/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.util;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.Optional;
import org.jabref.logic.util.UpdateFieldPreferences;
import org.jabref.model.FieldChange;
import org.jabref.model.entry.BibEntry;

public class UpdateField {
    private UpdateField() {
    }

    public static Optional<FieldChange> updateField(BibEntry be, String field2, String newValue) {
        return UpdateField.updateField(be, field2, newValue, false);
    }

    public static Optional<FieldChange> updateNonDisplayableField(BibEntry be, String field2, String newValue) {
        boolean changed = be.hasChanged();
        Optional<FieldChange> fieldChange = UpdateField.updateField(be, field2, newValue, false);
        be.setChanged(changed);
        return fieldChange;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Optional<FieldChange> updateField(BibEntry be, String field2, String newValue, Boolean nullFieldIfValueIsTheSame) {
        String writtenValue = null;
        String oldValue = null;
        if (be.hasField(field2)) {
            oldValue = be.getField(field2).get();
            if (newValue == null || oldValue.equals(newValue) && nullFieldIfValueIsTheSame.booleanValue()) {
                be.clearField(field2);
                return Optional.of(new FieldChange(be, field2, oldValue, writtenValue));
            } else {
                if (oldValue.equals(newValue)) return Optional.empty();
                writtenValue = newValue;
                be.setField(field2, newValue);
            }
            return Optional.of(new FieldChange(be, field2, oldValue, writtenValue));
        } else {
            if (newValue == null) {
                return Optional.empty();
            }
            writtenValue = newValue;
            be.setField(field2, newValue);
        }
        return Optional.of(new FieldChange(be, field2, oldValue, writtenValue));
    }

    public static void setAutomaticFields(BibEntry entry, boolean overwriteOwner, boolean overwriteTimestamp, UpdateFieldPreferences prefs) {
        String defaultOwner = prefs.getDefaultOwner();
        String timestamp = DateTimeFormatter.ofPattern(prefs.getTimeStampFormat()).format(LocalDateTime.now());
        String timeStampField = prefs.getTimeStampField();
        boolean setOwner = prefs.isUseOwner() && (overwriteOwner || !entry.hasField("owner"));
        boolean setTimeStamp = prefs.isUseTimeStamp() && (overwriteTimestamp || !entry.hasField(timeStampField));
        UpdateField.setAutomaticFields(entry, setOwner, defaultOwner, setTimeStamp, timeStampField, timestamp);
    }

    public static void setAutomaticFields(BibEntry entry, UpdateFieldPreferences prefs) {
        UpdateField.setAutomaticFields(entry, prefs.isOverwriteOwner(), prefs.isOverwriteTimeStamp(), prefs);
    }

    private static void setAutomaticFields(BibEntry entry, boolean setOwner, String owner, boolean setTimeStamp, String timeStampField, String timeStamp) {
        if (setOwner) {
            entry.setField("owner", owner);
        }
        if (setTimeStamp) {
            entry.setField(timeStampField, timeStamp);
        }
    }

    public static void setAutomaticFields(Collection<BibEntry> bibs, boolean overwriteOwner, boolean overwriteTimestamp, UpdateFieldPreferences prefs) {
        boolean globalSetOwner = prefs.isUseOwner();
        boolean globalSetTimeStamp = prefs.isUseTimeStamp();
        if (!globalSetOwner && !globalSetTimeStamp) {
            return;
        }
        String timeStampField = prefs.getTimeStampField();
        String defaultOwner = prefs.getDefaultOwner();
        String timestamp = DateTimeFormatter.ofPattern(prefs.getTimeStampFormat()).format(LocalDateTime.now());
        for (BibEntry curEntry : bibs) {
            boolean setOwner = globalSetOwner && (overwriteOwner || !curEntry.hasField("owner"));
            boolean setTimeStamp = globalSetTimeStamp && (overwriteTimestamp || !curEntry.hasField(timeStampField));
            UpdateField.setAutomaticFields(curEntry, setOwner, defaultOwner, setTimeStamp, timeStampField, timestamp);
        }
    }

    public static void setAutomaticFields(Collection<BibEntry> bibs, UpdateFieldPreferences prefs) {
        UpdateField.setAutomaticFields(bibs, prefs.isOverwriteOwner(), prefs.isOverwriteTimeStamp(), prefs);
    }
}

