/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.search;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.search.SearchMatcher;
import org.jabref.model.search.rules.ContainBasedSearchRule;
import org.jabref.model.search.rules.GrammarBasedSearchRule;
import org.jabref.model.search.rules.SearchRule;
import org.jabref.model.search.rules.SearchRules;
import org.jabref.model.search.rules.SentenceAnalyzer;

public class SearchQuery
implements SearchMatcher {
    private final String query;
    private final boolean caseSensitive;
    private final boolean regularExpression;
    private final SearchRule rule;

    public SearchQuery(String query, boolean caseSensitive, boolean regularExpression) {
        this.query = Objects.requireNonNull(query);
        this.caseSensitive = caseSensitive;
        this.regularExpression = regularExpression;
        this.rule = SearchRules.getSearchRuleByQuery(query, caseSensitive, regularExpression);
    }

    public String toString() {
        return String.format("\"%s\" (%s, %s)", this.getQuery(), this.getCaseSensitiveDescription(), this.getRegularExpressionDescription());
    }

    @Override
    public boolean isMatch(BibEntry entry) {
        return this.rule.applyRule(this.getQuery(), entry);
    }

    public boolean isValid() {
        return this.rule.validateSearchStrings(this.getQuery());
    }

    public boolean isContainsBasedSearch() {
        return this.rule instanceof ContainBasedSearchRule;
    }

    private String getCaseSensitiveDescription() {
        if (this.isCaseSensitive()) {
            return "case sensitive";
        }
        return "case insensitive";
    }

    private String getRegularExpressionDescription() {
        if (this.isRegularExpression()) {
            return "regular expression";
        }
        return "plain text";
    }

    public String localize() {
        return String.format("\"%s\" (%s, %s)", this.getQuery(), this.getLocalizedCaseSensitiveDescription(), this.getLocalizedRegularExpressionDescription());
    }

    private String getLocalizedCaseSensitiveDescription() {
        if (this.isCaseSensitive()) {
            return Localization.lang("case sensitive", new String[0]);
        }
        return Localization.lang("case insensitive", new String[0]);
    }

    private String getLocalizedRegularExpressionDescription() {
        if (this.isRegularExpression()) {
            return Localization.lang("regular expression", new String[0]);
        }
        return Localization.lang("plain text", new String[0]);
    }

    public boolean isGrammarBasedSearch() {
        return this.rule instanceof GrammarBasedSearchRule;
    }

    public String getQuery() {
        return this.query;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public boolean isRegularExpression() {
        return this.regularExpression;
    }

    public List<String> getSearchWords() {
        if (this.isRegularExpression()) {
            return Collections.singletonList(this.getQuery());
        }
        return new SentenceAnalyzer(this.getQuery()).getWords();
    }

    public SearchRule getRule() {
        return this.rule;
    }
}

