/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.msbib;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jabref.logic.msbib.MsBibAuthor;
import org.jabref.logic.msbib.PageNumbers;
import org.jabref.model.entry.Author;
import org.jabref.model.entry.AuthorList;
import org.jabref.model.entry.Date;
import org.jabref.model.strings.StringUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class MSBibEntry {
    public Map<String, String> fields = new HashMap<String, String>();
    public List<MsBibAuthor> authors;
    public List<MsBibAuthor> bookAuthors;
    public List<MsBibAuthor> editors;
    public List<MsBibAuthor> translators;
    public List<MsBibAuthor> producerNames;
    public List<MsBibAuthor> composers;
    public List<MsBibAuthor> conductors;
    public List<MsBibAuthor> performers;
    public List<MsBibAuthor> writers;
    public List<MsBibAuthor> directors;
    public List<MsBibAuthor> compilers;
    public List<MsBibAuthor> interviewers;
    public List<MsBibAuthor> interviewees;
    public List<MsBibAuthor> inventors;
    public List<MsBibAuthor> counsels;
    public PageNumbers pages;
    public String standardNumber;
    public String address;
    public String conferenceName;
    public String thesisType;
    public String internetSiteTitle;
    public String dateAccessed;
    public String publicationTitle;
    public String albumTitle;
    public String broadcastTitle;
    public String year;
    public String month;
    public String day;
    public String number;
    public String patentNumber;
    public String journalName;
    private String bibtexEntryType;
    private final Pattern ADDRESS_PATTERN = Pattern.compile("\\b(\\w+)\\s?[,]?\\s?(\\w*)\\s?[,]?\\s?(\\w*)\\b");

    public MSBibEntry() {
    }

    public MSBibEntry(Element entry) {
        this.populateFromXml(entry);
    }

    public String getType() {
        return this.fields.get("SourceType");
    }

    public String getCiteKey() {
        return this.fields.get("Tag");
    }

    private String getXmlElementTextContent(String name, Element entry) {
        String value = null;
        NodeList nodeLst = entry.getElementsByTagNameNS("*", name);
        if (nodeLst.getLength() > 0) {
            value = nodeLst.item(0).getTextContent();
        }
        return value;
    }

    private void populateFromXml(Element entry) {
        for (int i = 0; i < entry.getChildNodes().getLength(); ++i) {
            Node node = entry.getChildNodes().item(i);
            if (node.getNodeType() != 1) continue;
            String key = node.getLocalName();
            String value = node.getTextContent();
            if ("SourceType".equals(key)) {
                this.bibtexEntryType = value;
            }
            this.fields.put(key, value);
        }
        String temp = this.getXmlElementTextContent("Pages", entry);
        if (temp != null) {
            this.pages = new PageNumbers(temp);
        }
        this.standardNumber = this.getXmlElementTextContent("StandardNumber", entry);
        this.conferenceName = this.getXmlElementTextContent("ConferenceName", entry);
        String city = this.getXmlElementTextContent("City", entry);
        String state = this.getXmlElementTextContent("StateProvince", entry);
        String country = this.getXmlElementTextContent("CountryRegion", entry);
        StringBuilder addressBuffer = new StringBuilder();
        if (city != null) {
            addressBuffer.append(city);
        }
        if (state != null && !state.isEmpty() && city != null && !city.isEmpty()) {
            addressBuffer.append(",").append(' ');
            addressBuffer.append(state);
        }
        if (country != null && !country.isEmpty()) {
            addressBuffer.append(",").append(' ');
            addressBuffer.append(country);
        }
        this.address = addressBuffer.toString().trim();
        if (this.address.isEmpty() || ",".equals(this.address)) {
            this.address = null;
        }
        if ("Patent".equalsIgnoreCase(this.bibtexEntryType)) {
            this.number = this.getXmlElementTextContent("PatentNumber", entry);
        }
        this.journalName = this.getXmlElementTextContent("JournalName", entry);
        this.month = this.getXmlElementTextContent("Month", entry);
        this.internetSiteTitle = this.getXmlElementTextContent("InternetSiteTitle", entry);
        String monthAccessed = this.getXmlElementTextContent("MonthAccessed", entry);
        String dayAccessed = this.getXmlElementTextContent("DayAccessed", entry);
        String yearAccessed = this.getXmlElementTextContent("YearAccessed", entry);
        Optional<Date> parsedDateAcessed = Date.parse(Optional.ofNullable(yearAccessed), Optional.ofNullable(monthAccessed), Optional.ofNullable(dayAccessed));
        parsedDateAcessed.map(Date::getNormalized).ifPresent(date -> {
            this.dateAccessed = date;
        });
        NodeList nodeLst = entry.getElementsByTagNameNS("*", "Author");
        if (nodeLst.getLength() > 0) {
            this.getAuthors((Element)nodeLst.item(0));
        }
    }

    private void getAuthors(Element authorsElem) {
        this.authors = this.getSpecificAuthors("Author", authorsElem);
        this.bookAuthors = this.getSpecificAuthors("BookAuthor", authorsElem);
        this.editors = this.getSpecificAuthors("Editor", authorsElem);
        this.translators = this.getSpecificAuthors("Translator", authorsElem);
        this.producerNames = this.getSpecificAuthors("ProducerName", authorsElem);
        this.composers = this.getSpecificAuthors("Composer", authorsElem);
        this.conductors = this.getSpecificAuthors("Conductor", authorsElem);
        this.performers = this.getSpecificAuthors("Performer", authorsElem);
        this.writers = this.getSpecificAuthors("Writer", authorsElem);
        this.directors = this.getSpecificAuthors("Director", authorsElem);
        this.compilers = this.getSpecificAuthors("Compiler", authorsElem);
        this.interviewers = this.getSpecificAuthors("Interviewer", authorsElem);
        this.interviewees = this.getSpecificAuthors("Interviewee", authorsElem);
        this.inventors = this.getSpecificAuthors("Inventor", authorsElem);
        this.counsels = this.getSpecificAuthors("Counsel", authorsElem);
    }

    private List<MsBibAuthor> getSpecificAuthors(String type, Element authors) {
        LinkedList<MsBibAuthor> result = null;
        NodeList nodeLst = authors.getElementsByTagNameNS("*", type);
        if (nodeLst.getLength() <= 0) {
            return result;
        }
        if ((nodeLst = ((Element)nodeLst.item(0)).getElementsByTagNameNS("*", "NameList")).getLength() <= 0) {
            return result;
        }
        NodeList person = ((Element)nodeLst.item(0)).getElementsByTagNameNS("*", "Person");
        if (person.getLength() <= 0) {
            return result;
        }
        result = new LinkedList<MsBibAuthor>();
        for (int i = 0; i < person.getLength(); ++i) {
            NodeList firstName = ((Element)person.item(i)).getElementsByTagNameNS("*", "First");
            NodeList lastName = ((Element)person.item(i)).getElementsByTagNameNS("*", "Last");
            NodeList middleName = ((Element)person.item(i)).getElementsByTagNameNS("*", "Middle");
            StringBuilder sb = new StringBuilder();
            if (firstName.getLength() > 0) {
                sb.append(firstName.item(0).getTextContent());
                sb.append(" ");
            }
            if (middleName.getLength() > 0) {
                sb.append(middleName.item(0).getTextContent());
                sb.append(" ");
            }
            if (lastName.getLength() > 0) {
                sb.append(lastName.item(0).getTextContent());
            }
            AuthorList authorList = AuthorList.parse(sb.toString());
            for (Author author : authorList.getAuthors()) {
                result.add(new MsBibAuthor(author));
            }
        }
        return result;
    }

    public Element getEntryDom(Document document) {
        Element rootNode = document.createElementNS("http://schemas.openxmlformats.org/officeDocument/2006/bibliography", "b:Source");
        for (Map.Entry<String, String> entry : this.fields.entrySet()) {
            this.addField(document, rootNode, entry.getKey(), entry.getValue());
        }
        Optional.ofNullable(this.dateAccessed).ifPresent(field2 -> this.addDateAcessedFields(document, rootNode));
        Element allAuthors = document.createElementNS("http://schemas.openxmlformats.org/officeDocument/2006/bibliography", "b:Author");
        this.addAuthor(document, allAuthors, "Author", this.authors);
        this.addAuthor(document, allAuthors, "BookAuthor", this.bookAuthors);
        this.addAuthor(document, allAuthors, "Editor", this.editors);
        this.addAuthor(document, allAuthors, "Translator", this.translators);
        this.addAuthor(document, allAuthors, "ProducerName", this.producerNames);
        this.addAuthor(document, allAuthors, "Composer", this.composers);
        this.addAuthor(document, allAuthors, "Conductor", this.conductors);
        this.addAuthor(document, allAuthors, "Performer", this.performers);
        this.addAuthor(document, allAuthors, "Writer", this.writers);
        this.addAuthor(document, allAuthors, "Director", this.directors);
        this.addAuthor(document, allAuthors, "Compiler", this.compilers);
        this.addAuthor(document, allAuthors, "Interviewer", this.interviewers);
        this.addAuthor(document, allAuthors, "Interviewee", this.interviewees);
        this.addAuthor(document, allAuthors, "Inventor", this.inventors);
        this.addAuthor(document, allAuthors, "Counsel", this.counsels);
        rootNode.appendChild(allAuthors);
        if (this.pages != null) {
            this.addField(document, rootNode, "Pages", this.pages.toString("-"));
        }
        this.addField(document, rootNode, "Year", this.year);
        this.addField(document, rootNode, "Month", this.month);
        this.addField(document, rootNode, "Day", this.day);
        this.addField(document, rootNode, "JournalName", this.journalName);
        this.addField(document, rootNode, "PatentNumber", this.patentNumber);
        this.addField(document, rootNode, "Number", this.number);
        this.addField(document, rootNode, "StandardNumber", this.standardNumber);
        this.addField(document, rootNode, "ConferenceName", this.conferenceName);
        this.addAddress(document, rootNode, this.address);
        this.addField(document, rootNode, "ThesisType", this.thesisType);
        this.addField(document, rootNode, "InternetSiteTitle", this.internetSiteTitle);
        this.addField(document, rootNode, "PublicationTitle", this.publicationTitle);
        this.addField(document, rootNode, "AlbumTitle", this.albumTitle);
        this.addField(document, rootNode, "BroadcastTitle", this.broadcastTitle);
        return rootNode;
    }

    private void addField(Document document, Element parent, String name, String value) {
        if (value == null) {
            return;
        }
        Element elem = document.createElementNS("http://schemas.openxmlformats.org/officeDocument/2006/bibliography", "b:" + name);
        elem.appendChild(document.createTextNode(StringUtil.stripNonValidXMLCharacters(value)));
        parent.appendChild(elem);
    }

    private void addAuthor(Document document, Element allAuthors, String entryName, List<MsBibAuthor> authorsLst) {
        if (authorsLst == null) {
            return;
        }
        Element authorTop = document.createElementNS("http://schemas.openxmlformats.org/officeDocument/2006/bibliography", "b:" + entryName);
        Optional<MsBibAuthor> personName = authorsLst.stream().filter(MsBibAuthor::isCorporate).findFirst();
        if (personName.isPresent()) {
            MsBibAuthor person = personName.get();
            Element corporate = document.createElementNS("http://schemas.openxmlformats.org/officeDocument/2006/bibliography", "b:Corporate");
            corporate.setTextContent(person.getFirstLast());
            authorTop.appendChild(corporate);
        } else {
            Element nameList = document.createElementNS("http://schemas.openxmlformats.org/officeDocument/2006/bibliography", "b:NameList");
            for (MsBibAuthor name : authorsLst) {
                Element person = document.createElementNS("http://schemas.openxmlformats.org/officeDocument/2006/bibliography", "b:Person");
                this.addField(document, person, "Last", name.getLastName());
                this.addField(document, person, "Middle", name.getMiddleName());
                this.addField(document, person, "First", name.getFirstName());
                nameList.appendChild(person);
            }
            authorTop.appendChild(nameList);
        }
        allAuthors.appendChild(authorTop);
    }

    private void addDateAcessedFields(Document document, Element rootNode) {
        Optional<Date> parsedDateAcesseField = Date.parse(this.dateAccessed);
        parsedDateAcesseField.flatMap(Date::getYear).map(accYear -> accYear.toString()).ifPresent(yearAccessed -> this.addField(document, rootNode, "YearAccessed", (String)yearAccessed));
        parsedDateAcesseField.flatMap(Date::getMonth).map(accMonth -> accMonth.getTwoDigitNumber()).ifPresent(monthAcessed -> this.addField(document, rootNode, "MonthAccessed", (String)monthAcessed));
        parsedDateAcesseField.flatMap(Date::getDay).map(accDay -> accDay.toString()).ifPresent(dayAccessed -> this.addField(document, rootNode, "DayAccessed", (String)dayAccessed));
    }

    private void addAddress(Document document, Element parent, String addressToSplit) {
        if (addressToSplit == null) {
            return;
        }
        Matcher matcher = this.ADDRESS_PATTERN.matcher(addressToSplit);
        if (addressToSplit.contains(",") && matcher.matches() && matcher.groupCount() >= 3) {
            this.addField(document, parent, "City", matcher.group(1));
            this.addField(document, parent, "StateProvince", matcher.group(2));
            this.addField(document, parent, "CountryRegion", matcher.group(3));
        } else {
            this.addField(document, parent, "City", addressToSplit);
        }
    }
}

