/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.formatter.bibtexfields;

import java.util.Optional;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.cleanup.Formatter;
import org.jabref.model.entry.Date;

public class NormalizeDateFormatter
extends Formatter {
    @Override
    public String getName() {
        return Localization.lang("Normalize date", new String[0]);
    }

    @Override
    public String getKey() {
        return "normalize_date";
    }

    @Override
    public String format(String value) {
        Optional<Date> parsedDate = Date.parse(value);
        return parsedDate.map(Date::getNormalized).orElse(value);
    }

    @Override
    public String getDescription() {
        return Localization.lang("Normalizes the date to ISO date format.", new String[0]);
    }

    @Override
    public String getExampleInput() {
        return "29.11.2003";
    }
}

