/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.cleanup;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jabref.model.FieldChange;
import org.jabref.model.cleanup.CleanupJob;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.EntryConverter;
import org.jabref.model.strings.StringUtil;

public class ConvertToBibtexCleanup
implements CleanupJob {
    @Override
    public List<FieldChange> cleanup(BibEntry entry) {
        ArrayList<FieldChange> changes = new ArrayList<FieldChange>();
        entry.getPublicationDate().ifPresent(date -> {
            if (StringUtil.isBlank(entry.getField("year"))) {
                date.getYear().flatMap(year -> entry.setField("year", year.toString())).ifPresent(changes::add);
            }
            if (StringUtil.isBlank(entry.getField("month"))) {
                date.getMonth().flatMap(month -> entry.setField("month", month.getJabRefFormat())).ifPresent(changes::add);
            }
            if (changes.size() > 0) {
                entry.clearField("date").ifPresent(changes::add);
            }
        });
        for (Map.Entry<String, String> alias : EntryConverter.FIELD_ALIASES_TEX_TO_LTX.entrySet()) {
            String oldFieldName = alias.getValue();
            String newFieldName = alias.getKey();
            entry.getField(oldFieldName).ifPresent(oldValue -> {
                if (!oldValue.isEmpty() && !entry.getField(newFieldName).isPresent()) {
                    entry.setField(newFieldName, (String)oldValue).ifPresent(changes::add);
                    entry.clearField(oldFieldName).ifPresent(changes::add);
                }
            });
        }
        return changes;
    }
}

