/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.search;

import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import javax.swing.SwingWorker;
import org.jabref.JabRefGUI;
import org.jabref.gui.BasePanel;
import org.jabref.gui.BasePanelMode;
import org.jabref.gui.maintable.MainTableDataModel;
import org.jabref.gui.search.GlobalSearchBar;
import org.jabref.gui.search.SearchDisplayMode;
import org.jabref.gui.search.rules.describer.SearchDescribers;
import org.jabref.logic.search.SearchQuery;
import org.jabref.model.database.BibDatabase;
import org.jabref.model.entry.BibEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SearchWorker
extends SwingWorker<List<BibEntry>, Void> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SearchWorker.class);
    private final BasePanel basePanel;
    private final BibDatabase database;
    private final SearchQuery searchQuery;
    private final SearchDisplayMode searchDisplayMode;

    public SearchWorker(BasePanel basePanel, SearchQuery searchQuery, SearchDisplayMode searchDisplayMode) {
        this.basePanel = Objects.requireNonNull(basePanel);
        this.database = Objects.requireNonNull(basePanel.getDatabase());
        this.searchQuery = Objects.requireNonNull(searchQuery);
        this.searchDisplayMode = Objects.requireNonNull(searchDisplayMode);
        LOGGER.debug("Search (" + this.searchDisplayMode.getDisplayName() + "): " + this.searchQuery);
    }

    @Override
    protected List<BibEntry> doInBackground() throws Exception {
        return this.database.getEntries().parallelStream().filter(this.searchQuery::isMatch).collect(Collectors.toList());
    }

    @Override
    protected void done() {
        if (this.isCancelled()) {
            return;
        }
        try {
            this.updateUIWithSearchResult((List)this.get());
        }
        catch (InterruptedException | ExecutionException e) {
            LOGGER.error("something went wrong during the search", e);
        }
    }

    private void updateUIWithSearchResult(List<BibEntry> matchedEntries) {
        List<BibEntry> selectedEntries;
        boolean isHitSelected;
        GlobalSearchBar globalSearchBar = JabRefGUI.getMainFrame().getGlobalSearchBar();
        if (!globalSearchBar.isStillValidQuery(this.searchQuery)) {
            return;
        }
        for (BibEntry entry : this.basePanel.getDatabase().getEntries()) {
            entry.setSearchHit(false);
        }
        for (BibEntry entry : matchedEntries) {
            entry.setSearchHit(true);
        }
        this.basePanel.getMainTable().getTableModel().updateSearchState(MainTableDataModel.DisplayOption.DISABLED);
        switch (this.searchDisplayMode) {
            case FLOAT: {
                this.basePanel.getMainTable().getTableModel().updateSearchState(MainTableDataModel.DisplayOption.FLOAT);
                break;
            }
            case FILTER: {
                this.basePanel.getMainTable().getTableModel().updateSearchState(MainTableDataModel.DisplayOption.FILTER);
                break;
            }
            default: {
                LOGGER.error("Following searchDisplayMode was not defined: " + (Object)((Object)this.searchDisplayMode));
            }
        }
        if (this.basePanel.getMode() != BasePanelMode.SHOWING_EDITOR && this.basePanel.getMode() != BasePanelMode.WILL_SHOW_EDITOR && !(isHitSelected = (selectedEntries = this.basePanel.getSelectedEntries()).stream().anyMatch(BibEntry::isSearchHit)) && !matchedEntries.isEmpty()) {
            for (int i = 0; i < this.basePanel.getMainTable().getRowCount(); ++i) {
                BibEntry entry = this.basePanel.getMainTable().getEntryAt(i);
                if (!entry.isSearchHit()) continue;
                this.basePanel.getMainTable().setSelected(i);
                break;
            }
        }
        globalSearchBar.updateResults(matchedEntries.size(), SearchDescribers.getSearchDescriberFor(this.searchQuery).getDescription(), this.searchQuery.isGrammarBasedSearch());
        globalSearchBar.getSearchQueryHighlightObservable().fireSearchlistenerEvent(this.searchQuery);
    }
}

