/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.fieldeditors;

import java.io.IOException;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import org.fxmisc.easybind.EasyBind;
import org.jabref.gui.DialogService;
import org.jabref.gui.autocompleter.AutoCompleteSuggestionProvider;
import org.jabref.gui.desktop.JabRefDesktop;
import org.jabref.gui.fieldeditors.AbstractEditorViewModel;
import org.jabref.logic.integrity.FieldCheckers;
import org.jabref.logic.l10n.Localization;
import org.jabref.logic.net.URLUtil;
import org.jabref.model.strings.StringUtil;

public class UrlEditorViewModel
extends AbstractEditorViewModel {
    private DialogService dialogService;
    private BooleanProperty validUrlIsNotPresent = new SimpleBooleanProperty(true);

    public UrlEditorViewModel(String fieldName, AutoCompleteSuggestionProvider<?> suggestionProvider, DialogService dialogService, FieldCheckers fieldCheckers) {
        super(fieldName, suggestionProvider, fieldCheckers);
        this.dialogService = dialogService;
        this.validUrlIsNotPresent.bind(EasyBind.map(this.text, input -> StringUtil.isBlank(input) || !URLUtil.isURL(input)));
    }

    public boolean isValidUrlIsNotPresent() {
        return this.validUrlIsNotPresent.get();
    }

    public BooleanProperty validUrlIsNotPresentProperty() {
        return this.validUrlIsNotPresent;
    }

    public void openExternalLink() {
        if (StringUtil.isBlank((String)this.text.get())) {
            return;
        }
        try {
            JabRefDesktop.openBrowser((String)this.text.get());
        }
        catch (IOException ex) {
            this.dialogService.notify(Localization.lang("Unable to open link.", new String[0]));
        }
    }
}

