/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.entryeditor;

import java.util.Collection;
import java.util.LinkedHashSet;
import javafx.scene.control.Tooltip;
import javax.swing.undo.UndoManager;
import org.jabref.gui.IconTheme;
import org.jabref.gui.autocompleter.SuggestionProviders;
import org.jabref.gui.entryeditor.FieldsEditorTab;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.EntryType;

public class RequiredFieldsTab
extends FieldsEditorTab {
    public RequiredFieldsTab(BibDatabaseContext databaseContext, SuggestionProviders suggestionProviders, UndoManager undoManager) {
        super(false, databaseContext, suggestionProviders, undoManager);
        this.setText(Localization.lang("Required fields", new String[0]));
        this.setTooltip(new Tooltip(Localization.lang("Show required fields", new String[0])));
        this.setGraphic(IconTheme.JabRefIcon.REQUIRED.getGraphicNode());
    }

    @Override
    protected Collection<String> determineFieldsToShow(BibEntry entry, EntryType entryType) {
        LinkedHashSet<String> fields = new LinkedHashSet<String>();
        fields.addAll(entryType.getRequiredFieldsFlat());
        fields.add("bibtexkey");
        return fields;
    }
}

