/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.documentviewer;

public abstract class PageDimension {
    public static PageDimension ofFixedWidth(int width) {
        return new FixedWidthPageDimension(width);
    }

    public static PageDimension ofFixedHeight(int height) {
        return new FixedHeightPageDimension(height);
    }

    public static PageDimension ofFixedWidth(double width) {
        return PageDimension.ofFixedWidth((int)width);
    }

    public static PageDimension ofFixedHeight(double height) {
        return PageDimension.ofFixedHeight((int)height);
    }

    public abstract int getWidth(double var1);

    public abstract int getHeight(double var1);

    private static class FixedHeightPageDimension
    extends PageDimension {
        private final int height;

        public FixedHeightPageDimension(int height) {
            this.height = height;
        }

        @Override
        public int getWidth(double aspectRatio) {
            return (int)(aspectRatio * (double)this.height);
        }

        @Override
        public int getHeight(double aspectRatio) {
            return this.height;
        }
    }

    private static class FixedWidthPageDimension
    extends PageDimension {
        private final int width;

        public FixedWidthPageDimension(int width) {
            this.width = width;
        }

        @Override
        public int getWidth(double aspectRatio) {
            return this.width;
        }

        @Override
        public int getHeight(double aspectRatio) {
            return (int)((double)this.width / aspectRatio);
        }
    }
}

