/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.cleanup;

import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.nio.file.Path;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Optional;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.jabref.Globals;
import org.jabref.gui.cleanup.FieldFormatterCleanupsPanel;
import org.jabref.logic.cleanup.CleanupPreset;
import org.jabref.logic.cleanup.Cleanups;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.preferences.JabRefPreferences;

public class CleanupPresetPanel {
    private final BibDatabaseContext databaseContext;
    private JCheckBox cleanUpDOI;
    private JCheckBox cleanUpISSN;
    private JCheckBox cleanUpMovePDF;
    private JCheckBox cleanUpMakePathsRelative;
    private JCheckBox cleanUpRenamePDF;
    private JCheckBox cleanUpRenamePDFonlyRelativePaths;
    private JCheckBox cleanUpUpgradeExternalLinks;
    private JCheckBox cleanUpBiblatex;
    private JCheckBox cleanUpBibtex;
    private FieldFormatterCleanupsPanel cleanUpFormatters;
    private JPanel panel;
    private JScrollPane scrollPane;
    private CleanupPreset cleanupPreset;

    public CleanupPresetPanel(BibDatabaseContext databaseContext, CleanupPreset cleanupPreset) {
        this.cleanupPreset = Objects.requireNonNull(cleanupPreset);
        this.databaseContext = Objects.requireNonNull(databaseContext);
        this.init();
    }

    private void init() {
        this.cleanUpDOI = new JCheckBox(Localization.lang("Move DOIs from note and URL field to DOI field and remove http prefix", new String[0]));
        this.cleanUpISSN = new JCheckBox(Localization.lang("Reformat ISSN", new String[0]));
        Optional<Path> firstExistingDir = this.databaseContext.getFirstExistingFileDir(JabRefPreferences.getInstance().getFileDirectoryPreferences());
        if (firstExistingDir.isPresent()) {
            this.cleanUpMovePDF = new JCheckBox(Localization.lang("Move linked files to default file directory %0", firstExistingDir.get().toString()));
        } else {
            this.cleanUpMovePDF = new JCheckBox(Localization.lang("Move linked files to default file directory %0", "..."));
            this.cleanUpMovePDF.setEnabled(false);
            this.cleanUpMovePDF.setSelected(false);
        }
        this.cleanUpMakePathsRelative = new JCheckBox(Localization.lang("Make paths of linked files relative (if possible)", new String[0]));
        this.cleanUpRenamePDF = new JCheckBox(Localization.lang("Rename PDFs to given filename format pattern", new String[0]));
        this.cleanUpRenamePDF.addChangeListener(event -> this.cleanUpRenamePDFonlyRelativePaths.setEnabled(this.cleanUpRenamePDF.isSelected()));
        this.cleanUpRenamePDFonlyRelativePaths = new JCheckBox(Localization.lang("Rename only PDFs having a relative path", new String[0]));
        this.cleanUpUpgradeExternalLinks = new JCheckBox(Localization.lang("Upgrade external PDF/PS links to use the '%0' field.", "file"));
        this.cleanUpBiblatex = new JCheckBox(Localization.lang("Convert to biblatex format (for example, move the value of the 'journal' field to 'journaltitle')", new String[0]));
        this.cleanUpBibtex = new JCheckBox(Localization.lang("Convert to BibTeX format (for example, move the value of the 'journaltitle' field to 'journal')", new String[0]));
        ButtonGroup biblatexConversion = new ButtonGroup();
        biblatexConversion.add(this.cleanUpBiblatex);
        biblatexConversion.add(this.cleanUpBibtex);
        this.cleanUpFormatters = new FieldFormatterCleanupsPanel(Localization.lang("Run field formatter:", new String[0]), Cleanups.DEFAULT_SAVE_ACTIONS);
        this.updateDisplay(this.cleanupPreset);
        FormLayout layout = new FormLayout("left:15dlu, fill:pref:grow", "pref, pref, pref, pref, pref, fill:pref:grow, pref,pref, pref, pref,190dlu, fill:pref:grow,");
        FormBuilder builder = FormBuilder.create().layout(layout);
        builder.add(this.cleanUpDOI).xyw(1, 1, 2);
        builder.add(this.cleanUpUpgradeExternalLinks).xyw(1, 2, 2);
        builder.add(this.cleanUpMovePDF).xyw(1, 3, 2);
        builder.add(this.cleanUpMakePathsRelative).xyw(1, 4, 2);
        builder.add(this.cleanUpRenamePDF).xyw(1, 5, 2);
        String currentPattern = Localization.lang("Filename format pattern", new String[0]).concat(": ");
        currentPattern = currentPattern.concat(Globals.prefs.get("importFileNamePattern"));
        builder.add(new JLabel(currentPattern)).xy(2, 6);
        builder.add(this.cleanUpRenamePDFonlyRelativePaths).xy(2, 7);
        builder.add(this.cleanUpBibtex).xyw(1, 8, 2);
        builder.add(this.cleanUpBiblatex).xyw(1, 9, 2);
        builder.add(this.cleanUpISSN).xyw(1, 10, 2);
        builder.add(this.cleanUpFormatters).xyw(1, 11, 2);
        this.panel = builder.build();
        this.scrollPane = new JScrollPane(this.panel);
        this.scrollPane.setVerticalScrollBarPolicy(20);
        this.scrollPane.setVisible(true);
        this.scrollPane.setBorder(null);
    }

    private void updateDisplay(CleanupPreset preset) {
        this.cleanUpDOI.setSelected(preset.isCleanUpDOI());
        if (this.cleanUpMovePDF.isEnabled()) {
            this.cleanUpMovePDF.setSelected(preset.isMovePDF());
        }
        this.cleanUpMakePathsRelative.setSelected(preset.isMakePathsRelative());
        this.cleanUpRenamePDF.setSelected(preset.isRenamePDF());
        this.cleanUpRenamePDFonlyRelativePaths.setSelected(preset.isRenamePdfOnlyRelativePaths());
        this.cleanUpRenamePDFonlyRelativePaths.setEnabled(this.cleanUpRenamePDF.isSelected());
        this.cleanUpUpgradeExternalLinks.setSelected(preset.isCleanUpUpgradeExternalLinks());
        this.cleanUpBiblatex.setSelected(preset.isConvertToBiblatex());
        this.cleanUpBibtex.setSelected(preset.isConvertToBibtex());
        this.cleanUpISSN.setSelected(preset.isCleanUpISSN());
        this.cleanUpFormatters.setValues(preset.getFormatterCleanups());
    }

    public JScrollPane getScrollPane() {
        return this.scrollPane;
    }

    public CleanupPreset getCleanupPreset() {
        EnumSet<CleanupPreset.CleanupStep> activeJobs = EnumSet.noneOf(CleanupPreset.CleanupStep.class);
        if (this.cleanUpMovePDF.isSelected()) {
            activeJobs.add(CleanupPreset.CleanupStep.MOVE_PDF);
        }
        if (this.cleanUpDOI.isSelected()) {
            activeJobs.add(CleanupPreset.CleanupStep.CLEAN_UP_DOI);
        }
        if (this.cleanUpISSN.isSelected()) {
            activeJobs.add(CleanupPreset.CleanupStep.CLEAN_UP_ISSN);
        }
        if (this.cleanUpMakePathsRelative.isSelected()) {
            activeJobs.add(CleanupPreset.CleanupStep.MAKE_PATHS_RELATIVE);
        }
        if (this.cleanUpRenamePDF.isSelected()) {
            if (this.cleanUpRenamePDFonlyRelativePaths.isSelected()) {
                activeJobs.add(CleanupPreset.CleanupStep.RENAME_PDF_ONLY_RELATIVE_PATHS);
            } else {
                activeJobs.add(CleanupPreset.CleanupStep.RENAME_PDF);
            }
        }
        if (this.cleanUpUpgradeExternalLinks.isSelected()) {
            activeJobs.add(CleanupPreset.CleanupStep.CLEAN_UP_UPGRADE_EXTERNAL_LINKS);
        }
        if (this.cleanUpBiblatex.isSelected()) {
            activeJobs.add(CleanupPreset.CleanupStep.CONVERT_TO_BIBLATEX);
        }
        if (this.cleanUpBibtex.isSelected()) {
            activeJobs.add(CleanupPreset.CleanupStep.CONVERT_TO_BIBTEX);
        }
        activeJobs.add(CleanupPreset.CleanupStep.FIX_FILE_LINKS);
        this.cleanupPreset = new CleanupPreset(activeJobs, this.cleanUpFormatters.getFormatterCleanups());
        return this.cleanupPreset;
    }
}

