/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.cleanup;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.jabref.model.cleanup.FieldFormatterCleanup;
import org.jabref.model.cleanup.FieldFormatterCleanups;

public class CleanupActionsListModel
implements ListModel<FieldFormatterCleanup> {
    private List<FieldFormatterCleanup> cleanupActions;
    private final List<ListDataListener> listeners = new ArrayList<ListDataListener>();

    public CleanupActionsListModel(List<FieldFormatterCleanup> cleanupAction) {
        Objects.requireNonNull(cleanupAction);
        this.cleanupActions = cleanupAction;
    }

    public void addCleanupAction(FieldFormatterCleanup action) {
        if (!this.cleanupActions.contains(action)) {
            this.cleanupActions.add(action);
            for (ListDataListener listener : this.listeners) {
                listener.intervalAdded(new ListDataEvent(action, 1, this.cleanupActions.size(), this.cleanupActions.size()));
            }
        }
    }

    public void removeAtIndex(int index) {
        if (index >= 0 && index < this.cleanupActions.size()) {
            FieldFormatterCleanup action = this.cleanupActions.remove(index);
            for (ListDataListener listener : this.listeners) {
                listener.intervalRemoved(new ListDataEvent(action, 2, index, index));
            }
        }
    }

    public List<FieldFormatterCleanup> getAllActions() {
        return this.cleanupActions;
    }

    @Override
    public int getSize() {
        return this.cleanupActions.size();
    }

    @Override
    public FieldFormatterCleanup getElementAt(int index) {
        return this.cleanupActions.get(index);
    }

    @Override
    public void addListDataListener(ListDataListener l) {
        this.listeners.add(l);
    }

    @Override
    public void removeListDataListener(ListDataListener l) {
        this.listeners.remove(l);
    }

    public void reset(FieldFormatterCleanups defaultFormatters) {
        this.cleanupActions = new ArrayList<FieldFormatterCleanup>(defaultFormatters.getConfiguredActions());
        for (ListDataListener listener : this.listeners) {
            listener.contentsChanged(new ListDataEvent(this, 0, 0, this.cleanupActions.size()));
        }
    }
}

