/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import org.apache.batik.bridge.Bridge;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeException;
import org.apache.batik.bridge.CSSUtilities;
import org.apache.batik.bridge.DocumentBridge;
import org.apache.batik.bridge.GenericBridge;
import org.apache.batik.bridge.GraphicsNodeBridge;
import org.apache.batik.bridge.InterruptedBridgeException;
import org.apache.batik.gvt.CompositeGraphicsNode;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.RootGraphicsNode;
import org.apache.batik.util.HaltingThread;
import org.apache.batik.util.SVGConstants;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class GVTBuilder
implements SVGConstants {
    public GraphicsNode build(BridgeContext bridgeContext, Document document) {
        bridgeContext.setDocument(document);
        bridgeContext.initializeDocument(document);
        bridgeContext.setGVTBuilder(this);
        DocumentBridge documentBridge = bridgeContext.getDocumentBridge();
        RootGraphicsNode rootGraphicsNode = null;
        try {
            rootGraphicsNode = documentBridge.createGraphicsNode(bridgeContext, document);
            Element element = document.getDocumentElement();
            GraphicsNode graphicsNode = null;
            Bridge bridge2 = bridgeContext.getBridge(element);
            if (bridge2 == null || !(bridge2 instanceof GraphicsNodeBridge)) {
                return null;
            }
            GraphicsNodeBridge graphicsNodeBridge = (GraphicsNodeBridge)bridge2;
            graphicsNode = graphicsNodeBridge.createGraphicsNode(bridgeContext, element);
            if (graphicsNode == null) {
                return null;
            }
            rootGraphicsNode.getChildren().add(graphicsNode);
            this.buildComposite(bridgeContext, element, (CompositeGraphicsNode)graphicsNode);
            graphicsNodeBridge.buildGraphicsNode(bridgeContext, element, graphicsNode);
            documentBridge.buildGraphicsNode(bridgeContext, document, rootGraphicsNode);
        }
        catch (BridgeException bridgeException) {
            bridgeException.setGraphicsNode(rootGraphicsNode);
            throw bridgeException;
        }
        if (bridgeContext.isInteractive()) {
            bridgeContext.addUIEventListeners(document);
            bridgeContext.addGVTListener(document);
        }
        if (bridgeContext.isDynamic()) {
            bridgeContext.addDOMListeners();
        }
        return rootGraphicsNode;
    }

    public GraphicsNode build(BridgeContext bridgeContext, Element element) {
        Bridge bridge2 = bridgeContext.getBridge(element);
        if (bridge2 instanceof GenericBridge) {
            ((GenericBridge)bridge2).handleElement(bridgeContext, element);
            this.handleGenericBridges(bridgeContext, element);
            return null;
        }
        if (bridge2 == null || !(bridge2 instanceof GraphicsNodeBridge)) {
            this.handleGenericBridges(bridgeContext, element);
            return null;
        }
        GraphicsNodeBridge graphicsNodeBridge = (GraphicsNodeBridge)bridge2;
        if (!graphicsNodeBridge.getDisplay(element)) {
            this.handleGenericBridges(bridgeContext, element);
            return null;
        }
        GraphicsNode graphicsNode = graphicsNodeBridge.createGraphicsNode(bridgeContext, element);
        if (graphicsNode != null) {
            if (graphicsNodeBridge.isComposite()) {
                this.buildComposite(bridgeContext, element, (CompositeGraphicsNode)graphicsNode);
            } else {
                this.handleGenericBridges(bridgeContext, element);
            }
            graphicsNodeBridge.buildGraphicsNode(bridgeContext, element, graphicsNode);
        }
        if (bridgeContext.isDynamic()) {
            // empty if block
        }
        return graphicsNode;
    }

    protected void buildComposite(BridgeContext bridgeContext, Element element, CompositeGraphicsNode compositeGraphicsNode) {
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1) continue;
            this.buildGraphicsNode(bridgeContext, (Element)node, compositeGraphicsNode);
        }
    }

    protected void buildGraphicsNode(BridgeContext bridgeContext, Element element, CompositeGraphicsNode compositeGraphicsNode) {
        if (HaltingThread.hasBeenHalted()) {
            throw new InterruptedBridgeException();
        }
        Bridge bridge2 = bridgeContext.getBridge(element);
        if (bridge2 instanceof GenericBridge) {
            ((GenericBridge)bridge2).handleElement(bridgeContext, element);
            this.handleGenericBridges(bridgeContext, element);
            return;
        }
        if (bridge2 == null || !(bridge2 instanceof GraphicsNodeBridge)) {
            this.handleGenericBridges(bridgeContext, element);
            return;
        }
        if (!CSSUtilities.convertDisplay(element)) {
            this.handleGenericBridges(bridgeContext, element);
            return;
        }
        GraphicsNodeBridge graphicsNodeBridge = (GraphicsNodeBridge)bridge2;
        try {
            GraphicsNode graphicsNode = graphicsNodeBridge.createGraphicsNode(bridgeContext, element);
            if (graphicsNode != null) {
                compositeGraphicsNode.getChildren().add(graphicsNode);
                if (graphicsNodeBridge.isComposite()) {
                    this.buildComposite(bridgeContext, element, (CompositeGraphicsNode)graphicsNode);
                } else {
                    this.handleGenericBridges(bridgeContext, element);
                }
                graphicsNodeBridge.buildGraphicsNode(bridgeContext, element, graphicsNode);
            } else {
                this.handleGenericBridges(bridgeContext, element);
            }
        }
        catch (BridgeException bridgeException) {
            GraphicsNode graphicsNode = bridgeException.getGraphicsNode();
            if (graphicsNode != null) {
                compositeGraphicsNode.getChildren().add(graphicsNode);
                graphicsNodeBridge.buildGraphicsNode(bridgeContext, element, graphicsNode);
                bridgeException.setGraphicsNode(null);
            }
            throw bridgeException;
        }
    }

    protected void handleGenericBridges(BridgeContext bridgeContext, Element element) {
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!(node instanceof Element)) continue;
            Element element2 = (Element)node;
            Bridge bridge2 = bridgeContext.getBridge(element2);
            if (bridge2 instanceof GenericBridge) {
                ((GenericBridge)bridge2).handleElement(bridgeContext, element2);
            }
            this.handleGenericBridges(bridgeContext, element2);
        }
    }
}

