/*
 * Decompiled with CFR 0.152.
 */
package de.saxsys.mvvmfx.utils.validation;

import java.util.function.Predicate;
import java.util.regex.Pattern;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;

public class ObservableRules {
    public static <T> ObservableBooleanValue fromPredicate(ObservableValue<T> source, Predicate<T> predicate) {
        return Bindings.createBooleanBinding(() -> predicate.test(source.getValue()), (Observable[])new Observable[]{source});
    }

    public static ObservableBooleanValue notEmpty(ObservableValue<String> source) {
        return Bindings.createBooleanBinding(() -> {
            String s2 = (String)source.getValue();
            return s2 != null && !s2.trim().isEmpty();
        }, (Observable[])new Observable[]{source});
    }

    public static ObservableBooleanValue matches(ObservableValue<String> source, Pattern pattern) {
        return Bindings.createBooleanBinding(() -> {
            String s2 = (String)source.getValue();
            return s2 != null && pattern.matcher(s2).matches();
        }, (Observable[])new Observable[]{source});
    }
}

