/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.internal.util;

import com.microsoft.applicationinsights.core.dependencies.apachecommons.lang3.exception.ExceptionUtils;
import com.microsoft.applicationinsights.internal.logger.InternalLogger;
import com.microsoft.applicationinsights.internal.util.PropertyHelper;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Locale;
import java.util.Properties;

public class DeviceInfo {
    private static OperatingSystemMXBean osBean = ManagementFactory.getOperatingSystemMXBean();

    public static String getOperatingSystem() {
        return osBean.getName();
    }

    public static String getOperatingSystemVersion() {
        return osBean.getName();
    }

    public static String getOperatingVersionArchitecture() {
        return osBean.getArch();
    }

    public static String getHostName() {
        try {
            InetAddress ip = InetAddress.getLocalHost();
            return ip.getCanonicalHostName();
        }
        catch (UnknownHostException e) {
            InternalLogger.INSTANCE.error("Failed to get canonical host name, exception: %s", e.toString());
            InternalLogger.INSTANCE.trace("Stack trace generated is %s", ExceptionUtils.getStackTrace(e));
            return null;
        }
    }

    public static String getLocale() {
        String languageTagMethodName = "toLanguageTag";
        Locale defaultLocale = Locale.getDefault();
        try {
            return (String)Locale.class.getMethod("toLanguageTag", new Class[0]).invoke((Object)defaultLocale, new Object[0]);
        }
        catch (Exception e) {
            InternalLogger.INSTANCE.trace("Method '%s' could not be found in Locale class - moving to fallback path. Stack trace generated is %s", "toLanguageTag", ExceptionUtils.getStackTrace(e));
            String localeFileName = "locales.properties";
            Properties localesMap = null;
            try {
                localesMap = PropertyHelper.getProperties("locales.properties");
            }
            catch (Exception e2) {
                InternalLogger.INSTANCE.error("Could not find locale mapping file '%s'", "locales.properties");
                InternalLogger.INSTANCE.trace("Stack trace generated is %s", ExceptionUtils.getStackTrace(e2));
            }
            String localeString = defaultLocale.toString();
            String localeTag = localesMap != null ? localesMap.getProperty(localeString) : null;
            return localeTag != null ? localeTag : localeString;
        }
    }
}

