/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.system.procs;

import com.impossibl.postgres.api.data.InetAddr;
import com.impossibl.postgres.system.Context;
import com.impossibl.postgres.system.procs.BinaryDecoder;
import com.impossibl.postgres.system.procs.BinaryEncoder;
import com.impossibl.postgres.system.procs.SimpleProcProvider;
import com.impossibl.postgres.system.procs.TextDecoder;
import com.impossibl.postgres.system.procs.TextEncoder;
import com.impossibl.postgres.types.PrimitiveType;
import com.impossibl.postgres.types.Type;
import io.netty.buffer.ByteBuf;
import java.io.IOException;

abstract class Networks
extends SimpleProcProvider {
    private static final short PGSQL_AF_INET = 2;
    private static final short PGSQL_AF_INET6 = 3;

    public Networks(String pgtype, NetworkObjectFactory<? extends InetAddr> nof) {
        super((Type.Codec.Encoder)new TxtEncoder(nof), (Type.Codec.Decoder)new TxtDecoder(nof), (Type.Codec.Encoder)new BinEncoder(nof), (Type.Codec.Decoder)new BinDecoder(nof), pgtype);
    }

    static class TxtEncoder
    extends TextEncoder {
        private NetworkObjectFactory<? extends InetAddr> nof;

        public TxtEncoder(NetworkObjectFactory<? extends InetAddr> nof) {
            this.nof = nof;
        }

        @Override
        public Class<?> getInputType() {
            return this.nof.getObjectClass();
        }

        @Override
        public PrimitiveType getOutputPrimitiveType() {
            return PrimitiveType.Binary;
        }

        @Override
        public void encode(Type type, StringBuilder buffer, Object val, Context context) throws IOException {
            InetAddr inet = (InetAddr)val;
            buffer.append(inet.toString());
        }
    }

    static class TxtDecoder
    extends TextDecoder {
        private NetworkObjectFactory<? extends InetAddr> nof;

        public TxtDecoder(NetworkObjectFactory<? extends InetAddr> nof) {
            this.nof = nof;
        }

        @Override
        public PrimitiveType getInputPrimitiveType() {
            return PrimitiveType.Binary;
        }

        @Override
        public Class<?> getOutputType() {
            return this.nof.getObjectClass();
        }

        @Override
        public InetAddr decode(Type type, Short typeLength, Integer typeModifier, CharSequence buffer, Context context) throws IOException {
            try {
                return this.nof.newNetworkObject(buffer.toString());
            }
            catch (RuntimeException e) {
                throw new IOException("Invalid address format", e);
            }
        }
    }

    static class BinEncoder
    extends BinaryEncoder {
        private NetworkObjectFactory<? extends InetAddr> nof;

        public BinEncoder(NetworkObjectFactory<? extends InetAddr> nof) {
            this.nof = nof;
        }

        @Override
        public Class<?> getInputType() {
            return this.nof.getObjectClass();
        }

        @Override
        public PrimitiveType getOutputPrimitiveType() {
            return PrimitiveType.Binary;
        }

        @Override
        public void encode(Type type, ByteBuf buffer, Object val, Context context) throws IOException {
            if (val == null) {
                buffer.writeInt(-1);
            } else {
                InetAddr inet = (InetAddr)val;
                byte[] addr = inet.getAddress();
                boolean ipV4 = inet.getFamily() == InetAddr.Family.IPv4;
                buffer.writeInt(ipV4 ? 8 : 20);
                buffer.writeByte(ipV4 ? 2 : 3);
                buffer.writeByte(inet.getMaskBits());
                buffer.writeByte(type.getName().equals("cidr") ? 0 : 1);
                buffer.writeByte(addr.length);
                buffer.writeBytes(addr);
            }
        }
    }

    static class BinDecoder
    extends BinaryDecoder {
        private NetworkObjectFactory<? extends InetAddr> nof;

        public BinDecoder(NetworkObjectFactory<? extends InetAddr> nof) {
            this.nof = nof;
        }

        @Override
        public PrimitiveType getInputPrimitiveType() {
            return PrimitiveType.Binary;
        }

        @Override
        public Class<?> getOutputType() {
            return this.nof.getObjectClass();
        }

        @Override
        public InetAddr decode(Type type, Short typeLength, Integer typeModifier, ByteBuf buffer, Context context) throws IOException {
            int length = buffer.readInt();
            if (length == -1) {
                return null;
            }
            if (length != 8 && length != 20) {
                throw new IOException("Invalid length: " + length);
            }
            short family = buffer.readUnsignedByte();
            short mask = buffer.readUnsignedByte();
            buffer.readByte();
            short addrSize = buffer.readUnsignedByte();
            if (family == 2) {
                if (addrSize != 4) {
                    throw new IOException("Invalid inet4 size: " + addrSize);
                }
            } else if (family == 3) {
                if (addrSize != 16) {
                    throw new IOException("Invalid inet6 size: " + addrSize);
                }
            } else {
                throw new IOException("Invalid inet family: " + family);
            }
            byte[] addr = new byte[addrSize];
            buffer.readBytes(addr);
            try {
                return this.nof.newNetworkObject(addr, mask);
            }
            catch (IllegalArgumentException e) {
                throw new IOException("Invalid address format", e);
            }
        }
    }

    static interface NetworkObjectFactory<T extends InetAddr> {
        public T newNetworkObject(byte[] var1, short var2);

        public T newNetworkObject(String var1);

        public Class<? extends InetAddr> getObjectClass();
    }
}

