/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.protocol.v30;

import com.impossibl.postgres.protocol.CloseCommand;
import com.impossibl.postgres.protocol.Notice;
import com.impossibl.postgres.protocol.ServerObjectType;
import com.impossibl.postgres.protocol.TransactionStatus;
import com.impossibl.postgres.protocol.v30.BaseProtocolListener;
import com.impossibl.postgres.protocol.v30.CommandImpl;
import com.impossibl.postgres.protocol.v30.ProtocolImpl;
import com.impossibl.postgres.protocol.v30.ProtocolListener;
import io.netty.buffer.ByteBuf;
import java.io.IOException;

public class CloseCommandImpl
extends CommandImpl
implements CloseCommand {
    ServerObjectType objectType;
    String objectName;
    boolean complete;
    private ProtocolListener listener = new BaseProtocolListener(){

        @Override
        public boolean isComplete() {
            return CloseCommandImpl.this.complete || CloseCommandImpl.this.error != null || CloseCommandImpl.this.exception != null;
        }

        @Override
        public void closeComplete() {
            CloseCommandImpl.this.complete = true;
        }

        @Override
        public synchronized void error(Notice error) {
            CloseCommandImpl.this.error = error;
            this.notifyAll();
        }

        @Override
        public synchronized void exception(Throwable cause) {
            CloseCommandImpl.this.setException(cause);
            this.notifyAll();
        }

        @Override
        public void notice(Notice notice) {
            CloseCommandImpl.this.addNotice(notice);
        }

        @Override
        public synchronized void ready(TransactionStatus txStatus) {
            this.notifyAll();
        }
    };

    public CloseCommandImpl(ServerObjectType objectType, String objectName) {
        this.objectType = objectType;
        this.objectName = objectName;
    }

    @Override
    public ServerObjectType getObjectType() {
        return this.objectType;
    }

    @Override
    public String getObjectName() {
        return this.objectName;
    }

    @Override
    public void execute(ProtocolImpl protocol) throws IOException {
        protocol.setListener(this.listener);
        ByteBuf msg = protocol.channel.alloc().buffer();
        protocol.writeClose(msg, this.objectType, this.objectName);
        protocol.writeSync(msg);
        protocol.send(msg);
        this.waitFor(this.listener);
    }
}

