/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.jdbc.xa;

import com.impossibl.postgres.api.jdbc.PGConnection;
import com.impossibl.postgres.jdbc.PGPooledConnectionDelegator;
import com.impossibl.postgres.jdbc.PGSQLSimpleException;
import com.impossibl.postgres.jdbc.xa.PGXAConnection;
import java.sql.SQLException;
import java.sql.Savepoint;

public class PGXAConnectionDelegator
extends PGPooledConnectionDelegator {
    private PGXAConnection owner;

    public PGXAConnectionDelegator(PGXAConnection owner, PGConnection delegator) {
        super(owner, delegator);
        this.owner = owner;
    }

    @Override
    public void commit() throws SQLException {
        if (this.owner.getState() != 0) {
            PGSQLSimpleException se = new PGSQLSimpleException("commit not allowed", "55000");
            this.owner.fireConnectionError(se);
            throw se;
        }
        super.commit();
    }

    @Override
    public void rollback() throws SQLException {
        if (this.owner.getState() != 0) {
            PGSQLSimpleException se = new PGSQLSimpleException("rollback not allowed", "55000");
            this.owner.fireConnectionError(se);
            throw se;
        }
        super.rollback();
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        if (this.owner.getState() != 0) {
            PGSQLSimpleException se = new PGSQLSimpleException("rollback(Savepoint) not allowed", "55000");
            this.owner.fireConnectionError(se);
            throw se;
        }
        super.rollback(savepoint);
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        if (this.owner.getState() != 0 && autoCommit) {
            PGSQLSimpleException se = new PGSQLSimpleException("setAutoCommit(true) not allowed", "55000");
            this.owner.fireConnectionError(se);
            throw se;
        }
        super.setAutoCommit(autoCommit);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof PGXAConnectionDelegator)) {
            return false;
        }
        PGXAConnectionDelegator other = (PGXAConnectionDelegator)o;
        return this.owner.equals(other.owner);
    }
}

