/* sithwm - Minimalist Window Manager for X
 * see README for Copyright, license and other details. */

#include <X11/Xproto.h>
#include <stdlib.h>
#include <stdarg.h>
#include "sithwm.h"
#include <sys/wait.h>
#include <unistd.h>
#include <string.h>

void spawn(const char*command) {
   pid_t pid;
   if (!(pid = fork())) {
      setsid();
      if (!fork()) {
         char ebuf[110];
         snprintf(ebuf, sizeof ebuf-10, "DISPLAY=%s", DisplayString(dpy));
         char *colon = strrchr(ebuf, ':');
         if (colon) {
            char *dot = strchr(colon, '.');
            if (!dot)
               dot = colon + strlen(colon);
            snprintf(dot, 5, ".%d", current_screen-screens);
            putenv(ebuf);
         }
	 snprintf(global_buffer, sizeof global_buffer, "%s&", command);
	 system(global_buffer);
      }
      _exit(0);
   }
   if (pid > 0)
      wait(NULL);
}

int intersect(struct area *r1, struct area *r2)
{
   return ! ( ( (r1->pos.x+r1->w) <= r2->pos.x) ||
	      ( (r1->pos.y+r1->h) <= r2->pos.y) ||
	      ( (r2->pos.x+r2->w) <= r1->pos.x) ||
	      ( (r2->pos.y+r2->h) <= r1->pos.y) );
}

unsigned int hash_val(void*p, size_t len, unsigned int s)
{
   for (unsigned char*x=(unsigned char*)p;len-->0;x++)
      s = s*113+*x;
   return s;
}

#ifdef DO_EVENT_LOG
#include <sys/time.h>
#include <stdio.h>
#include <time.h>
void log_window_event(const char*cmd, Client *c)
{
   static unsigned int old_key;
   unsigned int key = c->dyn.window;
   key = hash_val(c->name, strlen(c->name), key);
   if (key != old_key) {
      old_key = key;
      snprintf(global_buffer, 110, "%s/.log", getenv("HOME"));
      FILE *f = fopen(global_buffer, "a");
      if (f) {
         struct timeval act_time;
         gettimeofday(&act_time, NULL);
         strftime(global_buffer, 110, "%y:%m:%d %H:%M:%S %a", localtime(&act_time.tv_sec));
         fprintf(f,"%s %x:%s:%s\n", global_buffer, (int)c->dyn.window, cmd, c->name);
         fclose(f);
      }
   }
}
#endif

int handle_xerror(Display *dsply, XErrorEvent *e)
{
   Client *c;
   (void)dsply;  /* unused */

   LOG_DEBUG("**ERK** handle_xerror() caught an XErrorEvent: resourceid:0x%lx error_code=%d request_code=%d minor_code=%d\n",
	     e->resourceid, e->error_code, e->request_code, e->minor_code);
   if (e->error_code == BadAccess && e->request_code == X_GrabKey &&
       screens->root == e->resourceid)
   {
      LOG_ERROR("root window unavailable (maybe another wm is running?)\n");
      exit(1);
   }

   c = find_client(e->resourceid);
   if (c) {
      LOG_DEBUG("\thandle_xerror() : flagging 0x%lx for removal\n", e->resourceid);
      c->dyn.opts |= FL_REMOVE;
   }
   return 0;
}
