searchData={"items":[{"type":"extras","doc":"# Erlang/OTP System Documentation\n\nThe Erlang/OTP system documentation is a collection of guides describing how\nto use Erlang/OTP and different aspects of working with Erlang/OTP. The guides are:\n\n* [Installation Guide](installation_guide/installation_guide.md) -\n  Describes how to build and install Erlang/OTP on Unix and Windows.\n* [Getting Started With Erlang](getting_started/getting_started.md) -\n  Describes how to get up and running with programming Erlang.\n* [System Principles](system_principles/system_principles.md) -\n  Describes how to build Erlang/OTP systems.\n* [OTP Design Principles](design_principles/design_principles.md) -\n  Describes how to build Erlang/OTP applications.\n* [Programming Examples](programming_examples/programming_examples.md) -\n  Examples on using records, funs, list comprehensions, and the bit syntax.\n* [Erlang Reference Manual](reference_manual/reference_manual.md) -\n  This section is the Erlang reference manual. It describes the Erlang programming language.\n* [Efficiency Guide](efficiency_guide/efficiency_guide.md) -\n  Describes how to write efficient code in Erlang-\n* [Interoperability Tutorial](tutorial/tutorial.md) -\n  This section informs on interoperability, that is, information exchange, between\n  Erlang and other programming languages. The included examples mainly treat\n  interoperability between Erlang and C.\n* [Embedded Systems User's Guide](embedded/embedded.md) -\n  This section describes the issues that are specific for running Erlang on an embedded system.","title":"Erlang/OTP System Documentation","ref":"readme.html"},{"type":"extras","doc":"# Introduction\n\nThis section describes how to build, install and patch Erlang/OTP on UNIX and Windows.\n\n* **[Building and Installing Erlang/OTP](INSTALL.md)** - Describes how to build and install Erlang/OTP\n  on any UNIX platform, that is Linux, macOS, any BSD, Solaris and so on.\n* **[Cross Compiling Erlang/OTP](INSTALL-CROSS.md)** - Describes how to use a [cross compiler] to build\n  Erlang/OTP on any UNIX platform.\n* **[Building Erlang/OTP on Windows](INSTALL-WIN32.md)** - Describes how to build Erlang/OTP for on\n  Windows 10 using WSL.\n\nThere are also various other guides for other OS located in the\n[Erlang/OTP HOWTO folder](https://github.com/erlang/otp/blob/master/HOWTO/).\n\n> #### Note {: .info }\n>\n> Depending on the Operating System and how familiar you are with using GNU configure/make\n> it can be difficult to build Erlang/OTP. Therefore it is recommended to first go to\n>   and check if a pre-built Erlang/OTP can be used.\n\nIf the purpose of building Erlang/OTP is to contribute to its development it is recommended\nto have a look at\n[Contributing to Erlang/OTP](https://github.com/erlang/otp/blob/master/CONTRIBUTING.md)\nand [Developing Erlang/OTP](https://github.com/erlang/otp/blob/master/HOWTO/DEVELOPMENT.md).\n\n[cross compiler]: https://en.wikipedia.org/wiki/Cross_compiler","title":"Introduction","ref":"installation_guide.html"},{"type":"extras","doc":"Building and Installing Erlang/OTP\n==================================\n\nIntroduction\n------------\n\nThis document describes how to build and install Erlang/OTP-27.\nErlang/OTP should be possible to build from source on any Unix/Linux system,\nincluding macOS. You are advised to read the whole document\nbefore attempting to build and install Erlang/OTP.\n\nThe source code can be downloaded from the official site of Erlang/OTP or GitHub.\n*  \n*  \n\nRequired Utilities\n------------------\n\nThese are the tools you need in order to unpack and build Erlang/OTP.","title":"Building and Installing Erlang/OTP","ref":"install.html"},{"type":"extras","doc":"*   GNU unzip, or a modern uncompress.\n*   A TAR program that understands the GNU TAR format for long filenames.","title":"Unpacking ### - Building and Installing Erlang/OTP","ref":"install.html#unpacking"},{"type":"extras","doc":"*   GNU `make`\n*   Compiler -- GNU C Compiler, `gcc` or the C compiler frontend for LLVM, `clang`.\n*   Perl 5\n*   `ncurses`, `termcap`, or `termlib` -- The development headers and\n    libraries are needed, often known as `ncurses-devel`. Use\n    `--without-termcap` to build without any of these libraries. Note that\n    in this case only the old shell (without any line editing) can be used.\n*  `sed` -- Stream Editor for basic text transformation.\n\n#### Building in Git ####\n\nBuild the same way as when building the unpacked tar file.\n\n#### Building on macOS ####\n\n*   Xcode -- Download and install via the Mac App Store.\n    Read about [Building on a Mac][] before proceeding.","title":"Building ### - Building and Installing Erlang/OTP","ref":"install.html#building"},{"type":"extras","doc":"*   An `install` program that can take multiple file names.\n\nOptional Utilities\n------------------\n\nSome applications are automatically skipped if the dependencies aren't met.\nHere is a list of utilities needed for those applications. You will\nalso find the utilities needed for building the documentation.","title":"Installing ### - Building and Installing Erlang/OTP","ref":"install.html#installing"},{"type":"extras","doc":"*   OpenSSL -- The opensource toolkit for Secure Socket Layer\n    and Transport Layer Security.\n    Required for building the application `crypto`.\n    Further, `ssl` and `ssh` require a working crypto application and\n    will also be skipped if OpenSSL is missing. The `public_key`\n    application is available without `crypto`, but the functionality\n    will be very limited.\n\n    The development package of OpenSSL including the header files are needed as well\n    as the binary command program `openssl`. At least version 0.9.8 of OpenSSL is required.\n    Read more and download from  .\n*   Oracle Java SE JDK -- The Java Development Kit (Standard Edition).\n    Required for building the application `jinterface`.\n    At least version 1.6.0 of the JDK is required.\n\n    Download from  .\n    We have also tested with IBM's JDK 1.6.0.\n*   `flex` -- Headers and libraries are needed to build the flex\n    scanner for the `megaco` application on Unix/Linux.\n*   wxWidgets -- Toolkit for GUI applications.\n    Required for building the `wx` application. At least\n    version 3.0 of wxWidgets is required.\n\n    Download from  \n    or get it from GitHub:  \n\n    Further instructions on wxWidgets, read [Building with Wx][].","title":"Building ### - Building and Installing Erlang/OTP","ref":"install.html#building"},{"type":"extras","doc":"*   `ex_doc` -- [ExDoc](https://hexdocs.pm/ex_doc/readme.html) is a tool to\n    generate html and epub documentation for Erlang and Elixir projects.\n  \n    Download as an [escript from github](https://github.com/elixir-lang/ex_doc/releases/latest)\n    or get it from GitHub:   and build\n    your self.\n    \n    ExDoc v0.37.0-rc.2 was used to build the documentation for this release,\n    but any version after that should work just as well.\n\n    You can also use `./otp_build download_ex_doc` to download the correct version\n    from github. One of the following dependencies are needed to check the documentation:\n    \n    - sha256sum, or\n    - sha1sum, or\n    - shasum\n\nHow to Build and Install Erlang/OTP\n-----------------------------------\n\nThe following instructions are for building [the released source tar ball][]\nor from a [git clone](https://github.com/erlang/otp).\n\nThe variable `$ERL_TOP` will be mentioned a lot of times. It refers to\nthe top directory in the source tree. More information about `$ERL_TOP`\ncan be found in the [make and $ERL_TOP][] section below.","title":"Building Documentation ### - Building and Installing Erlang/OTP","ref":"install.html#building-documentation"},{"type":"extras","doc":"Start by unpacking the Erlang/OTP distribution file with your GNU\ncompatible TAR program.\n\n    $ tar -zxf otp_src_27.3.tar.gz    # Assuming bash/sh\n\nor clone from github:\n\n    $ git clone https://github.com/erlang/otp otp_src_27.3\n\nNow change directory into the base directory and set the `$ERL_TOP` variable.\n\n    $ cd otp_src_27.3\n    $ export ERL_TOP=`pwd`    # Assuming bash/sh","title":"Unpacking ### - Building and Installing Erlang/OTP","ref":"install.html#unpacking"},{"type":"extras","doc":"Run the following commands to configure the build:\n\n    $ ./configure [ options ]\n\nBy default, Erlang/OTP release will be installed in `/usr/local/{bin,lib/erlang}`.\nIf you for instance don't have the permission to install in the standard location,\n you can install Erlang/OTP somewhere else. For example, to install in\n`/opt/erlang/27.3/{bin,lib/erlang}`, use the `--prefix=/opt/erlang/27.3` option.\n\nOn some platforms Perl may behave strangely if certain locales are\nset. If you get errors when building, try setting the LANG variable:\n\n    $ export LANG=C   # Assuming bash/sh","title":"Configuring ### - Building and Installing Erlang/OTP","ref":"install.html#configuring"},{"type":"extras","doc":"Build the Erlang/OTP release.\n\n    $ make","title":"Building ### - Building and Installing Erlang/OTP","ref":"install.html#building"},{"type":"extras","doc":"Before installation you should test whether your build is working properly\nby running our smoke test. The smoke test is a subset of the complete Erlang/OTP test suites.\nFirst you will need to build and release the test suites.\n\n    $ make release_tests\n\nThis creates an additional folder in `$ERL_TOP/release` called `tests`.\nNow, it's time to start the smoke test.\n\n    $ cd release/tests/test_server\n    $ $ERL_TOP/bin/erl -s ts install -s ts smoke_test batch -s init stop\n\nTo verify that everything is ok you should open `$ERL_TOP/release/tests/test_server/index.html`\nin your web browser and make sure that there are zero failed test cases.\n\n> #### Note {: .info }\n>\n> On builds without `crypto`, `ssl` and `ssh` there is a failed test case\n> for undefined functions. Verify that the failed test case log only shows calls\n> to skipped applications.","title":"Testing ### - Building and Installing Erlang/OTP","ref":"install.html#testing"},{"type":"extras","doc":"You are now ready to install the Erlang/OTP release!\nThe following command will install the release on your system.\n\n    $ make install","title":"Installing ### - Building and Installing Erlang/OTP","ref":"install.html#installing"},{"type":"extras","doc":"You should now have a working release of Erlang/OTP!\nJump to [System Principles][] for instructions on running Erlang/OTP.\n\n[](){: #How-to-Build-and-Install-Erlang-OTP_How-to-Build-the-Documentation }","title":"Running ### - Building and Installing Erlang/OTP","ref":"install.html#running"},{"type":"extras","doc":"Make sure you're in the top directory in the source tree.\n\n    $ cd $ERL_TOP\n\nIf you have just built Erlang/OTP in the current source tree, you have\nalready ran `configure` and do not need to do this again; otherwise, run\n`configure`.\n\n    $ ./configure [Configure Args]\n\nWhen building the documentation you need a full Erlang/OTP-27.3 system in\nthe `$PATH`.\n\n    $ export PATH=$ERL_TOP/bin:$PATH     # Assuming bash/sh\n\nTo build `html` and `epub` docs you need to have [ExDoc v0.37.0-rc.2](https://github.com/elixir-lang/ex_doc).\nSee [Building Documentation](#building-documentation) for information on how to\ninstall ExDoc.\n\nBuild the documentation using:\n\n    $ make docs\n\nIt is possible to limit which types of documentation is build by passing the `DOC_TARGETS`\nenvironment variable to `make docs`.\n\n_Example_:\n\n    $ make docs DOC_TARGETS=chunks\n\nThe currently available types are: `html` and `chunks`. Where:\n\n* *chunks* - Build [EEP-48](`e:kernel:eep48_chapter.md`) documentation chunks.\n* *html* - Build html and epub documentation.","title":"How to Build the Documentation ### - Building and Installing Erlang/OTP","ref":"install.html#how-to-build-the-documentation"},{"type":"extras","doc":"The documentation can be installed either using the `install-docs` target,\nor using the `release_docs` target.\n\n*   If you have installed Erlang/OTP using the `install` target, install\n    the documentation using the `install-docs` target. Install locations\n    determined by `configure` will be used. `$DESTDIR` can be used the\n    same way as when doing `make install`.\n\n        $ make install-docs\n\n*   If you have installed Erlang/OTP using the `release` target, install\n    the documentation using the `release_docs` target. You typically want\n    to use the same `RELEASE_ROOT` as when invoking `make release`.\n\n        $ make release_docs RELEASE_ROOT= \n\nIt is possible to limit which types of documentation is released using the same `DOC_TARGETS`\nenvironment variable as when building documentation.","title":"How to Install the Documentation ### - Building and Installing Erlang/OTP","ref":"install.html#how-to-install-the-documentation"},{"type":"extras","doc":"After installation you can access the documentation by\n\n*   Browsing the html pages by loading the page `/usr/local/lib/erlang/doc/erlang/index.html`\n    or ` /lib/erlang/doc/erlang/index.html` if the prefix option has been used.\n\n*   Read the embedded documentation by using the built-in shell functions `h/1,2,3` or\n    `ht/1,2,3`.","title":"Accessing the Documentation ### - Building and Installing Erlang/OTP","ref":"install.html#accessing-the-documentation"},{"type":"extras","doc":"Pre-formatted [html documentation][] can be downloaded from  .\n\nExtract the html archive in the installation directory.\n\n    $ cd  \n    $ tar -zxf otp_html_27.3.tar.gz\n\nWhere ` ` is\n\n*   ` /lib/erlang` if you have installed Erlang/OTP using\n    `make install`.\n*   `$DESTDIR /lib/erlang` if you have installed Erlang/OTP\n    using `make install DESTDIR= `.\n*   `RELEASE_ROOT` if you have installed using\n    `make release RELEASE_ROOT= `.\n\n\nAdvanced configuration and build of Erlang/OTP\n----------------------------------------------\n\nIf you want to tailor your Erlang/OTP build and installation, please read\non for detailed information about the individual steps.\n\n[](){: #advanced-configuration-and-build-of-erlang-otp_make-and-ERLTOP }","title":"How to Install the Pre-formatted Documentation ### - Building and Installing Erlang/OTP","ref":"install.html#how-to-install-the-pre-formatted-documentation"},{"type":"extras","doc":"All the makefiles in the entire directory tree use the environment\nvariable `ERL_TOP` to find the absolute path of the installation. The\n`configure` script will figure this out and set it in the top level\nMakefile (which, when building, it will pass on). However, when\ndeveloping it is sometimes convenient to be able to run make in a\nsubdirectory. To do this you must set the `ERL_TOP` variable\nbefore you run make.\n\nFor example, assume your GNU make program is called `make` and you\nwant to rebuild the application `STDLIB`, then you could do:\n\n    $ cd lib/stdlib; env ERL_TOP=  make\n\nwhere ` ` would be what you find `ERL_TOP` is set to in the top level\nMakefile.","title":"make and $ERL_TOP ### - Building and Installing Erlang/OTP","ref":"install.html#make-and-erl_top"},{"type":"extras","doc":"Building Erlang/OTP can be done either by using the `$ERL_TOP/otp_build`\nscript, or by invoking `$ERL_TOP/configure` and `make` directly. Building using\n`otp_build` is easier since it involves fewer steps, but the `otp_build` build\nprocedure is not as flexible as the `configure`/`make` build procedure. The binary\nreleases for Windows that we deliver are built using `otp_build`.\n\n[]() {: #advanced-configuration-and-build-of-erlang-otp_configuring }","title":"otp_build vs configure/make ### - Building and Installing Erlang/OTP","ref":"install.html#otp_build-vs-configure-make"},{"type":"extras","doc":"The configure script is created by the GNU autoconf utility, which\nchecks for system specific features and then creates a number of makefiles.\n\nThe configure script allows you to customize a number of parameters;\ntype `./configure --help` or `./configure --help=recursive` for details.\n`./configure --help=recursive` will give help for all `configure` scripts in\nall applications.\n\nOne of the things you can specify is where Erlang/OTP should be installed. By\ndefault Erlang/OTP will be installed in `/usr/local/{bin,lib/erlang}`.\nTo keep the same structure but install in a different place, ` ` say,\nuse the `--prefix` argument like this: `./configure --prefix= `.\n\nSome of the available `configure` options are:\n\n*   `--prefix=PATH` - Specify installation prefix.\n*   `--disable-parallel-configure` - Disable parallel execution of\n    `configure` scripts (parallel execution is enabled by default)\n*   `--{enable,disable}-jit` - Force enabling or disabling of the JIT.\n*   `--{enable,disable}-kernel-poll` - Kernel poll support (enabled by\n    default if possible)\n*   `--enable-m64-build` - Build 64-bit binaries using the `-m64` flag to\n    `(g)cc`\n*   `--enable-m32-build` - Build 32-bit binaries using the `-m32` flag to\n    `(g)cc`\n*   `--{enable,disable}-pie` - Build position independent executable binaries.\n*   `--with-assumed-cache-line-size=SIZE` - Set assumed cache-line size in\n    bytes. Default is 64. Valid values are powers of two between and\n    including 16 and 8192. The runtime system use this value in order to\n    try to avoid false sharing. A too large value wastes memory. A to\n    small value will increase the amount of false sharing.\n*   `--{with,without}-termcap` - termcap (without implies that only the old\n    Erlang shell can be used)\n*   `--with-javac=JAVAC` - Specify Java compiler to use\n*   `--{with,without}-javac` - Java compiler (without implies that the\n    `jinterface` application won't be built)\n*   `--{enable,disable}-builtin-zlib` - Use the built-in source for zlib.\n*   `--{enable,disable}-dynamic-ssl-lib` - Enable or disable dynamic OpenSSL\n    libraries when linking the crypto NIF. By default dynamic linking is\n    done unless it does not work or is if it is a Windows system.\n*   `--{with,without}-ssl` - OpenSSL (without implies that the `crypto`,\n    `ssh`, and `ssl` won't be built)\n*   `--with-ssl=PATH` - Specify base location of OpenSSL include and lib\n    directories.\n*   `--with-ssl-incl=PATH` - Specify base location of OpenSSL `include`\n    directory (if different than base location specified by --with-ssl=PATH).\n*   `--with-ssl-zlib=PATH` - Path to static zlib library to link the\n    crypto NIF with. This zlib library is most often not necessary but\n    might be needed in order to link the NIF in some cases.\n*   `--with-ssl-lib-subdir=RELATIVE_PATH` - Specify extra OpenSSL lib\n    sub-directory to search in (relative to base directory).\n*   `--with-ssl-rpath=yes|no|PATHS` - Runtime library path for OpenSSL.\n    Default is `yes`, which equates to a number of standard locations. If\n    `no`, then no runtime library paths will be used. Anything else should be\n    a comma or colon separated list of paths.\n*   `--with-libatomic_ops=PATH` - Use the `libatomic_ops` library for atomic\n    memory accesses. If `configure` should inform you about no native atomic\n    implementation available, you typically want to try using the\n    `libatomic_ops` library. It can be downloaded from\n     .\n*   `--disable-smp-require-native-atomics` - By default `configure` will\n    fail if an SMP runtime system is about to be built, and no implementation\n    for native atomic memory accesses can be found. If this happens, you are\n    encouraged to find a native atomic implementation that can be used, e.g.,\n    using `libatomic_ops`, but by passing `--disable-smp-require-native-atomics`\n    you can build using a fallback implementation based on mutexes or spinlocks.\n    Performance of the SMP runtime system will however suffer immensely without\n    an implementation for native atomic memory accesses.\n*   `--enable-static-{nifs,drivers}` - To allow usage of nifs and drivers on OSs\n    that do not support dynamic linking of libraries it is possible to statically\n    link nifs and drivers with the main Erlang VM binary. This is done by passing\n    a comma separated list to the archives that you want to statically link. e.g.\n    `--enable-static-nifs=/home/$USER/my_nif.a`. The paths have to be absolute.\n    For drivers, the driver name has to be the same as the filename. You also\n    have to define `STATIC_ERLANG_NIF_LIBNAME` (see `erl_nif` documentation) or\n    `STATIC_ERLANG_DRIVER` when compiling the .o files for the nif/driver.\n    If your nif/driver depends on some other dynamic library, you now have to link\n    that to the Erlang VM binary. This is easily achieved by passing `LIBS=-llibname`\n    to configure.\n*   `--without-$app` - By default all applications in Erlang/OTP will be included\n\tin a release. If this is not wanted it is possible to specify that Erlang/OTP\n\tshould be compiled without one or more applications, i.e. `--without-wx`. There is\n\tno automatic dependency handling between applications. If you disable\n\tan application that another application depends on, you also have to disable the\n\tdependent application.\n*   `--enable-gettimeofday-as-os-system-time` - Force usage of `gettimeofday()` for\n    OS system time.\n*   `--enable-prefer-elapsed-monotonic-time-during-suspend` - Prefer an OS monotonic\n    time source with elapsed time during suspend.\n*   `--disable-prefer-elapsed-monotonic-time-during-suspend` - Do not prefer an OS\n    monotonic time source with elapsed time during suspend.\n*   `--with-clock-resolution=high|low` - Try to find clock sources for OS system\n    time, and OS monotonic time with higher or lower resolution than chosen by\n    default. Note that both alternatives may have a negative impact on the performance\n    and scalability compared to the default clock sources chosen.\n*   `--enable-ensure-os-monotonic-time` - Enable functionality ensuring the\n    monotonicity of monotonic timestamps delivered by the OS. When a\n    non-monotonic timestamp is detected, it will be replaced by the last\n    delivered monotonic timestamp before being used by Erlang's time\n    functionality. Note that you do *not* want to enable this unless the OS\n    monotonic time source on the system fails to produce monotonic timestamps.\n    This since ensuring the monotonicity of OS monotonic timestamps will hurt\n    scalability and performance of the system.\n*   `--disable-saved-compile-time` - Disable saving of compile date and time\n    in the emulator binary.\n*   `--enable-ei-dynamic-lib` - Make erl_interface build a shared library in addition\n    to the archive normally built.\n*   `--disable-year2038` - Don't support timestamps after mid-January 2038. By\n    default `configure` will try to enable support for timestamps after\n    mid-January 2038. If it cannot figure out how to do that, it will fail and\n    abort with an error. If you anyway want to build the system knowing that the\n    system won't function properly after mid-January 2038, you can pass this\n    option which will enable `configure` to continue without support for\n    timestamps after mid-January 2038. This is typically only an issue on 32-bit\n    platforms.\n\nIf you or your system has special requirements please read the `Makefile` for\nadditional configuration information.\n\n[](){: #advanced-configuration-and-build-of-erlang-otp_Configuring_Important-Variables-Inspected-by-configure }\n\n#### Important Variables Inspected by configure ####\n\n##### Compiler and Linker #####\n\n*   `CC` - C compiler.\n*   `CFLAGS` - C compiler flags. Defaults to \"-g -O2\". If you set it,\n    these will be removed.\n*   `STATIC_CFLAGS` - Static C compiler flags.\n*   `CFLAG_RUNTIME_LIBRARY_PATH` - This flag should set runtime library\n    search path for the shared libraries. Note that this actually is a\n    linker flag, but it needs to be passed via the compiler.\n*   `CPP` - C pre-processor.\n*   `CPPFLAGS` - C pre-processor flags.\n*   `CXX` - C++ compiler.\n*   `CXXFLAGS` - C++ compiler flags.\n*   `LD` - Linker.\n*   `LDFLAGS` - Linker flags.\n*   `LIBS` - Libraries.\n\n##### Dynamic Erlang Driver Linking #####\n\n> #### Note {: .info }\n>\n> Either set all or none of the `DED_LD*` variables (with the exception\n> of `DED_LDFLAGS_CONFTEST`).\n\n*   `DED_LD` - Linker for Dynamically loaded Erlang Drivers.\n*   `DED_LDFLAGS` - Linker flags to use with `DED_LD`.\n*   `DED_LDFLAGS_CONFTEST` - Linker flags to use with `DED_LD` in configure\n    link tests if `DED_LDFLAGS` cannot be used in such tests. If not set,\n    `DED_LDFLAGS` will be used in configure tests.\n*   `DED_LD_FLAG_RUNTIME_LIBRARY_PATH` - This flag should set runtime library\n    search path for shared libraries when linking with `DED_LD`.\n\n##### Large File Support #####\n\n> #### Note {: .info }\n>\n> Either set all or none of the `LFS_*` variables.\n\n*   `LFS_CFLAGS` - Large file support C compiler flags.\n*   `LFS_LDFLAGS` - Large file support linker flags.\n*   `LFS_LIBS` - Large file support libraries.\n\n##### Other Tools #####\n\n*   `RANLIB` - `ranlib` archive index tool.\n*   `AR` - `ar` archiving tool.\n*   `GETCONF` - `getconf` system configuration inspection tool. `getconf` is\n    currently used for finding out large file support flags to use, and\n    on Linux systems for finding out if we have an NPTL thread library or\n    not.\n\n#### Updating configure Scripts ####\n\nGenerated `configure` scripts are nowadays included in the git repository.\n\nIf you modify any `configure.in` files or the `erts/aclocal.m4` file, you need\nto regenerate `configure` scripts before the changes will take effect. First\nensure that you have GNU `autoconf` of version 2.69 in your path. Then execute\n`./otp_build update_configure [--no-commit]` in the `$ERL_TOP` directory. The\n`otp_build` script will verify that `autoconf` is of correct version and will\nrefuse to update the `configure` scripts if it is of any other version.\n\n[](){: #advanced-configuration-and-build-of-erlang-otp_configuring_atomic-memory-operations-and-the-vm }\n\n#### Atomic Memory Operations and the VM ####\n\nThe VM with SMP support makes quite a heavy use of atomic memory operations.\nAn implementation providing native atomic memory operations is therefore very\nimportant when building Erlang/OTP. By default the VM will refuse to build\nif native atomic memory operations are not available.\n\nErlang/OTP itself provides implementations of native atomic memory operations\nthat can be used when compiling with a `gcc` compatible compiler for 32/64-bit\nx86, 32/64-bit SPARC V9, 32-bit PowerPC, or 32-bit Tile. When compiling with\na `gcc` compatible compiler for other architectures, the VM may be able to make\nuse of native atomic operations using the `__atomic_*` builtins (may be\navailable when using a `gcc` of at least version 4.7) and/or using the\n`__sync_*` builtins (may be available when using a `gcc` of at least version\n4.1). If only the `gcc`'s `__sync_*` builtins are available, the performance\nwill suffer. Such a configuration should only be used as a last resort. When\ncompiling on Windows using a MicroSoft Visual C++ compiler native atomic\nmemory operations are provided by Windows APIs.\n\nNative atomic implementation in the order preferred:\n1.  The implementation provided by Erlang/OTP.\n2.  The API provided by Windows.\n3.  The implementation based on the `gcc` `__atomic_*` builtins.\n4.  If none of the above are available for your architecture/compiler, you\n    are recommended to build and install [libatomic_ops][] before building\n    Erlang/OTP. The `libatomic_ops` library provides native atomic memory\n    operations for a variety of architectures and compilers. When building\n    Erlang/OTP you need to inform the build system of where the\n    `libatomic_ops` library is installed using the\n    `--with-libatomic_ops=PATH` `configure` switch.\n5.  As a last resort, the implementation solely based on the `gcc`\n    `__sync_*` builtins. This will however cause lots of expensive and\n    unnecessary memory barrier instructions to be issued. That is,\n    performance will suffer. The `configure` script will warn at the end\n    of its execution if it cannot find any other alternative than this.","title":"Configuring ### - Building and Installing Erlang/OTP","ref":"install.html#configuring"},{"type":"extras","doc":"Building Erlang/OTP on a relatively fast computer takes approximately\n5 minutes. To speed it up, you can utilize parallel make with the `-j ` option.\n\n    $ export MAKEFLAGS=-j8    # Assuming bash/sh\n    $ make\n\nIf you've upgraded the source with a patch you may need to clean up from previous\nbuilds before the new build.\nMake sure to read the [Pre-built Source Release][] section below before doing a `make clean`.\n\nOther useful information can be found here:\n* [Erlang/OTP GitHub wiki](https://github.com/erlang/otp/wiki)\n* [Contributing to Erlang/OTP](https://github.com/erlang/otp/blob/master/CONTRIBUTING.md)\n* [Developing Erlang/OTP](https://github.com/erlang/otp/blob/master/HOWTO/DEVELOPMENT.md)\n\n[](){: #advanced-configuration-and-build-of-erlang-otp_Building_macOS-Darwin }\n\n#### macOS (Darwin) ####\n\nMake sure that the command `hostname` returns a valid fully qualified host\nname (this is configured in `/etc/hostconfig`). Otherwise you might experience\nproblems when running distributed systems.\n\nIf you develop linked-in drivers (shared library) you need to link using\n`gcc` and the flags `-bundle -flat_namespace -undefined suppress`. You also\ninclude `-fno-common` in `CFLAGS` when compiling. Use `.so` as the library\nsuffix.\n\nIf you have Xcode 4.3, or later, you will also need to download\n\"Command Line Tools\" via the Downloads preference pane in Xcode.\n\n[](){: #advanced-configuration-and-build-of-erlang-otp_Building_Building-with-Wx }\n\n#### Building with Wx ####\n\nwxWidgets-3.2.x is recommended for building the `wx` application\n(wxWidgets-3.0.x will also work). Download it from\n  or from\n . It is recommended to use the\nlatest release in the 3.2 series, which at the time of writing\nis 3.2.2.1.\n\nNote that the wxWidgets-3.3 versions are experimental, but they should\nalso work if 3.0 compatibility is enabled by adding\n`--enable-compat30` to the `configure` commands below.\n\nOn all other platforms, a shared library is built as follows:\n\n    $ ./configure --prefix=/usr/local\n    $ make && sudo make install\n    $ export PATH=/usr/local/bin:$PATH\n\nOn Linux, a static library is built as follows:\n\n    $ export CFLAGS=-fPIC\n    $ export CXXFLAGS=-fPIC\n    $ ./configure --prefix=/usr/local --disable-shared\n    $ make && sudo make install\n    $ export PATH=/usr/local/bin:$PATH\n\nOn macOs, a static library compatible with macOS 13 (Ventura) and later is built\nas follows:\n\n    $ ./configure --prefix=/usr/local --with-macosx-version-min=13.0 --disable-shared\n    $ make\n    $ sudo make install\n    $ export PATH=/usr/local/bin:$PATH\n\nVerify that the build and installation succeeded:\n\n    $ which wx-config && wx-config --version-full\n\nExpected output is `/usr/local/bin/wx-config` on one line, followed by the full\nversion number. For example, if you built version 3.2.2.1, the expected output is:\n\n    /usr/local/bin/wx-config\n    3.2.2.1\n\nBuild Erlang/OTP in the usual way. To verify that `wx` application is\nworking run the following command:\n\n    $ erl -run wx demo\n\n\n[](){: #advanced-configuration-and-build-of-erlang-otp_Building_Prebuilt-Source-Release }\n\n#### Pre-built Source Release ####\n\nThe source release is delivered with a lot of platform independent\nbuild results already pre-built. If you want to remove these pre-built\nfiles, invoke `./otp_build remove_prebuilt_files` from the `$ERL_TOP`\ndirectory. After you have done this, you can build exactly the same way\nas before, but the build process will take a much longer time.\n\n> #### Warning {: .warning }\n>\n> Doing `make clean` in an arbitrary directory of the source\n> tree, may remove files needed for bootstrapping the build.\n>\n> Doing `./otp_build save_bootstrap` from the `$ERL_TOP` directory before\n> doing `make clean` will ensure that it will be possible to build after\n> doing `make clean`. `./otp_build save_bootstrap` will be invoked\n> automatically when `make` is invoked from `$ERL_TOP` with either the\n> `clean` target, or the default target. It is also automatically invoked\n> if `./otp_build remove_prebuilt_files` is invoked.\n>\n> If you need to verify the bootstrap beam files match the provided\n> source files, use `./otp_build update_primary` to create a new commit that\n> contains differences, if any exist.\n\n[](){: #advanced-configuration-and-build-of-erlang-otp_building_how-to-build-a-debug-enabled-erlang-runtime-system }\n\n#### How to Build a Debug Enabled Erlang RunTime System ####\n\nAfter completing all the normal building steps described above a debug\nenabled runtime system can be built. To do this you have to change\ndirectory to `$ERL_TOP/erts/emulator` and execute:\n\n    $ (cd $ERL_TOP/erts/emulator && make debug)\n\nThis will produce a `beam.debug.smp` executable. The\nfile are installed along side with the normal (opt) version `beam.smp`.\n\nTo start the debug enabled runtime system execute:\n\n    $ $ERL_TOP/bin/cerl -debug\n\nThe debug enabled runtime system features lock violation checking,\nassert checking and various sanity checks to help a developer ensure\ncorrectness. Some of these features can be enabled on a normal beam\nusing appropriate configure options.\n\nThere are other types of runtime systems that can be built as well\nusing the similar steps just described.\n\n    $ (cd $ERL_TOP/erts/emulator && make $TYPE)\n\nwhere `$TYPE` is `opt`, `gcov`, `gprof`, `debug`, `valgrind`, `asan` or `lcnt`.\nThese different beam types are useful for debugging and profiling\npurposes.","title":"Building ### - Building and Installing Erlang/OTP","ref":"install.html#building"},{"type":"extras","doc":"*   Staged install using [DESTDIR][]. You can perform the install\n    phase in a temporary directory and later move the installation into\n    its correct location by use of the `DESTDIR` variable:\n\n        $ make DESTDIR=  install\n\n    The installation will be created in a location prefixed by `$DESTDIR`.\n    It can, however, not be run from there. It needs to be moved into the\n    correct location before it can be run. If `DESTDIR` have not been set\n    but `INSTALL_PREFIX` has been set, `DESTDIR` will be set to\n    `INSTALL_PREFIX`. Note that `INSTALL_PREFIX` in pre R13B04 was buggy\n    and behaved as `EXTRA_PREFIX` (see below). There are lots of areas of\n    use for an installation procedure using `DESTDIR`, e.g. when creating\n    a package, cross compiling, etc. Here is an example where the\n    installation should be located under `/opt/local`:\n\n        $ ./configure --prefix=/opt/local\n        $ make\n        $ make DESTDIR=/tmp/erlang-build install\n        $ cd /tmp/erlang-build/opt/local\n        $     # gnu-tar is used in this example\n        $ tar -zcf /home/me/my-erlang-build.tgz *\n        $ su -\n        Password: *****\n        $ cd /opt/local\n        $ tar -zxf /home/me/my-erlang-build.tgz\n\n*   Install using the `release` target. Instead of doing `make install` you\n    can create the installation in whatever directory you like using the\n    `release` target and run the `Install` script yourself. `RELEASE_ROOT`\n    is used for specifying the directory where the installation should be\n    created. This is what by default ends up under `/usr/local/lib/erlang`\n    if you do the install using `make install`. All installation paths\n    provided in the `configure` phase are ignored, as well as `DESTDIR`,\n    and `INSTALL_PREFIX`. If you want links from a specific `bin` directory\n    to the installation you have to set those up yourself. An example where\n    Erlang/OTP should be located at `/home/me/OTP`:\n\n        $ ./configure\n        $ make\n        $ make RELEASE_ROOT=/home/me/OTP release\n        $ cd /home/me/OTP\n        $ ./Install -minimal /home/me/OTP\n        $ mkdir -p /home/me/bin\n        $ cd /home/me/bin\n        $ ln -s /home/me/OTP/bin/erl erl\n        $ ln -s /home/me/OTP/bin/erlc erlc\n        $ ln -s /home/me/OTP/bin/escript escript\n        ...\n\n    The `Install` script should currently be invoked as follows in the\n    directory where it resides (the top directory):\n\n        $ ./Install [-cross] [-minimal|-sasl]  \n\n    where:\n\n    *   `-minimal` Creates an installation that starts up a minimal amount\n        of applications, i.e., only `kernel` and `stdlib` are started. The\n        minimal system is normally enough, and is what `make install` uses.\n    *   `-sasl` Creates an installation that also starts up the `sasl`\n        application.\n    *   `-cross` For cross compilation. Informs the install script that it\n        is run on the build machine.\n    *   ` ` - The absolute path to the Erlang installation to use\n        at run time. This is often the same as the current working directory,\n        but does not have to be. It can follow any other path through the\n        file system to the same directory.\n\n    If neither `-minimal`, nor `-sasl` is passed as argument you will be\n    prompted.\n\n*   Test install using `EXTRA_PREFIX`. The content of the `EXTRA_PREFIX`\n    variable will prefix all installation paths when doing `make install`.\n    Note that `EXTRA_PREFIX` is similar to `DESTDIR`, but it does *not* have\n    the same effect as `DESTDIR`. The installation can and have to be run\n    from the location specified by `EXTRA_PREFIX`. That is, it can be useful\n    if you want to try the system out, running test suites, etc, before doing\n    the real install without `EXTRA_PREFIX`.\n\n#### Symbolic Links in --bindir ####\n\nWhen doing `make install` and the default installation prefix is used,\nrelative symbolic links will be created from `/usr/local/bin` to all public\nErlang/OTP executables in `/usr/local/lib/erlang/bin`. The installation phase\nwill try to create relative symbolic links as long as `--bindir` and the\nErlang bin directory, located under `--libdir`, both have `--exec-prefix` as\nprefix. Where `--exec-prefix` defaults to `--prefix`. `--prefix`,\n`--exec-prefix`, `--bindir`, and `--libdir` are all arguments that can be\npassed to `configure`. One can force relative, or absolute links by passing\n`BINDIR_SYMLINKS=relative|absolute` as arguments to `make` during the install\nphase. Note that such a request might cause a failure if the request cannot\nbe satisfied.","title":"Installing ### - Building and Installing Erlang/OTP","ref":"install.html#installing"},{"type":"extras","doc":"Erlang/OTP are currently tested on the following hardware and operating systems.\nThis is not an exhaustive list, but we try to keep it as up to date as possible.\n\nArchitecture\n\n* x86, x86-64\n* Aarch32, Aarch64\n* powerpc, powerpc64le\n* Apple M1, M2, M2 Pro\n\nOperating system\n\n* Fedora 31\n* FreeBSD\n* macOS 13 - 14\n* MontaVista 4\n* NetBSD\n* OpenBSD\n* SLES 10, 11, 12\n* SunOS 5.11\n* Ubuntu 10.04 - 22.04\n* Windows 11, Windows 10, Windows Server 2019\n\n[DESTDIR]: http://www.gnu.org/prep/standards/html_node/DESTDIR.html\n[Building in Git]: #advanced-configuration-and-build-of-erlang-otp_Building_Within-Git\n[Advanced Configure]: #advanced-configuration-and-build-of-erlang-otp_Configuring\n[Pre-built Source Release]: #advanced-configuration-and-build-of-erlang-otp_Building_Prebuilt-Source-Release\n[make and $ERL_TOP]: #advanced-configuration-and-build-of-erlang-otp_make-and-ERLTOP\n[html documentation]: https://github.com/erlang/otp/releases/download/OTP-27.3/otp_doc_html_27.3.tar.gz\n[the released source tar ball]: https://github.com/erlang/otp/releases/download/OTP-27.3/otp_src_27.3.tar.gz\n[System Principles]: `e:system:system_principles.md`\n[native build]: #how-to-build-and-install-erlang-otp\n[cross build]: INSTALL-CROSS.md\n[Required Utilities]: #Required-Utilities\n[Optional Utilities]: #Optional-Utilities\n[Building on a Mac]: #advanced-configuration-and-build-of-erlang-otp_Building_macOS-Darwin\n[Building with Wx]: #advanced-configuration-and-build-of-erlang-otp_Building_Building-with-Wx\n[libatomic_ops]: https://github.com/ivmai/libatomic_ops/","title":"Erlang/OTP test architectures ## - Building and Installing Erlang/OTP","ref":"install.html#erlang-otp-test-architectures"},{"type":"extras","doc":"Cross Compiling Erlang/OTP\n==========================\n\nIntroduction\n------------\n\nThis document describes how to cross compile Erlang/OTP-27. \nYou are advised to read the whole document before attempting to cross\ncompile Erlang/OTP. However, before reading this document, you should read\n[Building and Installing Erlang/OTP][] which describes building\nand installing Erlang/OTP in general.\n\nIn the text below `$ERL_TOP` is the top directory in the Erlang/OTP source tree.","title":"Cross Compiling Erlang/OTP","ref":"install-cross.html"},{"type":"extras","doc":"Building Erlang/OTP can be done either by using the `$ERL_TOP/otp_build`\nscript, or by invoking `$ERL_TOP/configure` and `make` directly. Building using\n`otp_build` is easier since it involves fewer steps, but the `otp_build` build\nprocedure is not as flexible as the `configure`/`make` build procedure. Note\nthat `otp_build configure` will produce a default configuration that differs\nfrom what `configure` will produce by default. For example, currently\n`--disable-dynamic-ssl-lib` is added to the `configure` command line arguments\nunless `--enable-dynamic-ssl-lib` has been explicitly passed. The defaults used by\n`otp_build configure` may change at any time without prior notice.","title":"otp_build Versus configure/make ### - Cross Compiling Erlang/OTP","ref":"install-cross.html#otp_build-versus-configure-make"},{"type":"extras","doc":"The `$ERL_TOP/xcomp/erl-xcomp.conf.template` file contains all available cross\nconfiguration variables and can be used as a template when creating a cross\ncompilation configuration. All [cross configuration variables][] are also\nlisted at the end of this document. For examples of working cross\nconfigurations see the `$ERL_TOP/xcomp/erl-xcomp-TileraMDE2.0-tilepro.conf`\nfile and the `$ERL_TOP/xcomp/erl-xcomp-x86_64-saf-linux-gnu.conf` file. If the\ndefault behavior of a variable is satisfactory, the variable does not need to\nbe set. However, the `configure` script will issue a warning when a default\nvalue is used. When a variable has been set, no warning will be issued.\n\nA cross configuration file can be passed to `otp_build configure` using the\n`--xcomp-conf` command line argument. Note that `configure` does not accept\nthis command line argument. When using the `configure` script directly, pass\nthe configuration variables as arguments to `configure` using a\n` = ` syntax. Variables can also be passed as environment\nvariables to `configure`. However, if you pass the configuration in the\nenvironment, make sure to unset all of these environment variables before\ninvoking `make`; otherwise, the environment variables might set make variables\nin some applications, or parts of some applications, and you may end up with\nan erroneously configured build.","title":"Cross Configuration ### - Cross Compiling Erlang/OTP","ref":"install-cross.html#cross-configuration"},{"type":"extras","doc":"All Erlang/OTP applications except the `wx` application can be cross compiled.\nThe build of the `wx` driver will currently be automatically disabled when\ncross compiling.","title":"What can be Cross Compiled? ### - Cross Compiling Erlang/OTP","ref":"install-cross.html#what-can-be-cross-compiled"},{"type":"extras","doc":"The build system, including cross compilation configuration variables used,\nmay be subject to non backward compatible changes without prior notice.\nCurrent cross build system has been tested when cross compiling some Linux/GNU\nsystems, but has only been partly tested on other platforms.","title":"Compatibility ### - Cross Compiling Erlang/OTP","ref":"install-cross.html#compatibility"},{"type":"extras","doc":"Please submit any patches for cross compiling in a way consistent with this\nsystem. All input is welcome as we have a very limited set of cross compiling\nenvironments to test with. If a new configuration variable is needed, add it\nto `$ERL_TOP/xcomp/erl-xcomp.conf.template`, and use it in `configure.in`.\nOther files that might need to be updated are:\n\n- `$ERL_TOP/xcomp/erl-xcomp-vars.sh`\n- `$ERL_TOP/erl-build-tool-vars.sh`\n- `$ERL_TOP/erts/aclocal.m4`\n- `$ERL_TOP/xcomp/README.md`\n- `$ERL_TOP/xcomp/erl-xcomp-*.conf`\n\nNote that this might be an incomplete list of files that need to be updated.\n\nGeneral information on how to submit patches can be found at:\n   \n\nBuild and Install Procedure\n---------------------------\n\nWe will first go through the `configure`/`make` build procedure which people\nprobably are most familiar with.","title":"Patches ### - Cross Compiling Erlang/OTP","ref":"install-cross.html#patches"},{"type":"extras","doc":"Change directory into the top directory of the Erlang/OTP source tree.\n\n    $ cd $ERL_TOP\n\nIn order to compile Erlang code, a small Erlang bootstrap system has to be\nbuilt, or an Erlang/OTP system of the same release as the one being built\nhas to be provided in the `$PATH`. The Erlang/OTP for the target system will\nbe built using this Erlang system, together with the cross compilation tools\nprovided.\n\nIf you want to build using a compatible Erlang/OTP system in the `$PATH`,\njump to [Cross Building the System].\n\n#### Building a Bootstrap System ####\n\n    $ ./configure --enable-bootstrap-only\n    $ make\n\nThe `--enable-bootstrap-only` argument to `configure` isn't strictly necessary,\nbut will speed things up. It will only run `configure` in applications\nnecessary for the bootstrap, and will disable a lot of things not needed by\nthe bootstrap system. If you run `configure` without `--enable-boostrap-only`\nyou also have to run make as `make bootstrap`; otherwise, the whole system will\nbe built.\n\n#### Cross Building the System #### {: #cross-building-the-system }\n\n    $ ./configure --host=  --build=  [Other Config Args]\n    $ make\n\n` ` is the host/target system that you build for. It does not have to be\na full `CPU-VENDOR-OS` triplet, but can be. The full canonicalized\n`CPU-VENDOR-OS` triplet will be created by executing\n`$ERL_TOP/make/autoconf/config.sub  `. If `config.sub` fails, you need\nto be more specific.\n\n` ` should equal the `CPU-VENDOR-OS` triplet of the system that you\nbuild on. If you execute `$ERL_TOP/make/autoconf/config.guess`, it will in\nmost cases print the triplet you want to use for this.\n\nThe use of ` ` and ` ` values that differ will trigger cross\ncompilation. Note that if ` ` and ` ` differ, the canonicalized\nvalues of ` ` and ` ` must also differ. If they do not, the\nconfiguration will fail.\n\nPass the cross compilation variables as command line arguments to `configure`\nusing a ` = ` syntax.\n\n> #### Note {: .info }\n>\n> You can *not* pass a configuration file using the `--xcomp-conf`\n> argument when you invoke `configure` directly. The `--xcomp-conf` argument\n> can only be passed to `otp_build configure`.\n\n`make` will verify that the Erlang/OTP system used when building is of the\nsame release as the system being built, and will fail if this is not the case.\nIt is possible, however not recommended, to force the cross compilation even\nthough the wrong Erlang/OTP system is used. This by invoking `make` like this:\n`make ERL_XCOMP_FORCE_DIFFERENT_OTP=yes`.\n\n> #### Warning {: .warning }\n>\n> Invoking `make ERL_XCOMP_FORCE_DIFFERENT_OTP=yes` might fail,\n> silently produce suboptimal code, or silently produce erroneous code.\n\n#### Installing ####\n\nYou can either install using the [Installing Using Paths Determined by configure](#installing-using-paths-determined-by-configure), or [install manually](#installing-manually).\n\n[](){: #installing-using-paths-determined-by-configure }\n\n##### Installing Using Paths Determined by configure #####\n\n    $ make install DESTDIR= \n\n`make install` will install at a location specified when doing `configure`.\n`configure` arguments specifying where the installation should reside are for\nexample: `--prefix`, `--exec-prefix`, `--libdir`, `--bindir`, etc. By default\nit will install under `/usr/local`. You typically do not want to install your\ncross build under `/usr/local` on your build machine. Using [DESTDIR][]\nwill cause the installation paths to be prefixed by `$DESTDIR`. This makes it\npossible to install and package the installation on the build machine without\nhaving to place the installation in the same directory on the build machine as\nit should be executed from on the target machine.\n\nWhen `make install` has finished, change directory into `$DESTDIR`, package\nthe system, move it to the target machine, and unpack it. Note that the\ninstallation will only be working on the target machine at the location\ndetermined by `configure`.\n\n[](){: #installing-manually }\n\n##### Installing Manually #####\n\n    $ make release RELEASE_ROOT= \n\n`make release` will copy what you have built for the target machine to\n` `. The `Install` script will not be run. The content of\n` ` is what by default ends up in `/usr/local/lib/erlang`.\n\nThe `Install` script used when installing Erlang/OTP requires common Unix\ntools such as `sed` to be present in your `$PATH`. If your target system\ndoes not have such tools, you need to run the `Install` script on your\nbuild machine before packaging Erlang/OTP. The `Install` script should\ncurrently be invoked as follows in the directory where it resides\n(the top directory):\n\n    $ ./Install [-cross] [-minimal|-sasl]  \n\nwhere:\n\n*   `-minimal` Creates an installation that starts up a minimal amount\n    of applications, i.e., only `kernel` and `stdlib` are started. The\n    minimal system is normally enough, and is what `make install` uses.\n*   `-sasl` Creates an installation that also starts up the `sasl`\n    application.\n*   `-cross` For cross compilation. Informs the install script that it\n    is run on the build machine.\n*   ` ` - The absolute path to the Erlang installation to use\n    at run time. This is often the same as the current working directory,\n    but does not have to be. It can follow any other path through the file\n    system to the same directory.\n\nIf neither `-minimal`, nor `-sasl` is passed as argument you will be\nprompted.\n\n[](){: #install-release }\n\nYou can now either do:\n\n*   Decide where the installation should be located on the target machine,\n    run the `Install` script on the build machine, and package the installed\n    installation. The installation just need to be unpacked at the right\n    location on the target machine:\n\n        $ cd  \n        $ ./Install -cross [-minimal|-sasl]  \n\nor:\n\n*   Package the installation in ` `, place it wherever you want\n    on your target machine, and run the `Install` script on your target\n    machine:\n\n        $ cd  \n        $ ./Install [-minimal|-sasl]","title":"Building With configure/make Directly ### - Cross Compiling Erlang/OTP","ref":"install-cross.html#building-with-configure-make-directly"},{"type":"extras","doc":"$ cd $ERL_TOP\n\n    $ ./otp_build configure --xcomp-conf=  [Other Config Args]\n\nalternatively:\n\n    $ ./otp_build configure --host=  --build=  [Other Config Args]\n\nIf you have your cross compilation configuration in a file, pass it using the\n`--xcomp-conf= ` command line argument. If not, pass `--host= `,\n`--build= `, and the configuration variables using a ` = `\nsyntax on the command line  (same as in [Cross Building the System]). Note that ` ` and ` `\nhave to be passed one way or the other; either by using `erl_xcomp_host= `\nand `erl_xcomp_build= ` in the configuration file, or by using the\n`--host= `, and `--build= ` command line arguments.\n\n`otp_build configure` will configure both for the bootstrap system on the\nbuild machine and the cross host system.\n\n    $ ./otp_build boot -a\n\n`otp_build boot -a` will first build a bootstrap system for the build machine\nand then do the cross build of the system.\n\n    $ ./otp_build release -a  \n\n`otp_build release -a` will do the same as `make release` in [Installing Manually],\nand you will after this have to do a [manual ./Install](#install-release) on either\nthe host or target.\n\nBuilding and Installing the Documentation\n-----------------------------------------\n\nAfter the system has been cross built you can build and install the\ndocumentation the same way as after a native build of the system. See the\n[How to Build the Documentation][] section in the [Building and Installing Erlang/OTP][]\ndocument for information on how to build the documentation.\n\nTesting the cross compiled system\n---------------------------------\n\nSome of the tests that come with erlang use native code to test. This means\nthat when cross compiling erlang you also have to cross compile test suites\nin order to run tests on the target host. To do this you first have to release\nthe tests as usual.\n\n    $ make release_tests\n\nor\n\n    $ ./otp_build tests\n\nThe tests will be released into `$ERL_TOP/release/tests`. After releasing the\ntests you have to install the tests on the build machine. You supply the same\nxcomp file as to `./otp_build` in [Building With the otp_build Script](#building-with-the-otp_build-script).\n\n    $ cd $ERL_TOP/release/tests/test_server/\n    $ $ERL_TOP/bootstrap/bin/erl -eval 'ts:install([{xcomp,\" \"}])' -s ts compile_testcases -s init stop\n\nYou should get a lot of printouts as the testcases are compiled. Once done you\nshould copy the entire `$ERL_TOP/release/tests` folder to the cross host system.\n\nThen go to the cross host system and setup the erlang installed\nto be in your `$PATH`. Then go to what previously was\n`$ERL_TOP/release/tests/test_server` and issue the following command.\n\n    $ erl -s ts install -s ts run all_tests -s init stop\n\nThe configure should be skipped and all tests should hopefully pass. For more\ndetails about how to use ts run `erl -s ts help -s init stop`\n\nCurrently Used Configuration Variables\n--------------------------------------\n\nNote that you cannot define arbitrary variables in a cross compilation\nconfiguration file. Only the ones listed below will be guaranteed to be\nvisible throughout the whole execution of all `configure` scripts. Other\nvariables needs to be defined as arguments to `configure` or exported in\nthe environment.","title":"Building With the otp_build Script ### - Cross Compiling Erlang/OTP","ref":"install-cross.html#building-with-the-otp_build-script"},{"type":"extras","doc":"Variables in this section are only used, when configuring Erlang/OTP for\ncross compilation using `$ERL_TOP/otp_build configure`.\n\n> #### Note {: .info }\n>\n> These variables currently have *no* effect if you configure using\n> the `configure` script directly.\n\n*   `erl_xcomp_build` - The build system used. This value will be passed as\n    `--build=$erl_xcomp_build` argument to the `configure` script. It does\n    not have to be a full `CPU-VENDOR-OS` triplet, but can be. The full\n    `CPU-VENDOR-OS` triplet will be created by\n    `$ERL_TOP/make/autoconf/config.sub $erl_xcomp_build`. If set to `guess`,\n    the build system will be guessed using\n    `$ERL_TOP/make/autoconf/config.guess`.\n\n*   `erl_xcomp_host` - Cross host/target system to build for. This value will\n    be passed as `--host=$erl_xcomp_host` argument to the `configure` script.\n    It does not have to be a full `CPU-VENDOR-OS` triplet, but can be. The\n    full `CPU-VENDOR-OS` triplet will be created by\n    `$ERL_TOP/make/autoconf/config.sub $erl_xcomp_host`.\n\n*   `erl_xcomp_configure_flags` - Extra configure flags to pass to the\n    `configure` script.","title":"Variables for otp_build Only ### - Cross Compiling Erlang/OTP","ref":"install-cross.html#variables-for-otp_build-only"},{"type":"extras","doc":"If the cross compilation tools are prefixed by ` -` you probably do\nnot need to set these variables (where ` ` is what has been passed as\n`--host= ` argument to `configure`). Compiler and other tools can\notherwise be identified via variables passed as arguments on the command\nline to `configure`, in then xcomp file, or as environment variables. For\nmore information see the [Important Variables Inspected by configure][]\nsection in [Building and Installing Erlang/OTP][].","title":"Cross Compiler and Other Tools ### - Cross Compiling Erlang/OTP","ref":"install-cross.html#cross-compiler-and-other-tools"},{"type":"extras","doc":"*   `erl_xcomp_sysroot` - The absolute path to the system root of the cross\n    compilation environment. Currently, the `crypto`, `odbc`, `ssh` and\n    `ssl` applications need the system root. These applications will be\n    skipped if the system root has not been set. The system root might be\n    needed for other things too. If this is the case and the system root\n    has not been set, `configure` will fail and request you to set it.\n\n*   `erl_xcomp_isysroot` - The absolute path to the system root for includes\n    of the cross compilation environment. If not set, this value defaults\n    to `$erl_xcomp_sysroot`, i.e., only set this value if the include system\n    root path is not the same as the system root path.","title":"Cross System Root Locations ### - Cross Compiling Erlang/OTP","ref":"install-cross.html#cross-system-root-locations"},{"type":"extras","doc":"These tests cannot (always) be done automatically when cross compiling. You\nusually do not need to set these variables.\n\n> #### Warning {: .warning }\n>\n> Setting these variables wrong may cause hard to detect\n> runtime errors. If you need to change these values, *really* make sure\n> that the values are correct.\n\n> #### Note {: .info }\n>\n> Some of these values will override results of tests performed\n> by `configure`, and some will not be used until `configure` is sure that\n> it cannot figure the result out.\n\nThe `configure` script will issue a warning when a default value is used.\nWhen a variable has been set, no warning will be issued.\n\n*   `erl_xcomp_after_morecore_hook` - `yes|no`. Defaults to `no`. If `yes`,\n    the target system must have a working `__after_morecore_hook` that can be\n    used for tracking used `malloc()` implementations core memory usage.\n    This is currently only used by unsupported features.\n\n*   `erl_xcomp_bigendian` - `yes|no`. No default. If `yes`, the target system\n    must be big endian. If `no`, little endian. This can often be\n    automatically detected, but not always. If not automatically detected,\n    `configure` will fail unless this variable is set. Since no default\n    value is used, `configure` will try to figure this out automatically.\n\t\n*   `erl_xcomp_double_middle` - `yes|no`. Defaults to `no`. \n\tIf `yes`, the target system must have doubles in \"middle-endian\" format. If\n    `no`, it has \"regular\" endianness. \t\n\n*   `erl_xcomp_clock_gettime_cpu_time` - `yes|no`. Defaults to `no`. If `yes`,\n    the target system must have a working `clock_gettime()` implementation\n    that can be used for retrieving process CPU time.\n\n*   `erl_xcomp_getaddrinfo` - `yes|no`. Defaults to `no`. If `yes`, the target\n    system must have a working `getaddrinfo()` implementation that can\n    handle both IPv4 and IPv6.\n\n*   `erl_xcomp_gethrvtime_procfs_ioctl` - `yes|no`. Defaults to `no`. If `yes`,\n    the target system must have a working `gethrvtime()` implementation and\n    is used with procfs `ioctl()`.\n\n*   `erl_xcomp_dlsym_brk_wrappers` - `yes|no`. Defaults to `no`. If `yes`, the\n    target system must have a working `dlsym(RTLD_NEXT,  )` implementation\n    that can be used on `brk` and `sbrk` symbols used by the `malloc()`\n    implementation in use, and by this track the `malloc()` implementations\n    core memory usage. This is currently only used by unsupported features.\n\n*   `erl_xcomp_kqueue` - `yes|no`. Defaults to `no`. If `yes`, the target\n    system must have a working `kqueue()` implementation that returns a file\n    descriptor which can be used by `poll()` and/or `select()`. If `no` and\n    the target system has not got `epoll()` or `/dev/poll`, the kernel-poll\n    feature will be disabled.\n\n*   `erl_xcomp_linux_clock_gettime_correction` - `yes|no`. Defaults to `yes` on\n    Linux; otherwise, `no`. If `yes`, `clock_gettime(CLOCK_MONOTONIC, _)` on\n    the target system must work. This variable is recommended to be set to\n    `no` on Linux systems with kernel versions less than 2.6.\n\n*   `erl_xcomp_linux_nptl` - `yes|no`. Defaults to `yes` on Linux; otherwise,\n    `no`. If `yes`, the target system must have NPTL (Native POSIX Thread\n    Library). Older Linux systems have LinuxThreads instead of NPTL (Linux\n    kernel versions typically less than 2.6).\n\n*   `erl_xcomp_linux_usable_sigaltstack` - `yes|no`. Defaults to `yes` on Linux;\n    otherwise, `no`. If `yes`, `sigaltstack()` must be usable on the target\n    system. `sigaltstack()` on Linux kernel versions less than 2.4 are\n    broken.\n\n*   `erl_xcomp_linux_usable_sigusrx` - `yes|no`. Defaults to `yes`. If `yes`,\n    the `SIGUSR1` and `SIGUSR2` signals must be usable by the ERTS. Old\n    LinuxThreads thread libraries (Linux kernel versions typically less than\n    2.2) used these signals and made them unusable by the ERTS.\n\n*   `erl_xcomp_poll` - `yes|no`. Defaults to `no` on Darwin/MacOSX; otherwise,\n    `yes`. If `yes`, the target system must have a working `poll()`\n    implementation that also can handle devices. If `no`, `select()` will be\n    used instead of `poll()`.\n\n*   `erl_xcomp_putenv_copy` - `yes|no`. Defaults to `no`. If `yes`, the target\n    system must have a `putenv()` implementation that stores a copy of the\n    key/value pair.\n\n*   `erl_xcomp_reliable_fpe` - `yes|no`. Defaults to `no`. If `yes`, the target\n    system must have reliable floating point exceptions.\n\n*   `erl_xcomp_posix_memalign` - `yes|no`. Defaults to `yes` if `posix_memalign`\n    system call exists; otherwise `no`. If `yes`, the target system must have a\n    `posix_memalign` implementation that accepts larger than page size\n    alignment.\n\n*   `erl_xcomp_code_model_small` - `yes|no`. Default to `no`. If `yes`, the target\n    system must place the beam.smp executable in the lower 2 GB of memory. That is it\n    should not use position independent executable.\n\n\n[Building and Installing Erlang/OTP]: INSTALL.md\n[How to Build the Documentation]: INSTALL.md#How-to-Build-and-Install-Erlang-OTP_How-to-Build-the-Documentation\n[Important Variables Inspected by configure]: INSTALL.md#advanced-configuration-and-build-of-erlang-otp_Configuring_Important-Variables-Inspected-by-configure\n[cross configuration variables]: #currently-used-configuration-variables\n[DESTDIR]: http://www.gnu.org/prep/standards/html_node/DESTDIR.html\n[?TOC]: true\n[Cross Building the System]: #cross-building-the-system","title":"Optional Feature, and Bug Tests ### - Cross Compiling Erlang/OTP","ref":"install-cross.html#optional-feature-and-bug-tests"},{"type":"extras","doc":"Building Erlang/OTP on Windows\n==============================\n\nIntroduction\n------------\n\nThis section describes how to build the Erlang emulator and the OTP\nlibraries on Windows. Note that the Windows binary releases are still\na preferred alternative if one does not have Microsoft’s development\ntools and/or don’t want to install WSL. You can download the binary\nreleases from  .\n\nThe instructions apply to Windows 10 (v.1809 and later) supporting the\nWSL.1 (Windows Subsystem for Linux v.1) and using Ubuntu 18.04 release.\n\nThe procedure described uses WSL as a build environment.  You run the\nbash shell in WSL and use the gnu configure/make etc to do\nthe build. The emulator C-source code is, however, mostly compiled\nwith Microsoft Visual C++™, producing a native Windows binary. This is\nthe same procedure as we use to build the pre-built binaries. Why we\nuse VC++ and not gcc is explained further in the FAQ section.\n\nThese instructions apply for both 32-bit and 64-bit Windows. Note that\neven if you build a 64-bit version of Erlang, most of the directories\nand files involved are still named win32. Some occurrences of the name\nwin64 are however present. The installation file for a 64-bit Windows\nversion of Erlang, for example, is `otp_win64_27.exe`.\n\nIf you feel comfortable with the environment and build\nsystem, and have all the necessary tools, you have a great opportunity\nto make the Erlang/OTP distribution for Windows better. Please submit\nany suggestions or patches to our [git project] [1] to let\nthem find their way into the next version of Erlang. If making changes\nto the build system (like makefiles etc) please bear in mind that the\nsame makefiles are used on Unix, so that your changes\ndon't break other platforms. That of course goes for C-code too; system\nspecific code resides in the `$ERL_TOP/erts/emulator/sys/win32` and\n`$ERL_TOP/erts/etc/win32` directories mostly. The\n`$ERL_TOP/erts/emulator/beam` directory is for common code.\n\n\nShort Version\n-------------\n\nIn the following sections, we've described as much as we could about\nthe installation of the tools needed. Once the tools are installed,\nbuilding is quite easy. We have also tried to make these instructions\nunderstandable for people with limited Unix experience. WSL is a whole\nnew environment to some Windows users, why careful explanation of\nenvironment variables etc seemed to be in place.\n\nThis is the short story though, for the experienced and impatient:\n\n*   Get and install complete WSL environment\n\n*   Install Visual Studio 2019\n\n*   Get and install windows JDK-8\n\n*   Get and install windows NSIS 3.05 or later (3.05 tried and working)\n\n*   Get, build and install OpenSSL v1.1.1d or later (up to 1.1.1d\n    tried & working) with static libs.\n\n*   Get, build and install wxWidgets-3.2.2.1 or later (up to that\n    version tried & working) with static libs.\n\n*   Get the Erlang source distribution (from\n     ) and unpack with `tar`\n    to the windows disk for example to: /mnt/c/src/\n\n*   Install mingw-gcc, and make: `sudo apt update && sudo apt install g++-mingw-w64 gcc-mingw-w64 make`\n\n*   `$ cd UNPACK_DIR`\n\n*   Modify PATH and other environment variables so that all these tools\n    are runnable from a bash shell. Still standing in `$ERL_TOP`, issue\n    the following commands (for 32-bit Windows, remove the x64 from the\n    first row and change `otp_win64_27` to `otp_win32_27` on\n    the last row):\n\n        $ eval `./otp_build env_win32 x64`\n        $ ./otp_build configure\n        $ ./otp_build boot -a\n        $ ./otp_build release -a\n        $ ./otp_build installer_win32\n        $ release/win32/otp_win64_27 /S\n\nVoila! `Start->Programs->Erlang OTP 27->Erlang` starts the Erlang\nWindows shell.\n\n\nTools you Need and Their Environment\n------------------------------------\n\nYou need some tools to be able to build Erlang/OTP on Windows. Most\nnotably you'll need WSL (with ubuntu), Visual Studio and\nMicrosofts Windows SDK, but you might also want a Java compiler, the\nNSIS install system, OpenSSL and wxWidgets. Well, here's some information about\nthe different tools:\n\n*   WSL: Install WSL and Ubuntu in Windows 10\n     \n\n    We have used and tested with WSL-1, WSL-2 was not available and may\n    not be preferred when building Erlang/OTP since access to the windows\n    disk is (currently) slower WSL-2.\n\n*   Visual Studio 2019\n    Download and run the installer from:\n       \n    Install C++ and SDK packages to the default installation directory.\n\n*   Java JDK 8 or later  (optional)\n    If you don't care about Java, you can skip this step. The\n    result will be that jinterface is not built.\n\n    Our Java code (jinterface, ic) is tested on windows with JDK 8.\n    Get it for Windows and install it, the JRE is not enough.\n\n    URL:  \n\n    Add javac to your path environment, in my case this means:\n\n    `PATH=\"/mnt/c/Program\\ Files/Java/jdk1.8.0_241/bin:$PATH`\n\n    No `CLASSPATH` or anything is needed. Type `javac.exe` in the bash prompt\n    and you should get a list of available Java options.\n\n*   Nullsoft NSIS installer system (optional)\n    You need this to build the self installing package.\n\n    Download and run the installer from:\n    URL:  \n\n    Add 'makensis.exe' to your path environment:\n\n    `PATH=\"/mnt/c/Program\\ Files/NSIS/Bin:$PATH`\n\n    Type `which makensis.exe` in the bash prompt and you should get the\n    path to the program.\n\n*   OpenSSL (optional)\n    You need this to build crypto, ssh and ssl libs.\n\n    We recommend v1.1.1d or later.\n    There are prebuilt available binaries, which you can just\n    download and install, available here:\n    URL:  \n\n    Install into `C:/OpenSSL-Win64` (or `C:/OpenSSL-Win32`)\n\n*   wxWidgets (optional)\n    You need this to build wx to use gui's in debugger and observer.\n\n    We recommend v3.2.2.1 or later.\n    Unpack into `c:/opt/local64/pgm/wxWidgets-3.2.2.1`\n\n    If the `wxUSE_POSTSCRIPT` isn't enabled in  `c:/opt/local64/pgm/wxWidgets-3.2.2.1/include/wx/msw/setup.h`,\n    enable it.\n\n    We recommend to enable for wxWebView wxUSE_WEBVIEW_EDGE.\n    *   Download the nuget package 'Microsoft.Web.WebView2' (Version 0.9.488 or newer)\n    *   Extract the package (it's a zip archive) to wxWidgets/3rdparty/webview2 (you should have 3rdparty/webview2/build/native/include/WebView2.h file after unpacking it)\n    *   Enable wxUSE_WEBVIEW_EDGE in `c:/opt/local64/pgm/wxWidgets-3.2.2.1/include/wx/msw/setup.h`\n\n    Build with:\n\n    ```text\n    C:\\...\\> cd c:\\opt\\local64\\pgm\\wxWidgets-3.2.2.1\\build\\msw\n    C:\\...\\> nmake TARGET_CPU=amd64 BUILD=release SHARED=0 DIR_SUFFIX_CPU= -f makefile.vc\n    ```\n\n    Remove the `TARGET_CPU=amd64` for 32bit build.\n\n*   Get the Erlang source distribution (from  ).\n    The same as for Unix platforms. Preferably use tar to\n    unpack the source tar.gz (`tar zxf otp_src_27.tar.gz`) to somewhere\n    on the windows disk, `/mnt/c/path/to/otp_src`\n\n    NOTE: It is important that source on the windows disk.\n\n    Set the environment `ERL_TOP` to point to the root directory of the\n    source distribution. Let's say I stood in `/mnt/c/src` and unpacked\n    `otp_src_27.tar.gz`, I then add the following to `.profile`:\n    \n    ```text\n    ERL_TOP=/mnt/c/src/otp_src_27\n    export ERL_TOP\n    ```\n\n\nThe Shell Environment\n---------------------\n\nThe path variable should now contain the windows paths to javac.exe and makensis.exe.\n\nSetup the environment with:\n\n    $ export PATH\n    $ cd /mnt/c/path/to/otp_src/\n    $ eval `./otp_build env_win32 x64`\n\nThis should setup the additional environment variables.\n\nThis should do the final touch to the environment and building should\nbe easy after this. You could run `./otp_build env_win32` without\n`eval` just to see what it does, and to see that the environment it\nsets seems OK. The path is cleaned of spaces if possible (using DOS\nstyle short names instead), the variables `OVERRIDE_TARGET`, `CC`, `CXX`,\n`AR` and `RANLIB` are set to their respective wrappers and the directories\n`$ERL_TOP/erts/etc/win32/wsl_tools/vc` and\n`$ERL_TOP/erts/etc/win32/wsl_tools` are added first in the PATH.\n\nNow you can check which erlc you have by writing `type erlc` in your shell.\nIt should reside in `$ERL_TOP/erts/etc/win32/wsl_tools`.\n\nAnd running `cl.exe` should print the Microsoft compiler usage message.\n\nThe needed compiler environment variables are setup inside `otp_build`\nvia `erts/etc/win32/wsl_tools/SetupWSLcross.bat`. It contains some\nhardcoded paths, if your installation path is different it can be added\nto that file.\n\n\nBuilding and Installing\n-----------------------\n\nBuilding is easiest using the `otp_build` script:\n\n    $ ./otp_build configure  \n    $ ./otp_build boot -a\n    $ ./otp_build release -a  \n    $ ./otp_build installer_win32   # optional\n\nNow you will have a file called `otp_win32_27.exe` or `otp_win64_27.exe`\nin the ` `, i.e. `$ERL_TOP/release/win32`.\n\nLets get into more detail:\n\n1.  `$ ./otp_build configure` - This runs the newly generated configure\n    scripts with options making configure behave nicely. The target machine\n    type is plainly `win32`, so a lot of the configure-scripts recognize\n    this awkward target name and behave accordingly. The CC variable also\n    makes the compiler be `cc.sh`, which wraps MSVC++, so all configure\n    tests regarding the C compiler gets to run the right compiler. A lot of\n    the tests are not needed on Windows, but we thought it best to run the\n    whole configure anyway.\n\n2.  `$ ./otp_build boot -a` - This uses the bootstrap directory (shipped\n    with the source, `$ERL_TOP/bootstrap`) to build a complete OTP\n    system. When this is done you can run erl from within the source tree;\n    just type `$ERL_TOP/bin/erl` and you should have the prompt.\n\n3.  `$ ./otp_build release -a` - Builds a commercial release tree from the\n    source tree. The default is to put it in `$ERL_TOP/release/win32`. You can\n    give any directory as parameter, but it doesn't really\n    matter if you're going to build a self extracting installer too.\n\n4.  `$ ./otp_build installer_win32` - Creates the self extracting installer executable.\n    The executable `otp_win32_27.exe` or `otp_win64_27.exe` will be placed\n    in the top directory of the release created in the previous step. If\n    no release directory is specified, the release is expected to have\n    been built to `$ERL_TOP/release/win32`, which also will be the place\n    where the installer executable will be placed. If you specified some\n    other directory for the release (i.e. `./otp_build release -a\n    /tmp/erl_release`), you're expected to give the same parameter here,\n    (i.e. `./otp_build installer_win32 /tmp/erl_release`). You need to have\n    a full NSIS installation and `makensis.exe` in your path for this to\n    work. Once you have created the installer, you can run it to\n    install Erlang/OTP in the regular way, just run the executable and\n    follow the steps in the installation wizard. To get all default settings\n    in the installation without any questions asked, you run the executable\n    with the parameter `/S` (capital S) like in:\n\n        $ cd $ERL_TOP\n        $ release/win32/otp_win32_27 /S\n        ...\n\n    or\n\n        $ cd $ERL_TOP\n        $ release/win32/otp_win64_27 /S\n        ...\n\n\n    and after a while Erlang/OTP-27 will have been installed in\n    `C:\\Program Files\\erl%ERTS-VSN%\\`, with shortcuts in the menu etc.\n\n\nDevelopment\n-----------\n\nOnce the system is built, you might want to change it. Having a test\nrelease in some nice directory might be useful, but you can also run\nErlang from within the source tree. The target `local_setup`, makes\nthe program `$ERL_TOP/bin/erl.exe` usable and it also uses all the OTP\nlibraries in the source tree.\n\nIf you hack the emulator, you can build the emulator executable\nby standing in `$ERL_TOP/erts/emulator` and do a simple\n\n    $ make opt\n\nNote that you need to have run ``(cd $ERL_TOP && eval `./otp_build env_win32`)``\nin the particular shell before building anything on Windows. After\ndoing a make opt you can test your result by running `$ERL_TOP/bin/erl`.\nIf you want to copy the result to a release directory (say\n`/tmp/erl_release`), you do this (still in  `$ERL_TOP/erts/emulator`)\n\n    $ make TESTROOT=/tmp/erl_release release\n\nThat will copy the emulator executables.\n\nTo make a debug build of the emulator, you need to recompile both\n`beam.dll` (the actual runtime system) and `erlexec.dll`. Do like this\n\n    $ cd $ERL_TOP\n    $ rm bin/win32/erlexec.dll\n    $ cd erts/emulator\n    $ make debug\n    $ cd ../etc\n    $ make debug\n\nand sometimes\n\n    $ cd $ERL_TOP\n    $ make local_setup\n\nSo now when you run `$ERL_TOP/erl.exe`, you should have a debug compiled\nemulator, which you will see if you do a:\n\n    1> erlang:system_info(system_version).\n\nin the erlang shell. If the returned string contains `[debug]`, you\ngot a debug compiled emulator.\n\nTo hack the erlang libraries, you simply do a `make opt` in the\nspecific \"applications\" directory, like:\n\n    $ cd $ERL_TOP/lib/stdlib\n    $ make opt\n\nor even in the source directory...\n\n    $ cd $ERL_TOP/lib/stdlib/src\n    $ make opt\n\nNote that you're expected to have a fresh Erlang in your path when\ndoing this, preferably the plain 27 you have built in the previous\nsteps. You could also add `$ERL_TOP/bootstrap/bin` to your `PATH` before\nrebuilding specific libraries. That would give you a good enough\nErlang system to compile any OTP erlang code.  Setting up the path\ncorrectly is a little bit tricky. You still need to have\n`$ERL_TOP/erts/etc/win32/wsl_tools/vc` and\n`$ERL_TOP/erts/etc/win32/wsl_tools` *before* the actual emulator\nin the path. A typical setting of the path for using the bootstrap\ncompiler would be:\n\n    $ export PATH=$ERL_TOP/erts/etc/win32/wsl_tools/vc\\\n    :$ERL_TOP/erts/etc/win32/wsl_tools:$ERL_TOP/bootstrap/bin:$PATH\n\nThat should make it possible to rebuild any library without hassle...\n\nIf you want to copy a library (an application) newly built, to a\nrelease area, you do like with the emulator:\n\n    $ cd $ERL_TOP/lib/stdlib\n    $ make TESTROOT=/tmp/erlang_release release\n\nRemember that:\n\n*   Windows specific C-code goes in the `$ERL_TOP/erts/emulator/sys/win32`,\n    `$ERL_TOP/erts/emulator/drivers/win32` or `$ERL_TOP/erts/etc/win32`.\n\n*   Windows specific erlang code should be used conditionally and the\n    host OS tested in *runtime*, the exactly same beam files should be\n    distributed for every platform! So write code like:\n\n        case os:type() of\n            {win32,_} ->\n                do_windows_specific();\n            Other ->\n                do_fallback_or_exit()\n        end,\n\nThat's basically all you need to get going.\n\n\n\nFrequently Asked Questions\n--------------------------\n\n*   Q: So, now I can build Erlang using GCC on Windows?\n\n    A: No, unfortunately not. You'll need Microsoft's Visual C++\n    still. A Bourne-shell script (cc.sh) wraps the Visual C++ compiler\n    and runs it from within the WSL environment. All other tools\n    needed to build Erlang are free-ware/open source, but not the C\n    compiler.\n\n*   Q: Why haven't you got rid of VC++ then, you \\*\\*\\*\\*\\*\\*?\n\n    A: Well, partly because it's a good compiler - really! Actually it's\n    been possible in late R11-releases to build using mingw instead of\n    visual C++ (you might see the remnants of that in some scripts and\n    directories). Unfortunately the development of the SMP version for\n    Windows broke the mingw build and we chose to focus on the VC++ build\n    as the performance has been much better in the VC++ versions. The\n    mingw build will possibly be back, but as long as VC++ gives better\n    performance, the commercial build will be a VC++ one.\n\n*   Q: Hah, I saw you, you used GCC even though you said you didn't!\n\n    A: OK, I admit, one of the files is compiled using\n    MinGW's GCC and the resulting object code is then converted to MS\n    VC++ compatible coff using a small C hack. It's because that\n    particular file, `beam_emu.c` benefits immensely from being able\n    to use the GCC labels-as-values extension, which boosts emulator\n    performance by up to 50%. That does unfortunately not (yet) mean\n    that all of OTP could be compiled using GCC. That particular\n    source code does not do anything system specific and actually is\n    adopted to the fact that GCC is used to compile it on Windows.\n\n*   Q: So now there's a MS VC++ project file somewhere and I can build OTP\n    using the nifty VC++ GUI?\n\n    A: No, never. The hassle of keeping the project files up to date and\n    do all the steps that constitute an OTP build from within the VC++ GUI\n    is simply not worth it, maybe even impossible. A VC++ project\n    file for Erlang/OTP will never happen.\n\n*   Q: So how does it all work then?\n\n    A: WSL/Ubuntu is the environment, it's almost like you had a\n    virtual Unix machine inside Windows. Configure, given certain\n    parameters, then creates makefiles that are used by the\n    environment's gnu-make to built the system. Most of the actual\n    compilers etc are not, however, WSL tools, so we've written\n    a couple of wrappers (Bourne-shell scripts), which reside in\n    `$ERL_TOP/etc/win32/wsl_tools`. They all do conversion of\n    parameters and switches common in the Unix environment to fit the\n    native Windows tools. Most notable is of course the paths, which\n    in WSL are Unix-like paths with \"forward slashes\" (/) and\n    no drive letters. The WSL specific command `wslpath` is used\n    for most of the path conversions in a WSL environment.\n    Luckily most compilers accept forward slashes instead\n    of backslashes as path separators, but one still have to get the drive\n    letters etc right, though. The wrapper scripts are not general in\n    the sense that, for example, cc.sh would understand and translate\n    every possible gcc option and pass correct options to\n    cl.exe. The principle is that the scripts are powerful enough to\n    allow building of Erlang/OTP, no more, no less. They might need\n    extensions to cope with changes during the development of Erlang, and\n    that's one of the reasons we made them into shell-scripts and not\n    Perl-scripts. We believe they are easier to understand and change\n    that way.\n\n    In `$ERL_TOP`, there is a script called `otp_build`. That script handles\n    the hassle of giving all the right parameters to `configure`/`make` and\n    also helps you set up the correct environment variables to work with\n    the Erlang source under WSL.\n\n*   Q: Can I build something that looks exactly as the commercial release?\n\n    A: Yes, we use the exact same build procedure.\n\n*   Q: Which version of WSL and other tools do you use then?\n\n    A:  We use WSL 1 with Ubuntu 18.04.\n    The GCC we used for 27 was version 7.3-win32.\n    We used Visual studio 2019, Sun's JDK 1.8.0\\_241,\n    NSIS 3.05, Win32 OpenSSL 1.1.1d and wxWidgets-3.1.3.\n\n\n   [1]: https://github.com/erlang/otp\n\n   [?TOC]: true","title":"Building Erlang/OTP on Windows","ref":"install-win32.html"},{"type":"extras","doc":"Patching OTP Applications\n=========================\n\nIntroduction\n------------\n\nThis document describes the process of patching an existing OTP\ninstallation with one or more Erlang/OTP applications of newer versions\nthan already installed. The tool `otp_patch_apply` is available for this\nspecific purpose. It resides in the top directory of the Erlang/OTP\nsource tree.\n\nThe `otp_patch_apply` tool utilizes the [runtime_dependencies][] tag in\nthe [application resource file][]. This information is used to determine\nif the patch can be installed in the given Erlang/OTP installation\ndirectory.\n\nRead more about the [version handling][] introduced in Erlang/OTP release\n17, which also describes how to determine if an installation includes one\nor more patched applications.\n\nIf you want to apply patches of multiple OTP applications that resides\nin different OTP versions, you have to apply these patches in multiple\nsteps. It is only possible to apply multiple OTP applications from the\nsame OTP version at once.\n\nPrerequisites\n-------------\n\nIt's assumed that the reader is familiar with\n[building and installing Erlang/OTP][]. To be able to patch an\napplication, the following must exist:\n\n* An Erlang/OTP installation.\n\n* An Erlang/OTP source tree containing the updated applications that\n  you want to patch into the existing Erlang/OTP installation.\n\nUsing otp\\_patch\\_apply\n-----------------------\n\n> #### Warning {: .warning }\n>\n> Patching applications is a one-way process.\n> Create a backup of your OTP installation directory before\n> proceeding.\n\nFirst of all, build the OTP source tree at `$ERL_TOP` containing\nthe updated applications.\n\n> #### Note {: .info }\n>\n> Before applying a patch you need to do a *full* build\n> of OTP in the source directory.\n\nConfigure and build all applications in OTP:\n\n\t$ configure\n\t$ make\n\nor\n\n\t$ ./otp_build configure\n\t$ ./otp_build boot -a\n\nIf you have installed documentation in the OTP installation, also\nbuild the documentation:\n\n\t$ make docs\n\nAfter the successful build it's time to patch. The source tree directory,\nthe directory of the installation and the applications to patch are given\nas arguments to `otp_patch_apply`. The dependencies of each application\nare validated against the applications in the installation and the other\napplications given as arguments. If a dependency error is detected, the\nscript will be aborted.\n\nThe `otp_patch_apply` syntax:\n\n\t$ otp_patch_apply -s   -i   [-l  ] [-c] [-f] [-h] \\\n          [-n] [-v]   [...  ]\n\t\n\t-s    -- OTP source directory that contains build results.\n\t-i    -- OTP installation directory to patch.\n\t-l    -- Alternative OTP source library directory path(s)\n\t             containing build results of OTP applications.\n\t             Multiple paths should be colon separated.\n\t-c        -- Cleanup (remove) old versions of applications\n\t             patched in the installation.\n\t-f        -- Force patch of application(s) even though\n\t             dependencies are not fulfilled (should only be\n\t             considered in a test environment).\n\t-h        -- Print help then exit.\n\t-n        -- Do not install documentation.\n\t-v        -- Print version then exit.\n\t     -- Application to patch.\n\t\n\tEnvironment Variable:\n\t  ERL_LIBS  -- Alternative OTP source library directory path(s)\n\t               containing build results of OTP applications.\n\t               Multiple paths should be colon separated.\n\n> #### Note {: .info }\n>\n> The complete build environment is required while running\n> `otp_patch_apply`.\n\n> #### Note {: .info }\n>\n> All source directories identified by `-s` and `-l` should\n> contain build results of OTP applications.\n\nFor example, if the user wants to install patched versions of `mnesia`\nand `ssl` built in `/home/me/git/otp` into the OTP installation\nlocated in `/opt/erlang/my_otp` type\n\n\t$ otp_patch_apply -s /home/me/git/otp -i /opt/erlang/my_otp \\\n\t  mnesia ssl\n\n> #### Note {: .info }\n>\n> If the list of applications contains core applications,\n> i.e `erts`, `kernel`, `stdlib` or `sasl`, the `Install` script in\n> the patched Erlang/OTP installation must be rerun.\n\nThe patched applications are appended to the list of installed\napplications. Take a look at\n` /releases/OTP-REL/installed_application_versions`.\n\nSanity check\n------------\n\nThe application dependencies can be checked using the Erlang shell.\nApplication dependencies are verified among installed applications by\n`otp_patch_apply`, but these are not necessarily those actually loaded.\nBy calling `system_information:sanity_check()` one can validate\ndependencies among applications actually loaded.\n\n```\n1> system_information:sanity_check().\nok\n```\n\nPlease take a look at the reference of [sanity_check()][] for more\ninformation.\n\n[application resource file]: `e:kernel:app.md`\n[runtime_dependencies]: `e:kernel:app.md#runtime_dependencies`\n[building and installing Erlang/OTP]: INSTALL.md\n[version handling]: `e:system:versions.md`\n[sanity_check()]: `system_information:sanity_check/0`","title":"Patching OTP Applications","ref":"otp-patch-apply.html"},{"type":"extras","doc":"<!--\n%CopyrightBegin%\n\nCopyright Ericsson AB 2023-2024. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# Introduction\n\nThis section is a quick start tutorial to get you started with Erlang.\nEverything in this section is true, but only part of the truth. For example,\nonly the simplest form of the syntax is shown, not all esoteric forms. Also,\nparts that are greatly simplified are indicated with _manual_. This means that a\nlot more information on the subject is to be found in the Erlang book or in\n[Erlang Reference Manual](`e:system:reference_manual.md`).","title":"Introduction","ref":"getting_started.html"},{"type":"extras","doc":"The reader of this section is assumed to be familiar with the following:\n\n- Computers in general\n- Basics on how computers are programmed","title":"Prerequisites - Introduction","ref":"getting_started.html#prerequisites"},{"type":"extras","doc":"The following topics are not treated in this section:\n\n- References.\n- Local error handling (catch/throw).\n- Single direction links (monitor).\n- Handling of binary data (binaries / bit syntax).\n- List comprehensions.\n- How to communicate with the outside world and software written in other\n  languages (ports); this is described in\n  [Interoperability Tutorial](`e:system:tutorial.md`).\n- Erlang libraries (for example, file handling).\n- OTP and (in consequence) the Mnesia database.\n- Hash tables for Erlang terms (ETS).\n- Changing code in running systems.","title":"Omitted Topics - Introduction","ref":"getting_started.html#omitted-topics"},{"type":"extras","doc":"<!--\n%CopyrightBegin%\n\nCopyright Ericsson AB 2023-2024. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# Sequential Programming","title":"Sequential Programming","ref":"seq_prog.html"},{"type":"extras","doc":"Most operating systems have a command interpreter or shell, UNIX and Linux have\nmany, Windows has the command prompt, powershell and more. Erlang has its own shell\nwhere bits of Erlang code can be written directly, and be evaluated to see what happens (see\nthe `m:shell` manual page in STDLIB).\n\nStart the Erlang shell (in Linux or UNIX) by starting a shell or command\ninterpreter in your operating system and typing `erl`. You will see something\nlike this.\n\n```text\n$ erl\nErlang R15B (erts-5.9.1) [source] [smp:8:8] [rq:8] [async-threads:0] [hipe] [kernel-poll:false]\n\nEshell V5.9.1  (abort with ^G)\n1>\n```\n\nType `2 + 5.` in the shell and then press Enter (carriage return). Notice that\nyou tell the shell you are done entering code by finishing with a full stop `.`\nand a carriage return.\n\n```erlang\n1> 2 + 5.\n7\n2> \n```\n\nAs shown, the Erlang shell numbers the lines that can be entered, (as 1> 2>) and\nthat it correctly says that 2 + 5 is 7. If you make writing mistakes in the\nshell, you can delete with the backspace key, as in most shells. There are many\nmore editing commands in the shell (see\n[tty - A command line interface](`e:erts:tty.md`) in ERTS User's Guide).\n\n(Notice that many line numbers given by the shell in the following examples are\nout of sequence. This is because this tutorial was written and code-tested in\nseparate sessions).\n\nHere is a bit more complex calculation:\n\n```erlang\n2> (42 + 77) * 66 / 3.\n2618.0\n```\n\nNotice the use of brackets, the multiplication operator `*`, and the division\noperator `/`, as in normal arithmetic (see\n[Expressions](`e:system:expressions.md`)).\n\nPress Control-C to shut down the Erlang system and the Erlang shell.\n\nThe following output is shown:\n\n```text\nBREAK: (a)bort (c)ontinue (p)roc info (i)nfo (l)oaded\n       (v)ersion (k)ill (D)b-tables (d)istribution\na\n$\n```\n\nType `a` to leave the Erlang system.\n\nAnother way to shut down the Erlang system is by entering `halt/0`:\n\n```erlang\n3> halt().\n$\n```","title":"The Erlang Shell - Sequential Programming","ref":"seq_prog.html#the-erlang-shell"},{"type":"extras","doc":"A programming language is not much use if you only can run code from the shell.\nSo here is a small Erlang program. Enter it into a file named `tut.erl` using a\nsuitable text editor. The file name `tut.erl` is important, and also that it is\nin the same directory as the one where you started `erl`). If you are lucky your\neditor has an Erlang mode that makes it easier for you to enter and format your\ncode nicely (see [The Erlang mode for Emacs](`e:tools:erlang_mode_chapter.md`)\nin Tools User's Guide), but you can manage perfectly well without. Here is the\ncode to enter:\n\n```erlang\n-module(tut).\n-export([double/1]).\n\ndouble(X) ->\n    2 * X.\n```\n\nIt is not hard to guess that this program doubles the value of numbers. The\nfirst two lines of the code are described later. Let us compile the program.\nThis can be done in an Erlang shell as follows, where `c` means compile:\n\n```erlang\n3> c(tut).\n{ok,tut}\n```\n\nThe `{ok,tut}` means that the compilation is OK. If it says `error` it means\nthat there is some mistake in the text that you entered. Additional error\nmessages gives an idea to what is wrong so you can modify the text and then try\nto compile the program again.\n\nNow run the program:\n\n```erlang\n4> tut:double(10).\n20\n```\n\nAs expected, double of 10 is 20.\n\nNow let us get back to the first two lines of the code. Erlang programs are\nwritten in files. Each file contains an Erlang _module_. The first line of code\nin the module is the module name (see [Modules](`e:system:modules.md`)):\n\n```erlang\n-module(tut).\n```\n\nThus, the module is called _tut_. Notice the full stop `.` at the end of the\nline. The files which are used to store the module must have the same name as\nthe module but with the extension `.erl`. In this case the file name is\n`tut.erl`. When using a function in another module, the syntax\n`module_name:function_name(arguments)` is used. So the following means call\nfunction `double` in module `tut` with argument `10`.\n\n```erlang\n4> tut:double(10).\n```\n\nThe second line says that the module `tut` contains a function called `double`,\nwhich takes one argument (`X` in our example):\n\n```erlang\n-export([double/1]).\n```\n\nThe second line also says that this function can be called from outside the\nmodule `tut`. More about this later. Again, notice the `.` at the end of the\nline.\n\nNow for a more complicated example, the factorial of a number. For example, the\nfactorial of 4 is 4 _ 3 _ 2 * 1, which equals 24.\n\nEnter the following code in a file named `tut1.erl`:\n\n```erlang\n-module(tut1).\n-export([fac/1]).\n\nfac(1) ->\n    1;\nfac(N) ->\n    N * fac(N - 1).\n```\n\nSo this is a module, called `tut1` that contains a function called `fac>`, which\ntakes one argument, `N`.\n\nThe first part says that the factorial of 1 is 1.:\n\n```erlang\nfac(1) ->\n    1;\n```\n\nNotice that this part ends with a semicolon `;` that indicates that there is\nmore of the function `fac>` to come.\n\nThe second part says that the factorial of N is N multiplied by the factorial of\nN - 1:\n\n```erlang\nfac(N) ->\n    N * fac(N - 1).\n```\n\nNotice that this part ends with a `.` saying that there are no more parts of\nthis function.\n\nCompile the file:\n\n```erlang\n5> c(tut1).\n{ok,tut1}\n```\n\nAnd now calculate the factorial of 4.\n\n```erlang\n6> tut1:fac(4).\n24\n```\n\nHere the function `fac>` in module `tut1` is called with argument `4`.\n\nA function can have many arguments. Let us expand the module `tut1` with the\nfunction to multiply two numbers:\n\n```erlang\n-module(tut1).\n-export([fac/1, mult/2]).\n\nfac(1) ->\n    1;\nfac(N) ->\n    N * fac(N - 1).\n\nmult(X, Y) ->\n    X * Y.\n```\n\nNotice that it is also required to expand the `-export` line with the\ninformation that there is another function `mult` with two arguments.\n\nCompile:\n\n```erlang\n7> c(tut1).\n{ok,tut1}\n```\n\nTry out the new function `mult`:\n\n```erlang\n8> tut1:mult(3,4).\n12\n```\n\nIn this example the numbers are integers and the arguments in the functions in\nthe code `N`, `X`, and `Y` are called variables. Variables must start with a\ncapital letter (see [Variables](`e:system:expressions.md`)). Examples of\nvariables are `Number`, `ShoeSize`, and `Age`.","title":"Modules and Functions - Sequential Programming","ref":"seq_prog.html#modules-and-functions"},{"type":"extras","doc":"Atom is another data type in Erlang. Atoms start with a small letter (see\n[Atom](`e:system:data_types.md`)), for example, `charles`, `centimeter`, and\n`inch`. Atoms are simply names, nothing else. They are not like variables, which\ncan have a value.\n\nEnter the next program in a file named `tut2.erl`). It can be useful for\nconverting from inches to centimeters and conversely:\n\n```erlang\n-module(tut2).\n-export([convert/2]).\n\nconvert(M, inch) ->\n    M / 2.54;\n\nconvert(N, centimeter) ->\n    N * 2.54.\n```\n\nCompile:\n\n```erlang\n9> c(tut2).\n{ok,tut2}\n```\n\nTest:\n\n```erlang\n10> tut2:convert(3, inch).\n1.1811023622047243\n11> tut2:convert(7, centimeter).\n17.78\n```\n\nNotice the introduction of decimals (floating point numbers) without any\nexplanation. Hopefully you can cope with that.\n\nLet us see what happens if something other than `centimeter` or `inch` is\nentered in the `convert` function:\n\n```erlang\n12> tut2:convert(3, miles).\n** exception error: no function clause matching tut2:convert(3,miles) (tut2.erl, line 4)\n```\n\nThe two parts of the `convert` function are called its clauses. As shown,\n`miles` is not part of either of the clauses. The Erlang system cannot _match_\neither of the clauses so an error message `function_clause` is returned. The\nshell formats the error message nicely, but the error tuple is saved in the\nshell's history list and can be output by the shell command `v/1`:\n\n```erlang\n13> v(12).\n{'EXIT',{function_clause,[{tut2,convert,\n                                [3,miles],\n                                [{file,\"tut2.erl\"},{line,4}]},\n                          {erl_eval,do_apply,6,\n                                    [{file,\"erl_eval.erl\"},{line,677}]},\n                          {shell,exprs,7,[{file,\"shell.erl\"},{line,687}]},\n                          {shell,eval_exprs,7,[{file,\"shell.erl\"},{line,642}]},\n                          {shell,eval_loop,3,\n                                 [{file,\"shell.erl\"},{line,627}]}]}}\n```","title":"Atoms - Sequential Programming","ref":"seq_prog.html#atoms"},{"type":"extras","doc":"Now the `tut2` program is hardly good programming style. Consider:\n\n```erlang\ntut2:convert(3, inch).\n```\n\nDoes this mean that 3 is in inches? Or does it mean that 3 is in centimeters and\nis to be converted to inches? Erlang has a way to group things together to make\nthings more understandable. These are called _tuples_ and are surrounded by\ncurly brackets, `{` and `}`.\n\nSo, `{inch,3}` denotes 3 inches and `{centimeter,5}` denotes 5 centimeters. Now\nlet us write a new program that converts centimeters to inches and conversely.\nEnter the following code in a file called `tut3.erl`):\n\n```erlang\n-module(tut3).\n-export([convert_length/1]).\n\nconvert_length({centimeter, X}) ->\n    {inch, X / 2.54};\nconvert_length({inch, Y}) ->\n    {centimeter, Y * 2.54}.\n```\n\nCompile and test:\n\n```erlang\n14> c(tut3).\n{ok,tut3}\n15> tut3:convert_length({inch, 5}).\n{centimeter,12.7}\n16> tut3:convert_length(tut3:convert_length({inch, 5})).\n{inch,5.0}\n```\n\nNotice on line 16 that 5 inches is converted to centimeters and back again and\nreassuringly get back to the original value. That is, the argument to a function\ncan be the result of another function. Consider how line 16 (above) works. The\nargument given to the function `{inch,5}` is first matched against the first\nhead clause of `convert_length`, that is, `convert_length({centimeter,X})`. It\ncan be seen that `{centimeter,X}` does not match `{inch,5}` (the head is the bit\nbefore the `->`). This having failed, let us try the head of the next clause\nthat is, `convert_length({inch,Y})`. This matches, and `Y` gets the value 5.\n\nTuples can have more than two parts, in fact as many parts as you want, and\ncontain any valid Erlang _term_. For example, to represent the temperature of\nvarious cities of the world:\n\n```erlang\n{moscow, {c, -10}}\n{cape_town, {f, 70}}\n{paris, {f, 28}}\n```\n\nTuples have a fixed number of items in them. Each item in a tuple is called an\n_element_. In the tuple `{moscow,{c,-10}}`, element 1 is `moscow` and element 2\nis `{c,-10}`. Here `c` represents Celsius and `f` Fahrenheit.","title":"Tuples - Sequential Programming","ref":"seq_prog.html#tuples"},{"type":"extras","doc":"Whereas tuples group things together, it is also needed to represent lists of\nthings. Lists in Erlang are surrounded by square brackets, `[` and `]`. For\nexample, a list of the temperatures of various cities in the world can be:\n\n```erlang\n[{moscow, {c, -10}}, {cape_town, {f, 70}}, {stockholm, {c, -4}},\n {paris, {f, 28}}, {london, {f, 36}}]\n```\n\nNotice that this list was so long that it did not fit on one line. This does not\nmatter, Erlang allows line breaks at all \"sensible places\" but not, for example,\nin the middle of atoms, integers, and others.\n\nA useful way of looking at parts of lists, is by using `|`. This is best\nexplained by an example using the shell:\n\n```erlang\n17> [First |TheRest] = [1,2,3,4,5].\n[1,2,3,4,5]\n18> First.\n1\n19> TheRest.\n[2,3,4,5]\n```\n\nTo separate the first elements of the list from the rest of the list, `|` is\nused. `First` has got value `1` and `TheRest` has got the value `[2,3,4,5]`.\n\nAnother example:\n\n```erlang\n20> [E1, E2 | R] = [1,2,3,4,5,6,7].\n[1,2,3,4,5,6,7]\n21> E1.\n1\n22> E2.\n2\n23> R.\n[3,4,5,6,7]\n```\n\nHere you see the use of `|` to get the first two elements from the list. If you\ntry to get more elements from the list than there are elements in the list, an\nerror is returned. Notice also the special case of the list with no elements,\n`[]`:\n\n```erlang\n24> [A, B | C] = [1, 2].\n[1,2]\n25> A.\n1\n26> B.\n2\n27> C.\n[]\n```\n\nIn the previous examples, new variable names are used, instead of reusing the\nold ones: `First`, `TheRest`, `E1`, `E2`, `R`, `A`, `B`, and `C`. The reason for\nthis is that a variable can only be given a value once in its context (scope).\nMore about this later.\n\nThe following example shows how to find the length of a list. Enter the\nfollowing code in a file named `tut4.erl`:\n\n```erlang\n-module(tut4).\n\n-export([list_length/1]).\n\nlist_length([]) ->\n    0;\nlist_length([First | Rest]) ->\n    1 + list_length(Rest).\n```\n\nCompile and test:\n\n```erlang\n28> c(tut4).\n{ok,tut4}\n29> tut4:list_length([1,2,3,4,5,6,7]).\n7\n```\n\nExplanation:\n\n```erlang\nlist_length([]) ->\n    0;\n```\n\nThe length of an empty list is obviously 0.\n\n```erlang\nlist_length([First | Rest]) ->\n    1 + list_length(Rest).\n```\n\nThe length of a list with the first element `First` and the remaining elements\n`Rest` is 1 + the length of `Rest`.\n\n(Advanced readers only: This is not tail recursive, there is a better way to\nwrite this function.)\n\nIn general, tuples are used where \"records\" or \"structs\" are used in other\nlanguages. Also, lists are used when representing things with varying sizes,\nthat is, where linked lists are used in other languages.\n\nErlang does not have a string data type. Instead, strings can be represented by\nlists of Unicode characters. This implies for example that the list `[97,98,99]`\nis equivalent to `\"abc\"`. The Erlang shell is \"clever\" and guesses what list you\nmean and outputs it in what it thinks is the most appropriate form, for example:\n\n```erlang\n30> [97,98,99].\n\"abc\"\n```","title":"Lists - Sequential Programming","ref":"seq_prog.html#lists"},{"type":"extras","doc":"Maps are a set of key to value associations. These associations are encapsulated\nwith `#{` and `}`. To create an association from `\"key\"` to value `42`:\n\n```erlang\n> #{ \"key\" => 42 }.\n#{\"key\" => 42}\n```\n\nLet us jump straight into the deep end with an example using some interesting\nfeatures.\n\nThe following example shows how to calculate alpha blending using maps to\nreference color and alpha channels. Enter the code in a file named `color.erl`):\n\n```erlang\n-module(color).\n\n-export([new/4, blend/2]).\n\n-define(is_channel(V), (is_float(V) andalso V >= 0.0 andalso V =< 1.0)).\n\nnew(R,G,B,A) when ?is_channel(R), ?is_channel(G),\n                  ?is_channel(B), ?is_channel(A) ->\n    #{red => R, green => G, blue => B, alpha => A}.\n\nblend(Src,Dst) ->\n    blend(Src,Dst,alpha(Src,Dst)).\n\nblend(Src,Dst,Alpha) when Alpha > 0.0 ->\n    Dst#{\n        red   := red(Src,Dst) / Alpha,\n        green := green(Src,Dst) / Alpha,\n        blue  := blue(Src,Dst) / Alpha,\n        alpha := Alpha\n    };\nblend(_,Dst,_) ->\n    Dst#{\n        red   := 0.0,\n        green := 0.0,\n        blue  := 0.0,\n        alpha := 0.0\n    }.\n\nalpha(#{alpha := SA}, #{alpha := DA}) ->\n    SA + DA*(1.0 - SA).\n\nred(#{red := SV, alpha := SA}, #{red := DV, alpha := DA}) ->\n    SV*SA + DV*DA*(1.0 - SA).\ngreen(#{green := SV, alpha := SA}, #{green := DV, alpha := DA}) ->\n    SV*SA + DV*DA*(1.0 - SA).\nblue(#{blue := SV, alpha := SA}, #{blue := DV, alpha := DA}) ->\n    SV*SA + DV*DA*(1.0 - SA).\n```\n\nCompile and test:\n\n```erlang\n> c(color).\n{ok,color}\n> C1 = color:new(0.3,0.4,0.5,1.0).\n#{alpha => 1.0,blue => 0.5,green => 0.4,red => 0.3}\n> C2 = color:new(1.0,0.8,0.1,0.3).\n#{alpha => 0.3,blue => 0.1,green => 0.8,red => 1.0}\n> color:blend(C1,C2).\n#{alpha => 1.0,blue => 0.5,green => 0.4,red => 0.3}\n> color:blend(C2,C1).\n#{alpha => 1.0,blue => 0.38,green => 0.52,red => 0.51}\n```\n\nThis example warrants some explanation:\n\n```erlang\n-define(is_channel(V), (is_float(V) andalso V >= 0.0 andalso V =< 1.0)).\n```\n\nFirst a macro `is_channel` is defined to help with the guard tests. This is only\nhere for convenience and to reduce syntax cluttering. For more information about\nmacros, see [The Preprocessor](`e:system:macros.md`).\n\n```erlang\nnew(R,G,B,A) when ?is_channel(R), ?is_channel(G),\n                  ?is_channel(B), ?is_channel(A) ->\n    #{red => R, green => G, blue => B, alpha => A}.\n```\n\nThe function `new/4` creates a new map term and lets the keys `red`, `green`,\n`blue`, and `alpha` be associated with an initial value. In this case, only\nfloat values between and including 0.0 and 1.0 are allowed, as ensured by the\n`?is_channel/1` macro for each argument. Only the `=>` operator is allowed when\ncreating a new map.\n\nBy calling `blend/2` on any color term created by `new/4`, the resulting color\ncan be calculated as determined by the two map terms.\n\nThe first thing `blend/2` does is to calculate the resulting alpha channel:\n\n```erlang\nalpha(#{alpha := SA}, #{alpha := DA}) ->\n    SA + DA*(1.0 - SA).\n```\n\nThe value associated with key `alpha` is fetched for both arguments using the\n`:=` operator. The other keys in the map are ignored, only the key `alpha` is\nrequired and checked for.\n\nThis is also the case for functions `red/2`, `blue/2`, and `green/2`.\n\n```erlang\nred(#{red := SV, alpha := SA}, #{red := DV, alpha := DA}) ->\n    SV*SA + DV*DA*(1.0 - SA).\n```\n\nThe difference here is that a check is made for two keys in each map argument.\nThe other keys are ignored.\n\nFinally, let us return the resulting color in `blend/3`:\n\n```erlang\nblend(Src,Dst,Alpha) when Alpha > 0.0 ->\n    Dst#{\n        red   := red(Src,Dst) / Alpha,\n        green := green(Src,Dst) / Alpha,\n        blue  := blue(Src,Dst) / Alpha,\n        alpha := Alpha\n    };\n```\n\nThe `Dst` map is updated with new channel values. The syntax for updating an\nexisting key with a new value is with the `:=` operator.","title":"Maps - Sequential Programming","ref":"seq_prog.html#maps"},{"type":"extras","doc":"Erlang has many standard modules to help you do things. For example, the module\n`m:io` contains many functions that help in doing formatted input/output. To look\nup information about standard modules, the command `h(..)` can be used at the\nerlang shell. Try the erlang shell command:\n\n```text\n1> h(io).\n\n\tio\n\n    Standard I/O server interface functions.\n    \n    This module provides an interface to standard Erlang I/O servers. The output\n    functions all return `ok` if they are successful, or exit if they are not.\n     ...\n```\n\nIf this does not work on your system, the documentation is included as HTML in\nthe Erlang/OTP release. You can also read the documentation as HTML or download\nit as epub from  .","title":"Standard Modules and Manual Pages - Sequential Programming","ref":"seq_prog.html#standard-modules-and-manual-pages"},{"type":"extras","doc":"It is nice to be able to do formatted output in examples, so the next example\nshows a simple way to use the `io:format/2` function. Like all other exported\nfunctions, you can test the `io:format/2` function in the shell:\n\n```erlang\n31> io:format(\"hello world~n\", []).\nhello world\nok\n32> io:format(\"this outputs one Erlang term: ~w~n\", [hello]).\nthis outputs one Erlang term: hello\nok\n33> io:format(\"this outputs two Erlang terms: ~w~w~n\", [hello, world]).\nthis outputs two Erlang terms: helloworld\nok\n34> io:format(\"this outputs two Erlang terms: ~w ~w~n\", [hello, world]).\nthis outputs two Erlang terms: hello world\nok\n```\n\nThe function `io:format/2` (that is, `format` with two arguments) takes two lists.\nThe first one is nearly always a list written between `\" \"`. This list is printed\nout as it is, except that each `~w` is replaced by a term taken in order from the\nsecond list. Each ~n is replaced by a new line. The `io:format/2` function\nitself returns the atom `ok` if everything goes as planned. Like other functions\nin Erlang, it crashes if an error occurs. This is not a fault in Erlang, it is a\ndeliberate policy. Erlang has sophisticated mechanisms to handle errors which\nare shown later. As an exercise, try to make `io:format/2` crash, it should not be\ndifficult. But notice that although `io:format/2` crashes, the Erlang shell itself\ndoes not crash.","title":"Writing Output to a Terminal - Sequential Programming","ref":"seq_prog.html#writing-output-to-a-terminal"},{"type":"extras","doc":"Now for a larger example to consolidate what you have learnt so far. Assume that\nyou have a list of temperature readings from a number of cities in the world.\nSome of them are in Celsius and some in Fahrenheit (as in the previous list).\nFirst let us convert them all to Celsius, then let us print the data neatly.\n\n```erlang\n%% This module is in file tut5.erl\n\n-module(tut5).\n-export([format_temps/1]).\n\n%% Only this function is exported\nformat_temps([])->                        % No output for an empty list\n    ok;\nformat_temps([City | Rest]) ->\n    print_temp(convert_to_celsius(City)),\n    format_temps(Rest).\n\nconvert_to_celsius({Name, {c, Temp}}) ->  % No conversion needed\n    {Name, {c, Temp}};\nconvert_to_celsius({Name, {f, Temp}}) ->  % Do the conversion\n    {Name, {c, (Temp - 32) * 5 / 9}}.\n\nprint_temp({Name, {c, Temp}}) ->\n    io:format(\"~-15w ~w c~n\", [Name, Temp]).\n```\n\n```erlang\n35> c(tut5).\n{ok,tut5}\n36> tut5:format_temps([{moscow, {c, -10}}, {cape_town, {f, 70}},\n{stockholm, {c, -4}}, {paris, {f, 28}}, {london, {f, 36}}]).\nmoscow          -10 c\ncape_town       21.11111111111111 c\nstockholm       -4 c\nparis           -2.2222222222222223 c\nlondon          2.2222222222222223 c\nok\n```\n\nBefore looking at how this program works, notice that a few comments are added\nto the code. A comment starts with a %-character and goes on to the end of the\nline. Notice also that the `-export([format_temps/1]).` line only includes the\nfunction `format_temps/1`. The other functions are _local_ functions, that is,\nthey are not visible from outside the module `tut5`.\n\nNotice also that when testing the program from the shell, the input is spread\nover two lines as the line was too long.\n\nWhen `format_temps` is called the first time, `City` gets the value\n`{moscow,{c,-10}}` and `Rest` is the rest of the list. So the function\n`print_temp(convert_to_celsius({moscow,{c,-10}}))` is called.\n\nHere is a function call as `convert_to_celsius({moscow,{c,-10}})` as the\nargument to the function `print_temp`. When function calls are _nested_ like\nthis, they execute (evaluate) from the inside out. That is, first\n`convert_to_celsius({moscow,{c,-10}})` is evaluated, which gives the value\n`{moscow,{c,-10}}` as the temperature is already in Celsius. Then\n`print_temp({moscow,{c,-10}})` is evaluated. The function `convert_to_celsius`\nworks in a similar way to the `convert_length` function in the previous example.\n\n`print_temp` simply calls `io:format` in a similar way to what has been\ndescribed above. Notice that `~-15w` says to print the \"term\" with a field length\n(width) of 15 and left justify it. (see `io:fwrite/1` manual page in STDLIB).\n\nNow `format_temps(Rest)` is called with the rest of the list as an argument.\nThis way of doing things is similar to the loop constructs in other languages.\n(Yes, this is recursion, but do not let that worry you.) So the same\n`format_temps` function is called again, this time `City` gets the value\n`{cape_town,{f,70}}` and the same procedure is repeated as before. This is done\nuntil the list becomes empty, that is [], which causes the first clause\n`format_temps([])` to match. This simply returns (results in) the atom `ok`, so\nthe program ends.","title":"A Larger Example - Sequential Programming","ref":"seq_prog.html#a-larger-example"},{"type":"extras","doc":"It can be useful to find the maximum and minimum temperature in lists like this.\nBefore extending the program to do this, let us look at functions for finding\nthe maximum value of the elements in a list:\n\n```erlang\n-module(tut6).\n-export([list_max/1]).\n\nlist_max([Head|Rest]) ->\n   list_max(Rest, Head).\n\nlist_max([], Res) ->\n    Res;\nlist_max([Head|Rest], Result_so_far) when Head > Result_so_far ->\n    list_max(Rest, Head);\nlist_max([Head|Rest], Result_so_far)  ->\n    list_max(Rest, Result_so_far).\n```\n\n```erlang\n37> c(tut6).\n{ok,tut6}\n38> tut6:list_max([1,2,3,4,5,7,4,3,2,1]).\n7\n```\n\nFirst notice that two functions have the same name, `list_max`. However, each of\nthese takes a different number of arguments (parameters). In Erlang these are\nregarded as completely different functions. Where you need to distinguish\nbetween these functions, you write Name/Arity, where Name is the function name\nand Arity is the number of arguments, in this case `list_max/1` and\n`list_max/2`.\n\nIn this example you walk through a list \"carrying\" a value, in this case\n`Result_so_far`. `list_max/1` simply assumes that the max value of the list is\nthe head of the list and calls `list_max/2` with the rest of the list and the\nvalue of the head of the list. In the above this would be\n`list_max([2,3,4,5,7,4,3,2,1],1)`. If you tried to use `list_max/1` with an\nempty list or tried to use it with something that is not a list at all, you\nwould cause an error. Notice that the Erlang philosophy is not to handle errors\nof this type in the function they occur, but to do so elsewhere. More about this\nlater.\n\nIn `list_max/2`, you walk down the list and use `Head` instead of\n`Result_so_far` when `Head` > `Result_so_far`. `when` is a special word used\nbefore the -> in the function to say that you only use this part of the function\nif the test that follows is true. A test of this type is called _guard_. If the\nguard is false (that is, the guard fails), the next part of the function is\ntried. In this case, if `Head` is not greater than `Result_so_far`, then it must\nbe smaller or equal to it. This means that a guard on the next part of the\nfunction is not needed.\n\nSome useful operators in guards are:\n\n- `<` less than\n- `>` greater than\n- `==` equal\n- `>=` greater or equal\n- `=<` less or equal\n- `/=` not equal\n\n(see [Guard Sequences](`e:system:expressions.md`)).\n\nTo change the above program to one that works out the minimum value of the\nelement in a list, you only need to write  . (But it would be wise\nto change the name of the function to `list_min`.)\n\nEarlier it was mentioned that a variable can only be given a value once in its\nscope. In the above you see that `Result_so_far` is given several values. This\nis OK since every time you call `list_max/2` you create a new scope and one can\nregard `Result_so_far` as a different variable in each scope.\n\nAnother way of creating and giving a variable a value is by using the match\noperator = . So if you write `M = 5`, a variable called `M` is created with the\nvalue 5. If, in the same scope, you then write `M = 6`, an error is returned.\nTry this out in the shell:\n\n```erlang\n39> M = 5.\n5\n40> M = 6.\n** exception error: no match of right hand side value 6\n41> M = M + 1.\n** exception error: no match of right hand side value 6\n42> N = M + 1.\n6\n```\n\nThe use of the match operator is particularly useful for pulling apart Erlang\nterms and creating new ones.\n\n```erlang\n43> {X, Y} = {paris, {f, 28}}.\n{paris,{f,28}}\n44> X.\nparis\n45> Y.\n{f,28}\n```\n\nHere `X` gets the value `paris` and `Y` the value `{f,28}`.\n\nIf you try to do the same again with another city, an error is returned:\n\n```erlang\n46> {X, Y} = {london, {f, 36}}.\n** exception error: no match of right hand side value {london,{f,36}}\n```\n\nVariables can also be used to improve the readability of programs. For example,\nin function `list_max/2` above, you can write:\n\n```erlang\nlist_max([Head|Rest], Result_so_far) when Head > Result_so_far ->\n    New_result_far = Head,\n    list_max(Rest, New_result_far);\n```\n\nThis is possibly a little clearer.","title":"Matching, Guards, and Scope of Variables - Sequential Programming","ref":"seq_prog.html#matching-guards-and-scope-of-variables"},{"type":"extras","doc":"Remember that the `|` operator can be used to get the head of a list:\n\n```erlang\n47> [M1|T1] = [paris, london, rome].\n[paris,london,rome]\n48> M1.\nparis\n49> T1.\n[london,rome]\n```\n\nThe `|` operator can also be used to add a head to a list:\n\n```erlang\n50> L1 = [madrid | T1].\n[madrid,london,rome]\n51> L1.\n[madrid,london,rome]\n```\n\nNow an example of this when working with lists - reversing the order of a list:\n\n```erlang\n-module(tut8).\n\n-export([reverse/1]).\n\nreverse(List) ->\n    reverse(List, []).\n\nreverse([Head | Rest], Reversed_List) ->\n    reverse(Rest, [Head | Reversed_List]);\nreverse([], Reversed_List) ->\n    Reversed_List.\n```\n\n```erlang\n52> c(tut8).\n{ok,tut8}\n53> tut8:reverse([1,2,3]).\n[3,2,1]\n```\n\nConsider how `Reversed_List` is built. It starts as [], then successively the\nheads are taken off of the list to be reversed and added to the the\n`Reversed_List`, as shown in the following:\n\n```erlang\nreverse([1|2,3], []) =>\n    reverse([2,3], [1|[]])\n\nreverse([2|3], [1]) =>\n    reverse([3], [2|[1])\n\nreverse([3|[]], [2,1]) =>\n    reverse([], [3|[2,1]])\n\nreverse([], [3,2,1]) =>\n    [3,2,1]\n```\n\nThe module `lists` contains many functions for manipulating lists, for example,\nfor reversing them. So before writing a list-manipulating function it is a good\nidea to check if one not already is written for you (see the `m:lists` manual\npage in STDLIB).\n\nNow let us get back to the cities and temperatures, but take a more structured\napproach this time. First let us convert the whole list to Celsius as follows:\n\n```erlang\n-module(tut7).\n-export([format_temps/1]).\n\nformat_temps(List_of_cities) ->\n    convert_list_to_c(List_of_cities).\n\nconvert_list_to_c([{Name, {f, F}} | Rest]) ->\n    Converted_City = {Name, {c, (F -32)* 5 / 9}},\n    [Converted_City | convert_list_to_c(Rest)];\n\nconvert_list_to_c([City | Rest]) ->\n    [City | convert_list_to_c(Rest)];\n\nconvert_list_to_c([]) ->\n    [].\n```\n\nTest the function:\n\n```erlang\n54> c(tut7).\n{ok, tut7}.\n55> tut7:format_temps([{moscow, {c, -10}}, {cape_town, {f, 70}},\n{stockholm, {c, -4}}, {paris, {f, 28}}, {london, {f, 36}}]).\n[{moscow,{c,-10}},\n {cape_town,{c,21.11111111111111}},\n {stockholm,{c,-4}},\n {paris,{c,-2.2222222222222223}},\n {london,{c,2.2222222222222223}}]\n```\n\nExplanation:\n\n```erlang\nformat_temps(List_of_cities) ->\n    convert_list_to_c(List_of_cities).\n```\n\nHere `format_temps/1` calls `convert_list_to_c/1`. `convert_list_to_c/1` takes\noff the head of the `List_of_cities`, converts it to Celsius if needed. The `|`\noperator is used to add the (maybe) converted to the converted rest of the list:\n\n```erlang\n[Converted_City | convert_list_to_c(Rest)];\n```\n\nor:\n\n```erlang\n[City | convert_list_to_c(Rest)];\n```\n\nThis is done until the end of the list is reached, that is, the list is empty:\n\n```erlang\nconvert_list_to_c([]) ->\n    [].\n```\n\nNow when the list is converted, a function to print it is added:\n\n```erlang\n-module(tut7).\n-export([format_temps/1]).\n\nformat_temps(List_of_cities) ->\n    Converted_List = convert_list_to_c(List_of_cities),\n    print_temp(Converted_List).\n\nconvert_list_to_c([{Name, {f, F}} | Rest]) ->\n    Converted_City = {Name, {c, (F -32)* 5 / 9}},\n    [Converted_City | convert_list_to_c(Rest)];\n\nconvert_list_to_c([City | Rest]) ->\n    [City | convert_list_to_c(Rest)];\n\nconvert_list_to_c([]) ->\n    [].\n\nprint_temp([{Name, {c, Temp}} | Rest]) ->\n    io:format(\"~-15w ~w c~n\", [Name, Temp]),\n    print_temp(Rest);\nprint_temp([]) ->\n    ok.\n```\n\n```erlang\n56> c(tut7).\n{ok,tut7}\n57> tut7:format_temps([{moscow, {c, -10}}, {cape_town, {f, 70}},\n{stockholm, {c, -4}}, {paris, {f, 28}}, {london, {f, 36}}]).\nmoscow          -10 c\ncape_town       21.11111111111111 c\nstockholm       -4 c\nparis           -2.2222222222222223 c\nlondon          2.2222222222222223 c\nok\n```\n\nNow a function has to be added to find the cities with the maximum and minimum\ntemperatures. The following program is not the most efficient way of doing this\nas you walk through the list of cities four times. But it is better to first\nstrive for clarity and correctness and to make programs efficient only if\nneeded.\n\n```erlang\n-module(tut7).\n-export([format_temps/1]).\n\nformat_temps(List_of_cities) ->\n    Converted_List = convert_list_to_c(List_of_cities),\n    print_temp(Converted_List),\n    {Max_city, Min_city} = find_max_and_min(Converted_List),\n    print_max_and_min(Max_city, Min_city).\n\nconvert_list_to_c([{Name, {f, Temp}} | Rest]) ->\n    Converted_City = {Name, {c, (Temp -32)* 5 / 9}},\n    [Converted_City | convert_list_to_c(Rest)];\n\nconvert_list_to_c([City | Rest]) ->\n    [City | convert_list_to_c(Rest)];\n\nconvert_list_to_c([]) ->\n    [].\n\nprint_temp([{Name, {c, Temp}} | Rest]) ->\n    io:format(\"~-15w ~w c~n\", [Name, Temp]),\n    print_temp(Rest);\nprint_temp([]) ->\n    ok.\n\nfind_max_and_min([City | Rest]) ->\n    find_max_and_min(Rest, City, City).\n\nfind_max_and_min([{Name, {c, Temp}} | Rest],\n         {Max_Name, {c, Max_Temp}},\n         {Min_Name, {c, Min_Temp}}) ->\n    if\n        Temp > Max_Temp ->\n            Max_City = {Name, {c, Temp}};           % Change\n        true ->\n            Max_City = {Max_Name, {c, Max_Temp}} % Unchanged\n    end,\n    if\n         Temp  \n            Min_City = {Name, {c, Temp}};           % Change\n        true ->\n            Min_City = {Min_Name, {c, Min_Temp}} % Unchanged\n    end,\n    find_max_and_min(Rest, Max_City, Min_City);\n\nfind_max_and_min([], Max_City, Min_City) ->\n    {Max_City, Min_City}.\n\nprint_max_and_min({Max_name, {c, Max_temp}}, {Min_name, {c, Min_temp}}) ->\n    io:format(\"Max temperature was ~w c in ~w~n\", [Max_temp, Max_name]),\n    io:format(\"Min temperature was ~w c in ~w~n\", [Min_temp, Min_name]).\n```\n\n```erlang\n58> c(tut7).\n{ok, tut7}\n59> tut7:format_temps([{moscow, {c, -10}}, {cape_town, {f, 70}},\n{stockholm, {c, -4}}, {paris, {f, 28}}, {london, {f, 36}}]).\nmoscow          -10 c\ncape_town       21.11111111111111 c\nstockholm       -4 c\nparis           -2.2222222222222223 c\nlondon          2.2222222222222223 c\nMax temperature was 21.11111111111111 c in cape_town\nMin temperature was -10 c in moscow\nok\n```","title":"More About Lists - Sequential Programming","ref":"seq_prog.html#more-about-lists"},{"type":"extras","doc":"The function `find_max_and_min` works out the maximum and minimum temperature. A\nnew construct, `if`, is introduced here. If works as follows:\n\n```c\nif\n    Condition 1 ->\n        Action 1;\n    Condition 2 ->\n        Action 2;\n    Condition 3 ->\n        Action 3;\n    Condition 4 ->\n        Action 4\nend\n```\n\nNotice that there is no `;` before `end`. Conditions do the same as guards, that\nis, tests that succeed or fail. Erlang starts at the top and tests until it\nfinds a condition that succeeds. Then it evaluates (performs) the action\nfollowing the condition and ignores all other conditions and actions before the\n`end`. If no condition matches, a run-time failure occurs. A condition that\nalways succeeds is the atom `true`. This is often used last in an `if`, meaning,\ndo the action following the `true` if all other conditions have failed.\n\nThe following is a short program to show the workings of `if`.\n\n```erlang\n-module(tut9).\n-export([test_if/2]).\n\ntest_if(A, B) ->\n    if\n        A == 5 ->\n            io:format(\"A == 5~n\", []),\n            a_equals_5;\n        B == 6 ->\n            io:format(\"B == 6~n\", []),\n            b_equals_6;\n        A == 2, B == 3 ->                      %That is A equals 2 and B equals 3\n            io:format(\"A == 2, B == 3~n\", []),\n            a_equals_2_b_equals_3;\n        A == 1 ; B == 7 ->                     %That is A equals 1 or B equals 7\n            io:format(\"A == 1 ; B == 7~n\", []),\n            a_equals_1_or_b_equals_7\n    end.\n```\n\nTesting this program gives:\n\n```erlang\n60> c(tut9).\n{ok,tut9}\n61> tut9:test_if(5,33).\nA == 5\na_equals_5\n62> tut9:test_if(33,6).\nB == 6\nb_equals_6\n63> tut9:test_if(2, 3).\nA == 2, B == 3\na_equals_2_b_equals_3\n64> tut9:test_if(1, 33).\nA == 1 ; B == 7\na_equals_1_or_b_equals_7\n65> tut9:test_if(33, 7).\nA == 1 ; B == 7\na_equals_1_or_b_equals_7\n66> tut9:test_if(33, 33).\n** exception error: no true branch found when evaluating an if expression\n     in function  tut9:test_if/2 (tut9.erl, line 5)\n```\n\nNotice that `tut9:test_if(33,33)` does not cause any condition to succeed. This\nleads to the run time error `if_clause`, here nicely formatted by the shell. See\n[Guard Sequences](`e:system:expressions.md`) for details of the many guard tests\navailable.\n\n`case` is another construct in Erlang. Recall that the `convert_length` function\nwas written as:\n\n```erlang\nconvert_length({centimeter, X}) ->\n    {inch, X / 2.54};\nconvert_length({inch, Y}) ->\n    {centimeter, Y * 2.54}.\n```\n\nThe same program can also be written as:\n\n```erlang\n-module(tut10).\n-export([convert_length/1]).\n\nconvert_length(Length) ->\n    case Length of\n        {centimeter, X} ->\n            {inch, X / 2.54};\n        {inch, Y} ->\n            {centimeter, Y * 2.54}\n    end.\n```\n\n```erlang\n67> c(tut10).\n{ok,tut10}\n68> tut10:convert_length({inch, 6}).\n{centimeter,15.24}\n69> tut10:convert_length({centimeter, 2.5}).\n{inch,0.984251968503937}\n```\n\nBoth `case` and `if` have _return values_, that is, in the above example `case`\nreturned either `{inch,X/2.54}` or `{centimeter,Y*2.54}`. The behaviour of\n`case` can also be modified by using guards. The following example clarifies\nthis. It tells us the length of a month, given the year. The year must be known,\nsince February has 29 days in a leap year.\n\n```erlang\n-module(tut11).\n-export([month_length/2]).\n\nmonth_length(Year, Month) ->\n    %% All years divisible by 400 are leap\n    %% Years divisible by 100 are not leap (except the 400 rule above)\n    %% Years divisible by 4 are leap (except the 100 rule above)\n    Leap = if\n        trunc(Year / 400) * 400 == Year ->\n            leap;\n        trunc(Year / 100) * 100 == Year ->\n            not_leap;\n        trunc(Year / 4) * 4 == Year ->\n            leap;\n        true ->\n            not_leap\n    end,\n    case Month of\n        sep -> 30;\n        apr -> 30;\n        jun -> 30;\n        nov -> 30;\n        feb when Leap == leap -> 29;\n        feb -> 28;\n        jan -> 31;\n        mar -> 31;\n        may -> 31;\n        jul -> 31;\n        aug -> 31;\n        oct -> 31;\n        dec -> 31\n    end.\n```\n\n```erlang\n70> c(tut11).\n{ok,tut11}\n71> tut11:month_length(2004, feb).\n29\n72> tut11:month_length(2003, feb).\n28\n73> tut11:month_length(1947, aug).\n31\n```","title":"If and Case - Sequential Programming","ref":"seq_prog.html#if-and-case"},{"type":"extras","doc":"BIFs are functions that for some reason are built-in to the Erlang virtual\nmachine. BIFs often implement functionality that is impossible or is too\ninefficient to implement in Erlang. Some BIFs can be called using the function\nname only but they are by default belonging to the `erlang` module. For example,\nthe call to the BIF `trunc` below is equivalent to a call to `erlang:trunc`.\n\nAs shown, first it is checked if a year is leap. If a year is divisible by 400,\nit is a leap year. To determine this, first divide the year by 400 and use the\nBIF `trunc` (more about this later) to cut off any decimals. Then multiply by\n400 again and see if the same value is returned again. For example, year 2004:\n\n```erlang\n2004 / 400 = 5.01\ntrunc(5.01) = 5\n5 * 400 = 2000\n```\n\n2000 is not the same as 2004, so 2004 is not divisible by 400. Year 2000:\n\n```erlang\n2000 / 400 = 5.0\ntrunc(5.0) = 5\n5 * 400 = 2000\n```\n\nThat is, a leap year. The next two `trunc`\\-tests evaluate if the year is\ndivisible by 100 or 4 in the same way. The first `if` returns `leap` or\n`not_leap`, which lands up in the variable `Leap`. This variable is used in the\nguard for `feb` in the following `case` that tells us how long the month is.\n\nThis example showed the use of `trunc`. It is easier to use the Erlang operator\n`rem` that gives the remainder after division, for example:\n\n```erlang\n74> 2004 rem 400.\n4\n```\n\nSo instead of writing:\n\n```erlang\ntrunc(Year / 400) * 400 == Year ->\n    leap;\n```\n\nit can be written:\n\n```erlang\nYear rem 400 == 0 ->\n    leap;\n```\n\nThere are many other BIFs such as `trunc`. Only a few BIFs can be used in\nguards, and you cannot use functions you have defined yourself in guards. (see\n[Guard Sequences](`e:system:expressions.md`)) (For advanced readers: This is to\nensure that guards do not have side effects.) Let us play with a few of these\nfunctions in the shell:\n\n```erlang\n75> trunc(5.6).\n5\n76> round(5.6).\n6\n77> length([a,b,c,d]).\n4\n78> float(5).\n5.0\n79> is_atom(hello).\ntrue\n80> is_atom(\"hello\").\nfalse\n81> is_tuple({paris, {c, 30}}).\ntrue\n82> is_tuple([paris, {c, 30}]).\nfalse\n```\n\nAll of these can be used in guards. Now for some BIFs that cannot be used in\nguards:\n\n```erlang\n83> atom_to_list(hello).\n\"hello\"\n84> list_to_atom(\"goodbye\").\ngoodbye\n85> integer_to_list(22).\n\"22\"\n```\n\nThese three BIFs do conversions that would be difficult (or impossible) to do in\nErlang.","title":"Built-In Functions (BIFs) - Sequential Programming","ref":"seq_prog.html#built-in-functions-bifs"},{"type":"extras","doc":"Erlang, like most modern functional programming languages, has higher-order\nfunctions. Here is an example using the shell:\n\n```erlang\n86> Xf = fun(X) -> X * 2 end.\n#Fun \n87> Xf(5).\n10\n```\n\nHere is defined a function that doubles the value of a number and assigned this\nfunction to a variable. Thus `Xf(5)` returns value 10. Two useful functions when\nworking with lists are `foreach` and `map`, which are defined as follows:\n\n```erlang\nforeach(Fun, [First|Rest]) ->\n    Fun(First),\n    foreach(Fun, Rest);\nforeach(Fun, []) ->\n    ok.\n\nmap(Fun, [First|Rest]) ->\n    [Fun(First)|map(Fun,Rest)];\nmap(Fun, []) ->\n    [].\n```\n\nThese two functions are provided in the standard module `lists`. `foreach` takes\na list and applies a fun to every element in the list. `map` creates a new list\nby applying a fun to every element in a list. Going back to the shell, `map` is\nused and a fun to add 3 to every element of a list:\n\n```erlang\n88> Add_3 = fun(X) -> X + 3 end.\n#Fun \n89> lists:map(Add_3, [1,2,3]).\n[4,5,6]\n```\n\nLet us (again) print the temperatures in a list of cities:\n\n```erlang\n90> Print_City = fun({City, {X, Temp}}) -> io:format(\"~-15w ~w ~w~n\",\n[City, X, Temp]) end.\n#Fun \n91> lists:foreach(Print_City, [{moscow, {c, -10}}, {cape_town, {f, 70}},\n{stockholm, {c, -4}}, {paris, {f, 28}}, {london, {f, 36}}]).\nmoscow          c -10\ncape_town       f 70\nstockholm       c -4\nparis           f 28\nlondon          f 36\nok\n```\n\nLet us now define a fun that can be used to go through a list of cities and\ntemperatures and transform them all to Celsius.\n\n```erlang\n-module(tut13).\n\n-export([convert_list_to_c/1]).\n\nconvert_to_c({Name, {f, Temp}}) ->\n    {Name, {c, trunc((Temp - 32) * 5 / 9)}};\nconvert_to_c({Name, {c, Temp}}) ->\n    {Name, {c, Temp}}.\n\nconvert_list_to_c(List) ->\n    lists:map(fun convert_to_c/1, List).\n```\n\n```erlang\n92> tut13:convert_list_to_c([{moscow, {c, -10}}, {cape_town, {f, 70}},\n{stockholm, {c, -4}}, {paris, {f, 28}}, {london, {f, 36}}]).\n[{moscow,{c,-10}},\n {cape_town,{c,21}},\n {stockholm,{c,-4}},\n {paris,{c,-2}},\n {london,{c,2}}]\n```\n\nThe `convert_to_c` function is the same as before, but here it is used as a fun:\n\n```erlang\nlists:map(fun convert_to_c/1, List)\n```\n\nWhen a function defined elsewhere is used as a fun, it can be referred to as\n`Function/Arity` (remember that `Arity` = number of arguments). So in the\n`map`\\-call `lists:map(fun convert_to_c/1, List)` is written. As shown,\n`convert_list_to_c` becomes much shorter and easier to understand.\n\nThe standard module `lists` also contains a function `sort(Fun, List)` where\n`Fun` is a fun with two arguments. This fun returns `true` if the first argument\nis less than the second argument, or else `false`. Sorting is added to the\n`convert_list_to_c`:\n\n```erlang\n-module(tut13).\n\n-export([convert_list_to_c/1]).\n\nconvert_to_c({Name, {f, Temp}}) ->\n    {Name, {c, trunc((Temp - 32) * 5 / 9)}};\nconvert_to_c({Name, {c, Temp}}) ->\n    {Name, {c, Temp}}.\n\nconvert_list_to_c(List) ->\n    New_list = lists:map(fun convert_to_c/1, List),\n    lists:sort(fun({_, {c, Temp1}}, {_, {c, Temp2}}) ->\n                       Temp1   c(tut13).\n{ok,tut13}\n94> tut13:convert_list_to_c([{moscow, {c, -10}}, {cape_town, {f, 70}},\n{stockholm, {c, -4}}, {paris, {f, 28}}, {london, {f, 36}}]).\n[{moscow,{c,-10}},\n {stockholm,{c,-4}},\n {paris,{c,-2}},\n {london,{c,2}},\n {cape_town,{c,21}}]\n```\n\nIn `sort` the fun is used:\n\n```erlang\nfun({_, {c, Temp1}}, {_, {c, Temp2}}) -> Temp1 < Temp2 end,\n```\n\nHere the concept of an _anonymous variable_ `_` is introduced. This is simply\nshorthand for a variable that gets a value, but the value is ignored. This can\nbe used anywhere suitable, not just in funs. `Temp1 < Temp2` returns `true` if\n`Temp1` is less than `Temp2`.","title":"Higher-Order Functions (Funs) - Sequential Programming","ref":"seq_prog.html#higher-order-functions-funs"},{"type":"extras","doc":"<!--\n%CopyrightBegin%\n\nCopyright Ericsson AB 2023-2024. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# Concurrent Programming","title":"Concurrent Programming","ref":"conc_prog.html"},{"type":"extras","doc":"One of the main reasons for using Erlang instead of other functional languages\nis Erlang's ability to handle concurrency and distributed programming. By\nconcurrency is meant programs that can handle several threads of execution at\nthe same time. For example, modern operating systems allow you to use a word\nprocessor, a spreadsheet, a mail client, and a print job all running at the same\ntime. Each processor (CPU) in the system is probably only handling one thread\n(or job) at a time, but it swaps between the jobs at such a rate that it gives\nthe illusion of running them all at the same time. It is easy to create parallel\nthreads of execution in an Erlang program and to allow these threads to\ncommunicate with each other. In Erlang, each thread of execution is called a\n_process_.\n\n(Aside: the term \"process\" is usually used when the threads of execution share\nno data with each other and the term \"thread\" when they share data in some way.\nThreads of execution in Erlang share no data, that is why they are called\nprocesses).\n\nThe Erlang BIF `spawn` is used to create a new process:\n`spawn(Module, Exported_Function, List of Arguments)`. Consider the following\nmodule:\n\n```erlang\n-module(tut14).\n\n-export([start/0, say_something/2]).\n\nsay_something(What, 0) ->\n    done;\nsay_something(What, Times) ->\n    io:format(\"~p~n\", [What]),\n    say_something(What, Times - 1).\n\nstart() ->\n    spawn(tut14, say_something, [hello, 3]),\n    spawn(tut14, say_something, [goodbye, 3]).\n```\n\n```erlang\n5> c(tut14).\n{ok,tut14}\n6> tut14:say_something(hello, 3).\nhello\nhello\nhello\ndone\n```\n\nAs shown, the function `say_something` writes its first argument the number of\ntimes specified by second argument. The function `start` starts two Erlang\nprocesses, one that writes \"hello\" three times and one that writes \"goodbye\"\nthree times. Both processes use the function `say_something`. Notice that a\nfunction used in this way by `spawn`, to start a process, must be exported from\nthe module (that is, in the `-export` at the start of the module).\n\n```erlang\n9> tut14:start().\nhello\ngoodbye\n<0.63.0>\nhello\ngoodbye\nhello\ngoodbye\n```\n\nNotice that it did not write \"hello\" three times and then \"goodbye\" three times.\nInstead, the first process wrote a \"hello\", the second a \"goodbye\", the first\nanother \"hello\" and so forth. But where did the `<0.63.0>` come from? The return\nvalue of a function is the return value of the last \"thing\" in the function. The\nlast thing in the function `start` is\n\n```erlang\nspawn(tut14, say_something, [goodbye, 3]).\n```\n\n`spawn` returns a _process identifier_, or _pid_, which uniquely identifies the\nprocess. So `<0.63.0>` is the pid of the `spawn` function call above. The next\nexample shows how to use pids.\n\nNotice also that ~p is used instead of ~w in `io:format/2`. To quote [the manual](`m:io#tilde_p`):\n\n> ~p Writes the data with standard syntax in the same way as ~w, but breaks terms\n> whose printed representation is longer than one line into many lines and indents\n> each line sensibly. It also tries to detect flat lists of printable characters and\n> to output these as strings","title":"Processes - Concurrent Programming","ref":"conc_prog.html#processes"},{"type":"extras","doc":"In the following example two processes are created and they send messages to\neach other a number of times.\n\n```erlang\n-module(tut15).\n\n-export([start/0, ping/2, pong/0]).\n\nping(0, Pong_PID) ->\n    Pong_PID ! finished,\n    io:format(\"ping finished~n\", []);\n\nping(N, Pong_PID) ->\n    Pong_PID ! {ping, self()},\n    receive\n        pong ->\n            io:format(\"Ping received pong~n\", [])\n    end,\n    ping(N - 1, Pong_PID).\n\npong() ->\n    receive\n        finished ->\n            io:format(\"Pong finished~n\", []);\n        {ping, Ping_PID} ->\n            io:format(\"Pong received ping~n\", []),\n            Ping_PID ! pong,\n            pong()\n    end.\n\nstart() ->\n    Pong_PID = spawn(tut15, pong, []),\n    spawn(tut15, ping, [3, Pong_PID]).\n```\n\n```erlang\n1> c(tut15).\n{ok,tut15}\n2> tut15: start().\n<0.36.0>\nPong received ping\nPing received pong\nPong received ping\nPing received pong\nPong received ping\nPing received pong\nping finished\nPong finished\n```\n\nThe function `start` first creates a process, let us call it \"pong\":\n\n```erlang\nPong_PID = spawn(tut15, pong, [])\n```\n\nThis process executes `tut15:pong()`. `Pong_PID` is the process identity of the\n\"pong\" process. The function `start` now creates another process \"ping\":\n\n```erlang\nspawn(tut15, ping, [3, Pong_PID]),\n```\n\nThis process executes:\n\n```erlang\ntut15:ping(3, Pong_PID)\n```\n\n`<0.36.0>` is the return value from the `start` function.\n\nThe process \"pong\" now does:\n\n```erlang\nreceive\n    finished ->\n        io:format(\"Pong finished~n\", []);\n    {ping, Ping_PID} ->\n        io:format(\"Pong received ping~n\", []),\n        Ping_PID ! pong,\n        pong()\nend.\n```\n\nThe `receive` construct is used to allow processes to wait for messages from\nother processes. It has the following format:\n\n```erlang\nreceive\n   pattern1 ->\n       actions1;\n   pattern2 ->\n       actions2;\n   ....\n   patternN\n       actionsN\nend.\n```\n\nNotice there is no \";\" before the `end`.\n\nMessages between Erlang processes are simply valid Erlang terms. That is, they\ncan be lists, tuples, integers, atoms, pids, and so on.\n\nEach process has its own input queue for messages it receives. New messages\nreceived are put at the end of the queue. When a process executes a `receive`,\nthe first message in the queue is matched against the first pattern in the\n`receive`. If this matches, the message is removed from the queue and the\nactions corresponding to the pattern are executed.\n\nHowever, if the first pattern does not match, the second pattern is tested. If\nthis matches, the message is removed from the queue and the actions\ncorresponding to the second pattern are executed. If the second pattern does not\nmatch, the third is tried and so on until there are no more patterns to test. If\nthere are no more patterns to test, the first message is kept in the queue and\nthe second message is tried instead. If this matches any pattern, the\nappropriate actions are executed and the second message is removed from the\nqueue (keeping the first message and any other messages in the queue). If the\nsecond message does not match, the third message is tried, and so on, until the\nend of the queue is reached. If the end of the queue is reached, the process\nblocks (stops execution) and waits until a new message is received and this\nprocedure is repeated.\n\nThe Erlang implementation is \"clever\" and minimizes the number of times each\nmessage is tested against the patterns in each `receive`.\n\nNow back to the ping pong example.\n\n\"Pong\" is waiting for messages. If the atom `finished` is received, \"pong\"\nwrites \"Pong finished\" to the output and, as it has nothing more to do,\nterminates. If it receives a message with the format:\n\n```erlang\n{ping, Ping_PID}\n```\n\nit writes \"Pong received ping\" to the output and sends the atom `pong` to the\nprocess \"ping\":\n\n```erlang\nPing_PID ! pong\n```\n\nNotice how the operator \"\\!\" is used to send messages. The syntax of \"\\!\" is:\n\n```erlang\nPid ! Message\n```\n\nThat is, `Message` (any Erlang term) is sent to the process with identity `Pid`.\n\nAfter sending the message `pong` to the process \"ping\", \"pong\" calls the `pong`\nfunction again, which causes it to get back to the `receive` again and wait for\nanother message.\n\nNow let us look at the process \"ping\". Recall that it was started by executing:\n\n```erlang\ntut15:ping(3, Pong_PID)\n```\n\nLooking at the function `ping/2`, the second clause of `ping/2` is executed\nsince the value of the first argument is 3 (not 0) (first clause head is\n`ping(0,Pong_PID)`, second clause head is `ping(N,Pong_PID)`, so `N` becomes 3).\n\nThe second clause sends a message to \"pong\":\n\n```erlang\nPong_PID ! {ping, self()},\n```\n\n`self/0` returns the pid of the process that executes `self/0`, in this case the\npid of \"ping\". (Recall the code for \"pong\", this lands up in the variable\n`Ping_PID` in the `receive` previously explained.)\n\n\"Ping\" now waits for a reply from \"pong\":\n\n```erlang\nreceive\n    pong ->\n        io:format(\"Ping received pong~n\", [])\nend,\n```\n\nIt writes \"Ping received pong\" when this reply arrives, after which \"ping\" calls\nthe `ping` function again.\n\n```erlang\nping(N - 1, Pong_PID)\n```\n\n`N-1` causes the first argument to be decremented until it becomes 0. When this\noccurs, the first clause of `ping/2` is executed:\n\n```erlang\nping(0, Pong_PID) ->\n    Pong_PID !  finished,\n    io:format(\"ping finished~n\", []);\n```\n\nThe atom `finished` is sent to \"pong\" (causing it to terminate as described\nabove) and \"ping finished\" is written to the output. \"Ping\" then terminates as\nit has nothing left to do.","title":"Message Passing - Concurrent Programming","ref":"conc_prog.html#message-passing"},{"type":"extras","doc":"In the above example, \"pong\" was first created to be able to give the identity\nof \"pong\" when \"ping\" was started. That is, in some way \"ping\" must be able to\nknow the identity of \"pong\" to be able to send a message to it. Sometimes\nprocesses which need to know each other's identities are started independently\nof each other. Erlang thus provides a mechanism for processes to be given names\nso that these names can be used as identities instead of pids. This is done by\nusing the `register` BIF:\n\n```erlang\nregister(some_atom, Pid)\n```\n\nLet us now rewrite the ping pong example using this and give the name `pong` to\nthe \"pong\" process:\n\n```erlang\n-module(tut16).\n\n-export([start/0, ping/1, pong/0]).\n\nping(0) ->\n    pong ! finished,\n    io:format(\"ping finished~n\", []);\n\nping(N) ->\n    pong ! {ping, self()},\n    receive\n        pong ->\n            io:format(\"Ping received pong~n\", [])\n    end,\n    ping(N - 1).\n\npong() ->\n    receive\n        finished ->\n            io:format(\"Pong finished~n\", []);\n        {ping, Ping_PID} ->\n            io:format(\"Pong received ping~n\", []),\n            Ping_PID ! pong,\n            pong()\n    end.\n\nstart() ->\n    register(pong, spawn(tut16, pong, [])),\n    spawn(tut16, ping, [3]).\n```\n\n```erlang\n2> c(tut16).\n{ok, tut16}\n3> tut16:start().\n<0.38.0>\nPong received ping\nPing received pong\nPong received ping\nPing received pong\nPong received ping\nPing received pong\nping finished\nPong finished\n```\n\nHere the `start/0` function,\n\n```erlang\nregister(pong, spawn(tut16, pong, [])),\n```\n\nboth spawns the \"pong\" process and gives it the name `pong`. In the \"ping\"\nprocess, messages can be sent to `pong` by:\n\n```erlang\npong ! {ping, self()},\n```\n\n`ping/2` now becomes `ping/1` as the argument `Pong_PID` is not needed.","title":"Registered Process Names - Concurrent Programming","ref":"conc_prog.html#registered-process-names"},{"type":"extras","doc":"Let us rewrite the ping pong program with \"ping\" and \"pong\" on different\ncomputers. First a few things are needed to set up to get this to work. The\ndistributed Erlang implementation provides a very basic authentication mechanism\nto prevent unintentional access to an Erlang system on another computer. Erlang\nsystems which talk to each other must have the same _magic cookie_. The easiest\nway to achieve this is by having a file called `.erlang.cookie` in your home\ndirectory on all machines on which you are going to run Erlang systems\ncommunicating with each other:\n\n- On Windows systems the home directory is the directory pointed out by the\n  environment variable $HOME - you may need to set this.\n- On Linux or UNIX you can safely ignore this and simply create a file called\n  `.erlang.cookie` in the directory you get to after executing the command `cd`\n  without any argument.\n\nThe `.erlang.cookie` file is to contain a line with the same atom. For example,\non Linux or UNIX, in the OS shell:\n\n```text\n$ cd\n$ cat > .erlang.cookie\nthis_is_very_secret\n$ chmod 400 .erlang.cookie\n```\n\nThe `chmod` above makes the `.erlang.cookie` file accessible only by the owner\nof the file. This is a requirement.\n\nWhen you start an Erlang system that is going to talk to other Erlang systems,\nyou must give it a name, for example:\n\n```text\n$ erl -sname my_name\n```\n\nWe will see more details of this later. If you want to experiment with\ndistributed Erlang, but you only have one computer to work on, you can start two\nseparate Erlang systems on the same computer but give them different names. Each\nErlang system running on a computer is called an _Erlang node_.\n\n(Note: `erl -sname` assumes that all nodes are in the same IP domain and we can\nuse only the first component of the IP address, if we want to use nodes in\ndifferent domains we use `-name` instead, but then all IP address must be given\nin full.)\n\nHere is the ping pong example modified to run on two separate nodes:\n\n```erlang\n-module(tut17).\n\n-export([start_ping/1, start_pong/0,  ping/2, pong/0]).\n\nping(0, Pong_Node) ->\n    {pong, Pong_Node} ! finished,\n    io:format(\"ping finished~n\", []);\n\nping(N, Pong_Node) ->\n    {pong, Pong_Node} ! {ping, self()},\n    receive\n        pong ->\n            io:format(\"Ping received pong~n\", [])\n    end,\n    ping(N - 1, Pong_Node).\n\npong() ->\n    receive\n        finished ->\n            io:format(\"Pong finished~n\", []);\n        {ping, Ping_PID} ->\n            io:format(\"Pong received ping~n\", []),\n            Ping_PID ! pong,\n            pong()\n    end.\n\nstart_pong() ->\n    register(pong, spawn(tut17, pong, [])).\n\nstart_ping(Pong_Node) ->\n    spawn(tut17, ping, [3, Pong_Node]).\n```\n\nLet us assume there are two computers called gollum and kosken. First a node is\nstarted on kosken, called ping, and then a node on gollum, called pong.\n\nOn kosken (on a Linux/UNIX system):\n\n```text\nkosken> erl -sname ping\nErlang (BEAM) emulator version 5.2.3.7 [hipe] [threads:0]\n\nEshell V5.2.3.7  (abort with ^G)\n(ping@kosken)1>\n```\n\nOn gollum:\n\n```text\ngollum> erl -sname pong\nErlang (BEAM) emulator version 5.2.3.7 [hipe] [threads:0]\n\nEshell V5.2.3.7  (abort with ^G)\n(pong@gollum)1>\n```\n\nNow the \"pong\" process on gollum is started:\n\n```erlang\n(pong@gollum)1> tut17:start_pong().\ntrue\n```\n\nAnd the \"ping\" process on kosken is started (from the code above you can see\nthat a parameter of the `start_ping` function is the node name of the Erlang\nsystem where \"pong\" is running):\n\n```erlang\n(ping@kosken)1> tut17:start_ping(pong@gollum).\n<0.37.0>\nPing received pong\nPing received pong\nPing received pong\nping finished\n```\n\nAs shown, the ping pong program has run. On the \"pong\" side:\n\n```erlang\n(pong@gollum)2> \nPong received ping\nPong received ping\nPong received ping\nPong finished\n(pong@gollum)2> \n```\n\nLooking at the `tut17` code, you see that the `pong` function itself is\nunchanged, the following lines work in the same way irrespective of on which\nnode the \"ping\" process is executes:\n\n```erlang\n{ping, Ping_PID} ->\n    io:format(\"Pong received ping~n\", []),\n    Ping_PID ! pong,\n```\n\nThus, Erlang pids contain information about where the process executes. So if\nyou know the pid of a process, the `!` operator can be used to send it a\nmessage disregarding if the process is on the same node or on a different node.\n\nA difference is how messages are sent to a registered process on another node:\n\n```erlang\n{pong, Pong_Node} ! {ping, self()},\n```\n\nA tuple `{registered_name,node_name}` is used instead of just the\n`registered_name`.\n\nIn the previous example, \"ping\" and \"pong\" were started from the shells of two\nseparate Erlang nodes. `spawn` can also be used to start processes in other\nnodes.\n\nThe next example is the ping pong program, yet again, but this time \"ping\" is\nstarted in another node:\n\n```erlang\n-module(tut18).\n\n-export([start/1,  ping/2, pong/0]).\n\nping(0, Pong_Node) ->\n    {pong, Pong_Node} ! finished,\n    io:format(\"ping finished~n\", []);\n\nping(N, Pong_Node) ->\n    {pong, Pong_Node} ! {ping, self()},\n    receive\n        pong ->\n            io:format(\"Ping received pong~n\", [])\n    end,\n    ping(N - 1, Pong_Node).\n\npong() ->\n    receive\n        finished ->\n            io:format(\"Pong finished~n\", []);\n        {ping, Ping_PID} ->\n            io:format(\"Pong received ping~n\", []),\n            Ping_PID ! pong,\n            pong()\n    end.\n\nstart(Ping_Node) ->\n    register(pong, spawn(tut18, pong, [])),\n    spawn(Ping_Node, tut18, ping, [3, node()]).\n```\n\nAssuming an Erlang system called ping (but not the \"ping\" process) has already\nbeen started on kosken, then on gollum this is done:\n\n```erlang\n(pong@gollum)1> tut18:start(ping@kosken).\n<3934.39.0>\nPong received ping\nPing received pong\nPong received ping\nPing received pong\nPong received ping\nPing received pong\nPong finished\nping finished\n```\n\nNotice that all the output is received on gollum. This is because the I/O system\nfinds out where the process is spawned from and sends all output there.","title":"Distributed Programming - Concurrent Programming","ref":"conc_prog.html#distributed-programming"},{"type":"extras","doc":"Now for a larger example with a simple \"messenger\". The messenger is a program\nthat allows users to log in on different nodes and send simple messages to each\nother.\n\nBefore starting, notice the following:\n\n- This example only shows the message passing logic - no attempt has been made\n  to provide a nice graphical user interface, although this can also be done in\n  Erlang.\n- This sort of problem can be solved easier by use of the facilities in OTP,\n  which also provide methods for updating code on the fly and so on (see\n  [OTP Design Principles](`e:system:design_principles.md`)).\n- The first program contains some inadequacies regarding handling of nodes which\n  disappear. These are corrected in a later version of the program.\n\nThe messenger is set up by allowing \"clients\" to connect to a central server and\nsay who and where they are. That is, a user does not need to know the name of\nthe Erlang node where another user is located to send a message.\n\nFile `messenger.erl`:\n\n[](){: #ex }\n\n```erlang\n%%% Message passing utility.\n%%% User interface:\n%%% logon(Name)\n%%%     One user at a time can log in from each Erlang node in the\n%%%     system messenger: and choose a suitable Name. If the Name\n%%%     is already logged in at another node or if someone else is\n%%%     already logged in at the same node, login will be rejected\n%%%     with a suitable error message.\n%%% logoff()\n%%%     Logs off anybody at that node\n%%% message(ToName, Message)\n%%%     sends Message to ToName. Error messages if the user of this\n%%%     function is not logged on or if ToName is not logged on at\n%%%     any node.\n%%%\n%%% One node in the network of Erlang nodes runs a server which maintains\n%%% data about the logged on users. The server is registered as \"messenger\"\n%%% Each node where there is a user logged on runs a client process registered\n%%% as \"mess_client\"\n%%%\n%%% Protocol between the client processes and the server\n%%% ----------------------------------------------------\n%%%\n%%% To server: {ClientPid, logon, UserName}\n%%% Reply {messenger, stop, user_exists_at_other_node} stops the client\n%%% Reply {messenger, logged_on} logon was successful\n%%%\n%%% To server: {ClientPid, logoff}\n%%% Reply: {messenger, logged_off}\n%%%\n%%% To server: {ClientPid, logoff}\n%%% Reply: no reply\n%%%\n%%% To server: {ClientPid, message_to, ToName, Message} send a message\n%%% Reply: {messenger, stop, you_are_not_logged_on} stops the client\n%%% Reply: {messenger, receiver_not_found} no user with this name logged on\n%%% Reply: {messenger, sent} Message has been sent (but no guarantee)\n%%%\n%%% To client: {message_from, Name, Message},\n%%%\n%%% Protocol between the \"commands\" and the client\n%%% ----------------------------------------------\n%%%\n%%% Started: messenger:client(Server_Node, Name)\n%%% To client: logoff\n%%% To client: {message_to, ToName, Message}\n%%%\n%%% Configuration: change the server_node() function to return the\n%%% name of the node where the messenger server runs\n\n-module(messenger).\n-export([start_server/0, server/1, logon/1, logoff/0, message/2, client/2]).\n\n%%% Change the function below to return the name of the node where the\n%%% messenger server runs\nserver_node() ->\n    messenger@super.\n\n%%% This is the server process for the \"messenger\"\n%%% the user list has the format [{ClientPid1, Name1},{ClientPid22, Name2},...]\nserver(User_List) ->\n    receive\n        {From, logon, Name} ->\n            New_User_List = server_logon(From, Name, User_List),\n            server(New_User_List);\n        {From, logoff} ->\n            New_User_List = server_logoff(From, User_List),\n            server(New_User_List);\n        {From, message_to, To, Message} ->\n            server_transfer(From, To, Message, User_List),\n            io:format(\"list is now: ~p~n\", [User_List]),\n            server(User_List)\n    end.\n\n%%% Start the server\nstart_server() ->\n    register(messenger, spawn(messenger, server, [[]])).\n\n\n%%% Server adds a new user to the user list\nserver_logon(From, Name, User_List) ->\n    %% check if logged on anywhere else\n    case lists:keymember(Name, 2, User_List) of\n        true ->\n            From ! {messenger, stop, user_exists_at_other_node},  %reject logon\n            User_List;\n        false ->\n            From ! {messenger, logged_on},\n            [{From, Name} | User_List]        %add user to the list\n    end.\n\n%%% Server deletes a user from the user list\nserver_logoff(From, User_List) ->\n    lists:keydelete(From, 1, User_List).\n\n\n%%% Server transfers a message between user\nserver_transfer(From, To, Message, User_List) ->\n    %% check that the user is logged on and who he is\n    case lists:keysearch(From, 1, User_List) of\n        false ->\n            From ! {messenger, stop, you_are_not_logged_on};\n        {value, {From, Name}} ->\n            server_transfer(From, Name, To, Message, User_List)\n    end.\n%%% If the user exists, send the message\nserver_transfer(From, Name, To, Message, User_List) ->\n    %% Find the receiver and send the message\n    case lists:keysearch(To, 2, User_List) of\n        false ->\n            From ! {messenger, receiver_not_found};\n        {value, {ToPid, To}} ->\n            ToPid ! {message_from, Name, Message},\n            From ! {messenger, sent}\n    end.\n\n\n%%% User Commands\nlogon(Name) ->\n    case whereis(mess_client) of\n        undefined ->\n            register(mess_client,\n                     spawn(messenger, client, [server_node(), Name]));\n        _ -> already_logged_on\n    end.\n\nlogoff() ->\n    mess_client ! logoff.\n\nmessage(ToName, Message) ->\n    case whereis(mess_client) of % Test if the client is running\n        undefined ->\n            not_logged_on;\n        _ -> mess_client ! {message_to, ToName, Message},\n             ok\nend.\n\n\n%%% The client process which runs on each server node\nclient(Server_Node, Name) ->\n    {messenger, Server_Node} ! {self(), logon, Name},\n    await_result(),\n    client(Server_Node).\n\nclient(Server_Node) ->\n    receive\n        logoff ->\n            {messenger, Server_Node} ! {self(), logoff},\n            exit(normal);\n        {message_to, ToName, Message} ->\n            {messenger, Server_Node} ! {self(), message_to, ToName, Message},\n            await_result();\n        {message_from, FromName, Message} ->\n            io:format(\"Message from ~p: ~p~n\", [FromName, Message])\n    end,\n    client(Server_Node).\n\n%%% wait for a response from the server\nawait_result() ->\n    receive\n        {messenger, stop, Why} -> % Stop the client\n            io:format(\"~p~n\", [Why]),\n            exit(normal);\n        {messenger, What} ->  % Normal response\n            io:format(\"~p~n\", [What])\n    end.\n```\n\nTo use this program, you need to:\n\n- Configure the `server_node()` function.\n- Copy the compiled code (`messenger.beam`) to the directory on each computer\n  where you start Erlang.\n\nIn the following example using this program, nodes are started on four different\ncomputers. If you do not have that many machines available on your network, you\ncan start several nodes on the same machine.\n\nFour Erlang nodes are started up: messenger@super, c1@bilbo, c2@kosken,\nc3@gollum.\n\nFirst the server at messenger@super is started up:\n\n```erlang\n(messenger@super)1> messenger:start_server().\ntrue\n```\n\nNow Peter logs on at c1@bilbo:\n\n```erlang\n(c1@bilbo)1> messenger:logon(peter).\ntrue\nlogged_on\n```\n\nJames logs on at c2@kosken:\n\n```erlang\n(c2@kosken)1> messenger:logon(james).\ntrue\nlogged_on\n```\n\nAnd Fred logs on at c3@gollum:\n\n```erlang\n(c3@gollum)1> messenger:logon(fred).\ntrue\nlogged_on\n```\n\nNow Peter sends Fred a message:\n\n```erlang\n(c1@bilbo)2> messenger:message(fred, \"hello\").\nok\nsent\n```\n\nFred receives the message and sends a message to Peter and logs off:\n\n```erlang\nMessage from peter: \"hello\"\n(c3@gollum)2> messenger:message(peter, \"go away, I'm busy\").\nok\nsent\n(c3@gollum)3> messenger:logoff().\nlogoff\n```\n\nJames now tries to send a message to Fred:\n\n```erlang\n(c2@kosken)2> messenger:message(fred, \"peter doesn't like you\").\nok\nreceiver_not_found\n```\n\nBut this fails as Fred has already logged off.\n\nFirst let us look at some of the new concepts that have been introduced.\n\nThere are two versions of the `server_transfer` function: one with four\narguments (`server_transfer/4`) and one with five (`server_transfer/5`). These\nare regarded by Erlang as two separate functions.\n\nNotice how to write the `server` function so that it calls itself, through\n`server(User_List)`, and thus creates a loop. The Erlang compiler is \"clever\"\nand optimizes the code so that this really is a sort of loop and not a proper\nfunction call. But this only works if there is no code after the call.\nOtherwise, the compiler expects the call to return and make a proper function\ncall. This would result in the process getting bigger and bigger for every loop.\n\nFunctions in the `lists` module are used. This is a very useful module and a\nstudy of the manual page is recommended (`erl -man lists`).\n`lists:keymember(Key,Position,Lists)` looks through a list of tuples and looks\nat `Position` in each tuple to see if it is the same as `Key`. The first element\nis position 1. If it finds a tuple where the element at `Position` is the same\nas `Key`, it returns `true`, otherwise `false`.\n\n```erlang\n3> lists:keymember(a, 2, [{x,y,z},{b,b,b},{b,a,c},{q,r,s}]).\ntrue\n4> lists:keymember(p, 2, [{x,y,z},{b,b,b},{b,a,c},{q,r,s}]).\nfalse\n```\n\n`lists:keydelete` works in the same way but deletes the first tuple found (if\nany) and returns the remaining list:\n\n```erlang\n5> lists:keydelete(a, 2, [{x,y,z},{b,b,b},{b,a,c},{q,r,s}]).\n[{x,y,z},{b,b,b},{q,r,s}]\n```\n\n`lists:keysearch` is like `lists:keymember`, but it returns\n`{value,Tuple_Found}` or the atom `false`.\n\nThere are many very useful functions in the `lists` module.\n\nAn Erlang process (conceptually) runs until it does a `receive` and there is no\nmessage which it wants to receive in the message queue. \"conceptually\" is used\nhere because the Erlang system shares the CPU time between the active processes\nin the system.\n\nA process terminates when there is nothing more for it to do, that is, the last\nfunction it calls simply returns and does not call another function. Another way\nfor a process to terminate is for it to call [`exit/1`](`exit/1`). The argument\nto [`exit/1`](`exit/1`) has a special meaning, which is discussed later. In this\nexample, [`exit(normal)`](`exit/1`) is done, which has the same effect as a\nprocess running out of functions to call.\n\nThe BIF [`whereis(RegisteredName)`](`whereis/1`) checks if a registered process\nof name `RegisteredName` exists. If it exists, the pid of that process is\nreturned. If it does not exist, the atom `undefined` is returned.\n\nYou should by now be able to understand most of the code in the\nmessenger-module. Let us study one case in detail: a message is sent from one\nuser to another.\n\nThe first user \"sends\" the message in the example above by:\n\n```erlang\nmessenger:message(fred, \"hello\")\n```\n\nAfter testing that the client process exists:\n\n```erlang\nwhereis(mess_client)\n```\n\nAnd a message is sent to `mess_client`:\n\n```erlang\nmess_client ! {message_to, fred, \"hello\"}\n```\n\nThe client sends the message to the server by:\n\n```erlang\n{messenger, messenger@super} ! {self(), message_to, fred, \"hello\"},\n```\n\nAnd waits for a reply from the server.\n\nThe server receives this message and calls:\n\n```erlang\nserver_transfer(From, fred, \"hello\", User_List),\n```\n\nThis checks that the pid `From` is in the `User_List`:\n\n```erlang\nlists:keysearch(From, 1, User_List)\n```\n\nIf `keysearch` returns the atom `false`, some error has occurred and the server\nsends back the message:\n\n```erlang\nFrom ! {messenger, stop, you_are_not_logged_on}\n```\n\nThis is received by the client, which in turn does [`exit(normal)`](`exit/1`)\nand terminates. If `keysearch` returns `{value,{From,Name}}` it is certain that\nthe user is logged on and that his name (peter) is in variable `Name`.\n\nLet us now call:\n\n```erlang\nserver_transfer(From, peter, fred, \"hello\", User_List)\n```\n\nNotice that as this is `server_transfer/5`, it is not the same as the previous\nfunction `server_transfer/4`. Another `keysearch` is done on `User_List` to find\nthe pid of the client corresponding to fred:\n\n```erlang\nlists:keysearch(fred, 2, User_List)\n```\n\nThis time argument 2 is used, which is the second element in the tuple. If this\nreturns the atom `false`, fred is not logged on and the following message is\nsent:\n\n```erlang\nFrom ! {messenger, receiver_not_found};\n```\n\nThis is received by the client.\n\nIf `keysearch` returns:\n\n```erlang\n{value, {ToPid, fred}}\n```\n\nThe following message is sent to fred's client:\n\n```erlang\nToPid ! {message_from, peter, \"hello\"},\n```\n\nThe following message is sent to peter's client:\n\n```erlang\nFrom ! {messenger, sent}\n```\n\nFred's client receives the message and prints it:\n\n```erlang\n{message_from, peter, \"hello\"} ->\n    io:format(\"Message from ~p: ~p~n\", [peter, \"hello\"])\n```\n\nPeter's client receives the message in the `await_result` function.","title":"A Larger Example - Concurrent Programming","ref":"conc_prog.html#a-larger-example"},{"type":"extras","doc":"<!--\n%CopyrightBegin%\n\nCopyright Ericsson AB 2023-2024. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# Robustness\n\nSeveral things are wrong with the messenger example in\n[A Larger Example](conc_prog.md#ex). For example, if a node where a user is\nlogged on goes down without doing a logoff, the user remains in the server's\n`User_List`, but the client disappears. This makes it impossible for the user to\nlog on again as the server thinks the user already is logged on.\n\nOr what happens if the server goes down in the middle of sending a message,\nleaving the sending client hanging forever in the `await_result` function?","title":"Robustness","ref":"robustness.html"},{"type":"extras","doc":"Before improving the messenger program, let us look at some general principles,\nusing the ping pong program as an example. Recall that when \"ping\" finishes, it\ntells \"pong\" that it has done so by sending the atom `finished` as a message to\n\"pong\" so that \"pong\" can also finish. Another way to let \"pong\" finish is to\nmake \"pong\" exit if it does not receive a message from ping within a certain\ntime. This can be done by adding a _time-out_ to `pong` as shown in the\nfollowing example:\n\n```erlang\n-module(tut19).\n\n-export([start_ping/1, start_pong/0,  ping/2, pong/0]).\n\nping(0, Pong_Node) ->\n    io:format(\"ping finished~n\", []);\n\nping(N, Pong_Node) ->\n    {pong, Pong_Node} ! {ping, self()},\n    receive\n        pong ->\n            io:format(\"Ping received pong~n\", [])\n    end,\n    ping(N - 1, Pong_Node).\n\npong() ->\n    receive\n        {ping, Ping_PID} ->\n            io:format(\"Pong received ping~n\", []),\n            Ping_PID ! pong,\n            pong()\n    after 5000 ->\n            io:format(\"Pong timed out~n\", [])\n    end.\n\nstart_pong() ->\n    register(pong, spawn(tut19, pong, [])).\n\nstart_ping(Pong_Node) ->\n    spawn(tut19, ping, [3, Pong_Node]).\n```\n\nAfter this is compiled and the file `tut19.beam` is copied to the necessary\ndirectories, the following is seen on (pong@kosken):\n\n```text\n(pong@kosken)1> tut19:start_pong().\ntrue\nPong received ping\nPong received ping\nPong received ping\nPong timed out\n```\n\nAnd the following is seen on (ping@gollum):\n\n```text\n(ping@gollum)1> tut19:start_ping(pong@kosken).\n<0.36.0>\nPing received pong\nPing received pong\nPing received pong\nping finished\n```\n\nThe time-out is set in:\n\n```erlang\npong() ->\n    receive\n        {ping, Ping_PID} ->\n            io:format(\"Pong received ping~n\", []),\n            Ping_PID ! pong,\n            pong()\n    after 5000 ->\n            io:format(\"Pong timed out~n\", [])\n    end.\n```\n\nThe time-out (`after 5000`) is started when `receive` is entered. The time-out\nis canceled if `{ping,Ping_PID}` is received. If `{ping,Ping_PID}` is not\nreceived, the actions following the time-out are done after 5000 milliseconds.\n`after` must be last in the `receive`, that is, preceded by all other message\nreception specifications in the `receive`. It is also possible to call a\nfunction that returned an integer for the time-out:\n\n```erlang\nafter pong_timeout() ->\n```\n\nIn general, there are better ways than using time-outs to supervise parts of a\ndistributed Erlang system. Time-outs are usually appropriate to supervise\nexternal events, for example, if you have expected a message from some external\nsystem within a specified time. For example, a time-out can be used to log a\nuser out of the messenger system if they have not accessed it for, say, ten\nminutes.","title":"Time-outs - Robustness","ref":"robustness.html#time-outs"},{"type":"extras","doc":"Before going into details of the supervision and error handling in an Erlang\nsystem, let us see how Erlang processes terminate, or in Erlang terminology,\n_exit_.\n\nA process which executes [`exit(normal)`](`exit/1`) or simply runs out of things\nto do has a _normal_ exit.\n\nA process which encounters a runtime error (for example, divide by zero, bad\nmatch, trying to call a function that does not exist and so on) exits with an\nerror, that is, has an _abnormal_ exit. A process which executes\n[exit(Reason)](`erlang:exit/1`) where `Reason` is any Erlang term except the\natom `normal`, also has an abnormal exit.\n\nAn Erlang process can set up links to other Erlang processes. If a process calls\n[link(Other_Pid)](`erlang:link/1`) it sets up a bidirectional link between\nitself and the process called `Other_Pid`. When a process terminates, it sends\nsomething called a _signal_ to all the processes it has links to.\n\nThe signal carries information about the pid it was sent from and the exit\nreason.\n\nThe default behaviour of a process that receives a normal exit is to ignore the\nsignal.\n\nThe default behaviour in the two other cases (that is, abnormal exit) above is\nto:\n\n- Bypass all messages to the receiving process.\n- Kill the receiving process.\n- Propagate the same error signal to the links of the killed process.\n\nIn this way you can connect all processes in a transaction together using links.\nIf one of the processes exits abnormally, all the processes in the transaction\nare killed. As it is often wanted to create a process and link to it at the same\ntime, there is a special BIF, [spawn_link](`erlang:spawn_link/1`) that does the\nsame as `spawn`, but also creates a link to the spawned process.\n\nNow an example of the ping pong example using links to terminate \"pong\":\n\n```erlang\n-module(tut20).\n\n-export([start/1,  ping/2, pong/0]).\n\nping(N, Pong_Pid) ->\n    link(Pong_Pid),\n    ping1(N, Pong_Pid).\n\nping1(0, _) ->\n    exit(ping);\n\nping1(N, Pong_Pid) ->\n    Pong_Pid ! {ping, self()},\n    receive\n        pong ->\n            io:format(\"Ping received pong~n\", [])\n    end,\n    ping1(N - 1, Pong_Pid).\n\npong() ->\n    receive\n        {ping, Ping_PID} ->\n            io:format(\"Pong received ping~n\", []),\n            Ping_PID ! pong,\n            pong()\n    end.\n\nstart(Ping_Node) ->\n    PongPID = spawn(tut20, pong, []),\n    spawn(Ping_Node, tut20, ping, [3, PongPID]).\n```\n\n```text\n(s1@bill)3> tut20:start(s2@kosken).\nPong received ping\n<3820.41.0>\nPing received pong\nPong received ping\nPing received pong\nPong received ping\nPing received pong\n```\n\nThis is a slight modification of the ping pong program where both processes are\nspawned from the same `start/1` function, and the \"ping\" process can be spawned\non a separate node. Notice the use of the `link` BIF. \"Ping\" calls\n[`exit(ping)`](`exit/1`) when it finishes and this causes an exit signal to be\nsent to \"pong\", which also terminates.\n\nIt is possible to modify the default behaviour of a process so that it does not\nget killed when it receives abnormal exit signals. Instead, all signals are\nturned into normal messages on the format `{'EXIT',FromPID,Reason}` and added to\nthe end of the receiving process' message queue. This behaviour is set by:\n\n```erlang\nprocess_flag(trap_exit, true)\n```\n\nThere are several other process flags, see [erlang(3)](`erlang:process_flag/2`).\nChanging the default behaviour of a process in this way is usually not done in\nstandard user programs, but is left to the supervisory programs in OTP. However,\nthe ping pong program is modified to illustrate exit trapping.\n\n```erlang\n-module(tut21).\n\n-export([start/1,  ping/2, pong/0]).\n\nping(N, Pong_Pid) ->\n    link(Pong_Pid),\n    ping1(N, Pong_Pid).\n\nping1(0, _) ->\n    exit(ping);\n\nping1(N, Pong_Pid) ->\n    Pong_Pid ! {ping, self()},\n    receive\n        pong ->\n            io:format(\"Ping received pong~n\", [])\n    end,\n    ping1(N - 1, Pong_Pid).\n\npong() ->\n    process_flag(trap_exit, true),\n    pong1().\n\npong1() ->\n    receive\n        {ping, Ping_PID} ->\n            io:format(\"Pong received ping~n\", []),\n            Ping_PID ! pong,\n            pong1();\n        {'EXIT', From, Reason} ->\n            io:format(\"pong exiting, got ~p~n\", [{'EXIT', From, Reason}])\n    end.\n\nstart(Ping_Node) ->\n    PongPID = spawn(tut21, pong, []),\n    spawn(Ping_Node, tut21, ping, [3, PongPID]).\n```\n\n```text\n(s1@bill)1> tut21:start(s2@gollum).\n<3820.39.0>\nPong received ping\nPing received pong\nPong received ping\nPing received pong\nPong received ping\nPing received pong\npong exiting, got {'EXIT',<3820.39.0>,ping}\n```","title":"Error Handling - Robustness","ref":"robustness.html#error-handling"},{"type":"extras","doc":"Let us return to the messenger program and add changes to make it more robust:\n\n```erlang\n%%% Message passing utility.\n%%% User interface:\n%%% login(Name)\n%%%     One user at a time can log in from each Erlang node in the\n%%%     system messenger: and choose a suitable Name. If the Name\n%%%     is already logged in at another node or if someone else is\n%%%     already logged in at the same node, login will be rejected\n%%%     with a suitable error message.\n%%% logoff()\n%%%     Logs off anybody at that node\n%%% message(ToName, Message)\n%%%     sends Message to ToName. Error messages if the user of this\n%%%     function is not logged on or if ToName is not logged on at\n%%%     any node.\n%%%\n%%% One node in the network of Erlang nodes runs a server which maintains\n%%% data about the logged on users. The server is registered as \"messenger\"\n%%% Each node where there is a user logged on runs a client process registered\n%%% as \"mess_client\"\n%%%\n%%% Protocol between the client processes and the server\n%%% ----------------------------------------------------\n%%%\n%%% To server: {ClientPid, logon, UserName}\n%%% Reply {messenger, stop, user_exists_at_other_node} stops the client\n%%% Reply {messenger, logged_on} logon was successful\n%%%\n%%% When the client terminates for some reason\n%%% To server: {'EXIT', ClientPid, Reason}\n%%%\n%%% To server: {ClientPid, message_to, ToName, Message} send a message\n%%% Reply: {messenger, stop, you_are_not_logged_on} stops the client\n%%% Reply: {messenger, receiver_not_found} no user with this name logged on\n%%% Reply: {messenger, sent} Message has been sent (but no guarantee)\n%%%\n%%% To client: {message_from, Name, Message},\n%%%\n%%% Protocol between the \"commands\" and the client\n%%% ----------------------------------------------\n%%%\n%%% Started: messenger:client(Server_Node, Name)\n%%% To client: logoff\n%%% To client: {message_to, ToName, Message}\n%%%\n%%% Configuration: change the server_node() function to return the\n%%% name of the node where the messenger server runs\n\n-module(messenger).\n-export([start_server/0, server/0,\n         logon/1, logoff/0, message/2, client/2]).\n\n%%% Change the function below to return the name of the node where the\n%%% messenger server runs\nserver_node() ->\n    messenger@super.\n\n%%% This is the server process for the \"messenger\"\n%%% the user list has the format [{ClientPid1, Name1},{ClientPid22, Name2},...]\nserver() ->\n    process_flag(trap_exit, true),\n    server([]).\n\nserver(User_List) ->\n    receive\n        {From, logon, Name} ->\n            New_User_List = server_logon(From, Name, User_List),\n            server(New_User_List);\n        {'EXIT', From, _} ->\n            New_User_List = server_logoff(From, User_List),\n            server(New_User_List);\n        {From, message_to, To, Message} ->\n            server_transfer(From, To, Message, User_List),\n            io:format(\"list is now: ~p~n\", [User_List]),\n            server(User_List)\n    end.\n\n%%% Start the server\nstart_server() ->\n    register(messenger, spawn(messenger, server, [])).\n\n%%% Server adds a new user to the user list\nserver_logon(From, Name, User_List) ->\n    %% check if logged on anywhere else\n    case lists:keymember(Name, 2, User_List) of\n        true ->\n            From ! {messenger, stop, user_exists_at_other_node},  %reject logon\n            User_List;\n        false ->\n            From ! {messenger, logged_on},\n            link(From),\n            [{From, Name} | User_List]        %add user to the list\n    end.\n\n%%% Server deletes a user from the user list\nserver_logoff(From, User_List) ->\n    lists:keydelete(From, 1, User_List).\n\n\n%%% Server transfers a message between user\nserver_transfer(From, To, Message, User_List) ->\n    %% check that the user is logged on and who he is\n    case lists:keysearch(From, 1, User_List) of\n        false ->\n            From ! {messenger, stop, you_are_not_logged_on};\n        {value, {_, Name}} ->\n            server_transfer(From, Name, To, Message, User_List)\n    end.\n\n%%% If the user exists, send the message\nserver_transfer(From, Name, To, Message, User_List) ->\n    %% Find the receiver and send the message\n    case lists:keysearch(To, 2, User_List) of\n        false ->\n            From ! {messenger, receiver_not_found};\n        {value, {ToPid, To}} ->\n            ToPid ! {message_from, Name, Message},\n            From ! {messenger, sent}\n    end.\n\n%%% User Commands\nlogon(Name) ->\n    case whereis(mess_client) of\n        undefined ->\n            register(mess_client,\n                     spawn(messenger, client, [server_node(), Name]));\n        _ -> already_logged_on\n    end.\n\nlogoff() ->\n    mess_client ! logoff.\n\nmessage(ToName, Message) ->\n    case whereis(mess_client) of % Test if the client is running\n        undefined ->\n            not_logged_on;\n        _ -> mess_client ! {message_to, ToName, Message},\n             ok\nend.\n\n%%% The client process which runs on each user node\nclient(Server_Node, Name) ->\n    {messenger, Server_Node} ! {self(), logon, Name},\n    await_result(),\n    client(Server_Node).\n\nclient(Server_Node) ->\n    receive\n        logoff ->\n            exit(normal);\n        {message_to, ToName, Message} ->\n            {messenger, Server_Node} ! {self(), message_to, ToName, Message},\n            await_result();\n        {message_from, FromName, Message} ->\n            io:format(\"Message from ~p: ~p~n\", [FromName, Message])\n    end,\n    client(Server_Node).\n\n%%% wait for a response from the server\nawait_result() ->\n    receive\n        {messenger, stop, Why} -> % Stop the client\n            io:format(\"~p~n\", [Why]),\n            exit(normal);\n        {messenger, What} ->  % Normal response\n            io:format(\"~p~n\", [What])\n    after 5000 ->\n            io:format(\"No response from server~n\", []),\n            exit(timeout)\n    end.\n```\n\nThe following changes are added:\n\nThe messenger server traps exits. If it receives an exit signal,\n`{'EXIT',From,Reason}`, this means that a client process has terminated or is\nunreachable for one of the following reasons:\n\n- The user has logged off (the \"logoff\" message is removed).\n- The network connection to the client is broken.\n- The node on which the client process resides has gone down.\n- The client processes has done some illegal operation.\n\nIf an exit signal is received as above, the tuple `{From,Name}` is deleted from\nthe servers `User_List` using the `server_logoff` function. If the node on which\nthe server runs goes down, an exit signal (automatically generated by the\nsystem) is sent to all of the client processes:\n`{'EXIT',MessengerPID,noconnection}` causing all the client processes to\nterminate.\n\nAlso, a time-out of five seconds has been introduced in the `await_result`\nfunction. That is, if the server does not reply within five seconds (5000 ms),\nthe client terminates. This is only needed in the logon sequence before the\nclient and the server are linked.\n\nAn interesting case is if the client terminates before the server links to it.\nThis is taken care of because linking to a non-existent process causes an exit\nsignal, `{'EXIT',From,noproc}`, to be automatically generated. This is as if the\nprocess terminated immediately after the link operation.","title":"The Larger Example with Robustness Added - Robustness","ref":"robustness.html#the-larger-example-with-robustness-added"},{"type":"extras","doc":"<!--\n%CopyrightBegin%\n\nCopyright Ericsson AB 2023-2024. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# Records and Macros\n\nLarger programs are usually written as a collection of files with a well-defined\ninterface between the various parts.","title":"Records and Macros","ref":"records_macros.html"},{"type":"extras","doc":"To illustrate this, the messenger example from the previous section is divided\ninto the following five files:\n\n- `mess_config.hrl`\n\n  Header file for configuration data\n\n- `mess_interface.hrl`\n\n  Interface definitions between the client and the messenger\n\n- `user_interface.erl`\n\n  Functions for the user interface\n\n- `mess_client.erl`\n\n  Functions for the client side of the messenger\n\n- `mess_server.erl`\n\n  Functions for the server side of the messenger\n\nWhile doing this, the message passing interface between the shell, the client,\nand the server is cleaned up and is defined using _records_. Also, _macros_ are\nintroduced:\n\n```erlang\n%%%----FILE mess_config.hrl----\n\n%%% Configure the location of the server node,\n-define(server_node, messenger@super).\n\n%%%----END FILE----\n```\n\n```erlang\n%%%----FILE mess_interface.hrl----\n\n%%% Message interface between client and server and client shell for\n%%% messenger program\n\n%%%Messages from Client to server received in server/1 function.\n-record(logon,{client_pid, username}).\n-record(message,{client_pid, to_name, message}).\n%%% {'EXIT', ClientPid, Reason}  (client terminated or unreachable.\n\n%%% Messages from Server to Client, received in await_result/0 function\n-record(abort_client,{message}).\n%%% Messages are: user_exists_at_other_node,\n%%%               you_are_not_logged_on\n-record(server_reply,{message}).\n%%% Messages are: logged_on\n%%%               receiver_not_found\n%%%               sent  (Message has been sent (no guarantee)\n%%% Messages from Server to Client received in client/1 function\n-record(message_from,{from_name, message}).\n\n%%% Messages from shell to Client received in client/1 function\n%%% spawn(mess_client, client, [server_node(), Name])\n-record(message_to,{to_name, message}).\n%%% logoff\n\n%%%----END FILE----\n```\n\n```erlang\n%%%----FILE user_interface.erl----\n\n%%% User interface to the messenger program\n%%% login(Name)\n%%%     One user at a time can log in from each Erlang node in the\n%%%     system messenger: and choose a suitable Name. If the Name\n%%%     is already logged in at another node or if someone else is\n%%%     already logged in at the same node, login will be rejected\n%%%     with a suitable error message.\n\n%%% logoff()\n%%%     Logs off anybody at that node\n\n%%% message(ToName, Message)\n%%%     sends Message to ToName. Error messages if the user of this\n%%%     function is not logged on or if ToName is not logged on at\n%%%     any node.\n\n-module(user_interface).\n-export([logon/1, logoff/0, message/2]).\n-include(\"mess_interface.hrl\").\n-include(\"mess_config.hrl\").\n\nlogon(Name) ->\n    case whereis(mess_client) of\n        undefined ->\n            register(mess_client,\n                     spawn(mess_client, client, [?server_node, Name]));\n        _ -> already_logged_on\n    end.\n\nlogoff() ->\n    mess_client ! logoff.\n\nmessage(ToName, Message) ->\n    case whereis(mess_client) of % Test if the client is running\n        undefined ->\n            not_logged_on;\n        _ -> mess_client ! #message_to{to_name=ToName, message=Message},\n             ok\nend.\n\n%%%----END FILE----\n```\n\n```erlang\n%%%----FILE mess_client.erl----\n\n%%% The client process which runs on each user node\n\n-module(mess_client).\n-export([client/2]).\n-include(\"mess_interface.hrl\").\n\nclient(Server_Node, Name) ->\n    {messenger, Server_Node} ! #logon{client_pid=self(), username=Name},\n    await_result(),\n    client(Server_Node).\n\nclient(Server_Node) ->\n    receive\n        logoff ->\n            exit(normal);\n        #message_to{to_name=ToName, message=Message} ->\n            {messenger, Server_Node} !\n                #message{client_pid=self(), to_name=ToName, message=Message},\n            await_result();\n        {message_from, FromName, Message} ->\n            io:format(\"Message from ~p: ~p~n\", [FromName, Message])\n    end,\n    client(Server_Node).\n\n%%% wait for a response from the server\nawait_result() ->\n    receive\n        #abort_client{message=Why} ->\n            io:format(\"~p~n\", [Why]),\n            exit(normal);\n        #server_reply{message=What} ->\n            io:format(\"~p~n\", [What])\n    after 5000 ->\n            io:format(\"No response from server~n\", []),\n            exit(timeout)\n    end.\n\n%%%----END FILE---\n```\n\n```erlang\n%%%----FILE mess_server.erl----\n\n%%% This is the server process of the messenger service\n\n-module(mess_server).\n-export([start_server/0, server/0]).\n-include(\"mess_interface.hrl\").\n\nserver() ->\n    process_flag(trap_exit, true),\n    server([]).\n\n%%% the user list has the format [{ClientPid1, Name1},{ClientPid22, Name2},...]\nserver(User_List) ->\n    io:format(\"User list = ~p~n\", [User_List]),\n    receive\n        #logon{client_pid=From, username=Name} ->\n            New_User_List = server_logon(From, Name, User_List),\n            server(New_User_List);\n        {'EXIT', From, _} ->\n            New_User_List = server_logoff(From, User_List),\n            server(New_User_List);\n        #message{client_pid=From, to_name=To, message=Message} ->\n            server_transfer(From, To, Message, User_List),\n            server(User_List)\n    end.\n\n%%% Start the server\nstart_server() ->\n    register(messenger, spawn(?MODULE, server, [])).\n\n%%% Server adds a new user to the user list\nserver_logon(From, Name, User_List) ->\n    %% check if logged on anywhere else\n    case lists:keymember(Name, 2, User_List) of\n        true ->\n            From ! #abort_client{message=user_exists_at_other_node},\n            User_List;\n        false ->\n            From ! #server_reply{message=logged_on},\n            link(From),\n            [{From, Name} | User_List]        %add user to the list\n    end.\n\n%%% Server deletes a user from the user list\nserver_logoff(From, User_List) ->\n    lists:keydelete(From, 1, User_List).\n\n%%% Server transfers a message between user\nserver_transfer(From, To, Message, User_List) ->\n    %% check that the user is logged on and who he is\n    case lists:keysearch(From, 1, User_List) of\n        false ->\n            From ! #abort_client{message=you_are_not_logged_on};\n        {value, {_, Name}} ->\n            server_transfer(From, Name, To, Message, User_List)\n    end.\n%%% If the user exists, send the message\nserver_transfer(From, Name, To, Message, User_List) ->\n    %% Find the receiver and send the message\n    case lists:keysearch(To, 2, User_List) of\n        false ->\n            From ! #server_reply{message=receiver_not_found};\n        {value, {ToPid, To}} ->\n            ToPid ! #message_from{from_name=Name, message=Message},\n            From !  #server_reply{message=sent}\n    end.\n\n%%%----END FILE---\n```","title":"The Larger Example Divided into Several Files - Records and Macros","ref":"records_macros.html#the-larger-example-divided-into-several-files"},{"type":"extras","doc":"As shown above, some files have extension `.hrl`. These are header files that\nare included in the `.erl` files by:\n\n```erlang\n-include(\"File_Name\").\n```\n\nfor example:\n\n```erlang\n-include(\"mess_interface.hrl\").\n```\n\nIn the case above the file is fetched from the same directory as all the other\nfiles in the messenger example. (_manual_).\n\n.hrl files can contain any valid Erlang code but are most often used for record\nand macro definitions.","title":"Header Files - Records and Macros","ref":"records_macros.html#header-files"},{"type":"extras","doc":"A record is defined as:\n\n```erlang\n-record(name_of_record,{field_name1, field_name2, field_name3, ......}).\n```\n\nFor example:\n\n```erlang\n-record(message_to,{to_name, message}).\n```\n\nThis is equivalent to:\n\n```erlang\n{message_to, To_Name, Message}\n```\n\nCreating a record is best illustrated by an example:\n\n```erlang\n#message_to{message=\"hello\", to_name=fred)\n```\n\nThis creates:\n\n```erlang\n{message_to, fred, \"hello\"}\n```\n\nNotice that you do not have to worry about the order you assign values to the\nvarious parts of the records when you create it. The advantage of using records\nis that by placing their definitions in header files you can conveniently define\ninterfaces that are easy to change. For example, if you want to add a new field\nto the record, you only have to change the code where the new field is used and\nnot at every place the record is referred to. If you leave out a field when\ncreating a record, it gets the value of the atom `undefined`. (_manual_)\n\nPattern matching with records is very similar to creating records. For example,\ninside a `case` or `receive`:\n\n```erlang\n#message_to{to_name=ToName, message=Message} ->\n```\n\nThis is the same as:\n\n```erlang\n{message_to, ToName, Message}\n```","title":"Records - Records and Macros","ref":"records_macros.html#records"},{"type":"extras","doc":"Another thing that has been added to the messenger is a macro. The file\n`mess_config.hrl` contains the definition:\n\n```erlang\n%%% Configure the location of the server node,\n-define(server_node, messenger@super).\n```\n\nThis file is included in `mess_server.erl`:\n\n```erlang\n-include(\"mess_config.hrl\").\n```\n\nEvery occurrence of `?server_node` in `mess_server.erl` is now replaced by\n`messenger@super`.\n\nA macro is also used when spawning the server process:\n\n```erlang\nspawn(?MODULE, server, [])\n```\n\nThis is a standard macro (that is, defined by the system, not by the user).\n`?MODULE` is always replaced by the name of the current module (that is, the\n`-module` definition near the start of the file). There are more advanced ways\nof using macros with, for example, [parameters](macros.md#defining-and-using-macros).\n\nThe three Erlang (`.erl`) files in the messenger example are individually\ncompiled into object code file (`.beam`). The Erlang system loads and links\nthese files into the system when they are referred to during execution of the\ncode. In this case, they are simply put in our current working directory (that\nis, the place you have done \"cd\" to). There are ways of putting the `.beam`\nfiles in other directories.\n\nIn the messenger example, no assumptions have been made about what the message\nbeing sent is. It can be any valid Erlang term.","title":"Macros - Records and Macros","ref":"records_macros.html#macros"},{"type":"extras","doc":"<!--\n%CopyrightBegin%\n\nCopyright Ericsson AB 2023-2024. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# System Principles\n\n[](){: #system-principles }","title":"System Principles","ref":"system_principles.html"},{"type":"extras","doc":"An Erlang runtime system is started with command `erl`:\n\n```text\n% erl\nErlang/OTP 27 [erts-15.0] [64-bit] [smp:8:8] [ds:8:8:10] [async-threads:1] [jit]\n\nEshell V15.0 (press Ctrl+G to abort, type help(). for help)\n1>\n```\n\n`erl` understands a number of command-line arguments; see\n[erl](`e:erts:erl_cmd.md`) in the ERTS application. Some arguments are\nalso described in this chapter.\n\nApplication programs can access the values of the command-line arguments by\ncalling one of the following functions:\n\n* [`init:get_argument(Key)`](https://www.erlang.org/doc/man/init#get_argument-1)\n* [`init:get_arguments()`](https://www.erlang.org/doc/man/init#get_arguments-0)\n* [`init:get_plain_arguments()`](https://www.erlang.org/doc/man/init#get_plain_arguments-0)","title":"Starting the System - System Principles","ref":"system_principles.html#starting-the-system"},{"type":"extras","doc":"The runtime system is halted by calling\n[`halt/0,1,2`](https://www.erlang.org/doc/man/erlang#halt-2).\n\nModule `m:init` contains functions for restarting, rebooting, and stopping the\nruntime system:\n\n* [`init:restart()`](https://www.erlang.org/doc/man/init#restart-0)\n* [`init:reboot()`](https://www.erlang.org/doc/man/init#reboot-0)\n* [`init:stop()`](https://www.erlang.org/doc/man/init#stop-0)\n\nThe runtime system terminates if the Erlang shell is terminated.\n\n[](){: #BOOTSCRIPT }","title":"Restarting and Stopping the System - System Principles","ref":"system_principles.html#restarting-and-stopping-the-system"},{"type":"extras","doc":"The runtime system is started using a _boot script_. The boot script contains\ninstructions on which code to load and which processes and applications to\nstart.\n\nA boot script file has the extension `.script`. The runtime system uses a binary\nversion of the script. This _binary boot script_ file has the extension `.boot`.\n\nWhich boot script to use is specified by the command-line flag `-boot`. The\nextension `.boot` is to be omitted. For example, using the boot script\n`start_all.boot`:\n\n```text\n% erl -boot start_all\n```\n\nIf no boot script is specified, it defaults to `ROOT/bin/start`, where\n`ROOT` is the installation directory of Erlang/OTP. See [Default Boot\nScripts](system_principles.md#default_boot_scripts).\n\nWhen the command-line flag `-init_debug` is used, the `init` process will\noutput debug information while interpreting the boot script.\n\n```text\n% erl -init_debug\n{progress,preloaded}\n{progress,kernel_load_completed}\n{progress,modules_loaded}\n{start,heart}\n{start,logger}\n  .\n  .\n  .\n```\n\nFor a detailed description of the syntax and contents of the boot script, see\n[`script`](https://www.erlang.org/doc/man/script) in the SASL application.\n\n[](){: #default_boot_scripts }","title":"Boot Scripts - System Principles","ref":"system_principles.html#boot-scripts"},{"type":"extras","doc":"Erlang/OTP comes with these boot scripts:\n\n- `start_clean.boot` \\- Loads the code for and starts the applications Kernel\n  and STDLIB.\n- `start_sasl.boot` \\- Loads the code for and starts the applications Kernel,\n  STDLIB, and SASL.\n- `no_dot_erlang.boot` \\- Loads the code for and starts the applications Kernel\n  and STDLIB. Skips loading the file `.erlang`. Useful for scripts and other\n  tools that are to behave the same irrespective of user preferences.\n\nWhich of `start_clean` and `start_sasl` to use as default is decided by the user\nwhen installing Erlang/OTP using `Install`. The user is asked:\n\n```text\nDo you want to use a minimal system startup instead of the SASL startup?\n```\n\nIf the answer is yes, `start_clean` is used, otherwise `start_sasl` is\nused. The chosen boot script is copied and renamed as `start.boot`,\nthen placed into directory `ROOT/bin`.","title":"Default Boot Scripts - System Principles","ref":"system_principles.html#default-boot-scripts"},{"type":"extras","doc":"It is sometimes useful or necessary to create a user-defined boot script. This\nis true especially when running Erlang in embedded mode; see\n[Code Loading Strategy](system_principles.md#code_loading).\n\nWhile it is possible to manually create a boot script, it is\npreferable to generate it from a release resource file called\n`Name.rel` using the function\n[`systools:make_script/1,2`](https://www.erlang.org/doc/man/systools#make_script-2).\nThis requires that the source code is structured as applications\naccording to the OTP design principles.\n\nFor more information about `.rel` files, see\n[OTP Design Principles](`e:system:release_handling.md`) and the\n[rel](`e:sasl:rel.md`) page in SASL.\n\nTo generate the binary boot script file `Name.boot` the boot script file\n`Name.script`, use the\n[`systools:script2boot(File)`](https://www.erlang.org/doc/man/systools#script2boot-1)\nfunction.\n\n[](){: #code_loading }","title":"User-Defined Boot Scripts - System Principles","ref":"system_principles.html#user-defined-boot-scripts"},{"type":"extras","doc":"The runtime system can be started in either _embedded_ or _interactive_ mode.\nWhich one is decided by the command-line flag `-mode`:\n\n```text\n% erl -mode embedded\n```\n\nThe default mode is `interactive`. If more than one `-mode` flag is given,\nthe first one will be used.\n\nThe mode properties are as follows:\n\n- In embedded mode, all code is loaded during system startup according\n  to the boot script. (Code can be loaded later by **explicitly**\n  ordering the code server to load it.)\n\n- In interactive mode, code is dynamically loaded when first required,\n  which means that when an attempt is made to call a function in a\n  module that is not loaded, the code server searches the code path\n  and loads the module into the system.\n\nInitially, the code path consists of the current working directory and\nall object code directories under `ROOT/lib`, where `ROOT` is the\ninstallation directory of Erlang/OTP. Directories can be named\n`Name[-Vsn]`, where the `-Vsn` suffix is optional. By default, the\ncode server chooses the directory with the highest version number\namong those which have the same `Name`. If an `ebin` directory exists\nunder the `Name[-Vsn]` directory, this directory is added to the code\npath.\n\nThe code path can be extended by using the command-line flags `-pa Directories`\nand `-pz Directories`. These add `Directories` to the head or the end of the\ncode path, respectively. Example:\n\n```text\n% erl -pa /home/arne/mycode\n```\n\nThe `m:code` module contains a number of functions for modifying and\nquerying the search path.","title":"Code Loading Strategy - System Principles","ref":"system_principles.html#code-loading-strategy"},{"type":"extras","doc":"The following file types are defined in Erlang/OTP:\n\n| _File Type_               | _File Name/Extension_ | _Documented in_                                     |\n| ------------------------- | --------------------- | --------------------------------------------------- |\n| Module                    | `.erl`                | [Erlang Reference Manual](`e:system:modules.md`)    |\n| Include file              | `.hrl`                | [Erlang Reference Manual](`e:system:modules.md`)    |\n| Release resource file     | `.rel`                | [rel](`e:sasl:rel.md`) in SASL                      |\n| Application resource file | `.app`                | [app](`e:kernel:app.md`) in Kernel                  |\n| Boot script               | `.script`             | [script](`e:sasl:script.md`) in SASL                |\n| Binary boot script        | `.boot`               | -                                                   |\n| Configuration file        | `.config`             | [config](`e:kernel:config.md`) in Kernel            |\n| Application upgrade file  | `.appup`              | [appup](`e:sasl:appup.md`) in SASL                  |\n| Release upgrade file      | `relup`               | [relup](`e:sasl:relup.md`) in SASL                  |\n\n_Table: File Types_","title":"File Types - System Principles","ref":"system_principles.html#file-types"},{"type":"extras","doc":"<!--\n%CopyrightBegin%\n\nCopyright Ericsson AB 2023-2024. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# Error Logging\n\n[](){: #error-logging }","title":"Error Logging","ref":"error_logging.html"},{"type":"extras","doc":"Error information from the runtime system, that is, information about a process\nterminating because of an uncaught error exception, is by default written to\nthe terminal (TTY):\n\n```text\n=ERROR REPORT==== 9-Dec-2003::13:25:02 ===\nError in process <0.27.0> with exit value: {{badmatch,[1,2,3]},[{m,f,1},{shell,eval_loop,2}]}\n```\n\nThe error information is handled by Logger, which is part of the Kernel\napplication.\n\nThe exit reasons (such as `badarg`) used by the runtime system are described in\n[Errors and Error Handling](`e:system:errors.md#exit_reasons`).\n\nFor information about Logger and its user interface, see the `m:logger` manual\npage and the [Logging](`e:kernel:logger_chapter.md`) section in the Kernel\nUser's Guide. The system can be configured so that log events are written to\nfile or to the TTY, or both. In addition, user-defined applications can send and\nformat log events using Logger.","title":"Error Information From the Runtime System - Error Logging","ref":"error_logging.html#error-information-from-the-runtime-system"},{"type":"extras","doc":"The standard behaviours (`supervisor`, `gen_server`, and so on) send progress\nand error information to Logger. Progress reports are by default not logged, but\ncan be enabled by setting the primary log level to `info`, for example by using\nthe Kernel configuration parameter `logger_level`. Supervisor reports, crash\nreports and other error and information reports are by default logged through\nthe log handler which is set up when the Kernel application is started.\n\nPrior to Erlang/OTP 21.0, supervisor, crash, and progress reports were only\nlogged when the SASL application was running. This behaviour can, for backwards\ncompatibility, be enabled by setting the Kernel configuration parameter\n[`logger_sasl_compatible`](`e:kernel:kernel_app.md#logger_sasl_compatible`) to\n`true`. For more information, see\n[SASL Error Logging](`e:sasl:error_logging.md`) in the SASL User's Guide.\n\n```erlang\n% erl -kernel logger_level info\nErlang/OTP 21 [erts-10.0] [source-13c50db] [64-bit] [smp:4:4] [ds:4:4:10] [async-threads:1] [hipe]\n\n=PROGRESS REPORT==== 8-Jun-2018::16:54:19.916404 ===\n    application: kernel\n    started_at: nonode@nohost\n=PROGRESS REPORT==== 8-Jun-2018::16:54:19.922908 ===\n    application: stdlib\n    started_at: nonode@nohost\n=PROGRESS REPORT==== 8-Jun-2018::16:54:19.925755 ===\n    supervisor: {local,kernel_safe_sup}\n    started: [{pid,<0.74.0>},\n              {id,disk_log_sup},\n              {mfargs,{disk_log_sup,start_link,[]}},\n              {restart_type,permanent},\n              {shutdown,1000},\n              {child_type,supervisor}]\n=PROGRESS REPORT==== 8-Jun-2018::16:54:19.926056 ===\n    supervisor: {local,kernel_safe_sup}\n    started: [{pid,<0.75.0>},\n              {id,disk_log_server},\n              {mfargs,{disk_log_server,start_link,[]}},\n              {restart_type,permanent},\n              {shutdown,2000},\n              {child_type,worker}]\nEshell V10.0  (abort with ^G)\n1>\n```","title":"Log events from OTP behaviours - Error Logging","ref":"error_logging.html#log-events-from-otp-behaviours"},{"type":"extras","doc":"<!--\n%CopyrightBegin%\n\nCopyright Ericsson AB 2023-2024. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# Creating and Upgrading a Target System\n\n[](){: #creating-upgrading-target-system }\n\nWhen creating a system using Erlang/OTP, the simplest way is to install\nErlang/OTP somewhere, install the application-specific code somewhere else, and\nthen start the Erlang runtime system, making sure the code path includes the\napplication-specific code.\n\nIt is often not desirable to use an Erlang/OTP system as is. A developer can\ncreate new Erlang/OTP-compliant applications for a particular purpose, and\nseveral original Erlang/OTP applications can be irrelevant for the purpose in\nquestion. Thus, there is a need to be able to create a new system based on a\ngiven Erlang/OTP system, where dispensable applications are removed and new\napplications are included. Documentation and source code is irrelevant and is\ntherefore not included in the new system.\n\nThis chapter is about creating such a system, which is called a _target system_.\n\nThe following sections deal with target systems with different requirements of\nfunctionality:\n\n- A _basic target system_ that can be started by calling the ordinary `erl`\n  script.\n- A _simple target system_ that also supports code replacement in runtime.\n- An _embedded target system_ that also supports starting automatically\n  at boot time, and logging output from the system files for later inspection.\n\nHere is only considered the case when Erlang/OTP is running on a UNIX system.\n\nThe `sasl` application includes the example Erlang module `target_system.erl`,\nwhich contains functions for creating and installing a target system. This\nmodule is used in the following examples. The source code of the module is\nlisted in\n[Listing of target_system.erl](create_target.md#listing-of-target-system)\n\n[](){: #create }","title":"Creating and Upgrading a Target System","ref":"create_target.html"},{"type":"extras","doc":"It is assumed that you have a working Erlang/OTP system structured according to\nthe OTP design principles.\n\n_Step 1._ Create a `.rel` file (see the [rel(4)](`e:sasl:rel.md`) manual page in\nSASL), which specifies the ERTS version and lists all applications that are to\nbe included in the new basic target system. An example is the following\n`mysystem.rel` file:\n\n```erlang\n%% mysystem.rel\n{release,\n {\"MYSYSTEM\", \"FIRST\"},\n {erts, \"5.10.4\"},\n [{kernel, \"2.16.4\"},\n  {stdlib, \"1.19.4\"},\n  {sasl, \"2.3.4\"},\n  {pea, \"1.0\"}]}.\n```\n\nThe listed applications are not only original Erlang/OTP applications but\npossibly also new applications that you have written (here exemplified by the\napplication Pea (`pea`)).\n\n_Step 2._ Start Erlang/OTP from the directory where the `mysystem.rel` file\nresides:\n\n```text\n% erl -pa /home/user/target_system/myapps/pea-1.0/ebin\n```\n\nThe `-pa` argument prepends the path to the `ebin` directory for\nthe Pea application to the code path.\n\n_Step 3._ Create the target system:\n\n```text\n1> target_system:create(\"mysystem\").\n```\n\nThe function `target_system:create/1` performs the following:\n\n1. Reads the file `mysystem.rel` and creates a new file `plain.rel`.\n   The new file is identical to the original, except that it only\n   lists the Kernel and STDLIB applications.\n\n1. From the files `mysystem.rel` and `plain.rel` creates the files\n   `mysystem.script`, `mysystem.boot`, `plain.script`, and `plain.boot`\n   by calling `systools:make_script/2`.\n\n1. Creates the file `mysystem.tar.gz` by calling `systools:make_tar/2`. That\n   file has the following contents:\n\n```text\nerts-5.10.4/bin/\nreleases/FIRST/start.boot\nreleases/FIRST/mysystem.rel\nreleases/mysystem.rel\nlib/kernel-2.16.4/\nlib/stdlib-1.19.4/\nlib/sasl-2.3.4/\nlib/pea-1.0/\n```\n\nThe file `releases/FIRST/start.boot` is a copy of our `mysystem.boot`\n\nThe release resource file `mysystem.rel` is duplicated in the tar file.\nOriginally, this file was only stored in the `releases` directory to make it\npossible for the `release_handler` to extract this file separately. After\nunpacking the tar file, `release_handler` would automatically copy the file to\n`releases/FIRST`. However, sometimes the tar file is unpacked without involving\nthe `release_handler` (for example, when unpacking the first target system).\nHence, the file is now duplicated within the tar archive, eliminating the\nneed for manual copying.\n\n1. Creates the temporary directory `tmp` and extracts the tar file\n   `mysystem.tar.gz` into that directory.\n1. Deletes the files `erl` and `start` from `tmp/erts-5.10.4/bin`. These files\n   are created again from source when installing the release.\n1. Creates the directory `tmp/bin`.\n1. Copies the previously created file `plain.boot` to `tmp/bin/start.boot`.\n1. Copies the files `epmd`, `run_erl`, and `to_erl` from the directory\n   `tmp/erts-5.10.4/bin` to the directory `tmp/bin`.\n1. Creates the directory `tmp/log`, which is used if the system is started as\n   embedded with the `bin/start` script.\n1. Creates the file `tmp/releases/start_erl.data` with the contents \"5.10.4\n   FIRST\". This file is to be passed as data file to the `start_erl` script.\n1. Recreates the file `mysystem.tar.gz` from the directories in the directory\n   `tmp` and removes `tmp`.","title":"Creating a Target System - Creating and Upgrading a Target System","ref":"create_target.html#creating-a-target-system"},{"type":"extras","doc":"_Step 4._ Install the created target system in a suitable directory.\n\n```text\n2> target_system:install(\"mysystem\", \"/usr/local/erl-target\").\n```\n\nThe function `target_system:install/2` performs the following:\n\n1. Extracts the tar file `mysystem.tar.gz` into the target directory\n   `/usr/local/erl-target`.\n1. In the target directory reads the file `releases/start_erl.data` to find the\n   Erlang runtime system version (\"5.10.4\").\n1. Substitutes `%FINAL_ROOTDIR%` and `%EMU%` for `/usr/local/erl-target` and\n   `beam`, respectively, in the files `erl.src`, `start.src`, and\n   `start_erl.src` of the target `erts-5.10.4/bin` directory, and puts the\n   resulting files `erl`, `start`, and `run_erl` in the target `bin` directory.\n1. Finally the target `releases/RELEASES` file is created from data in the file\n   `releases/mysystem.rel`.\n\n[](){: #start }","title":"Installing a Target System - Creating and Upgrading a Target System","ref":"create_target.html#installing-a-target-system"},{"type":"extras","doc":"Now we have a target system that can be started in various ways. We start it as\na _basic target system_ by invoking:\n\n```text\n% /usr/local/erl-target/bin/erl\n```\n\nHere only the Kernel and STDLIB applications are started, that is, the system is\nstarted as an ordinary development system. Only two files are needed for all\nthis to work:\n\n1. `bin/erl` (obtained from `erts-5.10.4/bin/erl.src`)\n1. `bin/start.boot` (a copy of `plain.boot`)\n\nWe can also start a distributed system (requires `bin/epmd`).\n\nTo start all applications specified in the original `mysystem.rel` file, use\nflag `-boot` as follows:\n\n```text\n% /usr/local/erl-target/bin/erl -boot /usr/local/erl-target/releases/FIRST/start\n```\n\nWe start a _simple target system_ as above. The only difference is that also the\nfile `releases/RELEASES` is present for code replacement in runtime to work.\n\nTo start an _embedded target system_, the shell script `bin/start` is used. The\nscript calls `bin/run_erl`, which in turn calls `bin/start_erl` (roughly,\n`start_erl` is an embedded variant of `erl`).\n\nThe shell script `start`, which is generated from `erts-5.10.4/bin/start.src`\nduring installation, is merely an example. Edit it to suite your needs. Typically\nit is executed when the UNIX system boots.\n\n`run_erl` is a wrapper that provides logging of output from the runtime system\nto file. It also provides a simple mechanism for attaching to the Erlang shell\n(`to_erl`).\n\n`start_erl` requires:\n\n1. The root directory (`\"/usr/local/erl-target\"`)\n1. The releases directory (`\"/usr/local/erl-target/releases\"`\n1. The location of the file `start_erl.data`\n\nIt performs the following:\n\n1. Reads the runtime system version (`\"5.10.4\"`) and release version (`\"FIRST\"`)\n   from the file `start_erl.data`.\n1. Starts the runtime system of the version found.\n1. Provides the flag `-boot` specifying the boot file of the release version\n   found (`\"releases/FIRST/start.boot\"`).\n\n`start_erl` also assumes that there is `sys.config` in the release version\ndirectory (`\"releases/FIRST/sys.config\"`). That is the topic of the next\nsection.\n\nThe `start_erl` shell script is normally not to be altered by the user.","title":"Starting a Target System - Creating and Upgrading a Target System","ref":"create_target.html#starting-a-target-system"},{"type":"extras","doc":"As was mentioned in the previous section, `start_erl` requires a `sys.config` in\nthe release version directory (`\"releases/FIRST/sys.config\"`). If there is no\nsuch file, the system start fails. Such a file must therefore also be added.\n\nIf you have system configuration data that is neither file-location-dependent\nnor site-dependent, it can be convenient to create `sys.config` early, so it\nbecomes part of the target system tar file created by `target_system:create/1`.\nIn fact, if you in the current directory create not only the file\n`mysystem.rel`, but also file `sys.config`, the latter file is tacitly put in\nthe appropriate directory.\n\nHowever, it can also be convenient to replace variables in within a `sys.config`\non the target after unpacking but before running the release. If you have a\n`sys.config.src` it will be included and is not required to be a valid Erlang\nterm file like `sys.config`. Before running the release you must have a valid\n`sys.config` in the same directory, so using `sys.config.src` requires having\nsome tool to populate what is needed and write `sys.config` to disk before\nbooting the release.","title":"System Configuration Parameters - Creating and Upgrading a Target System","ref":"create_target.html#system-configuration-parameters"},{"type":"extras","doc":"The previous `install/2` procedure differs somewhat from that of the ordinary\n`Install` shell script. In fact, `create/1` makes the release package as\ncomplete as possible, and leave to the `install/2` procedure to finish by only\nconsidering location-dependent files.","title":"Differences From the Install Script - Creating and Upgrading a Target System","ref":"create_target.html#differences-from-the-install-script"},{"type":"extras","doc":"In this example the Pea application has been changed, and so are the\napplications ERTS, Kernel, STDLIB and SASL.\n\n_Step 1._ Create the file `.rel`:\n\n```erlang\n%% mysystem2.rel\n{release,\n {\"MYSYSTEM\", \"SECOND\"},\n {erts, \"6.0\"},\n [{kernel, \"3.0\"},\n  {stdlib, \"2.0\"},\n  {sasl, \"2.4\"},\n  {pea, \"2.0\"}]}.\n```\n\n_Step 2._ Create the application upgrade file (see\n[appup](`e:sasl:appup.md`) in SASL) for Pea, for example:\n\n```erlang\n%% pea.appup\n{\"2.0\",\n [{\"1.0\",[{load_module,pea_lib}]}],\n [{\"1.0\",[{load_module,pea_lib}]}]}.\n```\n\n_Step 3._ From the directory where the file `mysystem2.rel` resides, start the\nErlang/OTP system, giving the path to the new version of Pea:\n\n```text\n% erl -pa /home/user/target_system/myapps/pea-2.0/ebin\n```\n\n_Step 4._ Create the release upgrade file (see [relup](`e:sasl:relup.md`)\nin SASL):\n\n```text\n1> systools:make_relup(\"mysystem2\",[\"mysystem\"],[\"mysystem\"],\n    [{path,[\"/home/user/target_system/myapps/pea-1.0/ebin\",\n    \"/my/old/erlang/lib/*/ebin\"]}]).\n```\n\nHere `\"mysystem\"` is the base release and `\"mysystem2\"` is the release to\nupgrade to.\n\nThe `path` option is used for pointing out the old version of all applications.\n(The new versions are already in the code path - assuming of course that the\nErlang node on which this is executed is running the correct version of\nErlang/OTP.)\n\n_Step 5._ Create the new release:\n\n```text\n2> target_system:create(\"mysystem2\").\n```\n\nGiven that the file `relup` generated in Step 4 is now located in the current\ndirectory, it is automatically included in the release package.","title":"Creating the Next Version - Creating and Upgrading a Target System","ref":"create_target.html#creating-the-next-version"},{"type":"extras","doc":"This part is done on the target node, and for this example we want the node to\nbe running as an embedded system with the `-heart` option, allowing automatic\nrestart of the node. For more information, see\n[Starting a Target System](create_target.md#start).\n\nWe add `-heart` to `bin/start`:\n\n```text\n#!/bin/sh\nROOTDIR=/usr/local/erl-target/\n\nif [ -z \"$RELDIR\" ]\nthen\n   RELDIR=$ROOTDIR/releases\nfi\n\nSTART_ERL_DATA=${1:-$RELDIR/start_erl.data}\n\n$ROOTDIR/bin/run_erl -daemon /tmp/ $ROOTDIR/log \"exec $ROOTDIR/bin/start_erl $ROOTDIR\\\n$RELDIR $START_ERL_DATA -heart\"\n```\n\nWe use the simplest possible `sys.config`, which we store in `releases/FIRST`:\n\n```text\n%% sys.config\n[].\n```\n\nFinally, to prepare the upgrade, we must put the new release package in the\n`releases` directory of the first target system:\n\n```text\n% cp mysystem2.tar.gz /usr/local/erl-target/releases\n```\n\nAssuming that the node has been started as follows:\n\n```text\n% /usr/local/erl-target/bin/start\n```\n\nIt can be accessed as follows:\n\n```text\n% /usr/local/erl-target/bin/to_erl /tmp/erlang.pipe.1\n```\n\nLogs can be found in `/usr/local/erl-target/log`. This directory is specified as\nan argument to `run_erl`in the start script listed above.\n\n_Step 1._ Unpack the release:\n\n```text\n1> {ok,Vsn} = release_handler:unpack_release(\"mysystem2\").\n```\n\n_Step 2._ Install the release:\n\n```text\n2> release_handler:install_release(Vsn).\n{continue_after_restart,\"FIRST\",[]}\nheart: Tue Apr  1 12:15:10 2014: Erlang has closed.\nheart: Tue Apr  1 12:15:11 2014: Executed \"/usr/local/erl-target/bin/start /usr/local/erl-target/releases/new_start_erl.data\" -> 0. Terminating.\n[End]\n```\n\nThe above return value and output after the call to\n`release_handler:install_release/1` means that the `release_handler` has\nrestarted the node by using `heart`. This is always done when the upgrade\ninvolves a change of the applications ERTS, Kernel, STDLIB, or SASL. For more\ninformation, see [Upgrade when Erlang/OTP has Changed](upgrade.md).\n\nThe node is accessible through a new pipe:\n\n```text\n% /usr/local/erl-target/bin/to_erl /tmp/erlang.pipe.2\n```\n\nList the available releases in the system:\n\n```erlang\n1> release_handler:which_releases().\n[{\"MYSYSTEM\",\"SECOND\",\n  [\"kernel-3.0\",\"stdlib-2.0\",\"sasl-2.4\",\"pea-2.0\"],\n  current},\n {\"MYSYSTEM\",\"FIRST\",\n  [\"kernel-2.16.4\",\"stdlib-1.19.4\",\"sasl-2.3.4\",\"pea-1.0\"],\n  permanent}]\n```\n\nOur new release, \"SECOND\", is now the current release, but we can also see that\nour \"FIRST\" release is still permanent. This means that if the node would be\nrestarted now, it would come up running the \"FIRST\" release again.\n\n_Step 3._ Make the new release permanent:\n\n```text\n2> release_handler:make_permanent(\"SECOND\").\n```\n\nCheck the releases again:\n\n```c\n3> release_handler:which_releases().\n[{\"MYSYSTEM\",\"SECOND\",\n  [\"kernel-3.0\",\"stdlib-2.0\",\"sasl-2.4\",\"pea-2.0\"],\n  permanent},\n {\"MYSYSTEM\",\"FIRST\",\n  [\"kernel-2.16.4\",\"stdlib-1.19.4\",\"sasl-2.3.4\",\"pea-1.0\"],\n  old}]\n```\n\nWe see that the new release version is `permanent`, so it would be safe to\nrestart the node.\n\n[](){: #listing-of-target-system }","title":"Upgrading the Target System - Creating and Upgrading a Target System","ref":"create_target.html#upgrading-the-target-system"},{"type":"extras","doc":"This module can also be found in the `examples` directory of the SASL\napplication.\n\n```erlang\n\n-module(target_system).\n-export([create/1, create/2, install/2]).\n\n%% Note: RelFileName below is the *stem* without trailing .rel,\n%% .script etc.\n%%\n\n%% create(RelFileName)\n%%\ncreate(RelFileName) ->\n    create(RelFileName,[]).\n\ncreate(RelFileName,SystoolsOpts) ->\n    RelFile = RelFileName ++ \".rel\",\n    Dir = filename:dirname(RelFileName),\n    PlainRelFileName = filename:join(Dir,\"plain\"),\n    PlainRelFile = PlainRelFileName ++ \".rel\",\n    io:fwrite(\"Reading file: ~ts ...~n\", [RelFile]),\n    {ok, [RelSpec]} = file:consult(RelFile),\n    io:fwrite(\"Creating file: ~ts from ~ts ...~n\",\n              [PlainRelFile, RelFile]),\n    {release,\n     {RelName, RelVsn},\n     {erts, ErtsVsn},\n     AppVsns} = RelSpec,\n    PlainRelSpec = {release,\n                    {RelName, RelVsn},\n                    {erts, ErtsVsn},\n                    lists:filter(fun({kernel, _}) ->\n                                         true;\n                                    ({stdlib, _}) ->\n                                         true;\n                                    (_) ->\n                                         false\n                                 end, AppVsns)\n                   },\n    {ok, Fd} = file:open(PlainRelFile, [write]),\n    io:fwrite(Fd, \"~p.~n\", [PlainRelSpec]),\n    file:close(Fd),\n\n    io:fwrite(\"Making \\\"~ts.script\\\" and \\\"~ts.boot\\\" files ...~n\",\n\t      [PlainRelFileName,PlainRelFileName]),\n    make_script(PlainRelFileName,SystoolsOpts),\n\n    io:fwrite(\"Making \\\"~ts.script\\\" and \\\"~ts.boot\\\" files ...~n\",\n              [RelFileName, RelFileName]),\n    make_script(RelFileName,SystoolsOpts),\n\n    TarFileName = RelFileName ++ \".tar.gz\",\n    io:fwrite(\"Creating tar file ~ts ...~n\", [TarFileName]),\n    make_tar(RelFileName,SystoolsOpts),\n\n    TmpDir = filename:join(Dir,\"tmp\"),\n    io:fwrite(\"Creating directory ~tp ...~n\",[TmpDir]),\n    file:make_dir(TmpDir),\n\n    io:fwrite(\"Extracting ~ts into directory ~ts ...~n\", [TarFileName,TmpDir]),\n    extract_tar(TarFileName, TmpDir),\n\n    TmpBinDir = filename:join([TmpDir, \"bin\"]),\n    ErtsBinDir = filename:join([TmpDir, \"erts-\" ++ ErtsVsn, \"bin\"]),\n    io:fwrite(\"Deleting \\\"erl\\\" and \\\"start\\\" in directory ~ts ...~n\",\n              [ErtsBinDir]),\n    file:delete(filename:join([ErtsBinDir, \"erl\"])),\n    file:delete(filename:join([ErtsBinDir, \"start\"])),\n\n    io:fwrite(\"Creating temporary directory ~ts ...~n\", [TmpBinDir]),\n    file:make_dir(TmpBinDir),\n\n    io:fwrite(\"Copying file \\\"~ts.boot\\\" to ~ts ...~n\",\n              [PlainRelFileName, filename:join([TmpBinDir, \"start.boot\"])]),\n    copy_file(PlainRelFileName++\".boot\",filename:join([TmpBinDir, \"start.boot\"])),\n\n    io:fwrite(\"Copying files \\\"epmd\\\", \\\"run_erl\\\" and \\\"to_erl\\\" from \\n\"\n              \"~ts to ~ts ...~n\",\n              [ErtsBinDir, TmpBinDir]),\n    copy_file(filename:join([ErtsBinDir, \"epmd\"]),\n              filename:join([TmpBinDir, \"epmd\"]), [preserve]),\n    copy_file(filename:join([ErtsBinDir, \"run_erl\"]),\n              filename:join([TmpBinDir, \"run_erl\"]), [preserve]),\n    copy_file(filename:join([ErtsBinDir, \"to_erl\"]),\n              filename:join([TmpBinDir, \"to_erl\"]), [preserve]),\n\n    %% This is needed if 'start' script created from 'start.src' shall\n    %% be used as it points out this directory as log dir for 'run_erl'\n    TmpLogDir = filename:join([TmpDir, \"log\"]),\n    io:fwrite(\"Creating temporary directory ~ts ...~n\", [TmpLogDir]),\n    ok = file:make_dir(TmpLogDir),\n\n    StartErlDataFile = filename:join([TmpDir, \"releases\", \"start_erl.data\"]),\n    io:fwrite(\"Creating ~ts ...~n\", [StartErlDataFile]),\n    StartErlData = io_lib:fwrite(\"~s ~s~n\", [ErtsVsn, RelVsn]),\n    write_file(StartErlDataFile, StartErlData),\n\n    io:fwrite(\"Recreating tar file ~ts from contents in directory ~ts ...~n\",\n\t      [TarFileName,TmpDir]),\n    {ok, Tar} = erl_tar:open(TarFileName, [write, compressed]),\n    %% {ok, Cwd} = file:get_cwd(),\n    %% file:set_cwd(\"tmp\"),\n    ErtsDir = \"erts-\"++ErtsVsn,\n    erl_tar:add(Tar, filename:join(TmpDir,\"bin\"), \"bin\", []),\n    erl_tar:add(Tar, filename:join(TmpDir,ErtsDir), ErtsDir, []),\n    erl_tar:add(Tar, filename:join(TmpDir,\"releases\"), \"releases\", []),\n    erl_tar:add(Tar, filename:join(TmpDir,\"lib\"), \"lib\", []),\n    erl_tar:add(Tar, filename:join(TmpDir,\"log\"), \"log\", []),\n    erl_tar:close(Tar),\n    %% file:set_cwd(Cwd),\n    io:fwrite(\"Removing directory ~ts ...~n\",[TmpDir]),\n    remove_dir_tree(TmpDir),\n    ok.\n\n\ninstall(RelFileName, RootDir) ->\n    TarFile = RelFileName ++ \".tar.gz\",\n    io:fwrite(\"Extracting ~ts ...~n\", [TarFile]),\n    extract_tar(TarFile, RootDir),\n    StartErlDataFile = filename:join([RootDir, \"releases\", \"start_erl.data\"]),\n    {ok, StartErlData} = read_txt_file(StartErlDataFile),\n    [ErlVsn, _RelVsn| _] = string:tokens(StartErlData, \" \\n\"),\n    ErtsBinDir = filename:join([RootDir, \"erts-\" ++ ErlVsn, \"bin\"]),\n    BinDir = filename:join([RootDir, \"bin\"]),\n    io:fwrite(\"Substituting in erl.src, start.src and start_erl.src to \"\n              \"form erl, start and start_erl ...\\n\"),\n    subst_src_scripts([\"erl\", \"start\", \"start_erl\"], ErtsBinDir, BinDir,\n                      [{\"FINAL_ROOTDIR\", RootDir}, {\"EMU\", \"beam\"}],\n                      [preserve]),\n    %%! Workaround for pre OTP 17.0: start.src and start_erl.src did\n    %%! not have correct permissions, so the above 'preserve' option did not help\n    ok = file:change_mode(filename:join(BinDir,\"start\"),8#0755),\n    ok = file:change_mode(filename:join(BinDir,\"start_erl\"),8#0755),\n\n    io:fwrite(\"Creating the RELEASES file ...\\n\"),\n    create_RELEASES(RootDir, filename:join([RootDir, \"releases\",\n\t\t\t\t\t    filename:basename(RelFileName)])).\n\n%% LOCALS\n\n%% make_script(RelFileName,Opts)\n%%\nmake_script(RelFileName,Opts) ->\n    systools:make_script(RelFileName, [no_module_tests,\n\t\t\t\t       {outdir,filename:dirname(RelFileName)}\n\t\t\t\t       |Opts]).\n\n%% make_tar(RelFileName,Opts)\n%%\nmake_tar(RelFileName,Opts) ->\n    RootDir = code:root_dir(),\n    systools:make_tar(RelFileName, [{erts, RootDir},\n\t\t\t\t    {outdir,filename:dirname(RelFileName)}\n\t\t\t\t    |Opts]).\n\n%% extract_tar(TarFile, DestDir)\n%%\nextract_tar(TarFile, DestDir) ->\n    erl_tar:extract(TarFile, [{cwd, DestDir}, compressed]).\n\ncreate_RELEASES(DestDir, RelFileName) ->\n    release_handler:create_RELEASES(DestDir, RelFileName ++ \".rel\").\n\nsubst_src_scripts(Scripts, SrcDir, DestDir, Vars, Opts) ->\n    lists:foreach(fun(Script) ->\n                          subst_src_script(Script, SrcDir, DestDir,\n                                           Vars, Opts)\n                  end, Scripts).\n\nsubst_src_script(Script, SrcDir, DestDir, Vars, Opts) ->\n    subst_file(filename:join([SrcDir, Script ++ \".src\"]),\n               filename:join([DestDir, Script]),\n               Vars, Opts).\n\nsubst_file(Src, Dest, Vars, Opts) ->\n    {ok, Conts} = read_txt_file(Src),\n    NConts = subst(Conts, Vars),\n    write_file(Dest, NConts),\n    case lists:member(preserve, Opts) of\n        true ->\n            {ok, FileInfo} = file:read_file_info(Src),\n            file:write_file_info(Dest, FileInfo);\n        false ->\n            ok\n    end.\n\n%% subst(Str, Vars)\n%% Vars = [{Var, Val}]\n%% Var = Val = string()\n%% Substitute all occurrences of %Var% for Val in Str, using the list\n%% of variables in Vars.\n%%\nsubst(Str, Vars) ->\n    subst(Str, Vars, []).\n\nsubst([$%, C| Rest], Vars, Result) when $A = \n    subst_var([C| Rest], Vars, Result, []);\nsubst([$%, C| Rest], Vars, Result) when $a = \n    subst_var([C| Rest], Vars, Result, []);\nsubst([$%, C| Rest], Vars, Result) when  C == $_ ->\n    subst_var([C| Rest], Vars, Result, []);\nsubst([C| Rest], Vars, Result) ->\n    subst(Rest, Vars, [C| Result]);\nsubst([], _Vars, Result) ->\n    lists:reverse(Result).\n\nsubst_var([$%| Rest], Vars, Result, VarAcc) ->\n    Key = lists:reverse(VarAcc),\n    case lists:keysearch(Key, 1, Vars) of\n        {value, {Key, Value}} ->\n            subst(Rest, Vars, lists:reverse(Value, Result));\n        false ->\n            subst(Rest, Vars, [$%| VarAcc ++ [$%| Result]])\n    end;\nsubst_var([C| Rest], Vars, Result, VarAcc) ->\n    subst_var(Rest, Vars, Result, [C| VarAcc]);\nsubst_var([], Vars, Result, VarAcc) ->\n    subst([], Vars, [VarAcc ++ [$%| Result]]).\n\ncopy_file(Src, Dest) ->\n    copy_file(Src, Dest, []).\n\ncopy_file(Src, Dest, Opts) ->\n    {ok,_} = file:copy(Src, Dest),\n    case lists:member(preserve, Opts) of\n        true ->\n            {ok, FileInfo} = file:read_file_info(Src),\n            file:write_file_info(Dest, FileInfo);\n        false ->\n            ok\n    end.\n\nwrite_file(FName, Conts) ->\n    Enc = file:native_name_encoding(),\n    {ok, Fd} = file:open(FName, [write]),\n    file:write(Fd, unicode:characters_to_binary(Conts,Enc,Enc)),\n    file:close(Fd).\n\nread_txt_file(File) ->\n    {ok, Bin} = file:read_file(File),\n    {ok, binary_to_list(Bin)}.\n\nremove_dir_tree(Dir) ->\n    remove_all_files(\".\", [Dir]).\n\nremove_all_files(Dir, Files) ->\n    lists:foreach(fun(File) ->\n                          FilePath = filename:join([Dir, File]),\n                          case filelib:is_dir(FilePath) of\n                              true ->\n                                  {ok, DirFiles} = file:list_dir(FilePath),\n                                  remove_all_files(FilePath, DirFiles),\n                                  file:del_dir(FilePath);\n                              _ ->\n                                  file:delete(FilePath)\n                          end\n                  end, Files).\n```","title":"Listing of target_system.erl - Creating and Upgrading a Target System","ref":"create_target.html#listing-of-target_system-erl"},{"type":"extras","doc":"<!--\n%CopyrightBegin%\n\nCopyright Ericsson AB 2023-2024. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# Upgrade when Erlang/OTP has Changed\n\n[](){: #upgrade-section }","title":"Upgrade when Erlang/OTP has Changed","ref":"upgrade.html"},{"type":"extras","doc":"[](){: #upgrade }\n\nAs of Erlang/OTP 17, most applications deliver a valid application upgrade file\n(`appup`). Many of the applications use the `restart_application`\ninstruction. These are applications for which it is not crucial to support real\nsoft upgrade, for example, tools and library applications. The\n`restart_application` instruction ensures that all modules in the application\nare reloaded and thereby running the new code.","title":"Introduction - Upgrade when Erlang/OTP has Changed","ref":"upgrade.html#introduction"},{"type":"extras","doc":"The core applications ERTS, Kernel, STDLIB, and SASL never allow real\nsoft upgrade, but require the Erlang runtime system to be\nrestarted. This is indicated to the `release_handler` by the upgrade\ninstruction `restart_new_emulator`. This instruction is always the\nvery first instruction executed, and it restarts the runtime system\nwith the new versions of the previously mentioned core applications\nand the old versions of all other applications. When the node is back\nup, all other upgrade instructions are executed, making sure each\napplication is finally running its new version.\n\nIt might seem strange to do a two-step upgrade instead of just\nrestarting the runtime system with the new version of all\napplications. The reason for this design decision is to allow\n`code_change` functions to have side effects, for example, changing\ndata on disk. It also guarantees that the upgrade mechanism for\nnon-core applications does not differ depending on whether or not core\napplications are changed at the same time.\n\nIf, however, the more brutal variant is preferred, the release\nupgrade file can be handwritten using only the single upgrade\ninstruction `restart_emulator`.  This instruction, in contrast to\n`restart_new_emulator`, causes the runtime system to restart with the\nnew versions of _all_ applications.\n\n_Note:_ If other instructions are included before `restart_emulator`\nin the handwritten `relup` file, they are executed in the old runtime\nsystem. This is a big risk since there is no guarantee that new BEAM\ncode can be loaded into the old runtime system. Adding instructions\nafter `restart_emulator` has no effect as the `release_handler` will\nnot execute them.\n\nFor information about the release upgrade file, see\n[relup](`e:sasl:relup.md`) in SASL. For more information about\nupgrade instructions, see [appup](`e:sasl:appup.md`) in SASL.","title":"Upgrade of Core Applications - Upgrade when Erlang/OTP has Changed","ref":"upgrade.html#upgrade-of-core-applications"},{"type":"extras","doc":"A few applications, such as Erl_interface, do not support upgrade. This is\nindicated by an application upgrade file containing only `{Vsn,[],[]}`. Any\nattempt at creating a release upgrade file with such input fails. The only way\nto force an upgrade involving applications like this is to handwrite the file\n`relup`, preferably as described above with only the `restart_emulator`\ninstruction.","title":"Applications that Still do Not Allow Code Upgrade - Upgrade when Erlang/OTP has Changed","ref":"upgrade.html#applications-that-still-do-not-allow-code-upgrade"},{"type":"extras","doc":"<!--\n%CopyrightBegin%\n\nCopyright Ericsson AB 2023-2024. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# Versions\n\n[](){: #versions-section }","title":"Versions","ref":"versions.html"},{"type":"extras","doc":"As of OTP release 17, the OTP release number corresponds to the major part of\nthe OTP version. The OTP version as a concept was introduced in OTP 17. The\nversion scheme used is described in detail in\n[Version Scheme](versions.md#version_scheme).\n\nOTP of a specific version is a set of applications of specific versions. The\napplication versions identified by an OTP version corresponds to application\nversions that have been tested together by the Erlang/OTP team at Ericsson AB.\nAn OTP system can, however, be put together with applications from different OTP\nversions. Such a combination of application versions has not been tested by the\nErlang/OTP team. It is therefore _always preferred to use OTP applications from\none single OTP version_.\n\nRelease candidates have an `-rc ` suffix. The suffix `-rc0` is used during\ndevelopment up to the first release candidate.","title":"OTP Version - Versions","ref":"versions.html#otp-version"},{"type":"extras","doc":"In an OTP source code tree, the OTP version can be read from the text file\n` /OTP_VERSION`. The absolute path to the file can be\nconstructed by calling\n`filename:join([`[`code:root_dir()`](`code:root_dir/0`)`, \"OTP_VERSION\"])`.\n\nIn an installed OTP development system, the OTP version can be read from the\ntext file ` /releases/ /OTP_VERSION`.\nThe absolute path to the file can by constructed by calling\n`filename:join([`[`code:root_dir()`](`code:root_dir/0`)`, \"releases\", `[`erlang:system_info(otp_release)`](`m:erlang#system_info_otp_release`)`, \"OTP_VERSION\"]).`\n\nIf the version read from the `OTP_VERSION` file in a development system has a\n`**` suffix, the system has been patched using the\n[`otp_patch_apply`](`e:system:otp-patch-apply.md`) tool. In this case, the\nsystem consists of application versions from multiple OTP versions. The version\npreceding the `**` suffix corresponds to the OTP version of the base system that\nhas been patched. Note that if a development system is updated by other means\nthan `otp_patch_apply`, the file `OTP_VERSION` can identify an incorrect OTP\nversion.\n\nNo `OTP_VERSION` file is placed in a [target system](create_target.md) created\nby OTP tools, because one can easily create a target system where it is hard\nto even determine the base OTP version. However, it is allowed to place such\na file there if one knows the OTP version.","title":"Retrieving Current OTP Version - Versions","ref":"versions.html#retrieving-current-otp-version"},{"type":"extras","doc":"The text file ` /otp_versions.table`, which is part of the\nsource code, contains information about all OTP versions from OTP 17.0 up to the\ncurrent OTP version. Each line contains information about application versions\nthat are part of a specific OTP version, and has the following format:\n\n```text\n  :   #   :\n```\n\n` ` has the format `OTP- `, that is, the same as the git tag used\nto identify the source.\n\n` ` and ` ` are space-separated lists of\napplication versions and has the format ` - `.\n\n- ` ` corresponds to changed applications with new version\n  numbers in this OTP version.\n- ` ` corresponds to unchanged application versions in this\n  OTP version.\n\nBoth of them can be empty, but not at the same time. If ` `\nis empty, no changes have been made that change the build result of any\napplication. This could, for example, be a pure bug fix of the build system. The\norder of lines is undefined. All white-space characters in this file are either\nspace (character 32) or line-break (character 10).\n\nBy using ordinary UNIX tools like `sed` and `grep` one can easily find answers\nto various questions like:\n\n- Which OTP versions are `kernel-3.0` part of?\n\n  `$ grep ' kernel-3\\.0 ' otp_versions.table`\n\n- In which OTP version was `kernel-3.0` introduced?\n\n  `$ sed 's/#.*//;/ kernel-3\\.0 /!d' otp_versions.table`\n\nThe above commands give a bit more information than the exact answers, but\nadequate information when manually searching for answers to these questions.","title":"OTP Versions Table - Versions","ref":"versions.html#otp-versions-table"},{"type":"extras","doc":"As of OTP 17.0 application versions use the same [version\nscheme](versions.md#version_scheme) as the OTP version, except that\napplication versions never include the `-rc ` suffix. Also\nnote that a major increment in an application version does not\nnecessarily imply a major increment of the OTP version. This depends\non whether the major change in the application is considered a\nmajor change for OTP as a whole or not.\n\n[](){: #version_scheme }","title":"Application Version - Versions","ref":"versions.html#application-version"},{"type":"extras","doc":"> #### Change {: .info }\n>\n> The version scheme was changed as of OTP 17.0.\n> [A list of application versions used in OTP 17.0](versions.md#otp_17_0_app_versions)\n> is included at the end of this section.\n\nNormally, a version is constructed as ` . . `, where\n` ` is the most significant part. However, versions with more than three\ndot-separated parts are possible.\n\nThe dot-separated parts consist of non-negative integers. If all parts\nless significant than ` ` equals `0`, they are omitted. The\nthree normal parts ` . . ` are changed as follows:\n\n- ` ` - Increases when major changes, including incompatibilities, are\n  made.\n- ` ` - Increases when new functionality is added.\n- ` ` - Increases when pure bug fixes are made.\n\nWhen a part in the version number increases, all less significant parts are set\nto `0`.\n\nAn application version or an OTP version identifies source code versions. That\nis, it implies nothing about how the application or OTP has been built.","title":"Version Scheme - Versions","ref":"versions.html#version-scheme"},{"type":"extras","doc":"Version numbers in general are only partially ordered. However, normal version\nnumbers (with three parts) as of OTP 17.0 have a total or linear order. This\napplies both to normal OTP versions and normal application versions.\n\nWhen comparing two version numbers with a defined order, one compares\neach part as standard integers, starting from the most significant\npart and moving towards the less significant parts. The order is\ndetermined by the first parts of the same significance that differ. A\nlarger OTP version encompasses all changes present in a smaller OTP\nversion. The same principle applies to application versions.\n\nVersions can have more than three parts, resulting in partial\nordering. Such versions are only used when branching off from another\nbranch. When an extra part (apart from the normal three parts) is added to\na version number, a new branch of versions is made. The new branch has\na linear order against the base version. However, versions on\ndifferent branches have no order, and therefore one can only conclude\nthat they all include what is included in their closest common\nancestor. When branching multiple times from the same base version,\n`0` parts are added between the base version and the least significant\n`1` part until a unique version is found. Versions that have an order\ncan be compared as described in the previous paragraph.\n\nAn example of branched versions: The version `6.0.2.1` is a branched version\nfrom the base version `6.0.2`. Versions on the form `6.0.2. ` can be compared\nwith normal versions smaller than or equal to `6.0.2`, and other versions on the\nform `6.0.2. `. The version `6.0.2.1` will include all changes in `6.0.2`.\nHowever, `6.0.3` will most likely _not_ include all changes in `6.0.2.1` (note\nthat these versions have no order). A second branched version from the base\nversion `6.0.2` will be version `6.0.2.0.1`, and a third branched version will\nbe `6.0.2.0.0.1`.\n\n[](){: #releases_and_patches }","title":"Order of Versions - Versions","ref":"versions.html#order-of-versions"},{"type":"extras","doc":"When a new OTP release is released it will have an OTP version on the form\n` .0` where the major OTP version number equals the release number. The\nmajor version number is increased one step since the last major version. All\nother OTP versions with the same major OTP version number are patches on that\nOTP release.\n\nPatches are either released as maintenance patch packages or emergency patch\npackages. The only difference is that maintenance patch packages are planned and\nusually contain more changes than emergency patch packages. Emergency patch\npackages are released to solve one or more specific issues when such are\ndiscovered.\n\nThe release of a maintenance patch package usually imply an increase\nof the OTP ` ` version, while the release of an emergency patch\npackage usually imply an increase of the OTP ` `\nversion. However, this is not always the case, as changes in OTP\nversions are determined by actual code modifications rather than\nwhether the patch was planned or not. For more information see\n[Version Scheme](versions.md#version_scheme).\n\n[](){: #otp_versions_tree }","title":"Releases and Patches - Versions","ref":"versions.html#releases-and-patches"},{"type":"extras","doc":"All released OTP versions can be found in the [OTP Versions\nTree](http://www.erlang.org/download/otp_versions_tree.html), which is\nautomatically updated whenever we release a new OTP version. Note that\neach version number explicitly determines its position in the version\ntree. All that is required to build the tree are the version numbers\nthemselves.\n\nThe root of the tree is OTP version 17.0 which is when we introduced the new\n[version scheme](versions.md#version_scheme). The green versions are normal\nversions released on the main track. Old\n[OTP releases](versions.md#releases_and_patches) will be maintained for a while\non `maint` branches that have branched off from the main track. Old `maint`\nbranches always branch off from the main track when the next OTP release is\nintroduced into the main track. Versions on these old `maint` branches are\nmarked blue.\n\nApart from the green and blue versions, there are also gray\nversions. These denote versions established on branches to resolve a\nparticular issue for a specific customer based on a specific base\nversion. Branches with gray versions will typically become dead ends\nvery quickly if not immediately.\n\n[](){: #otp_17_0_app_versions }","title":"OTP Versions Tree - Versions","ref":"versions.html#otp-versions-tree"},{"type":"extras","doc":"The following list details the application versions that were part of\nOTP 17.0.\n\nIf the normal part of an application version number is smaller than\nthe corresponding application version in the list, the version number\ndoes not adhere to the versioning scheme introduced in OTP\n17.0. Consequently, it is not regarded as having an order against\nversions used from OTP 17.0 onwards.\n\n- `asn1-3.0`\n- `common_test-1.8`\n- `compiler-5.0`\n- `cosEvent-2.1.15`\n- `cosEventDomain-1.1.14`\n- `cosFileTransfer-1.1.16`\n- `cosNotification-1.1.21`\n- `cosProperty-1.1.17`\n- `cosTime-1.1.14`\n- `cosTransactions-1.2.14`\n- `crypto-3.3`\n- `debugger-4.0`\n- `dialyzer-2.7`\n- `diameter-1.6`\n- `edoc-0.7.13`\n- `eldap-1.0.3`\n- `erl_docgen-0.3.5`\n- `erl_interface-3.7.16`\n- `erts-6.0`\n- `et-1.5`\n- `eunit-2.2.7`\n- `gs-1.5.16`\n- `hipe-3.10.3`\n- `ic-4.3.5`\n- `inets-5.10`\n- `jinterface-1.5.9`\n- `kernel-3.0`\n- `megaco-3.17.1`\n- `mnesia-4.12`\n- `observer-2.0`\n- `odbc-2.10.20`\n- `orber-3.6.27`\n- `os_mon-2.2.15`\n- `ose-1.0`\n- `otp_mibs-1.0.9`\n- `parsetools-2.0.11`\n- `percept-0.8.9`\n- `public_key-0.22`\n- `reltool-0.6.5`\n- `runtime_tools-1.8.14`\n- `sasl-2.4`\n- `snmp-4.25.1`\n- `ssh-3.0.1`\n- `ssl-5.3.4`\n- `stdlib-2.0`\n- `syntax_tools-1.6.14`\n- `test_server-3.7`\n- `tools-2.6.14`\n- `typer-0.9.6`\n- `webtool-0.8.10`\n- `wx-1.2`\n- `xmerl-1.3.7`","title":"OTP 17.0 Application Versions - Versions","ref":"versions.html#otp-17-0-application-versions"},{"type":"extras","doc":"<!--\n%CopyrightBegin%\n\nCopyright Ericsson AB 2023-2024. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# Support, Compatibility, Deprecations, and Removal","title":"Support, Compatibility, Deprecations, and Removal","ref":"misc.html"},{"type":"extras","doc":"This document describes the strategy regarding supported Releases,\ncompatibility, deprecations, and removal of functionality.\n\n> #### Change {: .info }\n>\n> This document and the strategy it describes was introduced in\n> Erlang/OTP 21.\n\n[](){: #supported_releases }","title":"Introduction - Support, Compatibility, Deprecations, and Removal","ref":"misc.html#introduction"},{"type":"extras","doc":"In general, bugs are only fixed on the latest\n[release](versions.md#releases_and_patches), and new features are introduced in\nthe upcoming release that is under development. However, when we, for\ninternal reasons, fix bugs on older releases, these will be available and\nannounced as well.\n\nPull requests are only accepted on the `maint` and the `master`\nbranches in our [git repository](https://github.com/erlang/otp). The\n`maint` branch contains changes planned for the next [maintenance\npatch package](versions.md#releases_and_patches) on the latest OTP\nrelease and the `master` branch contain changes planned for the\nupcoming OTP release.","title":"Supported Releases - Support, Compatibility, Deprecations, and Removal","ref":"misc.html#supported-releases"},{"type":"extras","doc":"We strive to remain as compatible as possible, even in cases where we\ngive no compatibility guarantees.\n\nDifferent parts of the system will be handled differently regarding\ncompatibility. The following items describe how different parts of the system\nare handled.\n\n- **Erlang Distribution** - Erlang nodes can communicate across at least two\n  preceding and two subsequent releases.\n\n- **Compiled BEAM Code, NIF Libraries, and Drivers** - Compiled code\n  can be loaded on at least two subsequent releases. To achive the\n  highest possible performance for Erlang code, ensure it is compiled\n  using the same release as the one it will be deployed on.\n\n  Loading on previous releases is _not_ supported.\n\n- **APIs** - Compatible between releases.\n\n- **Compiler Warnings** - New warnings may be issued between releases.\n\n- **Command Line Arguments** - Incompatible changes may occur between releases.\n\n- **OTP Build Procedures** - Incompatible changes may occur between releases.\n\nUnder certain circumstances incompatible changes might be introduced even in\nparts of the system that should be compatible between releases. Things that\nmight trigger incompatible changes like this are:\n\n- **Security Issues** - It might be necessary to introduce incompatible changes\n  in order to solve a security issue. This kind of incompatibility might occur\n  in a patch.\n\n- **Bug Fixes** - We will not be bug-compatible. A bug fix might introduce\n  incompatible changes. This kind of incompatibility might occur in a patch.\n\n- **Severe Previous Design Issues** - Some parts of OTP were designed\n  a very long time ago and did not necessarily take today's computing\n  environments into account. Consequently, the ramifications of these\n  design choices can be quite significant, impacting performance,\n  scalability, and more. If we determine that these consequences are\n  too substantial, we may implement incompatible changes. Such changes\n  are never introduced in a patch, but in the subsequent release.\n\nPeripheral, trace, and debug functionality is at greater risk of being changed\nin an incompatible way than functionality in the language itself and core\nlibraries used during operation.\n\nThere is a page in the documentation regarding incompatibilities:\n\n* [Upcoming Potential Incompatibilities](`e:general_info:upcoming_incompatibilities.md`) -\n  lists all upcoming potential incompatibilities.","title":"Compatibility - Support, Compatibility, Deprecations, and Removal","ref":"misc.html#compatibility"},{"type":"extras","doc":"Deprecation of functionality occurs when newer, preferred alternatives\nare introduced. The deprecation does **not** imply future removal of the\nfunctionality unless an upcoming removal is explicitly stated in the\ndeprecation notice.\n\nDeprecated functionality will be documented as deprecated and highlighted\nin a release note as early possible. If appropriate, the compiler will\nissue warnings when the deprecated functionality is used.\n\nThere is a page in the documentation regarding deprecations:\n\n* [Deprecations](`e:general_info:deprecations.md`) - lists all\n  deprecated functionality.","title":"Deprecation - Support, Compatibility, Deprecations, and Removal","ref":"misc.html#deprecation"},{"type":"extras","doc":"It can become necessary to remove legacy solutions. In such instances,\nthey will be gradually phased out over a sufficient period to allow\nusers to adjust. Before functionality is removed, it will be\ndeprecated for at least one release, with an explicit announcement\nabout the upcoming removal.\n\nPeripheral, trace, and debug functionality is at greater risk of removal than\nfunctionality in the language itself and core libraries used during operation.\n\nThere are two pages in the documentation regarding removal:\n\n* [Scheduled for Removal](`e:general_info:scheduled_for_removal.md`) - lists\n  all functionality that is schedule for removal in upcoming releases.\n\n* [Removed Functionality](`e:general_info:removed.md`) - lists\n  functionality that has been removed.","title":"Removal - Support, Compatibility, Deprecations, and Removal","ref":"misc.html#removal"},{"type":"extras","doc":"<!--\n%CopyrightBegin%\n\nCopyright Ericsson AB 2023-2024. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# Overview\n\n[](){: #otp-design-principles }\n\nThe _OTP Design Principles_ define how to structure Erlang code in terms of\nprocesses, modules, and directories.","title":"Overview","ref":"design_principles.html"},{"type":"extras","doc":"A basic concept in Erlang/OTP is the _supervision tree_. This is a process\nstructuring model based on the idea of _workers_ and _supervisors_:\n\n- Workers are processes that perform computations and other actual work.\n- Supervisors are processes that monitor workers. A supervisor\n  can restart a worker if something goes wrong.\n- The supervision tree is a hierarchical arrangement of code into supervisors\n  and workers, which makes it possible to design and program fault-tolerant\n  software.\n\nIn the following figure, square boxes represents supervisors and circles\nrepresent workers:\n\n[](){: #sup6 }\n\n```mermaid\n---\ntitle: Supervision Tree\n---\nflowchart\n    sup1[Type 1 Supervisor] --- sup2[Type 1 Supervisor] --- worker1((worker))\n    sup1 --- sup1a[Type A Supervisor]\n\n    sup1a --- sup2a[Type A Supervisor] --- worker2((worker))\n    sup1a --- sup3[Type 1 Supervisor]\n\n    sup3 --- worker3((worker))\n    sup3 --- worker4((worker))\n```","title":"Supervision Trees - Overview","ref":"design_principles.html#supervision-trees"},{"type":"extras","doc":"In a supervision tree, many of the processes have similar structures\nand follow similar patterns. For example, the supervisors share a\nsimilar structure, with the sole distinction lying in the child\nprocesses they supervise. Many of the workers are servers in a\nserver-client relation, finite-state machines, or event handlers.\n\n_Behaviours_ are formalizations of these common patterns. The idea is to divide\nthe code for a process in a generic part (a behaviour module) and a specific\npart (a _callback module_).\n\nThe behaviour module is part of Erlang/OTP. To implement a process such as a\nsupervisor, the user only needs to implement the callback module, which is to\nexport a pre-defined set of functions, the _callback functions_.\n\nThe following example illustrate how code can be divided into a generic and a\nspecific part. Consider the following code (written in plain Erlang) for a\nsimple server, which keeps track of a number of \"channels\". Other processes can\nallocate and free the channels by calling the functions `alloc/0` and `free/1`,\nrespectively.\n\n[](){: #ch1 }\n\n```erlang\n-module(ch1).\n-export([start/0]).\n-export([alloc/0, free/1]).\n-export([init/0]).\n\nstart() ->\n    spawn(ch1, init, []).\n\nalloc() ->\n    ch1 ! {self(), alloc},\n    receive\n        {ch1, Res} ->\n            Res\n    end.\n\nfree(Ch) ->\n    ch1 ! {free, Ch},\n    ok.\n\ninit() ->\n    register(ch1, self()),\n    Chs = channels(),\n    loop(Chs).\n\nloop(Chs) ->\n    receive\n        {From, alloc} ->\n            {Ch, Chs2} = alloc(Chs),\n            From ! {ch1, Ch},\n            loop(Chs2);\n        {free, Ch} ->\n            Chs2 = free(Ch, Chs),\n            loop(Chs2)\n    end.\n```\n\nThe code for the server can be rewritten into a generic part `server.erl`:\n\n```erlang\n-module(server).\n-export([start/1]).\n-export([call/2, cast/2]).\n-export([init/1]).\n\nstart(Mod) ->\n    spawn(server, init, [Mod]).\n\ncall(Name, Req) ->\n    Name ! {call, self(), Req},\n    receive\n        {Name, Res} ->\n            Res\n    end.\n\ncast(Name, Req) ->\n    Name ! {cast, Req},\n    ok.\n\ninit(Mod) ->\n    register(Mod, self()),\n    State = Mod:init(),\n    loop(Mod, State).\n\nloop(Mod, State) ->\n    receive\n        {call, From, Req} ->\n            {Res, State2} = Mod:handle_call(Req, State),\n            From ! {Mod, Res},\n            loop(Mod, State2);\n        {cast, Req} ->\n            State2 = Mod:handle_cast(Req, State),\n            loop(Mod, State2)\n    end.\n```\n\nAnd a callback module `ch2.erl`:\n\n```erlang\n-module(ch2).\n-export([start/0]).\n-export([alloc/0, free/1]).\n-export([init/0, handle_call/2, handle_cast/2]).\n\nstart() ->\n    server:start(ch2).\n\nalloc() ->\n    server:call(ch2, alloc).\n\nfree(Ch) ->\n    server:cast(ch2, {free, Ch}).\n\ninit() ->\n    channels().\n\nhandle_call(alloc, Chs) ->\n    alloc(Chs). % => {Ch,Chs2}\n\nhandle_cast({free, Ch}, Chs) ->\n    free(Ch, Chs). % => Chs2\n```\n\nNotice the following:\n\n- The code in `server` can be reused to build many different servers.\n- The server name, in this example the atom `ch2`, is hidden from the users of\n  the client functions. This means that the name can be changed without\n  affecting them.\n- The protocol (messages sent to and received from the server) is also hidden.\n  This is good programming practice and allows one to change the protocol\n  without changing the code using the interface functions.\n- The functionality of `server` can be extended without having to change `ch2`\n  or any other callback module.\n\nIn `ch1.erl` and `ch2.erl` above, the implementation of `channels/0`, `alloc/1`,\nand `free/2` has been intentionally left out, as it is not relevant to the\nexample. For completeness, one way to write these functions is given below. This\nis an example only, a realistic implementation must be able to handle situations\nlike running out of channels to allocate, and so on.\n\n[](){: #channels-implementation }\n\n```erlang\nchannels() ->\n   {_Allocated = [], _Free = lists:seq(1, 100)}.\n\nalloc({Allocated, [H|T] = _Free}) ->\n   {H, {[H|Allocated], T}}.\n\nfree(Ch, {Alloc, Free} = Channels) ->\n   case lists:member(Ch, Alloc) of\n      true ->\n         {lists:delete(Ch, Alloc), [Ch|Free]};\n      false ->\n         Channels\n   end.\n```\n\nCode written without using behaviours can be more efficient, but the increased\nefficiency is at the expense of generality. The ability to manage all\napplications in the system in a consistent manner is important.\n\nUsing behaviours also makes it easier to read and understand code written by\nother programmers. Improvised programming structures, while possibly more\nefficient, are always more difficult to understand.\n\nThe `server` module corresponds, greatly simplified, to the Erlang/OTP behaviour\n`gen_server`.\n\nThe standard Erlang/OTP behaviours are:\n\n- [gen_server](gen_server_concepts.md)\n\n  For implementing the server of a client-server relation\n\n- [gen_statem](statem.md)\n\n  For implementing state machines\n\n- [gen_event](events.md)\n\n  For implementing event handling functionality\n\n- [supervisor](sup_princ.md)\n\n  For implementing a supervisor in a supervision tree\n\nThe compiler understands the module attribute `-behaviour(Behaviour)` and issues\nwarnings about missing callback functions, for example:\n\n```erlang\n-module(chs3).\n-behaviour(gen_server).\n...\n\n3> c(chs3).\n./chs3.erl:10: Warning: undefined call-back function handle_call/3\n{ok,chs3}\n```","title":"Behaviours - Overview","ref":"design_principles.html#behaviours"},{"type":"extras","doc":"Erlang/OTP comes with a number of components, each implementing some specific\nfunctionality. Components are with Erlang/OTP terminology called _applications_.\nExamples of Erlang/OTP applications are Mnesia, which has everything needed for\nprogramming database services, and Debugger, which is used to debug Erlang\nprograms. The minimal system based on Erlang/OTP consists of the following two\napplications:\n\n- Kernel - Functionality necessary to run Erlang\n- STDLIB - Erlang standard libraries\n\nThe application concept applies both to program structure (processes) and\ndirectory structure (modules).\n\nThe simplest applications do not have any processes, but consist of a collection\nof functional modules. Such an application is called a _library application_. An\nexample of a library application is STDLIB.\n\nAn application with processes is easiest implemented as a supervision tree using\nthe standard behaviours.\n\nHow to program applications is described in [Applications](applications.md).","title":"Applications - Overview","ref":"design_principles.html#applications"},{"type":"extras","doc":"A _release_ is a complete system made out from a subset of Erlang/OTP\napplications and a set of user-specific applications.\n\nHow to program releases is described in [Releases](release_structure.md).\n\nHow to install a release in a target environment is described in\n[Creating and Upgrading a Target System](`e:system:create_target.md`) in System Principles.","title":"Releases - Overview","ref":"design_principles.html#releases"},{"type":"extras","doc":"_Release handling_ is upgrading and downgrading between different versions of a\nrelease, in a (possibly) running system. How to do this is described in\n[Release Handling](release_handling.md).","title":"Release Handling - Overview","ref":"design_principles.html#release-handling"},{"type":"extras","doc":"<!--\n%CopyrightBegin%\n\nCopyright Ericsson AB 2023-2024. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n\n[](){: #gen_server }gen_server Behaviour\n========================================\n\nIt is recommended to read this section alongside `m:gen_server` in STDLIB.\n\nClient-Server Principles\n------------------------\n\nThe client-server model is characterized by a central server and an arbitrary\nnumber of clients. The client-server model is used for resource management\noperations, where several different clients want to share a common resource.\nThe server is responsible for managing this resource.\n\n[](){: #clientserver }\n\n```mermaid\n---\ntitle: Client Server Model\n---\n\nflowchart LR\n    client1((Client))\n    client2((Client))\n    client3((Client))\n    server((Server))\n\n    client1 --> server\n    server -.-> client1\n\n    client2 --> server\n    server -.-> client2\n\n    client3 --> server\n    server -.-> client3\n\n    subgraph Legend\n        direction LR\n\n        start1[ ] -->|Query| stop1[ ]\n        style start1 height:0px;\n        style stop1 height:0px;\n\n        start2[ ] -.->|Reply| stop2[ ]\n        style start2 height:0px;\n        style stop2 height:0px;\n    end\n```\n\nExample\n-------\n\nAn example of a simple server written in plain Erlang is provided in\n[Overview](design_principles.md#ch1). The server can be reimplemented using\n`gen_server`, resulting in this callback module:\n\n[](){: #ex }\n\n```erlang\n-module(ch3).\n-behaviour(gen_server).\n\n-export([start_link/0]).\n-export([alloc/0, free/1]).\n-export([init/1, handle_call/3, handle_cast/2]).\n\nstart_link() ->\n    gen_server:start_link({local, ch3}, ch3, [], []).\n\nalloc() ->\n    gen_server:call(ch3, alloc).\n\nfree(Ch) ->\n    gen_server:cast(ch3, {free, Ch}).\n\ninit(_Args) ->\n    {ok, channels()}.\n\nhandle_call(alloc, _From, Chs) ->\n    {Ch, Chs2} = alloc(Chs),\n    {reply, Ch, Chs2}.\n\nhandle_cast({free, Ch}, Chs) ->\n    Chs2 = free(Ch, Chs),\n    {noreply, Chs2}.\n```\n\nThe code is explained in the next sections.\n\nStarting a Gen_Server\n---------------------\n\nIn the example in the previous section, `gen_server` is started by calling\n`ch3:start_link()`:\n\n```erlang\nstart_link() ->\n    gen_server:start_link({local, ch3}, ch3, [], []) => {ok, Pid}\n```\n\n`start_link/0` calls function `gen_server:start_link/4`.  This function\nspawns and links to a new process, a `gen_server`.\n\n- The first argument, `{local, ch3}`, specifies the name.\n  The gen_server is then locally registered as `ch3`.\n\n  If the name is omitted, the `gen_server` is not registered. Instead its pid\n  must be used. The name can also be given as `{global, Name}`, in which case\n  the `gen_server` is registered using `global:register_name/2`.\n\n- The second argument, `ch3`, is the name of the callback module, which is\n  the module where the callback functions are located.\n\n  The interface functions (`start_link/0`, `alloc/0`, and `free/1`) are located\n  in the same module as the callback functions (`init/1`, `handle_call/3`, and\n  `handle_cast/2`). It is usually good programming practice to have the code\n  corresponding to one process contained in a single module.\n\n- The third argument, `[]`, is a term that is passed as is to the callback\n  function `init`. Here, `init` does not need any indata and ignores the\n  argument.\n\n- The fourth argument, `[]`, is a list of options. See `m:gen_server`\n  for the available options.\n\nIf name registration succeeds, the new `gen_server` process calls the callback\nfunction `ch3:init([])`. `init` is expected to return `{ok, State}`, where\n`State` is the internal state of the `gen_server`. In this case, the state is\nthe available channels.\n\n```erlang\ninit(_Args) ->\n    {ok, channels()}.\n```\n\n`gen_server:start_link/4` is synchronous. It does not return until the\n`gen_server` has been initialized and is ready to receive requests.\n\n`gen_server:start_link/4` must be used if the `gen_server` is part of\na supervision tree, meaning that it was started by a supervisor. There\nis another function, `gen_server:start/4`, to start a standalone\n`gen_server` that is not part of a supervision tree.\n\nSynchronous Requests - Call\n---------------------------\n\nThe synchronous request `alloc()` is implemented using `gen_server:call/2`:\n\n```text\nalloc() ->\n    gen_server:call(ch3, alloc).\n```\n\n`ch3` is the name of the `gen_server` and must agree with the name\nused to start it. `alloc` is the actual request.\n\nThe request is made into a message and sent to the `gen_server`.\nWhen the request is received, the `gen_server` calls\n`handle_call(Request, From, State)`, which is expected to return\na tuple `{reply,Reply,State1}`. `Reply` is the reply that is to be sent back\nto the client, and `State1` is a new value for the state of the `gen_server`.\n\n```erlang\nhandle_call(alloc, _From, Chs) ->\n    {Ch, Chs2} = alloc(Chs),\n    {reply, Ch, Chs2}.\n```\n\nIn this case, the reply is the allocated channel `Ch` and the new state is the\nset of remaining available channels `Chs2`.\n\nThus, the call `ch3:alloc()` returns the allocated channel `Ch` and the\n`gen_server` then waits for new requests, now with an updated list of\navailable channels.\n\nAsynchronous Requests - Cast\n----------------------------\n\nThe asynchronous request `free(Ch)` is implemented using `gen_server:cast/2`:\n\n```erlang\nfree(Ch) ->\n    gen_server:cast(ch3, {free, Ch}).\n```\n\n`ch3` is the name of the `gen_server`. `{free, Ch}` is the actual request.\n\nThe request is made into a message and sent to the `gen_server`.\n`cast`, and thus `free`, then returns `ok`.\n\nWhen the request is received, the `gen_server` calls\n`handle_cast(Request, State)`, which is expected to return a tuple\n`{noreply,State1}`. `State1` is a new value for the state of the `gen_server`.\n\n```erlang\nhandle_cast({free, Ch}, Chs) ->\n    Chs2 = free(Ch, Chs),\n    {noreply, Chs2}.\n```\n\nIn this case, the new state is the updated list of available channels `Chs2`.\nThe `gen_server` is now ready for new requests.\n\nStopping\n--------","title":"gen_server Behaviour","ref":"gen_server_concepts.html"},{"type":"extras","doc":"If the `gen_server` is part of a supervision tree, no stop function is needed.\nThe `gen_server` is automatically terminated by its supervisor.  Exactly how\nthis is done is defined by a [shutdown strategy](sup_princ.md#shutdown)\nset in the supervisor.\n\nIf it is necessary to clean up before termination, the shutdown strategy\nmust be a time-out value and the `gen_server` must be set to trap exit signals\nin function `init`. When ordered to shutdown, the `gen_server` then calls\nthe callback function `terminate(shutdown, State)`:\n\n```erlang\ninit(Args) ->\n    ...,\n    process_flag(trap_exit, true),\n    ...,\n    {ok, State}.\n\n...\n\nterminate(shutdown, State) ->\n    %% Code for cleaning up here\n    ...\n    ok.\n```","title":"In a Supervision Tree - gen_server Behaviour","ref":"gen_server_concepts.html#in-a-supervision-tree"},{"type":"extras","doc":"If the `gen_server` is not part of a supervision tree, a stop function\ncan be useful, for example:\n\n```erlang\n...\nexport([stop/0]).\n...\n\nstop() ->\n    gen_server:cast(ch3, stop).\n...\n\nhandle_cast(stop, State) ->\n    {stop, normal, State};\nhandle_cast({free, Ch}, State) ->\n    ...\n\n...\n\nterminate(normal, State) ->\n    ok.\n```\n\nThe callback function handling the `stop` request returns a tuple\n`{stop,normal,State1}`, where `normal` specifies that it is\na normal termination and `State1` is a new value for the state\nof the `gen_server`.  This causes the `gen_server` to call\n`terminate(normal, State1)` and then it terminates gracefully.\n\nHandling Other Messages\n-----------------------\n\nIf the `gen_server` is to be able to receive other messages than requests,\nthe callback function `handle_info(Info, State)` must be implemented\nto handle them.  Examples of other messages are exit messages,\nif the `gen_server` is linked to other processes than the supervisor\nand it is trapping exit signals.\n\n```erlang\nhandle_info({'EXIT', Pid, Reason}, State) ->\n    %% Code to handle exits here.\n    ...\n    {noreply, State1}.\n```\n\nThe final function to implement is `code_change/3`:\n\n```erlang\ncode_change(OldVsn, State, Extra) ->\n    %% Code to convert state (and more) during code change.\n    ...\n    {ok, NewState}.\n```","title":"Standalone Gen_Servers - gen_server Behaviour","ref":"gen_server_concepts.html#standalone-gen_servers"},{"type":"extras","doc":"<!--\n%CopyrightBegin%\n\nCopyright Ericsson AB 2024. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n\n`gen_statem` Behaviour\n======================\n\nIt is recommended to read this section alongside\nthe `m:gen_statem` reference manual in STDLIB.\n\nEvent-Driven State Machines\n---------------------------\n\nEstablished Automata Theory does not deal much with how a _state transition_\nis triggered, but assumes that the output is a function of the input\n(and the state) and that they are some kind of values.\n\nFor an Event-Driven State Machine, the input is an _event_ that triggers\na _state transition_ and the output is actions executed during\nthe _state transition_.  Analogously to the mathematical model\nof a Finite State Machine, it can be described as a set of relations\nof the following form:\n\n```erlang\nState(S) x Event(E) -> Actions(A), State(S')\n```\n\nThese relations are interpreted as follows: if we are in state `S`,\nand event `E` occurs, we are to perform actions `A`, and make a transition\nto state `S'`.  Notice that `S'` can be equal to `S`,\nand that `A` can be empty.\n\nIn `gen_statem` we define a _state change_ as a _state transition_ in which the\nnew state `S'` is different from the current state `S`, where \"different\" means\nErlang's strict inequality: `=/=` also known as \"does not match\". `gen_statem`\ndoes more things during _state changes_ than during other _state transitions_.\n\nAs `A` and `S'` depend only on `S` and `E`, the kind of state machine described\nhere is a Mealy machine (see, for example, the Wikipedia article\n[Mealy machine](https://en.wikipedia.org/wiki/Mealy_machine)).\n\nSimilar to most `gen_` behaviours, `gen_statem` keeps a server `Data`\nitem besides the state. Because of this data item, and since there is\nno restriction on the number of states (assuming sufficient virtual\nmachine memory), or on the number of distinct input events, a state\nmachine implemented with this behaviour is Turing complete. But it\nfeels mostly like an Event-Driven Mealy machine.","title":"gen_statem Behaviour","ref":"statem.html"},{"type":"extras","doc":"An example of an everyday device that can be modelled as a state machine\nis a classic ballpoint pen, the retractable type where you push the end\nto expose the tip and push the side to retract it.  (A push-push pen\nwould also be an example but that type has only one event, so it is\nless interesting)\n\n![Ballpoint Pen](assets/ballpoint-pen.svg \"Ballpoint Pen\")\n\n```mermaid\n---\ntitle: Ballpoint Pen State Diagram\n---\nstateDiagram-v2\n    [*]       --> Retracted\n    Retracted --> Retracted : push-side\n    Retracted --> Exposed   : push-end\\n* Expose tip\n    Exposed   --> Retracted : push-side\\n* Retract tip\n    Exposed   --> Exposed   : push-end\n```\n\nThe state diagram shows the states, events, and state transitions\nwith transition actions.  Note that pushing the end when the tip is exposed,\nor pushing the side when the tip is retracted, does not change the state\nnor cause any actions, which is modeled by an arrow back to the same state.\n\nWhen to use gen_statem\n----------------------\n\nYou should consider using `m:gen_statem` over `m:gen_server` if your\nprocess logic is convenient to describe as a state machine and you\nneed any of these `m:gen_statem` key features:\n\n- Co-located callback code for each state, for all\n  [_event types_](#event-types-and-event-content), such as _call_,\n  _cast_, and _info_\n- [_Postponing events_](#postponing-events) - a substitute for selective\n  receive\n- [_Inserted events_](#inserted-events) - events from the state\n  machine to itself; for purely internal events in particular\n- [_State enter calls_](#state-enter-calls) - callback on state entry\n  co-located with the rest of each state's callback code\n- Easy-to-use time-outs - [_state time-outs_](#state-time-outs),\n  [_event time-outs_](#event-time-outs), and\n  [_generic time-outs_](#generic-time-outs) (named time-outs)\n\nFor simple state machines not needing these features, `m:gen_server`\nis perfectly suitable. It also has a smaller call overhead, but we are\ntalking about something like 2 vs 3.3 microseconds call roundtrip time\nhere, so if the server callback does just a little bit more than just\nreplying, or if calls are not extremely frequent, that difference\nwill be hard to notice.\n\nCallback Module\n---------------\n\nThe _callback module_ contains functions that implement the state\nmachine. When an event occurs, the `gen_statem` behaviour engine calls\na function in the _callback module_ with the event, current state, and\nserver data. This callback function performs the actions for the\nevent, and returns the new state and server data as well as actions to\nbe performed by the behaviour engine.\n\nThe behaviour engine holds the state machine state, server data, timer\nreferences, a queue of postponed messages, and other metadata. It receives all\nprocess messages, handles the system messages, and calls the _callback module_\nwith state machine specific events.\n\nThe _callback module_ can be changed for a running server using any of the\n[_transition actions_](#transition-actions)\n[`{change_callback_module, NewModule}`](`t:gen_statem:action/0`),\n[`{push_callback_module, NewModule}`](`t:gen_statem:action/0`), or\n[`pop_callback_module`](`t:gen_statem:action/0`).\n\n> #### Note {: .info }\n>\n> Switching the callback module is a pretty esoteric thing to do...\n>\n> The origin for this feature is a protocol that after version\n> negotiation branches off into quite different state machines depending\n> on the protocol version. There _might_ be other use cases. _Beware_\n> that the new callback module completely replaces the previous callback\n> module, so all relevant callback functions have to handle the state\n> and data from the previous callback module.\n\nCallback Modes\n--------------\n\nThe `gen_statem` behaviour supports two _callback modes_:\n\n- **[`state_functions`](`t:gen_statem:callback_mode/0`)** - Events are handled\n  by one callback function per state.\n\n- **[`handle_event_function`](`t:gen_statem:callback_mode/0`)** - Events are\n  handled by one single callback function.\n\nThe _callback mode_ is a property of the _callback module_ and is set at server\nstart. It may be changed due to a code upgrade/downgrade, or when changing the\n_callback module_.\n\nSee the section [_State Callback_](#state-callback) that describes the\nevent handling callback function(s).\n\nThe _callback mode_ is selected by implementing a mandatory callback function\n[`Module:callback_mode()`](`c:gen_statem:callback_mode/0`) that returns one of\nthe _callback modes_.\n\nThe [`Module:callback_mode()`](`c:gen_statem:callback_mode/0`) function\nmay also return a list containing the _callback mode_ and the atom\n`state_enter` in which case [_state enter calls_](#state-enter-calls)\nare activated for the _callback mode_.","title":"Everyday State Machine - gen_statem Behaviour","ref":"statem.html#everyday-state-machine"},{"type":"extras","doc":"The short version: choose `state_functions` - it is the one most like\n`m:gen_fsm`. But if you do not want the restriction that the state must be an\natom, or if you do not want to write one _state callback_ function per state,\nplease read on...\n\nThe two [_callback modes_](#callback-modes) give different\npossibilities and restrictions, with one common goal: to handle all possible\ncombinations of events and states.\n\nThis can be done, for example, by focusing on one state at the time and for\nevery state ensure that all events are handled. Alternatively, you can focus\non one event at the time and ensure that it is handled in every state.\nYou can also use a mix of these strategies.\n\nWith `state_functions`, you are restricted to use atom-only states, and the\n`m:gen_statem` engine branches depending on state name for you.\nThis encourages the _callback module_ to co-locate the implementation\nof all event actions particular to one state in the same place in the code,\nhence to focus on one state at the time.\n\nThis mode fits well when you have a regular state diagram, like the ones\nin this chapter, which describes all events and actions belonging to a state\nvisually around that state, and each state has its unique name.\n\nWith `handle_event_function`, you are free to mix strategies, as all events\nand states are handled in the same callback function.\n\nThis mode works equally well when you want to focus on one event\nat the time or on one state at the time, but function\n[`Module:handle_event/4`](`c:gen_statem:handle_event/4`) quickly grows\ntoo large to handle without branching to helper functions.\n\nThe mode enables the use of non-atom states, for example, complex states,\nor even hierarchical states. See section [_Complex State_](#complex-state).\nIf, for example, a state diagram is largely alike for the client side\nand the server side of a protocol, you can have a state `{StateName, server}`,\nor `{StateName, client}`, and make `StateName` determine where in the code\nto handle most events in the state. The second element of the tuple\nis then used to select whether to handle special client-side\nor server-side events.\n\nState Callback\n--------------\n\nThe _state callback_ is the callback function that handles an event in the\ncurrent state, and which function that is depends on the _callback mode_:\n\n- **`state_functions`** - The event is handled by:\n  [`Module:StateName(EventType, EventContent,\n  Data)`](`c:gen_statem:'StateName'/3`)\n\n  This form is the one mostly used in the [_Example_](#example) section.\n\n- **`handle_event_function`** - The event is handled by:\n  [`Module:handle_event(EventType, EventContent, State,\n  Data)`](`c:gen_statem:handle_event/4`)\n\n  See section [_One State Callback_](#one-state-callback) for an example.\n\nThe state is either the name of the state callback itself, or an argument\nto the [`handle_event()`](`c:gen_statem:handle_event/4`) callback.  The\nother arguments are the `EventType` and the event dependent `EventContent`,\nboth described in section\n[_Event Types and Event Content_](#event-types-and-event-content),\nand the the last argument is the current server `Data`.\n\n[_State Enter Calls_](#state-enter-calls) (see that section)\nare also handled by the event handler and have slightly different arguments.\n\nThe _state callback_ return values are defined in the description of\n[`Module:StateName/3`](`c:gen_statem:'StateName'/3`) in `m:gen_statem`.\nHere is a maybe more readable list:\n\n- **`{next_state, NextState, NewData [, Actions]}`**\n  Set next state and update the server data. If the `Actions` field is used,\n  execute [_Transition Actions_](#transition-actions)\n  (see that section).  An empty `Actions` list is equivalent to not\n  returning the field.\n\n  If `NextState =/= State` it's a _state change_ and `gen_statem`\n  does some extra things: the event queue is restarted from the oldest\n  [postponed event](#postponing-events), any current\n  [_state time-out_](#state-time-outs) is canceled, and a\n  [_state enter call_](#state-enter-calls) is performed, if enabled.\n  The current `State` becomes `OldState` in a _state enter call_.\n\n- **`{keep_state, NewData [, Actions]}`**\n  Same as the `next_state` values with `NextState =:= State`, that is,\n  no _state change_.\n\n- **`keep_state_and_data | {keep_state_and_data, Actions}`**\n  Same as the `keep_state` values with `NextData =:= Data`, that is, no change\n  in server data.\n\n- **`{repeat_state, NewData [, Actions]} |\n  repeat_state_and_data |{repeat_state_and_data, Actions}`**\n  Same as the `keep_state` or `keep_state_and_data` values, but if\n  [_state enter calls_](#state-enter-calls) are enabled;\n  repeat it as if this state was entered again.  In this case `State`\n  and `OldState` becomes equal in the repeated _state enter call_\n  since the state is re-entered from itself.\n\n- **`{stop, Reason [, NewData]}`**\n  Stop the server with reason `Reason`. If the `NewData` field is used,\n  first update the server data.\n\n- **`{stop_and_reply, Reason, [NewData, ] ReplyActions}`**\n  Same as the `stop` values, but first execute the given\n  [_transition actions_](#transition-actions)\n  that may only be reply actions.","title":"Choosing the Callback Mode - gen_statem Behaviour","ref":"statem.html#choosing-the-callback-mode"},{"type":"extras","doc":"To decide the first state the\n[`Module:init(Args)`](`c:gen_statem:init/1`) callback function is called\nbefore any [_state callback_](#state-callback) is called. This function\nbehaves like a _state callback_ function, but gets its only argument `Args`\nfrom the `gen_statem` [`start/3,4`](`gen_statem:start/3`) or\n[`start_link/3,4`](`gen_statem:start_link/3`) function, and returns\n`{ok, State, Data}` or `{ok, State, Data, Actions}`. If you use the\n[`postpone`](#postponing-events) action from this function, that action\nis ignored, since there is no event to postpone.\n\nTransition Actions\n------------------\n\nIn the first section\n([_Event-Driven State Machines_](#event-driven-state-machines)), actions\nwere mentioned as a part of the general state machine model. These general\nactions are implemented with the code that _callback module_ `gen_statem`\nexecutes in an event-handling callback function before returning to the\n`m:gen_statem` engine.\n\nThere are more specific _transition actions_ that a callback function can\ncommand the `gen_statem` engine to do after the callback function return.\nThese are commanded by returning a list of [_actions_](`t:gen_statem:action/0`)\nin the [return value](`t:gen_statem:state_callback_result/2`) from the\n[_callback function_](`c:gen_statem:'StateName'/3`). These are the possible\n_transition actions_:\n\n- **[`{postpone, Boolean}`](`t:gen_statem:postpone/0`)** -\n  If `true` postpone the current event, see section\n  [_Postponing Events_](#postponing-events).\n\n- **[`{hibernate, Boolean`](`t:gen_statem:hibernate/0`)** -\n  If `true` hibernate the `gen_statem`, treated in section\n  [_Hibernation_](#hibernation).\n\n- **[`{state_timeout, Time, EventContent\n  [, Opts]}`](`t:gen_statem:state_timeout/0`)` |`**\\\n  **[`{state_timeout, update,\n  EventContent}`](`t:gen_statem:timeout_update_action/0`)` |`**\\\n  **[`{state_timeout, cancel}`](`t:gen_statem:timeout_cancel_action/0`)** -\n  Start, update, or cancel a _state time-out_, read more in sections\n  [_Time-Outs_](#time-outs) and\n  [_State Time-Outs_](#state-time-outs).\n\n- **[`{{timeout, Name}, Time, EventContent\n  [, Opts]}`](`t:gen_statem:generic_timeout/0`)` |`**\\\n  **[`{{timeout, Name}, update,\n  EventContent}`](`t:gen_statem:timeout_update_action/0`)` |`**\\\n  **[`{{timeout, Name}, cancel}`](`t:gen_statem:timeout_cancel_action/0`)** -\n  Start, update, or cancel a _generic time-out_, read more in sections\n  [_Time-Outs_](#time-outs) and\n  [_Generic Time-Outs_](#generic-time-outs).\n\n- **[`{timeout, Time, EventContent\n  [, Opts]}`](`t:gen_statem:event_timeout/0`)** -\n  Start an _event time-out_, see more in sections [_Time-Outs_](#time-outs)\n  and [_Event Time-Outs_](#event-time-outs).\n\n- **[`{reply, From, Reply}`](`t:gen_statem:reply_action/0`)** - Reply to a\n  caller, mentioned at the end of section\n  [_All State Events_](#all-state-events).\n\n- **[`{next_event, EventType, EventContent}`](`t:gen_statem:action/0`)** -\n  Generate the next event to handle, see section\n  [_Inserted Events_](#inserted-events).\n\n- **[`{change_callback_module, NewModule}`](`t:gen_statem:action/0`)** -\n  Change the [_callback module_](#callback-module) for the running server.\n  This can be done during any _state transition_, whether it is\n  a _state change_ or not, but it _cannot_ be done from a\n  [_state enter call_](#state-enter-calls).\n\n- **[`{push_callback_module, NewModule}`](`t:gen_statem:action/0`)** -\n  Push the current _callback module_ to the top of an internal stack\n  of callback modules and set the new [_callback module_](#callback-module)\n  for the running server.  Otherwise like\n  `{change_callback_module, NewModule}` above.\n\n- **[`pop_callback_module`](`t:gen_statem:action/0`)** - Pop the top module\n  from the internal stack of callback modules and set it to be the new\n  [_callback module_](#callback-module) for the running server. If the\n  stack is empty the server fails. Otherwise like\n  `{change_callback_module, NewModule}` above.\n\nFor details, see module `m:gen_statem` for type\n[`action()`](`t:gen_statem:action/0`). You can, for example, reply to many\ncallers, generate multiple next events, and set a time-out to use absolute\ninstead of relative time (using the `Opts` field).\n\nOut of these _transition actions_, the only immediate action is\n`reply` for replying to a caller. The other actions are collected and\nhandled later during the _state transition_.\n[_Inserted events_](#inserted-events) are stored and inserted all\ntogether, and the rest set transition options where the last of a\nspecific type override the previous. See the description of a _state\ntransition_ in module `m:gen_statem` for type\n[`transition_option()`](`t:gen_statem:transition_option/0`).\n\nThe different [_Time-Outs_](#time-outs) and\n[`next_event`](#inserted-events) actions generate new events with\ncorresponding\n[_event types and event content_](#event-types-and-event-content).\n\nEvent Types and Event Content\n-----------------------------\n\nEvents are categorized in different\n[_event types_](`t:gen_statem:event_type/0`). Events of all types are for a\ngiven state handled in the same callback function, and that function gets\n`EventType` and `EventContent` as arguments. The meaning of the `EventContent`\ndepends on the `EventType`.\n\nThe following is a complete list of _event types_ and from where they come:\n\n- **[`cast`](`t:gen_statem:external_event_type/0`)** - Generated by\n  [`gen_statem:cast(ServerRef, Msg)`](`gen_statem:cast/2`) where `Msg` becomes\n  the `EventContent`.\n\n- **[`{call, From}`](`t:gen_statem:external_event_type/0`)** - Generated by\n  [`gen_statem:call(ServerRef, Request)`](`gen_statem:call/2`),\n  [`gen_statem:send_request(ServerRef,\n  Request)`](`gen_statem:send_request/2`), or\n  [`gen_statem:send_request(ServerRef, Request,\n  _, _)`](`gen_statem:send_request/4`) where `Request` becomes\n  the `EventContent`.  `From` is the reply address to use when replying\n  either through the _transition action_ `{reply, From, Reply}`,\n  or by calling [`gen_statem:reply(From, Reply)`](`gen_statem:reply/1`)\n  from the _callback module_.\n\n- **[`info`](`t:gen_statem:external_event_type/0`)** - Generated by\n  any regular process message sent to the `gen_statem` process.\n  The process message becomes the `EventContent`.\n\n- **[`state_timeout`](`t:gen_statem:timeout_event_type/0`)** - Generated by\n  _transition action_\n  [`{state_timeout, Time, EventContent}`](`t:gen_statem:timeout_action/0`)\n  when the time-out expires. Read more in sections [_Time-Outs_](#time-outs)\n  and [_State Time-Outs_](#state-time-outs).\n\n- **[`{timeout, Name}`](`t:gen_statem:timeout_event_type/0`)** - Generated by\n  _transition action_\n  [`{{timeout, Name},Time, EventContent}`](`t:gen_statem:timeout_action/0`)\n  when the time-out expires. Read more in sections [_Time-Outs_](#time-outs)\n  and [_Generic Time-Outs_](#generic-time-outs).\n\n- **[`timeout`](`t:gen_statem:timeout_event_type/0`)** - Generated by\n  _transition action_\n  [`{timeout, Time, EventContent}`](`t:gen_statem:timeout_action/0`)\n  (or its short form `Time`) when the time-out expires. Read more in sections\n  [_Time-Outs_](#time-outs) and [_Event Time-Outs_](#event-time-outs).\n\n- **[`internal`](`t:gen_statem:event_type/0`)** - Generated by _transition\n  action_ [`{next_event, internal, EventContent}`](`t:gen_statem:action/0`).\n  All _event types_ above can also be generated using the `next_event` action:\n  `{next_event, EventType, EventContent}`.\n\nState Enter Calls\n-----------------\n\nThe `gen_statem` behaviour can, if this is enabled, regardless of _callback\nmode_, automatically call the [_state callback_](`t:gen_statem:state_enter/0`)\nwith special arguments whenever the state changes, so you can write\nstate enter actions near the rest of the _state transition_ rules.\nIt typically looks like this:\n\n```erlang\nStateName(enter, OldState, Data) ->\n    ... code for state enter actions here ...\n    {keep_state, NewData};\nStateName(EventType, EventContent, Data) ->\n    ... code for actions here ...\n    {next_state, NewStateName, NewData}.\n```\n\nSince the _state enter call_ is not an event there are restrictions on the\nallowed return value and state [_transition actions_](#transition-actions).\nYou must not change the state, [postpone](#postponing-events) this non-event,\n[insert any events](#inserted-events), or change the\n[_callback module_](#callback-module).\n\nThe first state that is entered after `c:gen_statem:init/1` will get\na _state enter call_ with `OldState` equal to the current state.\n\nYou may repeat the _state enter call_ using the `{repeat_state,...}` return\nvalue from the [_state callback_](#state-callback). In this case\n`OldState` will also be equal to the current state.\n\nDepending on how your state machine is specified, this can be a very useful\nfeature, but it forces you to handle the _state enter calls_ in all states.\nSee also the [_State Enter Actions_](#state-enter-actions) section.\n\nTime-Outs\n---------\n\nTime-outs in `gen_statem` are started from a\n[_transition action_](#transition-actions) during a state transition\nthat is when exiting from the [_state callback_](#state-callback).\n\nThere are 3 types of time-outs in `gen_statem`:\n\n- **[`state_timeout`](`t:gen_statem:state_timeout/0`)** - There is one\n  [_state time-out_](#state-time-outs) that is automatically canceled by\n  a _state change_.\n\n- **[`{timeout, Name}`](`t:gen_statem:generic_timeout/0`)** - There are any\n  number of [_generic time-outs_](#generic-time-outs) differing by their\n  `Name`. They have no automatic canceling.\n\n- **[`timeout`](`t:gen_statem:event_timeout/0`)** - There is one\n  [_event time-out_](#event-time-outs) that is automatically canceled by\n  any event. Note that [postponed](#postponing-events) and\n  [inserted](#inserted-events) events cancel this time-out just as\n  external events do.\n\nWhen a time-out is started, any running time-out of the same type\n(`state_timeout`, `{timeout, Name}`, or `timeout`) is canceled, that is,\nthe time-out is restarted with the new time and event content.\n\nAll time-outs have an `EventContent` that is part of the\n[_transition action_](#transition-actions) that starts the time-out.\nDifferent `EventContent`s does not create different time-outs. The\n`EventContent` is delivered to the [_state callback_](#state-callback)\nwhen the time-out expires.","title":"The First State - gen_statem Behaviour","ref":"statem.html#the-first-state"},{"type":"extras","doc":"Starting a time-out with the `infinity` time value would never time out,\nwhich is optimized by not even starting it, and any running\ntime-out with the same tag will be canceled. The `EventContent` will\nin this case be ignored, so it makes sense to set it to `undefined`.\n\nA more explicit way to cancel a time-out is to use a\n[_transition action_](#transition-actions) on the form\n[`{TimeoutType, cancel}`](`t:gen_statem:timeout_cancel_action/0`).","title":"Canceling a Time-Out - gen_statem Behaviour","ref":"statem.html#canceling-a-time-out"},{"type":"extras","doc":"While a time-out is running, its `EventContent` can be updated using a\n[_transition action_](#transition-actions) on the form\n[`{TimeoutType, update,\nNewEventContent}`](`t:gen_statem:timeout_update_action/0`).\n\nIf this feature is used while no such `TimeoutType` is running, a time-out\nevent is immediately delivered as when starting a\n[zero time-out](#zero-time-out).","title":"Updating a Time-Out - gen_statem Behaviour","ref":"statem.html#updating-a-time-out"},{"type":"extras","doc":"If a time-out is started with the time `0` it will actually not be started.\nInstead the time-out event will immediately be inserted to be processed after\nany events already enqueued, and before any not yet received external events.\n\nNote that some time-outs are automatically canceled so if you for example\ncombine [postponing](#postponing-events) an event in a _state change_\nwith starting an [_event time-out_](#event-time-outs) with time `0` there\nwill be no time-out event inserted since the _event time-out_ is canceled by\nthe postponed event that is delivered due to the state change.\n\nExample\n-------\n\nA door with a code lock can be seen as a state machine.  Initially,\nthe door is locked.  When someone presses a button, a `{button, Button}`\nevent is generated.  In the state diagram below, \"Collect Buttons\" means\nto store buttons up to as many as in the correct code; append to\na length capped list.  If correct, the door is unlocked for 10 seconds.\nIf incorrect, we wait for a new button to be pressed.\n\n```mermaid\n---\ntitle: Code Lock State Diagram\n---\nstateDiagram-v2\n    state check_code < >\n\n    [*]         --> locked : * do_lock()\\n* Clear Buttons\n\n    locked      --> check_code : {button, Button}\\n* Collect Buttons\n    check_code  --> locked     : Incorrect code\n    check_code  --> open       : Correct code\\n* do_unlock()\\n* Clear Buttons\\n* Set state_timeout 10 s\n\n    open        --> open   : {button, Digit}\n    open        --> locked : state_timeout\\n* do_lock()\n```\n\nThis code lock state machine can be implemented using `m:gen_statem` with\nthe following _callback module_:\n\n```erlang\n-module(code_lock).\n-behaviour(gen_statem).\n-define(NAME, code_lock).\n\n-export([start_link/1]).\n-export([button/1]).\n-export([init/1,callback_mode/0,terminate/3]).\n-export([locked/3,open/3]).\n\nstart_link(Code) ->\n    gen_statem:start_link({local,?NAME}, ?MODULE, Code, []).\n\nbutton(Button) ->\n    gen_statem:cast(?NAME, {button,Button}).\n\ninit(Code) ->\n    do_lock(),\n    Data = #{code => Code, length => length(Code), buttons => []},\n    {ok, locked, Data}.\n\ncallback_mode() ->\n    state_functions.\n```\n\n```erlang\nlocked(\n  cast, {button,Button},\n  #{code := Code, length := Length, buttons := Buttons} = Data) ->\n    NewButtons =\n        if\n            length(Buttons)  \n                Buttons;\n            true ->\n                tl(Buttons)\n        end ++ [Button],\n    if\n        NewButtons =:= Code -> % Correct\n\t    do_unlock(),\n            {next_state, open, Data#{buttons := []},\n             [{state_timeout,10_000,lock}]}; % Time in milliseconds\n\ttrue -> % Incomplete | Incorrect\n            {next_state, locked, Data#{buttons := NewButtons}}\n    end.\n```\n\n```erlang\nopen(state_timeout, lock,  Data) ->\n    do_lock(),\n    {next_state, locked, Data};\nopen(cast, {button,_}, Data) ->\n    {next_state, open, Data}.\n```\n\n```erlang\ndo_lock() ->\n    io:format(\"Lock~n\", []).\ndo_unlock() ->\n    io:format(\"Unlock~n\", []).\n\nterminate(_Reason, State, _Data) ->\n    State =/= locked andalso do_lock(),\n    ok.\n```\n\nThe code is explained in the next sections.\n\nStarting gen_statem\n-------------------\n\nIn the example in the previous section, `gen_statem` is started by calling\n`code_lock:start_link(Code)`:\n\n```erlang\nstart_link(Code) ->\n    gen_statem:start_link({local,?NAME}, ?MODULE, Code, []).\n```\n\n`start_link/1` calls function `gen_statem:start_link/4`,\nwhich spawns and links to a new process, a `gen_statem`.\n\n- The first argument, `{local,?NAME}`, specifies the name. In this case, the\n  `gen_statem` is locally registered as `code_lock` through the macro `?NAME`.\n\n  If the name is omitted, the `gen_statem` is not registered. Instead its pid\n  must be used. The name can also be specified as `{global, Name}`, then the\n  `gen_statem` is registered using `global:register_name/2` in Kernel.\n\n- The second argument, `?MODULE`, is the name of the _callback module_,\n  that is, the module where the callback functions are located,\n  which is this module.\n\n  The interface functions (`start_link/1` and `button/1`) are located in the\n  same module as the callback functions (`init/1`, `locked/3`, and `open/3`).\n  It is normally good programming practice to have the client-side code\n  and the server-side code contained in the same module.\n\n- The third argument, `Code`, is a list of digits, which is the correct\n  unlock code that is passed to callback function `init/1`.\n\n- The fourth argument, `[]`, is a list of options. For the available options,\n  see `gen_statem:start_link/3`.\n\nIf name registration succeeds, the new `gen_statem` process calls callback\nfunction `code_lock:init(Code)`. This function is expected to return\n`{ok, State, Data}`, where `State` is the initial state of the `gen_statem`,\nin this case `locked`; assuming that the door is locked to begin with.\n`Data` is the internal server data of the `gen_statem`. Here the server data\nis a [`map()`](`m:maps`) with key `code` that stores the correct\nbutton sequence, key `length` store its length, and key `buttons`\nthat stores the collected buttons up to the same length.\n\n```erlang\ninit(Code) ->\n    do_lock(),\n    Data = #{code => Code, length => length(Code), buttons => []},\n    {ok, locked, Data}.\n```\n\nFunction [`gen_statem:start_link/3,4`](`gen_statem:start_link/3`)\nis synchronous. It does not return until the `gen_statem` is initialized\nand is ready to receive events.\n\nFunction [`gen_statem:start_link/3,4`](`gen_statem:start_link/3`)\nmust be used if the `gen_statem` is part of a supervision tree, that is,\nstarted by a supervisor.  Function,\n[`gen_statem:start/3,4`](`gen_statem:start/3`) can be used to start\na standalone `gen_statem`, meaning it is not part of a supervision tree.\n\nFunction [`Module:callback_mode/0`](`c:gen_statem:callback_mode/0`) selects\nthe [`CallbackMode`](#callback-modes) for the _callback module_,\nin this case [`state_functions`](`t:gen_statem:callback_mode/0`).\nThat is, each state has its own handler function:\n\n```erlang\ncallback_mode() ->\n    state_functions.\n```\n\nHandling Events\n---------------\n\nThe function notifying the code lock about a button event is implemented using\n`gen_statem:cast/2`:\n\n```erlang\nbutton(Button) ->\n    gen_statem:cast(?NAME, {button,Button}).\n```\n\nThe first argument is the name of the `gen_statem` and must agree with\nthe name used to start it. So, we use the same macro `?NAME` as when starting.\n`{button, Button}` is the event content.\n\nThe event is sent to the `gen_statem`. When the event is received, the\n`gen_statem` calls `StateName(cast, Event, Data)`, which is expected\nto return a tuple `{next_state, NewStateName, NewData}`, or\n`{next_state, NewStateName, NewData, Actions}`. `StateName` is the name\nof the current state and `NewStateName` is the name of the next state.\n`NewData` is a new value for the server data of the `gen_statem`,\nand `Actions` is a list of actions to be performed by the `gen_statem` engine.\n\n```erlang\nlocked(\n  cast, {button,Button},\n  #{code := Code, length := Length, buttons := Buttons} = Data) ->\n    NewButtons =\n        if\n            length(Buttons)  \n                Buttons;\n            true ->\n                tl(Buttons)\n        end ++ [Button],\n    if\n        NewButtons =:= Code -> % Correct\n\t    do_unlock(),\n            {next_state, open, Data#{buttons := []},\n             [{state_timeout,10_000,lock}]}; % Time in milliseconds\n\ttrue -> % Incomplete | Incorrect\n            {next_state, locked, Data#{buttons := NewButtons}}\n    end.\n```\n\nIn state `locked`, when a button is pressed, it is collected with the\npreviously pressed buttons up to the length of the correct code, then\ncompared with the correct code. Depending on the result, the door is\neither unlocked and the `gen_statem` goes to state `open`, or the door\nremains in state `locked`.\n\nWhen changing to state `open`, the collected buttons are reset, the lock\nunlocked, and a _state time-out_ for 10 seconds is started.\n\n```erlang\nopen(cast, {button,_}, Data) ->\n    {next_state, open, Data}.\n```\n\nIn state `open`, a button event is ignored by staying in the same state.\nThis can also be done by returning `{keep_state, Data}`, or in this case\nsince `Data` is unchanged, by returning `keep_state_and_data`.\n\nState Time-Outs\n---------------\n\nWhen a correct code has been given, the door is unlocked and the following\ntuple is returned from `locked/2`:\n\n```erlang\n{next_state, open, Data#{buttons := []},\n [{state_timeout,10_000,lock}]}; % Time in milliseconds\n```\n\n10,000 is a time-out value in milliseconds. After this time (10 seconds),\na time-out occurs. Then, `StateName(state_timeout, lock, Data)` is called.\nThe time-out occurs when the door has been in state `open` for 10 seconds.\nAfter that the door is locked again:\n\n```erlang\nopen(state_timeout, lock,  Data) ->\n    do_lock(),\n    {next_state, locked, Data};\n```\n\nThe timer for a _state time-out_ is automatically canceled when\nthe state machine does a _state change_.\n\nYou can restart, cancel, or update a _state time-out_. See section\n[_Time-Outs_](#time-outs) for details.\n\nAll State Events\n----------------\n\nSometimes events can arrive in any state of the `gen_statem`. It is convenient\nto handle these in a common state handler function that all state functions\ncall for events not specific to the state.\n\nConsider a `code_length/0` function that returns the length\nof the correct code.  We dispatch all events that are not state-specific\nto the common function `handle_common/3`:\n\n```erlang\n...\n-export([button/1,code_length/0]).\n...\n\ncode_length() ->\n    gen_statem:call(?NAME, code_length).\n\n...\nlocked(...) -> ... ;\nlocked(EventType, EventContent, Data) ->\n    handle_common(EventType, EventContent, Data).\n\n...\nopen(...) -> ... ;\nopen(EventType, EventContent, Data) ->\n    handle_common(EventType, EventContent, Data).\n\nhandle_common({call,From}, code_length, #{code := Code} = Data) ->\n    {keep_state, Data,\n     [{reply,From,length(Code)}]}.\n```\n\nAnother way to do it is through a convenience macro `?HANDLE_COMMON/0`:\n\n```erlang\n...\n-export([button/1,code_length/0]).\n...\n\ncode_length() ->\n    gen_statem:call(?NAME, code_length).\n\n-define(HANDLE_COMMON,\n    ?FUNCTION_NAME(T, C, D) -> handle_common(T, C, D)).\n%%\nhandle_common({call,From}, code_length, #{code := Code} = Data) ->\n    {keep_state, Data,\n     [{reply,From,length(Code)}]}.\n\n...\nlocked(...) -> ... ;\n?HANDLE_COMMON.\n\n...\nopen(...) -> ... ;\n?HANDLE_COMMON.\n```\n\nThis example uses `gen_statem:call/2`, which waits for a reply from the server.\nThe reply is sent with a `{reply, From, Reply}` tuple in an action list in the\n`{keep_state, ...}` tuple that retains the current state. This return form is\nconvenient when you want to stay in the current state but do not know or care\nabout what it is.\n\nIf the common _state callback_ needs to know the current state a function\n`handle_common/4` can be used instead:\n\n```erlang\n-define(HANDLE_COMMON,\n    ?FUNCTION_NAME(T, C, D) -> handle_common(T, C, ?FUNCTION_NAME, D)).\n```\n\nOne State Callback\n------------------\n\nIf [_callback mode_](#callback-modes) `handle_event_function` is used,\nall events are handled in\n[`Module:handle_event/4`](`c:gen_statem:handle_event/4`) and we can\n(but do not have to) use an event-centered approach where we first branch\ndepending on event and then depending on state:\n\n```erlang\n...\n-export([handle_event/4]).\n\n...\ncallback_mode() ->\n    handle_event_function.\n\nhandle_event(cast, {button,Button}, State, #{code := Code} = Data) ->\n    case State of\n\tlocked ->\n            #{length := Length, buttons := Buttons} = Data,\n            NewButtons =\n                if\n                    length(Buttons)  \n                        Buttons;\n                    true ->\n                        tl(Buttons)\n                end ++ [Button],\n            if\n                NewButtons =:= Code -> % Correct\n                    do_unlock(),\n                    {next_state, open, Data#{buttons := []},\n                     [{state_timeout,10_000,lock}]}; % Time in milliseconds\n                true -> % Incomplete | Incorrect\n                    {keep_state, Data#{buttons := NewButtons}}\n            end;\n\topen ->\n            keep_state_and_data\n    end;\nhandle_event(state_timeout, lock, open, Data) ->\n    do_lock(),\n    {next_state, locked, Data};\nhandle_event(\n  {call,From}, code_length, _State, #{code := Code} = Data) ->\n    {keep_state, Data,\n     [{reply,From,length(Code)}]}.\n\n...\n```\n\nStopping\n--------","title":"Zero Time-Out - gen_statem Behaviour","ref":"statem.html#zero-time-out"},{"type":"extras","doc":"If the `gen_statem` is part of a supervision tree, no stop function is needed.\nThe `gen_statem` is automatically terminated by its supervisor. Exactly how\nthis is done is defined by a [shutdown strategy](sup_princ.md#shutdown)\nset in the supervisor.\n\nIf it is necessary to clean up before termination, the shutdown strategy\nmust be a time-out value and the `gen_statem` must in function `init/1`\nset itself to trap exit signals by calling\n[`process_flag(trap_exit, true)`](`erlang:process_flag/2`):\n\n```erlang\ninit(Args) ->\n    process_flag(trap_exit, true),\n    do_lock(),\n    ...\n```\n\nWhen ordered to shut down, the `gen_statem` then calls callback function\n`terminate(shutdown, State, Data)`.\n\nIn this example, function `terminate/3` locks the door if it is open,\nso we do not accidentally leave the door open\nwhen the supervision tree terminates:\n\n```erlang\nterminate(_Reason, State, _Data) ->\n    State =/= locked andalso do_lock(),\n    ok.\n```","title":"In a Supervision Tree - gen_statem Behaviour","ref":"statem.html#in-a-supervision-tree"},{"type":"extras","doc":"If the `gen_statem` is not part of a supervision tree, it can be stopped\nusing [`gen_statem:stop/1`](`gen_statem:stop/1`), preferably through\nan API function:\n\n```erlang\n...\n-export([start_link/1,stop/0]).\n\n...\nstop() ->\n    gen_statem:stop(?NAME).\n```\n\nThis makes the `gen_statem` call callback function `terminate/3` just like\nfor a supervised server and waits for the process to terminate.\n\nEvent Time-Outs\n---------------\n\nA time-out feature inherited from `gen_statem`'s predecessor `m:gen_fsm`,\nis an _event time-out_, that is, if an event arrives the timer is canceled.\nYou get either an event or a time-out, but not both.\n\nIt is ordered by the\n[_transition action_](#transition-actions) `{timeout, Time, EventContent}`,\nor just an integer `Time`, even without the enclosing actions list (the latter\nis a form inherited from `gen_fsm`).\n\nThis type of time-out is useful, for example, to act on inactivity.\nLet's restart the code sequence if no button is pressed for say 30 seconds:\n\n```erlang\n...\n\nlocked(timeout, _, Data) ->\n    {next_state, locked, Data#{buttons := []}};\nlocked(\n  cast, {button,Button},\n  #{code := Code, length := Length, buttons := Buttons} = Data) ->\n...\n\ttrue -> % Incomplete | Incorrect\n            {next_state, locked, Data#{buttons := NewButtons},\n             30_000} % Time in milliseconds\n...\n```\n\nWhenever we receive a button event we start an _event time-out_ of 30 seconds,\nand if we get an _event type_ of `timeout` we reset the remaining\ncode sequence.\n\nAn _event time-out_ is canceled by any other event so you either get\nsome other event or the time-out event. Therefore, canceling,\nrestarting, or updating an _event time-out_ is neither possible nor\nnecessary. Whatever event you act on has already canceled\nthe _event time-out_, so there is never a running _event time-out_\nwhile the _state callback_ executes.\n\nNote that an _event time-out_ does not work well when you have for example a\nstatus call as in section [_All State Events_](#all-state-events), or\nhandle unknown events, since all kinds of events will cancel\nthe _event time-out_.\n\nGeneric Time-Outs\n-----------------\n\nThe previous example of _state time-outs_ only work if the state machine stays\nin the same state during the time-out time. And _event time-outs_ only work\nif no disturbing unrelated events occur.\n\nYou may want to start a timer in one state and respond to the time-out in\nanother, maybe cancel the time-out without changing states, or perhaps run\nmultiple time-outs in parallel. All this can be accomplished with\n[_generic time-outs_](`t:gen_statem:generic_timeout/0`). They may look a little\nbit like [_event time-outs_](`t:gen_statem:event_timeout/0`) but contain\na name to allow for any number of them simultaneously and they are\nnot automatically canceled.\n\nHere is how to accomplish the _state time-out_ in the previous example\nby instead using a _generic time-out_ named for example `open`:\n\n```erlang\n...\nlocked(\n  cast, {button,Button},\n  #{code := Code, length := Length, buttons := Buttons} = Data) ->\n...\n    if\n        NewButtons =:= Code -> % Correct\n\t    do_unlock(),\n            {next_state, open, Data#{buttons := []},\n             [{{timeout,open},10_000,lock}]}; % Time in milliseconds\n...\n\nopen({timeout,open}, lock, Data) ->\n    do_lock(),\n    {next_state,locked,Data};\nopen(cast, {button,_}, Data) ->\n    {keep_state,Data};\n...\n```\n\nSpecific _generic time-outs_ can just as [_state time-outs_](#state-time-outs)\nbe restarted or canceled by setting it to a new time or `infinity`.\n\nIn this particular case we do not need to cancel the time-out since\nthe time-out event is the only possible reason to do a _state change_\nfrom `open` to `locked`.\n\nInstead of bothering with when to cancel a time-out, a late time-out event\ncan be handled by ignoring it if it arrives in a state\nwhere it is known to be late.\n\nYou can restart, cancel, or update a _generic time-out_.\nSee section [_Time-Outs_](#time-outs) for details.\n\nErlang Timers\n-------------\n\nThe most versatile way to handle time-outs is to use Erlang Timers; see\n[`erlang:start_timer/3,4`](`erlang:start_timer/4`). Most time-out tasks\ncan be performed with the time-out features in `m:gen_statem`,\nbut an example of one that cannot is if you should need the return value\nfrom [`erlang:cancel_timer(Tref)`](`erlang:cancel_timer/2`), that is,\nthe remaining time of the timer.\n\nHere is how to accomplish the _state time-out_ in the previous example\nby instead using an Erlang Timer:\n\n```erlang\n...\nlocked(\n  cast, {button,Button},\n  #{code := Code, length := Length, buttons := Buttons} = Data) ->\n...\n    if\n        NewButtons =:= Code -> % Correct\n\t    do_unlock(),\n\t    Tref =\n                 erlang:start_timer(\n                     10_000, self(), lock), % Time in milliseconds\n            {next_state, open, Data#{buttons := [], timer => Tref}};\n...\n\nopen(info, {timeout,Tref,lock}, #{timer := Tref} = Data) ->\n    do_lock(),\n    {next_state,locked,maps:remove(timer, Data)};\nopen(cast, {button,_}, Data) ->\n    {keep_state,Data};\n...\n```\n\nRemoving the `timer` key from the map when we do a _state change_ to `locked`\nis not strictly necessary since we can only get into state `open`\nwith an updated `timer` map value. But it can be nice to not have\noutdated values in the state `Data`.\n\nIf you need to cancel a timer because of some other event, you can use\n[`erlang:cancel_timer(Tref)`](`erlang:cancel_timer/2`). Note that no time-out\nmessage will arrive after this (because the timer has been\nexplicitly canceled), unless you have already postponed one earlier\n(see the next section), so ensure that you do not accidentally\npostpone such messages.  Also note that a time-out message may arrive\nduring a _state callback_ that is canceling the timer, so you may have to\nread out such a message from the process mailbox, depending on\nthe return value from [`erlang:cancel_timer(Tref)`](`erlang:cancel_timer/2`).\n\nAnother way to handle a late time-out can be to not cancel it, but to ignore it\nif it arrives in a state where it is known to be late.\n\nPostponing Events\n-----------------\n\nIf you want to ignore a particular event in the current state and handle it\nin a future state, you can postpone the event. A postponed event\nis retried after a _state change_, that is, `OldState =/= NewState`.\n\nPostponing is ordered by the\n[_transition action_](#transition-actions) `postpone`.\n\nIn this example, instead of ignoring button events while in the `open` state,\nwe can postpone them handle them later in the `locked` state:\n\n```erlang\n...\nopen(cast, {button,_}, Data) ->\n    {keep_state,Data,[postpone]};\n...\n```\n\nSince a postponed event is only retried after a _state change_, you have to\nthink about where to keep a state data item. You can keep it in the server\n`Data` or in the `State` itself, for example by having two more or less\nidentical states to keep a boolean value, or by using a complex state (see\nsection [_Complex State_](#complex-state)) with\n[_callback mode_](#callback-modes)\n[`handle_event_function`](`t:gen_statem:callback_mode/0`). If a change\nin the value changes the set of events that is handled, the value\nshould be in the State.  Otherwise no postponed events will be retried\nsince only the server `Data` changes.\n\nThis is important if events are postponed.  But remember that an incorrect\ndesign decision of what belongs in the state, may become a hard to find bug\nsome time later, when event postponing is introduced.","title":"Standalone gen_statem - gen_statem Behaviour","ref":"statem.html#standalone-gen_statem"},{"type":"extras","doc":"It is not uncommon that a state diagram does not specify how to handle events\nthat are not illustrated in a particular state in the diagram.\nHopefully this is described in an associated text or from the context.\n\nPossible actions: ignore as in drop the event (maybe log it) or deal with\nthe event in some other state as in postpone it.","title":"Fuzzy State Diagrams - gen_statem Behaviour","ref":"statem.html#fuzzy-state-diagrams"},{"type":"extras","doc":"Erlang's selective `receive` statement is often used to describe simple state\nmachine examples in straightforward Erlang code. The following is a possible\nimplementation of the first example:\n\n```erlang\n-module(code_lock).\n-define(NAME, code_lock_1).\n-export([start_link/1,button/1]).\n\nstart_link(Code) ->\n    spawn(\n      fun () ->\n\t      true = register(?NAME, self()),\n\t      do_lock(),\n\t      locked(Code, length(Code), [])\n      end).\n\nbutton(Button) ->\n    ?NAME ! {button,Button}.\n```\n\n```erlang\nlocked(Code, Length, Buttons) ->\n    receive\n        {button,Button} ->\n            NewButtons =\n                if\n                    length(Buttons)  \n                        Buttons;\n                    true ->\n                        tl(Buttons)\n                end ++ [Button],\n            if\n                NewButtons =:= Code -> % Correct\n                    do_unlock(),\n\t\t    open(Code, Length);\n                true -> % Incomplete | Incorrect\n                    locked(Code, Length, NewButtons)\n            end\n    end.\n```\n\n```erlang\nopen(Code, Length) ->\n    receive\n    after 10_000 -> % Time in milliseconds\n\t    do_lock(),\n\t    locked(Code, Length, [])\n    end.\n\ndo_lock() ->\n    io:format(\"Locked~n\", []).\ndo_unlock() ->\n    io:format(\"Open~n\", []).\n```\n\nThe selective receive in this case causes `open` to implicitly postpone any\nevents to the `locked` state.\n\nA catch-all receive should never be used from a `gen_statem` behaviour\n(or from any `gen_*` behaviour), as the receive statement is within\nthe `gen_*` engine itself. `m:sys`-compatible behaviours must respond to\nsystem messages and therefore do that in their engine receive loop,\npassing non-system messages to the _callback module_. Using a catch-all\nreceive can result in system messages being discarded, which in turn\ncan lead to unexpected behaviour. If a selective receive must be used,\ngreat care should be taken to ensure that only messages pertinent\nto the operation are received. Likewise, a callback must return\nin due time to let the engine receive loop handle system messages,\nor they might time out, also leading to unexpected behaviour.\n\nThe [_transition action_](#transition-actions) `postpone` is\ndesigned to model selective receives. A selective receive implicitly\npostpones any events not yet received, but the `postpone` _transition\naction_ explicitly postpones a single received event.\n\nBoth mechanisms have the same theoretical time and memory complexity,\nbut note that the selective receive language construct has smaller\nconstant factors.\n\nState Enter Actions\n-------------------\n\nSay you have a state machine specification that uses state enter actions.\nAlthough you can code this using inserted events (described in the next\nsection), especially if only one or a few states have state enter actions,\nthis is a perfect use case for the built in\n[_state enter calls_](#state-enter-calls).\n\nYou return a list containing `state_enter` from your\n[`callback_mode/0`](`c:gen_statem:callback_mode/0`) function and the\n`gen_statem` engine will call your _state callback_ once with an event\n`(enter, OldState, ...)` whenever it does a _state change_. Then you\njust need to handle these event-like calls in all states.\n\n```erlang\n...\ninit(Code) ->\n    process_flag(trap_exit, true),\n    Data = #{code => Code, length = length(Code)},\n    {ok, locked, Data}.\n\ncallback_mode() ->\n    [state_functions,state_enter].\n\nlocked(enter, _OldState, Data) ->\n    do_lock(),\n    {keep_state,Data#{buttons => []}};\nlocked(\n  cast, {button,Button},\n  #{code := Code, length := Length, buttons := Buttons} = Data) ->\n...\n    if\n        NewButtons =:= Code -> % Correct\n            {next_state, open, Data};\n...\n\nopen(enter, _OldState, _Data) ->\n    do_unlock(),\n    {keep_state_and_data,\n     [{state_timeout,10_000,lock}]}; % Time in milliseconds\nopen(state_timeout, lock, Data) ->\n    {next_state, locked, Data};\n...\n```\n\nYou can repeat the state enter code by returning one of\n`{repeat_state, ...}`,`{repeat_state_and_data, _}`,\nor `repeat_state_and_data` that otherwise behaves exactly like their\n`keep_state` siblings.  See the type\n[`state_callback_result()`](`t:gen_statem:state_callback_result/2`)\nin the Reference Manual.\n\nInserted Events\n---------------\n\nIt can sometimes be beneficial to be able to generate events to your own\nstate machine.  This can be done with the\n[_transition action_](#transition-actions)\n[`{next_event, EventType, EventContent}`](`t:gen_statem:action/0`).\n\nYou can generate events of any existing [type](`t:gen_statem:action/0`),\nbut the`internal` type can only be generated through action `next_event`.\nHence, it cannot come from an external source, so you can be certain\nthat an `internal` event is an event from your state machine to itself.\n\nOne example for this is to pre-process incoming data, for example decrypting\nchunks or collecting characters up to a line break.\n\nPurists may argue that this should be modeled with a separate state machine\nthat sends pre-processed events to the main state machine.\n\nHowever, for efficiency's sake, the small pre-processing state machine\ncan be integrated into the common event handling of the main state\nmachine. This integration involves using a few state data items\nto dispatch pre-processed events as internal events to the main state\nmachine.\n\nUsing internal events also can make it easier to synchronize the state\nmachines.\n\nA variant of this is to use a [complex state](#complex-state) with\n[one state callback](#one-state-callback), modeling the state\nwith, for example, a tuple `{MainFSMState, SubFSMState}`.\n\nTo illustrate this we make up an example where the buttons instead generate\ndown and up (press and release) events, and the lock responds\nto an up event only after the corresponding down event.\n\n```erlang\n...\n-export([down/1, up/1]).\n...\ndown(Button) ->\n    gen_statem:cast(?NAME, {down,Button}).\n\nup(Button) ->\n    gen_statem:cast(?NAME, {up,Button}).\n\n...\n\nlocked(enter, _OldState, Data) ->\n    do_lock(),\n    {keep_state,Data#{buttons => []}};\nlocked(\n  internal, {button,Button},\n  #{code := Code, length := Length, buttons := Buttons} = Data) ->\n...\n```\n\n```erlang\nhandle_common(cast, {down,Button}, Data) ->\n    {keep_state, Data#{button => Button}};\nhandle_common(cast, {up,Button}, Data) ->\n    case Data of\n        #{button := Button} ->\n            {keep_state,maps:remove(button, Data),\n             [{next_event,internal,{button,Button}}]};\n        #{} ->\n            keep_state_and_data\n    end;\n...\n\nopen(internal, {button,_}, Data) ->\n    {keep_state,Data,[postpone]};\n...\n```\n\nIf you start this program with `code_lock:start([17])` you can unlock with\n`code_lock:down(17), code_lock:up(17).`\n\nExample Revisited\n-----------------\n\nThis section includes the example after most of the mentioned modifications\nand some more using _state enter calls_, which deserves a new state diagram:\n\n```mermaid\n---\ntitle: Code Lock State Diagram Revisited\n---\nstateDiagram-v2\n    state enter_locked < >\n    state enter_open   < >\n    state check_code   < >\n\n    [*] --> enter_locked\n\n    enter_locked --> locked     : * do_lock()\\n* Clear Buttons\n    locked       --> check_code : {button, Button}\\n* Collect Buttons\n    locked       --> locked     : state_timeout\\n* Clear Buttons\n    check_code   --> locked     : Incorrect code\\n* Set state_timeout 30 s\n    check_code   --> enter_open : Correct code\n\n    enter_open --> open         : * do_unlock()\\n* Set state_timeout 10 s\n    open       --> enter_locked : state_timeout\n```\n\nNotice that this state diagram does not specify how to handle a button event\nin the state `open`. So, you need to read in some side notes, that is, here:\nthat unspecified events shall be postponed (handled in some later state).\nAlso, the state diagram does not show that the `code_length/0` call\nmust be handled in every state.","title":"Selective Receive - gen_statem Behaviour","ref":"statem.html#selective-receive"},{"type":"extras","doc":"Using state functions:\n\n```erlang\n-module(code_lock).\n-behaviour(gen_statem).\n-define(NAME, code_lock_2).\n\n-export([start_link/1,stop/0]).\n-export([down/1,up/1,code_length/0]).\n-export([init/1,callback_mode/0,terminate/3]).\n-export([locked/3,open/3]).\n\nstart_link(Code) ->\n    gen_statem:start_link({local,?NAME}, ?MODULE, Code, []).\nstop() ->\n    gen_statem:stop(?NAME).\n\ndown(Button) ->\n    gen_statem:cast(?NAME, {down,Button}).\nup(Button) ->\n    gen_statem:cast(?NAME, {up,Button}).\ncode_length() ->\n    gen_statem:call(?NAME, code_length).\n```\n\n```erlang\ninit(Code) ->\n    process_flag(trap_exit, true),\n    Data = #{code => Code, length => length(Code), buttons => []},\n    {ok, locked, Data}.\n\ncallback_mode() ->\n    [state_functions,state_enter].\n\n-define(HANDLE_COMMON,\n    ?FUNCTION_NAME(T, C, D) -> handle_common(T, C, D)).\n%%\nhandle_common(cast, {down,Button}, Data) ->\n    {keep_state, Data#{button => Button}};\nhandle_common(cast, {up,Button}, Data) ->\n    case Data of\n        #{button := Button} ->\n            {keep_state, maps:remove(button, Data),\n             [{next_event,internal,{button,Button}}]};\n        #{} ->\n            keep_state_and_data\n    end;\nhandle_common({call,From}, code_length, #{code := Code}) ->\n    {keep_state_and_data,\n     [{reply,From,length(Code)}]}.\n```\n\n```erlang\nlocked(enter, _OldState, Data) ->\n    do_lock(),\n    {keep_state, Data#{buttons := []}};\nlocked(state_timeout, button, Data) ->\n    {keep_state, Data#{buttons := []}};\nlocked(\n  internal, {button,Button},\n  #{code := Code, length := Length, buttons := Buttons} = Data) ->\n    NewButtons =\n        if\n            length(Buttons)  \n                Buttons;\n            true ->\n                tl(Buttons)\n        end ++ [Button],\n    if\n        NewButtons =:= Code -> % Correct\n            {next_state, open, Data};\n\ttrue -> % Incomplete | Incorrect\n            {keep_state, Data#{buttons := NewButtons},\n             [{state_timeout,30_000,button}]} % Time in milliseconds\n    end;\n?HANDLE_COMMON.\n```\n\n```erlang\nopen(enter, _OldState, _Data) ->\n    do_unlock(),\n    {keep_state_and_data,\n     [{state_timeout,10_000,lock}]}; % Time in milliseconds\nopen(state_timeout, lock, Data) ->\n    {next_state, locked, Data};\nopen(internal, {button,_}, _) ->\n    {keep_state_and_data, [postpone]};\n?HANDLE_COMMON.\n\ndo_lock() ->\n    io:format(\"Locked~n\", []).\ndo_unlock() ->\n    io:format(\"Open~n\", []).\n\nterminate(_Reason, State, _Data) ->\n    State =/= locked andalso do_lock(),\n    ok.\n```","title":"Callback Mode: state_functions - gen_statem Behaviour","ref":"statem.html#callback-mode-state_functions"},{"type":"extras","doc":"This section describes what to change in the example to use one\n`handle_event/4` function.  The previously used approach to first branch\ndepending on event does not work that well here because of\nthe _state enter calls_, so this example first branches depending on state:\n\n```erlang\n-export([handle_event/4]).\n```\n\n```erlang\ncallback_mode() ->\n    [handle_event_function,state_enter].\n```\n\n```erlang\n%%\n%% State: locked\nhandle_event(enter, _OldState, locked, Data) ->\n    do_lock(),\n    {keep_state, Data#{buttons := []}};\nhandle_event(state_timeout, button, locked, Data) ->\n    {keep_state, Data#{buttons := []}};\nhandle_event(\n  internal, {button,Button}, locked,\n  #{code := Code, length := Length, buttons := Buttons} = Data) ->\n    NewButtons =\n        if\n            length(Buttons)  \n                Buttons;\n            true ->\n                tl(Buttons)\n        end ++ [Button],\n    if\n        NewButtons =:= Code -> % Correct\n            {next_state, open, Data};\n\ttrue -> % Incomplete | Incorrect\n            {keep_state, Data#{buttons := NewButtons},\n             [{state_timeout,30_000,button}]} % Time in milliseconds\n    end;\n```\n\n```erlang\n%%\n%% State: open\nhandle_event(enter, _OldState, open, _Data) ->\n    do_unlock(),\n    {keep_state_and_data,\n     [{state_timeout,10_000,lock}]}; % Time in milliseconds\nhandle_event(state_timeout, lock, open, Data) ->\n    {next_state, locked, Data};\nhandle_event(internal, {button,_}, open, _) ->\n    {keep_state_and_data,[postpone]};\n```\n\n```erlang\n%% Common events\nhandle_event(cast, {down,Button}, _State, Data) ->\n    {keep_state, Data#{button => Button}};\nhandle_event(cast, {up,Button}, _State, Data) ->\n    case Data of\n        #{button := Button} ->\n            {keep_state, maps:remove(button, Data),\n             [{next_event,internal,{button,Button}},\n              {state_timeout,30_000,button}]}; % Time in milliseconds\n        #{} ->\n            keep_state_and_data\n    end;\nhandle_event({call,From}, code_length, _State, #{length := Length}) ->\n    {keep_state_and_data,\n     [{reply,From,Length}]}.\n```\n\nNotice that postponing buttons from the `open` state to the `locked` state\nseems like a strange thing to do for a code lock, but it at least\nillustrates event postponing.\n\nFilter the State\n----------------\n\nThe example servers so far in this chapter print the full internal state\nin the error log, for example, when killed by an exit signal or because of\nan internal error.  The state contains both the code lock code\nand which digits that remain to unlock.\n\nThis state data can be regarded as sensitive, and maybe not what you want\nin the error log because of some unpredictable event.\n\nAnother reason to filter the state can be that the state is too large to print,\nas it fills the error log with uninteresting details.\n\nTo avoid this, you can format the internal state that gets in the error log\nand gets returned from [`sys:get_status/1,2`](`sys:get_status/1`)\nby implementing function\n[`Module:format_status/2`](`c:gen_statem:format_status/2`),\nfor example like this:\n\n```erlang\n...\n-export([init/1,terminate/3,format_status/2]).\n...\n\nformat_status(Opt, [_PDict,State,Data]) ->\n    StateData =\n\t{State,\n\t maps:filter(\n\t   fun (code, _) -> false;\n\t       (_, _) -> true\n\t   end,\n\t   Data)},\n    case Opt of\n\tterminate ->\n\t    StateData;\n\tnormal ->\n\t    [{data,[{\"State\",StateData}]}]\n    end.\n```\n\nIt is not mandatory to implement a\n[`Module:format_status/2`](`c:gen_statem:format_status/2`) function.\nIf you do not, a default implementation is used that does the same\nas this example function without filtering the `Data` term, that is,\n`StateData = {State, Data}`, in this example containing sensitive information.\n\nComplex State\n-------------\n\nThe _callback mode_ [`handle_event_function`](`t:gen_statem:callback_mode/0`)\nenables using a non-atom state as described in section\n[_Callback Modes_](#callback-modes), for example, a complex state term\nlike a tuple.\n\nOne reason to use this is when you have a state item that when changed\nshould cancel the [_state time-out_](#state-time-outs), or one that affects\nthe event handling in combination with postponing events. We will go for\nthe latter and complicate the previous example by introducing\na configurable lock button (this is the state item in question),\nwhich in the `open` state immediately locks the door, and an API function\n`set_lock_button/1` to set the lock button.\n\nSuppose now that we call `set_lock_button` while the door is open,\nand we have already postponed a button event that was the new lock button:\n\n```erlang\n1> code_lock:start_link([a,b,c], x).\n{ok,<0.666.0>}\n2> code_lock:button(a).\nok\n3> code_lock:button(b).\nok\n4> code_lock:button(c).\nok\nOpen\n5> code_lock:button(y).\nok\n6> code_lock:set_lock_button(y).\nx\n% What should happen here?  Immediate lock or nothing?\n```\n\nWe could say that the button was pressed too early so it should not be\nrecognized as the lock button. Or we can make the lock button part of\nthe state so when we then change the lock button in the locked state,\nthe change becomes a _state change_ and all postponed events are retried,\ntherefore the lock is immediately locked\\!\n\nWe define the state as `{StateName, LockButton}`, where `StateName`\nis as before and `LockButton` is the current lock button:\n\n```erlang\n-module(code_lock).\n-behaviour(gen_statem).\n-define(NAME, code_lock_3).\n\n-export([start_link/2,stop/0]).\n-export([button/1,set_lock_button/1]).\n-export([init/1,callback_mode/0,terminate/3]).\n-export([handle_event/4]).\n\nstart_link(Code, LockButton) ->\n    gen_statem:start_link(\n        {local,?NAME}, ?MODULE, {Code,LockButton}, []).\nstop() ->\n    gen_statem:stop(?NAME).\n\nbutton(Button) ->\n    gen_statem:cast(?NAME, {button,Button}).\nset_lock_button(LockButton) ->\n    gen_statem:call(?NAME, {set_lock_button,LockButton}).\n```\n\n```erlang\ninit({Code,LockButton}) ->\n    process_flag(trap_exit, true),\n    Data = #{code => Code, length => length(Code), buttons => []},\n    {ok, {locked,LockButton}, Data}.\n\ncallback_mode() ->\n    [handle_event_function,state_enter].\n\n%% State: locked\nhandle_event(enter, _OldState, {locked,_}, Data) ->\n    do_lock(),\n    {keep_state, Data#{buttons := []}};\nhandle_event(state_timeout, button, {locked,_}, Data) ->\n    {keep_state, Data#{buttons := []}};\nhandle_event(\n  cast, {button,Button}, {locked,LockButton},\n  #{code := Code, length := Length, buttons := Buttons} = Data) ->\n    NewButtons =\n        if\n            length(Buttons)  \n                Buttons;\n            true ->\n                tl(Buttons)\n        end ++ [Button],\n    if\n        NewButtons =:= Code -> % Correct\n            {next_state, {open,LockButton}, Data};\n\ttrue -> % Incomplete | Incorrect\n            {keep_state, Data#{buttons := NewButtons},\n             [{state_timeout,30_000,button}]} % Time in milliseconds\n    end;\n```\n\n```erlang\n%%\n%% State: open\nhandle_event(enter, _OldState, {open,_}, _Data) ->\n    do_unlock(),\n    {keep_state_and_data,\n     [{state_timeout,10_000,lock}]}; % Time in milliseconds\nhandle_event(state_timeout, lock, {open,LockButton}, Data) ->\n    {next_state, {locked,LockButton}, Data};\nhandle_event(cast, {button,LockButton}, {open,LockButton}, Data) ->\n    {next_state, {locked,LockButton}, Data};\nhandle_event(cast, {button,_}, {open,_}, _Data) ->\n    {keep_state_and_data,[postpone]};\n```\n\n```erlang\n%%\n%% Common events\nhandle_event(\n  {call,From}, {set_lock_button,NewLockButton},\n  {StateName,OldLockButton}, Data) ->\n    {next_state, {StateName,NewLockButton}, Data,\n     [{reply,From,OldLockButton}]}.\n```\n\n```erlang\ndo_lock() ->\n    io:format(\"Locked~n\", []).\ndo_unlock() ->\n    io:format(\"Open~n\", []).\n\nterminate(_Reason, State, _Data) ->\n    State =/= locked andalso do_lock(),\n    ok.\n```\n\nHibernation\n-----------\n\nIf you have many servers in one node and they have some state(s) in their\nlifetime in which the servers can be expected to idle for a while, and the\namount of heap memory all these servers need is a problem, then the memory\nfootprint of a server can be minimized by hibernating it through\n`proc_lib:hibernate/3`.\n\n> #### Note {: .info }\n>\n> It is rather costly to hibernate a process; see `erlang:hibernate/3`. It is\n> not something you want to do after every event.\n\nWe can in this example hibernate in the `{open, _}` state,\nbecause what normally occurs in that state is that the _state time-out_\nafter a while triggers a transition to `{locked, _}`:\n\n```erlang\n...\n%%\n%% State: open\nhandle_event(enter, _OldState, {open,_}, _Data) ->\n    do_unlock(),\n    {keep_state_and_data,\n     [{state_timeout,10_000,lock}, % Time in milliseconds\n      hibernate]};\n...\n```\n\nThe atom [`hibernate`](`t:gen_statem:hibernate/0`) in the action list on the\nlast line when entering the `{open, _}` state is the only change. If any event\narrives in the `{open, _},` state, we do not bother to rehibernate,\nso the server stays awake after any event.\n\nTo change that we would need to insert action `hibernate` in more places.\nFor example, the state-independent `set_lock_button` operation\nwould have to use `hibernate` but only in the `{open, _}` state,\nwhich would clutter the code.\n\nAnother not uncommon scenario is to use the\n[_event time-out_](#event-time-outs) to trigger hibernation after a\ncertain time of inactivity. There is also a server start option\n[`{hibernate_after, Timeout}`](`t:gen_statem:enter_loop_opt/0`) for\n[`start/3,4`](`gen_statem:start/3`),\n[`start_link/3,4`](`gen_statem:start_link/3`), or\n[`enter_loop/4,5,6`](`gen_statem:enter_loop/4`) that may be used to\nautomatically hibernate the server.\n\nThis particular server probably does not use heap memory worth hibernating for.\nTo gain anything from hibernation, your server would have to produce\nnon-insignificant garbage during callback execution, for which this example\nserver can serve as a bad example.","title":"Callback Mode: handle_event_function - gen_statem Behaviour","ref":"statem.html#callback-mode-handle_event_function"},{"type":"extras","doc":"<!--\n%CopyrightBegin%\n\nCopyright Ericsson AB 2023-2024. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# gen_event Behaviour\n\n[](){: #gen_event }\n\nIt is recommended to read this section alongside `m:gen_event` in STDLIB.","title":"gen_event Behaviour","ref":"events.html"},{"type":"extras","doc":"In OTP, an _event manager_ is a named object to which events can be sent. An\n_event_ can be, for example, an error, an alarm, or some information that is to\nbe logged.\n\nIn the event manager, zero, one, or many _event handlers_ are installed. When\nthe event manager is notified about an event, the event is processed by all the\ninstalled event handlers. For example, an event manager for handling errors can\nby default have a handler installed that writes error messages to the\nterminal. If the error messages during a certain period are to be saved to a\nfile as well, the user adds another event handler that does this. When logging\nto the file is no longer necessary, this event handler is deleted.\n\nAn event manager is implemented as a process and each event handler is\nimplemented as a callback module.\n\nThe event manager essentially maintains a list of `{Module, State}` pairs, where\neach `Module` is an event handler, and `State` is the internal state of that\nevent handler.","title":"Event Handling Principles - gen_event Behaviour","ref":"events.html#event-handling-principles"},{"type":"extras","doc":"The callback module for the event handler writing error messages to the terminal\ncan look as follows:\n\n```erlang\n-module(terminal_logger).\n-behaviour(gen_event).\n\n-export([init/1, handle_event/2, terminate/2]).\n\ninit(_Args) ->\n    {ok, []}.\n\nhandle_event(ErrorMsg, State) ->\n    io:format(\"***Error*** ~p~n\", [ErrorMsg]),\n    {ok, State}.\n\nterminate(_Args, _State) ->\n    ok.\n```\n\nThe callback module for the event handler writing error messages to a file can\nlook as follows:\n\n```erlang\n-module(file_logger).\n-behaviour(gen_event).\n\n-export([init/1, handle_event/2, terminate/2]).\n\ninit(File) ->\n    {ok, Fd} = file:open(File, read),\n    {ok, Fd}.\n\nhandle_event(ErrorMsg, Fd) ->\n    io:format(Fd, \"***Error*** ~p~n\", [ErrorMsg]),\n    {ok, Fd}.\n\nterminate(_Args, Fd) ->\n    file:close(Fd).\n```\n\nThe code is explained in the next sections.\n\n[](){: #mgr }","title":"Example - gen_event Behaviour","ref":"events.html#example"},{"type":"extras","doc":"To start an event manager for handling errors, as described in the previous\nexample, call the following function:\n\n```text\ngen_event:start_link({local, error_man})\n```\n\n`gen_event:start_link/1` spawns and links to a new event manager process.\n\nThe argument, `{local, error_man}`, specifies the name under which the\nevent manager should be locally registered. The name can also be given\nas `{global, Name}` to register the event manager globally using\n`global:register_name/2`.\n\nIf the name is omitted, the event manager is not registered. Instead its pid\nmust be used.\n\n`gen_event:start_link/1` must be used if the event manager is part of\na supervision tree, meaning that it was started by a supervisor. There\nis another function, `gen_event:start/1`, to start a standalone event\nmanager that is not part of a supervision tree.","title":"Starting an Event Manager - gen_event Behaviour","ref":"events.html#starting-an-event-manager"},{"type":"extras","doc":"The following example shows how to start an event manager and add an event\nhandler to it by using the shell:\n\n```erlang\n1> gen_event:start({local, error_man}).\n{ok,<0.31.0>}\n2> gen_event:add_handler(error_man, terminal_logger, []).\nok\n```\n\nThis function sends a message to the event manager registered as `error_man`,\ntelling it to add the event handler `terminal_logger`. The event manager calls\nthe callback function `terminal_logger:init([])`, where the argument `[]` is the\nthird argument to `add_handler`. `init/1` is expected to return `{ok, State}`,\nwhere `State` is the internal state of the event handler.\n\n```erlang\ninit(_Args) ->\n    {ok, []}.\n```\n\nHere, `init/1` does not need any input data and ignores its argument. For\n`terminal_logger`, the internal state is not used. For `file_logger`, the\ninternal state is used to save the open file descriptor.\n\n```erlang\ninit(File) ->\n    {ok, Fd} = file:open(File, read),\n    {ok, Fd}.\n```","title":"Adding an Event Handler - gen_event Behaviour","ref":"events.html#adding-an-event-handler"},{"type":"extras","doc":"```text\n3> gen_event:notify(error_man, no_reply).\n***Error*** no_reply\nok\n```\n\n`error_man` is the name of the event manager and `no_reply` is the event.\n\nThe event is made into a message and sent to the event manager. When the event\nis received, the event manager calls `handle_event(Event, State)` for each\ninstalled event handler, in the same order as they were added. The function is\nexpected to return a tuple `{ok,State1}`, where `State1` is a new value for the\nstate of the event handler.\n\nIn `terminal_logger`:\n\n```erlang\nhandle_event(ErrorMsg, State) ->\n    io:format(\"***Error*** ~p~n\", [ErrorMsg]),\n    {ok, State}.\n```\n\nIn `file_logger`:\n\n```erlang\nhandle_event(ErrorMsg, Fd) ->\n    io:format(Fd, \"***Error*** ~p~n\", [ErrorMsg]),\n    {ok, Fd}.\n```","title":"Notifying about Events - gen_event Behaviour","ref":"events.html#notifying-about-events"},{"type":"extras","doc":"```erlang\n4> gen_event:delete_handler(error_man, terminal_logger, []).\nok\n```\n\nThis function sends a message to the event manager registered as `error_man`,\ntelling it to delete the event handler `terminal_logger`. The event manager\ncalls the callback function `terminal_logger:terminate([], State)`, where the\nargument `[]` is the third argument to `delete_handler`. `terminate/2` is to be\nthe opposite of `init/1` and do any necessary cleaning up. Its return value is\nignored.\n\nFor `terminal_logger`, no cleaning up is necessary:\n\n```erlang\nterminate(_Args, _State) ->\n    ok.\n```\n\nFor `file_logger`, the file descriptor opened in `init` must be closed:\n\n```erlang\nterminate(_Args, Fd) ->\n    file:close(Fd).\n```","title":"Deleting an Event Handler - gen_event Behaviour","ref":"events.html#deleting-an-event-handler"},{"type":"extras","doc":"When an event manager is stopped, it gives each of the installed event handlers\nthe chance to clean up by calling `terminate/2`, the same way as when deleting a\nhandler.","title":"Stopping - gen_event Behaviour","ref":"events.html#stopping"},{"type":"extras","doc":"If the event manager is part of a supervision tree, no stop function is needed.\nThe event manager is automatically terminated by its supervisor. Exactly how\nthis is done is defined by a [shutdown strategy](sup_princ.md#shutdown) set in\nthe supervisor.","title":"In a Supervision Tree - gen_event Behaviour","ref":"events.html#in-a-supervision-tree"},{"type":"extras","doc":"An event manager can also be stopped by calling:\n\n```erlang\n1> gen_event:stop(error_man).\nok\n```","title":"Standalone Event Managers - gen_event Behaviour","ref":"events.html#standalone-event-managers"},{"type":"extras","doc":"If the `gen_event` process is to be able to receive other messages\nthan events, the callback function `handle_info(Info, State)` must be\nimplemented to handle them. Examples of other messages are exit\nmessages if the event manager is linked to other processes than the\nsupervisor (for example via `gen_event:add_sup_handler/3`) and is\ntrapping exit signals.\n\n```erlang\nhandle_info({'EXIT', Pid, Reason}, State) ->\n    %% Code to handle exits here.\n    ...\n    {noreply, State1}.\n```\n\nThe final function to implement is `code_change/3`:\n\n```erlang\ncode_change(OldVsn, State, Extra) ->\n    %% Code to convert state (and more) during code change.\n    ...\n    {ok, NewState}.\n```","title":"Handling Other Messages - gen_event Behaviour","ref":"events.html#handling-other-messages"},{"type":"extras","doc":"<!--\n%CopyrightBegin%\n\nCopyright Ericsson AB 2023-2024. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# Supervisor Behaviour\n\nIt is recommended to read this section alongside `m:supervisor` in STDLIB.","title":"Supervisor Behaviour","ref":"sup_princ.html"},{"type":"extras","doc":"A supervisor is responsible for starting, stopping, and monitoring its child\nprocesses. The basic idea of a supervisor is that it is to keep its child\nprocesses alive by restarting them when necessary.\n\nWhich child processes to start and monitor is specified by a list of\n[child specifications](sup_princ.md#spec). The child processes are started in\nthe order specified by this list, and are terminated in the reverse order.","title":"Supervision Principles - Supervisor Behaviour","ref":"sup_princ.html#supervision-principles"},{"type":"extras","doc":"The callback module for a supervisor starting the server from\n[gen_server Behaviour](gen_server_concepts.md#ex) can look as follows:\n\n[](){: #ex }\n\n```erlang\n-module(ch_sup).\n-behaviour(supervisor).\n\n-export([start_link/0]).\n-export([init/1]).\n\nstart_link() ->\n    supervisor:start_link(ch_sup, []).\n\ninit(_Args) ->\n    SupFlags = #{strategy => one_for_one, intensity => 1, period => 5},\n    ChildSpecs = [#{id => ch3,\n                    start => {ch3, start_link, []},\n                    restart => permanent,\n                    shutdown => brutal_kill,\n                    type => worker,\n                    modules => [ch3]}],\n    {ok, {SupFlags, ChildSpecs}}.\n```\n\nThe `SupFlags` variable in the return value from `init/1` represents the\n[supervisor flags](sup_princ.md#flags).\n\nThe `ChildSpecs` variable in the return value from `init/1` is a list of\n[child specifications](sup_princ.md#spec).\n\n[](){: #flags }","title":"Example - Supervisor Behaviour","ref":"sup_princ.html#example"},{"type":"extras","doc":"This is the type definition for the supervisor flags:\n\n```erlang\nsup_flags() = #{strategy => strategy(),           % optional\n                intensity => non_neg_integer(),   % optional\n                period => pos_integer(),          % optional\n                auto_shutdown => auto_shutdown()} % optional\n    strategy() = one_for_all\n               | one_for_one\n               | rest_for_one\n               | simple_one_for_one\n    auto_shutdown() = never\n                    | any_significant\n                    | all_significant\n```\n\n- `strategy` specifies the [restart strategy](sup_princ.md#strategy).\n- `intensity` and `period` specify the\n  [maximum restart intensity](sup_princ.md#max_intensity).\n- `auto_shutdown` specifies whether and when a supervisor should\n  [automatically shut itself down](sup_princ.md#automatic-shutdown).\n\n[](){: #strategy }","title":"Supervisor Flags - Supervisor Behaviour","ref":"sup_princ.html#supervisor-flags"},{"type":"extras","doc":"The restart strategy is specified by the `strategy` key in the supervisor flags\nmap returned by the callback function `init`:\n\n```text\nSupFlags = #{strategy => Strategy, ...}\n```\n\nThe `strategy` key is optional in this map. If it is not given, it defaults to\n`one_for_one`.\n\n> #### Note {: .info }\n>\n> For simplicity, the diagrams shown in this section display a setup where all\n> the depicted children are assumed to have a\n> [restart type](sup_princ.md#restart) of `permanent`.","title":"Restart Strategy - Supervisor Behaviour","ref":"sup_princ.html#restart-strategy"},{"type":"extras","doc":"If a child process terminates, only that process is restarted.\n\n```mermaid\n---\ntitle: One For One Supervision\n---\nflowchart TD\n    subgraph Legend\n        direction LR\n        t(( )) ~~~ l1[Terminated Process]\n        p(( )) ~~~ l2[Process Restarted by the Supervisor]\n    end\n\n    subgraph graph[\" \"]\n        s[Supervisor]\n        s --- p1((P1))\n        s --- p2((P2))\n        s --- p3((P3))\n        s --- pn((Pn))\n    end\n\n    classDef term fill:#ff8888,color:black;\n    classDef restarted stroke:#00aa00,stroke-width:3px;\n    classDef legend fill-opacity:0,stroke-width:0px;\n\n    class p2,t term;\n    class p2,p restarted;\n    class l1,l2 legend;\n```","title":"one_for_one - Supervisor Behaviour","ref":"sup_princ.html#one_for_one"},{"type":"extras","doc":"If a child process terminates, all remaining child processes are\nterminated. Subsequently, all child processes, including the\nterminated one, are restarted.\n\n```mermaid\n---\ntitle: One For All Supervision\n---\nflowchart TD\n    subgraph Legend\n        direction LR\n        t(( )) ~~~ l1[Terminated Process]\n        st(( )) ~~~ l2[Process Terminated by the Supervisor]\n        p(( )) ~~~ l3[Process Restarted by the Supervisor]\n        l4[\"Note:\n\n           Processes are terminated right to left\n           Processes are restarted left to right\"]\n\n    end\n\n    subgraph graph[\" \"]\n        s[Supervisor]\n        s --- p1((P1))\n        s --- p2((P2))\n        s --- p3((P3))\n        s --- pn((Pn))\n    end\n\n    classDef term fill:#ff8888,color:black;\n    classDef sterm fill:#ffaa00,color:black;\n    classDef restarted stroke:#00aa00,stroke-width:3px;\n    classDef legend fill-opacity:0,stroke-width:0px;\n\n    class p2,t term;\n    class p1,p3,pn,st sterm;\n    class p1,p2,p3,pn,p restarted;\n    class l1,l2,l3,l4 legend;\n```","title":"one_for_all - Supervisor Behaviour","ref":"sup_princ.html#one_for_all"},{"type":"extras","doc":"If a child process terminates, the child processes after the\nterminated process in start order are terminated. Subsequently, the\nterminated child process and the remaining child processes are\nrestarted.\n\n\n```mermaid\n---\ntitle: Rest For One Supervision\n---\nflowchart TD\n    subgraph Legend\n        direction LR\n        t(( )) ~~~ l1[Terminated Process]\n        st(( )) ~~~ l2[Process Terminated by the Supervisor]\n        p(( )) ~~~ l3[Process Restarted by the Supervisor]\n        l4[\"Note:\n\n           Processes are terminated right to left\n           Processes are restarted left to right\"]\n\n    end\n\n    subgraph graph[\" \"]\n        s[Supervisor]\n        s --- p1((P1))\n        s --- p2((P2))\n        s --- p3((P3))\n        s --- pn((Pn))\n    end\n\n    classDef term fill:#ff8888,color:black;\n    classDef sterm fill:#ffaa00,color:black;\n    classDef restarted stroke:#00aa00,stroke-width:3px;\n    classDef legend fill-opacity:0,stroke-width:0px;\n\n    class p2,t term;\n    class p3,pn,st sterm;\n    class p2,p3,pn,p restarted;\n    class l1,l2,l3,l4 legend;\n```","title":"rest_for_one - Supervisor Behaviour","ref":"sup_princ.html#rest_for_one"},{"type":"extras","doc":"See [simple-one-for-one supervisors](sup_princ.md#simple).\n\n[](){: #max_intensity }","title":"simple_one_for_one - Supervisor Behaviour","ref":"sup_princ.html#simple_one_for_one"},{"type":"extras","doc":"The supervisors have a built-in mechanism to limit the number of restarts which\ncan occur in a given time interval. This is specified by the two keys\n`intensity` and `period` in the supervisor flags map returned by the callback\nfunction `init`:\n\n```text\nSupFlags = #{intensity => MaxR, period => MaxT, ...}\n```\n\nIf more than `MaxR` number of restarts occur in the last `MaxT` seconds, the\nsupervisor terminates all the child processes and then itself. The termination\nreason for the supervisor itself in that case will be `shutdown`.\n\nWhen the supervisor terminates, then the next higher-level supervisor takes some\naction. It either restarts the terminated supervisor or terminates itself.\n\nThe intention of the restart mechanism is to prevent a situation where a process\nrepeatedly dies for the same reason, only to be restarted again.\n\nThe keys `intensity` and `period` are optional in the supervisor flags map. If\nthey are not given, they default to `1` and `5`, respectively.","title":"Maximum Restart Intensity - Supervisor Behaviour","ref":"sup_princ.html#maximum-restart-intensity"},{"type":"extras","doc":"The default values were chosen to be safe for most systems, even with\ndeep supervision hierarchies, but you will probably want to tune the\nsettings for your particular use case.\n\nFirst, the intensity decides how big bursts of restarts you want to tolerate.\nFor example, you might want to accept a burst of at most 5 or 10 attempts, even\nwithin the same second, if it results in a successful restart.\n\nSecond, you need to consider the sustained failure rate, if crashes keep\nhappening but not often enough to make the supervisor give up. If you set\nintensity to 10 and set the period as low as 1, the supervisor will allow child\nprocesses to keep restarting up to 10 times per second, forever, filling your\nlogs with crash reports until someone intervenes manually.\n\nYou should therefore set the period to be long enough that you can accept that\nthe supervisor keeps going at that rate. For example, if an intensity value\nof 5 is chosen, setting the period to 30 seconds will give you at\nmost one restart per 6 seconds for any longer period of time, which means that\nyour logs will not fill up too quickly, and you will have a chance to observe the\nfailures and apply a fix.\n\nThese choices depend a lot on your problem domain. If you do not have real time\nmonitoring and ability to fix problems quickly, for example in an embedded\nsystem, you might want to accept at most one restart per minute before the\nsupervisor should give up and escalate to the next level to try to clear the\nerror automatically. On the other hand, if it is more important that you keep\ntrying even at a high failure rate, you might want a sustained rate of as much\nas 1-2 restarts per second.\n\nAvoiding common mistakes:\n\n- Do not forget to consider the burst rate. If you set intensity to 1 and period\n  to 6, it gives the same sustained error rate as 5/30 or 10/60, but will not\n  allow even 2 restart attempts in quick succession. This is probably not what\n  you wanted.\n- Do not set the period to a very high value if you want to tolerate bursts. If\n  you set intensity to 5 and period to 3600 (one hour), the supervisor will\n  allow a short burst of 5 restarts, but then gives up if it sees another single\n  restart almost an hour later. You probably want to regard those crashes as\n  separate incidents, so setting the period to 5 or 10 minutes will be more\n  reasonable.\n- If your application has multiple levels of supervision, do not set\n  the restart intensities to the same values on all levels. Keep in mind that\n  the total number of restarts (before the top level supervisor gives up and\n  terminates the application) will be the product of the intensity values of all\n  the supervisors above the failing child process.\n\n  For example, if the top level allows 10 restarts, and the next level also\n  allows 10, a crashing child below that level will be restarted 100 times,\n  which is probably excessive. Allowing at most 3 restarts for the top level\n  supervisor might be a better choice in this case.","title":"Tuning the intensity and period - Supervisor Behaviour","ref":"sup_princ.html#tuning-the-intensity-and-period"},{"type":"extras","doc":"A supervisor can be configured to automatically shut itself down when\n[significant children](sup_princ.md#significant_child) terminate.\n\nThis is useful when a supervisor represents a work unit of cooperating children,\nas opposed to independent workers. When the work unit has finished its work,\nthat is, when any or all significant child processes have terminated, the\nsupervisor should then shut down by terminating all remaining child processes in\nreverse start order according to the respective shutdown specifications, and\nthen itself.\n\nAutomatic shutdown is specified by the `auto_shutdown` key in the supervisor\nflags map returned by the callback function `init`:\n\n```text\nSupFlags = #{auto_shutdown => AutoShutdown, ...}\n```\n\nThe `auto_shutdown` key is optional in this map. If it is not given, it defaults\nto `never`.\n\n> #### Note {: .info }\n>\n> The automatic shutdown facility only applies when significant children\n> terminate by themselves, not when their termination was caused by\n> the supervisor. Specifically, neither the termination of a child as a\n> consequence of a sibling's termination in the `one_for_all` or `rest_for_one`\n> strategies nor the manual termination of a child by\n> `supervisor:terminate_child/2` will trigger an automatic shutdown.","title":"Automatic Shutdown - Supervisor Behaviour","ref":"sup_princ.html#automatic-shutdown"},{"type":"extras","doc":"Automatic shutdown is disabled.\n\nIn this mode, specifying significant children is not accepted. If the\nchild specs returned from `init` contain significant children, the\nsupervisor will refuse to start. Attempts to start significant\nchildren dynamically will be rejected.\n\nThis is the default setting.","title":"never - Supervisor Behaviour","ref":"sup_princ.html#never"},{"type":"extras","doc":"The supervisor will automatically shut itself down when _any_ significant child\nterminates, that is, when a transient significant child terminates normally or\nwhen a temporary significant child terminates normally or abnormally.","title":"any_significant - Supervisor Behaviour","ref":"sup_princ.html#any_significant"},{"type":"extras","doc":"The supervisor will automatically shut itself down when _all_ significant\nchildren have terminated, that is, when the _last active_ significant child\nterminates. The same rules as for `any_significant` apply.\n\n> #### Warning {: .warning }\n>\n> The automatic shutdown feature was introduced in OTP 24.0, but applications\n> using this feature will also compile and run with older OTP versions.\n>\n> However, such applications, when compiled with an OTP version that predates\n> the appearance of the automatic shutdown feature, will leak processes because\n> the automatic shutdowns they rely on will not happen.\n>\n> It is up to implementors to take proper precautions if they expect that their\n> applications may be compiled with older OTP versions.\n\n> #### Warning {: .warning }\n>\n> Top supervisors of [Applications](applications.md) should not be configured\n> for automatic shutdown, because when the top supervisor exits, the application\n> terminates. If the application is `permanent`, all other applications and the\n> runtime system are terminated as well.\n\n> #### Warning {: .warning }\n>\n> Supervisors configured for automatic shutdown should not be made\n> [permanent](sup_princ.md#restart) children of their respective parent\n> supervisors, as they would be restarted immediately after having automatically\n> shut down, only to shut down automatically again after a while, and may thus\n> exhaust the [Maximum Restart Intensity](sup_princ.md#max_intensity) of the\n> parent supervisor.\n\n[](){: #spec }","title":"all_significant - Supervisor Behaviour","ref":"sup_princ.html#all_significant"},{"type":"extras","doc":"The type definition for a child specification is as follows:\n\n```erlang\nchild_spec() = #{id => child_id(),             % mandatory\n                 start => mfargs(),            % mandatory\n                 restart => restart(),         % optional\n                 significant => significant(), % optional\n                 shutdown => shutdown(),       % optional\n                 type => worker(),             % optional\n                 modules => modules()}         % optional\n    child_id() = term()\n    mfargs() = {M :: module(), F :: atom(), A :: [term()]}\n    modules() = [module()] | dynamic\n    restart() = permanent | transient | temporary\n    significant() = boolean()\n    shutdown() = brutal_kill | timeout()\n    worker() = worker | supervisor\n```\n\n- `id` is used to identify the child specification internally by the supervisor.\n\n  The `id` key is mandatory.\n\n  Note that this identifier occasionally has been called \"name\". As far as\n  possible, the terms \"identifier\" or \"id\" are now used but in order to keep\n  backwards compatibility, some occurrences of \"name\" can still be found, for\n  example in error messages.\n\n- `start` defines the function call used to start the child process. It is a\n  module-function-arguments tuple used as [`apply(M, F, A)`](`apply/3`).\n\n  It is to be (or result in) a call to any of the following:\n\n  - [`supervisor:start_link/2,3`](`supervisor:start_link/3`)\n  - [`gen_server:start_link/3,4`](`gen_server:start_link/4`)\n  - [`gen_statem:start_link/3,4`](`gen_statem:start_link/4`)\n  - [`gen_event:start_link/0,1,2`](`gen_event:start_link/2`)\n  - A function compliant with these functions. For details, see\n    `m:supervisor`.\n\n  The `start` key is mandatory.\n\n- [](){: #restart } `restart` defines when a terminated child process is to be\n  restarted.\n\n  - A `permanent` child process is always restarted.\n  - A `temporary` child process is never restarted (not even when the supervisor\n    restart strategy is `rest_for_one` or `one_for_all` and a sibling death\n    causes the temporary process to be terminated).\n  - A `transient` child process is restarted only if it terminates abnormally,\n    that is, with an exit reason other than `normal`, `shutdown`, or\n    `{shutdown,Term}`.\n\n  The `restart` key is optional. If it is not given, the default value\n  `permanent` will be used.\n\n- [](){: #significant_child } `significant` defines whether a child is considered\n  significant for [automatic self-shutdown](sup_princ.md#automatic-shutdown) of\n  the supervisor.\n\n  It is invalid to set this option to `true` for a child with\n  [restart type](sup_princ.md#restart) `permanent` or in a supervisor with\n  [auto_shutdown](sup_princ.md#automatic-shutdown) set to `never`.\n\n- [](){: #shutdown } `shutdown` defines how a child process is to be terminated.\n\n  - `brutal_kill` means that the child process is unconditionally terminated\n    using [`exit(Child, kill)`](`exit/2`).\n  - An integer time-out value means that the supervisor tells the child process\n    to terminate by calling [`exit(Child, shutdown)`](`exit/2`) and then waits\n    for an exit signal back. If no exit signal is received within the specified\n    time, the child process is unconditionally terminated using\n    [`exit(Child, kill)`](`exit/2`).\n  - If the child process is another supervisor, it should be set to `infinity`\n    to give the subtree enough time to shut down. It is also allowed to set it\n    to `infinity` if the child process is a worker.\n\n  > #### Warning {: .warning }\n  >\n  > Setting the shutdown time to anything other than `infinity` for a child of\n  > type `supervisor` can cause a race condition where the child in question\n  > unlinks its own children, but fails to terminate them before it is killed.\n  >\n  > Be careful when setting the shutdown time to `infinity` when the child\n  > process is a worker. Because, in this situation, the termination of the\n  > supervision tree depends on the child process; it must be implemented in a\n  > safe way and its cleanup procedure must always return.\n\n  The `shutdown` key is optional. If it is not given, and the child is of type\n  `worker`, the default value `5000` will be used; if the child is of type\n  `supervisor`, the default value `infinity` will be used.\n\n- `type` specifies whether the child process is a supervisor or a worker.\n\n  The `type` key is optional. If it is not given, the default value `worker`\n  will be used.\n\n- `modules` has to be a list consisting of a single element. The value\n  of that element depends on the behaviour of the process:\n\n  * If the child process is a `gen_event`, the element has to be the atom\n    `dynamic`.\n  * Otherwise, the element should be `Module`, where `Module` is the\n    name of the callback module.\n\n  This information is used by the release handler during upgrades and\n  downgrades; see [Release Handling](release_handling.md).\n\n  The `modules` key is optional. If it is not given, it defaults to `[M]`, where\n  `M` comes from the child's start `{M,F,A}`.\n\n_Example:_ The child specification to start the server `ch3` in the previous\nexample look as follows:\n\n```erlang\n#{id => ch3,\n  start => {ch3, start_link, []},\n  restart => permanent,\n  shutdown => brutal_kill,\n  type => worker,\n  modules => [ch3]}\n```\n\nor simplified, relying on the default values:\n\n```text\n#{id => ch3,\n  start => {ch3, start_link, []},\n  shutdown => brutal_kill}\n```\n\nExample: A child specification to start the event manager from the chapter about\n[gen_event](events.md#mgr):\n\n```erlang\n#{id => error_man,\n  start => {gen_event, start_link, [{local, error_man}]},\n  modules => dynamic}\n```\n\nBoth server and event manager are registered processes which can be expected to\nbe always accessible. Thus they are specified to be `permanent`.\n\n`ch3` does not need to do any cleaning up before termination. Thus, no shutdown\ntime is needed, but `brutal_kill` is sufficient. `error_man` can need some time\nfor the event handlers to clean up, thus the shutdown time is set to 5000 ms\n(which is the default value).\n\nExample: A child specification to start another supervisor:\n\n```erlang\n#{id => sup,\n  start => {sup, start_link, []},\n  restart => transient,\n  type => supervisor} % will cause default shutdown=>infinity\n```\n\n[](){: #super_tree }","title":"Child Specification - Supervisor Behaviour","ref":"sup_princ.html#child-specification"},{"type":"extras","doc":"In the previous example, the supervisor is started by calling\n`ch_sup:start_link()`:\n\n```erlang\nstart_link() ->\n    supervisor:start_link(ch_sup, []).\n```\n\n`ch_sup:start_link` calls function `supervisor:start_link/2`, which spawns and\nlinks to a new process, a supervisor.\n\n- The first argument, `ch_sup`, is the name of the callback module, that is, the\n  module where the `init` callback function is located.\n- The second argument, `[]`, is a term that is passed as is to the callback\n  function `init`. Here, `init` does not need any data and ignores the argument.\n\nIn this case, the supervisor is not registered. Instead its pid must be used. A\nname can be specified by calling\n[`supervisor:start_link({local, Name}, Module, Args)`](`supervisor:start_link/3`)\nor\n[`supervisor:start_link({global, Name}, Module, Args)`](`supervisor:start_link/3`).\n\nThe new supervisor process calls the callback function `ch_sup:init([])`. `init`\nhas to return `{ok, {SupFlags, ChildSpecs}}`:\n\n```erlang\ninit(_Args) ->\n    SupFlags = #{},\n    ChildSpecs = [#{id => ch3,\n                    start => {ch3, start_link, []},\n                    shutdown => brutal_kill}],\n    {ok, {SupFlags, ChildSpecs}}.\n```\n\nSubsequently, the supervisor starts its child processes according to the child\nspecifications in the start specification. In this case there is a single child\nprocess, called `ch3`.\n\n`supervisor:start_link/3` is synchronous. It does not return until all child\nprocesses have been started.","title":"Starting a Supervisor - Supervisor Behaviour","ref":"sup_princ.html#starting-a-supervisor"},{"type":"extras","doc":"In addition to the static supervision tree as defined by the child\nspecifications, dynamic child processes can be added to an existing\nsupervisor by calling [`supervisor:start_child(Sup,\nChildSpec)`](`supervisor:start_child/2`).\n\n`Sup` is the pid, or name, of the supervisor. `ChildSpec` is a\n[child specification](sup_princ.md#spec).\n\nChild processes added using `start_child/2` behave in the same way as the other\nchild processes, with one important exception: if a supervisor dies and is\nrecreated, then all child processes that were dynamically added to the\nsupervisor are lost.","title":"Adding a Child Process - Supervisor Behaviour","ref":"sup_princ.html#adding-a-child-process"},{"type":"extras","doc":"Any child process, static or dynamic, can be stopped in accordance with the\nshutdown specification by calling\n[`supervisor:terminate_child(Sup, Id)`](`supervisor:terminate_child/2`).\n\nStopping a [significant child](sup_princ.md#significant_child) of a supervisor\nconfigured for [automatic shutdown](sup_princ.md#automatic-shutdown) will not\ntrigger an automatic shutdown.\n\nThe child specification for a stopped child process is deleted by\ncalling [`supervisor:delete_child(Sup, Id)`](`supervisor:delete_child/2`).\n\n`Sup` is the pid, or name, of the supervisor. `Id` is the value associated with\nthe `id` key in the [child specification](sup_princ.md#spec).\n\nAs with dynamically added child processes, the effects of deleting a static\nchild process are lost if the supervisor itself restarts.\n\n[](){: #simple }","title":"Stopping a Child Process - Supervisor Behaviour","ref":"sup_princ.html#stopping-a-child-process"},{"type":"extras","doc":"A supervisor with restart strategy `simple_one_for_one` is a simplified\n`one_for_one` supervisor, where all child processes are dynamically added\ninstances of the same process.\n\nThe following is an example of a callback module for a `simple_one_for_one`\nsupervisor:\n\n```erlang\n-module(simple_sup).\n-behaviour(supervisor).\n\n-export([start_link/0]).\n-export([init/1]).\n\nstart_link() ->\n    supervisor:start_link(simple_sup, []).\n\ninit(_Args) ->\n    SupFlags = #{strategy => simple_one_for_one,\n                 intensity => 0,\n                 period => 1},\n    ChildSpecs = [#{id => call,\n                    start => {call, start_link, []},\n                    shutdown => brutal_kill}],\n    {ok, {SupFlags, ChildSpecs}}.\n```\n\nWhen started, the supervisor does not start any child\nprocesses. Instead, all child processes need to be added dynamically by\ncalling [`supervisor:start_child(Sup, List)`](`supervisor:start_child/2`).\n\n`Sup` is the pid, or name, of the supervisor. `List` is an arbitrary list of\nterms, which are added to the list of arguments specified in the child\nspecification. If the start function is specified as `{M, F, A}`, the child\nprocess is started by calling [`apply(M, F, A++List)`](`apply/3`).\n\nFor example, adding a child to `simple_sup` above:\n\n```text\nsupervisor:start_child(Pid, [id1])\n```\n\nThe result is that the child process is started by calling\n[`apply(call, start_link, []++[id1])`](`apply/3`), or actually:\n\n```text\ncall:start_link(id1)\n```\n\nA child under a `simple_one_for_one` supervisor can be terminated with the\nfollowing:\n\n```text\nsupervisor:terminate_child(Sup, Pid)\n```\n\n`Sup` is the pid, or name, of the supervisor and `Pid` is the pid of the child.\n\nBecause a `simple_one_for_one` supervisor can have many children, it shuts them\nall down asynchronously. This means that the children will do their cleanup in\nparallel and therefore the order in which they are stopped is not defined.\n\nStarting, restarting, and manually terminating children are synchronous operations\nwhich are executed in the context of the supervisor process. This means\nthat the supervisor process will be blocked while it is performing any of those\noperations. Child processes are responsible for keeping their start and shutdown\nphases as short as possible.","title":"Simplified one_for_one Supervisors - Supervisor Behaviour","ref":"sup_princ.html#simplified-one_for_one-supervisors"},{"type":"extras","doc":"Since the supervisor is part of a supervision tree, it is\nautomatically terminated by its supervisor. When asked to shut down, a\nsupervisor terminates all child processes in reverse start order\naccording to the respective shutdown specifications before terminating\nitself.\n\nIf the supervisor is configured for\n[automatic shutdown](sup_princ.md#automatic-shutdown) on termination of any or\nall [significant children](sup_princ.md#significant_child), it will shut down\nitself when any or the last active significant child terminates, respectively.\nThe shutdown itself follows the same procedure as described above, that is, the\nsupervisor terminates all remaining child processes in reverse start order\nbefore terminating itself.","title":"Stopping - Supervisor Behaviour","ref":"sup_princ.html#stopping"},{"type":"extras","doc":"For several reasons, a supervisor should not be stopped manually via\n`supervisor:terminate_child/2` from a child located in its own tree.\n\n1. The child process will have to know the pids or registered names not only of\n   the supervisor it wants to stop, but also that of the supervisor's parent\n   supervisor, in order to tell the parent supervisor to stop the supervisor it\n   wants to stop. This can make restructuring a supervision tree difficult.\n1. `supervisor:terminate_child/2` is a blocking call that will only return after\n   the parent supervisor has finished the shutdown of the supervisor that should\n   be stopped. Unless the call is made from a spawned process, this will result\n   in a deadlock, as the supervisor waits for the child to exit as part of its\n   shutdown procedure, whereas the child waits for the supervisor to shut down.\n   If the child is trapping exits, this deadlock will last until the\n   [shutdown](sup_princ.md#shutdown) timeout for the child expires.\n1. When a supervisor is stopping a child, it will wait for the shutdown to\n   complete before accepting other calls, that is, the supervisor will be\n   unresponsive until then. If the termination takes some time to complete,\n   especially when the considerations outlined in the previous point were not\n   taken into account carefully, said supervisor might become unresponsive for a\n   long time.\n\nInstead, it is generally a better approach to rely on\n[Automatic Shutdown](sup_princ.md#automatic-shutdown).\n\n1. A child process does not need to know anything about its supervisor and its\n   respective parent, not even that it is part of a supervision tree in the\n   first place. It is instead only the supervisor which hosts the child who must\n   know which of its children are [significant](sup_princ.md#significant_child)\n   ones, and when to shut itself down.\n1. A child process does not need to do anything special to shut down the work\n   unit it is part of. All it needs to do is terminate normally when it has\n   finished the task it was started for.\n1. A supervisor that is automatically shutting itself down will perform the\n   required shutdown steps fully independent of its parent supervisor. The\n   parent supervisor will only notice that its child supervisor has terminated\n   in the end. As the parent supervisor is not involved in the shutdown process,\n   it will not be blocked.","title":"Manual stopping versus Automatic Shutdown - Supervisor Behaviour","ref":"sup_princ.html#manual-stopping-versus-automatic-shutdown"},{"type":"extras","doc":"<!--\n%CopyrightBegin%\n\nCopyright Ericsson AB 2023-2024. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# sys and proc_lib\n\n[](){: #sys-and-proc_lib }\n\nThe `m:sys` module has functions for simple debugging of processes implemented\nusing behaviours. It also has functions that, together with functions in the\n`proc_lib` module, can be used to implement a _special process_ that complies to\nthe OTP design principles without using a standard behaviour. These functions\ncan also be used to implement user-defined (non-standard) behaviours.\n\nBoth `m:sys` and `m:proc_lib` belong to the STDLIB application.","title":"sys and proc_lib","ref":"spec_proc.html"},{"type":"extras","doc":"The `m:sys` module has functions for simple debugging of processes implemented\nusing behaviours. The `code_lock` example from\n[gen_statem Behaviour](statem.md#example) is used to illustrate this:\n\n```erlang\nErlang/OTP 27 [erts-15.0] [64-bit] [smp:8:8] [ds:8:8:10] [async-threads:1] [jit]\n\nEshell V15.0 (press Ctrl+G to abort, type help(). for help)\n1> code_lock:start_link([1,2,3,4]).\nLock\n{ok,<0.90.0>}\n2> sys:statistics(code_lock, true).\nok\n3> sys:trace(code_lock, true).\nok\n4> code_lock:button(1).\n*DBG* code_lock receive cast {button,1} in state locked\nok\n*DBG* code_lock consume cast {button,1} in state locked\n5> code_lock:button(2).\n*DBG* code_lock receive cast {button,2} in state locked\nok\n*DBG* code_lock consume cast {button,2} in state locked\n6> code_lock:button(3).\n*DBG* code_lock receive cast {button,3} in state locked\nok\n*DBG* code_lock consume cast {button,3} in state locked\n7> code_lock:button(4).\n*DBG* code_lock receive cast {button,4} in state locked\nok\nUnlock\n*DBG* code_lock consume cast {button,4} in state locked => open\n*DBG* code_lock start_timer {state_timeout,10000,lock,[]} in state open\n*DBG* code_lock receive state_timeout lock in state open\nLock\n*DBG* code_lock consume state_timeout lock in state open => locked\n8> sys:statistics(code_lock, get).\n{ok,[{start_time,{{2024,5,3},{8,11,1}}},\n     {current_time,{{2024,5,3},{8,11,48}}},\n     {reductions,4098},\n     {messages_in,5},\n     {messages_out,0}]}\n9> sys:statistics(code_lock, false).\nok\n10> sys:trace(code_lock, false).\nok\n11> sys:get_status(code_lock).\n{status,<0.90.0>,\n        {module,gen_statem},\n        [[{'$initial_call',{code_lock,init,1}},\n          {'$ancestors',[<0.88.0>,<0.87.0>,<0.70.0>,<0.65.0>,<0.69.0>,\n                         <0.64.0>,kernel_sup,<0.47.0>]}],\n         running,<0.88.0>,[],\n         [{header,\"Status for state machine code_lock\"},\n          {data,[{\"Status\",running},\n                 {\"Parent\",<0.88.0>},\n                 {\"Modules\",[code_lock]},\n                 {\"Time-outs\",{0,[]}},\n                 {\"Logged Events\",[]},\n                 {\"Postponed\",[]}]},\n          {data,[{\"State\",\n                  {locked,#{code => [1,2,3,4],\n                            length => 4,buttons => []}}}]}]]}\n```","title":"Simple Debugging - sys and proc_lib","ref":"spec_proc.html#simple-debugging"},{"type":"extras","doc":"This section describes how to write a process that complies to the OTP design\nprinciples, without using a standard behaviour. Such a process is to:\n\n- Be started in a way that makes the process fit into a supervision tree\n- Support the `sys` [debug facilities](spec_proc.md#debug)\n- Take care of [system messages](spec_proc.md#msg).\n\nSystem messages are messages with a special meaning, used in the supervision\ntree. Typical system messages are requests for trace output, and requests to\nsuspend or resume process execution (used during release handling). Processes\nimplemented using standard behaviours automatically understand these messages.","title":"Special Processes - sys and proc_lib","ref":"spec_proc.html#special-processes"},{"type":"extras","doc":"Here follows the simple server from\n[Overview](design_principles.md#ch1),\nimplemented using `sys` and `proc_lib` to fit into a supervision tree:\n\n```erlang\n-module(ch4).\n-export([start_link/0]).\n-export([alloc/0, free/1]).\n-export([init/1]).\n-export([system_continue/3, system_terminate/4,\n         write_debug/3,\n         system_get_state/1, system_replace_state/2]).\n\nstart_link() ->\n    proc_lib:start_link(ch4, init, [self()]).\n\nalloc() ->\n    ch4 ! {self(), alloc},\n    receive\n        {ch4, Res} ->\n            Res\n    end.\n\nfree(Ch) ->\n    ch4 ! {free, Ch},\n    ok.\n\ninit(Parent) ->\n    register(ch4, self()),\n    Chs = channels(),\n    Deb = sys:debug_options([]),\n    proc_lib:init_ack(Parent, {ok, self()}),\n    loop(Chs, Parent, Deb).\n\nloop(Chs, Parent, Deb) ->\n    receive\n        {From, alloc} ->\n            Deb2 = sys:handle_debug(Deb, fun ch4:write_debug/3,\n                                    ch4, {in, alloc, From}),\n            {Ch, Chs2} = alloc(Chs),\n            From ! {ch4, Ch},\n            Deb3 = sys:handle_debug(Deb2, fun ch4:write_debug/3,\n                                    ch4, {out, {ch4, Ch}, From}),\n            loop(Chs2, Parent, Deb3);\n        {free, Ch} ->\n            Deb2 = sys:handle_debug(Deb, fun ch4:write_debug/3,\n                                    ch4, {in, {free, Ch}}),\n            Chs2 = free(Ch, Chs),\n            loop(Chs2, Parent, Deb2);\n\n        {system, From, Request} ->\n            sys:handle_system_msg(Request, From, Parent,\n                                  ch4, Deb, Chs)\n    end.\n\nsystem_continue(Parent, Deb, Chs) ->\n    loop(Chs, Parent, Deb).\n\nsystem_terminate(Reason, _Parent, _Deb, _Chs) ->\n    exit(Reason).\n\nsystem_get_state(Chs) ->\n    {ok, Chs}.\n\nsystem_replace_state(StateFun, Chs) ->\n    NChs = StateFun(Chs),\n    {ok, NChs, NChs}.\n\nwrite_debug(Dev, Event, Name) ->\n    io:format(Dev, \"~p event = ~p~n\", [Name, Event]).\n```\n\nAs it is not relevant to the example, the channel handling functions have been\nomitted. To compile this example, the\n[implementation of channel handling](design_principles.md#channels-implementation)\nneeds to be added to the module.\n\n{: #ex }\n\nHere is an example showing how the debugging functions in the `sys`\nmodule can be used for `ch4`:\n\n```erlang\n% erl\nErlang/OTP 27 [erts-15.0] [64-bit] [smp:8:8] [ds:8:8:10] [async-threads:1] [jit]\n\nEshell V15.0 (press Ctrl+G to abort, type help(). for help)\n1> ch4:start_link().\n{ok,<0.90.0>}\n2> sys:statistics(ch4, true).\nok\n3> sys:trace(ch4, true).\nok\n4> ch4:alloc().\nch4 event = {in,alloc,<0.88.0>}\nch4 event = {out,{ch4,1},<0.88.0>}\n1\n5> ch4:free(ch1).\nch4 event = {in,{free,ch1}}\nok\n6> sys:statistics(ch4, get).\n{ok,[{start_time,{{2024,5,3},{8,26,13}}},\n     {current_time,{{2024,5,3},{8,26,49}}},\n     {reductions,202},\n     {messages_in,2},\n     {messages_out,1}]}\n7> sys:statistics(ch4, false).\nok\n8> sys:trace(ch4, false).\nok\n9> sys:get_status(ch4).\n{status,<0.90.0>,\n        {module,ch4},\n        [[{'$initial_call',{ch4,init,1}},\n          {'$ancestors',[<0.88.0>,<0.87.0>,<0.70.0>,<0.65.0>,<0.69.0>,\n                         <0.64.0>,kernel_sup,<0.47.0>]}],\n         running,<0.88.0>,[],\n         {[1],[2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19|...]}]}\n```","title":"Example - sys and proc_lib","ref":"spec_proc.html#example"},{"type":"extras","doc":"A function in the `m:proc_lib` module is to be used to start the process. Several\nfunctions are available, for example,\n[`proc_lib:spawn_link/3,4`](`proc_lib:spawn_link/4`)\nfor asynchronous start and\n[`proc_lib:start_link/3,4,5`](`proc_lib:start_link/5`) for synchronous start.\n\nInformation necessary for a process within a supervision tree, such as\ndetails on ancestors and the initial call, is stored when a process\nis started through one of these functions.\n\nIf the process terminates with a reason other than `normal` or `shutdown`, a\ncrash report is generated. For more information about the crash report, see\n[Logging](`e:kernel:logger_chapter.md`) in Kernel User's Guide.\n\nIn the example, synchronous start is used. The process starts by calling\n`ch4:start_link()`:\n\n```erlang\nstart_link() ->\n    proc_lib:start_link(ch4, init, [self()]).\n```\n\n`ch4:start_link/0` calls `proc_lib:start_link/3`, which takes a module\nname, a function name, and an argument list as arguments. It then\nspawns a new process and establishes a link. The new process starts\nby executing the given function, here `ch4:init(Pid)`, where `Pid` is\nthe pid of the parent process (obtained by the call to\n[`self()`](`erlang:self/0`) in the call to `proc_lib:start_link/3`).\n\nAll initialization, including name registration, is done in `init/1`. The new\nprocess has to acknowledge that it has been started to the parent:\n\n```erlang\ninit(Parent) ->\n    ...\n    proc_lib:init_ack(Parent, {ok, self()}),\n    loop(...).\n```\n\n`proc_lib:start_link/3` is synchronous and does not return until\n[`proc_lib:init_ack/1,2`](`proc_lib:init_ack/2`) or\n[`proc_lib:init_fail/2,3`](`proc_lib:init_fail/3`) has been called,\nor the process has exited.\n\n[](){: #debug }","title":"Starting the Process - sys and proc_lib","ref":"spec_proc.html#starting-the-process"},{"type":"extras","doc":"To support the debug facilities in `sys`, a _debug structure_ is needed. The\n`Deb` term is initialized using `sys:debug_options/1`:\n\n```erlang\ninit(Parent) ->\n    ...\n    Deb = sys:debug_options([]),\n    ...\n    loop(Chs, Parent, Deb).\n```\n\n`sys:debug_options/1` takes a list of options. Given an empty list as in this\nexample means that debugging is initially disabled. For information about the\npossible options, see `m:sys` in STDLIB.\n\nFor each _system event_ to be logged or traced, the following function\nis to be called:\n\n```erlang\nsys:handle_debug(Deb, Func, Info, Event) => Deb1\n```\n\nThe arguments have the follow meaning:\n\n- `Deb` is the debug structure as returned from `sys:debug_options/1`.\n- `Func` is a fun specifying a (user-defined) function used to format trace\n  output. For each system event, the format function is called as\n  `Func(Dev, Event, Info)`, where:\n  - `Dev` is the I/O device to which the output is to be printed. See `m:io`\n    in STDLIB.\n  - `Event` and `Info` are passed as-is from the call to `sys:handle_debug/4`.\n- `Info` is used to pass more information to `Func`. It can be any term, and it\n  is passed as-is.\n- `Event` is the system event. It is up to the user to define what a system\n  event is and how it is to be represented. Typically, at least incoming and\n  outgoing messages are considered system events and represented by the tuples\n  `{in,Msg[,From]}` and `{out,Msg,To[,State]}`, respectively.\n\n`sys:handle_debug/4` returns an updated debug structure `Deb1`.\n\nIn the example, `sys:handle_debug/4` is called for each incoming and\noutgoing message. The format function `Func` is the function\n`ch4:write_debug/3`, which prints the message using `io:format/3`.\n\n```erlang\nloop(Chs, Parent, Deb) ->\n    receive\n        {From, alloc} ->\n            Deb2 = sys:handle_debug(Deb, fun ch4:write_debug/3,\n                                    ch4, {in, alloc, From}),\n            {Ch, Chs2} = alloc(Chs),\n            From ! {ch4, Ch},\n            Deb3 = sys:handle_debug(Deb2, fun ch4:write_debug/3,\n                                    ch4, {out, {ch4, Ch}, From}),\n            loop(Chs2, Parent, Deb3);\n        {free, Ch} ->\n            Deb2 = sys:handle_debug(Deb, fun ch4:write_debug/3,\n                                    ch4, {in, {free, Ch}}),\n            Chs2 = free(Ch, Chs),\n            loop(Chs2, Parent, Deb2);\n        ...\n    end.\n\nwrite_debug(Dev, Event, Name) ->\n    io:format(Dev, \"~p event = ~p~n\", [Name, Event]).\n```\n\n[](){: #msg }","title":"Debugging - sys and proc_lib","ref":"spec_proc.html#debugging"},{"type":"extras","doc":"_System messages_ are received as:\n\n```text\n{system, From, Request}\n```\n\nThe content and meaning of these messages are not to be interpreted by the\nprocess. Instead the following function is to be called:\n\n```erlang\nsys:handle_system_msg(Request, From, Parent, Module, Deb, State)\n```\n\nThe arguments have the following meaning:\n\n- `Request` and `From` from the received system message are to be\n  passed as-is to the call to `sys:handle_system_msg/6`.\n- `Parent` is the pid of the parent process.\n- `Module` is the name of the module implementing the speciall process.\n- `Deb` is the debug structure.\n- `State` is a term describing the internal state and is passed on to\n  `Module:system_continue/3`, `Module:system_terminate/4`/\n  `Module:system_get_state/1`, and `Module:system_replace_state/2`.\n\n`sys:handle_system_msg/6` does not return. It handles the system\nmessage and *eventually* calls either of the following functions:\n\n* `Module:system_continue(Parent, Deb, State)` - if process execution is to\n  continue.\n\n* `Module:system_terminate(Reason, Parent, Deb, State)` - if the\n  process is to terminate.\n\nWhile handling the system message, `sys:handle_system_msg/6` can call\none of the following functions:\n\n* `Module:system_get_state(State)` - if the process is to return its state.\n\n* `Module:system_replace_state(StateFun, State)` - if the process is\n  to replace its state using the fun `StateFun` fun. See `sys:replace_state/3`\n  for more information.\n\n* `system_code_change(Misc, Module, OldVsn, Extra)` - if the process is to\n  perform a code change.\n\nA process in a supervision tree is expected to terminate with the same reason as\nits parent.\n\nIn the example, system messages are handed by the following code:\n\n```erlang\nloop(Chs, Parent, Deb) ->\n    receive\n        ...\n\n        {system, From, Request} ->\n            sys:handle_system_msg(Request, From, Parent,\n                                  ch4, Deb, Chs)\n    end.\n\nsystem_continue(Parent, Deb, Chs) ->\n    loop(Chs, Parent, Deb).\n\nsystem_terminate(Reason, Parent, Deb, Chs) ->\n    exit(Reason).\n\nsystem_get_state(Chs) ->\n    {ok, Chs, Chs}.\n\nsystem_replace_state(StateFun, Chs) ->\n    NChs = StateFun(Chs),\n    {ok, NChs, NChs}.\n```\n\nIf a special process is configured to trap exits, it must take notice\nof 'EXIT' messages from its parent process and terminate using the\nsame exit reason once the parent process has terminated.\n\nHere is an example:\n\n```erlang\ninit(Parent) ->\n    ...,\n    process_flag(trap_exit, true),\n    ...,\n    loop(Parent).\n\nloop(Parent) ->\n    receive\n        ...\n        {'EXIT', Parent, Reason} ->\n            %% Clean up here, if needed.\n            exit(Reason);\n        ...\n    end.\n```","title":"Handling System Messages - sys and proc_lib","ref":"spec_proc.html#handling-system-messages"},{"type":"extras","doc":"[](){: #behaviours } To implement a user-defined behaviour, write code similar\nto code for a special process, but call functions in a callback module for\nhandling specific tasks.\n\nIf the compiler is to warn for missing callback functions, as it does for the\nOTP behaviours, add `-callback` attributes in the behaviour module to describe\nthe expected callbacks:\n\n```text\n-callback Name1(Arg1_1, Arg1_2, ..., Arg1_N1) -> Res1.\n-callback Name2(Arg2_1, Arg2_2, ..., Arg2_N2) -> Res2.\n...\n-callback NameM(ArgM_1, ArgM_2, ..., ArgM_NM) -> ResM.\n```\n\n`NameX` are the names of the expected callbacks. `ArgX_Y` and `ResX` are types\nas they are described in\n[Types and Function Specifications](`e:system:typespec.md`). The whole syntax of\nthe `-spec` attribute is supported by the `-callback` attribute.\n\nCallback functions that are optional for the user of the behaviour to implement\nare specified by use of the `-optional_callbacks` attribute:\n\n```text\n-optional_callbacks([OptName1/OptArity1, ..., OptNameK/OptArityK]).\n```\n\nwhere each `OptName/OptArity` specifies the name and arity of a callback\nfunction. Note that the `-optional_callbacks` attribute is to be used together\nwith the `-callback` attribute; it cannot be combined with the\n`behaviour_info()` function described below.\n\nTools that need to know about optional callback functions can call\n`Behaviour:behaviour_info(optional_callbacks)` to get a list of all optional\ncallback functions.\n\n> #### Note {: .info }\n>\n> We recommend using the `-callback` attribute rather than the\n> `behaviour_info()` function. The reason is that the extra type information can\n> be used by tools to produce documentation or find discrepancies.\n\nAs an alternative to the `-callback` and `-optional_callbacks` attributes you\nmay directly implement and export `behaviour_info()`:\n\n```erlang\nbehaviour_info(callbacks) ->\n    [{Name1, Arity1},...,{NameN, ArityN}].\n```\n\nwhere each `{Name, Arity}` specifies the name and arity of a callback function.\nThis function is otherwise automatically generated by the compiler using the\n`-callback` attributes.\n\nWhen the compiler encounters the module attribute `-behaviour(Behaviour).` in a\nmodule `Mod`, it calls `Behaviour:behaviour_info(callbacks)` and compares the\nresult with the set of functions actually exported from `Mod`, and issues a\nwarning if any callback function is missing.\n\n_Example:_\n\n```erlang\n%% User-defined behaviour module\n-module(simple_server).\n-export([start_link/2, init/3, ...]).\n\n-callback init(State :: term()) -> 'ok'.\n-callback handle_req(Req :: term(), State :: term()) -> {'ok', Reply :: term()}.\n-callback terminate() -> 'ok'.\n-callback format_state(State :: term()) -> term().\n\n-optional_callbacks([format_state/1]).\n\n%% Alternatively you may define:\n%%\n%% -export([behaviour_info/1]).\n%% behaviour_info(callbacks) ->\n%%     [{init,1},\n%%      {handle_req,2},\n%%      {terminate,0}].\n\nstart_link(Name, Module) ->\n    proc_lib:start_link(?MODULE, init, [self(), Name, Module]).\n\ninit(Parent, Name, Module) ->\n    register(Name, self()),\n    ...,\n    Dbg = sys:debug_options([]),\n    proc_lib:init_ack(Parent, {ok, self()}),\n    loop(Parent, Module, Deb, ...).\n\n...\n```\n\nIn a callback module:\n\n```erlang\n-module(db).\n-behaviour(simple_server).\n\n-export([init/1, handle_req/2, terminate/0]).\n\n...\n```\n\nThe contracts specified with `-callback` attributes in behaviour modules can be\nfurther refined by adding `-spec` attributes in callback modules. This can be\nuseful as `-callback` contracts are usually generic. The same callback module\nwith contracts for the callbacks:\n\n```erlang\n-module(db).\n-behaviour(simple_server).\n\n-export([init/1, handle_req/2, terminate/0]).\n\n-record(state, {field1 :: [atom()], field2 :: integer()}).\n\n-type state()   :: #state{}.\n-type request() :: {'store', term(), term()};\n                   {'lookup', term()}.\n\n...\n\n-spec handle_req(request(), state()) -> {'ok', term()}.\n\n...\n```\n\nEach `-spec` contract is to be a subtype of the respective `-callback` contract.","title":"User-Defined Behaviours - sys and proc_lib","ref":"spec_proc.html#user-defined-behaviours"},{"type":"extras","doc":"<!--\n%CopyrightBegin%\n\nCopyright Ericsson AB 2023-2024. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# Applications\n\n[](){: #appl }\n\nIt is recommended to read this section alongside [`app`](`e:kernel:app.md`)\nand `m:application` in Kernel.","title":"Applications","ref":"applications.html"},{"type":"extras","doc":"After creating code to implement a specific functionality, you might\nconsider transforming it into an *application* — a component that can be\nstarted and stopped as a unit, as well as reused in other systems.\n\nThe steps to create an application is as follows:\n\n* Create an [application callback\n  module](applications.md#callback_module) that describes how the\n  application is to be started and stopped.\n\n* Create an _application specification_ and place it in an\n  [application resource file](applications.md#appl_res_file). Among\n  other things, this file specifies which modules the application\n  consists of and the name of the callback module.\n\nIf you use `m:systools`, the Erlang/OTP tools for packaging code (see\n[Releases](release_structure.md)), the code for each application is placed in a\nseparate directory following a pre-defined\n[directory structure](applications.md#app_dir).\n\n[](){: #callback_module }","title":"Application Concept - Applications","ref":"applications.html#application-concept"},{"type":"extras","doc":"How to start and stop the code for the application, including its supervision\ntree, is described by two callback functions:\n\n```erlang\nstart(StartType, StartArgs) -> {ok, Pid} | {ok, Pid, State}\nstop(State)\n```\n\n- `start/2` is called when starting the application and is to create the\n  supervision tree by starting the top supervisor. It is expected to return the\n  pid of the top supervisor and an optional term, `State`, which defaults to\n  `[]`. This term is passed as is to `stop/1`.\n- `StartType` is usually the atom `normal`. It has other values only in the case\n  of a takeover or failover; see\n  [Distributed Applications](distributed_applications.md).\n- `StartArgs` is defined by the key `mod` in the\n  [application resource file](applications.md#appl_res_file).\n- `stop/1` is called _after_ the application has been stopped and is to do any\n  necessary cleaning up. The actual stopping of the application, that is,\n  shutting down the supervision tree, is handled automatically as described in\n  [Starting and Stopping Applications](applications.md#stopping).\n\n[](){: #ch_app }\n\nExample of an application callback module for packaging the supervision tree\nfrom [Supervisor Behaviour](sup_princ.md#ex):\n\n```erlang\n-module(ch_app).\n-behaviour(application).\n\n-export([start/2, stop/1]).\n\nstart(_Type, _Args) ->\n    ch_sup:start_link().\n\nstop(_State) ->\n    ok.\n```\n\nA library application that cannot be started or stopped does not need any\napplication callback module.\n\n[](){: #appl_res_file }","title":"Application Callback Module - Applications","ref":"applications.html#application-callback-module"},{"type":"extras","doc":"To define an application, an _application specification_ is created, which is\nput in an _application resource file_, or in short an `.app` file:\n\n```text\n{application, Application, [Opt1,...,OptN]}.\n```\n\n- `Application`, an atom, is the name of the application. The file must be named\n  `Application.app`.\n- Each `Opt` is a tuple `{Key,Value}`, which defines a certain property of the\n  application. All keys are optional. Default values are used for any omitted\n  keys.\n\nThe contents of a minimal `.app` file for a library application `libapp` looks\nas follows:\n\n```text\n{application, libapp, []}.\n```\n\nThe contents of a minimal `.app` file `ch_app.app` for a supervision tree\napplication like `ch_app` looks as follows:\n\n```text\n{application, ch_app,\n [{mod, {ch_app,[]}}]}.\n```\n\nThe key `mod` defines the callback module and start argument of the application,\nin this case `ch_app` and `[]`, respectively. This means that the following is\ncalled when the application is to be started:\n\n```text\nch_app:start(normal, [])\n```\n\nThe following is called when the application is stopped:\n\n```text\nch_app:stop([])\n```\n\nWhen using `m:systools`, the Erlang/OTP tools for packaging code (see Section\n[Releases](release_structure.md)), the keys `description`, `vsn`, `modules`,\n`registered`, and `applications` are also to be specified:\n\n```erlang\n{application, ch_app,\n [{description, \"Channel allocator\"},\n  {vsn, \"1\"},\n  {modules, [ch_app, ch_sup, ch3]},\n  {registered, [ch3]},\n  {applications, [kernel, stdlib, sasl]},\n  {mod, {ch_app,[]}}\n ]}.\n```\n\n- `description` - A short description, a string. Defaults to `\"\"`.\n- `vsn` - Version number, a string. Defaults to `\"\"`.\n- `modules` - All modules _introduced_ by this application. `m:systools` uses\n  this list when generating boot scripts and tar files. A module must only\n  be included in one application. Defaults to `[]`.\n- `registered` - All names of registered processes in the application.\n  `m:systools` uses this list to detect name clashes between applications.\n  Defaults to `[]`.\n- `applications` - All applications that must be started before this\n  application is started. `m:systools` uses this list to generate correct boot\n  scripts. Defaults to `[]`. Notice that all applications have dependencies to\n  at least Kernel and STDLIB.\n\n> #### Note {: .info }\n>\n> For details about the syntax and contents of the application resource file,\n> see [app](`e:kernel:app.md`) in Kernel.\n\n[](){: #app_dir }","title":"Application Resource File - Applications","ref":"applications.html#application-resource-file"},{"type":"extras","doc":"When packaging code using `m:systools`, the code for each application is placed in\na separate directory, `lib/Application-Vsn`, where `Vsn` is the version number.\n\nThis can be useful to know, even if `m:systools` is not used, since Erlang/OTP is\npackaged according to the OTP principles and thus comes with a specific\ndirectory structure. The code server (see module `m:code` in Kernel)\nautomatically uses code from the directory with the highest version number, if\nmore than one version of an application is present.","title":"Directory Structure - Applications","ref":"applications.html#directory-structure"},{"type":"extras","doc":"Any directory structure for development will suffice as long as the released\ndirectory structure adheres to the\n[description below](applications.md#app_dir_released), but it is encouraged that\nthe same directory structure also be used in a development environment. The\nversion number should be omitted from the application directory name since this\nis an artifact of the release step.\n\nSome sub-directories are _required_. Some sub-directories are _optional_,\nmeaning that it should only be used if the application itself requires it.\nFinally, some sub-directories are _recommended_, meaning it is encouraged that\nit is used and used as described here. For example, both documentation and tests\nare encouraged to exist in an application for it to be deemed a proper OTP\napplication.\n\n```text\n    ─ ${application}\n      ├── doc\n      │   ├── internal\n      │   ├── examples\n      │   └── src\n      ├── include\n      ├── priv\n      ├── src\n      │   └── ${application}.app.src\n      └── test\n```\n\n- `src` - Required. Contains the Erlang source code, the source of the `.app`\n  file and internal include files used by the application itself. Additional\n  sub-directories within `src` can be used as namespaces to organize source\n  files. These directories should never be deeper than one level.\n- `priv` - Optional. Used for application specific files.\n- `include` - Optional. Used for public include files that must be reachable\n  from other applications.\n- `doc` - Recommended. Any source documentation should be placed in\n  sub-directories here.\n- `doc/internal` - Recommended. Any documentation that describes implementation\n  details about this application, not intended for publication, should be placed\n  here.\n- `doc/examples` - Recommended. Source code for examples on how to use this\n  application should be placed here. It is encouraged that examples are sourced\n  to the public documentation from this directory.\n- `doc/src` - Recommended. All source files for documentation, such as\n  Markdown, AsciiDoc, or XML-files, should be placed here.\n- `test` - Recommended. All files regarding tests, such as test suites and test\n  specifications, should be placed here.\n\nOther directories in the development environment may be needed. If source code\nfrom languages other than Erlang is used, for instance C-code for NIFs, that\ncode should be placed in a separate directory. By convention it is recommended\nto prefix such directories with the language name, for example `c_src` for C,\n`java_src` for Java or `go_src` for Go. Directories with `_src` suffix indicates\nthat it is a part of the application and the compilation step. The final build\nartifacts should target the `priv/lib` or `priv/bin` directories.\n\nThe `priv` directory holds assets that the application needs during runtime.\nExecutables should reside in `priv/bin` and dynamically-linked libraries should\nreside in `priv/lib`. Other assets are free to reside within the `priv`\ndirectory but it is recommended they do so in a structured manner.\n\nSource files from other languages that generate Erlang code, such as ASN.1 or\nMibs, should be placed in directories, at the top level or in `src`, with the\nsame name as the source language, for example `asn1` and `mibs`. Build artifacts\nshould be placed in their respective language directory, such as `src` for\nErlang code or `java_src` for Java code.\n\nIn a development environment, it is acceptable that the `.app` file for\nthe release resides in the `ebin` directory, but it is recommended that\nit is an artifact of the build step. By convention a `.app.src`\nlocated in the `src` directory is used. This file is nearly identical\nto the `.app` file, but certain fields, such as the application\nversion, are replaced during the build step.\n\nDirectory names should not be capitalized.\n\nIt is encouraged to omit empty directories.\n\n[](){: #app_dir_released }","title":"Directory Structure Guidelines for a Development Environment - Applications","ref":"applications.html#directory-structure-guidelines-for-a-development-environment"},{"type":"extras","doc":"A released application must follow a certain structure.\n\n```text\n    ─ ${application}-${version}\n      ├── bin\n      ├── doc\n      │   ├── html\n      │   ├── man[1-9]\n      │   ├── pdf\n      │   ├── internal\n      │   └── examples\n      ├── ebin\n      │   └── ${application}.app\n      ├── include\n      ├── priv\n      │   ├── lib\n      │   └── bin\n      └── src\n```\n\n- `src` - Optional. Contains the Erlang source code and internal include files\n  used by the application itself.\n- `ebin` - Required. Contains the Erlang object code, the `.beam` files. The\n  `.app` file must also be placed here.\n- `priv` - Optional. Used for application specific files. `code:priv_dir/1` is\n  to be used to access this directory.\n- `priv/lib` - Recommended. Any shared-object files that are used by the\n  application, such as NIFs or linked-in-drivers, should be placed here.\n- `priv/bin` - Recommended. Any executable that is used by the application,\n  such as port programs, should be placed here.\n- `include` - Optional. Used for public include files that must be reachable\n  from other applications.\n- `bin` - Optional. Any executable that is a product of the application, such\n  as escripts or shell scripts, should be placed here.\n- `doc` - Optional. Any released documentation should be placed in\n  sub-directories here.\n\nThe `src` directory could be useful to release for debugging purposes,\nbut this is not required. The `include` directory should only be\nreleased if the applications has public include files.\n\nIt is encouraged to omit empty directories.\n\n[](){: #application_controller }","title":"Directory Structure for a Released System - Applications","ref":"applications.html#directory-structure-for-a-released-system"},{"type":"extras","doc":"When an Erlang runtime system is started, a number of processes are started as\npart of the Kernel application. One of these processes is the _application\ncontroller_ process, registered as `application_controller`.\n\nAll operations on applications are coordinated by the application\ncontroller. Use module `m:application` in Kernel to load, unload, start, and\nstop applications.","title":"Application Controller - Applications","ref":"applications.html#application-controller"},{"type":"extras","doc":"Before an application can be started, it must be _loaded_. The application\ncontroller reads and stores the information from the `.app` file:\n\n```erlang\n1> application:load(ch_app).\nok\n2> application:loaded_applications().\n[{kernel,\"ERTS  CXC 138 10\",\"2.8.1.3\"},\n {stdlib,\"ERTS  CXC 138 10\",\"1.11.4.3\"},\n {ch_app,\"Channel allocator\",\"1\"}]\n```\n\nAn application that has been stopped, or has never been started, can be\nunloaded. The information about the application is erased from the internal\ndatabase of the application controller.\n\n```erlang\n3> application:unload(ch_app).\nok\n4> application:loaded_applications().\n[{kernel,\"ERTS  CXC 138 10\",\"2.8.1.3\"},\n {stdlib,\"ERTS  CXC 138 10\",\"1.11.4.3\"}]\n```\n\n> #### Note {: .info }\n>\n> Loading/unloading an application does not load/unload the code used by the\n> application. Code loading is handled in the usual way by the code server.\n\n[](){: #stopping }","title":"Loading and Unloading Applications - Applications","ref":"applications.html#loading-and-unloading-applications"},{"type":"extras","doc":"An application is started by calling:\n\n```erlang\n5> application:start(ch_app).\nok\n6> application:which_applications().\n[{kernel,\"ERTS  CXC 138 10\",\"2.8.1.3\"},\n {stdlib,\"ERTS  CXC 138 10\",\"1.11.4.3\"},\n {ch_app,\"Channel allocator\",\"1\"}]\n```\n\nIf the application is not already loaded, the application controller first loads\nit using `application:load/1`. It checks the value of the `applications` key to\nensure that all applications that are to be started before this application are\nrunning.\n\n[](){: #application_master }\n\nFollowing that, the application controller creates an _application master_ for\nthe application.\n\nThe application master establishes itself as the [group\nleader](`erlang:group_leader/0`) of all processes in the application\nand will forward I/O to the previous group leader.\n\n> #### Note {: .info }\n>\n> The purpose of the application master being the group leader is to easily\n> keep track of which processes that belong to the application. That is needed\n> to support the `application:get_application/0` and `application:get_env/1`\n> functions, and also when stopping an application to ensure that all processes\n> belonging to the application are terminated.\n\nThe application master starts the application by calling the application\ncallback function `start/2` in the module with the start argument defined\nby the `mod` key in the `.app` file.\n\nAn application is stopped, but not unloaded, by calling:\n\n```text\n7> application:stop(ch_app).\nok\n```\n\nThe application master stops the application by telling the top supervisor to\nshut down. The top supervisor tells all its child processes to shut down, and so\non; the entire tree is terminated in reversed start order. The application\nmaster then calls the application callback function `stop/1` in the module\ndefined by the `mod` key.","title":"Starting and Stopping Applications - Applications","ref":"applications.html#starting-and-stopping-applications"},{"type":"extras","doc":"An application can be configured using _configuration parameters_. These are a\nlist of `{Par,Val}` tuples specified by a key `env` in the `.app` file:\n\n```erlang\n{application, ch_app,\n [{description, \"Channel allocator\"},\n  {vsn, \"1\"},\n  {modules, [ch_app, ch_sup, ch3]},\n  {registered, [ch3]},\n  {applications, [kernel, stdlib, sasl]},\n  {mod, {ch_app,[]}},\n  {env, [{file, \"/usr/local/log\"}]}\n ]}.\n```\n\n`Par` is to be an atom. `Val` is any term. The application can retrieve the\nvalue of a configuration parameter by calling `application:get_env(App, Par)` or\na number of similar functions. For more information, see module `m:application`\nin Kernel.\n\n_Example:_\n\n```erlang\n% erl\nErlang (BEAM) emulator version 5.2.3.6 [hipe] [threads:0]\n\nEshell V5.2.3.6  (abort with ^G)\n1> application:start(ch_app).\nok\n2> application:get_env(ch_app, file).\n{ok,\"/usr/local/log\"}\n```\n\nThe values in the `.app` file can be overridden by values in a _system\nconfiguration file_. This is a file that contains configuration parameters for\nrelevant applications:\n\n```erlang\n[{Application1, [{Par11,Val11},...]},\n ...,\n {ApplicationN, [{ParN1,ValN1},...]}].\n```\n\nThe system configuration is to be called `Name.config` and Erlang is to be\nstarted with the command-line argument `-config Name`. For details, see\n[`config`](`e:kernel:config.md`) in Kernel.\n\n_Example:_\n\nA file `test.config` is created with the following contents:\n\n```text\n[{ch_app, [{file, \"testlog\"}]}].\n```\n\nThe value of `file` overrides the value of `file` as defined in the `.app` file:\n\n```erlang\n% erl -config test\nErlang (BEAM) emulator version 5.2.3.6 [hipe] [threads:0]\n\nEshell V5.2.3.6  (abort with ^G)\n1> application:start(ch_app).\nok\n2> application:get_env(ch_app, file).\n{ok,\"testlog\"}\n```\n\nIf [release handling](release_handling.md#sys) is used, exactly one system\nconfiguration file is to be used and that file is to be called `sys.config`.\n\nThe values in the `.app` file and the values in a system configuration file can\nbe overridden directly from the command line:\n\n```text\n% erl -ApplName Par1 Val1 ... ParN ValN\n```\n\n_Example:_\n\n```erlang\n% erl -ch_app file '\"testlog\"'\nErlang (BEAM) emulator version 5.2.3.6 [hipe] [threads:0]\n\nEshell V5.2.3.6  (abort with ^G)\n1> application:start(ch_app).\nok\n2> application:get_env(ch_app, file).\n{ok,\"testlog\"}\n```","title":"Configuring an Application - Applications","ref":"applications.html#configuring-an-application"},{"type":"extras","doc":"A _start type_ is defined when starting the application:\n\n```text\napplication:start(Application, Type)\n```\n\n`application:start(Application)` is the same as calling\n`application:start(Application, temporary)`. The type can also be `permanent` or\n`transient`:\n\n- If a permanent application terminates, all other applications and the runtime\n  system are also terminated.\n- If a transient application terminates with reason `normal`, this is reported\n  but no other applications are terminated. If a transient application\n  terminates abnormally, that is with any other reason than `normal`, all other\n  applications and the runtime system are also terminated.\n- If a temporary application terminates, this is reported but no other\n  applications are terminated.\n\nAn application can always be stopped explicitly by calling `application:stop/1`.\nRegardless of the mode, no other applications are affected.\n\nThe transient mode is of little practical use, since when a supervision tree\nterminates, the reason is set to `shutdown`, not `normal`.","title":"Application Start Types - Applications","ref":"applications.html#application-start-types"},{"type":"extras","doc":"<!--\n%CopyrightBegin%\n\nCopyright Ericsson AB 2023-2024. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# Included Applications\n\n[](){: #included-appl }","title":"Included Applications","ref":"included_applications.html"},{"type":"extras","doc":"An application can _include_ other applications. An _included application_ has\nits own application directory and `.app` file, but it is started as part of the\nsupervisor tree of another application.\n\nAn application can only be included by one other application.\n\nAn included application can include other applications.\n\nAn application that is not included by any other application is called a\n_primary application_.\n\n[](){: #inclappls }\n\n```mermaid\n---\ntitle: Primary Application and Included Applications\n---\nflowchart TD\n    prim_app((Primary Application))\n\n    subgraph Included Applications\n        app1((App))\n        app2((App))\n        app3((App))\n        app4((App))\n        app5((App))\n\n        subgraph Included Applications\n            app11((App))\n        end\n        subgraph Included Applications\n            app31((App))\n            app32((App))\n        end\n    end\n\n    prim_app --- app1 --- app11\n    prim_app --- app2\n    prim_app --- app3\n    prim_app --- app4\n    prim_app --- app5\n\n    app3 --- app31\n    app3 --- app32\n```\n\nThe application controller automatically loads any included applications when\nloading a primary application, but does not start them. Instead, the top\nsupervisor of the included application must be started by a supervisor in the\nincluding application.\n\nThis means that when running, an included application is in fact part of the\nprimary application, and a process in an included application considers itself\nbelonging to the primary application.","title":"Introduction - Included Applications","ref":"included_applications.html#introduction"},{"type":"extras","doc":"Which applications to include is defined by the `included_applications` key in\nthe `.app` file:\n\n```erlang\n{application, prim_app,\n [{description, \"Tree application\"},\n  {vsn, \"1\"},\n  {modules, [prim_app_cb, prim_app_sup, prim_app_server]},\n  {registered, [prim_app_server]},\n  {included_applications, [incl_app]},\n  {applications, [kernel, stdlib, sasl]},\n  {mod, {prim_app_cb,[]}},\n  {env, [{file, \"/usr/local/log\"}]}\n ]}.\n```","title":"Specifying Included Applications - Included Applications","ref":"included_applications.html#specifying-included-applications"},{"type":"extras","doc":"The supervisor tree of an included application is started as part of the\nsupervisor tree of the including application. If there is a need for\nsynchronization between processes in the including and included applications,\nthis can be achieved by using _start phases_.\n\nStart phases are defined by the `start_phases` key in the `.app` file as a list\nof tuples `{Phase,PhaseArgs}`, where `Phase` is an atom and `PhaseArgs` is a\nterm.\n\nThe value of the `mod` key of the including application must be set to\n`{application_starter,[Module,StartArgs]}`, where `Module` as usual is the\napplication callback module. `StartArgs` is a term provided as argument to the\ncallback function `Module:start/2`:\n\n```erlang\n{application, prim_app,\n [{description, \"Tree application\"},\n  {vsn, \"1\"},\n  {modules, [prim_app_cb, prim_app_sup, prim_app_server]},\n  {registered, [prim_app_server]},\n  {included_applications, [incl_app]},\n  {start_phases, [{init,[]}, {go,[]}]},\n  {applications, [kernel, stdlib, sasl]},\n  {mod, {application_starter,[prim_app_cb,[]]}},\n  {env, [{file, \"/usr/local/log\"}]}\n ]}.\n\n{application, incl_app,\n [{description, \"Included application\"},\n  {vsn, \"1\"},\n  {modules, [incl_app_cb, incl_app_sup, incl_app_server]},\n  {registered, []},\n  {start_phases, [{go,[]}]},\n  {applications, [kernel, stdlib, sasl]},\n  {mod, {incl_app_cb,[]}}\n ]}.\n```\n\nWhen starting a primary application with included applications, the primary\napplication is started the normal way, that is:\n\n- The application controller creates an application master for the application\n- The application master calls `Module:start(normal, StartArgs)` to start the\n  top supervisor.\n\nThen, for the primary application and each included application in top-down,\nleft-to-right order, the application master calls\n`Module:start_phase(Phase, Type, PhaseArgs)` for each phase defined for the\nprimary application, in that order. If a phase is not defined for an included\napplication, the function is not called for this phase and application.\n\nThe following requirements apply to the `.app` file for an included application:\n\n- The `{mod, {Module,StartArgs}}` option must be included. This option is used\n  to find the callback module `Module` of the application. `StartArgs` is\n  ignored, as `Module:start/2` is called only for the primary application.\n- If the included application itself contains included applications, instead the\n  `{mod, {application_starter, [Module,StartArgs]}}` option must be included.\n- The `{start_phases, [{Phase,PhaseArgs}]}` option must be included, and the set\n  of specified phases must be a subset of the set of phases specified for the\n  primary application.\n\nWhen starting `prim_app` as defined above, the application controller calls the\nfollowing callback functions before `application:start(prim_app)` returns a\nvalue:\n\n```erlang\napplication:start(prim_app)\n => prim_app_cb:start(normal, [])\n => prim_app_cb:start_phase(init, normal, [])\n => prim_app_cb:start_phase(go, normal, [])\n => incl_app_cb:start_phase(go, normal, [])\nok\n```","title":"Synchronizing Processes during Startup - Included Applications","ref":"included_applications.html#synchronizing-processes-during-startup"},{"type":"extras","doc":"<!--\n%CopyrightBegin%\n\nCopyright Ericsson AB 2023-2024. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# Distributed Applications\n\n[](){: #distributed-appl }","title":"Distributed Applications","ref":"distributed_applications.html"},{"type":"extras","doc":"In a distributed system with several Erlang nodes, it can be necessary to\ncontrol applications in a distributed manner. If the node, where a certain\napplication is running, goes down, the application is to be restarted at another\nnode.\n\nSuch an application is called a _distributed application_. Note that it is the\ncontrol of the application that is distributed. All applications can be\ndistributed in the sense that they, for example, use services on other nodes.\n\nSince a distributed application can move between nodes, some addressing\nmechanism is required to ensure that it can be addressed by other applications,\nregardless on which node it currently executes. This issue is not addressed\nhere, but the `m:global` or `m:pg` modules in Kernel can be used for this purpose.","title":"Introduction - Distributed Applications","ref":"distributed_applications.html#introduction"},{"type":"extras","doc":"Distributed applications are controlled by both the application\ncontroller and a distributed application controller process called\n`dist_ac`. Both processes are part of the Kernel application.\nDistributed applications are thus specified by\nconfiguring the Kernel application, using the following configuration\nparameter (see also [Kernel](`e:kernel:kernel_app.md`)):\n\n`distributed = [{Application, [Timeout,] NodeDesc}]`\n\n- Specifies where the application `Application = atom()` can execute.\n- `NodeDesc = [Node | {Node,...,Node}]` is a list of node names in priority\n  order. The order between nodes in a tuple is undefined.\n- `Timeout = integer()` specifies how many milliseconds to wait before\n  restarting the application at another node. It defaults to 0.\n\nFor distribution of application control to work properly, the nodes where a\ndistributed application can run must contact each other and negotiate where to\nstart the application. This is done using the following configuration parameters\nin Kernel:\n\n- `sync_nodes_mandatory = [Node]` - Specifies which other nodes must be started\n  (within the time-out specified by `sync_nodes_timeout`).\n- `sync_nodes_optional = [Node]` - Specifies which other nodes can be started\n  (within the time-out specified by `sync_nodes_timeout`).\n- `sync_nodes_timeout = integer() | infinity` - Specifies how many milliseconds\n  to wait for the other nodes to start.\n\nWhen started, the node waits for all nodes specified by `sync_nodes_mandatory`\nand `sync_nodes_optional` to come up. When all nodes are up, or when all\nmandatory nodes are up and the time specified by `sync_nodes_timeout` has\nelapsed, all applications start. If not all mandatory nodes are up, the node\nterminates.\n\n_Example:_\n\nAn application `myapp` is to run at the node `cp1@cave`. If this node goes down,\n`myapp` is to be restarted at `cp2@cave` or `cp3@cave`. A system configuration\nfile `cp1.config` for `cp1@cave` can look as follows:\n\n```erlang\n[{kernel,\n  [{distributed, [{myapp, 5000, [cp1@cave, {cp2@cave, cp3@cave}]}]},\n   {sync_nodes_mandatory, [cp2@cave, cp3@cave]},\n   {sync_nodes_timeout, 5000}\n  ]\n }\n].\n```\n\nThe system configuration files for `cp2@cave` and `cp3@cave` are identical,\nexcept for the list of mandatory nodes, which is to be `[cp1@cave, cp3@cave]`\nfor `cp2@cave` and `[cp1@cave, cp2@cave]` for `cp3@cave`.\n\n> #### Note {: .info }\n>\n> All involved nodes must have the same value for `distributed` and\n> `sync_nodes_timeout`. Otherwise the system behavior is undefined.","title":"Specifying Distributed Applications - Distributed Applications","ref":"distributed_applications.html#specifying-distributed-applications"},{"type":"extras","doc":"When all involved (mandatory) nodes have been started, the distributed\napplication can be started by calling `application:start(Application)` at _all\nof these nodes._\n\nA boot script (see [Releases](release_structure.md)) can be used that\nautomatically starts the application.\n\nThe application is started at the first operational node that is listed in the\nlist of nodes in the `distributed` configuration parameter. The application is\nstarted as usual. That is, an application master is created and calls the\napplication callback function:\n\n```erlang\nModule:start(normal, StartArgs)\n```\n\nExample:\n\nContinuing the example from the previous section, the three nodes are started,\nspecifying the system configuration file:\n\n```text\n> erl -sname cp1 -config cp1\n> erl -sname cp2 -config cp2\n> erl -sname cp3 -config cp3\n```\n\nWhen all nodes are operational, `myapp` can be started. This is achieved by\ncalling `application:start(myapp)` at all three nodes. It is then started at\n`cp1`, as shown in the following figure:\n\n[](){: #dist1 }\n\n![Application myapp - Situation 1](assets/dist1.gif \"Application myapp - Situation 1\")\n\nSimilarly, the application must be stopped by calling\n`application:stop(Application)` at all involved nodes.","title":"Starting and Stopping Distributed Applications - Distributed Applications","ref":"distributed_applications.html#starting-and-stopping-distributed-applications"},{"type":"extras","doc":"If the node where the application is running goes down, the application is\nrestarted (after the specified time-out) at the first operational node that is\nlisted in the list of nodes in the `distributed` configuration parameter. This\nis called a _failover_.\n\nThe application is started the normal way at the new node, that is, by the\napplication master calling:\n\n```erlang\nModule:start(normal, StartArgs)\n```\n\nAn exception is if the application has the `start_phases` key defined (see\n[Included Applications](included_applications.md)). The application is then\ninstead started by calling:\n\n```erlang\nModule:start({failover, Node}, StartArgs)\n```\n\nHere `Node` is the terminated node.\n\n_Example:_\n\nIf `cp1` goes down, the system checks which one of the other nodes, `cp2` or\n`cp3`, has the least number of running applications, but waits for 5 seconds for\n`cp1` to restart. If `cp1` does not restart and `cp2` runs fewer applications\nthan `cp3`, `myapp` is restarted on `cp2`.\n\n[](){: #dist2 }\n\n![Application myapp - Situation 2](assets/dist2.gif \"Application myapp - Situation 2\")\n\nSuppose now that `cp2` goes also down and does not restart within 5 seconds.\n`myapp` is now restarted on `cp3`.\n\n[](){: #dist3 }\n\n![Application myapp - Situation 3](assets/dist3.gif \"Application myapp - Situation 3\")","title":"Failover - Distributed Applications","ref":"distributed_applications.html#failover"},{"type":"extras","doc":"If a node is started, which has higher priority according to `distributed` than\nthe node where a distributed application is running, the application is\nrestarted at the new node and stopped at the old node. This is called a\n_takeover_.\n\nThe application is started by the application master calling:\n\n```erlang\nModule:start({takeover, Node}, StartArgs)\n```\n\nHere `Node` is the old node.\n\n_Example:_\n\nIf `myapp` is running at `cp3`, and if `cp2` now restarts, it does not restart\n`myapp`, as the order between the `cp2` and `cp3` nodes is undefined.\n\n[](){: #dist4 }\n\n![Application myapp - Situation 4](assets/dist4.gif \"Application myapp - Situation 4\")\n\nHowever, if `cp1` also restarts, the function `application:takeover/2` moves\n`myapp` to `cp1`, as `cp1` has a higher priority than `cp3` for this\napplication. In this case, `Module:start({takeover, cp3@cave}, StartArgs)` is\nexecuted at `cp1` to start the application.\n\n[](){: #dist5 }\n\n![Application myapp - Situation 5](assets/dist5.gif \"Application myapp - Situation 5\")","title":"Takeover - Distributed Applications","ref":"distributed_applications.html#takeover"},{"type":"extras","doc":"<!--\n%CopyrightBegin%\n\nCopyright Ericsson AB 2023-2024. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# Releases\n\n[](){: #releases-section }\n\nIt is recommended to read this section alongside\n[`rel`](`e:sasl:rel.md`), `m:systools`, and\n[`script`](`e:sasl:script.md`) in SASL.","title":"Releases","ref":"release_structure.html"},{"type":"extras","doc":"When you have written one or more applications, you might want to create a\ncomplete system with these applications and a subset of the Erlang/OTP\napplications. This is called a _release_.\n\nTo do this, create a [release resource file](release_structure.md#res_file) that\ndefines which applications are included in the release.\n\nThe release resource file is used to generate\n[boot scripts](release_structure.md#boot) and\n[release packages](release_structure.md#pack). A system that is transferred to\nand installed at another site is called a _target system_. How to use a release\npackage to create a target system is described in\n[Creating and Upgrading a Target System](`e:system:create_target.md`)\nin System Principles.\n\n[](){: #res_file }","title":"Release Concept - Releases","ref":"release_structure.html#release-concept"},{"type":"extras","doc":"To define a release, create a _release resource file_, or in short a `.rel`\nfile. In the file, specify the name and version of the release, which ERTS\nversion it is based on, and which applications it consists of:\n\n```erlang\n{release, {Name,Vsn}, {erts, EVsn},\n [{Application1, AppVsn1},\n   ...\n  {ApplicationN, AppVsnN}]}.\n```\n\n`Name`, `Vsn`, `EVsn`, and `AppVsn` are strings.\n\nThe file must be named `Rel.rel`, where `Rel` is a unique name.\n\nEach `Application` (atom) and `AppVsn` is the name and version of an application\nincluded in the release. The minimal release based on Erlang/OTP consists of the\nKernel and STDLIB applications, so these applications must be included in the\nlist.\n\nIf the release is to be upgraded, it must also include the SASL application.\n\n[](){: #ch_rel }\n\nHere is an example showing the `.app` file for a release of `ch_app` from\nthe [Applications](applications.md#ch_app) section:\n\n```erlang\n{application, ch_app,\n [{description, \"Channel allocator\"},\n  {vsn, \"1\"},\n  {modules, [ch_app, ch_sup, ch3]},\n  {registered, [ch3]},\n  {applications, [kernel, stdlib, sasl]},\n  {mod, {ch_app,[]}}\n ]}.\n```\n\nThe `.rel` file must also contain `kernel`, `stdlib`, and `sasl`, as these\napplications are required by `ch_app`. The file is called `ch_rel-1.rel`:\n\n```erlang\n{release,\n {\"ch_rel\", \"A\"},\n {erts, \"14.2.5\"},\n [{kernel, \"9.2.4\"},\n  {stdlib, \"5.2.3\"},\n  {sasl, \"4.2.1\"},\n  {ch_app, \"1\"}]\n}.\n```\n\n[](){: #boot }","title":"Release Resource File - Releases","ref":"release_structure.html#release-resource-file"},{"type":"extras","doc":"`m:systools` in the SASL application includes tools to build and check\nreleases. The functions read the `.rel` and `.app` files and perform\nsyntax and dependency checks. The\n[`systools:make_script/1,2`](`systools:make_script/2`) function is\nused to generate a boot script:\n\n```text\n1> systools:make_script(\"ch_rel-1\", [local]).\nok\n```\n\nThis call creates both the human-readable boot script,\n`ch_rel-1.script`, and the binary boot script, `ch_rel-1.boot`, used\nby the runtime system.\n\n- `\"ch_rel-1\"` is the name of the `.rel` file, minus the extension.\n- `local` is an option that means that the directories where the applications\n  are found are used in the boot script, instead of `$ROOT/lib` (`$ROOT` is the\n  root directory of the installed release).\n\nThis is a useful way to test a generated boot script locally.\n\nWhen starting Erlang/OTP using the boot script, all applications from the `.rel`\nfile are automatically loaded and started:\n\n```text\n% erl -boot ch_rel-1\nErlang/OTP 26 [erts-14.2.5] [64-bit] [smp:8:8] [ds:8:8:10] [async-threads:1] [jit]\n\nEshell V14.2.5 (press Ctrl+G to abort, type help(). for help)\n1> application:which_applications().\n[{ch_app,\"Channel allocator\",\"1\"},\n {sasl,\"SASL  CXC 138 11\",\"4.2.1\"},\n {stdlib,\"ERTS  CXC 138 10\",\"5.2.3\"},\n {kernel,\"ERTS  CXC 138 10\",\"9.2.4\"}]\n```\n\n[](){: #pack }","title":"Generating Boot Scripts - Releases","ref":"release_structure.html#generating-boot-scripts"},{"type":"extras","doc":"The [`systools:make_tar/1,2`](`systools:make_tar/2`) function takes a\n`.rel` file as input and creates a zipped tar file with the code for\nthe specified applications, a _release package_:\n\n```erlang\n1> systools:make_script(\"ch_rel-1\").\nok\n2> systools:make_tar(\"ch_rel-1\").\nok\n```\n\nThe release package by default contains:\n\n- The `.app` files\n- The `.rel` file\n- The object code for all applications, structured according to the\n  [application directory structure](applications.md#app_dir)\n- The binary boot script renamed to `start.boot`\n\n```text\n% tar tf ch_rel-1.tar\nlib/kernel-9.2.4/ebin/kernel.app\nlib/kernel-9.2.4/ebin/application.beam\n...\nlib/stdlib-5.2.3/ebin/stdlib.app\nlib/stdlib-5.2.3/ebin/argparse.beam\n...\nlib/sasl-4.2.1/ebin/sasl.app\nlib/sasl-4.2.1/ebin/sasl.beam\n...\nlib/ch_app-1/ebin/ch_app.app\nlib/ch_app-1/ebin/ch_app.beam\nlib/ch_app-1/ebin/ch_sup.beam\nlib/ch_app-1/ebin/ch3.beam\nreleases/ch_rel-1.rel\nreleases/A/ch_rel-1.rel\nreleases/A/start.boot\n```\n\nA new boot script was generated, without the `local` option set, before the\nrelease package was made. In the release package, all application directories\nare placed under `lib`. You do not know where the release package will be\ninstalled, so no hard-coded absolute paths are allowed.\n\nThe release resource file `mysystem.rel` is duplicated in the tar file.\nOriginally, this file was only stored in the `releases` directory to make it\npossible for the `release_handler` to extract this file separately. After\nunpacking the tar file, `release_handler` would automatically copy the file to\n`releases/FIRST`. However, sometimes the tar file is unpacked without involving\nthe `release_handler` (for example, when unpacking the first target system) and\nthe file is therefore now instead duplicated in the tar file so no manual\ncopying is necessary.\n\nIf a `relup` file and/or a system configuration file called `sys.config`, or a\n`sys.config.src`, is found, these files are also included in the release\npackage. See [Release Handling](release_handling.md#req).\n\nOptions can be set to make the release package include source code and the ERTS\nbinary as well.\n\nFor information on how to install the first target system, using a release\npackage, see System Principles. For information on how to install a new release\npackage in an existing system, see [Release Handling](release_handling.md).\n\n[](){: #reldir }","title":"Creating a Release Package - Releases","ref":"release_structure.html#creating-a-release-package"},{"type":"extras","doc":"The directory structure for the code installed by the release handler from a\nrelease package is as follows:\n\n```text\n$ROOT/lib/App1-AVsn1/ebin\n                    /priv\n         /App2-AVsn2/ebin\n                    /priv\n         ...\n         /AppN-AVsnN/ebin\n                    /priv\n     /erts-EVsn/bin\n     /releases/Vsn\n     /bin\n```\n\n- `lib` \\- Application directories\n- `erts-EVsn/bin` \\- Erlang runtime system executables\n- `releases/Vsn` \\- `.rel` file and boot script `start.boot`; if present in the\n  release package, `relup` and/or `sys.config` or `sys.config.src`\n- `bin` \\- Top-level Erlang runtime system executables\n\nApplications are not required to be located under directory `$ROOT/lib`. Several\ninstallation directories, which contain different parts of a system, can thus\nexist. For example, the previous example can be extended as follows:\n\n```text\n$SECOND_ROOT/.../SApp1-SAVsn1/ebin\n                             /priv\n                /SApp2-SAVsn2/ebin\n                             /priv\n                ...\n                /SAppN-SAVsnN/ebin\n                             /priv\n\n$THIRD_ROOT/TApp1-TAVsn1/ebin\n                        /priv\n           /TApp2-TAVsn2/ebin\n                        /priv\n           ...\n           /TAppN-TAVsnN/ebin\n                        /priv\n```\n\n`$SECOND_ROOT` and `$THIRD_ROOT` are introduced as `variables` in the call to\nthe `systools:make_script/2` function.","title":"Directory Structure - Releases","ref":"release_structure.html#directory-structure"},{"type":"extras","doc":"If a complete system consists of disk-less and/or read-only client nodes, a\n`clients` directory is to be added to the `$ROOT` directory. A read-only node is\na node with a read-only file system.\n\nThe `clients` directory is to have one subdirectory per supported client node.\nThe name of each client directory is to be the name of the corresponding client\nnode. As a minimum, each client directory is to contain the `bin` and `releases`\nsubdirectories. These directories are used to store information about installed\nreleases and to appoint the current release to the client. The `$ROOT` directory\nthus contains the following:\n\n```text\n$ROOT/...\n    /clients/ClientName1/bin\n                        /releases/Vsn\n            /ClientName2/bin\n                        /releases/Vsn\n            ...\n            /ClientNameN/bin\n                        /releases/Vsn\n```\n\nThis structure is to be used if all clients are running the same type of Erlang\nmachine. If there are clients running different types of Erlang machines, or on\ndifferent operating systems, the `clients` directory can be divided into one\nsubdirectory per type of Erlang machine. Alternatively, one `$ROOT` can be set\nup per type of machine. For each type, some of the directories specified for the\n`$ROOT` directory are to be included:\n\n```text\n$ROOT/...\n    /clients/Type1/lib\n                  /erts-EVsn\n                  /bin\n                  /ClientName1/bin\n                              /releases/Vsn\n                  /ClientName2/bin\n                              /releases/Vsn\n                  ...\n                  /ClientNameN/bin\n                              /releases/Vsn\n            ...\n            /TypeN/lib\n                  /erts-EVsn\n                  /bin\n                  ...\n```\n\nWith this structure, the root directory for clients of `Type1` is\n`$ROOT/clients/Type1`.","title":"Disk-Less and/or Read-Only Clients - Releases","ref":"release_structure.html#disk-less-and-or-read-only-clients"},{"type":"extras","doc":"<!--\n%CopyrightBegin%\n\nCopyright Ericsson AB 2023-2024. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# Release Handling\n\n[](){: #release-handling }","title":"Release Handling","ref":"release_handling.html"},{"type":"extras","doc":"An important feature of the Erlang programming language is the ability to change\nmodule code at runtime, _code replacement_, as described in\n[Code Replacement](code_loading.md#code-replacement) in the Erlang Reference\nManual.\n\nBased on this feature, the OTP application SASL provides a framework for\nupgrading and downgrading between different versions of an entire release in\nruntime. This is called _release handling_.\n\nThe framework consists of:\n\n- Offline support - `systools` for generating scripts and building release\n  packages\n- Online support - `release_handler` for unpacking and installing release\n  packages\n\nThe minimal system based on Erlang/OTP, enabling release handling, thus consists\nof the Kernel, STDLIB, and SASL applications.","title":"Release Handling Principles - Release Handling","ref":"release_handling.html#release-handling-principles"},{"type":"extras","doc":"_Step 1_) A release is created as described in [Releases](release_structure.md).\n\n_Step 2_) The release is transferred to and installed at target environment. For\ninformation of how to install the first target system, see\n[System Principles](`e:system:create_target.md`).\n\n_Step 3_) Modifications, for example, error corrections, are made to the code in\nthe development environment.\n\n_Step 4_) At some point, it is time to make a new version of release. The\nrelevant `.app` files are updated and a new `.rel` file is written.\n\n_Step 5_) For each modified application, an\n[application upgrade file](release_handling.md#appup), `.appup`, is created. In\nthis file, it is described how to upgrade and/or downgrade between the old and\nnew version of the application.\n\n_Step 6_) Based on the `.appup` files, a\n[release upgrade file](release_handling.md#relup) called `relup`, is created.\nThis file describes how to upgrade and/or downgrade between the old and new\nversion of the entire release.\n\n_Step 7_) A new release package is made and transferred to the target system.\n\n_Step 8_) The new release package is unpacked using the release handler.\n\n_Step 9_) The new version of the release is installed, also using the release\nhandler. This is done by evaluating the instructions in `relup`. Modules can be\nadded, deleted, or reloaded, applications can be started, stopped, or restarted,\nand so on. In some cases, it is even necessary to restart the runtime system.\n\n- If the installation fails, the system can be rebooted. The old release version\n  is then automatically used.\n- If the installation succeeds, the new version is made the default version,\n  which is to now be used if there is a system reboot.","title":"Release Handling Workflow - Release Handling","ref":"release_handling.html#release-handling-workflow"},{"type":"extras","doc":"[Appup Cookbook](appup_cookbook.md), contains examples of `.appup` files for\ntypical cases of upgrades/downgrades that are normally easy to handle in\nruntime. However, many aspects can make release handling complicated, for\nexample:\n\n- Complicated or circular dependencies can make it difficult or even impossible\n  to decide in which order things must be done without risking runtime errors\n  during an upgrade or downgrade. Dependencies can be:\n\n  - Between nodes\n  - Between processes\n  - Between modules\n\n- During release handling, non-affected processes continue normal execution.\n  This can lead to time-outs or other problems. For example, new processes\n  created in the time window between suspending processes using a certain\n  module, and loading a new version of this module, can execute old code.\n\nIt is thus recommended that code is changed in as small steps as possible, and\nalways kept backwards compatible.\n\n[](){: #req }","title":"Release Handling Aspects - Release Handling","ref":"release_handling.html#release-handling-aspects"},{"type":"extras","doc":"For release handling to work properly, the runtime system must have knowledge\nabout which release it is running. It must also be able to change (in runtime)\nwhich boot script and system configuration file to use if the system is\nrebooted, for example, by `heart` after a failure. Thus, Erlang must be started\nas an embedded system; for information on how to do this, see Embedded System.\n\nFor system reboots to work properly, it is also required that the system is\nstarted with heartbeat monitoring; see [`erl`](`e:erts:erl_cmd.md`)\nin ERTS and module `m:heart` in Kernel.\n\nOther requirements:\n\n- The boot script included in a release package must be generated from the same\n  `.rel` file as the release package itself.\n\n  Information about applications is fetched from the script when an upgrade or\n  downgrade is performed.\n\n- The system must be configured using only one system configuration file, called\n  `sys.config`.\n\n  If found, this file is automatically included when a release package is\n  created.\n\n- All versions of a release, except the first one, must contain a `relup` file.\n\n  If found, this file is automatically included when a release package is\n  created.","title":"Requirements - Release Handling","ref":"release_handling.html#requirements"},{"type":"extras","doc":"If the system consists of several Erlang nodes, each node can use its own\nversion of the release. The release handler is a locally registered process and\nmust be called at each node where an upgrade or downgrade is required. A release\nhandling instruction, `sync_nodes`, can be used to synchronize the release\nhandler processes at a number of nodes; see [`appup`](`e:sasl:appup`) in SASL.\n\n[](){: #instr }","title":"Distributed Systems - Release Handling","ref":"release_handling.html#distributed-systems"},{"type":"extras","doc":"OTP supports a set of _release handling instructions_ that are used when\ncreating `.appup` files. The release handler understands a subset of these, the\n_low-level_ instructions. To make it easier for the user, there are also a\nnumber of _high-level_ instructions, which are translated to low-level\ninstructions by `systools:make_relup`.\n\nSome of the most frequently used instructions are described in this section. The\ncomplete list of instructions is included in [`appup`](`e:sasl:appup`) in SASL.\n\nFirst, some definitions:\n\n- _Residence module_ - The module where a process has its tail-recursive loop\n  function(s). If these functions are implemented in several modules, all those\n  modules are residence modules for the process.\n- _Functional module_ - A module that is not a residence module for any\n  process.\n\nFor a process implemented using an OTP behaviour, the behaviour module is the\nresidence module for that process. The callback module is a functional module.","title":"Release Handling Instructions - Release Handling","ref":"release_handling.html#release-handling-instructions"},{"type":"extras","doc":"If a simple extension has been made to a functional module, it is sufficient to\nload the new version of the module into the system, and remove the old version.\nThis is called _simple code replacement_ and for this the following instruction\nis used:\n\n```text\n{load_module, Module}\n```","title":"load_module - Release Handling","ref":"release_handling.html#load_module"},{"type":"extras","doc":"If a more complex change has been made, for example, a change to the format of\nthe internal state of a `m:gen_server`, simple code replacement is not sufficient.\nInstead, it is necessary to:\n\n- Suspend the processes using the module (to avoid that they try to handle any\n  requests before the code replacement is completed).\n- Ask them to transform the internal state format and switch to the new version\n  of the module.\n- Remove the old version.\n- Resume the processes.\n\nThis is called _synchronized code replacement_ and for this the following\ninstructions are used:\n\n```erlang\n{update, Module, {advanced, Extra}}\n{update, Module, supervisor}\n```\n\n`update` with argument `{advanced,Extra}` is used when changing the internal\nstate of a behaviour as described above. It causes behaviour processes to call\nthe callback function `code_change/3`, passing the term `Extra` and some other\ninformation as arguments. See the manual pages for the respective behaviours and\n[Appup Cookbook](appup_cookbook.md#int_state).\n\n`update` with argument `supervisor` is used when changing the start\nspecification of a supervisor. See [Appup Cookbook](appup_cookbook.md#sup).\n\nWhen a module is to be updated, the release handler finds which processes that\nare _using_ the module by traversing the supervision tree of each running\napplication and checking all the child specifications:\n\n```erlang\n{Id, StartFunc, Restart, Shutdown, Type, Modules}\n```\n\nA process uses a module if the name is listed in `Modules` in the child\nspecification for the process.\n\nIf `Modules=dynamic`, which is the case for event managers, the event manager\nprocess informs the release handler about the list of currently installed event\nhandlers (`gen_event`), and it is checked if the module name is in this list\ninstead.\n\nThe release handler suspends, asks for code change, and resumes processes by\ncalling the functions `sys:suspend/1,2`, `sys:change_code/4,5`, and\n`sys:resume/1,2`, respectively.","title":"update - Release Handling","ref":"release_handling.html#update"},{"type":"extras","doc":"If a new module is introduced, the following instruction is used:\n\n```erlang\n{add_module, Module}\n```\n\nThis instruction loads module `Module`. When running Erlang in\nembedded mode it is necessary to use this this instruction. It is not\nstrictly required when running Erlang in interactive mode, since the\ncode server automatically searches for and loads unloaded modules.\n\nThe opposite of `add_module` is `delete_module`, which unloads a module:\n\n```erlang\n{delete_module, Module}\n```\n\nAny process, in any application, with `Module` as residence module, is\nkilled when the instruction is evaluated. Therefore, the user must\nensure that all such processes are terminated before deleting module\n`Module` to avoid a situation with failing supervisor restarts.","title":"add_module and delete_module - Release Handling","ref":"release_handling.html#add_module-and-delete_module"},{"type":"extras","doc":"The following is the instruction for adding an application:\n\n```text\n{add_application, Application}\n```\n\nAdding an application means that the modules defined by the `modules` key in the\n`.app` file are loaded using a number of `add_module` instructions, and then the\napplication is started.\n\nThe following is the instruction for removing an application:\n\n```text\n{remove_application, Application}\n```\n\nRemoving an application means that the application is stopped, the modules are\nunloaded using a number of `delete_module` instructions, and then the\napplication specification is unloaded from the application controller.\n\nThe following is the instruction for restarting an application:\n\n```text\n{restart_application, Application}\n```\n\nRestarting an application means that the application is stopped and then started\nagain similar to using the instructions `remove_application` and\n`add_application` in sequence.","title":"Application Instructions - Release Handling","ref":"release_handling.html#application-instructions"},{"type":"extras","doc":"To call an arbitrary function from the release handler, the following\ninstruction is used:\n\n```text\n{apply, {M, F, A}}\n```\n\nThe release handler evaluates [`apply(M, F, A)`](`apply/3`).\n\n[](){: #restart_new_emulator_instr }","title":"apply (Low-Level) - Release Handling","ref":"release_handling.html#apply-low-level"},{"type":"extras","doc":"This instruction is used when changing to a new version of the runtime\nsystem, or when any of the core applications Kernel, STDLIB, or SASL\nis upgraded. If a system reboot is needed for another reason, the\n`restart_emulator` instruction is to be used instead.\n\nThis instruction requires that the system is started with heartbeat monitoring;\nsee [`erl`](`e:erts:erl_cmd.md`) in ERTS and module `m:heart` in Kernel.\n\nThe `restart_new_emulator` instruction must always be the first instruction in a\nrelup. If the relup is generated by\n[`systools:make_relup/3,4`](`systools:make_relup/4`),\nthis condition is automatically met.\n\nWhen the release handler encounters this instruction, it first generates a\ntemporary boot file that starts the new versions of the runtime system and the\ncore applications, and the old version of all other applications. Then it shuts\ndown the current instance of the runtime system by calling `init:reboot/0`.\nAll processes are terminated gracefully and the system is rebooted by\nthe `heart` program, using the temporary boot file. After the reboot, the rest\nof the relup instructions are executed. This is done as a part of the temporary\nboot script.\n\n> #### Warning {: .warning }\n>\n> This mechanism causes the new versions of the runtime system and core\n> applications to run with the old version of other applications during startup.\n> Thus, take extra care to avoid incompatibility. Incompatible changes in the\n> core applications can in some situations be necessary. If possible, such changes\n> are preceded by deprecation over two major releases before the actual change.\n> To ensure the application is not crashed by an incompatible change, always\n> remove any call to deprecated functions as soon as possible.\n\nAn info report is written when the upgrade is completed. To programmatically\nfind out if the upgrade is complete, call\n[`release_handler:which_releases(current)`](`release_handler:which_releases/1`)\nand check whether it returns the expected (that is, the new) release.\n\nThe new release version must be made permanent when the new runtime system is\noperational. Otherwise, the old version will be used if there is a new system\nreboot.\n\nOn UNIX, the release handler tells the `heart` program which command to use to\nreboot the system. The environment variable `HEART_COMMAND`, normally used by\nthe `heart` program, is ignored in this case. The command instead defaults to\n`$ROOT/bin/start`. Another command can be set by using the SASL configuration\nparameter `start_prg`. For more information, see [SASL](`e:sasl:sasl_app.md`).\n\n[](){: #restart_emulator_instr }","title":"restart_new_emulator (Low-Level) - Release Handling","ref":"release_handling.html#restart_new_emulator-low-level"},{"type":"extras","doc":"This instruction is not related to upgrades of ERTS or any of the core\napplications. It can be used by any application to force a restart of the\nruntime system after all upgrade instructions are executed.\n\nA relup script can only contain one `restart_emulator` instruction, and it must\nalways be placed at the end. If the relup is generated by\n[`systools:make_relup/3,4`](`systools:make_relup/4`),\nthis condition is automatically met.\n\nWhen the release handler encounters this instruction, it shuts down\nthe runtime system by calling `init:reboot/0`. All processes are terminated\ngracefully and the system can then be rebooted by the `heart` program\nusing the new release version. No more upgrade instruction is executed\nafter the restart.\n\n[](){: #appup }","title":"restart_emulator (Low-Level) - Release Handling","ref":"release_handling.html#restart_emulator-low-level"},{"type":"extras","doc":"To define how to upgrade/downgrade between the current version and previous\nversions of an application, an _application upgrade file_, or in short\n`.appup` file is created. The file is to be called `Application.appup`, where\n`Application` is the application name:\n\n```c\n{Vsn,\n [{UpFromVsn1, InstructionsU1},\n  ...,\n  {UpFromVsnK, InstructionsUK}],\n [{DownToVsn1, InstructionsD1},\n  ...,\n  {DownToVsnK, InstructionsDK}]}.\n```\n\n- `Vsn`, a string, is the current version of the application, as defined in the\n  `.app` file.\n- Each `UpFromVsn` is a previous version of the application to upgrade from.\n- Each `DownToVsn` is a previous version of the application to downgrade to.\n- Each `Instructions` is a list of release handling instructions.\n\n`UpFromVsn` and `DownToVsn` can also be specified as regular expressions. For\nmore information about the syntax and contents of the `.appup` file, see\n[`appup`](`e:sasl:appup.md`) in SASL.\n\n[Appup Cookbook](appup_cookbook.md) includes examples of `.appup` files for\ntypical upgrade/downgrade cases.\n\n_Example:_ Consider the release `ch_rel-1` from\n[Releases](release_structure.md#ch_rel). Assume you want to add a function\n`available/0` to server `ch3`, which returns the number of available channels\n(when trying out the example, make the change in a copy of the original\ndirectory, to ensure that the first version is still available):\n\n```erlang\n-module(ch3).\n-behaviour(gen_server).\n\n-export([start_link/0]).\n-export([alloc/0, free/1]).\n-export([available/0]).\n-export([init/1, handle_call/3, handle_cast/2]).\n\nstart_link() ->\n    gen_server:start_link({local, ch3}, ch3, [], []).\n\nalloc() ->\n    gen_server:call(ch3, alloc).\n\nfree(Ch) ->\n    gen_server:cast(ch3, {free, Ch}).\n\navailable() ->\n    gen_server:call(ch3, available).\n\ninit(_Args) ->\n    {ok, channels()}.\n\nhandle_call(alloc, _From, Chs) ->\n    {Ch, Chs2} = alloc(Chs),\n    {reply, Ch, Chs2};\nhandle_call(available, _From, Chs) ->\n    N = available(Chs),\n    {reply, N, Chs}.\n\nhandle_cast({free, Ch}, Chs) ->\n    Chs2 = free(Ch, Chs),\n    {noreply, Chs2}.\n```\n\nA new version of the `ch_app.app` file must now be created, where the version is\nupdated:\n\n```erlang\n{application, ch_app,\n [{description, \"Channel allocator\"},\n  {vsn, \"2\"},\n  {modules, [ch_app, ch_sup, ch3]},\n  {registered, [ch3]},\n  {applications, [kernel, stdlib, sasl]},\n  {mod, {ch_app,[]}}\n ]}.\n```\n\nTo upgrade `ch_app` from `\"1\"` to `\"2\"` (and to downgrade from `\"2\"` to `\"1\"`),\nyou only need to load the new (old) version of the `ch3` callback module. Create\nthe application upgrade file `ch_app.appup` in the `ebin` directory:\n\n```erlang\n{\"2\",\n [{\"1\", [{load_module, ch3}]}],\n [{\"1\", [{load_module, ch3}]}]\n}.\n```\n\n[](){: #relup }","title":"Application Upgrade File - Release Handling","ref":"release_handling.html#application-upgrade-file"},{"type":"extras","doc":"To define how to upgrade/downgrade between the new version and previous versions\nof a release, a _release upgrade file_, or in short `.relup` file, is to be\ncreated.\n\nThis file does not need to be created manually. It can be generated by\n[`systools:make_relup/3,4`](`systools:make_relup/4`).\nThe relevant versions of the `.rel` file, `.app`\nfiles, and `.appup` files are used as input. It is deduced which applications\nare to be added and deleted, and which applications that must be upgraded and/or\ndowngraded. The instructions for this are fetched from the `.appup` files and\ntransformed into a single list of low-level instructions in the right order.\n\nIf the `relup` file is relatively simple, it can be created manually. It is only\nto contain low-level instructions.\n\nFor details about the syntax and contents of the release upgrade file, see\n[`relup`](`e:sasl:relup.md`) in SASL.\n\n_Example, continued from the previous section:_ You have a new version \"2\" of\n`ch_app` and an `.appup` file. A new version of the `.rel` file is also needed.\nThis time the file is called `ch_rel-2.rel` and the release version string is\nchanged from \"A\" to \"B\":\n\n```erlang\n{release,\n {\"ch_rel\", \"B\"},\n {erts, \"14.2.5\"},\n [{kernel, \"9.2.4\"},\n  {stdlib, \"5.2.3\"},\n  {sasl, \"4.2.1\"},\n  {ch_app, \"2\"}]\n}.\n```\n\nNow the `relup` file can be generated:\n\n```text\n1> systools:make_relup(\"ch_rel-2\", [\"ch_rel-1\"], [\"ch_rel-1\"]).\nok\n```\n\nThis generates a `relup` file with instructions for how to upgrade from version\n\"A\" (\"ch_rel-1\") to version \"B\" (\"ch_rel-2\") and how to downgrade from version\n\"B\" to version \"A\".\n\nBoth the old and new versions of the `.app` and `.rel` files must be in the code\npath, as well as the `.appup` and (new) `.beam` files. The code path can be\nextended by using the option `path`:\n\n```text\n1> systools:make_relup(\"ch_rel-2\", [\"ch_rel-1\"], [\"ch_rel-1\"],\n[{path,[\"../ch_rel-1\",\n\"../ch_rel-1/lib/ch_app-1/ebin\"]}]).\nok\n```\n\n[](){: #rel_handler }","title":"Release Upgrade File - Release Handling","ref":"release_handling.html#release-upgrade-file"},{"type":"extras","doc":"When you have made a new version of a release, a release package can be created\nwith this new version and transferred to the target environment.\n\nTo install the new version of the release in runtime, the _release\nhandler_ is used. This is a process belonging to the SASL application,\nwhich handles unpacking, installation, and removal of release\npackages. The `m:release_handler` module communicates with this process.\n\nAssuming there is an operational target system with installation root directory\n`$ROOT`, the release package with the new version of the release is to be copied\nto `$ROOT/releases`.\n\nFirst, _unpack_ the release package. The files are then extracted from the\npackage:\n\n```erlang\nrelease_handler:unpack_release(ReleaseName) => {ok, Vsn}\n```\n\n- `ReleaseName` is the name of the release package except the `.tar.gz`\n  extension.\n- `Vsn` is the version of the unpacked release, as defined in its `.rel` file.\n\nA directory `$ROOT/lib/releases/Vsn` is created, where the `.rel` file, the boot\nscript `start.boot`, the system configuration file `sys.config`, and `relup` are\nplaced. For applications with new version numbers, the application directories\nare placed under `$ROOT/lib`. Unchanged applications are not affected.\n\nAn unpacked release can be _installed_. The release handler then evaluates the\ninstructions in `relup`, step by step:\n\n```erlang\nrelease_handler:install_release(Vsn) => {ok, FromVsn, []}\n```\n\nIf an error occurs during the installation, the system is rebooted using the old\nversion of the release. If installation succeeds, the system is afterwards using\nthe new version of the release, but if anything happens and the system is\nrebooted, it starts using the previous version again.\n\nTo be made the default version, the newly installed release must be made\n_permanent_, which means the previous version becomes _old_:\n\n```text\nrelease_handler:make_permanent(Vsn) => ok\n```\n\nThe system keeps information about which versions are old and permanent in the\nfiles `$ROOT/releases/RELEASES` and `$ROOT/releases/start_erl.data`.\n\nTo downgrade from `Vsn` to `FromVsn`, `install_release` must be called again:\n\n```erlang\nrelease_handler:install_release(FromVsn) => {ok, Vsn, []}\n```\n\nAn installed, but not permanent, release can be _removed_. Information about the\nrelease is then deleted from `$ROOT/releases/RELEASES` and the release-specific\ncode, that is, the new application directories and the `$ROOT/releases/Vsn`\ndirectory, are removed.\n\n```text\nrelease_handler:remove_release(Vsn) => ok\n```","title":"Installing a Release - Release Handling","ref":"release_handling.html#installing-a-release"},{"type":"extras","doc":"_Step 1)_ Create a target system as described in System Principles of the first\nversion `\"A\"` of `ch_rel` from [Releases](release_structure.md#ch_rel). This\ntime `sys.config` must be included in the release package. If no configuration\nis needed, the file is to contain the empty list:\n\n```text\n[].\n```\n\n_Step 2)_ Start the system as a simple target system. In reality, it is to be\nstarted as an embedded system. However, using `erl` with the correct boot script\nand config file is enough for illustration purposes:\n\n```text\n% cd $ROOT\n% bin/erl -boot $ROOT/releases/A/start -config $ROOT/releases/A/sys\n...\n```\n\n`$ROOT` is the installation directory of the target system.\n\n_Step 3)_ In another Erlang shell, generate start scripts and create a release\npackage for the new version `\"B\"`. Remember to include (a possible updated)\n`sys.config` and the `relup` file. For more information, see\n[Release Upgrade File](release_handling.md#relup).\n\n```erlang\n1> systools:make_script(\"ch_rel-2\").\nok\n2> systools:make_tar(\"ch_rel-2\").\nok\n```\n\nThe new release package now also contains version \"2\" of `ch_app` and the\n`relup` file:\n\n```text\n% tar tf ch_rel-2.tar\nlib/kernel-9.2.4/ebin/kernel.app\nlib/kernel-9.2.4/ebin/application.beam\n...\nlib/stdlib-5.2.3/ebin/stdlib.app\nlib/stdlib-5.2.3/ebin/argparse.beam\n...\nlib/sasl-4.2.1/ebin/sasl.app\nlib/sasl-4.2.1/ebin/sasl.beam\n...\nlib/ch_app-2/ebin/ch_app.app\nlib/ch_app-2/ebin/ch_app.beam\nlib/ch_app-2/ebin/ch_sup.beam\nlib/ch_app-2/ebin/ch3.beam\nreleases/B/start.boot\nreleases/B/relup\nreleases/B/sys.config\nreleases/B/ch_rel-2.rel\nreleases/ch_rel-2.rel\n```\n\n_Step 4)_ Copy the release package `ch_rel-2.tar.gz` to the `$ROOT/releases`\ndirectory.\n\n_Step 5)_ In the running target system, unpack the release package:\n\n```erlang\n1> release_handler:unpack_release(\"ch_rel-2\").\n{ok,\"B\"}\n```\n\nThe new application version `ch_app-2` is installed under `$ROOT/lib` next to\n`ch_app-1`. The `kernel`, `stdlib`, and `sasl` directories are not affected, as\nthey have not changed.\n\nUnder `$ROOT/releases`, a new directory `B` is created, containing\n`ch_rel-2.rel`, `start.boot`, `sys.config`, and `relup`.\n\n_Step 6)_ Check if the function `ch3:available/0` is available:\n\n```erlang\n2> ch3:available().\n** exception error: undefined function ch3:available/0\n```\n\n_Step 7)_ Install the new release. The instructions in `$ROOT/releases/B/relup`\nare executed one by one, resulting in the new version of `ch3` being loaded. The\nfunction `ch3:available/0` is now available:\n\n```erlang\n3> release_handler:install_release(\"B\").\n{ok,\"A\",[]}\n4> ch3:available().\n3\n5> code:which(ch3).\n\".../lib/ch_app-2/ebin/ch3.beam\"\n6> code:which(ch_sup).\n\".../lib/ch_app-1/ebin/ch_sup.beam\"\n```\n\nProcesses in `ch_app` for which code have not been updated, for example, the\nsupervisor, are still evaluating code from `ch_app-1`.\n\n_Step 8)_ If the target system is now rebooted, it uses version \"A\" again. The\n\"B\" version must be made permanent, to be used when the system is rebooted.\n\n```erlang\n7> release_handler:make_permanent(\"B\").\nok\n```\n\n[](){: #sys }","title":"Example (continued from the previous sections) - Release Handling","ref":"release_handling.html#example-continued-from-the-previous-sections"},{"type":"extras","doc":"When a new version of a release is installed, the application specifications are\nautomatically updated for all loaded applications.\n\n> #### Note {: .info }\n>\n> The information about the new application specifications is fetched from the\n> boot script included in the release package. Thus, it is important that the\n> boot script is generated from the same `.rel` file as is used to build the\n> release package itself.\n\nSpecifically, the application configuration parameters are automatically updated\naccording to (in increasing priority order):\n\n- The data in the boot script, fetched from the new application resource file\n  `App.app`\n- The new `sys.config`\n- Command-line arguments `-App Par Val`\n\nThis means that parameter values set in the other system configuration files and\nvalues set using `application:set_env/3` are disregarded.\n\nWhen an installed release is made permanent, the system process `init` is set to\npoint out the new `sys.config`.\n\nAfter the installation, the application controller compares the old and new\nconfiguration parameters for all running applications and call the callback\nfunction:\n\n```erlang\nModule:config_change(Changed, New, Removed)\n```\n\n- `Module` is the application callback module as defined by the `mod` key in the\n  `.app` file.\n- `Changed` and `New` are lists of `{Par,Val}` for all changed and added\n  configuration parameters, respectively.\n- `Removed` is a list of all parameters `Par` that have been removed.\n\nThe function is optional and can be omitted when implementing an application\ncallback module.","title":"Updating Application Specifications - Release Handling","ref":"release_handling.html#updating-application-specifications"},{"type":"extras","doc":"<!--\n%CopyrightBegin%\n\nCopyright Ericsson AB 2023-2024. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# Appup Cookbook\n\n[](){: #appup-cookbook }\n\nThis section includes examples of `.appup` files for typical cases of\nupgrades/downgrades done in runtime.","title":"Appup Cookbook","ref":"appup_cookbook.html"},{"type":"extras","doc":"When a functional module has been changed, for example, if a new function has\nbeen added or a bug has been corrected, simple code replacement is sufficient,\nfor example:\n\n```erlang\n{\"2\",\n [{\"1\", [{load_module, m}]}],\n [{\"1\", [{load_module, m}]}]\n}.\n```","title":"Changing a Functional Module - Appup Cookbook","ref":"appup_cookbook.html#changing-a-functional-module"},{"type":"extras","doc":"In a system implemented according to the OTP design principles, all processes,\nexcept system processes and special processes, reside in one of the behaviours\n`m:supervisor`, `m:gen_server`, `m:gen_statem`, `m:gen_event`, or `m:gen_fsm`.\nThese belong to the STDLIB application and upgrading/downgrading normally\nrequires a runtime system restart.\n\nThus, OTP provides no support for changing residence modules except in the case\nof [special processes](appup_cookbook.md#spec).","title":"Changing a Residence Module - Appup Cookbook","ref":"appup_cookbook.html#changing-a-residence-module"},{"type":"extras","doc":"A callback module is a functional module, and for code extensions simple code\nreplacement is sufficient.\n\n_Example_\n\nWhen adding a function to `ch3`, as described in the example in\n[Release Handling](release_handling.md#appup), `ch_app.appup` looks as follows:\n\n```erlang\n{\"2\",\n [{\"1\", [{load_module, ch3}]}],\n [{\"1\", [{load_module, ch3}]}]\n}.\n```\n\nOTP also supports changing the internal state of behaviour processes; see\n[Changing Internal State](appup_cookbook.md#int_state).\n\n[](){: #int_state }","title":"Changing a Callback Module - Appup Cookbook","ref":"appup_cookbook.html#changing-a-callback-module"},{"type":"extras","doc":"In this case, simple code replacement is not sufficient. The process must\nexplicitly transform its state using the callback function `code_change/3` before\nswitching to the new version of the callback module. Thus, synchronized code\nreplacement is used.\n\n_Example_\n\nConsider the `ch3` module from\n[gen_server Behaviour](gen_server_concepts.md#ex). The internal state is a term\n`Chs` representing the available channels. Assume you want to add a counter `N`,\nwhich keeps track of the number of `alloc` requests so far. This means that the\nformat must be changed to `{Chs,N}`.\n\nThe `.appup` file can look as follows:\n\n```erlang\n{\"2\",\n [{\"1\", [{update, ch3, {advanced, []}}]}],\n [{\"1\", [{update, ch3, {advanced, []}}]}]\n}.\n```\n\nThe third element of the `update` instruction is a tuple `{advanced,Extra}`,\nwhich says that the affected processes are to do a state transformation before\nloading the new version of the module. This is done by the processes calling the\ncallback function `code_change/3` (see `m:gen_server` in STDLIB).\nThe term `Extra`, in this case `[]`, is passed as is to the function:\n\n[](){: #code_change }\n\n```erlang\n-module(ch3).\n...\n-export([code_change/3]).\n...\ncode_change({down, _Vsn}, {Chs, N}, _Extra) ->\n    {ok, Chs};\ncode_change(_Vsn, Chs, _Extra) ->\n    {ok, {Chs, 0}}.\n```\n\nThe first argument is `{down,Vsn}` if there is a downgrade, or `Vsn` if there is\na upgrade. The term `Vsn` is fetched from the 'original' version of the module,\nthat is, the version you are upgrading from, or downgrading to.\n\nThe version is defined by the module attribute `vsn`, if any. There is no such\nattribute in `ch3`, so in this case the version is the checksum (a huge integer)\nof the beam file, an uninteresting value, which is ignored.\n\nThe other callback functions of `ch3` must also be modified and perhaps a new\ninterface function must be added, but this is not shown here.","title":"Changing Internal State - Appup Cookbook","ref":"appup_cookbook.html#changing-internal-state"},{"type":"extras","doc":"Assume that a module is extended by adding an interface function, as in the\nexample in [Release Handling](release_handling.md#appup), where a function\n`available/0` is added to `ch3`.\n\nIf a call is added to this function, say in module `m1`, a runtime error could\ncan occur during release upgrade if the new version of `m1` is loaded first and\ncalls `ch3:available/0` before the new version of `ch3` is loaded.\n\nThus, `ch3` must be loaded before `m1`, in the upgrade case, and conversely in\nthe downgrade case. `m1` is said to be _dependent on_ `ch3`. In a release\nhandling instruction, this is expressed by the `DepMods` element:\n\n```erlang\n{load_module, Module, DepMods}\n{update, Module, {advanced, Extra}, DepMods}\n```\n\n`DepMods` is a list of modules, on which `Module` is dependent.\n\n_Example_\n\nThe module `m1` in application `myapp` is dependent on `ch3` when\nupgrading from \"1\" to \"2\", or downgrading from \"2\" to \"1\":\n\n```erlang\nmyapp.appup:\n\n{\"2\",\n [{\"1\", [{load_module, m1, [ch3]}]}],\n [{\"1\", [{load_module, m1, [ch3]}]}]\n}.\n\nch_app.appup:\n\n{\"2\",\n [{\"1\", [{load_module, ch3}]}],\n [{\"1\", [{load_module, ch3}]}]\n}.\n```\n\nIf instead `m1` and `ch3` belong to the same application, the `.appup` file can\nlook as follows:\n\n```erlang\n{\"2\",\n [{\"1\",\n   [{load_module, ch3},\n    {load_module, m1, [ch3]}]}],\n [{\"1\",\n   [{load_module, ch3},\n    {load_module, m1, [ch3]}]}]\n}.\n```\n\n`m1` is dependent on `ch3` also when downgrading. `systools` knows the\ndifference between up- and downgrading and generates a correct `relup`, where\n`ch3` is loaded before `m1` when upgrading, but `m1` is loaded before `ch3` when\ndowngrading.\n\n[](){: #spec }","title":"Module Dependencies - Appup Cookbook","ref":"appup_cookbook.html#module-dependencies"},{"type":"extras","doc":"In this case, simple code replacement is not sufficient. When a new version of a\nresidence module for a special process is loaded, the process must make a fully\nqualified call to its loop function to switch to the new code. Thus,\nsynchronized code replacement must be used.\n\n> #### Note {: .info }\n>\n> The name(s) of the user-defined residence module(s) must be listed in the\n> `Modules` part of the child specification for the special process. Otherwise\n> the release handler cannot find the process.\n\n_Example_\n\nConsider the example `ch4` in [sys and proc_lib](spec_proc.md#ex).\nWhen started by a supervisor, the child specification can look as follows:\n\n```erlang\n{ch4, {ch4, start_link, []},\n permanent, brutal_kill, worker, [ch4]}\n```\n\nIf `ch4` is part of the application `sp_app` and a new version of the module is\nto be loaded when upgrading from version \"1\" to \"2\" of this application,\n`sp_app.appup` can look as follows:\n\n```erlang\n{\"2\",\n [{\"1\", [{update, ch4, {advanced, []}}]}],\n [{\"1\", [{update, ch4, {advanced, []}}]}]\n}.\n```\n\nThe `update` instruction must contain the tuple `{advanced,Extra}`. The\ninstruction makes the special process call the callback function\n`system_code_change/4`, a function the user must implement. The term `Extra`, in\nthis case `[]`, is passed as is to `system_code_change/4`:\n\n```erlang\n-module(ch4).\n...\n-export([system_code_change/4]).\n...\n\nsystem_code_change(Chs, _Module, _OldVsn, _Extra) ->\n    {ok, Chs}.\n```\n\n- The first argument is the internal state `State`, passed from\n  function [`sys:handle_system_msg(Request, From, Parent, Module, Deb,\n  State)`](`sys:handle_system_msg/6`), and called by the special\n  process when a system message is received. In `ch4`, the internal\n  state is the set of available channels `Chs`.\n- The second argument is the name of the module (`ch4`).\n- The third argument is `Vsn` or `{down,Vsn}`, as described for\n  `c:gen_server:code_change/3` in\n  [Changing Internal State](appup_cookbook.md#code_change).\n\nIn this case, all arguments but the first are ignored and the function simply\nreturns the internal state again. This is enough if the code only has been\nextended. If instead the internal state is changed (similar to the example in\n[Changing Internal State](appup_cookbook.md#int_state)), this is done in this\nfunction and `{ok,Chs2}` returned.\n\n[](){: #sup }","title":"Changing Code for a Special Process - Appup Cookbook","ref":"appup_cookbook.html#changing-code-for-a-special-process"},{"type":"extras","doc":"The supervisor behaviour supports changing the internal state, that is, changing\nthe restart strategy and maximum restart frequency properties, as well as\nchanging the existing child specifications.\n\nChild processes can be added or deleted, but this is not handled automatically.\nInstructions must be given by in the `.appup` file.","title":"Changing a Supervisor - Appup Cookbook","ref":"appup_cookbook.html#changing-a-supervisor"},{"type":"extras","doc":"Since the supervisor is to change its internal state, synchronized code\nreplacement is required. However, a special `update` instruction must be used.\n\nFirst, the new version of the callback module must be loaded, both in the case\nof upgrade and downgrade. Then the new return value of `init/1` can be checked\nand the internal state be changed accordingly.\n\nThe following `upgrade` instruction is used for supervisors:\n\n```text\n{update, Module, supervisor}\n```\n\n_Example_\n\nTo change the restart strategy of `ch_sup` (from\n[Supervisor Behaviour](sup_princ.md#ex)) from `one_for_one` to `one_for_all`,\nchange the callback function `init/1` in `ch_sup.erl`:\n\n```erlang\n-module(ch_sup).\n...\n\ninit(_Args) ->\n    {ok, {#{strategy => one_for_all, ...}, ...}}.\n```\n\nThe file `ch_app.appup`:\n\n```erlang\n{\"2\",\n [{\"1\", [{update, ch_sup, supervisor}]}],\n [{\"1\", [{update, ch_sup, supervisor}]}]\n}.\n```","title":"Changing Properties - Appup Cookbook","ref":"appup_cookbook.html#changing-properties"},{"type":"extras","doc":"The instruction, and thus the `.appup` file, when changing an existing child\nspecification, is the same as when changing properties as described earlier:\n\n```erlang\n{\"2\",\n [{\"1\", [{update, ch_sup, supervisor}]}],\n [{\"1\", [{update, ch_sup, supervisor}]}]\n}.\n```\n\nThe changes do not affect existing child processes. For example, changing the\nstart function only specifies how the child process is to be restarted, if\nneeded later on.\n\nThe id of the child specification cannot be changed.\n\nChanging the `Modules` field of the child specification can affect the release\nhandling process itself, as this field is used to identify which processes are\naffected when doing a synchronized code replacement.\n\n[](){: #sup_add }","title":"Changing Child Specifications - Appup Cookbook","ref":"appup_cookbook.html#changing-child-specifications"},{"type":"extras","doc":"As stated earlier, changing child specifications does not affect existing child\nprocesses. New child specifications are automatically added, but not deleted.\nChild processes are not automatically started or terminated, this must be done\nusing `apply` instructions.\n\n_Example_\n\nAssume a new child process `m1` is to be added to `ch_sup` when\nupgrading `ch_app` from \"1\" to \"2\". This means `m1` is to be deleted when\ndowngrading from \"2\" to \"1\":\n\n```erlang\n{\"2\",\n [{\"1\",\n   [{update, ch_sup, supervisor},\n    {apply, {supervisor, restart_child, [ch_sup, m1]}}\n   ]}],\n [{\"1\",\n   [{apply, {supervisor, terminate_child, [ch_sup, m1]}},\n    {apply, {supervisor, delete_child, [ch_sup, m1]}},\n    {update, ch_sup, supervisor}\n   ]}]\n}.\n```\n\nThe order of the instructions is important.\n\nThe supervisor must be registered as `ch_sup` for the script to work. If the\nsupervisor is not registered, it cannot be accessed directly from the script.\nInstead a help function that finds the pid of the supervisor and calls\n`supervisor:restart_child`, and so on, must be written. This function is then to\nbe called from the script using the `apply` instruction.\n\nIf the module `m1` is introduced in version \"2\" of `ch_app`, it must also be\nloaded when upgrading and deleted when downgrading:\n\n```erlang\n{\"2\",\n [{\"1\",\n   [{add_module, m1},\n    {update, ch_sup, supervisor},\n    {apply, {supervisor, restart_child, [ch_sup, m1]}}\n   ]}],\n [{\"1\",\n   [{apply, {supervisor, terminate_child, [ch_sup, m1]}},\n    {apply, {supervisor, delete_child, [ch_sup, m1]}},\n    {update, ch_sup, supervisor},\n    {delete_module, m1}\n   ]}]\n}.\n```\n\nAs stated earlier, the order of the instructions is important. When upgrading,\n`m1` must be loaded, and the supervisor child specification changed, before the\nnew child process can be started. When downgrading, the child process must be\nterminated before the child specification is changed and the module is deleted.","title":"Adding and Deleting Child Processes - Appup Cookbook","ref":"appup_cookbook.html#adding-and-deleting-child-processes"},{"type":"extras","doc":"_Example\n\n_ A new functional module `m` is added to `ch_app`:\n\n```erlang\n{\"2\",\n [{\"1\", [{add_module, m}]}],\n [{\"1\", [{delete_module, m}]}]\n```","title":"Adding or Deleting a Module - Appup Cookbook","ref":"appup_cookbook.html#adding-or-deleting-a-module"},{"type":"extras","doc":"In a system structured according to the OTP design principles, any process would\nbe a child process belonging to a supervisor, see\n[Adding and Deleting Child Processes](appup_cookbook.md#sup_add) in Changing a\nSupervisor.","title":"Starting or Terminating a Process - Appup Cookbook","ref":"appup_cookbook.html#starting-or-terminating-a-process"},{"type":"extras","doc":"When adding or removing an application, no `.appup` file is needed. When\ngenerating `relup`, the `.rel` files are compared and the `add_application` and\n`remove_application` instructions are added automatically.","title":"Adding or Removing an Application - Appup Cookbook","ref":"appup_cookbook.html#adding-or-removing-an-application"},{"type":"extras","doc":"Restarting an application is useful when a change is too complicated to be made\nwithout restarting the processes, for example, if the supervisor hierarchy has\nbeen restructured.\n\n_Example_\n\nWhen adding a child `m1` to `ch_sup`, as in\n[Adding and Deleting Child Processes](appup_cookbook.md#sup_add) in Changing a\nSupervisor, an alternative to updating the supervisor is to restart the entire\napplication:\n\n```erlang\n{\"2\",\n [{\"1\", [{restart_application, ch_app}]}],\n [{\"1\", [{restart_application, ch_app}]}]\n}.\n```\n\n[](){: #app_spec }","title":"Restarting an Application - Appup Cookbook","ref":"appup_cookbook.html#restarting-an-application"},{"type":"extras","doc":"When installing a release, the application specifications are automatically\nupdated before evaluating the `relup` script. Thus, no instructions are needed\nin the `.appup` file:\n\n```erlang\n{\"2\",\n [{\"1\", []}],\n [{\"1\", []}]\n}.\n```","title":"Changing an Application Specification - Appup Cookbook","ref":"appup_cookbook.html#changing-an-application-specification"},{"type":"extras","doc":"Changing an application configuration by updating the `env` key in the `.app`\nfile is an instance of changing an application specification, see the previous\nsection.\n\nAlternatively, application configuration parameters can be added or updated in\n`sys.config`.","title":"Changing Application Configuration - Appup Cookbook","ref":"appup_cookbook.html#changing-application-configuration"},{"type":"extras","doc":"The release handling instructions for adding, removing, and restarting\napplications apply to primary applications only. There are no corresponding\ninstructions for included applications. However, since an included application\nis really a supervision tree with a topmost supervisor, started as a child\nprocess to a supervisor in the including application, a `.relup` file can be\nmanually created.\n\n_Example_\n\nAssume there is a release containing an application `prim_app`, which\nhave a supervisor `prim_sup` in its supervision tree.\n\nIn a new version of the release, the application `ch_app` is to be included in\n`prim_app`. That is, its topmost supervisor `ch_sup` is to be started as a child\nprocess to `prim_sup`.\n\nThe workflow is as follows:\n\n_Step 1)_ Edit the code for `prim_sup`:\n\n```erlang\ninit(...) ->\n    {ok, {...supervisor flags...,\n          [...,\n           {ch_sup, {ch_sup,start_link,[]},\n            permanent,infinity,supervisor,[ch_sup]},\n           ...]}}.\n```\n\n_Step 2)_ Edit the `.app` file for `prim_app`:\n\n```erlang\n{application, prim_app,\n [...,\n  {vsn, \"2\"},\n  ...,\n  {included_applications, [ch_app]},\n  ...\n ]}.\n```\n\n_Step 3)_ Create a new `.rel` file, including `ch_app`:\n\n```text\n{release,\n ...,\n [...,\n  {prim_app, \"2\"},\n  {ch_app, \"1\"}]}.\n```\n\nThe included application can be started in two ways. This is described in the\nnext two sections.","title":"Changing Included Applications - Appup Cookbook","ref":"appup_cookbook.html#changing-included-applications"},{"type":"extras","doc":"_Step 4a)_ One way to start the included application is to restart the entire\n`prim_app` application. Normally, the `restart_application` instruction in the\n`.appup` file for `prim_app` would be used.\n\nHowever, if this is done and a `.relup` file is generated, not only would it\ncontain instructions for restarting (that is, removing and adding) `prim_app`,\nit would also contain instructions for starting `ch_app` (and stopping it, in\nthe case of downgrade). This is because `ch_app` is included in the new `.rel`\nfile, but not in the old one.\n\nInstead, a correct `relup` file can be created manually, either from scratch or\nby editing the generated version. The instructions for starting/stopping\n`ch_app` are replaced by instructions for loading/unloading the application:\n\n```c\n{\"B\",\n [{\"A\",\n   [],\n   [{load_object_code,{ch_app,\"1\",[ch_sup,ch3]}},\n    {load_object_code,{prim_app,\"2\",[prim_app,prim_sup]}},\n    point_of_no_return,\n    {apply,{application,stop,[prim_app]}},\n    {remove,{prim_app,brutal_purge,brutal_purge}},\n    {remove,{prim_sup,brutal_purge,brutal_purge}},\n    {purge,[prim_app,prim_sup]},\n    {load,{prim_app,brutal_purge,brutal_purge}},\n    {load,{prim_sup,brutal_purge,brutal_purge}},\n    {load,{ch_sup,brutal_purge,brutal_purge}},\n    {load,{ch3,brutal_purge,brutal_purge}},\n    {apply,{application,load,[ch_app]}},\n    {apply,{application,start,[prim_app,permanent]}}]}],\n [{\"A\",\n   [],\n   [{load_object_code,{prim_app,\"1\",[prim_app,prim_sup]}},\n    point_of_no_return,\n    {apply,{application,stop,[prim_app]}},\n    {apply,{application,unload,[ch_app]}},\n    {remove,{ch_sup,brutal_purge,brutal_purge}},\n    {remove,{ch3,brutal_purge,brutal_purge}},\n    {purge,[ch_sup,ch3]},\n    {remove,{prim_app,brutal_purge,brutal_purge}},\n    {remove,{prim_sup,brutal_purge,brutal_purge}},\n    {purge,[prim_app,prim_sup]},\n    {load,{prim_app,brutal_purge,brutal_purge}},\n    {load,{prim_sup,brutal_purge,brutal_purge}},\n    {apply,{application,start,[prim_app,permanent]}}]}]\n}.\n```","title":"Application Restart - Appup Cookbook","ref":"appup_cookbook.html#application-restart"},{"type":"extras","doc":"_Step 4b)_ Another way to start the included application (or stop it in the case\nof downgrade) is by combining instructions for adding and removing child\nprocesses to/from `prim_sup` with instructions for loading/unloading all\n`ch_app` code and its application specification.\n\nAgain, the `.relup` file is created manually, either from scratch or by editing a\ngenerated version. Load all code for `ch_app` first, and also load the\napplication specification, before `prim_sup` is updated. When downgrading,\n`prim_sup` is to updated first, before the code for `ch_app` and its application\nspecification are unloaded.\n\n```erlang\n{\"B\",\n [{\"A\",\n   [],\n   [{load_object_code,{ch_app,\"1\",[ch_sup,ch3]}},\n    {load_object_code,{prim_app,\"2\",[prim_sup]}},\n    point_of_no_return,\n    {load,{ch_sup,brutal_purge,brutal_purge}},\n    {load,{ch3,brutal_purge,brutal_purge}},\n    {apply,{application,load,[ch_app]}},\n    {suspend,[prim_sup]},\n    {load,{prim_sup,brutal_purge,brutal_purge}},\n    {code_change,up,[{prim_sup,[]}]},\n    {resume,[prim_sup]},\n    {apply,{supervisor,restart_child,[prim_sup,ch_sup]}}]}],\n [{\"A\",\n   [],\n   [{load_object_code,{prim_app,\"1\",[prim_sup]}},\n    point_of_no_return,\n    {apply,{supervisor,terminate_child,[prim_sup,ch_sup]}},\n    {apply,{supervisor,delete_child,[prim_sup,ch_sup]}},\n    {suspend,[prim_sup]},\n    {load,{prim_sup,brutal_purge,brutal_purge}},\n    {code_change,down,[{prim_sup,[]}]},\n    {resume,[prim_sup]},\n    {remove,{ch_sup,brutal_purge,brutal_purge}},\n    {remove,{ch3,brutal_purge,brutal_purge}},\n    {purge,[ch_sup,ch3]},\n    {apply,{application,unload,[ch_app]}}]}]\n}.\n```","title":"Supervisor Change - Appup Cookbook","ref":"appup_cookbook.html#supervisor-change"},{"type":"extras","doc":"Changing code for a program written in another programming language than Erlang,\nfor example, a port program, is application-dependent and OTP provides no\nspecial support.\n\n_Example_\n\nWhen changing code for a port program, assume that the Erlang process\ncontrolling the port is a `gen_server` `portc` and that the port is opened in\nthe callback function `init/1`:\n\n```erlang\ninit(...) ->\n    ...,\n    PortPrg = filename:join(code:priv_dir(App), \"portc\"),\n    Port = open_port({spawn,PortPrg}, [...]),\n    ...,\n    {ok, #state{port=Port, ...}}.\n```\n\nIf the port program is to be updated, the code for the `gen_server` can be\nextended with a `code_change/3` function, which closes the old port and opens a\nnew port. (If necessary, the `gen_server` can first request data that must be\nsaved from the port program and pass this data to the new port):\n\n```erlang\ncode_change(_OldVsn, State, port) ->\n    State#state.port ! close,\n    receive\n        {Port,close} ->\n            true\n    end,\n    PortPrg = filename:join(code:priv_dir(App), \"portc\"),\n    Port = open_port({spawn,PortPrg}, [...]),\n    {ok, #state{port=Port, ...}}.\n```\n\nUpdate the application version number in the `.app` file and write an `.appup`\nfile:\n\n```erlang\n[\"2\",\n [{\"1\", [{update, portc, {advanced,port}}]}],\n [{\"1\", [{update, portc, {advanced,port}}]}]\n].\n```\n\nEnsure that the `priv` directory, where the C program is located, is included in\nthe new release package:\n\n```erlang\n1> systools:make_tar(\"my_release\", [{dirs,[priv]}]).\n...\n```","title":"Changing Non-Erlang Code - Appup Cookbook","ref":"appup_cookbook.html#changing-non-erlang-code"},{"type":"extras","doc":"Two upgrade instructions restart the runtime system:\n\n- `restart_new_emulator`\n\n  Intended when ERTS, Kernel, STDLIB, or SASL is upgraded. It is automatically\n  added when the `relup` file is generated by `systools:make_relup/3,4`. It is\n  executed before all other upgrade instructions. For more information about\n  this instruction, see restart_new_emulator (Low-Level) in\n  [Release Handling Instructions](release_handling.md#restart_new_emulator_instr).\n\n- `restart_emulator`\n\n  Used when a restart of the runtime system is required after all other upgrade\n  instructions are executed. For more information about this instruction, see\n  restart_emulator (Low-Level) in\n  [Release Handling Instructions](release_handling.md#restart_emulator_instr).\n\nIf a runtime system restart is necessary and no upgrade instructions are needed,\nthat is, if the restart itself is enough for the upgraded applications to start\nrunning the new versions, a simple `.relup` file can be created manually:\n\n```erlang\n{\"B\",\n [{\"A\",\n   [],\n   [restart_emulator]}],\n [{\"A\",\n   [],\n   [restart_emulator]}]\n}.\n```\n\nIn this case, the release handler framework with automatic packing and unpacking\nof release packages, automatic path updates, and so on, can be used without\nhaving to specify `.appup` files.","title":"Runtime System Restart and Upgrade - Appup Cookbook","ref":"appup_cookbook.html#runtime-system-restart-and-upgrade"},{"type":"extras","doc":"# Introduction\n\n[](){: #programming-examples }\n\nThis section contains examples on using records, funs, list comprehensions, and\nthe bit syntax.","title":"Introduction","ref":"programming_examples.html"},{"type":"extras","doc":"<!--\n%CopyrightBegin%\n\nCopyright Ericsson AB 2023-2024. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# Records","title":"Records","ref":"prog_ex_records.html"},{"type":"extras","doc":"The main advantage of using records rather than tuples is that fields in a\nrecord are accessed by name, whereas fields in a tuple are accessed by position.\nTo illustrate these differences, suppose that you want to represent a person\nwith the tuple `{Name, Address, Phone}`.\n\nTo write functions that manipulate this data, remember the following:\n\n- The `Name` field is the first element of the tuple.\n- The `Address` field is the second element.\n- The `Phone` field is the third element.\n\nFor example, to extract data from a variable `P` that contains such a tuple, you\ncan write the following code and then use pattern matching to extract the\nrelevant fields:\n\n```erlang\nName = element(1, P),\nAddress = element(2, P),\n...\n```\n\nSuch code is difficult to read and understand, and errors occur if the numbering\nof the elements in the tuple is wrong. If the data representation of the fields\nis changed, by re-ordering, adding, or removing fields, all references to the\nperson tuple must be checked and possibly modified.\n\nRecords allow references to the fields by name, instead of by position. In the\nfollowing example, a record instead of a tuple is used to store the data:\n\n```erlang\n-record(person, {name, phone, address}).\n```\n\nThis enables references to the fields of the record by name. For example, if `P`\nis a variable whose value is a `person` record, the following code access the\nname and address fields of the records:\n\n```erlang\nName = P#person.name,\nAddress = P#person.address,\n...\n```\n\nInternally, records are represented using tagged tuples:\n\n```erlang\n{person, Name, Phone, Address}\n```","title":"Records and Tuples - Records","ref":"prog_ex_records.html#records-and-tuples"},{"type":"extras","doc":"This following definition of a `person` is used in several examples in this\nsection. Three fields are included, `name`, `phone`, and `address`. The default\nvalues for `name` and `phone` is \"\" and [], respectively. The default value for\n`address` is the atom `undefined`, since no default value is supplied for this\nfield:\n\n```erlang\n-record(person, {name = \"\", phone = [], address}).\n```\n\nThe record must be defined in the shell to enable use of the record syntax in\nthe examples:\n\n```erlang\n> rd(person, {name = \"\", phone = [], address}).\nperson\n```\n\nThis is because record definitions are only available at compile time, not at\nruntime. For details on records in the shell, see the `m:shell` manual page in\nSTDLIB.","title":"Defining a Record - Records","ref":"prog_ex_records.html#defining-a-record"},{"type":"extras","doc":"A new `person` record is created as follows:\n\n```erlang\n> #person{phone=[0,8,2,3,4,3,1,2], name=\"Robert\"}.\n#person{name = \"Robert\",phone = [0,8,2,3,4,3,1,2],address = undefined}\n```\n\nAs the `address` field was omitted, its default value is used.\n\nFrom Erlang 5.1/OTP R8B, a value to all fields in a record can be set with the\nspecial field `_`. `_` means \"all fields not explicitly specified\".\n\n_Example:_\n\n```erlang\n> #person{name = \"Jakob\", _ = '_'}.\n#person{name = \"Jakob\",phone = '_',address = '_'}\n```\n\nIt is primarily intended to be used in `ets:match/2` and\n`mnesia:match_object/3`, to set record fields to the atom `'_'`. (This is a\nwildcard in `ets:match/2`.)","title":"Creating a Record - Records","ref":"prog_ex_records.html#creating-a-record"},{"type":"extras","doc":"The following example shows how to access a record field:\n\n```erlang\n> P = #person{name = \"Joe\", phone = [0,8,2,3,4,3,1,2]}.\n#person{name = \"Joe\",phone = [0,8,2,3,4,3,1,2],address = undefined}\n> P#person.name.\n\"Joe\"\n```","title":"Accessing a Record Field - Records","ref":"prog_ex_records.html#accessing-a-record-field"},{"type":"extras","doc":"The following example shows how to update a record:\n\n```erlang\n> P1 = #person{name=\"Joe\", phone=[1,2,3], address=\"A street\"}.\n#person{name = \"Joe\",phone = [1,2,3],address = \"A street\"}\n> P2 = P1#person{name=\"Robert\"}.\n#person{name = \"Robert\",phone = [1,2,3],address = \"A street\"}\n```","title":"Updating a Record - Records","ref":"prog_ex_records.html#updating-a-record"},{"type":"extras","doc":"The following example shows that the guard succeeds if `P` is record of type\n`person`:\n\n```erlang\nfoo(P) when is_record(P, person) -> a_person;\nfoo(_) -> not_a_person.\n```","title":"Type Testing - Records","ref":"prog_ex_records.html#type-testing"},{"type":"extras","doc":"Matching can be used in combination with records, as shown in the following\nexample:\n\n```erlang\n> P3 = #person{name=\"Joe\", phone=[0,0,7], address=\"A street\"}.\n#person{name = \"Joe\",phone = [0,0,7],address = \"A street\"}\n> #person{name = Name} = P3, Name.\n\"Joe\"\n```\n\nThe following function takes a list of `person` records and searches for the\nphone number of a person with a particular name:\n\n```erlang\nfind_phone([#person{name=Name, phone=Phone} | _], Name) ->\n    {found,  Phone};\nfind_phone([_| T], Name) ->\n    find_phone(T, Name);\nfind_phone([], Name) ->\n    not_found.\n```\n\nThe fields referred to in the pattern can be given in any order.","title":"Pattern Matching - Records","ref":"prog_ex_records.html#pattern-matching"},{"type":"extras","doc":"The value of a field in a record can be an instance of a record. Retrieval of\nnested data can be done stepwise, or in a single step, as shown in the following\nexample:\n\n```erlang\n-record(name, {first = \"Robert\", last = \"Ericsson\"}).\n-record(person, {name = #name{}, phone}).\n\ndemo() ->\n  P = #person{name= #name{first=\"Robert\",last=\"Virding\"}, phone=123},\n  First = (P#person.name)#name.first.\n```\n\nHere, `demo()` evaluates to `\"Robert\"`.","title":"Nested Records - Records","ref":"prog_ex_records.html#nested-records"},{"type":"extras","doc":"Comments are embedded in the following example:\n\n```erlang\n%% File: person.hrl\n\n%%-----------------------------------------------------------\n%% Data Type: person\n%% where:\n%%    name:  A string (default is undefined).\n%%    age:   An integer (default is undefined).\n%%    phone: A list of integers (default is []).\n%%    dict:  A dictionary containing various information\n%%           about the person.\n%%           A {Key, Value} list (default is the empty list).\n%%------------------------------------------------------------\n-record(person, {name, age, phone = [], dict = []}).\n```\n\n```erlang\n-module(person).\n-include(\"person.hrl\").\n-compile(export_all). % For test purposes only.\n\n%% This creates an instance of a person.\n%%   Note: The phone number is not supplied so the\n%%         default value [] will be used.\n\nmake_hacker_without_phone(Name, Age) ->\n   #person{name = Name, age = Age,\n           dict = [{computer_knowledge, excellent},\n                   {drinks, coke}]}.\n\n%% This demonstrates matching in arguments\n\nprint(#person{name = Name, age = Age,\n              phone = Phone, dict = Dict}) ->\n  io:format(\"Name: ~s, Age: ~w, Phone: ~w ~n\"\n            \"Dictionary: ~w.~n\", [Name, Age, Phone, Dict]).\n\n%% Demonstrates type testing, selector, updating.\n\nbirthday(P) when is_record(P, person) ->\n   P#person{age = P#person.age + 1}.\n\nregister_two_hackers() ->\n   Hacker1 = make_hacker_without_phone(\"Joe\", 29),\n   OldHacker = birthday(Hacker1),\n   % The central_register_server should have\n   % an interface function for this.\n   central_register_server ! {register_person, Hacker1},\n   central_register_server ! {register_person,\n             OldHacker#person{name = \"Robert\",\n                              phone = [0,8,3,2,4,5,3,1]}}.\n```","title":"A Longer Example - Records","ref":"prog_ex_records.html#a-longer-example"},{"type":"extras","doc":"<!--\n%CopyrightBegin%\n\nCopyright Ericsson AB 2023-2024. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# Funs","title":"Funs","ref":"funs.html"},{"type":"extras","doc":"The following function, `double`, doubles every element in a list:\n\n```erlang\ndouble([H|T]) -> [2*H|double(T)];\ndouble([])    -> [].\n```\n\nHence, the argument entered as input is doubled as follows:\n\n```erlang\n> double([1,2,3,4]).\n[2,4,6,8]\n```\n\nThe following function, `add_one`, adds one to every element in a list:\n\n```erlang\nadd_one([H|T]) -> [H+1|add_one(T)];\nadd_one([])    -> [].\n```\n\nThe functions `double` and `add_one` have a similar structure. This can be used\nby writing a function `map` that expresses this similarity:\n\n```erlang\nmap(F, [H|T]) -> [F(H)|map(F, T)];\nmap(F, [])    -> [].\n```\n\nThe functions `double` and `add_one` can now be expressed in terms of `map` as\nfollows:\n\n```erlang\ndouble(L)  -> map(fun(X) -> 2*X end, L).\nadd_one(L) -> map(fun(X) -> 1 + X end, L).\n```\n\n`map(F, List)` is a function that takes a function `F` and a list `L` as\narguments and returns a new list, obtained by applying `F` to each of the\nelements in `L`.\n\nThe process of abstracting out the common features of a number of different\nprograms is called _procedural abstraction_. Procedural abstraction can be used\nto write several different functions that have a similar structure, but differ\nin some minor detail. This is done as follows:\n\n1. _Step 1._ Write one function that represents the common features of these\n   functions.\n1. _Step 2._ Parameterize the difference in terms of functions that are passed\n   as arguments to the common function.","title":"map - Funs","ref":"funs.html#map"},{"type":"extras","doc":"This section illustrates procedural abstraction. Initially, the following two\nexamples are written as conventional functions.\n\nThis function prints all elements of a list onto a stream:\n\n```erlang\nprint_list(Stream, [H|T]) ->\n    io:format(Stream, \"~p~n\", [H]),\n    print_list(Stream, T);\nprint_list(Stream, []) ->\n    true.\n```\n\nThis function broadcasts a message to a list of processes:\n\n```erlang\nbroadcast(Msg, [Pid|Pids]) ->\n    Pid ! Msg,\n    broadcast(Msg, Pids);\nbroadcast(_, []) ->\n    true.\n```\n\nThese two functions have a similar structure. They both iterate over a list and\ndo something to each element in the list. The \"something\" is passed on as an\nextra argument to the function that does this.\n\nThe function `foreach` expresses this similarity:\n\n```erlang\nforeach(F, [H|T]) ->\n    F(H),\n    foreach(F, T);\nforeach(F, []) ->\n    ok.\n```\n\nUsing the function `foreach`, the function `print_list` becomes:\n\n```erlang\nforeach(fun(H) -> io:format(S, \"~p~n\",[H]) end, L)\n```\n\nUsing the function `foreach`, the function `broadcast` becomes:\n\n```erlang\nforeach(fun(Pid) -> Pid ! M end, L)\n```\n\n`foreach` is evaluated for its side-effect and not its value. `foreach(Fun ,L)`\ncalls `Fun(X)` for each element `X` in `L` and the processing occurs in the\norder that the elements were defined in `L`. `map` does not define the order in\nwhich its elements are processed.","title":"foreach - Funs","ref":"funs.html#foreach"},{"type":"extras","doc":"Funs are written with the following syntax (see\n[Fun Expressions ](`e:system:expressions.md#fun-expressions`)for full description):\n\n```erlang\nF = fun (Arg1, Arg2, ... ArgN) ->\n        ...\n    end\n```\n\nThis creates an anonymous function of `N` arguments and binds it to the variable\n`F`.\n\nAnother function, `FunctionName`, written in the same module, can be passed as\nan argument, using the following syntax:\n\n```erlang\nF = fun FunctionName/Arity\n```\n\nWith this form of function reference, the function that is referred to does not\nneed to be exported from the module.\n\nIt is also possible to refer to a function defined in a different module, with\nthe following syntax:\n\n```erlang\nF = fun Module:FunctionName/Arity\n```\n\nIn this case, the function must be exported from the module in question.\n\nThe following program illustrates the different ways of creating funs:\n\n```erlang\n-module(fun_test).\n-export([t1/0, t2/0]).\n-import(lists, [map/2]).\n\nt1() -> map(fun(X) -> 2 * X end, [1,2,3,4,5]).\n\nt2() -> map(fun double/1, [1,2,3,4,5]).\n\ndouble(X) -> X * 2.\n```\n\nThe fun `F` can be evaluated with the following syntax:\n\n```erlang\nF(Arg1, Arg2, ..., Argn)\n```\n\nTo check whether a term is a fun, use the test\n[`is_function/1`](`is_function/1`) in a guard.\n\n_Example:_\n\n```erlang\nf(F, Args) when is_function(F) ->\n   apply(F, Args);\nf(N, _) when is_integer(N) ->\n   N.\n```\n\nFuns are a distinct type. The BIFs `erlang:fun_info/1,2` can be used to retrieve\ninformation about a fun, and the BIF `erlang:fun_to_list/1` returns a textual\nrepresentation of a fun. The [`check_process_code/2`](`check_process_code/2`)\nBIF returns `true` if the process contains funs that depend on the old version\nof a module.","title":"Syntax of Funs - Funs","ref":"funs.html#syntax-of-funs"},{"type":"extras","doc":"The scope rules for variables that occur in funs are as follows:\n\n- All variables that occur in the head of a fun are assumed to be \"fresh\"\n  variables.\n- Variables that are defined before the fun, and that occur in function calls or\n  guard tests within the fun, have the values they had outside the fun.\n- Variables cannot be exported from a fun.\n\nThe following examples illustrate these rules:\n\n```erlang\nprint_list(File, List) ->\n    {ok, Stream} = file:open(File, write),\n    foreach(fun(X) -> io:format(Stream,\"~p~n\",[X]) end, List),\n    file:close(Stream).\n```\n\nHere, the variable `X`, defined in the head of the fun, is a new variable. The\nvariable `Stream`, which is used within the fun, gets its value from the\n`file:open` line.\n\nAs any variable that occurs in the head of a fun is considered a new variable,\nit is equally valid to write as follows:\n\n```erlang\nprint_list(File, List) ->\n    {ok, Stream} = file:open(File, write),\n    foreach(fun(File) ->\n                io:format(Stream,\"~p~n\",[File])\n            end, List),\n    file:close(Stream).\n```\n\nHere, `File` is used as the new variable instead of `X`. This is not so wise\nbecause code in the fun body cannot refer to the variable `File`, which is\ndefined outside of the fun. Compiling this example gives the following\ndiagnostic:\n\n```text\n./FileName.erl:Line: Warning: variable 'File'\n      shadowed in 'fun'\n```\n\nThis indicates that the variable `File`, which is defined inside the fun,\ncollides with the variable `File`, which is defined outside the fun.\n\nThe rules for importing variables into a fun has the consequence that certain\npattern matching operations must be moved into guard expressions and cannot be\nwritten in the head of the fun. For example, you might write the following code\nif you intend the first clause of `F` to be evaluated when the value of its\nargument is `Y`:\n\n```erlang\nf(...) ->\n    Y = ...\n    map(fun(X) when X == Y ->\n             ;\n           (_) ->\n             ...\n        end, ...)\n    ...\n```\n\ninstead of writing the following code:\n\n```erlang\nf(...) ->\n    Y = ...\n    map(fun(Y) ->\n             ;\n           (_) ->\n             ...\n        end, ...)\n    ...\n```","title":"Variable Bindings Within a Fun - Funs","ref":"funs.html#variable-bindings-within-a-fun"},{"type":"extras","doc":"The following examples show a dialogue with the Erlang shell. All the higher\norder functions discussed are exported from the module `m:lists`.","title":"Funs and Module Lists - Funs","ref":"funs.html#funs-and-module-lists"},{"type":"extras","doc":"`lists:map/2` takes a function of one argument and a list of terms:\n\n```erlang\nmap(F, [H|T]) -> [F(H)|map(F, T)];\nmap(F, [])    -> [].\n```\n\nIt returns the list obtained by applying the function to every argument in the\nlist.\n\nWhen a new fun is defined in the shell, the value of the fun is printed as\n`Fun# `:\n\n```erlang\n> Double = fun(X) -> 2 * X end.\n#Fun \n> lists:map(Double, [1,2,3,4,5]).\n[2,4,6,8,10]\n```","title":"map - Funs","ref":"funs.html#map"},{"type":"extras","doc":"`lists:any/2` takes a predicate `P` of one argument and a list of terms:\n\n```erlang\nany(Pred, [H|T]) ->\n    case Pred(H) of\n        true  ->  true;\n        false ->  any(Pred, T)\n    end;\nany(Pred, []) ->\n    false.\n```\n\nA predicate is a function that returns `true` or `false`. `any` is `true` if\nthere is a term `X` in the list such that `P(X)` is `true`.\n\nA predicate `Big(X)` is defined, which is `true` if its argument is greater that\n10:\n\n```erlang\n> Big =  fun(X) -> if X > 10 -> true; true -> false end end.\n#Fun \n> lists:any(Big, [1,2,3,4]).\nfalse\n> lists:any(Big, [1,2,3,12,5]).\ntrue\n```","title":"any - Funs","ref":"funs.html#any"},{"type":"extras","doc":"`lists:all/2` has the same arguments as `any`:\n\n```erlang\nall(Pred, [H|T]) ->\n    case Pred(H) of\n        true  ->  all(Pred, T);\n        false ->  false\n    end;\nall(Pred, []) ->\n    true.\n```\n\nIt is `true` if the predicate applied to all elements in the list is `true`.\n\n```erlang\n> lists:all(Big, [1,2,3,4,12,6]).\nfalse\n> lists:all(Big, [12,13,14,15]).\ntrue\n```","title":"all - Funs","ref":"funs.html#all"},{"type":"extras","doc":"`lists:foreach/2` takes a function of one argument and a list of terms:\n\n```erlang\nforeach(F, [H|T]) ->\n    F(H),\n    foreach(F, T);\nforeach(F, []) ->\n    ok.\n```\n\nThe function is applied to each argument in the list. `foreach` returns `ok`. It\nis only used for its side-effect:\n\n```erlang\n> lists:foreach(fun(X) -> io:format(\"~w~n\",[X]) end, [1,2,3,4]).\n1\n2\n3\n4\nok\n```","title":"foreach - Funs","ref":"funs.html#foreach"},{"type":"extras","doc":"`lists:foldl/3` takes a function of two arguments, an accumulator and a list:\n\n```erlang\nfoldl(F, Accu, [Hd|Tail]) ->\n    foldl(F, F(Hd, Accu), Tail);\nfoldl(F, Accu, []) -> Accu.\n```\n\nThe function is called with two arguments. The first argument is the successive\nelements in the list. The second argument is the accumulator. The function must\nreturn a new accumulator, which is used the next time the function is called.\n\nIf you have a list of lists `L = [\"I\",\"like\",\"Erlang\"]`, then you can sum the\nlengths of all the strings in `L` as follows:\n\n```erlang\n> L = [\"I\",\"like\",\"Erlang\"].\n[\"I\",\"like\",\"Erlang\"]\n10> lists:foldl(fun(X, Sum) -> length(X) + Sum end, 0, L).\n11\n```\n\n`lists:foldl/3` works like a `while` loop in an imperative language:\n\n```erlang\nL =  [\"I\",\"like\",\"Erlang\"],\nSum = 0,\nwhile( L != []){\n    Sum += length(head(L)),\n    L = tail(L)\nend\n```","title":"foldl - Funs","ref":"funs.html#foldl"},{"type":"extras","doc":"`lists:mapfoldl/3` simultaneously maps and folds over a list:\n\n```erlang\nmapfoldl(F, Accu0, [Hd|Tail]) ->\n    {R,Accu1} = F(Hd, Accu0),\n    {Rs,Accu2} = mapfoldl(F, Accu1, Tail),\n    {[R|Rs], Accu2};\nmapfoldl(F, Accu, []) -> {[], Accu}.\n```\n\nThe following example shows how to change all letters in `L` to upper case and\nthen count them.\n\nFirst the change to upper case:\n\n```erlang\n> Upcase =  fun(X) when $a =  X + $A - $a;\n(X) -> X\nend.\n#Fun \n> Upcase_word =\nfun(X) ->\nlists:map(Upcase, X)\nend.\n#Fun \n> Upcase_word(\"Erlang\").\n\"ERLANG\"\n> lists:map(Upcase_word, L).\n[\"I\",\"LIKE\",\"ERLANG\"]\n```\n\nNow, the fold and the map can be done at the same time:\n\n```erlang\n> lists:mapfoldl(fun(Word, Sum) ->\n{Upcase_word(Word), Sum + length(Word)}\nend, 0, L).\n{[\"I\",\"LIKE\",\"ERLANG\"],11}\n```","title":"mapfoldl - Funs","ref":"funs.html#mapfoldl"},{"type":"extras","doc":"`lists:filter/2` takes a predicate of one argument and a list and returns all elements\nin the list that satisfy the predicate:\n\n```erlang\nfilter(F, [H|T]) ->\n    case F(H) of\n        true  -> [H|filter(F, T)];\n        false -> filter(F, T)\n    end;\nfilter(F, []) -> [].\n```\n\n```erlang\n> lists:filter(Big, [500,12,2,45,6,7]).\n[500,12,45]\n```\n\nCombining maps and filters enables writing of very succinct code. For example,\nto define a set difference function `diff(L1, L2)` to be the difference between\nthe lists `L1` and `L2`, the code can be written as follows:\n\n```erlang\ndiff(L1, L2) ->\n    filter(fun(X) -> not member(X, L2) end, L1).\n```\n\nThis gives the list of all elements in L1 that are not contained in L2.\n\nThe AND intersection of the list `L1` and `L2` is also easily defined:\n\n```erlang\nintersection(L1,L2) -> filter(fun(X) -> member(X,L1) end, L2).\n```","title":"filter - Funs","ref":"funs.html#filter"},{"type":"extras","doc":"`lists:takewhile/2` takes elements `X` from a list `L` as long as the predicate\n`P(X)` is true:\n\n```erlang\ntakewhile(Pred, [H|T]) ->\n    case Pred(H) of\n        true  -> [H|takewhile(Pred, T)];\n        false -> []\n    end;\ntakewhile(Pred, []) ->\n    [].\n```\n\n```erlang\n> lists:takewhile(Big, [200,500,45,5,3,45,6]).\n[200,500,45]\n```","title":"takewhile - Funs","ref":"funs.html#takewhile"},{"type":"extras","doc":"`lists:dropwhile/2` is the complement of `takewhile`:\n\n```erlang\ndropwhile(Pred, [H|T]) ->\n    case Pred(H) of\n        true  -> dropwhile(Pred, T);\n        false -> [H|T]\n    end;\ndropwhile(Pred, []) ->\n    [].\n```\n\n```erlang\n> lists:dropwhile(Big, [200,500,45,5,3,45,6]).\n[5,3,45,6]\n```","title":"dropwhile - Funs","ref":"funs.html#dropwhile"},{"type":"extras","doc":"`lists:splitwith/2` splits the list `L` into the two sublists `{L1, L2}`, where\n`L = takewhile(P, L)` and `L2 = dropwhile(P, L)`:\n\n```erlang\nsplitwith(Pred, L) ->\n    splitwith(Pred, L, []).\n\nsplitwith(Pred, [H|T], L) ->\n    case Pred(H) of\n        true  -> splitwith(Pred, T, [H|L]);\n        false -> {reverse(L), [H|T]}\n    end;\nsplitwith(Pred, [], L) ->\n    {reverse(L), []}.\n```\n\n```erlang\n> lists:splitwith(Big, [200,500,45,5,3,45,6]).\n{[200,500,45],[5,3,45,6]}\n```","title":"splitwith - Funs","ref":"funs.html#splitwith"},{"type":"extras","doc":"So far, only functions that take funs as arguments have been described. More\npowerful functions, that themselves return funs, can also be written. The\nfollowing examples illustrate these type of functions.","title":"Funs Returning Funs - Funs","ref":"funs.html#funs-returning-funs"},{"type":"extras","doc":"`Adder(X)` is a function that given `X`, returns a new function `G` such that\n`G(K)` returns `K + X`:\n\n```erlang\n> Adder = fun(X) -> fun(Y) -> X + Y end end.\n#Fun \n> Add6 = Adder(6).\n#Fun \n> Add6(10).\n16\n```","title":"Simple Higher Order Functions - Funs","ref":"funs.html#simple-higher-order-functions"},{"type":"extras","doc":"The idea is to write something like:\n\n```erlang\n-module(lazy).\n-export([ints_from/1]).\nints_from(N) ->\n    fun() ->\n            [N|ints_from(N+1)]\n    end.\n```\n\nThen proceed as follows:\n\n```erlang\n> XX = lazy:ints_from(1).\n#Fun \n> XX().\n[1|#Fun ]\n> hd(XX()).\n1\n> Y = tl(XX()).\n#Fun \n> hd(Y()).\n2\n```\n\nAnd so on. This is an example of \"lazy embedding\".","title":"Infinite Lists - Funs","ref":"funs.html#infinite-lists"},{"type":"extras","doc":"The following examples show parsers of the following type:\n\n```erlang\nParser(Toks) -> {ok, Tree, Toks1} | fail\n```\n\n`Toks` is the list of tokens to be parsed. A successful parse returns\n`{ok, Tree, Toks1}`.\n\n- `Tree` is a parse tree.\n- `Toks1` is a tail of `Tree` that contains symbols encountered after the\n  structure that was correctly parsed.\n\nAn unsuccessful parse returns `fail`.\n\nThe following example illustrates a simple, functional parser that parses the\ngrammar:\n\n```text\n(a | b) & (c | d)\n```\n\nThe following code defines a function `pconst(X)` in the module `funparse`,\nwhich returns a fun that parses a list of tokens:\n\n```erlang\npconst(X) ->\n    fun (T) ->\n       case T of\n           [X|T1] -> {ok, {const, X}, T1};\n           _      -> fail\n       end\n    end.\n```\n\nThis function can be used as follows:\n\n```erlang\n> P1 = funparse:pconst(a).\n#Fun \n> P1([a,b,c]).\n{ok,{const,a},[b,c]}\n> P1([x,y,z]).\nfail\n```\n\nNext, the two higher order functions `pand` and `por` are defined. They combine\nprimitive parsers to produce more complex parsers.\n\nFirst `pand`:\n\n```erlang\npand(P1, P2) ->\n    fun (T) ->\n        case P1(T) of\n            {ok, R1, T1} ->\n                case P2(T1) of\n                    {ok, R2, T2} ->\n                        {ok, {'and', R1, R2}};\n                    fail ->\n                        fail\n                end;\n            fail ->\n                fail\n        end\n    end.\n```\n\nGiven a parser `P1` for grammar `G1`, and a parser `P2` for grammar `G2`,\n`pand(P1, P2)` returns a parser for the grammar, which consists of sequences of\ntokens that satisfy `G1`, followed by sequences of tokens that satisfy `G2`.\n\n`por(P1, P2)` returns a parser for the language described by the grammar `G1` or\n`G2`:\n\n```erlang\npor(P1, P2) ->\n    fun (T) ->\n        case P1(T) of\n            {ok, R, T1} ->\n                {ok, {'or',1,R}, T1};\n            fail ->\n                case P2(T) of\n                    {ok, R1, T1} ->\n                        {ok, {'or',2,R1}, T1};\n                    fail ->\n                        fail\n                end\n        end\n    end.\n```\n\nThe original problem was to parse the grammar `(a | b) & (c | d)`. The following\ncode addresses this problem:\n\n```erlang\ngrammar() ->\n    pand(\n         por(pconst(a), pconst(b)),\n         por(pconst(c), pconst(d))).\n```\n\nThe following code adds a parser interface to the grammar:\n\n```erlang\nparse(List) ->\n    (grammar())(List).\n```\n\nThe parser can be tested as follows:\n\n```erlang\n> funparse:parse([a,c]).\n{ok,{'and',{'or',1,{const,a}},{'or',1,{const,c}}}}\n> funparse:parse([a,d]).\n{ok,{'and',{'or',1,{const,a}},{'or',2,{const,d}}}}\n> funparse:parse([b,c]).\n{ok,{'and',{'or',2,{const,b}},{'or',1,{const,c}}}}\n> funparse:parse([b,d]).\n{ok,{'and',{'or',2,{const,b}},{'or',2,{const,d}}}}\n> funparse:parse([a,b]).\nfail\n```","title":"Parsing - Funs","ref":"funs.html#parsing"},{"type":"extras","doc":"<!--\n%CopyrightBegin%\n\nCopyright Ericsson AB 2023-2024. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# List Comprehensions","title":"List Comprehensions","ref":"list_comprehensions.html"},{"type":"extras","doc":"This section starts with a simple example, showing a generator and a filter:\n\n```erlang\n> [X || X <- [1,2,a,3,4,b,5,6], X > 3].\n[a,4,b,5,6]\n```\n\nThis is read as follows: The list of X such that X is taken from the list\n`[1,2,a,...]` and X is greater than 3.\n\nThe notation `X <- [1,2,a,...]` is a generator and the expression `X > 3` is a\nfilter.\n\nAn additional filter, [`is_integer(X)`](`is_integer/1`), can be added to\nrestrict the result to integers:\n\n```erlang\n> [X || X <- [1,2,a,3,4,b,5,6], is_integer(X), X > 3].\n[4,5,6]\n```\n\nGenerators can be combined. For example, the Cartesian product of two lists can\nbe written as follows:\n\n```erlang\n> [{X, Y} || X <- [1,2,3], Y <- [a,b]].\n[{1,a},{1,b},{2,a},{2,b},{3,a},{3,b}]\n```","title":"Simple Examples - List Comprehensions","ref":"list_comprehensions.html#simple-examples"},{"type":"extras","doc":"The well-known quick sort routine can be written as follows:\n\n```erlang\nsort([]) -> [];\nsort([_] = L) -> L;\nsort([Pivot|T]) ->\n    sort([ X || X <- T, X  = Pivot]).\n```\n\nThe expression `[X || X <- T, X  = Pivot]` is the list of all elements in `T` that are greater\nthan or equal to `Pivot`.\n\nWith the algorithm above, a list is sorted as follows:\n\n- A list with zero or one element is trivially sorted.\n- For lists with more than one element:\n  1. The first element in the list is isolated as the pivot element.\n  1. The remaining list is partitioned into two sublists, such that:\n  - The first sublist contains all elements that are smaller than the pivot\n    element.\n  - The second sublist contains all elements that are greater than or equal to\n    the pivot element.\n  1. The sublists are recursively sorted by the same algorithm and the results\n     are combined, resulting in a list consisting of:\n  - All elements from the first sublist, that is all elements smaller than the\n    pivot element, in sorted order.\n  - The pivot element.\n  - All elements from the second sublist, that is all elements greater than or\n    equal to the pivot element, in sorted order.\n\n> #### Note {: .info }\n>\n> While the sorting algorithm as shown above serves as a nice example to\n> illustrate list comprehensions with filters, for real world use cases the\n> `m:lists` module contains sorting functions that are implemented in a more\n> efficient way.","title":"Quick Sort - List Comprehensions","ref":"list_comprehensions.html#quick-sort"},{"type":"extras","doc":"The following example generates all permutations of the elements in a list:\n\n```erlang\nperms([]) -> [[]];\nperms(L)  -> [[H|T] || H <- L, T <- perms(L--[H])].\n```\n\nThis takes `H` from `L` in all possible ways. The result is the set of all lists\n`[H|T]`, where `T` is the set of all possible permutations of `L`, with `H`\nremoved:\n\n```erlang\n> perms([b,u,g]).\n[[b,u,g],[b,g,u],[u,b,g],[u,g,b],[g,b,u],[g,u,b]]\n```","title":"Permutations - List Comprehensions","ref":"list_comprehensions.html#permutations"},{"type":"extras","doc":"Pythagorean triplets are sets of integers `{A,B,C}` such that\n`A**2 + B**2 = C**2`.\n\nThe function `pyth(N)` generates a list of all integers `{A,B,C}` such that\n`A**2 + B**2 = C**2` and where the sum of the sides is equal to, or less than,\n`N`:\n\n```erlang\npyth(N) ->\n    [ {A,B,C} ||\n        A <- lists:seq(1,N),\n        B <- lists:seq(1,N),\n        C <- lists:seq(1,N),\n        A+B+C =  pyth(3).\n[].\n> pyth(11).\n[].\n> pyth(12).\n[{3,4,5},{4,3,5}]\n> pyth(50).\n[{3,4,5},\n {4,3,5},\n {5,12,13},\n {6,8,10},\n {8,6,10},\n {8,15,17},\n {9,12,15},\n {12,5,13},\n {12,9,15},\n {12,16,20},\n {15,8,17},\n {16,12,20}]\n```\n\nThe following code reduces the search space and is more efficient:\n\n```erlang\npyth1(N) ->\n   [{A,B,C} ||\n       A <- lists:seq(1,N-2),\n       B <- lists:seq(A+1,N-1),\n       C <- lists:seq(B+1,N),\n       A+B+C =< N,\n       A*A+B*B == C*C ].\n```","title":"Pythagorean Triplets - List Comprehensions","ref":"list_comprehensions.html#pythagorean-triplets"},{"type":"extras","doc":"As an example, list comprehensions can be used to simplify some of the functions\nin `lists.erl`:\n\n```erlang\nappend(L)   ->  [X || L1 <- L, X <- L1].\nmap(Fun, L) -> [Fun(X) || X <- L].\nfilter(Pred, L) -> [X || X <- L, Pred(X)].\n```","title":"Simplifications With List Comprehensions - List Comprehensions","ref":"list_comprehensions.html#simplifications-with-list-comprehensions"},{"type":"extras","doc":"The scope rules for variables that occur in list comprehensions are as follows:\n\n- All variables that occur in a generator pattern are assumed to be \"fresh\"\n  variables.\n- Any variables that are defined before the list comprehension, and that are\n  used in filters, have the values they had before the list comprehension.\n- Variables cannot be exported from a list comprehension.\n\nAs an example of these rules, suppose you want to write the function `select`,\nwhich selects certain elements from a list of tuples. Suppose you write\n`select(X, L) -> [Y || {X, Y} <- L].` with the intention of extracting all\ntuples from `L`, where the first item is `X`.\n\nCompiling this gives the following diagnostic:\n\n```text\n./FileName.erl:Line: Warning: variable 'X' shadowed in generate\n```\n\nThis diagnostic warns that the variable `X` in the pattern is not the same as\nthe variable `X` that occurs in the function head.\n\nEvaluating `select` gives the following result:\n\n```erlang\n> select(b,[{a,1},{b,2},{c,3},{b,7}]).\n[1,2,3,7]\n```\n\nThis is not the wanted result. To achieve the desired effect, `select` must be\nwritten as follows:\n\n```erlang\nselect(X, L) ->  [Y || {X1, Y} <- L, X == X1].\n```\n\nThe generator now contains unbound variables and the test has been moved into\nthe filter.\n\nThis now works as expected:\n\n```erlang\n> select(b,[{a,1},{b,2},{c,3},{b,7}]).\n[2,7]\n```\n\nAlso note that a variable in a generator pattern will shadow a variable with the\nsame name bound in a previous generator pattern. For example:\n\n```erlang\n> [{X,Y} || X <- [1,2,3], X=Y <- [a,b,c]].\n[{a,a},{b,b},{c,c},{a,a},{b,b},{c,c},{a,a},{b,b},{c,c}]\n```\n\nA consequence of the rules for importing variables into a list comprehensions is\nthat certain pattern matching operations must be moved into the filters and\ncannot be written directly in the generators.\n\nTo illustrate this, do _not_ write as follows:\n\n```erlang\nf(...) ->\n    Y = ...\n    [ Expression || PatternInvolving Y  <- Expr, ...]\n    ...\n```\n\nInstead, write as follows:\n\n```erlang\nf(...) ->\n    Y = ...\n    [ Expression || PatternInvolving Y1  <- Expr, Y == Y1, ...]\n    ...\n```","title":"Variable Bindings in List Comprehensions - List Comprehensions","ref":"list_comprehensions.html#variable-bindings-in-list-comprehensions"},{"type":"extras","doc":"<!--\n%CopyrightBegin%\n\nCopyright Ericsson AB 2023-2024. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# Bit Syntax","title":"Bit Syntax","ref":"bit_syntax.html"},{"type":"extras","doc":"The complete specification for the bit syntax appears in the\n[Reference Manual](`e:system:expressions.md#bit-syntax-expressions`).\n\nIn Erlang, a Bin is used for constructing binaries and matching binary patterns.\nA Bin is written with the following syntax:\n\n```erlang\n< >\n```\n\nA Bin is a low-level sequence of bits or bytes. The purpose of a Bin is to\nenable construction of binaries:\n\n```erlang\nBin = < >\n```\n\nAll elements must be bound. Or match a binary:\n\n```erlang\n< > = Bin\n```\n\nHere, `Bin` is bound and the elements are bound or unbound, as in any match.\n\nA Bin does not need to consist of a whole number of bytes.\n\nA _bitstring_ is a sequence of zero or more bits, where the number of bits does\nnot need to be divisible by 8. If the number of bits is divisible by 8, the\nbitstring is also a binary.\n\nEach element specifies a certain _segment_ of the bitstring. A segment is a set\nof contiguous bits of the binary (not necessarily on a byte boundary). The first\nelement specifies the initial segment, the second element specifies the\nfollowing segment, and so on.\n\nThe following examples illustrate how binaries are constructed, or matched, and\nhow elements and tails are specified.","title":"Introduction - Bit Syntax","ref":"bit_syntax.html#introduction"},{"type":"extras","doc":"_Example 1:_ A binary can be constructed from a set of constants or a string\nliteral:\n\n```erlang\nBin11 = <<1, 17, 42>>,\nBin12 = <<\"abc\">>\n```\n\nThis gives two binaries of size 3, with the following evaluations:\n\n- [`binary_to_list(Bin11)`](`binary_to_list/1`) evaluates to `[1, 17, 42]`.\n- [`binary_to_list(Bin12)`](`binary_to_list/1`) evaluates to `[97, 98, 99]`.\n\n*Example 2:*Similarly, a binary can be constructed from a set of bound\nvariables:\n\n```erlang\nA = 1, B = 17, C = 42,\nBin2 = < >\n```\n\nThis gives a binary of size 4. Here, a _size expression_ is used for the\nvariable `C` to specify a 16-bits segment of `Bin2`.\n\n[`binary_to_list(Bin2)`](`binary_to_list/1`) evaluates to `[1, 17, 00, 42]`.\n\n_Example 3:_ A Bin can also be used for matching. `D`, `E`, and `F` are unbound\nvariables, and `Bin2` is bound, as in Example 2:\n\n```erlang\n< > = Bin2\n```\n\nThis gives `D = 273`, `E = 00`, and F binds to a binary of size 1:\n`binary_to_list(F) = [42]`.\n\n_Example 4:_ The following is a more elaborate example of matching. Here,\n`Dgram` is bound to the consecutive bytes of an IP datagram of IP protocol\nversion 4. The ambition is to extract the header and the data of the datagram:\n\n```erlang\n-define(IP_VERSION, 4).\n-define(IP_MIN_HDR_LEN, 5).\n\nDgramSize = byte_size(Dgram),\ncase Dgram of\n    <<?IP_VERSION:4, HLen:4, SrvcType:8, TotLen:16,\n      ID:16, Flgs:3, FragOff:13,\n      TTL:8, Proto:8, HdrChkSum:16,\n      SrcIP:32,\n      DestIP:32, RestDgram/binary>> when HLen>=5, 4*HLen= \n        OptsLen = 4*(HLen - ?IP_MIN_HDR_LEN),\n        < > = RestDgram,\n    ...\nend.\n```\n\nHere, the segment corresponding to the `Opts` variable has a _type modifier_,\nspecifying that `Opts` is to bind to a binary. All other variables have the\ndefault type equal to unsigned integer.\n\nAn IP datagram header is of variable length. This length is measured in the\nnumber of 32-bit words and is given in the segment corresponding to `HLen`. The\nminimum value of `HLen` is 5. It is the segment corresponding to `Opts` that is\nvariable, so if `HLen` is equal to 5, `Opts` becomes an empty binary.\n\nThe tail variables `RestDgram` and `Data` bind to binaries, as all tail\nvariables do. Both can bind to empty binaries.\n\nThe match of `Dgram` fails if one of the following occurs:\n\n- The first 4-bits segment of `Dgram` is not equal to 4.\n- `HLen` is less than 5.\n- The size of `Dgram` is less than `4*HLen`.","title":"Examples - Bit Syntax","ref":"bit_syntax.html#examples"},{"type":"extras","doc":"Notice that \"`B=<<1>>`\" will be interpreted as \"`B =< <1>>`\", which is a syntax\nerror. The correct way to write the expression is: `B = <<1>>`.","title":"Lexical Note - Bit Syntax","ref":"bit_syntax.html#lexical-note"},{"type":"extras","doc":"Each segment has the following general syntax:\n\n`Value:Size/TypeSpecifierList`\n\nThe `Size` or the `TypeSpecifier`, or both, can be omitted. Thus, the following\nvariants are allowed:\n\n- `Value`\n- `Value:Size`\n- `Value/TypeSpecifierList`\n\nDefault values are used when specifications are missing. The default values are\ndescribed in [Defaults](#defaults).\n\nThe `Value` part is any expression, when used in binary construction. Used in\nbinary matching, the `Value` part must be a literal or a variable. For more\ninformation about the `Value` part, see\n[Constructing Binaries and Bitstrings](#constructing-binaries-and-bitstrings)\nand [Matching Binaries](#matching-binaries).\n\nThe `Size` part of the segment multiplied by the unit in `TypeSpecifierList`\n(described later) gives the number of bits for the segment. In construction,\n`Size` is any expression that evaluates to an integer. In matching, `Size` must\nbe a constant expression or a variable.\n\nThe `TypeSpecifierList` is a list of type specifiers separated by hyphens.\n\n- **Type** - The most commonly used types are `integer`, `float`, and `binary`.\n  See\n  [Bit Syntax Expressions in the Reference Manual](`e:system:expressions.md#bit-syntax-expressions`)\n  for a complete description.\n\n- **Signedness** - The signedness specification can be either `signed` or\n  `unsigned`. Notice that signedness only matters for matching.\n\n- **Endianness** - The endianness specification can be either `big`, `little`,\n  or `native`. Native-endian means that the endian is resolved at load time, to\n  be either big-endian or little-endian, depending on what is \"native\" for the\n  CPU that the Erlang machine is run on.\n\n- **Unit** - The unit size is given as `unit:IntegerLiteral`. The allowed range\n  is 1-256. It is multiplied by the `Size` specifier to give the effective size\n  of the segment. The unit size specifies the alignment for binary segments\n  without size.\n\n_Example:_\n\n```text\nX:4/little-signed-integer-unit:8\n```\n\nThis element has a total size of 4\\*8 = 32 bits, and it contains a signed\ninteger in little-endian order.","title":"Segments - Bit Syntax","ref":"bit_syntax.html#segments"},{"type":"extras","doc":"The default type for a segment is integer. The default type\ndoes not depend on the value, even if the value is a literal. For example, the\ndefault type in `<<3.14>>` is integer, not float.\n\nThe default `Size` depends on the type. For integer it is 8. For float it is 64.\nFor binary it is all of the binary. In matching, this default value is only\nvalid for the last element. All other binary elements in matching must have a\nsize specification.\n\nThe default unit depends on the type. For `integer`, `float`, and `bitstring` it\nis 1. For binary it is 8.\n\nThe default signedness is `unsigned`.\n\nThe default endianness is `big`.","title":"Defaults - Bit Syntax","ref":"bit_syntax.html#defaults"},{"type":"extras","doc":"This section describes the rules for constructing binaries using the bit syntax.\nUnlike when constructing lists or tuples, the construction of a binary can fail\nwith a `badarg` exception.\n\nThere can be zero or more segments in a binary to be constructed. The expression\n`<<>>` constructs a zero length binary.\n\nEach segment in a binary can consist of zero or more bits. There are no\nalignment rules for individual segments of type `integer` and `float`. For\nbinaries and bitstrings without size, the unit specifies the alignment. Since\nthe default alignment for the `binary` type is 8, the size of a binary segment\nmust be a multiple of 8 bits, that is, only whole bytes.\n\n_Example:_\n\n```erlang\n< >\n```\n\nThe variable `Bin` must contain a whole number of bytes, because the `binary`\ntype defaults to `unit:8`. A `badarg` exception is generated if `Bin` consist\nof, for example, 17 bits.\n\nThe `Bitstring` variable can consist of any number of bits, for example, 0, 1,\n8, 11, 17, 42, and so on. This is because the default `unit` for bitstrings\nis 1.\n\nFor clarity, it is recommended not to change the unit size for binaries.\nInstead, use `binary` when you need byte alignment and `bitstring` when you need\nbit alignment.\n\nThe following example successfully constructs a bitstring of 7 bits, provided\nthat all of X and Y are integers:\n\n```erlang\n< >\n```\n\nAs mentioned earlier, segments have the following general syntax:\n\n`Value:Size/TypeSpecifierList`\n\nWhen constructing binaries, `Value` and `Size` can be any Erlang expression.\nHowever, for syntactical reasons, both `Value` and `Size` must be enclosed in\nparenthesis if the expression consists of anything more than a single literal or\na variable. The following gives a compiler syntax error:\n\n```erlang\n< >\n```\n\nThis expression must be rewritten into the following, to be accepted by the\ncompiler:\n\n```erlang\n<<(X+1):8>>\n```","title":"Constructing Binaries and Bitstrings - Bit Syntax","ref":"bit_syntax.html#constructing-binaries-and-bitstrings"},{"type":"extras","doc":"A literal string can be written instead of an element:\n\n```erlang\n<<\"hello\">>\n```\n\nThis is syntactic sugar for the following:\n\n```erlang\n<<$h,$e,$l,$l,$o>>\n```","title":"Including Literal Strings - Bit Syntax","ref":"bit_syntax.html#including-literal-strings"},{"type":"extras","doc":"This section describes the rules for matching binaries, using the bit syntax.\n\nThere can be zero or more segments in a binary pattern. A binary pattern can\noccur wherever patterns are allowed, including inside other patterns. Binary\npatterns cannot be nested. The pattern `<<>>` matches a zero length binary.\n\nEach segment in a binary can consist of zero or more bits. A segment of type\n`binary` must have a size evenly divisible by 8 (or divisible by the unit size,\nif the unit size has been changed). A segment of type `bitstring` has no\nrestrictions on the size. A segment of type `float` must have size 64 or 32.\n\nAs mentioned earlier, segments have the following general syntax:\n\n`Value:Size/TypeSpecifierList`\n\nWhen matching `Value`, value must be either a variable or an integer, or a\nfloating point literal. Expressions are not allowed.\n\n`Size` must be a\n[guard expression](`e:system:expressions.md#guard-expressions`), which can use\nliterals and previously bound variables. The following is not allowed:\n\n```erlang\nfoo(N, < >) ->\n   {X,T}.\n```\n\nThe two occurrences of `N` are not related. The compiler will complain that the\n`N` in the size field is unbound.\n\nThe correct way to write this example is as follows:\n\n```erlang\nfoo(N, Bin) ->\n   < > = Bin,\n   {X,T}.\n```\n\n> #### Note {: .info }\n>\n> Before OTP 23, `Size` was restricted to be an integer or a variable bound to\n> an integer.","title":"Matching Binaries - Bit Syntax","ref":"bit_syntax.html#matching-binaries"},{"type":"extras","doc":"There is one exception to the rule that a variable that is used as size must be\npreviously bound. It is possible to match and bind a variable, and use it as a\nsize within the same binary pattern. For example:\n\n```erlang\nbar(< >) ->\n   {Payload,Rest}.\n```\n\nHere `Sz` is bound to the value in the first byte of the binary. `Sz` is then\nused at the number of bytes to match out as a binary.\n\nStarting in OTP 23, the size can be a guard expression:\n\n```erlang\nbar(< >) ->\n   {Payload,Rest}.\n```\n\nHere `Sz` is the combined size of the header and the payload, so we will need to\nsubtract one byte to get the size of the payload.","title":"Binding and Using a Size Variable - Bit Syntax","ref":"bit_syntax.html#binding-and-using-a-size-variable"},{"type":"extras","doc":"To match out the rest of a binary, specify a binary field without size:\n\n```erlang\nfoo(< >) ->\n```\n\nThe size of the tail must be evenly divisible by 8.\n\nTo match out the rest of a bitstring, specify a field without size:\n\n```erlang\nfoo(< >) ->\n```\n\nThere are no restrictions on the number of bits in the tail.","title":"Getting the Rest of the Binary or Bitstring - Bit Syntax","ref":"bit_syntax.html#getting-the-rest-of-the-binary-or-bitstring"},{"type":"extras","doc":"Appending to a binary in an efficient way can be done as follows:\n\n```erlang\ntriples_to_bin(T) ->\n    triples_to_bin(T, <<>>).\n\ntriples_to_bin([{X,Y,Z} | T], Acc) ->\n    triples_to_bin(T, < >);\ntriples_to_bin([], Acc) ->\n    Acc.\n```","title":"Appending to a Binary - Bit Syntax","ref":"bit_syntax.html#appending-to-a-binary"},{"type":"extras","doc":"<!--\n%CopyrightBegin%\n\nCopyright Ericsson AB 2023-2024. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# Introduction\n\n[](){: #erlang-ref-manual }\n\nThis section is the Erlang reference manual. It describes the Erlang programming\nlanguage.","title":"Introduction","ref":"reference_manual.html"},{"type":"extras","doc":"The focus of the Erlang reference manual is on the language itself, not the\nimplementation of it. The language constructs are described in text and with\nexamples rather than formally specified. This is to make the manual more\nreadable. The Erlang reference manual is not intended as a tutorial.\n\nInformation about implementation of Erlang can, for example, be found, in the\nfollowing:\n\n- [System Principles](`e:system:system_principles.md`)\n\n  Starting and stopping, boot scripts, code loading,\n  [logging](`e:system:error_logging.md`),\n  [creating target systems](`e:system:create_target.md`)\n\n- [Efficiency Guide](`e:system:efficiency_guide.md`)\n\n  [Memory consumption](`e:system:memory.md`) and\n  [system limits](`e:system:system_limits.md`).\n\n- ERTS User's Guide\n\n  [Crash dumps](`e:erts:crash_dump.md`), [NIFs](`e:erts:erl_nif.md`),\n  [drivers](`e:erts:driver.md`)","title":"Purpose - Introduction","ref":"reference_manual.html#purpose"},{"type":"extras","doc":"It is assumed that the reader has done some programming and is familiar with\nconcepts such as data types and programming language syntax.","title":"Prerequisites - Introduction","ref":"reference_manual.html#prerequisites"},{"type":"extras","doc":"In this section, the following terminology is used:\n\n- A _sequence_ is one or more items. For example, a clause body consists of a\n  sequence of expressions. This means that there must be at least one\n  expression.\n- A _list_ is any number of items. For example, an argument list can consist of\n  zero, one, or more arguments.\n\nIf a feature has been added in R13A or later, this is mentioned in the text.","title":"Document Conventions - Introduction","ref":"reference_manual.html#document-conventions"},{"type":"extras","doc":"For a complete list of BIFs, their arguments and return values, see module `m:erlang`\nin ERTS.","title":"Complete List of BIFs - Introduction","ref":"reference_manual.html#complete-list-of-bifs"},{"type":"extras","doc":"The following are reserved words in Erlang:\n\n`after and andalso band begin bnot bor bsl bsr bxor case catch cond div else end fun if let maybe not of or orelse receive rem try when xor`\n\n**Note**: `cond` and `let`, while reserved, are currently not used by the\nlanguage.\n\n> #### Change {: .info }\n>\n> `maybe` is a reserved word only if feature `maybe_expr` is enabled. In\n> Erlang/OTP 25 and 26, `maybe_expr` is disabled by default. Starting from\n> Erlang/OTP 27, `maybe_expr` is enabled by default.","title":"Reserved Words - Introduction","ref":"reference_manual.html#reserved-words"},{"type":"extras","doc":"<!--\n%CopyrightBegin%\n\nCopyright Ericsson AB 2023-2024. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# Character Set and Source File Encoding","title":"Character Set and Source File Encoding","ref":"character_set.html"},{"type":"extras","doc":"The syntax of Erlang tokens allow the use of the full ISO-8859-1 (Latin-1)\ncharacter set. This is noticeable in the following ways:\n\n- All the Latin-1 printable characters can be used and are shown without the\n  escape backslash convention.\n- Unquoted atoms and variables can use all Latin-1 letters.\n\n| _Octal_   | _Decimal_ |       | _Class_                |\n| --------- | --------- | ----- | ---------------------- |\n| 200 - 237 | 128 - 159 |       | Control characters     |\n| 240 - 277 | 160 - 191 | \\- ¿  | Punctuation characters |\n| 300 - 326 | 192 - 214 | À - Ö | Uppercase letters      |\n| 327       | 215       | ×     | Punctuation character  |\n| 330 - 336 | 216 - 222 | Ø - Þ | Uppercase letters      |\n| 337 - 366 | 223 - 246 | ß - ö | Lowercase letters      |\n| 367       | 247       | ÷     | Punctuation character  |\n| 370 - 377 | 248 - 255 | ø - ÿ | Lowercase letters      |\n\n_Table: Character Classes_\n\nThe following tokens are allowed to also use Unicode characters outside of the\nLatin-1 range:\n\n- String literals. Example: `\"√π\"`\n- Character literals. Example: `$∑`\n- Comments in code.\n- Quoted atoms. Example: `'μs'`\n- Function names. Example: `'s_to_μs'(S) -> S * 1_000_000.`\n\nAtoms used as module names, application names, and node names are restricted to\nthe Latin-1 range.\n\n> #### Change {: .info }\n>\n> Support for Unicode in string literals, character literals, and comments was\n> introduced in Erlang/OTP R16B. Support for Unicode in atom and function names\n> was introduced in Erlang/OTP 20.","title":"Character Set - Character Set and Source File Encoding","ref":"character_set.html#character-set"},{"type":"extras","doc":"[](){: #encoding }\n\nThe Erlang source file `encoding` is selected by a comment in one of the first\ntwo lines of the source file. The first string that matches the regular\nexpression `coding\\s*[:=]\\s*([-a-zA-Z0-9])+` selects the encoding. If the\nmatching string is an invalid encoding, it is ignored. The valid encodings are\n`Latin-1` and `UTF-8`, where the case of the characters can be chosen freely.\n\nThe default Erlang source file encoding if no valid `coding` comment is present\nis UTF-8.\n\nTwo examples, both selecting Latin-1 as the source file encoding:\n\n```text\n%% For this file we have chosen encoding = Latin-1\n```\n\n```erlang\n%% -*- coding: latin-1 -*-\n```\n\n> #### Change {: .info }\n>\n> The default encoding for Erlang source files was changed from Latin-1 to UTF-8\n> in Erlang/OTP 17.0.","title":"Source File Encoding - Character Set and Source File Encoding","ref":"character_set.html#source-file-encoding"},{"type":"extras","doc":"<!--\n%CopyrightBegin%\n\nCopyright Ericsson AB 2023-2024. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# Data Types\n\nErlang provides a number of data types, which are listed in this section.\n\n[](){: #no_user_types }\n\nNote that Erlang has no user defined types, only composite types (data\nstructures) made of Erlang terms. This means that any function testing for a\ncomposite type, typically named `is_type/1`, might return `true` for a term that\ncoincides with the chosen representation. The corresponding functions for built\nin types do not suffer from this.","title":"Data Types","ref":"data_types.html"},{"type":"extras","doc":"A piece of data of any data type is called a _term_.","title":"Terms - Data Types","ref":"data_types.html#terms"},{"type":"extras","doc":"There are two types of numeric literals, _integers_ and _floats_. Besides the\nconventional notation, there are two Erlang-specific notations:\n\n- `$`_`char`_  \n  ASCII value or unicode code-point of the character _`char`_.\n- _`base`_`#`_`value`_  \n  Integer with the base _`base`_, which must be an integer in the range 2\n  through 36.\n\nLeading zeroes are ignored. Single underscore characters (`_`) can be\ninserted between digits as a visual separator.\n\n_Examples:_\n\n```text\n1> 42.\n42\n2> -1_234_567_890.\n-1234567890\n3> $A.\n65\n4> $\\n.\n10\n5> 2#101.\n5\n6> 16#1f.\n31\n7> 16#4865_316F_774F_6C64.\n5216630098191412324\n8> 2.3.\n2.3\n9> 2.3e3.\n2.3e3\n10> 2.3e-3.\n0.0023\n11> 1_234.333_333\n1234.333333\n12> 36#helloworld.\n1767707668033969\n```\n\n[](){: #numeric_comparisons }","title":"Number - Data Types","ref":"data_types.html#number"},{"type":"extras","doc":"Both integers and floats share the same linear order. That is, `1` compares less\nthan `2.4`, `3` compares greater than `2.99999`, and `5` is equal to `5.0`.\n\nWhen wanting to compare an integer with another integer or a float with another\nfloat, it may be tempting to use the term equivalence operators (`=:=`, `=/=`)\nor pattern matching. This works for integers which has a distinct representation\nfor every number, but there's a surprising edge case for floating-point as the\nlatter has two representations for zero which are considered different by the\nterm equivalence operators and pattern matching.\n\nIf you wish to compare floating-point numbers _numerically_, use the regular\ncomparison operators (such as `==`) and add guards that require both the\narguments to be floating-point.\n\n> #### Note {: .info }\n>\n> Prior to OTP 27, the term equivalence operators had a bug where they\n> considered `0.0` and `-0.0` to be the same term. Legacy code that makes\n> equality comparisons on floating-point zero should migrate to using the\n> equal-to (`==`) operator with [`is_float/1`](`is_float/1`) guards, and\n> compiler warnings have been added to that effect. These can be silenced by\n> writing `+0.0` instead, which is the same as `0.0` but makes the compiler\n> interpret the comparison as being purposely made against `0.0`.\n>\n> Note that this does _not_ break compatibility with IEEE 754 which mandates\n> that `0.0` and `-0.0` should compare equal: they are equal when interpreted as\n> numbers (`==`), and unequal when interpreted as opaque terms (`=:=`).\n\n[](){: #float_representation_problem }\n\n_Examples_:\n\n```erlang\n1> 0.0 =:= +0.0.\ntrue\n2> 0.0 =:= -0.0.\nfalse\n3> +0.0 =:= -0.0.\nfalse\n4> +0.0 == -0.0.\ntrue\n```","title":"Comparisons - Data Types","ref":"data_types.html#comparisons"},{"type":"extras","doc":"When working with floats you may not see what you expect when printing or doing\narithmetic operations. This is because floats are represented by a fixed number\nof bits in a base-2 system while printed floats are represented with a base-10\nsystem. Erlang uses 64-bit floats. Here are examples of this phenomenon:\n\n```erlang\n1> 0.1+0.2.\n0.30000000000000004\n```\n\nThe real numbers `0.1` and `0.2` cannot be represented exactly as floats.\n\n```erlang\n1> {36028797018963968.0, 36028797018963968 == 36028797018963968.0,\n  36028797018963970.0, 36028797018963970 == 36028797018963970.0}.\n{3.602879701896397e16, true,\n 3.602879701896397e16, false}.\n```\n\nThe value `36028797018963968` can be represented exactly as a float value but\nErlang's pretty printer rounds `36028797018963968.0` to `3.602879701896397e16`\n(`=36028797018963970.0`) as all values in the range\n`[36028797018963966.0, 36028797018963972.0]` are represented by\n`36028797018963968.0`.\n\nFor more information about floats and issues with them see:\n\n- [What Every Programmer Should Know About Floating-Point Arithmetic](https://floating-point-gui.de/)\n- [0\\.30000000000000004.com/](https://0.30000000000000004.com/)\n- [Floating Point Arithmetic: Issues and Limitations](https://docs.python.org/3/tutorial/floatingpoint.html)\n\nIf you need to work with exact decimal fractions, for instance to represent\nmoney, it is recommended to use a library that handles that, or work in\ncents instead of dollars or euros so that decimal fractions are not needed.\n\nAlso note that Erlang's floats do not exactly match IEEE 754 floats,\nin that neither _Inf_ nor _NaN_ are supported in Erlang. Any\noperation that would result in _NaN_, _+Inf_, or _-Inf_, will instead raise\na `badarith` exception.\n\n_Examples_:\n\n```erlang\n1> 1.0 / 0.0.\n** exception error: an error occurred when evaluating an arithmetic expression\n     in operator  '/'/2\n        called as 1.0 / 0.0\n2> 0.0 / 0.0.\n** exception error: an error occurred when evaluating an arithmetic expression\n     in operator  '/'/2\n        called as 0.0 / 0.0\n```","title":"Representation of Floating Point Numbers - Data Types","ref":"data_types.html#representation-of-floating-point-numbers"},{"type":"extras","doc":"An atom is a literal, a constant with name. An atom is to be enclosed in single\nquotes (`'`) if it does not begin with a lower-case letter or if it contains other\ncharacters than alphanumeric characters, underscore (`_`), or `@`.\n\n_Examples:_\n\n```text\nhello\nphone_number\nname@node\n'Monday'\n'phone number'\n```","title":"Atom - Data Types","ref":"data_types.html#atom"},{"type":"extras","doc":"A bit string is used to store an area of untyped memory.\n\nBit strings are expressed using the [bit syntax](expressions.md#bit-syntax-expressions).\n\nBit strings that consist of a number of bits that are evenly divisible\nby eight are called _binaries_.\n\n_Examples:_\n\n```text\n1> <<10,20>>.\n<<10,20>>\n2> <<\"ABC\">>.\n<<\"ABC\">>\n3> <<1:1,0:1>>.\n<<2:2>>\n```\n\nThe [`is_bitstring/1`](`erlang:is_bitstring/1`) BIF tests whether a\nterm is a bit string, and the [`is_binary/1`](`erlang:is_binary/1`)\nBIF tests whether a term is a binary.\n\n_Examples:_\n\n```erlang\n1> is_bitstring(<<1:1>>).\ntrue\n2> is_binary(<<1:1>>).\nfalse\n3> is_binary(<<42>>).\ntrue\n\n```\n\nFor more examples, see [Programming Examples](`e:system:bit_syntax.md`).","title":"Bit Strings and Binaries - Data Types","ref":"data_types.html#bit-strings-and-binaries"},{"type":"extras","doc":"A term that is [unique](`e:system:system_limits.md#unique_references`)\namong connected nodes. A reference is created by calling the\n[`make_ref/0`](`erlang:make_ref/0`) BIF. The\n[`is_reference/1`](`erlang:is_reference/1`) BIF tests whether a term\nis a reference.\n\n_Examples:_\n\n```erlang\n1> Ref = make_ref().\n#Ref<0.76482849.3801088007.198204>\n2> is_reference(Ref).\ntrue\n```","title":"Reference - Data Types","ref":"data_types.html#reference"},{"type":"extras","doc":"A fun is a functional object. Funs make it possible to create an anonymous\nfunction and pass the function itself — not its name — as argument to other\nfunctions.\n\n_Examples:_\n\n```erlang\n1> Fun1 = fun (X) -> X+1 end.\n#Fun \n2> Fun1(2).\n3\n```\n\nThe [`is_function/1`](`erlang:is_function/1`) and [`is_function/2`](`erlang:is_function/2`)\nBIFs tests whether a term is a fun.\n\n_Examples_:\n\n```erlang\n1> F = fun() -> ok end.\n#Fun \n2> is_function(F).\ntrue\n3> is_function(F, 0).\ntrue\n4> is_function(F, 1).\nfalse\n```\n\nRead more about funs in [Fun Expressions](expressions.md#fun-expressions). For more\nexamples, see [Programming Examples](`e:system:funs.md`).","title":"Fun - Data Types","ref":"data_types.html#fun"},{"type":"extras","doc":"A port identifier identifies an Erlang port.\n\n[`open_port/2`](`open_port/2`) returns a port identifier. The\n[`is_port/1`](`erlang:is_port/1`) BIF tests whether a term is a port\nidentifier.\n\nRead more about ports in [Ports and Port Drivers](ports.md).","title":"Port Identifier - Data Types","ref":"data_types.html#port-identifier"},{"type":"extras","doc":"Pid is an abbreviation for process identifier. Each process has a Pid which\nidentifies the process. Pids are unique among processes that are alive on\nconnected nodes. However, a Pid of a terminated process may be reused as a Pid\nfor a new process after a while.\n\nThe BIF [`self/0`](`erlang:self/0`) returns the Pid of the calling process. When\n[creating a new process](ref_man_processes.md#process-creation), the parent\nprocess will be able to get the Pid of the child process either via the return\nvalue, as is the case when calling the [`spawn/3`](`erlang:spawn/3`) BIF, or via\na message, which is the case when calling the\n[`spawn_request/5`](`erlang:spawn_request/5`) BIF. A Pid is typically used when\nwhen sending a process a [signal](ref_man_processes.md#signals). The\n[`is_pid/1`](`erlang:is_pid/1`) BIF tests whether a term is a Pid.\n\n_Example:_\n\n```erlang\n-module(m).\n-export([loop/0]).\n\nloop() ->\n    receive\n        who_are_you ->\n            io:format(\"I am ~p~n\", [self()]),\n            loop()\n    end.\n\n1> P = spawn(m, loop, []).\n<0.58.0>\n2> P ! who_are_you.\nI am <0.58.0>\nwho_are_you\n```\n\nRead more about processes in [Processes](ref_man_processes.md).","title":"Pid - Data Types","ref":"data_types.html#pid"},{"type":"extras","doc":"A tuple is a compound data type with a fixed number of terms:\n\n```text\n{Term1,...,TermN}\n```\n\nEach term `Term` in the tuple is called an _element_. The number of elements is\nsaid to be the _size_ of the tuple.\n\nThere exists a number of BIFs to manipulate tuples.\n\n_Examples:_\n\n```erlang\n1> P = {adam,24,{july,29}}.\n{adam,24,{july,29}}\n2> element(1,P).\nadam\n3> element(3,P).\n{july,29}\n4> P2 = setelement(2,P,25).\n{adam,25,{july,29}}\n5> tuple_size(P).\n3\n6> tuple_size({}).\n0\n7> is_tuple({a,b,c}).\ntrue\n```","title":"Tuple - Data Types","ref":"data_types.html#tuple"},{"type":"extras","doc":"A map is a compound data type with a variable number of key-value associations:\n\n```text\n#{Key1 => Value1, ..., KeyN => ValueN}\n```\n\nEach key-value association in the map is called an _association pair_. The key\nand value parts of the pair are called _elements_. The number of association\npairs is said to be the _size_ of the map.\n\nThere exists a number of BIFs to manipulate maps.\n\n_Examples:_\n\n```erlang\n1> M1 = #{name => adam, age => 24, date => {july,29}}.\n#{age => 24,date => {july,29},name => adam}\n2> maps:get(name, M1).\nadam\n3> maps:get(date, M1).\n{july,29}\n4> M2 = maps:update(age, 25, M1).\n#{age => 25,date => {july,29},name => adam}\n5> map_size(M).\n3\n6> map_size(#{}).\n0\n```\n\nA collection of maps processing functions are found in module `m:maps`\nin STDLIB.\n\nRead more about maps in [Map Expressions](expressions.md#map-expressions).\n\n> #### Change {: .info }\n>\n> Maps were introduced as an experimental feature in Erlang/OTP R17. Their\n> functionality was extended and became fully supported in Erlang/OTP 18.","title":"Map - Data Types","ref":"data_types.html#map"},{"type":"extras","doc":"A list is a compound data type with a variable number of terms.\n\n```text\n[Term1,...,TermN]\n```\n\nEach term `Term` in the list is called an _element_. The number of elements is\nsaid to be the _length_ of the list.\n\nFormally, a list is either the empty list `[]` or consists of a _head_ (first\nelement) and a _tail_ (remainder of the list). The _tail_ is also a list. The\nlatter can be expressed as `[H|T]`. The notation `[Term1,...,TermN]` above is\nequivalent with the list `[Term1|[...|[TermN|[]]]]`.\n\n_Example:_\n\n`[]` is a list, thus  \n`[c|[]]` is a list, thus  \n`[b|[c|[]]]` is a list, thus  \n`[a|[b|[c|[]]]]` is a list, or in short `[a,b,c]`\n\nA list where the tail is a list is sometimes called a _proper list_. It is\nallowed to have a list where the tail is not a list, for example, `[a|b]`.\nHowever, this type of list is of little practical use.\n\n_Examples:_\n\n```erlang\n1> L1 = [a,2,{c,4}].\n[a,2,{c,4}]\n2> [H|T] = L1.\n[a,2,{c,4}]\n3> H.\na\n4> T.\n[2,{c,4}]\n5> L2 = [d|T].\n[d,2,{c,4}]\n6> length(L1).\n3\n7> length([]).\n0\n```\n\nA collection of list processing functions are found in module\n`m:lists` in STDLIB.","title":"List - Data Types","ref":"data_types.html#list"},{"type":"extras","doc":"Strings are enclosed in double quotes (\"), but is not a data type in Erlang.\nInstead, a string `\"hello\"` is shorthand for the list `[$h,$e,$l,$l,$o]`, that\nis, `[104,101,108,108,111]`.\n\nTwo adjacent string literals are concatenated into one. This is done in the\ncompilation.\n\n_Example:_\n\n```text\n\"string\" \"42\"\n```\n\nis equivalent to\n\n```text\n\"string42\"\n```\n\n> #### Change {: .info }\n>\n> Starting with Erlang/OTP 27 two adjacent string literals have to be separated\n> by white space, or otherwise it is a syntax error. This avoids possible confusion\n> with _triple-quoted strings_.\n\n[](){: #tqstring } Strings can also be written as _triple-quoted strings_, which\ncan be _indented_ over multiple lines to follow the indentation of the\nsurrounding code. They are also _verbatim_, that is, they do not allow escape\nsequences, and thereby do not need double quote characters to be escaped.\n\n> #### Change {: .info }\n>\n> Triple-quoted strings were added in Erlang/OTP 27. Before that 3 consecutive\n> double quote characters had a different meaning. There were absolutely no good\n> reason to write such a character sequence before triple-quoted strings\n> existed, but there _are_ some gotchas; see the\n> [Warning ](data_types.md#triple-quoted-strings-warning) at the end of this\n> description of triple-quoted strings.\n\nExample, with verbatim double quote characters:\n\n```text\n\"\"\"\n  Line \"1\"\n  Line \"2\"\n  \"\"\"\n```\n\nThat is equivalent to the normal single quoted string (which also allows\nnewlines):\n\n```text\n\"Line \\\"1\\\"\nLine \\\"2\\\"\"\n```\n\nThe opening and the closing line has got the delimiters: the `\"\"\"` characters.\nThe lines between them are the content lines. The newline on the opening line is\nnot regarded as string content, nor is the newline on the last content line.\n\nThe indentation is defined by the white space character sequence preceding the\ndelimiter on the closing line. That character sequence is stripped from all\ncontent lines. There can only be white space before the delimiter on the closing\nline, or else it is regarded as a content line.\n\nThe opening line is not allowed to have any characters other than white space\nafter the delimiter, and all content lines must start with the defined\nindentation character sequence, otherwise the string has a syntax error.\n\nHere is a larger example:\n\n```text\nX = \"\"\"\n      First line starting with two spaces\n    Not escaped: \"\\t \\r \\xFF\" and \"\"\"\n\n    \"\"\"\n```\n\nThat corresponds to the normal string:\n\n```text\nX = \"  First line starting with two spaces\nNot escaped: \\\"\\\\t \\\\r \\\\xFF\\\" and \\\"\\\"\\\"\n\"\n```\n\nIt is possible to write consecutive double quote characters on the\nbeginning of a content line by using more double quote characters as\ndelimiters. This is a string that contains exactly four double quote\ncharacters, using a delimiter with five double quote characters:\n\n```text\n\"\"\"\"\"\n\"\"\"\"\n\"\"\"\"\"\n```\n\nThese strings are all the empty string:\n\n```text\n\"\"\n```\n\n```text\n\"\"\"\n\"\"\"\n```\n\n```text\n\"\"\"\n\n  \"\"\"\n```\n\n[](){: #triple-quoted-strings-warning }\n\n> #### Warning {: .warning }\n>\n> Before Erlang/OTP 27, when triple-quoted strings were added, the character\n> sequence `\"\"\"` was interpreted as `\"\" \"`, which means concatenating the empty\n> string to the string that follows. All sequences of an odd number of double\n> quote characters had this meaning.\n>\n> Any even number of double quote characters was interpreted as a sequence of\n> empty strings, that were concatenated (to the empty string).\n>\n> There was no reason to write such character sequences. But should that have\n> happened, the meaning has probably changed with the introduction of triple-quoted\n> strings.\n>\n> The compiler preprocessor was patched in Erlang/OTP 26.1 to warn about 3 or\n> more sequential double quote characters. In Erlang/OTP 26.2 this was improved\n> to warn about adjacent string literals without intervening white space, which\n> also covers the same problem at a string end.\n>\n> If the compiler should emit such a warning, please change such double quote\n> character sequences to have a whitespace after every second quote character,\n> remove redundant empty strings, or write them as one string. This makes the\n> code more readable, and means the same thing in all releases.","title":"String - Data Types","ref":"data_types.html#string"},{"type":"extras","doc":"A _sigil_ is a prefix to a string literal. It is not a data type in Erlang, but\na shorthand notation that indicates how to interpret the string literal. Sigils\noffer mainly two things: a compact way to create UTF-8 encoded binary strings,\nand a way to write verbatim strings (not having to escape `\\` characters),\nuseful for regular expressions, for example.\n\nA sigil starts with the Tilde character (`~`) followed by a name defining the\nsigil type.\n\nImmediately after follows the sigil content; a character sequence between\ncontent delimiters. The allowed delimiters are these start-end delimiter pairs:\n`() [] {} <>`, or these characters that are both start and end delimiters:\n``/ | ' \" ` #``. [Triple-quote](data_types.md#tqstring) string delimiters may\nalso be used.\n\nThe [character escaping rules ](data_types.md#escape-sequences)for the sigil\ncontent depends on the sigil type. When the sigil content is _verbatim_, there\nis no escape character. The sigil content simply ends when the end delimiter is\nfound, so it is impossible to have the end delimiter character in the string\ncontent. The set of delimiters is fairly generous, and in most cases it is\npossible to choose an end delimiter that's not in the literal string content.\n\n[Triple-quote](data_types.md#tqstring) string delimiters allow choosing a larger\nnumber of quote characters in the end delimiter, than whatever is in the string\ncontent, which thereby facilitates any content also with a sequence of `\"`\ncharacters at the start of a line even for a _verbatim_ string.\n\nThe Sigils are:\n\n- **`~`** - The Vanilla (default) Sigil. Shorthand for a UTF-8 encoded\n  `t:binary/0`. This sigil does not affect the character escaping rules, so with\n  triple-quoted string delimiters they are the same as for `~B`, and for other\n  string delimiters they are the same as for `~b`.\n\n- **`~b`** - The Binary Sigil. Shorthand for a\n  [UTF-8 encoded `binary()`](`t:unicode:unicode_binary/0`), as if calling\n  [`unicode:characters_to_binary/1` ](`unicode:characters_to_binary/1`)on the\n  sigil content. Character escaping rules are the same as for `~s`.\n\n- **`~B`** - The Verbatim Binary Sigil. As `~b`, but the sigil content is\n  verbatim.\n\n- **`~s`** - The String Sigil. Shorthand for a\n  [`string()`](`t:erlang:string/0`), that is, a `[char()]` which is a list of\n  Unicode codepoints.\n  [Character escaping rules ](data_types.md#escape-sequences)are the same as for\n  a normal `t:string/0`. Using this sigil on a regular string does effectively\n  nothing.\n\n- **`~S`** - The Verbatim String Sigil. As `~s`, but the sigil content is\n  verbatim. Using this sigil on a triple-quoted string does effectively nothing.\n\nExamples\n\n```text\n<<\"\\\"\\\\µA\\\"\"/utf8>> = <<$\",$\\\\,194,181,$A,$\">> =\n    ~b\"\"\"\n        \"\\\\µA\"\n        \"\"\" = ~b'\"\\\\µA\"' =\n    ~B\"\"\"\n        \"\\µA\"\n        \"\"\" = ~B<\"\\µA\"> =\n    ~\"\"\"\n        \"\\µA\"\n        \"\"\" = ~\"\\\"\\\\µA\\\"\" = ~/\"\\\\µA\"/\n```\n\n```text\n[$\",$\\\\,$µ,$A,$\"] =\n    ~s\"\"\"\n        \"\\\\µA\"\n        \"\"\" = ~s\"\\\"\\\\µA\\\"\" = ~s[\"\\\\µA\"] =\n    ~S\"\"\"\n        \"\\µA\"\n        \"\"\" = ~S(\"\\µA\") =\n    \"\"\"\n        \"\\µA\"\n        \"\"\" = \"\\\"\\\\µA\\\"\"\n```\n\nAdjacent strings are concatenated in the compilation, but that is not possible\nwith sigils, since they are transformed into terms that in general may not be\nconcatenated. So, `\"a\" \"b\"` is equivalent to `\"ab\"`, but `~s\"a\" \"b\"` or\n`~s\"a\" ~s\"b\"` is a syntax error. `~s\"a\" ++ \"b\"`, however, evaluates to `\"ab\"`\nsince both operands to the `++` operator are strings.\n\n> #### Change {: .info }\n>\n> Sigils were introduced in Erlang/OTP 27","title":"Sigil - Data Types","ref":"data_types.html#sigil"},{"type":"extras","doc":"A record is a data structure for storing a fixed number of elements. It has\nnamed fields and is similar to a struct in C. However, a record is not a true\ndata type. Instead, record expressions are translated to tuple expressions\nduring compilation. Therefore, record expressions are not understood by the\nshell unless special actions are taken. For details, see module `m:shell`\nin STDLIB.\n\n_Examples:_\n\n```erlang\n-module(person).\n-export([new/2]).\n\n-record(person, {name, age}).\n\nnew(Name, Age) ->\n    #person{name=Name, age=Age}.\n\n1> person:new(ernie, 44).\n{person,ernie,44}\n```\n\nRead more about records in [Records](ref_man_records.md). More examples are\nfound in [Programming Examples](`e:system:prog_ex_records.md`).","title":"Record - Data Types","ref":"data_types.html#record"},{"type":"extras","doc":"There is no Boolean data type in Erlang. Instead the atoms `true` and `false`\nare used to denote Boolean values. The [`is_boolean/1`](`erlang:is_boolean/1`)\nBIF tests whether a term is a boolean.\n\n_Examples:_\n\n```erlang\n1> 2 =< 3.\ntrue\n2> true or false.\ntrue\n3> is_boolean(true).\ntrue\n4> is_boolean(false).\ntrue\n5> is_boolean(ok).\nfalse\n```","title":"Boolean - Data Types","ref":"data_types.html#boolean"},{"type":"extras","doc":"Within strings (`\"`\\-delimited), quoted atoms, and the content of\n[`~b` and `~s` sigils](data_types.md#sigil), the following escape sequences are\nrecognized:\n\n| _Sequence_                  | _Description_                                                                         |\n| --------------------------- | ------------------------------------------------------------------------------------- |\n| `\\b`                        | Backspace (ASCII code 8)                                                              |\n| `\\d`                        | Delete (ASCII code 127)                                                               |\n| `\\e`                        | Escape (ASCII code 27)                                                                |\n| `\\f`                        | Form Feed (ASCII code 12)                                                             |\n| `\\n`                        | Line Feed/Newline (ASCII code 10)                                                     |\n| `\\r`                        | Carriage Return (ASCII code 13)                                                       |\n| `\\s`                        | Space (ASCII code 32)                                                                 |\n| `\\t`                        | (Horizontal) Tab (ASCII code 9)                                                       |\n| `\\v`                        | Vertical Tab (ASCII code 11)                                                          |\n| `\\`XYZ, `\\`YZ, `\\`Z         | Character with octal representation XYZ, YZ or Z                                      |\n| `\\xXY`                      | Character with hexadecimal representation XY                                          |\n| `\\x{`X...`}`                | Character with hexadecimal representation; X... is one or more hexadecimal characters |\n| `\\^a`...`\\^z` `\\^A`...`\\^Z` | Control A to control Z                                                                |\n| `\\^@`                       | NUL (ASCII code 0)                                                                    |\n| `\\^[`                       | Escape (ASCII code 27)                                                                |\n| `\\^\\`                       | File Separator (ASCII code 28)                                                        |\n| `\\^]`                       | Group Separator (ASCII code 29)                                                       |\n| `\\^^`                       | Record Separator (ASCII code 30)                                                      |\n| `\\^_`                       | Unit Separator (ASCII code 31)                                                        |\n| `\\^?`                       | Delete (ASCII code 127)                                                               |\n| `\\'`                        | Single quote                                                                          |\n| `\\\"`                        | Double quote                                                                          |\n| `\\\\`                        | Backslash                                                                             |\n\n_Table: Recognized Escape Sequences_\n\n> #### Change {: .info }\n>\n> As of Erlang/OTP 26, the value of `$\\^?` has been changed to be 127 (Delete),\n> instead of 31. Previous releases would allow any character following `$\\^`; as\n> of Erlang/OTP 26, only the documented characters are allowed.\n\nWithin [triple-quoted strings](data_types.md#tqstring), escape sequences are not\nrecognized. The only text that cannot be written in a triple-quoted string is\nthree consecutive double quote characters at the beginning of a line (preceded\nonly by whitespace). This limitation can be worked around by using more double\nquote characters for the string delimiters than in the string. Any number three\nor above is allowed for the start delimiter and the end delimiter is the same as\nthe start delimiter.\n\nWhen triple-quote string delimiters are used with the\n[`~`, `~B` or `~S` sigils ](data_types.md#sigil)the same applies, but for the\n[`~b` or `~s` sigils ](data_types.md#sigil)the escape sequences for normal\nstrings, above, are used.\n\n> #### Change {: .info }\n>\n> Triple-quoted strings and sigils were introduced in Erlang/OTP 27.","title":"Escape Sequences - Data Types","ref":"data_types.html#escape-sequences"},{"type":"extras","doc":"There are a number of BIFs for type conversions.\n\n_Examples:_\n\n```erlang\n1> atom_to_list(hello).\n\"hello\"\n2> list_to_atom(\"hello\").\nhello\n3> binary_to_list(<<\"hello\">>).\n\"hello\"\n4> binary_to_list(<<104,101,108,108,111>>).\n\"hello\"\n5> list_to_binary(\"hello\").\n<<104,101,108,108,111>>\n6> float_to_list(7.0).\n\"7.00000000000000000000e+00\"\n7> list_to_float(\"7.000e+00\").\n7.0\n8> integer_to_list(77).\n\"77\"\n9> list_to_integer(\"77\").\n77\n10> tuple_to_list({a,b,c}).\n[a,b,c]\n11> list_to_tuple([a,b,c]).\n{a,b,c}\n12> term_to_binary({a,b,c}).\n<<131,104,3,100,0,1,97,100,0,1,98,100,0,1,99>>\n13> binary_to_term(<<131,104,3,100,0,1,97,100,0,1,98,100,0,1,99>>).\n{a,b,c}\n14> binary_to_integer(<<\"77\">>).\n77\n15> integer_to_binary(77).\n<<\"77\">>\n16> float_to_binary(7.0).\n<<\"7.00000000000000000000e+00\">>\n17> binary_to_float(<<\"7.000e+00\">>).\n7.0\n```","title":"Type Conversions - Data Types","ref":"data_types.html#type-conversions"},{"type":"extras","doc":"<!--\n%CopyrightBegin%\n\nCopyright Ericsson AB 2023-2024. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# Pattern Matching","title":"Pattern Matching","ref":"patterns.html"},{"type":"extras","doc":"Variables are bound to values through the _pattern matching_ mechanism. Pattern\nmatching occurs when evaluating the `case`, `receive`, `try`, and\nthe match operator (`=`) expressions.\n\nIn pattern matching, a left-hand side [pattern](expressions.md#patterns) is\nmatched against a right-hand side [term](expressions.md#terms). If the matching\nsucceeds, any unbound variables in the pattern become bound. If the matching\nfails, an exception is raised.\n\n_Examples:_\n\n```erlang\n1> X.\n** 1:1: variable 'X' is unbound **\n2> X = 2.\n2\n3> X + 1.\n3\n4> {X, Y} = {1, 2}.\n** exception error: no match of right hand side value {1,2}\n5> {X, Y} = {2, 3}.\n{2,3}\n6> Y.\n3\n```","title":"Pattern Matching - Pattern Matching","ref":"patterns.html#pattern-matching"},{"type":"extras","doc":"<!--\n%CopyrightBegin%\n\nCopyright Ericsson AB 2023-2024. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# Modules","title":"Modules","ref":"modules.html"},{"type":"extras","doc":"Erlang code is divided into _modules_. A module consists of a sequence of\nattributes and function declarations, each terminated by a period (`.`).\n\n_Example:_\n\n```erlang\n-module(m).          % module attribute\n-export([fact/1]).   % module attribute\n\nfact(N) when N>0 ->  % beginning of function declaration\n    N * fact(N-1);   %  |\nfact(0) ->           %  |\n    1.               % end of function declaration\n```\n\nFor a description of function declarations, see\n[Function Declaration Syntax](ref_man_functions.md).","title":"Module Syntax - Modules","ref":"modules.html#module-syntax"},{"type":"extras","doc":"A _module attribute_ defines a certain property of a module.\n\nA module attribute consists of a tag and a value:\n\n```text\n-Tag(Value).\n```\n\n`Tag` must be an atom, while `Value` must be a literal term. As a convenience in\nuser-defined attributes, if the literal term `Value` has the syntax `Name/Arity`\n(where `Name` is an atom and `Arity` a positive integer), the term `Name/Arity`\nis translated to `{Name,Arity}`.\n\nAny module attribute can be specified. The attributes are stored in the compiled\ncode and can be retrieved by calling `Module:module_info(attributes)`, or by\nusing the module [beam_lib](`beam_lib:chunks/2`) in STDLIB.\n\nSeveral module attributes have predefined meanings. Some of them have arity two,\nbut user-defined module attributes must have arity one.","title":"Module Attributes - Modules","ref":"modules.html#module-attributes"},{"type":"extras","doc":"Pre-defined module attributes is to be placed before any function declaration.\n\n- **`-module(Module).`** - Module declaration, defining the name of the module.\n  The name `Module`, an atom, is to be same as the file name minus the extension\n  `.erl`. Otherwise [code loading](code_loading.md#loading) does not work as\n  intended.\n\n  This attribute is to be specified first and is the only mandatory attribute.\n\n- **`-export(Functions).`** - Exported functions. Specifies which of the\n  functions, defined within the module, that are visible from outside the\n  module.\n\n  `Functions` is a list `[Name1/Arity1, ..., NameN/ArityN]`, where each `NameI`\n  is an atom and `ArityI` an integer.\n\n- **`-import(Module, Functions).`** - Imported functions. Can be called the same\n  way as local functions, that is, without any module prefix.\n\n  `Module`, an atom, specifies which module to import functions from.\n  `Functions` is a list similar as for `export`.\n\n- **`-moduledoc(Documentation).` or `-moduledoc Documentation.`** - The user\n  documentation for this module. The allowed values for `Documentation` are the\n  same as for [`-doc`](modules.md#documentation-attributes).\n\n  See the [Documentation](documentation.md) for more details about how\n  to use `-moduledoc`.\n\n- **`-compile(Options).`** - Compiler options. `Options` is a single option or a\n  list of options. This attribute is added to the option list when compiling the\n  module. See module `m:compile` in Compiler.\n\n- **`-vsn(Vsn).`** - Module version. `Vsn` is any literal term and can be\n  retrieved using `beam_lib:version/1`.\n\n  If this attribute is not specified, the version defaults to the MD5 checksum\n  of the module.\n\n- **`-on_load(Function).`** - This attribute names a function that is to be run\n  automatically when a module is loaded. For more information, see\n  [Running a Function When a Module is Loaded](code_loading.md#on_load).\n\n- **`-nifs(Functions).`{: #nifs_attribute }** - Specifies which of the\n  functions, defined within the module, that may be loaded as NIFs with\n  `erlang:load_nif/2`.\n\n  `Functions` is a list `[Name1/Arity1, ..., NameN/ArityN]`, where each `NameI`\n  is an atom and `ArityI` an integer.\n\n  While not strictly necessary, it is recommended to use `-nifs()` attribute in\n  any module that load NIFs, to allow the compiler to make better decisions\n  regarding optimizations.\n\n  There is no need to add `-nifs([])` in modules that do not load NIFs. The lack\n  of any call to `erlang:load_nif/2`, from within the module, is enough for the\n  compiler to draw the same conclusion.\n\n  > #### Change {: .info }\n  >\n  > The special meaning for the `-nifs()` attribute was introduced in Erlang/OTP\n  > 25.0. In previous releases, `-nifs()` was accepted, but had no special\n  > meaning.","title":"Pre-Defined Module Attributes - Modules","ref":"modules.html#pre-defined-module-attributes"},{"type":"extras","doc":"It is possible to specify that the module is the callback module for a\n_behaviour_:\n\n```erlang\n-behaviour(Behaviour).\n```\n\nThe atom `Behaviour` gives the name of the behaviour, which can be a\nuser-defined behaviour or one of the following OTP standard behaviours:\n\n- `gen_server`\n- `gen_statem`\n- `gen_event`\n- `supervisor`\n\nThe spelling `behavior` is also accepted.\n\nThe callback functions of the module can be specified either directly by the\nexported function `behaviour_info/1`:\n\n```erlang\nbehaviour_info(callbacks) -> Callbacks.\n```\n\nor by a `-callback` attribute for each callback function:\n\n```erlang\n-callback Name(Arguments) -> Result.\n```\n\nHere, `Arguments` is a list of zero or more arguments. The `-callback` attribute\nis to be preferred since the extra type information can be used by tools to\nproduce documentation or find discrepancies.\n\nRead more about behaviours and callback modules in\n[OTP Design Principles](`e:system:spec_proc.md#behaviours`).","title":"Behaviour Module Attribute - Modules","ref":"modules.html#behaviour-module-attribute"},{"type":"extras","doc":"The same syntax as for module attributes is used for record definitions:\n\n```erlang\n-record(Record, Fields).\n```\n\nRecord definitions are allowed anywhere in a module, also among the function\ndeclarations. Read more in [Records](ref_man_records.md).","title":"Record Definitions - Modules","ref":"modules.html#record-definitions"},{"type":"extras","doc":"The same syntax as for module attributes is used by the preprocessor, which\nsupports file inclusion, macros, and conditional compilation:\n\n```erlang\n-include(\"SomeFile.hrl\").\n-define(Macro, Replacement).\n```\n\nRead more in [Preprocessor](macros.md).","title":"Preprocessor - Modules","ref":"modules.html#preprocessor"},{"type":"extras","doc":"The same syntax as for module attributes is used for changing the pre-defined\nmacros `?FILE` and `?LINE`:\n\n```erlang\n-file(File, Line).\n```\n\nThis attribute is used by tools, such as Yecc, to inform the compiler that the\nsource program is generated by another tool. It also indicates the\ncorrespondence of source files to lines of the original user-written file, from\nwhich the source program is produced.","title":"Setting File and Line - Modules","ref":"modules.html#setting-file-and-line"},{"type":"extras","doc":"A similar syntax as for module attributes is used for specifying types and\nfunction specifications:\n\n```erlang\n-type my_type() :: atom() | integer().\n-spec my_function(integer()) -> integer().\n```\n\nRead more in [Types and Function specifications](typespec.md).\n\nThe description is based on\n[EEP8 - Types and function specifications](http://www.erlang.org/eeps/eep-0008.html),\nwhich is not to be further updated.","title":"Types and function specifications - Modules","ref":"modules.html#types-and-function-specifications"},{"type":"extras","doc":"The module attribute `-doc(Documentation)` is used to provide user documentation\nfor a function/type/callback:\n\n```erlang\n-doc(\"Example documentation\").\nexample() -> ok.\n```\n\nThe attribute should be placed just before the entity it documents.The\nparenthesis are optional around `Documentation`. The allowed values for\n`Documentation` are:\n\n- **[literal string](data_types.md#string) or\n  [utf-8 encoded binary string](expressions.md#unicode-segments)** - The string\n  documenting the entity. Any literal string is allowed, so both\n  [triple quoted strings](data_types.md#tqstring) and\n  [sigils](data_types.md#sigil) that translate to literal strings can be used.\n  The following examples are equivalent:\n\n  ```erlang\n  -doc(\"Example \\\"docs\\\"\").\n  -doc(<<\"Example \\\"docs\\\"\"/utf8>>).\n  -doc ~S/Example \"docs\"/.\n  -doc \"\"\"\n     Example \"docs\"\n     \"\"\"\n  -doc ~B|Example \"docs\"|.\n  ```\n\n  For clarity it is recommended to use either normal `\"strings\"` or triple\n  quoted strings for documentation attributes.\n\n- **`{file, ` `t:file:name/0` `}`** - Read the contents of filename and use\n  that as the documentation string.\n\n- **`false`** - Set the current entity as hidden, that is, it should not be\n  listed as an available function and has no documentation.\n\n- **`Metadata :: `[`map()`](`t:erlang:map/0`)** - Metadata about the current\n  entity. Some of the keys in the metadata have a special meaning. See\n  [Moduledoc metadata](`e:system:documentation.md#moduledoc-metadata`) and\n  [Doc metadata](`e:system:documentation.md#doc-metadata`) for more details.\n\nIt is possible to have multiple Metadata doc attributes per entity, but only a\nsingle documentation string entry is allowed.\n\nSee the [Documentation](documentation.md) guide in the Erlang Reference Manual\nfor more details.","title":"Documentation attributes - Modules","ref":"modules.html#documentation-attributes"},{"type":"extras","doc":"While not a module attribute, but rather a directive (since it might affect\nsyntax), there is the `-feature(..)` directive used for enabling and disabling\n[features](`e:system:features.md#features`).\n\nThe syntax is similar to that of an attribute, but has two arguments:\n\n```erlang\n-feature(FeatureName, enable | disable).\n```\n\nNote that the [feature directive](macros.md#feature-directive) can only appear\nin a prefix of the module.","title":"The feature directive - Modules","ref":"modules.html#the-feature-directive"},{"type":"extras","doc":"Comments can be placed anywhere in a module except within strings and\nquoted atoms. A comment begins with the character `%`, and continues\nup to but not including the next end of line. A comment has no effect,\nbeing essentially equivalent to white space.","title":"Comments - Modules","ref":"modules.html#comments"},{"type":"extras","doc":"The compiler automatically inserts the two special, exported functions into each\nmodule:\n\n- `Module:module_info/0`\n- `Module:module_info/1`\n\nWhen called, these functions retrieve information about the module.","title":"module_info/0 and module_info/1 functions - Modules","ref":"modules.html#module_info-0-and-module_info-1-functions"},{"type":"extras","doc":"The `module_info/0` function in each module returns a list of\n`{Key,Value}` tuples with information about the module. At the time\nwriting, the list contain tuples having the following `Key`s:\n`module`, `attributes`, `compile`, `exports`, and `md5`.  The order\nand number of tuples may change without prior notice.","title":"module_info/0 - Modules","ref":"modules.html#module_info-0"},{"type":"extras","doc":"The call `module_info(Key)`, where `Key` is an atom, returns a single piece of\ninformation about the module.\n\nThe following values are allowed for `Key`:\n\n- **`module`** - Returns an atom representing the module name.\n\n- **`attributes`** - Returns a list of `{AttributeName,ValueList}` tuples, where\n  `AttributeName` is the name of an attribute, and `ValueList` is a list of\n  values. Notice that a given attribute can occur more than once in the list\n  with different values if the attribute occurs more than once in the module.\n\n  The list of attributes becomes empty if the module is stripped with\n  `beam_lib:strip/1`.\n\n- **`compile`** - Returns a list of tuples with information about how the module\n  was compiled. This list is empty if the module has been stripped with\n  `beam_lib:strip/1`.\n\n- **`md5`** - Returns a binary representing the MD5 checksum of the module.\n\n- **`exports`** - Returns a list of `{Name,Arity}` tuples with all exported\n  functions in the module.\n\n- **`functions`** - Returns a list of `{Name,Arity}` tuples with all functions\n  in the module.\n\n- **`nifs`** - Returns a list of `{Name,Arity}` tuples with all NIF functions in\n  the module.","title":"module_info/1 - Modules","ref":"modules.html#module_info-1"},{"type":"extras","doc":"<!--\n%CopyrightBegin%\n\nCopyright Ericsson AB 2023-2024. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# Documentation\n\nDocumentation in Erlang is done through the `-moduledoc` and `-doc`\n[attributes](modules.md#module-attributes). For example:\n\n```erlang\n-module(arith).\n-moduledoc \"\"\"\nA module for basic arithmetic.\n\"\"\".\n\n-export([add/2]).\n\n-doc \"Adds two numbers.\".\nadd(One, Two) -> One + Two.\n```\n\nThe `-moduledoc` attribute has to be located before the first `-doc` attribute\nor function declaration. It documents the overall purpose of the module.\n\nThe `-doc` attribute always precedes the [function](ref_man_functions.md) or\n[attribute](modules.md#module-attributes) it documents. The\nattributes that can be documented are\n[user-defined types](typespec.md#type-declarations-of-user-defined-types)\n(`-type` and `-opaque`) and\n[behaviour module attributes](modules.md#behaviour-module-attribute)\n(`-callback`).\n\nBy default the format used for documentation attributes is\n[Markdown](https://en.wikipedia.org/wiki/Markdown) but that can be changed by\nsetting\n[module documentation metadata](#moduledoc-metadata).\n\nA good starting point to writing Markdown is\n[Basic writing and formatting syntax](https://docs.github.com/en/get-started/writing-on-github/getting-started-with-writing-and-formatting-on-github/basic-writing-and-formatting-syntax).\n\nFor details on what is allowed to be part of the `-moduledoc` and `-doc`\nattributes, see\n[Documentation Attributes](modules.md#documentation-attributes).\n\n`-doc` attributes have been available since Erlang/OTP 27.","title":"Documentation","ref":"documentation.html"},{"type":"extras","doc":"It is possible to add metadata to the documentation entry. You do this by adding\na `-moduledoc` or `-doc` attribute with a map as argument. For example:\n\n```erlang\n-module(arith).\n-moduledoc \"\"\"\nA module for basic arithmetic.\n\"\"\".\n-moduledoc #{since => \"1.0\"}.\n\n-export([add/2]).\n\n-doc \"Adds two numbers.\".\n-doc(#{since => \"1.0\"}).\nadd(One, Two) -> One + Two.\n```\n\nThe metadata is used by documentation tools to provide extra information to the\nuser. There can be multiple metadata documentation entries, in which case the\nmaps will be merged with the latest taking precedence if there are duplicate\nkeys. Example:\n\n```erlang\n-doc \"Adds two numbers.\".\n-doc #{since => \"1.0\", author => \"Joe\"}.\n-doc #{since => \"2.0\"}.\nadd(One, Two) -> One + Two.\n```\n\nThis will result in a metadata entry of `#{since => \"2.0\", author => \"Joe\"}`.\n\nThe keys and values in the metadata map can be any type, but it is recommended\nthat only [atoms](data_types.md#atom) are used for keys and\n[strings](data_types.md#string) for the values.","title":"Documentation metadata - Documentation","ref":"documentation.html#documentation-metadata"},{"type":"extras","doc":"The `-moduledoc` and `-doc` can also be placed in external files. To do so use\n`-doc {file, \"path/to/doc.md\"}` to point to the documentation. The path used is\nrelative to the file where the `-doc` attribute is located. For example:\n\n```markdown\n%% doc/add.md\nAdds two numbers.\n```\n\nand\n\n```erlang\n%% src/arith.erl\n-doc({file, \"../doc/add.md\"}).\nadd(One, Two) -> One + Two.\n```","title":"External documentation files - Documentation","ref":"documentation.html#external-documentation-files"},{"type":"extras","doc":"The module description should include details on how to use the API and examples\nof the different functions working together. Here is a good place to use images\nand other diagrams to better show the usage of the module. Instead of writing a\nlong text in the `moduledoc` attribute, it could be better to break it out into\nan external page.\n\nThe `moduledoc` attribute should start with a short paragraph describing the\nmodule and then go into greater details. For example:\n\n````erlang\n-module(arith).\n-moduledoc \"\"\"\n   A module for basic arithmetic.\n\n   This module can be used to add and subtract values. For example:\n\n   ```erlang\n   1> arith:substract(arith:add(2, 3), 1).\n   4\n   ```\n   \"\"\".\n````","title":"Documenting a module - Documentation","ref":"documentation.html#documenting-a-module"},{"type":"extras","doc":"There are three reserved metadata keys for `-moduledoc`:\n\n- `since` - Shows in which version of the application the module was added.\n  If this is added, all functions, types, and callbacks within will also receive\n  the same `since` value unless specified in the metadata of the function, type\n  or callback.\n- `deprecated` - Shows a text in the documentation explaining that it is\n  deprecated and what to use instead.\n- `format` - The format to use for all documentation in this module. The\n  default is `text/markdown`. It should be written using the\n  [mime type](https://developer.mozilla.org/en-US/docs/Web/HTTP/Basics_of_HTTP/MIME_types)\n  of the format.\n\nExample:\n\n```erlang\n-moduledoc {file, \"../doc/arith.asciidoc\"}.\n-moduledoc #{since => \"0.1\", format => \"text/asciidoc\"}.\n-moduledoc #{deprecated => \"Use the Erlang arithmetic operators instead.\"}.\n```","title":"Moduledoc metadata - Documentation","ref":"documentation.html#moduledoc-metadata"},{"type":"extras","doc":"Functions, types, and callbacks can be documented using the `-doc` attribute.\nEach entry should start with a short paragraph describing the purpose of entity,\nand then go into greater detail in needed.\n\nIt is not recommended to include images or diagrams in this documentation as it\nis used by IDEs and `\\c:h/1` to show the documentation to the user.\n\nFor example:\n\n````erlang\n-doc \"\"\"\nA number that can be used by the arith module.\n\nWe use a special number here so that we know\nthat this number comes from this module.\n\"\"\".\n-opaque number() :: {arith, erlang:number()}.\n\n-doc \"\"\"\nAdds two numbers.","title":"Documenting functions, user-defined types, and callbacks - Documentation","ref":"documentation.html#documenting-functions-user-defined-types-and-callbacks"},{"type":"extras","doc":"```\n1> arith:add(arith:number(1), arith:number(2)). {number, 3}\n```\n\"\"\".\n-spec add(number(), number()) -> number().\nadd({number, One}, {number, Two}) -> {number, One + Two}.\n````","title":"Example: - Documentation","ref":"documentation.html#example"},{"type":"extras","doc":"There are four reserved metadata keys for `-doc`:\n\n- `since => unicode:chardata()` - Shows which version of the application the\n  module was added.\n- `deprecated => unicode:chardata()` - Shows a text in the documentation\n  explaining that it is deprecated and what to use instead. The compiler will\n  automatically insert this key if there is a `-deprecated` attribute marking a\n  function as deprecated.\n- `equiv => unicode:chardata() | F/A | F(...)` - Notes that this function is equivalent to\n  another function in this module. The equivalence can be described using either\n  `Func/Arity`, `Func(Args)` or a [unicode string](`t:unicode:chardata/0`). For example:\n\n  ```erlang\n  -doc #{equiv => add/3}.\n  add(One, Two) -> add(One, Two, []).\n  add(One, Two, Options) -> ...\n  ```\n\n  or\n\n  ```erlang\n  -doc #{equiv => add(One, Two, [])}.\n  -spec add(One :: number(), Two :: number()) -> number().\n  add(One, Two) -> add(One, Two, []).\n  add(One, Two, Options) -> ...\n  ```\n\n  The entry into the [EEP-48](`e:kernel:eep48_chapter.md`) doc chunk metadata is\n  the value converted to a string.\n\n- `exported => boolean()` - A `t:boolean/0` signifying if the entry is `exported`\n  or not. This value is automatically set by the compiler and should not be set\n  by the user.","title":"Doc metadata - Documentation","ref":"documentation.html#doc-metadata"},{"type":"extras","doc":"The doc signature is a short text shown to describe the function and its arguments.\nBy default it is determined by looking at the names of the arguments in the\n`-spec` or function. For example:\n\n```erlang\nadd(One, Two) -> One + Two.\n\n-spec sub(One :: integer(), Two :: integer()) -> integer().\nsub(X, Y) -> X - Y.\n```\n\nwill have a signature of `add(One, Two)` and `sub(One, Two)`.\n\nFor types or callbacks, the signature is derived from the type or callback\nspecification. For example:\n\n```erlang\n-type number(Value) :: {number, Value}.\n%% signature will be `number(Value)`\n\n-opaque number() :: {number, number()}.\n%% signature will be `number()`\n\n-callback increment(In :: number()) -> Out.\n%% signature will be `increment(In)`\n\n-callback increment(In) -> Out when In :: number().\n%% signature will be `increment(In)`\n```\n\nIf it is not possible to \"easily\" figure out a nice signature from the code, the\nMFA syntax is used instead. For example: `add/2`, `number/1`, `increment/1`\n\nIt is possible to supply a custom signature by placing it as the first line of the\n`-doc` attribute. The provided signature must be in the form of a function\ndeclaration up until the `->`. For example:\n\n```erlang\n-doc \"\"\"\nadd(One, Two)\n\nAdds two numbers.\n\"\"\".\nadd(A, B) -> A + B.\n```\n\nWill create the signature `add(One, Two)`. The signature will be removed from the\ndocumentation string, so in the example above only the text `\"Adds two numbers\"`\nwill be part of the documentation. This works for functions, types, and\ncallbacks.","title":"Doc signatures - Documentation","ref":"documentation.html#doc-signatures"},{"type":"extras","doc":"When writing documentation in Markdown, links are automatically found in any\ninline code segment that looks like an MFA. For example:\n\n```erlang\n-doc \"See `sub/2` for more details\".\n```\n\nwill create a link to the `sub/2` function in the current module if it exists.\nOne can also use `` `sub/2`  ``as the link target. For example:\n\n```erlang\n-doc \"See [subtract](`sub/2`) for more details\".\n-doc \"See [`sub/2`] for more details\".\n-doc \"\"\"\nSee [subtract] for more details\n\n[subtract]: `sub/2`\n\"\"\".\n-doc \"\"\"\nSee [subtract][1] for more details\n\n[1]: `sub/2`\n\"\"\".\n```\n\nThe above examples result in the same link being created.\n\nThe link can also other entities:\n\n- `remote functions` - Use `module:function/arity` syntax.\n\nExample:\n\n```erlang\n-doc \"See `arith:sub/2` for more details\".\n```\n\n- `modules` - Write the module with a `m` prefix. Use anchors to jump to a\n  specific place in the module.\n\nExample:\n\n```erlang\n-doc \"See `m:arith` for more details\".\n-doc \"See `m:arith#anchor` for more details\".\n```\n\n- `types` - Use the same syntax as for local/remote function but add a `t`\n  prefix.\n\nExample:\n\n```erlang\n-doc \"See `t:number/0` for more details\".\n-doc \"See `t:arith:number/0` for more details\".\n```\n\n- `callbacks` - Use the same syntax as for local/remote function but add a `c`\n  prefix.\n\nExample:\n\n```erlang\n-doc \"See `c:increment/0` for more details\".\n-doc \"See `c:arith:increment/0` for more details\".\n```\n\n- `extra pages` - For extra pages in the current application use a normal link,\n  for example \"`[release notes](notes.md)`\". For extra pages in another\n  application use the `e` prefix and state which application the page belongs\n  to. One can also use anchors to jump to a specific place in the page.\n\nExample:\n\n```erlang\n-doc \"See `e:stdlib:unicode_usage` for more details\".\n-doc \"See `e:stdlib:unicode_usage#notes-about-raw-filenames` for more details\".\n```","title":"Links in Markdown - Documentation","ref":"documentation.html#links-in-markdown"},{"type":"extras","doc":"An Erlang `m:application` normally consists of various public and private\nmodules. That is, modules that should be used by other applications and modules\nthat should not. By default all modules in an application are visible, but by\nsetting `-moduledoc false.` specific modules can be hidden from being listed as\npart of the available API.\n\nAn Erlang [module](modules.md) consists of public and private functions and type\nattributes. By default, all exported functions, exported types and callbacks are\nconsidered visible and part of the modules public API. In addition, any\nnon-exported type that is referred to by any other visible type attribute is\nalso visible, but not considered to be part of the public API. For example:\n\n```erlang\n-export([example/0]).\n\n-type private() :: one.\n-spec example() -> private().\nexample() -> one.\n```\n\nin the above code, the function `example/0` is exported and it referenced the\nun-exported type `private/0`. Therefore both `example/0` and `private/0` will be\nmarked as visible. The `private/0` type will have the metadata field `exported`\nset to `false` to show that it is not part of the public API.\n\nIf you want to make a visible entity hidden you need to set the `-doc` attribute\nto `false`. Let us revisit our previous example:\n\n```erlang\n-export([example/0]).\n\n-type private() :: one.\n-spec example() -> private().\n-doc false.\nexample() -> one.\n```\n\nThe function `example/0` is exported but explicitly marked as hidden; therefore\nboth `example/0` and `private/0` will be hidden.\n\nAny documentation added to an automatically hidden entity (non-exported function\nor type) is ignored and will generate a warning. Such functions can be\ndocumented using comments.","title":"What is visible versus hidden? - Documentation","ref":"documentation.html#what-is-visible-versus-hidden"},{"type":"extras","doc":"The Erlang compiler will by default insert documentation into\n[EEP-48](`e:kernel:eep48_chapter.md`) documentation chunks when compiling a module.\nBy passing the [no_docs](`m:compile#no_docs`) flag to `compile:file/1`,\nor `+no_docs` to [erlc](`e:erts:erlc_cmd.md`), no documentation chunk is inserted.\n\nThe documentation can then be retrieved using `code:get_doc/1`, or viewed using\nthe shell built-in command [`h/1`](`\\\\c:h/1`). For example:\n\n```text\n1> h(arith).\n\n      arith\n\n  A module for basic arithmetic.\n\n2> h(arith, add).\n\n      add(One, Two)\n\n  Adds two numbers.\n```","title":"Compiling and getting documentation - Documentation","ref":"documentation.html#compiling-and-getting-documentation"},{"type":"extras","doc":"[ExDoc](https://hexdocs.pm/ex_doc/) has built-in support to generate\ndocumentation from Markdown. The simplest way is by using the\n[rebar3_ex_doc](https://hexdocs.pm/rebar3_ex_doc) plugin. To set up a\nrebar3 project to use [ExDoc](https://hexdocs.pm/ex_doc/) to generate\ndocumentation add the following to your `rebar3.config`.\n\n```erlang\n%% Enable the plugin\n{plugins, [rebar3_ex_doc]}.\n\n{ex_doc, [\n  {extras, [\"README.md\"]},\n  {main, \"README.md\"},\n  {source_url, \"https://github.com/namespace/your_app\"}\n]}.\n```\n\nWhen configured you can run `rebar3 ex_doc` to generate the\ndocumentation to `doc/index.html`. For more details and options see\nthe [rebar3_ex_doc](https://hexdocs.pm/rebar3_ex_doc) documentation.\n\nYou can also download the\n[release escript bundle](https://github.com/elixir/ex_doc/releases/latest) from\ngithub and run it from the command line. The documentation for using the escript\nis found by running `ex_doc --help`.\n\nIf you are writing documentation that will be using\n[ExDoc](https://hexdocs.pm/ex_doc/) to generate HTML/ePub it is highly\nrecommended to read its documentation.","title":"Using ExDoc to generate HTML/ePub documentation - Documentation","ref":"documentation.html#using-exdoc-to-generate-html-epub-documentation"},{"type":"extras","doc":"<!--\n%CopyrightBegin%\n\nCopyright Ericsson AB 2023-2024. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# Functions\n\n[](){: #syntax }","title":"Functions","ref":"ref_man_functions.html"},{"type":"extras","doc":"A _function declaration_ is a sequence of function clauses separated by\nsemicolons, and terminated by a period (`.`).\n\nA _function clause_ consists of a _clause head_ and a _clause body_, separated by\n`->`.\n\nA clause _head_ consists of the function name, an argument list, and an optional\nguard sequence beginning with the keyword `when`:\n\n```erlang\nName(Pattern11,...,Pattern1N) [when GuardSeq1] ->\n    Body1;\n...;\nName(PatternK1,...,PatternKN) [when GuardSeqK] ->\n    BodyK.\n```\n\nThe function name is an atom. Each argument is a pattern.\n\nThe number of arguments `N` is the _arity_ of the function. A function is\nuniquely defined by the module name, function name, and arity. That is, two\nfunctions with the same name and in the same module, but with different arities\nare two different functions.\n\nA function named `f` in module `mod` and with arity `N` is often denoted as\n`mod:f/N`.\n\nA clause _body_ consists of a sequence of expressions separated by comma (`,`):\n\n```text\nExpr1,\n...,\nExprN\n```\n\nValid Erlang expressions and guard sequences are described in\n[Expressions](expressions.md).\n\n_Example:_\n\n```erlang\nfact(N) when N > 0 ->  % first clause head\n    N * fact(N-1);     % first clause body\n\nfact(0) ->             % second clause head\n    1.                 % second clause body\n```\n\n[](){: #eval }","title":"Function Declaration Syntax - Functions","ref":"ref_man_functions.html#function-declaration-syntax"},{"type":"extras","doc":"When a function `M:F/N` is called, first the code for the function is located.\nIf the function cannot be found, an `undef` runtime error occurs. Notice that\nthe function must be exported to be visible outside the module it is defined in.\n\nIf the function is found, the function clauses are scanned sequentially until a\nclause is found that fulfills both of the following two conditions:\n\n1. The patterns in the clause head can be successfully matched against the given\n   arguments.\n1. The guard sequence, if any, is true.\n\nIf such a clause cannot be found, a `function_clause` runtime error occurs.\n\nIf such a clause is found, the corresponding clause body is evaluated. That is,\nthe expressions in the body are evaluated sequentially and the value of the last\nexpression is returned.\n\nConsider the function `fact`:\n\n```erlang\n-module(mod).\n-export([fact/1]).\n\nfact(N) when N > 0 ->\n    N * fact(N - 1);\nfact(0) ->\n    1.\n```\n\nAssume that you want to calculate the factorial for 1:\n\n```text\n1> mod:fact(1).\n```\n\nEvaluation starts at the first clause. The pattern `N` is matched against\nargument 1. The matching succeeds and the guard (`N > 0`) is true, thus `N` is\nbound to 1, and the corresponding body is evaluated:\n\n```erlang\nN * fact(N-1) => (N is bound to 1)\n1 * fact(0)\n```\n\nNow, `fact(0)` is called, and the function clauses are scanned\nsequentially again. First, the pattern `N` is matched against 0. The\nmatching succeeds, but the guard (`N > 0`) is false. Second, the\npattern `0` is matched against the argument `0`. The matching succeeds\nand the body is evaluated:\n\n```text\n1 * fact(0) =>\n1 * 1 =>\n1\n```\n\nEvaluation has succeed and `mod:fact(1)` returns 1.\n\nIf `mod:fact/1` is called with a negative number as argument, no clause head\nmatches. A `function_clause` runtime error occurs.","title":"Function Evaluation - Functions","ref":"ref_man_functions.html#function-evaluation"},{"type":"extras","doc":"If the last expression of a function body is a function call, a\n_tail-recursive call_ is done. This is to ensure that no system\nresources, for example, call stack, are consumed. This means that an\ninfinite loop using tail-recursive calls will not exhaust the call\nstack and can (in principle) run forever.\n\n_Example:_\n\n```erlang\nloop(N) ->\n    io:format(\"~w~n\", [N]),\n    loop(N+1).\n```\n\nThe earlier factorial example is a counter-example. It is not\ntail-recursive, since a multiplication is done on the result of the recursive\ncall to `fact(N-1)`.","title":"Tail recursion - Functions","ref":"ref_man_functions.html#tail-recursion"},{"type":"extras","doc":"Built-In Functions (BIFs) are implemented in C code in the runtime\nsystem. BIFs do things that are difficult or impossible to implement\nin Erlang. Most of the BIFs belong to module `m:erlang`, but there\nare also BIFs belonging to a few other modules, for example `m:lists`\nand `m:ets`.\n\nThe most commonly used BIFs belonging to `m:erlang` are _auto-imported_. They do\nnot need to be prefixed with the module name. Which BIFs that are auto-imported\nis specified in the `m:erlang` module in ERTS. For example, standard-type\nconversion BIFs like `atom_to_list` and BIFs allowed in guards can be called\nwithout specifying the module name.\n\n_Examples:_\n\n```erlang\n1> tuple_size({a,b,c}).\n3\n2> atom_to_list('Erlang').\n\"Erlang\"\n```","title":"Built-In Functions (BIFs) - Functions","ref":"ref_man_functions.html#built-in-functions-bifs"},{"type":"extras","doc":"<!--\n%CopyrightBegin%\n\nCopyright Ericsson AB 2023-2024. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# Types and Function Specifications","title":"Types and Function Specifications","ref":"typespec.html"},{"type":"extras","doc":"Erlang is a dynamically typed language. Still, it comes with a notation for\ndeclaring sets of Erlang terms to form a particular type. This effectively forms\nspecific subtypes of the set of all Erlang terms.\n\nSubsequently, these types can be used to specify types of record fields and also\nthe argument and return types of functions.\n\nType information can be used for the following:\n\n- To document function interfaces\n- To provide more information for bug detection tools, such as Dialyzer\n- To be leveraged by documentation tools, such as\n  [ExDoc](https://hexdocs.pm/ex_doc/) or [EDoc](`e:edoc:edoc`), for generating\n  documentation\n\nIt is expected that the type language described in this section\nsupersedes and replaces the purely comment-based `@type` and `@spec`\ndeclarations used by EDoc.\n\n[](){: #syntax }","title":"The Erlang Type Language - Types and Function Specifications","ref":"typespec.html#the-erlang-type-language"},{"type":"extras","doc":"Types describe sets of Erlang terms. Types consist of, and are built from, a set\nof predefined types, for example, `t:integer/0`, `t:atom/0`, and `t:pid/0`.\nPredefined types represent a typically infinite set of Erlang terms that belong\nto this type. For example, the type `t:atom/0` denotes the set of all Erlang\natoms.\n\nFor integers and atoms, it is allowed for singleton types; for example, the\nintegers `-1` and `42`, or the atoms `'foo'` and `'bar'`. All other types are\nbuilt using unions of either predefined types or singleton types. In a type\nunion between a type and one of its subtypes, the subtype is absorbed by the\nsupertype. Thus, the union is then treated as if the subtype was not a\nconstituent of the union. For example, the type union:\n\n```text\natom() | 'bar' | integer() | 42\n```\n\ndescribes the same set of terms as the type union:\n\n```text\natom() | integer()\n```\n\nBecause of subtype relations that exist between types, all types, except\n`t:dynamic/0`, form a lattice where the top-most element, `t:any/0`, denotes the\nset of all Erlang terms and the bottom-most element, `t:none/0`, denotes the\nempty set of terms.\n\n[](){: #dynamic }\n\nTo facilitate [gradual typing](https://en.wikipedia.org/wiki/Gradual_typing) of\nErlang, the type `t:dynamic/0` is provided. The type `t:dynamic/0`\nrepresents a statically unknown type. It is similar to\n[Any](https://docs.python.org/3/library/typing.html#the-any-type) in Python,\n[any](https://www.typescriptlang.org/docs/handbook/2/everyday-types.html#any) in\nTypeScript and [dynamic](https://docs.hhvm.com/hack/built-in-types/dynamic) in\nHack. `t:any/0` and `t:dynamic/0` interact with\n[success typing](https://learnyousomeerlang.com/dialyzer#success-typing) the\nsame way, so Dialyzer doesn't distinguish between them.\n\nThe set of predefined types and the syntax for types follows:\n{: #predefined }\n\n```text\nType :: any()                 %% The top type, the set of all Erlang terms\n      | none()                %% The bottom type, contains no terms\n      | dynamic()\n      | pid()\n      | port()\n      | reference()\n      | []                    %% nil\n      | Atom\n      | Bitstring\n      | float()\n      | Fun\n      | Integer\n      | List\n      | Map\n      | Tuple\n      | Union\n      | UserDefined           %% described in Type Declarations of User-Defined Types\n\nAtom :: atom()\n      | Erlang_Atom           %% 'foo', 'bar', ...\n\nBitstring :: <<>>\n           | <<_:M>>          %% M is an Integer_Value that evaluates to a positive integer\n           | <<_:_*N>>        %% N is an Integer_Value that evaluates to a positive integer\n           | <<_:M, _:_*N>>\n\nFun :: fun()                  %% any function\n     | fun((...) -> Type)     %% any arity, returning Type\n     | fun(() -> Type)\n     | fun((TList) -> Type)\n\nInteger :: integer()\n         | Integer_Value\n         | Integer_Value..Integer_Value      %% specifies an integer range\n\nInteger_Value :: Erlang_Integer              %% ..., -1, 0, 1, ... 42 ...\n               | Erlang_Character            %% $a, $b ...\n               | Integer_Value BinaryOp Integer_Value\n               | UnaryOp Integer_Value\n\nBinaryOp :: '*' | 'div' | 'rem' | 'band' | '+' | '-' | 'bor' | 'bxor' | 'bsl' | 'bsr'\n\nUnaryOp :: '+' | '-' | 'bnot'\n\nList :: list(Type)                           %% Proper list ([]-terminated)\n      | maybe_improper_list(Type1, Type2)    %% Type1=contents, Type2=termination\n      | nonempty_improper_list(Type1, Type2) %% Type1 and Type2 as above\n      | nonempty_list(Type)                  %% Proper non-empty list\n\nMap :: #{}                                   %% denotes the empty map\n     | #{AssociationList}\n\nTuple :: tuple()                             %% denotes a tuple of any size\n       | {}\n       | {TList}\n\nAssociationList :: Association\n                 | Association, AssociationList\n\nAssociation :: Type := Type                  %% denotes a mandatory association\n             | Type => Type                  %% denotes an optional association\n\nTList :: Type\n       | Type, TList\n\nUnion :: Type1 | Type2\n```\n\nInteger values are either integer or character literals or expressions\nconsisting of possibly nested unary or binary operations that evaluate to an\ninteger. Such expressions can also be used in bit strings and ranges.\n\nThe general form of bit strings is `<<_:M, _:_*N>>`, where `M` and `N` must\nevaluate to positive integers. It denotes a bit string that is `M + (k*N)` bits\nlong (that is, a bit string that starts with `M` bits and continues with `k`\nsegments of `N` bits each, where `k` is also a positive integer). The notations\n`<<_:_*N>>`, `<<_:M>>`, and `<<>>` are convenient shorthands for the cases that\n`M` or `N`, or both, are zero.\n\nBecause lists are commonly used, they have shorthand type notations. The types\n[`list(T)`](`t:list/1`) and [`nonempty_list(T)`](`t:nonempty_list/1`) have the\nshorthands `[T]` and `[T,...]`, respectively. The only difference between the\ntwo shorthands is that `[T]` can be an empty list but `[T,...]` cannot.\n\nNotice that the shorthand for `t:list/0`, that is, the list of elements of\nunknown type, is `[_]` (or `[any()]`), not `[]`. The notation `[]` specifies the\nsingleton type for the empty list.\n\nThe general form of map types is `#{AssociationList}`. The key types in\n`AssociationList` are allowed to overlap, and if they do, the leftmost\nassociation takes precedence. A map association has a key in `AssociationList`\nif it belongs to this type. `AssociationList` can contain both mandatory `(:=)`\nand optional `(=>)` association types. If an association type is mandatory, an\nassociation with that type needs to be present. In the case of an optional\nassociation type it is not required for the key type to be present.\n\nThe notation `#{}` specifies the singleton type for the empty map. Note that\nthis notation is not a shorthand for the `t:map/0` type.\n\nFor convenience, the following types are also built-in. They can be thought as\npredefined aliases for the type unions also shown in the table.\n\n[](){: #builtin_types }\n\n| _Built-in type_           | _Defined as_                                                                |\n| ------------------------- | --------------------------------------------------------------------------- |\n| `t:term/0`                | `t:any/0`                                                                   |\n| `t:binary/0`              | `<<_:_*8>>`                                                                 |\n| `t:nonempty_binary/0`     | `<<_:8, _:_*8>>`                                                            |\n| `t:bitstring/0`           | `<<_:_*1>>`                                                                 |\n| `t:nonempty_bitstring/0`  | `<<_:1, _:_*1>>`                                                            |\n| `t:boolean/0`             | `'false'` \\| `'true'`                                                       |\n| `t:byte/0`                | `0..255`                                                                    |\n| `t:char/0`                | `0..16#10ffff`                                                              |\n| `t:nil/0`                 | `[]`                                                                        |\n| `t:number/0`              | `t:integer/0` \\| `t:float/0`                                                |\n| `t:list/0`                | `[any()]`                                                                   |\n| `t:maybe_improper_list/0` | [`maybe_improper_list(any(), any())`](`t:maybe_improper_list/2`)            |\n| `t:nonempty_list/0`       | [`nonempty_list(any())`](`t:nonempty_list/1`)                               |\n| `t:string/0`              | `[char()]`                                                                  |\n| `t:nonempty_string/0`     | `[char(),...]`                                                              |\n| `t:iodata/0`              | `iolist()` \\| `binary()`                                                    |\n| `t:iolist/0`              | `maybe_improper_list(byte()` \\| `binary()` \\| `iolist(), binary()` \\| `[])` |\n| `t:map/0`                 | `#{any() => any()}`                                                         |\n| `t:function/0`            | `fun()`                                                                     |\n| `t:module/0`              | `t:atom/0`                                                                  |\n| `t:mfa/0`                 | `{module(),atom(),arity()}`                                                 |\n| `t:arity/0`               | `0..255`                                                                    |\n| `t:identifier/0`          | `pid()` \\| `port()` \\| `reference()`                                        |\n| `node/0`                  | `t:atom/0`                                                                  |\n| `t:timeout/0`             | `'infinity'` \\| `non_neg_integer()`                                         |\n| `t:no_return/0`           | `t:none/0`                                                                  |\n\n_Table: Built-in types, predefined aliases_\n\nIn addition, the following three built-in types exist and can be thought as\ndefined below, though strictly their \"type definition\" is not valid syntax\naccording to the type language defined above.\n\n| _Built-in type_       | _Can be thought defined by the syntax_ |\n| --------------------- | -------------------------------------- |\n| `t:non_neg_integer/0` | `0..`                                  |\n| `t:pos_integer/0`     | `1..`                                  |\n| `t:neg_integer/0`     | `..-1`                                 |\n\n_Table: Additional built-in types_\n\n> #### Note {: .info }\n>\n> The following built-in list types also exist, but they are expected to be\n> rarely used. Hence, they have long names:\n\n```erlang\nnonempty_maybe_improper_list() :: nonempty_maybe_improper_list(any(), any())\nnonempty_improper_list(Type1, Type2)\nnonempty_maybe_improper_list(Type1, Type2)\n```\n\nwhere the last two types define the set of Erlang terms one would expect.\n\nAlso for convenience, record notation is allowed to be used. Records are\nshorthands for the corresponding tuples:\n\n```erlang\nRecord :: #Erlang_Atom{}\n        | #Erlang_Atom{Fields}\n```\n\nRecords are extended to possibly contain type information. This is described in\n[Type Information in Record Declarations](typespec.md#typeinrecords).","title":"Types and their Syntax - Types and Function Specifications","ref":"typespec.html#types-and-their-syntax"},{"type":"extras","doc":"> #### Change {: .info }\n>\n> Starting from Erlang/OTP 26, it is permitted to define a type having the same\n> name as a built-in type.\n\nIt is recommended to avoid deliberately reusing built-in names because it can be\nconfusing. However, when an Erlang/OTP release introduces a new type, code that\nhappened to define its own type having the same name will continue to work.\n\nAs an example, imagine that the Erlang/OTP 42 release introduces a new type\n`gadget()` defined like this:\n\n```erlang\n-type gadget() :: {'gadget', reference()}.\n```\n\nFurther imagine that some code has its own (different) definition of `gadget()`,\nfor example:\n\n```erlang\n-type gadget() :: #{}.\n```\n\nSince redefinitions are allowed, the code will still compile (but with a\nwarning), and Dialyzer will not emit any additional warnings.","title":"Redefining built-in types - Types and Function Specifications","ref":"typespec.html#redefining-built-in-types"},{"type":"extras","doc":"As seen, the basic syntax of a type is an atom followed by closed parentheses.\nNew types are declared using `-type` and `-opaque` attributes as in the\nfollowing:\n\n```erlang\n-type my_struct_type() :: Type.\n-opaque my_opaq_type() :: Type.\n```\n\nThe type name is the atom `my_struct_type`, followed by parentheses. `Type` is a\ntype as defined in the previous section. A current restriction is that `Type`\ncan contain only predefined types, or user-defined types which are either of the\nfollowing:\n\n- Module-local type, that is, with a definition that is present in the code of\n  the module\n- Remote type, that is, type defined in, and exported by, other modules; more\n  about this soon.\n\nFor module-local types, the restriction that their definition exists in the\nmodule is enforced by the compiler and results in a compilation error. (A\nsimilar restriction currently exists for records.)\n\nType declarations can also be parameterized by including type variables between\nthe parentheses. The syntax of type variables is the same as Erlang variables,\nthat is, starts with an upper-case letter. These variables is to\nappear on the RHS of the definition. A concrete example follows:\n\n```erlang\n-type orddict(Key, Val) :: [{Key, Val}].\n```\n\nA module can export some types to declare that other modules are allowed to\nrefer to them as _remote types_. This declaration has the following form:\n\n```erlang\n-export_type([T1/A1, ..., Tk/Ak]).\n```\n\nHere the `Ti`s are atoms (the name of the type) and the `Ai`s are their arguments.\n\n_Example:_\n\n```erlang\n-export_type([my_struct_type/0, orddict/2]).\n```\n\nAssuming that these types are exported from module `'mod'`, you can refer to\nthem from other modules using remote type expressions like the following:\n\n```erlang\nmod:my_struct_type()\nmod:orddict(atom(), term())\n```\n\nIt is not allowed to refer to types that are not declared as exported.\n\nTypes declared as `opaque` represent sets of terms whose structure is not\nsupposed to be visible from outside of their defining module. That is, only the\nmodule defining them is allowed to depend on their term structure. Consequently,\nsuch types do not make much sense as module local - module local types are not\naccessible by other modules anyway - and is always to be exported.\n\nRead more on [Opaques](opaques.md)\n\n[](){: #typeinrecords }","title":"Type Declarations of User-Defined Types - Types and Function Specifications","ref":"typespec.html#type-declarations-of-user-defined-types"},{"type":"extras","doc":"The types of record fields can be specified in the declaration of the record.\nThe syntax for this is as follows:\n\n```erlang\n-record(rec, {field1 :: Type1, field2, field3 :: Type3}).\n```\n\nFor fields without type annotations, their type defaults to `any()`. That is, the\nprevious example is a shorthand for the following:\n\n```erlang\n-record(rec, {field1 :: Type1, field2 :: any(), field3 :: Type3}).\n```\n\nIn the presence of initial values for fields, the type must be declared after\nthe initialization, as follows:\n\n```erlang\n-record(rec, {field1 = [] :: Type1, field2, field3 = 42 :: Type3}).\n```\n\nThe initial values for fields are to be compatible with (that is, a member of)\nthe corresponding types. This is checked by the compiler and results in a\ncompilation error if a violation is detected.\n\n> #### Change {: .info }\n>\n> Before Erlang/OTP 19, for fields without initial values, the singleton type\n> `'undefined'` was added to all declared types. In other words, the following\n> two record declarations had identical effects:\n>\n> ```erlang\n> -record(rec, {f1 = 42 :: integer(),\n>              f2      :: float(),\n>              f3      :: 'a' | 'b'}).\n>\n> -record(rec, {f1 = 42 :: integer(),\n>               f2      :: 'undefined' | float(),\n>               f3      :: 'undefined' | 'a' | 'b'}).\n> ```\n>\n> This is no longer the case. If you require `'undefined'` in your record field\n> type, you must explicitly add it to the typespec, as in the 2nd example.\n\nAny record, containing type information or not, once defined, can be used as a\ntype using the following syntax:\n\n```text\n#rec{}\n```\n\nIn addition, the record fields can be further specified when using a record type\nby adding type information about the field as follows:\n\n```text\n#rec{some_field :: Type}\n```\n\nAny unspecified fields are assumed to have the type in the original record\ndeclaration.\n\n> #### Note {: .info }\n>\n> When records are used to create patterns for ETS and Mnesia match functions,\n> Dialyzer may need some help not to emit bad warnings. For example:\n>\n> ```erlang\n> -type height() :: pos_integer().\n> -record(person, {name :: string(), height :: height()}).\n>\n> lookup(Name, Tab) ->\n>     ets:match_object(Tab, #person{name = Name, _ = '_'}).\n> ```\n>\n> Dialyzer will emit a warning since `'_'` is not in the type of record field\n> `height`.\n>\n> The recommended way of dealing with this is to declare the smallest record\n> field types to accommodate all your needs, and then create refinements as\n> needed. The modified example:\n>\n> ```erlang\n> -record(person, {name :: string(), height :: height() | '_'}).\n>\n> -type person() :: #person{height :: height()}.\n> ```\n>\n> In specifications and type declarations the type `person()` is to be preferred\n> before `#person{}`.","title":"Type Information in Record Declarations - Types and Function Specifications","ref":"typespec.html#type-information-in-record-declarations"},{"type":"extras","doc":"A specification (or contract) for a function is given using the `-spec`\nattribute. The general format is as follows:\n\n```text\n-spec Function(ArgType1, ..., ArgTypeN) -> ReturnType.\n```\n\nAn implementation of the function with the same name `Function` must exist in\nthe current module, and the arity of the function must match the number of\narguments, otherwise the compilation fails.\n\nThe following longer format with module name is also valid as long as `Module`\nis the name of the current module. This can be useful for documentation\npurposes.\n\n```text\n-spec Module:Function(ArgType1, ..., ArgTypeN) -> ReturnType.\n```\n\nAlso, for documentation purposes, argument names can be given:\n\n```text\n-spec Function(ArgName1 :: Type1, ..., ArgNameN :: TypeN) -> RT.\n```\n\nA function specification can be overloaded. That is, it can have several types,\nseparated by a semicolon (`;`). For example:\n\n```erlang\n-spec foo(T1, T2) -> T3;\n         (T4, T5) -> T6.\n```\n\nA current restriction, which currently results in a warning by Dialyzer, is that\nthe domains of the argument types cannot overlap. For example, the following\nspecification results in a warning:\n\n```erlang\n-spec foo(pos_integer()) -> pos_integer();\n         (integer()) -> integer().\n```\n\nType variables can be used in specifications to specify relations for the input\nand output arguments of a function. For example, the following specification\ndefines the type of a polymorphic identity function:\n\n```text\n-spec id(X) -> X.\n```\n\nNotice that the above specification does not restrict the input and output type\nin any way. These types can be constrained by guard-like subtype constraints and\nprovide bounded quantification:\n\n```erlang\n-spec id(X) -> X when X :: tuple().\n```\n\nCurrently, the `::` constraint (read as \"is a subtype of\") is the only guard\nconstraint that can be used in the `when` part of a `-spec` attribute.\n\n> #### Note {: .info }\n>\n> The above function specification uses multiple occurrences of the same type\n> variable. That provides more type information than the following function\n> specification, where the type variables are missing:\n>\n> ```erlang\n> -spec id(tuple()) -> tuple().\n> ```\n>\n> The latter specification says that the function takes some tuple and returns\n> some tuple. The specification with the `X` type variable specifies that the\n> function takes a tuple and returns _the same_ tuple.\n>\n> However, it is up to the tools that process the specifications to choose\n> whether to take this extra information into account or not.\n\nThe scope of a `::` constraint is the `(...) -> RetType` specification after\nwhich it appears. To avoid confusion, it is suggested that different variables\nare used in different constituents of an overloaded contract, as shown in the\nfollowing example:\n\n```erlang\n-spec foo({X, integer()}) -> X when X :: atom();\n         ([Y]) -> Y when Y :: number().\n```\n\nSome functions in Erlang are not meant to return; either because they define\nservers or because they are used to throw exceptions, as in the following\nfunction:\n\n```erlang\nmy_error(Err) -> throw({error, Err}).\n```\n\nFor such functions, it is recommended to use the special `t:no_return/0` type\nfor their \"return\", through a contract of the following form:\n\n```text\n-spec my_error(term()) -> no_return().\n```\n\n> #### Note {: .info }\n>\n> Erlang uses the shorthand version `_` as an anonymous type variable equivalent\n> to `t:term/0` or `t:any/0`. For example, the following function\n>\n> ```text\n> -spec Function(string(), _) -> string().\n> ```\n>\n> is equivalent to:\n>\n> ```text\n> -spec Function(string(), any()) -> string().\n> ```","title":"Specifications for Functions - Types and Function Specifications","ref":"typespec.html#specifications-for-functions"},{"type":"extras","doc":"<!--\n%CopyrightBegin%\n\nCopyright Ericsson AB 2023. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# Opaques","title":"Opaques","ref":"opaques.html"},{"type":"extras","doc":"The main use case for opacity in Erlang is to hide the implementation of a data\ntype, enabling evolving the API while minimizing the risk of breaking consumers.\nThe runtime does not check opacity. Dialyzer provides some opacity-checking, but\nthe rest is up to convention.\n\nThis document explains what Erlang opacity is (and the trade-offs involved) via\nthe example of the [`sets:set()`](`t:sets:set/0`) data type. This type _was_\ndefined in the `sets` module like this:\n\n```erlang\n-opaque set(Element) :: #set{segs :: segs(Element)}.\n```\n\nOTP 24 changed the definition to the following in\n[this commit](https://github.com/erlang/otp/commit/e66941e8d7c47b973dff94c0308ea85a6be1958e).\n\n```erlang\n-opaque set(Element) :: #set{segs :: segs(Element)} | #{Element => ?VALUE}.\n```\n\nAnd this change was safer and more backwards-compatible than if the type had\nbeen defined with `-type` instead of `-opaque`. Here is why: when a module\ndefines an `-opaque`, the contract is that only the defining module should rely\non the definition of the type: no other modules should rely on the definition.\n\nThis means that code that pattern-matched on `set` as a record/tuple technically\nbroke the contract, and opted in to being potentially broken when the definition\nof `set()` changed. Before OTP 24, this code printed `ok`. In OTP 24 it may\nerror:\n\n```erlang\ncase sets:new() of\n    Set when is_tuple(Set) ->\n        io:format(\"ok\")\nend.\n```\n\n**When working with an opaque defined in another module, here are some\nrecommendations:**\n\n- Don't examine the underlying type using pattern-matching, guards, or functions\n  that reveal the type, such as [`tuple_size/1`](`tuple_size/1`) .\n- Instead, use functions provided by the module for working with the type. For\n  example, `sets` module provides `sets:new/0`, `sets:add_element/2`,\n  `sets:is_element/2`, and so on.\n- [`sets:set(a)`](`t:sets:set/1`) is a subtype of `sets:set(a | b)` and not the\n  other way around. Generally, you can rely on the property that `the_opaque(T)`\n  is a subtype of `the_opaque(U)` when T is a subtype of U.\n\n**When defining your own opaques, here are some recommendations:**\n\n- Since consumers are expected to not rely on the definition of the opaque type,\n  you must provide functions for constructing, querying, and deconstructing\n  instances of your opaque type. For example, sets can be constructed with\n  `sets:new/0`, `sets:from_list/1`, `sets:add_element/2`, queried with\n  `sets:is_element/2`, and deconstructed with`sets:to_list/1`.\n- Don't define an opaque with a type variable in parameter position. This breaks\n  the normal and expected behavior that (for example) `my_type(a)` is a subtype\n  of `my_type(a | b)`\n- Add [specs](typespec.md) to exported functions that use the opaque type\n\nNote that opaques can be harder to work with for consumers, since the consumer\nis expected not to pattern-match and must instead use functions that the author\nof the opaque type provides to use instances of the type.\n\nAlso, opacity in Erlang is skin-deep: the runtime does not enforce\nopacity-checking. So now that sets are implemented in terms of maps, an\n[`is_map/1`](`is_map/1`) check on a set _will_ pass. The opacity rules are only\nenforced by convention and by additional tooling such as Dialyzer, and this\nenforcement is not total. A determined consumer of `sets` can still reveal the\nstructure of the set, for example by printing, serializing, or using a set as a\n`t:term/0` and inspecting it via functions like [`is_map/1`](`is_map/1`) or\n`maps:get/2`. Also, Dialyzer must make some\n[approximations](https://github.com/erlang/otp/issues/5118).","title":"Opaque Type Aliases - Opaques","ref":"opaques.html#opaque-type-aliases"},{"type":"extras","doc":"<!--\n%CopyrightBegin%\n\nCopyright Ericsson AB 2023-2025. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# Expressions\n\nIn this section, all valid Erlang expressions are listed. When writing Erlang\nprograms, it is also allowed to use macro and record expressions. However,\nthese expressions are expanded during compilation and are in that sense not true\nErlang expressions. Macro and record expressions are covered in separate\nsections:\n\n- [Preprocessor](macros.md)\n- [Records](ref_man_records.md)","title":"Expressions","ref":"expressions.html"},{"type":"extras","doc":"All subexpressions are evaluated before an expression itself is evaluated,\nunless explicitly stated otherwise. For example, consider the expression:\n\n```\nExpr1 + Expr2\n```\n\n`Expr1` and `Expr2`, which are also expressions, are evaluated first — in any\norder — before the addition is performed.\n\nMany of the operators can only be applied to arguments of a certain type. For\nexample, arithmetic operators can only be applied to numbers. An argument of the\nwrong type causes a `badarg` runtime error.","title":"Expression Evaluation - Expressions","ref":"expressions.html#expression-evaluation"},{"type":"extras","doc":"The simplest form of expression is a term, that is one of\n`t:integer/0`, `t:float/0`, `t:atom/0`, `t:string/0`, `t:list/0`,\n`t:map/0`, or `t:tuple/0`. The return value is the term itself.","title":"Terms - Expressions","ref":"expressions.html#terms"},{"type":"extras","doc":"A variable is an expression. If a variable is bound to a value, the return value\nis this value. Unbound variables are only allowed in patterns.\n\nVariables start with an uppercase letter or underscore (`_`). Variables can\ncontain alphanumeric characters, underscore, and `@`.\n\n_Examples:_\n\n```\nX\nName1\nPhoneNumber\nPhone_number\n_\n_Height\nname@node\n```\n\nVariables are bound to values using [pattern matching](patterns.md). Erlang uses\n_single assignment_, that is, a variable can only be bound once.\n\nThe _anonymous variable_ is denoted by underscore (\\_) and can be used when a\nvariable is required but its value can be ignored.\n\n_Example:_\n\n```text\n[H|_] = [1,2,3]\n```\n\nVariables starting with underscore (`_`), for example, `_Height`, are normal\nvariables, not anonymous. However, they are ignored by the compiler in the sense\nthat they do not generate warnings.\n\n_Example:_\n\nThe following code:\n\n```\nmember(_, []) ->\n    [].\n```\n\ncan be rewritten to be more readable:\n\n```\nmember(Elem, []) ->\n    [].\n```\n\nThis causes a warning for an unused variable, `Elem`. To avoid the warning,\nthe code can be rewritten to:\n\n```\nmember(_Elem, []) ->\n    [].\n```\n\nNotice that since variables starting with an underscore are not anonymous, the\nfollowing example matches:\n\n```\n{_,_} = {1,2}\n```\n\nBut this example fails:\n\n```\n{_N,_N} = {1,2}\n```\n\nThe scope for a variable is its function clause. Variables bound in a branch of\nan `if`, `case`, or `receive` expression must be bound in all branches to have a\nvalue outside the expression. Otherwise they are regarded as unsafe outside\nthe expression.\n\nFor the `try` expression variable scoping is limited so that variables bound in\nthe expression are always unsafe outside the expression.","title":"Variables - Expressions","ref":"expressions.html#variables"},{"type":"extras","doc":"A pattern has the same structure as a term but can contain unbound variables.\n\n_Example:_\n\n```\nName1\n[H|T]\n{error,Reason}\n```\n\nPatterns are allowed in clause heads, [case expressions](expressions.md#case),\n[receive expressions](expressions.md#receive), and\n[match expressions](expressions.md#the-match-operator).","title":"Patterns - Expressions","ref":"expressions.html#patterns"},{"type":"extras","doc":"If `Pattern1` and `Pattern2` are valid patterns, the following is also a valid\npattern:\n\n```\nPattern1 = Pattern2\n```\n\nWhen matched against a term, both `Pattern1` and `Pattern2` are matched against\nthe term. The idea behind this feature is to avoid reconstruction of terms.\n\n_Example:_\n\n```\nf({connect,From,To,Number,Options}, To) ->\n    Signal = {connect,From,To,Number,Options},\n    ...;\nf(Signal, To) ->\n    ignore.\n```\n\ncan instead be written as\n\n```\nf({connect,_,To,_,_} = Signal, To) ->\n    ...;\nf(Signal, To) ->\n    ignore.\n```\n\nThe compound pattern operator does not imply that its operands are matched in\nany particular order. That means that it is not legal to bind a variable in\n`Pattern1` and use it in `Pattern2`, or vice versa.","title":"The Compound Pattern Operator - Expressions","ref":"expressions.html#the-compound-pattern-operator"},{"type":"extras","doc":"When matching strings, the following is a valid pattern:\n\n```\nf(\"prefix\" ++ Str) -> ...\n```\n\nThis is syntactic sugar for the equivalent, but harder to read:\n\n```\nf([$p,$r,$e,$f,$i,$x | Str]) -> ...\n```","title":"String Prefix in Patterns - Expressions","ref":"expressions.html#string-prefix-in-patterns"},{"type":"extras","doc":"An arithmetic expression can be used within a pattern if it meets both of the\nfollowing two conditions:\n\n- It uses only numeric or bitwise operators.\n- Its value can be evaluated to a constant when complied.\n\n_Example:_\n\n```\ncase {Value, Result} of\n    {?THRESHOLD+1, ok} -> ...\n```","title":"Expressions in Patterns - Expressions","ref":"expressions.html#expressions-in-patterns"},{"type":"extras","doc":"The following matches `Pattern` against `Expr`:\n\n```\nPattern = Expr\n```\n\nIf the matching succeeds, any unbound variable in the pattern becomes bound and\nthe value of `Expr` is returned.\n\nIf multiple match operators are applied in sequence, they will be evaluated from\nright to left.\n\nIf the matching fails, a `badmatch` run-time error occurs.\n\n_Examples:_\n\n```\n1> {A, B} = T = {answer, 42}.\n{answer,42}\n2> A.\nanswer\n3> B.\n42\n4> T.\n{answer,42}\n5> {C, D} = [1, 2].\n** exception error: no match of right-hand side value [1,2]\n```\n\nBecause multiple match operators are evaluated from right to left, it means\nthat:\n\n```\nPattern1 = Pattern2 = . . . = PatternN = Expression\n```\n\nis equivalent to:\n\n```\nTemporary = Expression,\nPatternN = Temporary,\n   .\n   .\n   .,\nPattern2 = Temporary,\nPattern = Temporary\n```","title":"The Match Operator - Expressions","ref":"expressions.html#the-match-operator"},{"type":"extras","doc":"> #### Note {: .info }\n>\n> This is an advanced section, which references to topics not yet introduced. It\n> can safely be skipped on a first reading.\n\nThe `=` character is used to denote two similar but distinct operators: the\nmatch operator and the compound pattern operator. Which one is meant is\ndetermined by context.\n\nThe _compound pattern operator_ is used to construct a compound pattern from two\npatterns. Compound patterns are accepted everywhere a pattern is accepted. A\ncompound pattern matches if all of its constituent patterns match. It is not\nlegal for a pattern that is part of a compound pattern to use variables (as keys\nin map patterns or sizes in binary patterns) bound in other sub patterns of the\nsame compound pattern.\n\n_Examples:_\n\n```\n1> fun(#{Key := Value} = #{key := Key}) -> Value end.\n* 1:7: variable 'Key' is unbound\n2> F = fun({A, B} = E) -> {E, A + B} end, F({1,2}).\n{{1,2},3}\n3> G = fun(< > = < >) -> {A, B, C} end, G(<<42,43>>).\n{42,43,10795}\n```\n\nThe _match operator_ is allowed everywhere an expression is allowed. It is used\nto match the value of an expression to a pattern. If multiple match operators\nare applied in sequence, they will be evaluated from right to left.\n\n_Examples:_\n\n```\n1> M = #{key => key2, key2 => value}.\n#{key => key2,key2 => value}\n2> f(Key), #{Key := Value} = #{key := Key} = M, Value.\nvalue\n3> f(Key), #{Key := Value} = (#{key := Key} = M), Value.\nvalue\n4> f(Key), (#{Key := Value} = #{key := Key}) = M, Value.\n* 1:12: variable 'Key' is unbound\n5> < > = begin Y = 8, <<42:8>> end, X.\n42\n```\n\nThe expression at prompt `2>` first matches the value of variable `M` against\npattern `#{key := Key}`, binding variable `Key`. It then matches the value of\n`M` against pattern `#{Key := Value}` using variable `Key` as the key, binding\nvariable `Value`.\n\nThe expression at prompt `3>` matches expression `(#{key := Key} = M)` against\npattern `#{Key := Value}`. The expression inside the parentheses is evaluated\nfirst. That is, `M` is matched against `#{key := Key}`, and then the value of\n`M` is matched against pattern `#{Key := Value}`. That is the same evaluation\norder as in _2_; therefore, the parentheses are redundant.\n\nIn the expression at prompt `4>` the expression `M` is matched against a pattern\ninside parentheses. Since the construct inside the parentheses is a pattern, the\n`=` that separates the two patterns is the compound pattern operator (_not_ the\nmatch operator). The match fails because the two sub patterns are matched at the\nsame time, and the variable `Key` is therefore not bound when matching against\npattern `#{Key := Value}`.\n\nIn the expression at prompt `5>` the expressions inside the\n[block expression](expressions.md#block-expressions) are evaluated first,\nbinding variable `Y` and creating a binary. The binary is then matched against\npattern `< >` using the value of `Y` as the size of the segment.","title":"The Match Operator and the Compound Pattern Operator - Expressions","ref":"expressions.html#the-match-operator-and-the-compound-pattern-operator"},{"type":"extras","doc":"```\nExprF(Expr1,...,ExprN)\nExprM:ExprF(Expr1,...,ExprN)\n```\n\nIn the first form of function calls, `ExprM:ExprF(Expr1,...,ExprN)`, each of\n`ExprM` and `ExprF` must be an atom or an expression that evaluates to an atom.\nThe function is said to be called by using the _fully qualified function name_.\nThis is often referred to as a _remote_ or _external function call_.\n\n_Example:_\n\n```\nlists:keyfind(Name, 1, List)\n```\n\nIn the second form of function calls, `ExprF(Expr1,...,ExprN)`, `ExprF` must be\nan atom or evaluate to a fun.\n\nIf `ExprF` is an atom, the function is said to be called by using the\n_implicitly qualified function name_. If the function `ExprF` is locally\ndefined, it is called. Alternatively, if `ExprF` is explicitly imported from the\n`M` module, `M:ExprF(Expr1,...,ExprN)` is called. If `ExprF` is neither declared\nlocally nor explicitly imported, `ExprF` must be the name of an automatically\nimported BIF.\n\n_Examples:_\n\n```\nhandle(Msg, State)\nspawn(m, init, [])\n```\n\n_Examples_ where `ExprF` is a fun:\n\n```\n1> Fun1 = fun(X) -> X+1 end,\nFun1(3).\n4\n2> fun lists:append/2([1,2], [3,4]).\n[1,2,3,4]\n3>\n```\n\nNotice that when calling a local function, there is a difference between using\nthe implicitly or fully qualified function name. The latter always refers to the\nlatest version of the module. See\n[Compilation and Code Loading ](code_loading.md)and\n[Function Evaluation](ref_man_functions.md#eval).","title":"Function Calls - Expressions","ref":"expressions.html#function-calls"},{"type":"extras","doc":"If a local function has the same name as an auto-imported BIF, the semantics is\nthat implicitly qualified function calls are directed to the locally defined\nfunction, not to the BIF. To avoid confusion, there is a compiler directive\navailable, `-compile({no_auto_import,[F/A]})`, that makes a BIF not being\nauto-imported. In certain situations, such a compile-directive is mandatory.\n\n> #### Change {: .info }\n>\n> Before Erlang/OTP R14A (ERTS version 5.8), an implicitly qualified function call to a\n> function having the same name as an auto-imported BIF always resulted in the\n> BIF being called. In newer versions of the compiler, the local function is\n> called instead. This is to avoid that future additions to the set of\n> auto-imported BIFs do not silently change the behavior of old code.\n\nHowever, to avoid that old (pre R14) code changed its behavior when compiled\nwith Erlang/OTP version R14A or later, the following restriction applies: If you\noverride the name of a BIF that was auto-imported in OTP versions prior to R14A\n(ERTS version 5.8) and have an implicitly qualified call to that function in\nyour code, you either need to explicitly remove the auto-import using a compiler\ndirective, or replace the call with a fully qualified function call. Otherwise\nyou get a compilation error. See the following example:\n\n```\n-export([length/1,f/1]).\n\n-compile({no_auto_import,[length/1]}). % erlang:length/1 no longer autoimported\n\nlength([]) ->\n    0;\nlength([H|T]) ->\n    1 + length(T). %% Calls the local function length/1\n\nf(X) when erlang:length(X) > 3 -> %% Calls erlang:length/1,\n                                  %% which is allowed in guards\n    long.\n```\n\nThe same logic applies to explicitly imported functions from other modules, as\nto locally defined functions. It is not allowed to both import a function from\nanother module and have the function declared in the module at the same time:\n\n```\n-export([f/1]).\n\n-compile({no_auto_import,[length/1]}). % erlang:length/1 no longer autoimported\n\n-import(mod,[length/1]).\n\nf(X) when erlang:length(X) > 33 -> %% Calls erlang:length/1,\n                                   %% which is allowed in guards\n\n    erlang:length(X);              %% Explicit call to erlang:length in body\n\nf(X) ->\n    length(X).                     %% mod:length/1 is called\n```\n\nFor auto-imported BIFs added in Erlang/OTP R14A and thereafter, overriding the\nname with a local function or explicit import is always allowed. However, if the\n`-compile({no_auto_import,[F/A])` directive is not used, the compiler issues a\nwarning whenever the function is called in the module using the implicitly\nqualified function name.","title":"Local Function Names Clashing With Auto-Imported BIFs - Expressions","ref":"expressions.html#local-function-names-clashing-with-auto-imported-bifs"},{"type":"extras","doc":"```\nif\n    GuardSeq1 ->\n        Body1;\n    ...;\n    GuardSeqN ->\n        BodyN\nend\n```\n\nThe branches of an `if`\\-expression are scanned sequentially until a guard\nsequence `GuardSeq` that evaluates to true is found. Then the corresponding\n`Body` (a sequence of expressions separated by `,`) is evaluated.\n\nThe return value of `Body` is the return value of the `if` expression.\n\nIf no guard sequence is evaluated as true, an `if_clause` run-time error occurs.\nIf necessary, the guard expression `true` can be used in the last branch, as\nthat guard sequence is always true.\n\n_Example:_\n\n```\nis_greater_than(X, Y) ->\n    if\n        X > Y ->\n            true;\n        true -> % works as an 'else' branch\n            false\n    end\n```","title":"If - Expressions","ref":"expressions.html#if"},{"type":"extras","doc":"```\ncase Expr of\n    Pattern1 [when GuardSeq1] ->\n        Body1;\n    ...;\n    PatternN [when GuardSeqN] ->\n        BodyN\nend\n```\n\nThe expression `Expr` is evaluated and the patterns `Pattern` are sequentially\nmatched against the result. If a match succeeds and the optional guard sequence\n`GuardSeq` is true, the corresponding `Body` is evaluated.\n\nThe return value of `Body` is the return value of the `case` expression.\n\nIf there is no matching pattern with a true guard sequence, a `case_clause`\nrun-time error occurs.\n\n_Example:_\n\n```\nis_valid_signal(Signal) ->\n    case Signal of\n        {signal, _What, _From, _To} ->\n            true;\n        {signal, _What, _To} ->\n            true;\n        _Else ->\n            false\n    end.\n```","title":"Case - Expressions","ref":"expressions.html#case"},{"type":"extras","doc":"> #### Change {: .info }\n>\n> The `maybe` [feature](`e:system:features.md#features`) was introduced\n> in Erlang/OTP 25. Starting from Erlang/OTP 27 is is enabled by default.\n\n```\nmaybe\n    Expr1,\n    ...,\n    ExprN\nend\n```\n\nThe expressions in a `maybe` block are evaluated sequentially. If all\nexpressions are evaluated successfully, the return value of the `maybe` block is\n`ExprN`. However, execution can be short-circuited by a conditional match\nexpression:\n\n```\nExpr1 ?= Expr2\n```\n\n`?=` is called the conditional match operator. It is only allowed to be used at\nthe top-level of a `maybe` block. It matches the pattern `Expr1` against\n`Expr2`. If the matching succeeds, any unbound variable in the pattern becomes\nbound. If the expression is the last expression in the `maybe` block, it also\nreturns the value of `Expr2`. If the matching is unsuccessful, the rest of the\nexpressions in the `maybe` block are skipped and the return value of the `maybe`\nblock is `Expr2`.\n\nNone of the variables bound in a `maybe` block must be used in the code that\nfollows the block.\n\nHere is an example:\n\n```\nmaybe\n    {ok, A} ?= a(),\n    true = A >= 0,\n    {ok, B} ?= b(),\n    A + B\nend\n```\n\nLet us first assume that `a()` returns `{ok,42}` and `b()` returns `{ok,58}`.\nWith those return values, all of the match operators will succeed, and the\nreturn value of the `maybe` block is `A + B`, which is equal to `42 + 58 = 100`.\n\nNow let us assume that `a()` returns `error`. The conditional match operator in\n`{ok, A} ?= a()` fails to match, and the return value of the `maybe` block is\nthe value of the expression that failed to match, namely `error`. Similarly, if\n`b()` returns `wrong`, the return value of the `maybe` block is `wrong`.\n\nFinally, let us assume that `a()` returns `{ok,-1}`. Because `true = A >= 0` uses\nthe match operator `=`, a `{badmatch,false}` run-time error occurs when the\nexpression fails to match the pattern.\n\nThe example can be written in a less succient way using nested case expressions:\n\n```\ncase a() of\n    {ok, A} ->\n        true = A >= 0,\n        case b() of\n            {ok, B} ->\n                A + B;\n            Other1 ->\n                Other1\n        end;\n    Other2 ->\n        Other2\nend\n```\n\nThe `maybe` block can be augmented with `else` clauses:\n\n```\nmaybe\n    Expr1,\n    ...,\n    ExprN\nelse\n    Pattern1 [when GuardSeq1] ->\n        Body1;\n    ...;\n    PatternN [when GuardSeqN] ->\n        BodyN\nend\n```\n\nIf a conditional match operator fails, the failed expression is matched against\nthe patterns in all clauses between the `else` and `end` keywords. If a match\nsucceeds and the optional guard sequence `GuardSeq` is true, the corresponding\n`Body` is evaluated. The value returned from the body is the return value of the\n`maybe` block.\n\nIf there is no matching pattern with a true guard sequence, an `else_clause`\nrun-time error occurs.\n\nNone of the variables bound in a `maybe` block must be used in the `else`\nclauses. None of the variables bound in the `else` clauses must be used in the\ncode that follows the `maybe` block.\n\nHere is the previous example augmented with `else` clauses:\n\n```\nmaybe\n    {ok, A} ?= a(),\n    true = A >= 0,\n    {ok, B} ?= b(),\n    A + B\nelse\n    error -> error;\n    wrong -> error\nend\n```\n\nThe `else` clauses translate the failing value from the conditional match\noperators to the value `error`. If the failing value is not one of the\nrecognized values, a `else_clause` run-time error occurs.","title":"Maybe - Expressions","ref":"expressions.html#maybe"},{"type":"extras","doc":"```\nExpr1 ! Expr2\n```\n\nSends the value of `Expr2` as a message to the process specified by `Expr1`. The\nvalue of `Expr2` is also the return value of the expression.\n\n`Expr1` must evaluate to a pid, an alias (reference), a port, a registered name\n(atom), or a tuple `{Name,Node}`. `Name` is an atom and `Node` is a node name,\nalso an atom.\n\n- If `Expr1` evaluates to a name, but this name is not registered, a `badarg`\n  run-time error occurs.\n- Sending a message to a reference never fails, even if the reference is no\n  longer (or never was) an alias.\n- Sending a message to a pid never fails, even if the pid identifies a\n  non-existing process.\n- Distributed message sending, that is, if `Expr1` evaluates to a tuple\n  `{Name,Node}` (or a pid located at another node), also never fails.","title":"Send - Expressions","ref":"expressions.html#send"},{"type":"extras","doc":"```\nreceive\n    Pattern1 [when GuardSeq1] ->\n        Body1;\n    ...;\n    PatternN [when GuardSeqN] ->\n        BodyN\nend\n```\n\nFetches a received message present in the message queue of the process. The\nfirst message in the message queue is matched sequentially against the patterns\nfrom top to bottom. If no match was found, the matching sequence is repeated for\nthe second message in the queue, and so on. Messages are queued in the\n[order they were received](ref_man_processes.md#message-queue-order). If a match\nsucceeds, that is, if the `Pattern` matches and the optional guard sequence\n`GuardSeq` is true, then the message is removed from the message queue and the\ncorresponding `Body` is evaluated. All other messages in the message queue\nremain unchanged.\n\nThe return value of `Body` is the return value of the `receive` expression.\n\n`receive` never fails. The execution is suspended, possibly indefinitely, until\na message arrives that matches one of the patterns and with a true guard\nsequence.\n\n_Example:_\n\n```\nwait_for_onhook() ->\n    receive\n        onhook ->\n            disconnect(),\n            idle();\n        {connect, B} ->\n            B ! {busy, self()},\n            wait_for_onhook()\n    end.\n```\n\nThe `receive` expression can be augmented with a timeout:\n\n```\nreceive\n    Pattern1 [when GuardSeq1] ->\n        Body1;\n    ...;\n    PatternN [when GuardSeqN] ->\n        BodyN\nafter\n    ExprT ->\n        BodyT\nend\n```\n\n`receive...after` works exactly as `receive`, except that if no matching message\nhas arrived within `ExprT` milliseconds, then `BodyT` is evaluated instead. The\nreturn value of `BodyT` then becomes the return value of the `receive...after`\nexpression. `ExprT` is to evaluate to an integer, or the atom `infinity`. The\nallowed integer range is from 0 to 4294967295, that is, the longest possible\ntimeout is almost 50 days. With a zero value the timeout occurs immediately if\nthere is no matching message in the message queue.\n\nThe atom `infinity` will make the process wait indefinitely for a matching\nmessage. This is the same as not using a timeout. It can be useful for timeout\nvalues that are calculated at runtime.\n\n_Example:_\n\n```\nwait_for_onhook() ->\n    receive\n        onhook ->\n            disconnect(),\n            idle();\n        {connect, B} ->\n            B ! {busy, self()},\n            wait_for_onhook()\n    after\n        60000 ->\n            disconnect(),\n            error()\n    end.\n```\n\nIt is legal to use a `receive...after` expression with no branches:\n\n```\nreceive\nafter\n    ExprT ->\n        BodyT\nend\n```\n\nThis construction does not consume any messages, only suspends execution in the\nprocess for `ExprT` milliseconds. This can be used to implement simple timers.\n\n_Example:_\n\n```\ntimer() ->\n    spawn(m, timer, [self()]).\n\ntimer(Pid) ->\n    receive\n    after\n        5000 ->\n            Pid ! timeout\n    end.\n```\n\nFor more information on timers in Erlang in general, see the\n[*Timers*](`e:erts:time_correction.md#timers`) section of the\n[*Time and Time Correction in Erlang*](`e:erts:time_correction.md`)\nERTS User's guide.","title":"Receive - Expressions","ref":"expressions.html#receive"},{"type":"extras","doc":"```\nExpr1 op Expr2\n```\n\n| _op_   | _Description_            |\n| ------ | ------------------------ |\n| `==`   | Equal to                 |\n| `/=`   | Not equal to             |\n| `=<`   | Less than or equal to    |\n| `<`    | Less than                |\n| `>=`   | Greater than or equal to |\n| `>`    | Greater than             |\n| `=:=`  | Term equivalence         |\n| `=/=`  | Term non-equivalence     |\n\n_Table: Term Comparison Operators._\n\nThe arguments can be of different data types. The following order is defined:\n\n```text\nnumber   1 == 1.0.\ntrue\n2> 1 =:= 1.0.\nfalse\n3> 0 =:= 0.0.\nfalse\n4> 0.0 =:= -0.0.\nfalse\n5> 0.0 =:= +0.0.\ntrue\n6> 1 > a.\nfalse\n7> #{c => 3} > #{a => 1, b => 2}.\nfalse\n8> #{a => 1, b => 2} == #{a => 1.0, b => 2.0}.\ntrue\n9> <<2:2>> < <<128>>.\ntrue\n10> <<3:2>> < <<128>>.\nfalse\n```\n\n> #### Note {: .info }\n>\n> Prior to OTP 27, the term equivalence operators considered `0.0`\n> and `-0.0` to be the same term.\n>\n> This was changed in OTP 27 but legacy code may have expected them to be\n> considered the same. To help users catch errors that may arise from an\n> upgrade, the compiler raises a warning when `0.0` is pattern-matched or used\n> in a term equivalence test.\n>\n> If you need to match `0.0` specifically, the warning can be silenced by\n> writing `+0.0` instead, which produces the same term but makes the compiler\n> interpret the match as being done on purpose.","title":"Term Comparisons - Expressions","ref":"expressions.html#term-comparisons"},{"type":"extras","doc":"```\nop Expr\nExpr1 op Expr2\n```\n\n| _Operator_   | _Description_             | _Argument Type_ |\n| ------------ | ------------------------- | --------------- |\n| `+`          | Unary +                   | Number          |\n| `-`          | Negation (unary -)        | Number          |\n| `+`          | Addition                  | Number          |\n| `-`          | Subtraction               | Number          |\n| `*`          | Multiplication            | Number          |\n| `/`          | Floating point division   | Number          |\n| `bnot`       | Unary bitwise NOT         | Integer         |\n| `div`        | Integer division          | Integer         |\n| `rem`        | Integer remainder of X/Y  | Integer         |\n| `band`       | Bitwise AND               | Integer         |\n| `bor`        | Bitwise OR                | Integer         |\n| `bxor`       | Bitwise XOR               | Integer         |\n| `bsl`        | Bitshift left             | Integer         |\n| `bsr`        | Arithmetic bitshift right | Integer         |\n\n_Table: Arithmetic Operators._\n\n_Examples:_\n\n```\n1> +1.\n1\n2> -1.\n-1\n3> 1+1.\n2\n4> 4/2.\n2.0\n5> 5 div 2.\n2\n6> 5 rem 2.\n1\n7> 2#10 band 2#01.\n0\n8> 2#10 bor 2#01.\n3\n9> a + 10.\n** exception error: an error occurred when evaluating an arithmetic expression\n     in operator  +/2\n        called as a + 10\n10> 1 bsl (1 bsl 64).\n** exception error: a system limit has been reached\n     in operator  bsl/2\n        called as 1 bsl 18446744073709551616\n```","title":"Arithmetic Expressions - Expressions","ref":"expressions.html#arithmetic-expressions"},{"type":"extras","doc":"```\nop Expr\nExpr1 op Expr2\n```\n\n| _Operator_ | _Description_     |\n| ---------- | ----------------- |\n| `not`      | Unary logical NOT |\n| `and`      | Logical AND       |\n| `or`       | Logical OR        |\n| `xor`      | Logical XOR       |\n\n_Table: Logical Operators._\n\n_Examples:_\n\n```\n1> not true.\nfalse\n2> true and false.\nfalse\n3> true xor false.\ntrue\n4> true or garbage.\n** exception error: bad argument\n     in operator  or/2\n        called as true or garbage\n```","title":"Boolean Expressions - Expressions","ref":"expressions.html#boolean-expressions"},{"type":"extras","doc":"```\nExpr1 orelse Expr2\nExpr1 andalso Expr2\n```\n\n`Expr2` is evaluated only if necessary. That is, `Expr2` is evaluated only if:\n\n- `Expr1` evaluates to `false` in an `orelse` expression.\n\nor\n\n- `Expr1` evaluates to `true` in an `andalso` expression.\n\nReturns either the value of `Expr1` (that is, `true` or `false`) or the value of\n`Expr2` (if `Expr2` is evaluated).\n\n_Example 1:_\n\n```\ncase A >= -1.0 andalso math:sqrt(A+1) > B of\n```\n\nThis works even if `A` is less than `-1.0`, since in that case, `math:sqrt/1` is\nnever evaluated.\n\n_Example 2:_\n\n```\nOnlyOne = is_atom(L) orelse\n         (is_list(L) andalso length(L) == 1),\n```\n\n`Expr2` is not required to evaluate to a Boolean value. Because of that,\n`andalso` and `orelse` are tail-recursive.\n\n_Example 3 (tail-recursive function):_\n\n```\nall(Pred, [Hd|Tail]) ->\n    Pred(Hd) andalso all(Pred, Tail);\nall(_, []) ->\n    true.\n```\n\n> #### Change {: .info }\n>\n> Before Erlang/OTP R13A, `Expr2` was required to evaluate to a Boolean value,\n> and as consequence, `andalso` and `orelse` were **not** tail-recursive.","title":"Short-Circuit Expressions - Expressions","ref":"expressions.html#short-circuit-expressions"},{"type":"extras","doc":"```\nExpr1 ++ Expr2\nExpr1 -- Expr2\n```\n\nThe list concatenation operator `++` appends its second argument to its first\nand returns the resulting list.\n\nThe list subtraction operator `--` produces a list that is a copy of the first\nargument. The procedure is as follows: for each element in the second argument,\nthe first occurrence of this element (if any) is removed.\n\n_Example:_\n\n```\n1> [1,2,3] ++ [4,5].\n[1,2,3,4,5]\n2> [1,2,3,2,1,2] -- [2,1,2].\n[3,1,2]\n```","title":"List Operations - Expressions","ref":"expressions.html#list-operations"},{"type":"extras","doc":"","title":"Map Expressions - Expressions","ref":"expressions.html#map-expressions"},{"type":"extras","doc":"Constructing a new map is done by letting an expression `K` be associated with\nanother expression `V`:\n\n```\n#{K => V}\n```\n\nNew maps can include multiple associations at construction by listing every\nassociation:\n\n```\n#{K1 => V1, ..., Kn => Vn}\n```\n\nAn empty map is constructed by not associating any terms with each other:\n\n```\n#{}\n```\n\nAll keys and values in the map are terms. Any expression is first evaluated and\nthen the resulting terms are used as _key_ and _value_ respectively.\n\nKeys and values are separated by the `=>` arrow and associations are separated\nby a comma (`,`).\n\n_Examples:_\n\n```\nM0 = #{},                 % empty map\nM1 = #{a => <<\"hello\">>}, % single association with literals\nM2 = #{1 => 2, b => b},   % multiple associations with literals\nM3 = #{k => {A,B}},       % single association with variables\nM4 = #{{\"w\", 1} => f()}.  % compound key associated with an evaluated expression\n```\n\nHere, `A` and `B` are any expressions and `M0` through `M4` are the resulting\nmap terms.\n\nIf two matching keys are declared, the latter key takes precedence.\n\n_Example:_\n\n```\n1> #{1 => a, 1 => b}.\n#{1 => b }\n2> #{1.0 => a, 1 => b}.\n#{1 => b, 1.0 => a}\n```\n\nThe order in which the expressions constructing the keys (and their associated\nvalues) are evaluated is not defined. The syntactic order of the key-value pairs\nin the construction is of no relevance, except in the recently mentioned case of\ntwo matching keys.","title":"Creating Maps - Expressions","ref":"expressions.html#creating-maps"},{"type":"extras","doc":"Updating a map has a similar syntax as constructing it.\n\nAn expression defining the map to be updated is put in front of the expression\ndefining the keys to be updated and their respective values:\n\n```\nM#{K => V}\n```\n\nHere `M` is a term of type map and `K` and `V` are any expression.\n\nIf key `K` does not match any existing key in the map, a new association is\ncreated from key `K` to value `V`.\n\nIf key `K` matches an existing key in map `M`, its associated value is replaced\nby the new value `V`. In both cases, the evaluated map expression returns a new\nmap.\n\nIf `M` is not of type map, an exception of type `badmap` is raised.\n\nTo only update an existing value, the following syntax is used:\n\n```\nM#{K := V}\n```\n\nHere `M` is a term of type map, `V` is an expression and `K` is an expression\nthat evaluates to an existing key in `M`.\n\nIf key `K` does not match any existing keys in map `M`, an exception of type\n`badkey` is raised at runtime. If a matching key `K` is present in map `M`,\nits associated value is replaced by the new value `V`, and the evaluated map\nexpression returns a new map.\n\nIf `M` is not of type map, an exception of type `badmap` is raised.\n\n_Examples:_\n\n```\nM0 = #{},\nM1 = M0#{a => 0},\nM2 = M1#{a => 1, b => 2},\nM3 = M2#{\"function\" => fun() -> f() end},\nM4 = M3#{a := 2, b := 3}.  % 'a' and 'b' was added in `M1` and `M2`.\n```\n\nHere `M0` is any map. It follows that `M1` through `M4` are maps as well.\n\n_More examples:_\n\n```\n1> M = #{1 => a}.\n#{1 => a }\n2> M#{1.0 => b}.\n#{1 => a, 1.0 => b}.\n3> M#{1 := b}.\n#{1 => b}\n4> M#{1.0 := b}.\n** exception error: bad argument\n```\n\nAs in construction, the order in which the key and value expressions are\nevaluated is not defined. The syntactic order of the key-value pairs in the\nupdate is of no relevance, except in the case where two keys match. In that\ncase, the latter value is used.","title":"Updating Maps - Expressions","ref":"expressions.html#updating-maps"},{"type":"extras","doc":"Matching of key-value associations from maps is done as follows:\n\n```\n#{K := V} = M\n```\n\nHere `M` is any map. The key `K` must be a\n[guard expression](expressions.md#guard-expressions), with all variables already\nbound. `V` can be any pattern with either bound or unbound variables.\n\nIf the variable `V` is unbound, it becomes bound to the value associated with\nthe key `K`, which must exist in the map `M`. If the variable `V` is bound, it\nmust match the value associated with `K` in `M`.\n\n> #### Change {: .info }\n>\n> Before Erlang/OTP 23, the expression defining the key `K` was restricted to be\n> either a single variable or a literal.\n\n_Example:_\n\n```\n1> M = #{\"tuple\" => {1,2}}.\n#{\"tuple\" => {1,2}}\n2> #{\"tuple\" := {1,B}} = M.\n#{\"tuple\" => {1,2}}\n3> B.\n2.\n```\n\nThis binds variable `B` to integer `2`.\n\nSimilarly, multiple values from the map can be matched:\n\n```\n#{K1 := V1, ..., Kn := Vn} = M\n```\n\nHere keys `K1` through `Kn` are any expressions with literals or bound\nvariables. If all key expressions evaluate successfully and all keys\nexist in map `M`, all variables in `V1 .. Vn` is matched to the\nassociated values of their respective keys.\n\nIf the matching conditions are not met the match fails.\n\nNote that when matching a map, only the `:=` operator (not the `=>`) is allowed\nas a delimiter for the associations.\n\nThe order in which keys are declared in matching has no relevance.\n\nDuplicate keys are allowed in matching and match each pattern associated to the\nkeys:\n\n```\n#{K := V1, K := V2} = M\n```\n\nThe empty map literal (`#{}`) matches any map when used as a pattern:\n\n```\n#{} = Expr\n```\n\nThis expression matches if the expression `Expr` is of type map, otherwise it\nfails with an exception `badmatch`.\n\nHere the key to be retrieved is constructed from an expression:\n\n```\n#{{tag,length(List)} := V} = Map\n```\n\n`List` must be an already bound variable.\n\n#### Matching Syntax\n\nMatching of literals as keys are allowed in function heads:\n\n```\n%% only start if not_started\nhandle_call(start, From, #{state := not_started} = S) ->\n...\n    {reply, ok, S#{state := start}};\n\n%% only change if started\nhandle_call(change, From, #{state := start} = S) ->\n...\n    {reply, ok, S#{state := changed}};\n```","title":"Maps in Patterns - Expressions","ref":"expressions.html#maps-in-patterns"},{"type":"extras","doc":"Maps are allowed in guards as long as all subexpressions are valid guard\nexpressions.\n\nThe following guard BIFs handle maps:\n\n- [is_map/1](`erlang:is_map/1`) in the `erlang` module\n- [is_map_key/2](`erlang:is_map_key/2`) in the `erlang` module\n- [map_get/2](`erlang:map_get/2`) in the `erlang` module\n- [map_size/1](`erlang:map_size/1`) in the `erlang` module","title":"Maps in Guards - Expressions","ref":"expressions.html#maps-in-guards"},{"type":"extras","doc":"The bit syntax operates on _bit strings_. A bit string is a sequence of bits\nordered from the most significant bit to the least significant bit.\n\n```\n<<>>  % The empty bit string, zero length\n< >\n< >\n```\n\nEach element `Ei` specifies a _segment_ of the bit string. The segments are\nordered left to right from the most significant bit to the least significant bit\nof the bit string.\n\nEach segment specification `Ei` is a value, whose default type is `integer`,\nfollowed by an optional _size expression_ and an optional _type specifier list_.\n\n```\nEi = Value |\n     Value:Size |\n     Value/TypeSpecifierList |\n     Value:Size/TypeSpecifierList\n```\n\nWhen used in a bit string construction, `Value` is an expression that is to\nevaluate to an integer, float, or bit string. If the expression is not a single\nliteral or variable, it is to be enclosed in parentheses.\n\nWhen used in a bit string matching, `Value` must be a variable, or an integer,\nfloat, or string.\n\nNotice that, for example, using a string literal as in `<<\"abc\">>` is syntactic\nsugar for `<<$a,$b,$c>>`.\n\nWhen used in a bit string construction, `Size` is an expression that is to\nevaluate to an integer.\n\nWhen used in a bit string matching, `Size` must be a\n[guard expression](expressions.md#guard-expressions) that evaluates to an\ninteger. All variables in the guard expression must be already bound.\n\n> #### Change {: .info }\n>\n> Before Erlang/OTP 23, `Size` was restricted to be an integer or a variable\n> bound to an integer.\n\nThe value of `Size` specifies the size of the segment in units (see below). The\ndefault value depends on the type (see below):\n\n- For `integer` it is 8.\n- For `float` it is 64.\n- For `binary` and `bitstring` it is the whole binary or bit string.\n\nIn matching, the default value for a binary or bit string segment is only valid\nfor the last element. All other bit string or binary elements in the matching\nmust have a size specification.\n\n[](){: #binaries }\n\n**Binaries**\n\nA bit string with a length that is a multiple of 8 bits is known as a _binary_,\nwhich is the most common and useful type of bit string.\n\nA binary has a canonical representation in memory. Here follows a sequence of\nbytes where each byte's value is its sequence number:\n\n```\n<<1, 2, 3, 4, 5, 6, 7, 8, 9, 10>>\n```\n\nBit strings are a later generalization of binaries, so many texts and much\ninformation about binaries apply just as well for bit strings.\n\n**Example:**\n\n```\n1> < > = <<\"abcde\">>.\n* 1:3: a binary field without size is only allowed at the end of a binary pattern\n2> < > = <<\"abcde\">>.\n<<\"abcde\">>\n3> A.\n<<\"abc\">>\n4> B.\n<<\"de\">>\n```\n\nFor the `utf8`, `utf16`, and `utf32` types, `Size` must not be given. The size\nof the segment is implicitly determined by the type and value itself.\n\n`TypeSpecifierList` is a list of type specifiers, in any order, separated by\nhyphens (-). Default values are used for any omitted type specifiers.\n\n- **`Type`= `integer` | `float` | `binary` | `bytes` | `bitstring` | `bits` |\n  `utf8` | `utf16` | `utf32`** - The default is `integer`. `bytes` is a\n  shorthand for `binary` and `bits` is a shorthand for `bitstring`. See below\n  for more information about the `utf` types.\n\n- **`Signedness`= `signed` | `unsigned`** - Only matters for matching and when\n  the type is `integer`. The default is `unsigned`.\n\n- **`Endianness`= `big` | `little` | `native`** - Specifies byte level (octet\n  level) endianness (byte order). Native-endian means that the endianness is\n  resolved at load time to be either big-endian or little-endian, depending on\n  what is native for the CPU that the Erlang machine is run on. Endianness only\n  matters when the **Type** is either `integer`, `utf16`, `utf32`, or `float`. The\n  default is `big`.\n\n  ```\n  <<16#1234:16/little>> = <<16#3412:16>> = <<16#34:8, 16#12:8>>\n  ```\n\n- **`Unit`= `unit:IntegerLiteral`** - The allowed range is 1 through 256.\n  Defaults to 1 for `integer`, `float`, and `bitstring`, and to 8 for `binary`.\n  For types `bitstring`, `bits`, and `bytes`, it is not allowed to specify a\n  unit value different from the default value. No unit specifier must be given\n  for the types `utf8`, `utf16`, and `utf32`.","title":"Bit Syntax Expressions - Expressions","ref":"expressions.html#bit-syntax-expressions"},{"type":"extras","doc":"The value of `Size` multiplied with the unit gives the size of the segment in\nbits.\n\nWhen constructing bit strings, if the size `N` of an integer segment is too\nsmall to contain the given integer, the most significant bits of the integer are\nsilently discarded and only the `N` least significant bits are put into the bit\nstring. For example, `<<16#ff:4>>` will result in the bit string `<<15:4>>`.","title":"Integer segments - Expressions","ref":"expressions.html#integer-segments"},{"type":"extras","doc":"The value of `Size` multiplied with the unit gives the size of the segment in\nbits. The size of a float segment in bits must be one of 16, 32, or 64.\n\nWhen constructing bit strings, if the size of a float segment is too small to\ncontain the representation of the given float value, an exception is raised.\n\nWhen matching bit strings, matching of float segments fails if the bits of the\nsegment does not contain the representation of a finite floating point value.","title":"Float segments - Expressions","ref":"expressions.html#float-segments"},{"type":"extras","doc":"In this section, the phrase \"binary segment\" refers to any one of the segment\ntypes `binary`, `bitstring`, `bytes`, and `bits`.\n\nSee also the paragraphs about [Binaries](expressions.md#binaries).\n\nWhen constructing binaries and no size is specified for a binary segment, the\nentire binary value is interpolated into the binary being constructed. However,\nthe size in bits of the binary being interpolated must be evenly divisible by\nthe unit value for the segment; otherwise an exception is raised.\n\nFor example, the following examples all succeed:\n\n```\n1> <<(<<\"abc\">>)/bitstring>>.\n<<\"abc\">>\n2> <<(<<\"abc\">>)/binary-unit:1>>.\n<<\"abc\">>\n3> <<(<<\"abc\">>)/binary>>.\n<<\"abc\">>\n```\n\nThe first two examples have a unit value of 1 for the segment, while the third\nsegment has a unit value of 8.\n\nAttempting to interpolate a bit string of size 1 into a binary segment with unit\n8 (the default unit for `binary`) fails as shown in this example:\n\n```\n1> <<(<<1:1>>)/binary>>.\n** exception error: bad argument\n```\n\nFor the construction to succeed, the unit value of the segment must be 1:\n\n```\n2> <<(<<1:1>>)/bitstring>>.\n<<1:1>>\n3> <<(<<1:1>>)/binary-unit:1>>.\n<<1:1>>\n```\n\nSimilarly, when matching a binary segment with no size specified, the match\nsucceeds if and only if the size in bits of the rest of the binary is evenly\ndivisible by the unit value:\n\n```\n1> <<_/binary-unit:16>> = <<\"\">>.\n<<>>\n2> <<_/binary-unit:16>> = <<\"a\">>.\n** exception error: no match of right hand side value <<\"a\">>\n3> <<_/binary-unit:16>> = <<\"ab\">>.\n<<\"ab\">>\n4> <<_/binary-unit:16>> = <<\"abc\">>.\n** exception error: no match of right hand side value <<\"abc\">>\n5> <<_/binary-unit:16>> = <<\"abcd\">>.\n<<\"abcd\">>\n```\n\nWhen a size is explicitly specified for a binary segment, the segment size in\nbits is the value of `Size` multiplied by the default or explicit unit value.\n\nWhen constructing binaries, the size of the binary being interpolated into the\nconstructed binary must be at least as large as the size of the binary segment.\n\n**Examples:**\n\n```\n1> <<(<<\"abc\">>):2/binary>>.\n<<\"ab\">>\n2> <<(<<\"a\">>):2/binary>>.\n** exception error: construction of binary failed\n        *** segment 1 of type 'binary': the value <<\"a\">> is shorter than the size of the segment\n```","title":"Binary segments - Expressions","ref":"expressions.html#binary-segments"},{"type":"extras","doc":"The types `utf8`, `utf16`, and `utf32` specifies encoding/decoding of the\n*Unicode Transformation Format*s [UTF-8](https://en.wikipedia.org/wiki/UTF-8),\n[UTF-16](https://en.wikipedia.org/wiki/UTF-16), and\n[UTF-32](https://en.wikipedia.org/wiki/UTF-32), respectively.\n\nWhen constructing a segment of a `utf` type, `Value` must be an integer in the\nrange `0` through `16#D7FF` or `16#E000` through `16#10FFFF`. Construction fails with a\n`badarg` exception if `Value` is outside the allowed ranges. The sizes of the\nencoded values are as follows:\n\n- For `utf8`, `Value` is encoded in 1-4 bytes.\n- For `utf16`, `Value` is encoded in 2 or 4 bytes.\n- For `utf32`, `Value` is encoded in 4 bytes.\n\nWhen constructing, a literal string can be given followed by one of the UTF\ntypes, for example: `<<\"abc\"/utf8>>` which is syntactic sugar for\n`<<$a/utf8,$b/utf8,$c/utf8>>`.\n\nA successful match of a segment of a `utf` type, results in an integer in the\nrange `0` through `16#D7FF` or `16#E000` through `16#10FFFF`. The match fails if the\nreturned value falls outside those ranges.\n\nA segment of type `utf8` matches 1-4 bytes in the bit string, if the bit string\nat the match position contains a valid UTF-8 sequence. (See RFC-3629 or the\nUnicode standard.)\n\nA segment of type `utf16` can match 2 or 4 bytes in the bit string. The match\nfails if the bit string at the match position does not contain a legal UTF-16\nencoding of a Unicode code point. (See RFC-2781 or the Unicode standard.)\n\nA segment of type `utf32` can match 4 bytes in the bit string in the same way as\nan `integer` segment matches 32 bits. The match fails if the resulting integer\nis outside the legal ranges previously mentioned.\n\n_Examples:_\n\n```\n1> Bin1 = <<1,17,42>>.\n<<1,17,42>>\n2> Bin2 = <<\"abc\">>.\n<<97,98,99>>\n\n3> Bin3 = <<1,17,42:16>>.\n<<1,17,0,42>>\n4> < > = <<1,17,42:16>>.\n<<1,17,0,42>>\n5> C.\n42\n6> < > = <<1,17,42:16>>.\n<<1,17,0,42>>\n7> D.\n273\n8> F.\n42\n9> < > = <<1,17,42:16>>.\n<<1,17,0,42>>\n10> H.\n<<17,0,42>>\n11> < > = <<1,17,42:12>>.\n<<1,17,2,10:4>>\n12> J.\n<<17,2,10:4>>\n\n13> <<1024/utf8>>.\n<<208,128>>\n\n14> <<1:1,0:7>>.\n<<128>>\n15> <<16#123:12/little>> = <<16#231:12>> = <<2:4, 3:4, 1:4>>.\n<<35,1:4>>\n```\n\nNotice that bit string patterns cannot be nested.\n\nNotice also that \"`B=<<1>>`\" is interpreted as \"`B =< <1>>`\" which is a syntax\nerror. The correct way is to write a space after `=`: \"`B = <<1>>`.\n\nMore examples are provided in [Programming Examples](`e:system:bit_syntax.md`).","title":"Unicode segments - Expressions","ref":"expressions.html#unicode-segments"},{"type":"extras","doc":"```\nfun\n    [Name](Pattern11,...,Pattern1N) [when GuardSeq1] ->\n              Body1;\n    ...;\n    [Name](PatternK1,...,PatternKN) [when GuardSeqK] ->\n              BodyK\nend\n```\n\nA fun expression begins with the keyword `fun` and ends with the keyword `end`.\nBetween them is to be a function declaration, similar to a\n[regular function declaration](ref_man_functions.md#function-declaration-syntax),\nexcept that the function name is optional and is to be a variable, if any.\n\nVariables in a fun head shadow the function name and both shadow variables in\nthe function clause surrounding the fun expression. Variables bound in a fun\nbody are local to the fun body.\n\nThe return value of the expression is the resulting fun.\n\n_Examples:_\n\n```\n1> Fun1 = fun (X) -> X+1 end.\n#Fun \n2> Fun1(2).\n3\n3> Fun2 = fun (X) when X>=5 -> gt; (X) -> lt end.\n#Fun \n4> Fun2(7).\ngt\n5> Fun3 = fun Fact(1) -> 1; Fact(X) when X > 1 -> X * Fact(X - 1) end.\n#Fun \n6> Fun3(4).\n24\n```\n\nThe following fun expressions are also allowed:\n\n```\nfun Name/Arity\nfun Module:Name/Arity\n```\n\nIn `Name/Arity`, `Name` is an atom and `Arity` is an integer. `Name/Arity` must\nspecify an existing local function. The expression is syntactic sugar for:\n\n```\nfun (Arg1,...,ArgN) -> Name(Arg1,...,ArgN) end\n```\n\nIn `Module:Name/Arity`, `Module`, and `Name` are atoms and `Arity` is an\ninteger. `Module`, `Name`, and `Arity` can also be variables. A fun defined in\nthis way refers to the function `Name` with arity `Arity` in the _latest_\nversion of module `Module`. A fun defined in this way is not dependent on the\ncode for the module in which it is defined.\n\n> #### Change {: .info }\n>\n> Before Erlang/OTP R15, `Module`, `Name`, and `Arity` were not allowed to be\n> variables.\n\nMore examples are provided in [Programming Examples](`e:system:funs.md`).","title":"Fun Expressions - Expressions","ref":"expressions.html#fun-expressions"},{"type":"extras","doc":"```\ncatch Expr\n```\n\nReturns the value of `Expr` unless an exception is raised during the evaluation. In\nthat case, the exception is caught. The return value depends on the class of the\nexception:\n\n- **`error`** (a run-time error or the code called [`error(Term)`](`error/1`)) -\n  `{'EXIT',{Reason,Stack}}` is returned.\n\n- **`exit`** (the code called [`exit(Term)`](`exit/1`)) - `{'EXIT',Term}` is returned.\n\n- **`throw`** (the code called [`throw(Term)`](`throw/1`)): `Term` is returned.\n\n`Reason` depends on the type of error that occurred, and `Stack` is the stack of\nrecent function calls, see [Exit Reasons](errors.md#exit_reasons).\n\n_Examples:_\n\n```\n1> catch 1+2.\n3\n2> catch 1+a.\n{'EXIT',{badarith,[...]}}\n```\n\nThe BIF [`throw(Any)`](`throw/1`) can be used for non-local return from a\nfunction. It must be evaluated within a `catch`, which returns the value `Any`.\n\n_Example:_\n\n```\n3> catch throw(hello).\nhello\n```\n\nIf [`throw/1`](`throw/1`) is not evaluated within a catch, a `nocatch` run-time\nerror occurs.\n\n> #### Change {: .info }\n>\n> Before Erlang/OTP 24, the `catch` operator had the lowest precedence, making\n> it necessary to add parentheses when combining it with the `match` operator:\n>\n> ```\n> 1> A = (catch 42).\n> 42\n> 2> A.\n> 42\n> ```\n>\n> Starting from Erlang/OTP 24, the parentheses can be omitted:\n>\n> ```\n> 1> A = catch 42.\n> 42\n> 2> A.\n> 42\n> ```","title":"Catch and Throw - Expressions","ref":"expressions.html#catch-and-throw"},{"type":"extras","doc":"```\ntry Exprs\ncatch\n    Class1:ExceptionPattern1[:Stacktrace] [when ExceptionGuardSeq1] ->\n        ExceptionBody1;\n    ClassN:ExceptionPatternN[:Stacktrace] [when ExceptionGuardSeqN] ->\n        ExceptionBodyN\nend\n```\n\nThis is an enhancement of [catch](expressions.md#catch-and-throw). It gives the\npossibility to:\n\n- Distinguish between different exception classes.\n- Choose to handle only the desired ones.\n- Passing the others on to an enclosing `try` or `catch`, or to default error\n  handling.\n\nNotice that although the keyword `catch` is used in the `try` expression, there\nis not a `catch` expression within the `try` expression.\n\nIt returns the value of `Exprs` (a sequence of expressions `Expr1, ..., ExprN`)\nunless an exception occurs during the evaluation. In that case the exception is\ncaught and the patterns `ExceptionPattern` with the right exception class\n`Class` are sequentially matched against the caught exception. If a match\nsucceeds and the optional guard sequence `ExceptionGuardSeq` is true, the\ncorresponding `ExceptionBody` is evaluated to become the return value.\n\n`Stacktrace`, if specified, must be the name of a variable (not a pattern). The\nstack trace is bound to the variable when the corresponding `ExceptionPattern`\nmatches.\n\nIf an exception occurs during evaluation of `Exprs` but there is no matching\n`ExceptionPattern` of the right `Class` with a true guard sequence, the\nexception is passed on as if `Exprs` had not been enclosed in a `try`\nexpression.\n\nIf an exception occurs during evaluation of `ExceptionBody`, it is not caught.\n\nIt is allowed to omit `Class` and `Stacktrace`. An omitted `Class` is shorthand\nfor `throw`:\n\n```\ntry Exprs\ncatch\n    ExceptionPattern1 [when ExceptionGuardSeq1] ->\n        ExceptionBody1;\n    ExceptionPatternN [when ExceptionGuardSeqN] ->\n        ExceptionBodyN\nend\n```\n\nThe `try` expression can have an `of` section:\n\n```\ntry Exprs of\n    Pattern1 [when GuardSeq1] ->\n        Body1;\n    ...;\n    PatternN [when GuardSeqN] ->\n        BodyN\ncatch\n    Class1:ExceptionPattern1[:Stacktrace] [when ExceptionGuardSeq1] ->\n        ExceptionBody1;\n    ...;\n    ClassN:ExceptionPatternN[:Stacktrace] [when ExceptionGuardSeqN] ->\n        ExceptionBodyN\nend\n```\n\nIf the evaluation of `Exprs` succeeds without an exception, the patterns\n`Pattern` are sequentially matched against the result in the same way as for a\n[case](expressions.md#case) expression, except that if the matching fails, a\n`try_clause` run-time error occurs instead of a `case_clause`.\n\nOnly exceptions occurring during the evaluation of `Exprs` can be caught by the\n`catch` section. Exceptions occurring in a `Body` or due to a failed match are\nnot caught.\n\nThe `try` expression can also be augmented with an `after` section, intended to\nbe used for cleanup with side effects:\n\n```\ntry Exprs of\n    Pattern1 [when GuardSeq1] ->\n        Body1;\n    ...;\n    PatternN [when GuardSeqN] ->\n        BodyN\ncatch\n    Class1:ExceptionPattern1[:Stacktrace] [when ExceptionGuardSeq1] ->\n        ExceptionBody1;\n    ...;\n    ClassN:ExceptionPatternN[:Stacktrace] [when ExceptionGuardSeqN] ->\n        ExceptionBodyN\nafter\n    AfterBody\nend\n```\n\n`AfterBody` is evaluated after either `Body` or `ExceptionBody`, no matter which\none. The evaluated value of `AfterBody` is lost; the return value of the `try`\nexpression is the same with an `after` section as without.\n\nEven if an exception occurs during evaluation of `Body` or `ExceptionBody`,\n`AfterBody` is evaluated. In this case the exception is passed on after\n`AfterBody` has been evaluated, so the exception from the `try` expression is\nthe same with an `after` section as without.\n\nIf an exception occurs during evaluation of `AfterBody` itself, it is not\ncaught. So if `AfterBody` is evaluated after an exception in `Exprs`, `Body`, or\n`ExceptionBody`, that exception is lost and masked by the exception in\n`AfterBody`.\n\nThe `of`, `catch`, and `after` sections are all optional, as long as there is at\nleast a `catch` or an `after` section. So the following are valid `try`\nexpressions:\n\n```\ntry Exprs of\n    Pattern when GuardSeq ->\n        Body\nafter\n    AfterBody\nend\n\ntry Exprs\ncatch\n    ExpressionPattern ->\n        ExpressionBody\nafter\n    AfterBody\nend\n\ntry Exprs after AfterBody end\n```\n\nNext is an example of using `after`. This closes the file, even in the event of\nexceptions in `file:read/2` or in [`binary_to_term/1`](`binary_to_term/1`). The\nexceptions are the same as without the `try`...`after`...`end` expression:\n\n```\ntermize_file(Name) ->\n    {ok,F} = file:open(Name, [read,binary]),\n    try\n        {ok,Bin} = file:read(F, 1024*1024),\n        binary_to_term(Bin)\n    after\n        file:close(F)\n    end.\n```\n\nNext is an example of using `try` to emulate `catch Expr`:\n\n```\ntry Expr\ncatch\n    throw:Term -> Term;\n    exit:Reason -> {'EXIT',Reason};\n    error:Reason:Stk -> {'EXIT',{Reason,Stk}}\nend\n```\n\nVariables bound in the various parts of these expressions have different scopes.\nVariables bound just after the `try` keyword are:\n\n- bound in the `of` section\n- unsafe in both the `catch` and `after` sections, as well as after the whole\n  construct\n\nVariables bound in `of` section are:\n\n- unbound in the `catch` section\n- unsafe in both the `after` section, as well as after the whole construct\n\nVariables bound in the `catch` section are unsafe in the `after` section, as\nwell as after the whole construct.\n\nVariables bound in the `after` section are unsafe after the whole construct.","title":"Try - Expressions","ref":"expressions.html#try"},{"type":"extras","doc":"```\n(Expr)\n```\n\nParenthesized expressions are useful to override\n[operator precedences](expressions.md#prec), for example, in arithmetic\nexpressions:\n\n```\n1> 1 + 2 * 3.\n7\n2> (1 + 2) * 3.\n9\n```","title":"Parenthesized Expressions - Expressions","ref":"expressions.html#parenthesized-expressions"},{"type":"extras","doc":"```\nbegin\n   Expr1,\n   ...,\n   ExprN\nend\n```\n\nBlock expressions provide a way to group a sequence of expressions, similar to a\nclause body. The return value is the value of the last expression `ExprN`.\n\n[](){: #lcs }","title":"Block Expressions - Expressions","ref":"expressions.html#block-expressions"},{"type":"extras","doc":"Comprehensions provide a succinct notation for iterating over one or more terms\nand constructing a new term. Comprehensions come in three different flavors,\ndepending on the type of term they build.\n\nList comprehensions construct lists. They have the following syntax:\n\n```\n[Expr || Qualifier1, . . ., QualifierN]\n```\n\nHere, `Expr` is an arbitrary expression, and each `Qualifier` is either a\n**generator** or a **filter**.\n\nBit string comprehensions construct bit strings or binaries. They have the\nfollowing syntax:\n\n```\n< >\n```\n\n`BitStringExpr` is an expression that evaluates to a bit string. If\n`BitStringExpr` is a function call, it must be enclosed in parentheses. Each\n`Qualifier` is either a **generator** or a **filter**.\n\nMap comprehensions construct maps. They have the following syntax:\n\n```\n#{KeyExpr => ValueExpr || Qualifier1, . . ., QualifierN}\n```\n\nHere, `KeyExpr` and `ValueExpr` are arbitrary expressions, and each `Qualifier`\nis either a **generator** or a **filter**.\n\n> #### Change {: .info }\n>\n> Map comprehensions and map generators were introduced in Erlang/OTP 26.\n\nThere are three kinds of generators.\n\nA _list generator_ has the following syntax:\n\n```\nPattern <- ListExpr\n```\n\nwhere `ListExpr` is an expression that evaluates to a list of terms.\n\nA _bit string generator_ has the following syntax:\n\n```\nBitstringPattern <= BitStringExpr\n```\n\nwhere `BitStringExpr` is an expression that evaluates to a bit string.\n\nA _map generator_ has the following syntax:\n\n```\nKeyPattern := ValuePattern <- MapExpression\n```\n\nwhere `MapExpr` is an expression that evaluates to a map, or a map iterator\nobtained by calling `maps:iterator/1` or `maps:iterator/2`.\n\nA _filter_ is an expression that evaluates to `true` or `false`.\n\nThe variables in the generator patterns shadow previously bound variables,\nincluding variables bound in a previous generator pattern.\n\nVariables bound in a generator expression are not visible outside the\nexpression:\n\n```\n1> [{E,L} || E <- L=[1,2,3]].\n* 1:5: variable 'L' is unbound\n```\n\nA **list comprehension** returns a list, where the list elements are the result\nof evaluating `Expr` for each combination of generator elements for which all\nfilters are true.\n\nA **bit string comprehension** returns a bit string, which is created by\nconcatenating the results of evaluating `BitStringExpr` for each combination of\nbit string generator elements for which all filters are true.\n\nA **map comprehension** returns a map, where the map elements are the result of\nevaluating `KeyExpr` and `ValueExpr` for each combination of generator elements\nfor which all filters are true. If the key expressions are not unique, the last\noccurrence is stored in the map.\n\n**Examples:**\n\nMultiplying each element in a list by two:\n\n```\n1> [X*2 || X <- [1,2,3]].\n[2,4,6]\n```\n\nMultiplying each byte in a binary by two, returning a list:\n\n```\n1> [X*2 || < > <= <<1,2,3>>].\n[2,4,6]\n```\n\nMultiplying each byte in a binary by two:\n\n```\n1> << <<(X*2)>> || < > <= <<1,2,3>> >>.\n<<2,4,6>>\n```\n\nMultiplying each element in a list by two, returning a binary:\n\n```\n1> << <<(X*2)>> || X <- [1,2,3] >>.\n<<2,4,6>>\n```\n\nCreating a mapping from an integer to its square:\n\n```\n1> #{X => X*X || X <- [1,2,3]}.\n#{1 => 1,2 => 4,3 => 9}\n```\n\nMultiplying the value of each element in a map by two:\n\n```\n1> #{K => 2*V || K := V <- #{a => 1,b => 2,c => 3}}.\n#{a => 2,b => 4,c => 6}\n```\n\nFiltering a list, keeping odd numbers:\n\n```\n1> [X || X <- [1,2,3,4,5], X rem 2 =:= 1].\n[1,3,5]\n```\n\nFiltering a list, keeping only elements that match:\n\n```\n1> [X || {_,_}=X <- [{a,b}, [a], {x,y,z}, {1,2}]].\n[{a,b},{1,2}]\n```\n\nCombining elements from two list generators:\n\n```\n1> [{P,Q} || P <- [a,b,c], Q <- [1,2]].\n[{a,1},{a,2},{b,1},{b,2},{c,1},{c,2}]\n```\n\nMore examples are provided in\n[Programming Examples.](`e:system:list_comprehensions.md`)\n\nWhen there are no generators, a comprehension returns either a term constructed\nfrom a single element (the result of evaluating `Expr`) if all filters are true,\nor a term constructed from no elements (that is, `[]` for list comprehension,\n`<<>>` for a bit string comprehension, and `#{}` for a map comprehension).\n\n_Example:_\n\n```\n1> [2 || is_integer(2)].\n[2]\n2> [x || is_integer(x)].\n[]\n```\n\nWhat happens when the filter expression does not evaluate to a boolean value\ndepends on the expression:\n\n- If the expression is a [guard expression](expressions.md#guard-expressions),\n  failure to evaluate or evaluating to a non-boolean value is equivalent to\n  evaluating to `false`.\n- If the expression is not a guard expression and evaluates to a non-Boolean\n  value `Val`, an exception `{bad_filter, Val}` is triggered at runtime. If the\n  evaluation of the expression raises an exception, it is not caught by the\n  comprehension.\n\n**Examples** (using a guard expression as filter):\n\n```\n1> List = [1,2,a,b,c,3,4].\n[1,2,a,b,c,3,4]\n2> [E || E <- List, E rem 2].\n[]\n3> [E || E <- List, E rem 2 =:= 0].\n[2,4]\n```\n\n**Examples** (using a non-guard expression as filter):\n\n```\n1> List = [1,2,a,b,c,3,4].\n[1,2,a,b,c,3,4]\n2> FaultyIsEven = fun(E) -> E rem 2 end.\n#Fun \n3> [E || E <- List, FaultyIsEven(E)].\n** exception error: bad filter 1\n4> IsEven = fun(E) -> E rem 2 =:= 0 end.\n#Fun \n5> [E || E <- List, IsEven(E)].\n** exception error: an error occurred when evaluating an arithmetic expression\n     in operator  rem/2\n        called as a rem 2\n6> [E || E <- List, is_integer(E), IsEven(E)].\n[2,4]\n```\n\n[](){: #guards }","title":"Comprehensions - Expressions","ref":"expressions.html#comprehensions"},{"type":"extras","doc":"A _guard sequence_ is a sequence of guards, separated by semicolon (`;`). The\nguard sequence is true if at least one of the guards is true. (The remaining\nguards, if any, are not evaluated.)\n\n`Guard1; ...; GuardK`\n\nA _guard_ is a sequence of guard expressions, separated by comma (`,`). The guard\nis true if all guard expressions evaluate to `true`.\n\n`GuardExpr1, ..., GuardExprN`","title":"Guard Sequences - Expressions","ref":"expressions.html#guard-sequences"},{"type":"extras","doc":"The set of valid _guard expressions_ is a subset of the set of valid Erlang\nexpressions. The reason for restricting the set of valid expressions is that\nevaluation of a guard expression must be guaranteed to be free of side effects.\nValid guard expressions are the following:\n\n- Variables\n- Constants (atoms, integer, floats, lists, tuples, records, binaries, and maps)\n- Expressions that construct atoms, integer, floats, lists, tuples, records,\n  binaries, and maps\n- Expressions that update a map\n- The record expressions `Expr#Name.Field` and `#Name.Field`\n- Calls to the BIFs specified in tables _Type Test BIFs_ and _Other BIFs Allowed\n  in Guard Expressions_\n- Term comparisons\n- Arithmetic expressions\n- Boolean expressions\n- Short-circuit expressions (`andalso`/`orelse`)\n\n| _BIF_                                |\n| ------------------------------------ |\n| [`is_atom/1`](`is_atom/1`)           |\n| [`is_binary/1`](`is_binary/1`)       |\n| [`is_bitstring/1`](`is_bitstring/1`) |\n| [`is_boolean/1`](`is_boolean/1`)     |\n| [`is_float/1`](`is_float/1`)         |\n| [`is_function/1`](`is_function/1`)   |\n| [`is_function/2`](`is_function/2`)   |\n| [`is_integer/1`](`is_integer/1`)     |\n| [`is_list/1`](`is_list/1`)           |\n| [`is_map/1`](`is_map/1`)             |\n| [`is_number/1`](`is_number/1`)       |\n| [`is_pid/1`](`is_pid/1`)             |\n| [`is_port/1`](`is_port/1`)           |\n| [`is_record/2`](`is_record/2`)       |\n| [`is_record/3`](`is_record/3`)       |\n| [`is_reference/1`](`is_reference/1`) |\n| [`is_tuple/1`](`is_tuple/1`)         |\n\n_Table: Type Test BIFs_\n\nNotice that most type test BIFs have older equivalents, without the\n`is_` prefix. These old BIFs are retained only for backwards\ncompatibility and are not to be used in new code. They are also only\nallowed at top level. For example, they are not allowed in Boolean\nexpressions in guards.\n\n| _BIF_                                    |\n| ---------------------------------------- |\n| [`abs(Number)`](`abs/1`)                 |\n| [`bit_size(Bitstring)`](`bit_size/1`)    |\n| [`byte_size(Bitstring)`](`byte_size/1`)  |\n| [`element(N, Tuple)`](`element/2`)       |\n| [`float(Term)`](`float/1`)               |\n| [`hd(List)`](`hd/1`)                     |\n| [`is_map_key(Key, Map)`](`is_map_key/2`) |\n| [`length(List)`](`length/1`)             |\n| [`map_get(Key, Map)`](`map_get/2`)       |\n| [`map_size(Map)`](`map_size/1`)          |\n| [`max(A, B)`](`max/2`)                   |\n| [`min(A, B)`](`min/2`)                   |\n| `node/0`                                 |\n| `node(Pid` \\| `Ref` \\| `Port)`           |\n| [`round(Number)`](`round/1`)             |\n| `self/0`                                 |\n| `size(Tuple` \\| `Bitstring)`             |\n| [`tl(List)`](`tl/1`)                     |\n| [`trunc(Number)`](`trunc/1`)             |\n| [`tuple_size(Tuple)`](`tuple_size/1`)    |\n\n_Table: Other BIFs Allowed in Guard Expressions_\n\n> #### Change {: .info }\n>\n> The [`min/2`](`min/2`) and [`max/2`](`max/2`) BIFs are allowed to be used in\n> guards from Erlang/OTP 26.\n\nIf an arithmetic expression, a Boolean expression, a short-circuit expression,\nor a call to a guard BIF fails (because of invalid arguments), the entire guard\nfails. If the guard was part of a guard sequence, the next guard in the sequence\n(that is, the guard following the next semicolon) is evaluated.\n\n[](){: #prec }","title":"Guard Expressions - Expressions","ref":"expressions.html#guard-expressions"},{"type":"extras","doc":"Operator precedence in descending order:\n\n| _Operator_                                   | _Association_     |\n| -------------------------------------------- | ----------------- |\n| `#`                                          |                   |\n| Unary `+` `-` `bnot` `not`                   |                   |\n| `/` `*` `div` `rem` `band` `and`             | Left-associative  |\n| `+` `-` `bor` `bxor` `bsl` `bsr` `or` `xor`  | Left-associative  |\n| `++` `--`                                    | Right-associative |\n| `==` `/=` `=<` `<` `>=` `>` `=:=` `=/=`      | Non-associative   |\n| `andalso`                                    | Left-associative  |\n| `orelse`                                     | Left-associative  |\n| `catch`                                      |                   |\n| `=` `!`                                      | Right-associative |\n| `?=`                                         | Non-associative   |\n\n_Table: Operator Precedence_\n\n> #### Change {: .info }\n>\n> Before Erlang/OTP 24, the `catch` operator had the lowest precedence.\n\n> #### Note {: .info }\n>\n> The `=` operator in the table is the\n> [match operator](expressions.md#the-match-operator). The character `=` can also\n> denote the\n> [compound pattern operator](expressions.md#the-compound-pattern-operator), which\n> can only be used in patterns.\n>\n> `?=` is restricted in that it can only be used at the top-level inside a\n> `maybe` block.\n\nWhen evaluating an expression, the operator with the highest precedence is\nevaluated first. Operators with the same precedence are evaluated according to\ntheir associativity. Non-associative operators cannot be combined with operators\nof the same precedence.\n\n_Examples:_\n\nThe left-associative arithmetic operators are evaluated left to right:\n\n```\n6 + 5 * 4 - 3 / 2 evaluates to\n6 + 20 - 1.5 evaluates to\n26 - 1.5 evaluates to\n24.5\n```\n\nThe non-associative operators cannot be combined:\n\n```\n1> 1 < X < 10.\n* 1:7: syntax error before: '<'\n```","title":"Operator Precedence - Expressions","ref":"expressions.html#operator-precedence"},{"type":"extras","doc":"<!--\n%CopyrightBegin%\n\nCopyright Ericsson AB 2023-2024. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# Preprocessor","title":"Preprocessor","ref":"macros.html"},{"type":"extras","doc":"A file can be included as follows:\n\n```erlang\n-include(File).\n-include_lib(File).\n```\n\n`File`, a string, is to point out a file. The contents of this file are included\nas is, at the position of the directive.\n\nInclude files are typically used for record and macro definitions that are\nshared by several modules. It is recommended to use the file name extension\n`.hrl` for include files.\n\n`File` can start with a path component `$VAR`, for some string `VAR`. If that is\nthe case, the value of the environment variable `VAR` as returned by\n`os:getenv(VAR)` is substituted for `$VAR`. If `os:getenv(VAR)` returns `false`,\n`$VAR` is left as is.\n\nIf the filename `File` is absolute (possibly after variable substitution), the\ninclude file with that name is included. Otherwise, the specified file is\nsearched for in the following directories, and in this order:\n\n1. The current working directory\n1. The directory where the module is being compiled\n1. The directories given by the `include` option\n\nFor details, see [erlc](`e:erts:erlc_cmd.md`) in ERTS and\n`m:compile` in Compiler.\n\n_Examples:_\n\n```erlang\n-include(\"my_records.hrl\").\n-include(\"incdir/my_records.hrl\").\n-include(\"/home/user/proj/my_records.hrl\").\n-include(\"$PROJ_ROOT/my_records.hrl\").\n```\n\n`include_lib` is similar to `include`, but is not to point out an absolute file.\nInstead, the first path component (possibly after variable substitution) is\nassumed to be the name of an application.\n\n_Example:_\n\n```erlang\n-include_lib(\"kernel/include/file.hrl\").\n```\n\nThe code server uses `code:lib_dir(kernel)` to find the directory of the current\n(latest) version of Kernel, and then the subdirectory `include` is searched for\nthe file `file.hrl`.","title":"File Inclusion - Preprocessor","ref":"macros.html#file-inclusion"},{"type":"extras","doc":"A macro is defined as follows:\n\n```erlang\n-define(Const, Replacement).\n-define(Func(Var1,...,VarN), Replacement).\n```\n\nA macro definition can be placed anywhere among the attributes and function\ndeclarations of a module, but the definition must come before any usage of the\nmacro.\n\nIf a macro is used in several modules, it is recommended that the macro\ndefinition is placed in an include file.\n\nA macro is used as follows:\n\n```text\n?Const\n?Func(Arg1,...,ArgN)\n```\n\nMacros are expanded during compilation. A simple macro `?Const` is replaced with\n`Replacement`.\n\n_Example:_\n\n```erlang\n-define(TIMEOUT, 200).\n...\ncall(Request) ->\n    server:call(refserver, Request, ?TIMEOUT).\n```\n\nThis is expanded to:\n\n```erlang\ncall(Request) ->\n    server:call(refserver, Request, 200).\n```\n\nA macro `?Func(Arg1,...,ArgN)` is replaced with `Replacement`, where all\noccurrences of a variable `Var` from the macro definition are replaced with the\ncorresponding argument `Arg`.\n\n_Example:_\n\n```erlang\n-define(MACRO1(X, Y), {a, X, b, Y}).\n...\nbar(X) ->\n    ?MACRO1(a, b),\n    ?MACRO1(X, 123)\n```\n\nThis is expanded to:\n\n```erlang\nbar(X) ->\n    {a,a,b,b},\n    {a,X,b,123}.\n```\n\nIt is good programming practice, but not mandatory, to ensure that a macro\ndefinition is a valid Erlang syntactic form.\n\nTo view the result of macro expansion, a module can be compiled with the `'P'`\noption. `compile:file(File, ['P'])`. This produces a listing of the parsed code\nafter preprocessing and parse transforms, in the file `File.P`.","title":"Defining and Using Macros - Preprocessor","ref":"macros.html#defining-and-using-macros"},{"type":"extras","doc":"The following macros are predefined:\n\n- **`?MODULE`** - The name of the current module, as an atom.\n\n- **`?MODULE_STRING`** - The name of the current module, as a string.\n\n- **`?FILE`** - The file name of the current module, as a string.\n\n- **`?LINE`** - The current line number, as an integer.\n\n- **`?MACHINE`** - The machine name, `'BEAM'`.\n\n- **`?FUNCTION_NAME`** - The name of the current function, as an atom.\n\n- **`?FUNCTION_ARITY`** - The arity (number of arguments) for the current\n  function, as an integer.\n\n- **`?OTP_RELEASE`** - The OTP release for the runtime system that is\n  running the compiler, as an integer. For example, when compiling using\n  Erlang/OTP 27, the macro returns `27`.\n\n  > #### Note {: .info }\n  >\n  > To find out the release at run-time, call\n  > [`erlang:system_info(otp_release)`](`erlang:system_info/1`). Note\n  > that it returns the release as a string. For example, when the\n  > release is Erlang/OTP 27, the string `\"27\"` will be returned.\n\n  > #### Change {: .info }\n  >\n  > The `?OTP_RELEASE` macro was introduced in Erlang/OTP 21.\n\n- **`?FEATURE_AVAILABLE(Feature)`** - Expands to `true` if the\n  [feature](`e:system:features.md#features`) `Feature` is available. The feature\n  might or might not be enabled.\n\n  > #### Change {: .info }\n  >\n  > The `?FEATURE_AVAILABLE()` macro was introduced in Erlang/OTP 25.\n\n- **`?FEATURE_ENABLED(Feature)`** - Expands to `true` if the\n  [feature](`e:system:features.md#features`) `Feature` is enabled.\n  > #### Change {: .info }\n  >\n  > The `?FEATURE_ENABLED()` macro was introduced in Erlang/OTP 25.","title":"Predefined Macros - Preprocessor","ref":"macros.html#predefined-macros"},{"type":"extras","doc":"It is possible to overload macros, except for predefined macros. An overloaded\nmacro has more than one definition, each with a different number of arguments.\n\n> #### Change {: .info }\n>\n> Support for overloading of macros was added in Erlang 5.7.5/OTP R13B04.\n\nA macro `?Func(Arg1,...,ArgN)` with a (possibly empty) list of arguments results\nin an error message if there is at least one definition of `Func` with\narguments, but none with N arguments.\n\nAssuming these definitions:\n\n```erlang\n-define(F0(), c).\n-define(F1(A), A).\n-define(C, m:f).\n```\n\nthe following does not work:\n\n```erlang\nf0() ->\n    ?F0. % No, an empty list of arguments expected.\n\nf1(A) ->\n    ?F1(A, A). % No, exactly one argument expected.\n```\n\nOn the other hand,\n\n```text\nf() ->\n    ?C().\n```\n\nis expanded to\n\n```erlang\nf() ->\n    m:f().\n```","title":"Macros Overloading - Preprocessor","ref":"macros.html#macros-overloading"},{"type":"extras","doc":"A definition of macro can be removed as follows:\n\n```erlang\n-undef(Macro).\n```","title":"Removing a macro definition - Preprocessor","ref":"macros.html#removing-a-macro-definition"},{"type":"extras","doc":"The following macro directives support conditional compilation:\n\n- **`-ifdef(Macro).`** - Evaluate the following lines only if `Macro` is\n  defined.\n\n- **`-ifndef(Macro).`** - Evaluate the following lines only if `Macro` is not\n  defined.\n\n- **`-else.`** - Only allowed after the `ifdef`, `ifndef`, `if`, and `elif`\n  directives. The lines following `else` are evaluated if the preceding\n  directive evaluated to false.\n\n- **`-if(Condition).`** - Evaluates the following lines only if `Condition`\n  evaluates to true.\n\n- **`-elif(Condition).`** - Only allowed after an `if` or another `elif`\n  directive. If the preceding `if` or `elif` directive does not evaluate to\n  true, and the `Condition` evaluates to true, the lines following the `elif`\n  are evaluated instead.\n\n- **`-endif.`** - Specifies the end of a series of control flow directives.\n\n> #### Note {: .info }\n>\n> Macro directives cannot be used inside functions.\n\nSyntactically, the `Condition` in `if` and `elif` must be a\n[guard expression](expressions.md#guard-expressions). Other constructs (such as\na `case` expression) result in a compilation error.\n\nAs opposed to the standard guard expressions, an expression in an `if` and\n`elif` also supports calling the psuedo-function `defined(Name)`, which tests\nwhether the `Name` argument is the name of a previously defined macro.\n`defined(Name)` evaluates to `true` if the macro is defined and `false`\notherwise. An attempt to call other functions results in a compilation error.\n\n_Example:_\n\n```erlang\n-module(m).\n...\n\n-ifdef(debug).\n-define(LOG(X), io:format(\"{~p,~p}: ~p~n\", [?MODULE,?LINE,X])).\n-else.\n-define(LOG(X), true).\n-endif.\n\n...\n```\n\nWhen trace output is desired, `debug` is to be defined when the module `m` is\ncompiled:\n\n```erlang\n% erlc -Ddebug m.erl\n\nor\n\n1> c(m, {d, debug}).\n{ok,m}\n```\n\n`?LOG(Arg)` is then expanded to a call to `io:format/2` and provide the user\nwith some simple trace output.\n\n_Example:_\n\n```erlang\n-module(m)\n...\n-if(?OTP_RELEASE >= 25).\n%% Code that will work in OTP 25 or higher\n-elif(?OTP_RELEASE >= 26).\n%% Code that will work in OTP 26 or higher\n-else.\n%% Code that will work in OTP 24 or lower.\n-endif.\n...\n```\n\nThis code uses the `OTP_RELEASE` macro to conditionally select code depending on\nrelease.\n\n_Example:_\n\n```erlang\n-module(m)\n...\n-if(?OTP_RELEASE >= 26 andalso defined(debug)).\n%% Debugging code that requires OTP 26 or later.\n-else.\n%% Non-debug code that works in any release.\n-endif.\n...\n```\n\nThis code uses the `OTP_RELEASE` macro and `defined(debug)` to compile debug\ncode only for OTP 26 or later.","title":"Conditional Compilation - Preprocessor","ref":"macros.html#conditional-compilation"},{"type":"extras","doc":"[](){: #feature-directive }\n\nThe directive `-feature(FeatureName, enable | disable)` can be used to enable or\ndisable the [feature](`e:system:features.md#features`) `FeatureName`. This is\nthe preferred way of enabling (disabling) features, although it is possible to\ndo it with options to the compiler as well.\n\nNote that the `-feature(..)` directive may only appear before any syntax is\nused. In practice this means it should appear before any `-export(..)` or record\ndefinitions.\n\n## \\-error() and -warning() directives\n\nThe directive `-error(Term)` causes a compilation error.\n\n_Example:_\n\n```erlang\n-module(t).\n-export([version/0]).\n\n-ifdef(VERSION).\nversion() -> ?VERSION.\n-else.\n-error(\"Macro VERSION must be defined.\").\nversion() -> \"\".\n-endif.\n```\n\nThe error message will look like this:\n\n```text\n% erlc t.erl\nt.erl:7: -error(\"Macro VERSION must be defined.\").\n```\n\nThe directive `-warning(Term)` causes a compilation warning.\n\n_Example:_\n\n```erlang\n-module(t).\n-export([version/0]).\n\n-ifndef(VERSION).\n-warning(\"Macro VERSION not defined -- using default version.\").\n-define(VERSION, \"0\").\n-endif.\nversion() -> ?VERSION.\n```\n\nThe warning message will look like this:\n\n```text\n% erlc t.erl\nt.erl:5: Warning: -warning(\"Macro VERSION not defined -- using default version.\").\n```\n\n> #### Change {: .info }\n>\n> The `-error()` and `-warning()` directives were added in Erlang/OTP 19.","title":"The -feature() directive - Preprocessor","ref":"macros.html#the-feature-directive"},{"type":"extras","doc":"The construction `??Arg`, where `Arg` is a macro argument, is expanded to a\nstring containing the tokens of the argument. This is similar to the `#arg`\nstringifying construction in C.\n\n_Example:_\n\n```erlang\n-define(TESTCALL(Call), io:format(\"Call ~s: ~w~n\", [??Call, Call])).\n\n?TESTCALL(myfunction(1,2)),\n?TESTCALL(you:function(2,1)).\n```\n\nresults in\n\n```erlang\nio:format(\"Call ~s: ~w~n\",[\"myfunction ( 1 , 2 )\",myfunction(1,2)]),\nio:format(\"Call ~s: ~w~n\",[\"you : function ( 2 , 1 )\",you:function(2,1)]).\n```\n\nThat is, a trace output, with both the function called and the resulting value.","title":"Stringifying Macro Arguments - Preprocessor","ref":"macros.html#stringifying-macro-arguments"},{"type":"extras","doc":"<!--\n%CopyrightBegin%\n\nCopyright Ericsson AB 2023-2024. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# Records\n\nA record is a data structure for storing a fixed number of elements. It has\nnamed fields and is similar to a struct in C. Record expressions are translated\nto tuple expressions during compilation.\n\nMore examples are provided in\n[Programming Examples](`e:system:prog_ex_records.md`).","title":"Records","ref":"ref_man_records.html"},{"type":"extras","doc":"A record definition consists of the name of the record, followed by the field\nnames of the record. Record and field names must be atoms. Each field can be\ngiven an optional default value. If no default value is supplied, `undefined` is\nused.\n\n```erlang\n-record(Name, {Field1 [= Expr1],\n               ...\n               FieldN [= ExprN]}).\n```\n\nThe default value for a field is an arbitrary expression, except that it must\nnot use any variables.\n\nA record definition can be placed anywhere among the attributes and function\ndeclarations of a module, but the definition must come before any usage of the\nrecord.\n\nIf a record is used in several modules, it is recommended that the record\ndefinition is placed in an include file.\n\n> #### Change {: .info }\n>\n> Starting from Erlang/OTP 26, records can be defined in the Erlang shell\n> using the syntax described in this section. In earlier releases, it was\n> necessary to use the `m:shell` built-in function `rd/2`.","title":"Defining Records - Records","ref":"ref_man_records.html#defining-records"},{"type":"extras","doc":"The following expression creates a new `Name` record where the value of each\nfield `FieldI` is the value of evaluating the corresponding expression `ExprI`:\n\n```text\n#Name{Field1=Expr1, ..., FieldK=ExprK}\n```\n\nThe fields can be in any order, not necessarily the same order as in the record\ndefinition, and fields can be omitted. Omitted fields get their respective\ndefault value instead.\n\nIf several fields are to be assigned the same value, the following construction\ncan be used:\n\n```text\n#Name{Field1=Expr1, ..., FieldK=ExprK, _=ExprL}\n```\n\nOmitted fields then get the value of evaluating `ExprL` instead of their default\nvalues. This feature is primarily intended to be used to create patterns for ETS\nand Mnesia match functions.\n\n_Example:_\n\n```erlang\n-record(person, {name, phone, address}).\n\nlookup(Name, Tab) ->\n    ets:match_object(Tab, #person{name=Name, _='_'}).\n```","title":"Creating Records - Records","ref":"ref_man_records.html#creating-records"},{"type":"extras","doc":"```text\nExpr#Name.Field\n```\n\nReturns the value of the specified field. `Expr` is to evaluate to a `Name`\nrecord.\n\n_Example_:\n\n```erlang\n-record(person, {name, phone, address}).\n\nget_person_name(Person) ->\n    Person#person.name.\n```\n\nThe following expression returns the position of the specified field in the\ntuple representation of the record:\n\n```text\n#Name.Field\n```\n\n_Example:_\n\n```erlang\n-record(person, {name, phone, address}).\n\nlookup(Name, List) ->\n    lists:keyfind(Name, #person.name, List).\n```","title":"Accessing Record Fields - Records","ref":"ref_man_records.html#accessing-record-fields"},{"type":"extras","doc":"```text\nExpr#Name{Field1=Expr1, ..., FieldK=ExprK}\n```\n\n`Expr` is to evaluate to a `Name` record. A copy of this record is returned,\nwith the value of each specified field `FieldI` changed to the value of\nevaluating the corresponding expression `ExprI`. All other fields retain their\nold values.","title":"Updating Records - Records","ref":"ref_man_records.html#updating-records"},{"type":"extras","doc":"Since record expressions are expanded to tuple expressions, creating\nrecords and accessing record fields are allowed in guards. However,\nall subexpressions (for initializing fields), must be valid guard\nexpressions as well.\n\n_Examples:_\n\n```erlang\nhandle(Msg, State) when Msg =:= #msg{to=void, no=3} ->\n    ...\n\nhandle(Msg, State) when State#state.running =:= true ->\n    ...\n```\n\nThere is also a type test BIF [`is_record(Term, RecordTag)`](`is_record/2`).\n\n_Example:_\n\n```erlang\nis_person(P) when is_record(P, person) ->\n    true;\nis_person(_P) ->\n    false.\n```","title":"Records in Guards - Records","ref":"ref_man_records.html#records-in-guards"},{"type":"extras","doc":"A pattern that matches a certain record is created in the same way as a record\nis created:\n\n```text\n#Name{Field1=Expr1, ..., FieldK=ExprK}\n```\n\nIn this case, one or more of `Expr1` ... `ExprK` can be unbound variables.","title":"Records in Patterns - Records","ref":"ref_man_records.html#records-in-patterns"},{"type":"extras","doc":"Assume the following record definitions:\n\n```erlang\n-record(nrec0, {name = \"nested0\"}).\n-record(nrec1, {name = \"nested1\", nrec0=#nrec0{}}).\n-record(nrec2, {name = \"nested2\", nrec1=#nrec1{}}).\n\nN2 = #nrec2{},\n```\n\nAccessing or updating nested records can be written without parentheses:\n\n```text\n\"nested0\" = N2#nrec2.nrec1#nrec1.nrec0#nrec0.name,\n    N0n = N2#nrec2.nrec1#nrec1.nrec0#nrec0{name = \"nested0a\"},\n```\n\nwhich is equivalent to:\n\n```text\n\"nested0\" = ((N2#nrec2.nrec1)#nrec1.nrec0)#nrec0.name,\nN0n = ((N2#nrec2.nrec1)#nrec1.nrec0)#nrec0{name = \"nested0a\"},\n```\n\n> #### Change {: .info }\n>\n> Before Erlang/OTP R14, parentheses were necessary when accessing or updating\n> nested records.","title":"Nested Records - Records","ref":"ref_man_records.html#nested-records"},{"type":"extras","doc":"Record expressions are translated to tuple expressions during compilation. A\nrecord defined as:\n\n```erlang\n-record(Name, {Field1, ..., FieldN}).\n```\n\nis internally represented by the tuple:\n\n```text\n{Name, Value1, ..., ValueN}\n```\n\nHere each `ValueI` is the default value for `FieldI`.\n\nTo each module using records, a pseudo function is added during compilation to\nobtain information about records:\n\n```erlang\nrecord_info(fields, Record) -> [Field]\nrecord_info(size, Record) -> Size\n```\n\n`Size` is the size of the tuple representation, that is, one more than the\nnumber of fields.","title":"Internal Representation of Records - Records","ref":"ref_man_records.html#internal-representation-of-records"},{"type":"extras","doc":"<!--\n%CopyrightBegin%\n\nCopyright Ericsson AB 2023-2024. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# Errors and Error Handling","title":"Errors and Error Handling","ref":"errors.html"},{"type":"extras","doc":"Errors can roughly be divided into four different types:\n\n- **Compile-time errors** - When the compiler fails to compile the program, for\n  example a syntax error.\n\n- **Logical errors** - When a program does not behave as intended, but does not\n  crash. An example is that nothing happens when a button in a graphical user\n  interface is clicked.\n\n- **[](){: #run-time-errors } Run-time errors** - \n  When a crash occurs. An example is when an operator is applied to arguments of\n  the wrong type. The Erlang programming language has built-in features for\n  handling of run-time errors. A run-time error can also be emulated by calling\n  [`error(Reason)`](`erlang:error/1`). Run-time errors are exceptions of class\n  `error`.\n\n- **[](){: #generated-errors } Generated errors**\n  When the code itself calls [`exit/1`](`erlang:exit/1`) or\n  [`throw/1`](`erlang:throw/1`). Generated errors are exceptions of class `exit`\n  or `throw`.\n\nWhen an exception occurs in Erlang, execution of the process that evaluated the\nerroneous expression is stopped. This is referred to as a _failure_, that\nexecution or evaluation _fails_, or that the process _fails_, _terminates_, or\n_exits_. Notice that a process can terminate/exit for other reasons than a\nfailure.\n\nA process that terminates emits an _exit signal_ with an _exit reason_ that\ndescribes why the process terminated. Normally, some information about any\nerroneous termination is printed to the terminal. See\n[Process Termination](ref_man_processes.md#process-termination) in the Processes\nchapter for more details on termination.","title":"Terminology - Errors and Error Handling","ref":"errors.html#terminology"},{"type":"extras","doc":"Exceptions are [run-time errors](errors.md#run-time-errors) or\n[generated errors](errors.md#generated-errors) and are of three different\nclasses, with different origins. The [try](expressions.md#try) expression can\ndistinguish between the different classes, whereas the\n[catch](expressions.md#catch-and-throw) expression cannot. `try` and `catch` are described\nin [Expressions](expressions.md).\n\n| _Class_ | _Origin_                                                                           |\n| ------- | ---------------------------------------------------------------------------------- |\n| `error` | Run-time error, for example, `1+a`, or the process called [`error/1`](`error/1`)   |\n| `exit`  | The process called [`exit/1`](`exit/1`)                                            |\n| `throw` | The process called [`throw/1`](`throw/1`)                                          |\n\n_Table: Exception Classes._\n\nAll of the above exceptions can also be generated by calling `erlang:raise/3`.\n\nAn exception consists of its class, an exit reason (see\n[Exit Reason](errors.md#exit_reasons)), and a stack trace (which aids in finding\nthe code location of the exception).\n\nThe stack trace can be bound to a variable from within a `try` expression for\nany exception class, or as part of the exit reason when a run-time error is\ncaught by a `catch`. Example:\n\n```erlang\n> {'EXIT',{test,Stacktrace}} = (catch error(test)), Stacktrace.\n[{shell,apply_fun,3,[]},\n {erl_eval,do_apply,6,[]},\n ...]\n> try throw(test) catch Class:Reason:Stacktrace -> Stacktrace end.\n[{shell,apply_fun,3,[]},\n {erl_eval,do_apply,6,[]},\n ...]\n```\n\n[](){: #stacktrace }","title":"Exceptions - Errors and Error Handling","ref":"errors.html#exceptions"},{"type":"extras","doc":"The stack back-trace ([_stacktrace_](`t:erlang:stacktrace/0`)) is a list that\ncontains `{Module, Function, Arity, ExtraInfo}` and/or `{Fun, Arity, ExtraInfo}`\ntuples. The field `Arity` in the tuple can be the argument list of that function\ncall instead of an arity integer, depending on the exception.\n\n`ExtraInfo` is a (possibly empty) list of two-element tuples in any order that\nprovides additional information about the exception. The first element is an\natom describing the type of information in the second element. The following\nitems can occur:\n\n- **`error_info`** - The second element of the tuple is a map providing\n  additional information about what caused the exception. This information can\n  be created by calling [`error/3`](`erlang:error/3`) and is used by\n  `erl_error:format_exception/4`.\n\n- **`file`** - The second element of the tuple is a string (list of characters)\n  representing the filename of the source file of the function.\n\n- **`line`** - The second element of the tuple is the line number (an\n  integer > 0) in the source file where the exception occurred or the function\n  was called.\n\n> #### Warning {: .warning }\n>\n> Developers should rely on stacktrace entries only for debugging purposes.\n>\n> The VM performs tail call optimization, which does not add new entries to the\n> stacktrace, and also limits stacktraces to a certain depth. Furthermore,\n> compiler options, optimizations, and future changes may add or remove\n> stacktrace entries, causing any code that expects the stacktrace to be in a\n> certain order or contain specific items to fail.\n>\n> The only exception to this rule is the class `error` with the reason `undef`\n> which is guaranteed to include the `Module`, `Function` and `Arity` of the\n> attempted function as the first stacktrace entry.","title":"The call-stack back trace (stacktrace) - Errors and Error Handling","ref":"errors.html#the-call-stack-back-trace-stacktrace"},{"type":"extras","doc":"","title":"Handling of Run-time Errors in Erlang - Errors and Error Handling","ref":"errors.html#handling-of-run-time-errors-in-erlang"},{"type":"extras","doc":"It is possible to prevent run-time errors and other exceptions from\ncausing the process to terminate by using [`try`](expressions.md#try)\nor [`catch`](expressions.md#catch-and-throw).","title":"Error Handling Within Processes - Errors and Error Handling","ref":"errors.html#error-handling-within-processes"},{"type":"extras","doc":"Processes can monitor other processes and detect process terminations, see\n[Processes](ref_man_processes.md#errors).\n\n[](){: #exit_reasons }","title":"Error Handling Between Processes - Errors and Error Handling","ref":"errors.html#error-handling-between-processes"},{"type":"extras","doc":"When a run-time error occurs, that is an exception of class `error`. The exit\nreason is a tuple `{Reason,Stack}`, where `Reason` is a term indicating the type\nof error:\n\n- **`badarg`** - Bad argument. The argument is of wrong data type, or\n    is otherwise badly formed.\n\n- **`badarith`** - An argument for an arithmetic expression was not numeric,\n    or the expression does not evaluate to finite number.\n\n- **`{badmatch,V}`** - Evaluation of a match expression failed. The\n    value `V` did not match.\n\n- **`function_clause`** - No matching function clause is found when\n    evaluating a function call.\n\n- **`{case_clause,V}`** - No matching branch is found when evaluating\n    a `case` expression. The value `V` did not match.\n\n- **`if_clause`** - No true branch is found when evaluating an `if`\n    expression.\n\n- **`{try_clause,V}`** - No matching branch is found when evaluating\n    the of-section of a `try` expression. The value `V` did not\n    match.\n\n- **`undef`** - The function cannot be found when evaluating a\n    function call.\n\n- **`{badfun,F}`** - `F` was expected to a be a fun, but is not.\n\n- **`{badarity,{Fun,Args}}`** - A fun is applied to the wrong number of\n    arguments.\n\n- **`timeout_value`** - The timeout value in a `receive...after`\n    expression is evaluated to something else than an integer or\n    `infinity`.\n\n- **`noproc`** - Trying to create [link](`link/1`) or\n    [monitor](`monitor/2`) to a non-existing process or port.\n\n- **`noconnection`** - A link or monitor to a remote process was\n    broken because a connection between the nodes could not be\n    established or was severed.\n\n- **`{nocatch,V}`** - Trying to evaluate a `throw `outside a\n    `catch`. `V` is the thrown term.\n\n- **`system_limit`** - A system limit has been reached. See\n    [System Limits in the Efficiency Guide](`e:system:system_limits.md`)\n    for information about system limits.\n\n`Stack` is the stack of function calls being evaluated when the error occurred,\ngiven as a list of tuples `{Module,Name,Arity,ExtraInfo}` with the most recent\nfunction call first. The most recent function call tuple can in some cases be\n`{Module,Name,[Arg],ExtraInfo}`.","title":"Exit Reasons - Errors and Error Handling","ref":"errors.html#exit-reasons"},{"type":"extras","doc":"<!--\n%CopyrightBegin%\n\nCopyright Ericsson AB 2023-2024. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# Features\n\n[](){: #features } Introduced in OTP 25, Erlang has the concept of selectable\nfeatures. A feature can change, add or remove behaviour of the language and/or\nruntime system. Examples can include:\n\n- Adding new syntactical constructs to the language\n- Change the semantics of an existing construct\n- Change the behaviour of some runtime aspect\n\nA feature will start out with a status of experimental part of OTP, making it\npossible to try out for users and give feedback. The possibility to try out\nfeatures is enabled by options to the compiler, directives in a module and\noptions to the runtime system. Even when a feature is not experimental it will\nstill be possible to enable or disable it. This makes it possible to adapt a\ncode base at a suitable pace instead of being forced when changing to a new\nrelease.\n\nThe status of a feature will eventually end up as being either a permanent part\nof OTP or rejected, being removed and no longer selectable.","title":"Features","ref":"features.html"},{"type":"extras","doc":"A feature is in one of four possible states:\n\n- **Experimental** - The initial state, is meant for trying out and collecting\n  feedback. The feature can be enabled but is disabled by default.\n\n- **Approved** - The feature has been finalised and is now part of OTP. By\n  default it is enabled, but can be disabled.\n\n- **Permanent** - The feature is now a permanent part of OTP. It can no longer\n  be disabled.\n\n- **Rejected** - The feature never reached the approved state and will not be\n  part of OTP. It cannot be enabled.\n\nAfter leaving the experimental state, a feature can enter any of the other three\nstates, and if the next state is approved, the feature will eventually end up in\nthe permanent state. A feature can change state only in connection with a\nrelease.\n\nA feature may be in the approved state for several releases.\n\n| State        | Default  | Configurable | Available |\n| ------------ | -------- | ------------ | --------- |\n| Experimental | disabled | yes          | yes       |\n| Approved     | enabled  | yes          | yes       |\n| Permanent    | enabled  | no           | yes       |\n| Rejected     | disabled | no           | no        |\n\n_Table: Feature States_\n\n- Being configurable means the possibility to enable or disable the feature by\n  means of compiler options and directives in the file being compiled.\n- Being available can be seen using the `FEATURE_AVAILABLE` macro.","title":"Life cycle of features - Features","ref":"features.html#life-cycle-of-features"},{"type":"extras","doc":"To use a feature that is in the experimental state, it has to be enabled during\ncompilation. This can be done in a number of different ways:\n\n- **Options to `erlc`** - Options\n  [`-enable-feature`](`e:erts:erlc_cmd.md#enable-feature`) and\n  [`-disable-feature`](`e:erts:erlc_cmd.md#disable-feature`) can be used to\n  enable or disable individal features.\n\n- **Compiler options** - The compiler option\n  [`{feature,  , enable|disable}`](`m:compile#feature-option`) can be\n  used either as a `+ ` option to `erlc` or in the options argument to\n  functions in the `compile` module.\n\n- **The feature directive** - Inside a prefix of a module, one can use a\n  [`-feature( , enable|disable)`](macros.md#feature-directive)\n  directive. This is the preferred method of enabling and disabling features.\n\n> #### Change {: .info }\n>\n> In Erlang/OTP 25, in order to load a module with a feature enabled, it was\n> necessary to also enable the feature in the runtime. This was done using\n> option [`-enable-feature`](`e:erts:erl_cmd.md#enable-feature`) to `erl`. This\n> requirement was removed in Erlang/OTP 26. However, if you want to use features\n> directly in shell, you still need to enable them in the runtime.","title":"Enabling and Disabling Features - Features","ref":"features.html#enabling-and-disabling-features"},{"type":"extras","doc":"To allow for conditional compilation during transitioning of a code base and/or\ntrying out experimental features\n[feature](`e:system:macros.md#predefined-macros`) `predefined macros`\n`?FEATURE_AVAILABLE(Feature)` and `?FEATURE_ENABLED(Feature)` are available.","title":"Preprocessor Additions - Features","ref":"features.html#preprocessor-additions"},{"type":"extras","doc":"The module `erl_features` `m:erl_features` exports a number of functions that\ncan be used to obtain information about current features as well as the features\nused when compiling a module.\n\nOne can also use the `erlc` options\n[`-list-features`](`e:erts:erlc_cmd.md#list-features`) and\n[`-describe-feature  `](`e:erts:erlc_cmd.md#describe-feature`) to get\ninformation about existing features.\n\nAdditionally, there is the compiler option\n[`warn_keywords`](`m:compile#warn-keywords`) that can be used to find atoms in\nthe code base that might collide with keywords in features not yet enabled.","title":"Information about Existing Features - Features","ref":"features.html#information-about-existing-features"},{"type":"extras","doc":"The following configurable features exist:\n\n- **`maybe_expr` (approved)** - Implementation of the\n  [`maybe`](expressions.md#maybe) expression proposed in\n  [EEP 49](https://www.erlang.org/eeps/eep-0049).\n  It was approved in Erlang/OTP 27.","title":"Existing Features - Features","ref":"features.html#existing-features"},{"type":"extras","doc":"<!--\n%CopyrightBegin%\n\nCopyright Ericsson AB 2023-2024. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# Processes","title":"Processes","ref":"ref_man_processes.html"},{"type":"extras","doc":"Erlang is designed for massive concurrency. Erlang processes are lightweight\n(grow and shrink dynamically) with small memory footprint, fast to create and\nterminate, and the scheduling overhead is low.","title":"Processes - Processes","ref":"ref_man_processes.html#processes"},{"type":"extras","doc":"A process is created by calling [`spawn()`](`erlang:spawn/3`):\n\n```erlang\nspawn(Module, Name, Args) -> pid()\n  Module = Name = atom()\n  Args = [Arg1,...,ArgN]\n    ArgI = term()\n```\n\n`spawn()` creates a new process and returns the pid.\n\nThe new process starts executing in `Module:Name(Arg1,...,ArgN)` where the\narguments are the elements of the (possible empty) `Args` argument list.\n\nThere exist a number of different `spawn` BIFs:\n\n- [`spawn/1,2,3,4`](`erlang:spawn/4`)\n- [`spawn_link/1,2,3,4`](`erlang:spawn_link/4`)\n- [`spawn_monitor/1,2,3,4`](`erlang:spawn_monitor/4`)\n- [`spawn_opt/2,3,4,5`](`erlang:spawn_opt/5`)\n- [`spawn_request/1,2,3,4,5`](`erlang:spawn_request/5`)","title":"Process Creation - Processes","ref":"ref_man_processes.html#process-creation"},{"type":"extras","doc":"Besides addressing a process by using its pid, there are also BIFs for\nregistering a process under a name. The name must be an atom and is\nautomatically unregistered if the process terminates:\n\n| _BIF_                                 | _Description_                                                                          |\n| ------------------------------------- | -------------------------------------------------------------------------------------- |\n| [`register(Name, Pid)`](`register/2`) | Associates the name `Name`, an atom, with the process `Pid`.                           |\n| `registered/0`                        | Returns a list of names that have been registered using [`register/2`](`register/2`).  |\n| [`whereis(Name)`](`whereis/1`)        | Returns the pid registered under `Name`, or `undefined `if the name is not registered. |\n\n_Table: Name Registration BIFs_","title":"Registered Processes - Processes","ref":"ref_man_processes.html#registered-processes"},{"type":"extras","doc":"When sending a message to a process, the receiving process can be identified by\na [Pid](data_types.md#pid), a\n[registered name](ref_man_processes.md#registered-processes), or a _process\nalias_ which is a term of the type [reference](data_types.md#reference). The\ntypical use case that process aliases were designed for is a request/reply\nscenario. Using a process alias when sending the reply makes it possible for the\nreceiver of the reply to prevent the reply from reaching its message queue if\nthe operation times out or if the connection between the processes is lost.\n\nA process alias can be used as identifier of the receiver when sending a message\nusing the [send operator (`!`)](expressions.md#send) or send BIFs such as\n`erlang:send/2`. As long as the process alias is active, messages will be\ndelivered the same way as if the process identifier of the process that created\nthe alias had been used. When the alias has been deactivated, messages sent\nusing the alias will be dropped before entering the message queue of the\nreceiver. Note that messages that at deactivation time already have entered the\nmessage queue will _not_ be removed.\n\nA process alias is created either by calling one of the\n[`alias/0,1`](`erlang:alias/0`) BIFs or by creating an alias and a monitor\nsimultaneously. If the alias is created together with a monitor, the same\nreference will be used both as monitor reference and alias. Creating a monitor\nand an alias at the same time is done by passing the `{alias, _}` option to the\n[`monitor/3`](`erlang:monitor/3`) BIF. The `{alias, _}` option can also be\npassed when creating a monitor via [`spawn_opt()`](`erlang:spawn_opt/5`), or\n[`spawn_request()`](`erlang:spawn_request/5`).\n\nA process alias can be deactivated by the process that created it by calling the\n[`unalias/1`](`erlang:unalias/1`) BIF. It is also possible to automatically\ndeactivate an alias on certain events. See the documentation of the\n[`alias/1`](`erlang:alias/1`) BIF, and the `{alias, _}` option of the\n[`monitor/3`](`erlang:monitor/3`) BIF for more information about automatic\ndeactivation of aliases.\n\nIt is _not_ possible to:\n\n- create an alias identifying another process than the caller.\n- deactivate an alias unless it identifies the caller.\n- look up an alias.\n- look up the process identified by an alias.\n- check if an alias is active or not.\n- check if a reference is an alias.\n\nThese are all intentional design decisions relating to performance, scalability,\nand distribution transparency.","title":"Process Aliases - Processes","ref":"ref_man_processes.html#process-aliases"},{"type":"extras","doc":"When a process terminates, it always terminates with an _exit reason_. The\nreason can be any term.\n\nA process is said to terminate _normally_, if the exit reason is the atom\n`normal`. A process with no more code to execute terminates normally.\n\nA process terminates with an exit reason `{Reason,Stack}` when a run-time error\noccurs. See [Exit Reasons](errors.md#exit_reasons).\n\nA process can terminate itself by calling one of the following BIFs:\n\n- [`exit(Reason)`](`exit/1`)\n- [`error(Reason)`](`erlang:error/1`)\n- [`error(Reason, Args)`](`erlang:error/2`)\n\nThe process then terminates with reason `Reason` for [`exit/1`](`exit/1`) or\n`{Reason,Stack}` for the others.\n\nA process can also be terminated if it receives an exit signal with another exit\nreason than `normal`, see [Error Handling](ref_man_processes.md#errors).","title":"Process Termination - Processes","ref":"ref_man_processes.html#process-termination"},{"type":"extras","doc":"[](){: #message-sending } All communication between Erlang processes and Erlang\nports is done by sending and receiving asynchronous signals. The most common\nsignals are Erlang message signals. A message signal can be sent using the\n[send operator `!`](expressions.md#send). A received message can be fetched from\nthe message queue by the receiving process using the\n[`receive`](expressions.md#receive) expression.\n\n[](){: #sync-comm }\n\nSynchronous communication can be broken down into multiple asynchronous signals.\nAn example of such a synchronous communication is a call to the\n`erlang:process_info/2` BIF when the first argument does not equal the process\nidentifier of the calling process. The caller sends an asynchronous signal\nrequesting information, and then blocks waiting for the reply signal containing\nthe requested information. When the request signal reaches its destination, the\ndestination process replies with the requested information.","title":"Signals - Processes","ref":"ref_man_processes.html#signals"},{"type":"extras","doc":"There are many signals that processes and ports use to communicate. The list\nbelow contains the most important signals. In all the cases of request/reply\nsignal pairs, the request signal is sent by the process calling the specific\nBIF, and the reply signal is sent back to it when the requested operation has\nbeen performed.\n\n- **`message`** - Sent when using the [send operator `!`](expressions.md#send),\n  or when calling one of the [`erlang:send/2,3`](`erlang:send/2`) or\n  [`erlang:send_nosuspend/2,3`](`erlang:send_nosuspend/2`) BIFs.\n\n- **`link`** - Sent when calling the [link/1](`erlang:link/1`) BIF.\n\n- **`unlink`** - Sent when calling the [unlink/1](`erlang:unlink/1`) BIF.\n\n- **`exit`** - Sent either when explicitly sending an `exit` signal by calling\n  the [exit/2](`erlang:exit/2`) BIF, or when a\n  [linked process terminates](ref_man_processes.md#sending_exit_signals). If the\n  signal is sent due to a link, the signal is sent after all\n  [_directly visible Erlang resources_](ref_man_processes.md#visible-resources)\n  used by the process have been released.\n\n- **`monitor`** - Sent when calling one of the [monitor/2,3](`erlang:monitor/3`)\n  BIFs.\n\n- **`demonitor`** - Sent when calling one of the\n  [demonitor/1,2](`erlang:demonitor/1`) BIFs, or when a process monitoring\n  another process terminates.\n\n- **`down`** - Sent by a\n  [monitored process or port that terminates](ref_man_processes.md#monitors).\n  The signal is sent after all\n  [_directly visible Erlang resources_](ref_man_processes.md#visible-resources)\n  used by the process or the port have been released.\n\n- **`change`** - Sent by the\n  [clock service](ref_man_processes.md#runtime-service) on the local runtime\n  system, when the [time offset](`erlang:time_offset/0`) changes, to processes\n  which have [monitored the `time_offset`](`erlang:monitor/2`).\n\n- **`group_leader`** - Sent when calling the\n  [group_leader/2](`erlang:group_leader/2`) BIF.\n\n- **`spawn_request`/`spawn_reply`, `open_port_request`/`open_port_reply`** -\n  Sent due to a call to one of the [`spawn/1,2,3,4`](`erlang:spawn/4`),\n  [`spawn_link/1,2,3,4`](`erlang:spawn_link/4`),\n  [`spawn_monitor/1,2,3,4`](`erlang:spawn_monitor/4`),\n  [`spawn_opt/2,3,4,5`](`erlang:spawn_opt/5`),\n  [`spawn_request/1,2,3,4,5`](`erlang:spawn_request/5`), or `erlang:open_port/2`\n  BIFs. The request signal is sent to the\n  [spawn service](ref_man_processes.md#runtime-service) which responds with the\n  reply signal.\n\n- **`alive_request`/`alive_reply`** - Sent due to a call to the\n  [is_process_alive/1](`erlang:is_process_alive/1`) BIF.\n\n- **`garbage_collect_request`/`garbage_collect_reply`,\n  `check_process_code_request`/`check_process_code_reply`,\n  `process_info_request`/`process_info_reply`** - Sent due to a call to one of\n  the [garbage_collect/1,2](`erlang:garbage_collect/1`),\n  [erlang:check_process_code/2,3](`erlang:check_process_code/2`), or\n  [process_info/1,2](`erlang:process_info/2`) BIFs. Note that if the request is\n  directed towards the caller itself and it is a synchronous request, no\n  signaling will be performed and the caller will instead synchronously perform\n  the request before returning from the BIF.\n\n- **`port_command`, `port_connect`, `port_close`** - Sent by a process to a port\n  on the local node using the [send operator (`!`)](expressions.md#send), or by\n  calling one of the [`send()`](`erlang:send/2`) BIFs. The signal is sent by\n  passing a term on the format `{Owner, {command, Data}}`,\n  `{Owner, {connect, Pid}}`, or `{Owner, close}` as message.\n\n- **`port_command_request`/`port_command_reply`,\n  `port_connect_request`/`port_connect_reply`,\n  `port_close_request`/`port_close_reply`,\n  `port_control_request`/`port_control_reply`,\n  `port_call_request`/`port_call_reply`,\n  `port_info_request`/`port_info_reply`** - Sent due to a call to one of the\n  [`erlang:port_command/2,3`](`erlang:port_command/2`), `erlang:port_connect/2`,\n  `erlang:port_close/1`, `erlang:port_control/3`, `erlang:port_call/3`,\n  [`erlang:port_info/1,2`](`erlang:port_info/1`) BIFs. The request signal is\n  sent to a port on the local node which responds with the reply signal.\n\n- **`register_name_request`/`register_name_reply`,\n  `unregister_name_request`/`unregister_name_reply`,\n  `whereis_name_request`/`whereis_name_reply`** - Sent due to a call to one of\n  the [`register/2`](`erlang:register/2`),\n  [`unregister/1`](`erlang:unregister/1`), or [`whereis/1`](`erlang:whereis/1`)\n  BIFs. The request signal is sent to the\n  [name service](ref_man_processes.md#runtime-service), which responds with the\n  reply signal.\n\n- **`timer_start_request`/`timer_start_reply`,\n  `timer_cancel_request`/`timer_cancel_reply`** - Sent due to a call to one of\n  the [`erlang:send_after/3,4`](`erlang:send_after/3`),\n  [`erlang:start_timer/3,4`](`erlang:start_timer/3`), or\n  [`erlang:cancel_timer/1,2`](`erlang:cancel_timer/1`) BIFs. The request signal\n  is sent to the [timer service](ref_man_processes.md#runtime-service) which\n  responds with the reply signal.\n\n[](){: #runtime-service } The clock service, the name service, the timer\nservice, and the spawn service mentioned previously are services provided by the\nruntime system. Each of these services consists of multiple independently\nexecuting entities. Such a service can be viewed as a group of processes, and\ncould actually be implemented like that. Since each service consists of multiple\nindependently executing entities, the order between multiple signals sent from\none service to one process is _not_ preserved. Note that this does _not_ violate\nthe [signal ordering guarantee](ref_man_processes.md#signal-delivery) of the\nlanguage.\n\nThe realization of the signals described earlier may change both at runtime and\ndue to changes in implementation. You may be able to detect such changes using\n`receive` tracing or by inspecting message queues. However, these are internal\nimplementation details of the runtime system that you should _not_ rely on. As\nan example, many of the reply signals are ordinary message signals. When\nthe operation is synchronous, the reply signals do not have to be message\nsignals. The current implementation takes advantage of this and, depending on\nthe state of the system, use alternative ways of delivering the reply signals.\nThe implementation of these reply signals may also, at any time, be changed to\nnot use message signals where it previously did.","title":"Sending Signals - Processes","ref":"ref_man_processes.html#sending-signals"},{"type":"extras","doc":"Signals are received asynchronously and automatically. There is nothing a\nprocess must do to handle the reception of signals, or can do to prevent it. In\nparticular, signal reception is _not_ tied to the execution of a\n[`receive`](expressions.md#receive) expression, but can happen anywhere in the\nexecution flow of a process.\n\nWhen a signal is received by a process, some kind of action is taken. The\nspecific action taken depends on the signal type, contents of the signal, and\nthe state of the receiving process. Actions taken for the most common signals:\n\n- **`message`** - If the message signal was sent using a\n  [process alias](ref_man_processes.md#process-aliases) that is no longer\n  active, the message signal will be dropped; otherwise, if the alias is still\n  active or the message signal was sent by other means, the message is added to\n  the end of the message queue. When the message has been added to the message\n  queue, the receiving process can fetch the message from the message queue\n  using the [`receive`](expressions.md#receive) expression.\n\n- **`link`, `unlink`** - Very simplified it can be viewed as updating process\n  local information about the link. A detailed description of the\n  [link protocol](`e:erts:erl_dist_protocol.md#link_protocol`) can be found in\n  the _Distribution Protocol_ chapter of the _ERTS User's Guide_.\n\n- **`exit`** - Set the receiver in an exiting state, drop the signal, or convert\n  the signal into a message and add it to the end of the message queue. If the\n  receiver is set in an exiting state, no more Erlang code will be executed and\n  the process is scheduled for termination. The section\n  [_Receiving Exit Signals_](ref_man_processes.md#receiving_exit_signals) below\n  gives more details on the action taken when an `exit` signal is received.\n\n- **`monitor`, `demonitor`** - Update process local information about the\n  monitor.\n\n- **`down`, `change`** - Convert into a message if the corresponding monitor is\n  still active; otherwise, drop the signal. If the signal is converted into a\n  message, it is also added to the end of the message queue.\n\n- **`group_leader`** - Change the group leader of the process.\n\n- **`spawn_reply`** - Convert into a message, or drop the signal depending on\n  the reply and how the `spawn_request` signal was configured. If the signal is\n  converted into a message it is also added to the end of the message queue. For\n  more information see the [`spawn_request()`](`erlang:spawn_request/5`) BIF.\n\n- **`alive_request`** - Schedule execution of the _is alive_ test. If the\n  process is in an exiting state, the _is alive_ test will not be executed until\n  after all\n  [_directly visible Erlang resources_](ref_man_processes.md#visible-resources)\n  used by the process have been released. The `alive_reply` will be sent after\n  the _is alive_ test has executed.\n\n- **`process_info_request`, `garbage_collect_request`,\n  `check_process_code_request`** - Schedule execution of the requested\n  operation. The reply signal will be sent when the operation has been executed.\n\nNote that some actions taken when a signal is received involves _scheduling_\nfurther actions which will result in a reply signal when these scheduled actions\nhave completed. This implies that the reply signals may be sent in a different\norder than the order of the incoming signals that triggered these operations.\nThis does, however, _not_ violate the\n[signal ordering guarantee](ref_man_processes.md#signal-delivery) of the\nlanguage.\n\n[](){: #message-queue-order } The order of messages in the message queue of a\nprocess reflects the order in which the signals corresponding to the messages\nhas been received since\n[all signals that add messages to the message queue add them at the end of the message queue](ref_man_processes.md#receiving-signals).\nMessages corresponding to signals from the same sender are also ordered in the\nsame order as the signals were sent due to the\n[signal ordering guarantee](ref_man_processes.md#signal-delivery) of the\nlanguage.\n\n[](){: #visible-resources }","title":"Receiving Signals - Processes","ref":"ref_man_processes.html#receiving-signals"},{"type":"extras","doc":"As described earlier, `exit` signals due to links, `down` signals, and reply\nsignals from an exiting process due to `alive_request`s are not sent until all\n_directly visible Erlang resources_ held by the terminating process have been\nreleased. With _directly visible Erlang resources_ we here mean all resources\nmade available by the language excluding resources held by heap data, dirty\nnative code execution and the process identifier of the terminating process.\nExamples of _directly visible Erlang resources_ are\n[registered name](ref_man_processes.md#registered-processes) and [ETS](`m:ets`)\ntables.\n\n#### The Excluded Resources\n\nThe process identifier of the process cannot be released for reuse until\neverything regarding the process has been released.\n\nA process executing dirty native code in a NIF when it receives an exit signal\nwill be set into an exiting state even if it is still executing dirty native\ncode. _Directly visible Erlang resources_ will be released, but the runtime\nsystem cannot force the native code to stop executing. The runtime system tries\nto prevent the execution of the dirty native code from affecting other processes\nby, for example, disabling functionality such as\n[`enif_send()`](`e:erts:erl_nif.md#enif_send`) when used from a terminated\nprocess, but if the NIF is not well behaved it can still affect other processes.\nA well behaved dirty NIF should test if\n[the process it is executing in has exited](`e:erts:erl_nif.md#enif_is_current_process_alive`),\nand if so stop executing.\n\nIn the general case, the heap of a process cannot be removed before all signals\nthat it needs to send have been sent. Resources held by heap data are the memory\nblocks containing the heap, but also include things referred to from the heap\nsuch as off heap binaries, and resources held via NIF\n[resource objects](`e:erts:erl_nif.md#resource_objects`) on the heap.\n\n[](){: #signal-delivery }","title":"Directly Visible Erlang Resources - Processes","ref":"ref_man_processes.html#directly-visible-erlang-resources"},{"type":"extras","doc":"The amount of time that passes between the time a signal is sent and the arrival\nof the signal at the destination is unspecified but positive. If the receiver\nhas terminated, the signal does not arrive, but it can trigger another signal.\nFor example, a `link` signal sent to a non-existing process triggers an `exit`\nsignal, which is sent back to where the `link` signal originated from. When\ncommunicating over the distribution, signals can be lost if the distribution\nchannel goes down.\n\nThe only signal ordering guarantee given is the following: if an entity sends\nmultiple signals to the same destination entity, the order is preserved; that\nis, if `A` sends a signal `S1` to `B`, and later sends signal `S2` to `B`, `S1`\nis guaranteed not to arrive after `S2`. Note that `S1` may, or may not have been\nlost.\n\n[](){: #signal-irregularities }","title":"Delivery of Signals - Processes","ref":"ref_man_processes.html#delivery-of-signals"},{"type":"extras","doc":"- **Synchronous Error Checking** - Some functionality that send signals have\n  synchronous error checking when sending locally on a node and fail if the\n  receiver is not present at the time when the signal is sent:\n\n  - The [send operator (`!`)](expressions.md#send),\n    [`erlang:send/2,3`](`erlang:send/2`), BIFs and\n    [`erlang:send_nosuspend/2,3`](`erlang:send_nosuspend/2`) BIFs when the\n    receiver is identified by a name that is expected to be registered locally.\n  - `erlang:link/1`\n  - `erlang:group_leader/2`\n\n- **Unexpected Behaviours of Exit Signals** - When a process sends an exit\n  signal with exit reason `normal` to itself by calling\n  [`erlang:exit(self(), normal)`](`erlang:exit/2`) it will be terminated\n  [when the `exit` signal is received](ref_man_processes.md#receiving_exit_signals).\n  In all other cases when an exit signal with exit reason `normal` is received,\n  it is dropped.\n\n  When an\n  [`exit` signal with exit reason `kill` is received](ref_man_processes.md#receiving_exit_signals),\n  the action taken is different depending on whether the signal was sent due to\n  a linked process terminating, or the signal was explicitly sent using the\n  [`exit/2`](`erlang:exit/2`) BIF. When sent using the [`exit/2`](`exit/2`) BIF,\n  the signal cannot be [trapped](`m:erlang#process_flag_trap_exit`), while it\n  can be trapped if the signal was sent due to a link.\n\n- **Blocking Signaling Over Distribution[](){:\n  #blocking-signaling-over-distribution } **\n   When sending a signal over a distribution channel, the sending process may be\n  suspended even though the signal is supposed to be sent asynchronously. This is\n  due to the built in flow control over the channel that has been present more or\n  less for ever. When the size of the output buffer for the channel reach the _distribution\n  buffer busy limit_, processes sending on the channel will be suspended until the\n  size of the buffer shrinks below the limit.\n\n  Depending on the reason for why the buffer got full, the time it takes before\n  suspended processes are resumed can vary _very much_. A consequence of this\n  can, for example, be that a timeout in a call to [erpc:call()](`erpc:call/5`)\n  is significantly delayed.\n\n  Since this functionality has been present for so long, it is not possible to\n  remove it, but it is possible to enable _fully asynchronous distributed\n  signaling_ on a per process level using\n  [`process_flag(async_dist, Bool)`](`m:erlang#process_flag_async_dist`) which\n  can be used to solve problems occuring due to blocking signaling. However,\n  note that you need to make sure that flow control for data sent using _fully\n  asynchronous distributed signaling_ is implemented, or that the amount of such\n  data is known to always be limited; otherwise, you may get into a situation\n  with excessive memory usage.\n\n  The size of the _distribution buffer busy limit_ can be inspected by calling\n  [`erlang:system_info(dist_buf_busy_limit)`](`m:erlang#system_info_dist_buf_busy_limit`).\n\nThe irregularities mentioned earlier cannot be fixed as they have been part of\nErlang too long and it would break a lot of existing code.","title":"Irregularities - Processes","ref":"ref_man_processes.html#irregularities"},{"type":"extras","doc":"Two processes can be _linked_ to each other. Also a process and a port that\nreside on the same node can be linked to each other. A link between two\nprocesses can be created if one of them calls the [`link/1`](`erlang:link/1`)\nBIF with the process identifier of the other process as argument. Links can also\nbe created using one the following spawn BIFs\n[`spawn_link()`](`erlang:spawn_link/4`), [`spawn_opt()`](`erlang:spawn_opt/5`),\nor [`spawn_request()`](`erlang:spawn_request/5`). The spawn operation and the\nlink operation will be performed atomically, in these cases.\n\nIf one of the participants of a link terminates, it will\n[send an exit signal](ref_man_processes.md#sending_exit_signals) to the other\nparticipant. The exit signal will contain the\n[exit reason](ref_man_processes.md#link_exit_signal_reason) of the terminated\nparticipant.\n\nA link can be removed by calling the [`unlink/1`](`erlang:unlink/1`) BIF.\n\nLinks are bidirectional and there can only be one link between two processes.\nRepeated calls to `link()` have no effect. Either one of the involved processes\nmay create or remove a link.\n\nLinks are used to monitor the behavior of other processes, see\n[Error Handling](ref_man_processes.md#errors).\n\n[](){: #errors }","title":"Links - Processes","ref":"ref_man_processes.html#links"},{"type":"extras","doc":"Erlang has a built-in feature for error handling between processes. Terminating\nprocesses emit exit signals to all linked processes, which can terminate as well\nor handle the exit in some way. This feature can be used to build hierarchical\nprogram structures where some processes are supervising other processes, for\nexample, restarting them if they terminate abnormally.\n\nSee\n[OTP Design Principles](`e:system:design_principles.md`)\nfor more information about OTP supervision trees, which use this feature.\n\n[](){: #sending_exit_signals }","title":"Error Handling - Processes","ref":"ref_man_processes.html#error-handling"},{"type":"extras","doc":"When a process or port [terminates](ref_man_processes.md#process-termination) it\nwill send exit signals to all processes and ports that it is\n[linked](ref_man_processes.md#links) to. The exit signal will contain the\nfollowing information:\n\n- **Sender identifier** - The process or port identifier of the process or port\n  that terminated.\n\n- **Receiver identifier** - The process or port identifier of the process or\n  port which the exit signal is sent to.\n\n- **The `link` flag** - This flag will be set indicating that the exit signal\n  was sent due to a link.\n\n- **[](){: #link_exit_signal_reason } Exit reason**  \n  The exit reason of the process or port that terminated or the atom:\n\n  - `noproc` in case no process or port was found when setting up a link in a\n    preceding call to the [`link(PidOrPort)`](`erlang:link/1`) BIF. The process\n    or port identified as sender of the exit signal will equal the `PidOrPort`\n    argument passed to [`link/1`](`link/1`).\n  - `noconnection` in case the linked processes resides on different nodes and\n    the connection between the nodes was lost or could not be established. The\n    process or port identified as sender of the exit signal might in this case\n    still be alive.\n\nExit signals can also be sent explicitly by calling the\n[`exit(PidOrPort, Reason)`](`erlang:exit/2`) BIF. The exit signal is sent to the\nprocess or port identified by the `PidOrPort` argument. The exit signal sent\nwill contain the following information:\n\n- **Sender identifier** - The process identifier of the process that called\n  [`exit/2`](`exit/2`).\n\n- **Receiver identifier** - The process or port identifier of the process or\n  port which the exit signal is sent to.\n\n- **The `link` flag** - This flag will not be set, indicating that this exit\n  signal was not sent due to a link.\n\n- **Exit reason** - The term passed as `Reason` in the call to\n  [`exit/2`](`exit/2`). If `Reason` is the atom `kill`, the receiver cannot\n  [trap the exit](`m:erlang#process_flag_trap_exit`) signal and will\n  unconditionally terminate when it receives the signal.\n\n[](){: #receiving_exit_signals }","title":"Sending Exit Signals - Processes","ref":"ref_man_processes.html#sending-exit-signals"},{"type":"extras","doc":"What happens when a process receives an exit signal depends on:\n\n- The [trap exit](`m:erlang#process_flag_trap_exit`) state of the receiver at\n  the time when the exit signal is received.\n- The exit reason of the exit signal.\n- The sender of the exit signal.\n- The state of the `link` flag of the exit signal. If the `link` flag is set,\n  the exit signal was sent due to a link; otherwise, the exit signal was sent by\n  a call to the [`exit/2`](`erlang:exit/2`) BIF.\n- If the `link` flag is set, what happens also depends on whether the\n  [link is still active or not](`erlang:unlink/1`) when the exit signal is\n  received.\n\nBased on the above states, the following will happen when an exit signal is\nreceived by a process:\n\n- The exit signal is silently dropped if:\n\n  - the `link` flag of the exit signal is set and the corresponding link has\n    been deactivated.\n  - the exit reason of the exit signal is the atom `normal`, the receiver is not\n    trapping exits, and the receiver and sender are not the same process.\n\n- The receiving process is terminated if:\n\n  - the `link` flag of the exit signal is not set, and the exit reason of the\n    exit signal is the atom `kill`. The receiving process will terminate with\n    the atom `killed` as exit reason.\n  - the receiver is not trapping exits, and the exit reason is something other\n    than the atom `normal`. Also, if the `link` flag of the exit signal is set,\n    the link also needs to be active otherwise the exit signal will be dropped.\n    The exit reason of the receiving process will equal the exit reason of the\n    exit signal. Note that if the `link` flag is set, an exit reason of `kill`\n    will _not_ be converted to `killed`.\n  - the exit reason of the exit signal is the atom `normal` and the sender of\n    the exit signal is the same process as the receiver. The `link` flag cannot\n    be set in this case. The exit reason of the receiving process will be the\n    atom `normal`.\n\n- The exit signal is converted to a message signal and added to the end of the\n  message queue of the receiver, if the receiver is trapping exits, the `link`\n  flag of the exit signal is:\n\n  - not set, and the exit reason of the signal is not the atom `kill`.\n  - set, and the corresponding link is active. Note that an exit reason of\n    `kill` will _not_ terminate the process in this case and it will not be\n    converted to `killed`.\n\n  The converted message will be on the form `{'EXIT', SenderID, Reason}` where\n  `Reason` equals the exit reason of the exit signal and `SenderID` is the\n  identifier of the process or port that sent the exit signal.","title":"Receiving Exit Signals - Processes","ref":"ref_man_processes.html#receiving-exit-signals"},{"type":"extras","doc":"An alternative to links are _monitors_. A process `Pid1` can create a\nmonitor for `Pid2` by calling the BIF [`erlang:monitor(process,\nPid2)`](`erlang:monitor/2`). The function returns a reference `Ref`.\n\nIf `Pid2` terminates with exit reason `Reason`, a 'DOWN' message is sent to\n`Pid1`:\n\n```text\n{'DOWN', Ref, process, Pid2, Reason}\n```\n\nIf `Pid2` does not exist, the 'DOWN' message is sent immediately with `Reason`\nset to `noproc`.\n\nMonitors are unidirectional. Repeated calls to `erlang:monitor(process, Pid)`\ncreates several independent monitors, and each one sends a 'DOWN' message when\n`Pid` terminates.\n\nA monitor can be removed by calling [`erlang:demonitor(Ref)`](`erlang:demonitor/1`).\n\nMonitors can be created for processes with registered names, also at other\nnodes.","title":"Monitors - Processes","ref":"ref_man_processes.html#monitors"},{"type":"extras","doc":"Each process has its own process dictionary, accessed by calling the following\nBIFs:\n\n- [`put(Key, Value)`](`erlang:put/2`)\n- [`get(Key)`](`erlang:get/1`)\n- [`get()`](`erlang:get/0`)\n- [`get_keys(Value)`](`erlang:get_keys/1`)\n- [`erase(Key)`](`erlang:erase/1`)\n- [`erase()`](`erlang:erase/0`)","title":"Process Dictionary - Processes","ref":"ref_man_processes.html#process-dictionary"},{"type":"extras","doc":"<!--\n%CopyrightBegin%\n\nCopyright Ericsson AB 2023-2024. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# Distributed Erlang","title":"Distributed Erlang","ref":"distributed.html"},{"type":"extras","doc":"A _distributed Erlang system_ consists of a number of Erlang runtime systems\ncommunicating with each other. Each such runtime system is called a _node_.\nMessage passing between processes at different nodes, as well as links and\nmonitors, are transparent when pids are used. Registered names, however, are\nlocal to each node. This means that the node must be specified as well when\nsending messages, and so on, using registered names.\n\nThe distribution mechanism is implemented using TCP/IP sockets. How to implement\nan alternative carrier is described in the\n[ERTS User's Guide](`e:erts:alt_dist.md`).\n\n> #### Warning {: .warning }\n>\n> Starting a distributed node without also specifying\n> [`-proto_dist inet_tls`](`e:erts:erl_cmd.md#proto_dist`) will expose the node\n> to attacks that may give the attacker complete access to the node and in\n> extension the cluster. When using un-secure distributed nodes, make sure that\n> the network is configured to keep potential attackers out. See the\n> [Using SSL for Erlang Distribution](`e:ssl:ssl_distribution.md`) User's Guide\n> for details on how to setup a secure distributed node.","title":"Distributed Erlang System - Distributed Erlang","ref":"distributed.html#distributed-erlang-system"},{"type":"extras","doc":"A _node_ is an executing Erlang runtime system that has been given a name, using\nthe command-line flag [`-name`](`e:erts:erl_cmd.md#name`) (long names) or\n[`-sname`](`e:erts:erl_cmd.md#sname`) (short names).\n\nThe format of the node name is an atom `name@host`. `name` is the name given by\nthe user. `host` is the full host name if long names are used, or the first part\nof the host name if short names are used. Function [`node()`](`erlang:node/0`)\nreturns the name of the node.\n\n_Example:_\n\n```erlang\n% erl -name dilbert\n(dilbert@uab.ericsson.se)1> node().\n'dilbert@uab.ericsson.se'\n\n% erl -sname dilbert\n(dilbert@uab)1> node().\ndilbert@uab\n```\n\nThe node name can also be given in runtime by calling `net_kernel:start/1`.\n\n_Example:_\n\n```erlang\n% erl\n1> node().\nnonode@nohost\n2> net_kernel:start([dilbert,shortnames]).\n{ok,<0.102.0>}\n(dilbert@uab)3> node().\ndilbert@uab\n```\n\n> #### Note {: .info }\n>\n> A node with a long node name cannot communicate with a node with a short node\n> name.","title":"Nodes - Distributed Erlang","ref":"distributed.html#nodes"},{"type":"extras","doc":"The nodes in a distributed Erlang system are loosely connected. The first time\nthe name of another node is used, for example, if\n[`spawn(Node, M, F, A)`](`spawn/4`) or `net_adm:ping(Node)` is called, a connection\nattempt to that node is made.\n\nConnections are by default transitive. If a node A connects to node B, and node\nB has a connection to node C, then node A also tries to connect to node C. This\nfeature can be turned off by using the command-line flag `-connect_all false`,\nsee [erl](`e:erts:erl_cmd.md`) in ERTS.\n\nIf a node goes down, all connections to that node are removed. Calling\n[`erlang:disconnect_node(Node)`](`erlang:disconnect_node/1`) forces\ndisconnection of a node.\n\nThe list of (visible) nodes currently connected to is returned by `nodes/0`.","title":"Node Connections - Distributed Erlang","ref":"distributed.html#node-connections"},{"type":"extras","doc":"The Erlang Port Mapper Daemon _epmd_ is automatically started at every host\nwhere an Erlang node is started. It is responsible for mapping the symbolic node\nnames to machine addresses. See the [epmd](`e:erts:epmd_cmd.md`) in ERTS.","title":"epmd - Distributed Erlang","ref":"distributed.html#epmd"},{"type":"extras","doc":"In a distributed Erlang system, it is sometimes useful to connect to a\nnode without also connecting to all other nodes. An example is some\nkind of Operation and Maintenance functionality used to inspect the\nstatus of a system, without disturbing it. For this purpose, a _hidden\nnode_ can be used.\n\nA hidden node is a node started with the command-line flag `-hidden`.\nConnections between hidden nodes and other nodes are not transitive, they must\nbe set up explicitly. Also, hidden nodes does not show up in the list of nodes\nreturned by `nodes/0`. Instead, [`nodes(hidden)`](`nodes/1`) or\n[`nodes(connected)`](`nodes/1`) must be used. This means, for example, that the\nhidden node is not added to the set of nodes that `m:global` is keeping track of.\n\n[](){: #dyn_node_name }","title":"Hidden Nodes - Distributed Erlang","ref":"distributed.html#hidden-nodes"},{"type":"extras","doc":"If the node name is set to _`undefined`_ the node will be started in a special\nmode to be the temporary client of another node. The node will then request a\ndynamic node name from the first node it connects to. In addition these\ndistribution settings will be set:\n\n```text\n-dist_listen false -hidden -kernel dist_auto_connect never\n```\n\nAs `-dist_auto_connect` is set to `never`, `net_kernel:connect_node/1` must be\ncalled in order to setup connections. If the first established connection is\nclosed (which gave the node its dynamic name), then any other connections will\nalso be closed and the node will lose its dynamic node name. A new call to\n`net_kernel:connect_node/1` can be made to get a new dynamic node name. The node\nname may change if the distribution is dropped and then set up again.\n\n> #### Change {: .info }\n>\n> The _dynamic node name_ feature is supported from Erlang/OTP 23. Both the\n> temporary client node and the first connected peer node (supplying the dynamic\n> node name) must be at least Erlang/OTP 23 for it to work.","title":"Dynamic Node Name - Distributed Erlang","ref":"distributed.html#dynamic-node-name"},{"type":"extras","doc":"A _C node_ is a C program written to act as a hidden node in a distributed\nErlang system. The library _Erl_Interface_ contains functions for this purpose.\nFor more information about C nodes, see the\n[Erl_Interface](`e:erl_interface:ei_users_guide.md`) application and\n[Interoperability Tutorial.](`e:system:tutorial.md`).","title":"C Nodes - Distributed Erlang","ref":"distributed.html#c-nodes"},{"type":"extras","doc":"> #### Note {: .info }\n>\n> \"Security\" here does _not_ mean cryptographically secure, but rather security\n> against accidental misuse, such as preventing a node from connecting to a\n> cluster with which it is not intended to communicate.\n>\n> Furthermore, the communication between nodes is per default in clear text. If\n> you need strong security, please see\n> [Using TLS for Erlang Distribution ](`e:ssl:ssl_distribution.md`)in the SSL\n> application's User's Guide.\n>\n> Also, the default random cookie mentioned in the following text is not very\n> unpredictable. A better one can be generated using primitives in the `crypto`\n> module, though this still does not make the initial handshake\n> cryptographically secure. And inter-node communication is still in clear text.\n\nAuthentication determines which nodes are allowed to communicate with each\nother. In a network of different Erlang nodes, it is built into the system at\nthe lowest possible level. All nodes use a _magic cookie_, which is an Erlang\natom, when connecting another node.\n\nDuring the connection setup, after node names have been exchanged, the magic\ncookies the nodes present to each other are compared. If they do not match, the\nconnection is rejected. The cookies themselves are never transferred, instead\nthey are compared using hashed challenges, although not in a cryptographically\nsecure manner.\n\nAt start-up, a node has a random atom assigned as its default magic cookie and\nthe cookie of other nodes is assumed to be `nocookie`. The first action of the\nErlang network authentication server (`auth`) is then to search for a file named\n`.erlang.cookie` in the [user's home directory](`m:init#home`) and then in\n[`filename:basedir(user_config, \"erlang\")`](`m:filename#user_config`). If none\nof the files exist, a `.erlang.cookie` file is created in the user's home\ndirectory. The UNIX permissions mode of the file is set to octal 400 (read-only\nby user) and its content is a random string. An atom `Cookie` is created from\nthe contents of the file and the cookie of the local node is set to this using\n`erlang:set_cookie(Cookie)`. This sets the default cookie that the local node\nwill use for all other nodes.\n\nThus, groups of users with identical cookie files get Erlang nodes that can\ncommunicate freely since they use the same magic cookie. Users who want to run\nnodes where the cookie files are on different file systems must make certain\nthat their cookie files are identical.\n\nFor a node `Node1` using magic cookie `Cookie` to be able to connect to, and to\naccept a connection from, another node `Node2` that uses a different cookie\n`DiffCookie`, the function `erlang:set_cookie(Node2, DiffCookie)` must first be\ncalled at `Node1`. Distributed systems with multiple home directories (differing\ncookie files) can be handled in this way.\n\n> #### Note {: .info }\n>\n> With this setup `Node1` and `Node2` agree on which cookie to use: `Node1` uses\n> its explicitly configured `DiffCookie` for `Node2`, and `Node2` uses its\n> default cookie `DiffCookie`.\n>\n> You can also use a `DiffCookie` that neither `Node1` nor `Node2` has as its\n> default cookie, if you also call `erlang:set_cookie(Node1, DiffCookie)` in\n> `Node2` before establishing connection\n>\n> Because node names are exchanged during connection setup before cookies are\n> selected, connection setup works regardless of which node that initiates it.\n>\n> Note that to configure `Node1` to use `Node2`'s default cookie when\n> communicating with `Node2`, _and vice versa_ results in a broken configuration\n> (if the cookies are different) because then both nodes use the other node's\n> (differing) cookie.\n\nThe default when a connection is established between two nodes, is to\nimmediately connect all other visible nodes as well. This way, there is always a\nfully connected network. If there are nodes with different cookies, this method\ncan be inappropriate (since it may not be feasible to configure different\ncookies for all possible nodes) and the command-line flag `-connect_all false`\nmust be set, see the [erl](`e:erts:erl_cmd.md`) executable in ERTS.\n\nThe magic cookie of the local node can be retrieved by calling\n`erlang:get_cookie()`.","title":"Security - Distributed Erlang","ref":"distributed.html#security"},{"type":"extras","doc":"Here are some BIFs that are useful for distributed programming:\n\n- [`disconnect_node(Node)`](`erlang:disconnect_node/1`) - Forces the\n  disconnection of a node.\n\n- `erlang:get_cookie/0` - Returns the magic cookie of the current\n  node.\n\n- [`erlang:get_cookie(Node)`](`erlang:get_cookie/1`) - Returns the\n  magic cookie for node `Node`.\n\n- `is_alive/0` - Returns `true` if the runtime system is a node and\n  can connect to other nodes, `false` otherwise.\n\n- [`monitor_node(Node, Bool)`](`erlang:monitor_node/2`) - Monitors the\n  status of `Node`. A message`{nodedown, Node}` is received if the\n  connection to it is lost.\n\n- `node/0` - Returns the name of the current node. Allowed in guards.\n\n- [`node(Arg)`](`node/1`) - Returns the node where `Arg`, a pid,\n  reference, or port, is located.\n\n- `nodes/0` - Returns a list of all visible nodes this node is connected to.\n\n- [`nodes(Arg)`](`nodes/1`) - Depending on `Arg`, this function can\n  return a list not only of visible nodes, but also hidden nodes and\n  previously known nodes, and so on.\n\n- [`erlang:set_cookie(Cookie)`](`erlang:set_cookie/1`) - Sets the\n  magic cookie, `Cookie` to use when connecting all nodes that have no\n  explicit cookie set with `erlang:set_cookie/2`.\n\n- [`erlang:set_cookie(Node, Cookie)`](`erlang:set_cookie/2`) - Sets\n  the magic cookie used when connecting `Node`. If `Node` is the\n  current node, `Cookie` is used when connecting all nodes that have\n  no explicit cookie set with this function.\n\n- [`spawn_link(Node, Fun)`](`spawn_link/2`) - Creates a process at a remote node.\n\n- [`spawn_opt(Node, Fun, Opts)`](`spawn_opt/3`) - Creates a process at\n  a remote node.\n\n- [`spawn_link(Node, Module, Name, Args)`](`erlang:spawn_link/4`) -\n  Creates a process at a remote node.\n\n- [`spawn_opt(Node, Module, Name, Args, Opts)`](`erlang:spawn_opt/5`) - Creates\n  a process at a remote node.\n\n_Table: Distribution BIFs_","title":"Distribution BIFs - Distributed Erlang","ref":"distributed.html#distribution-bifs"},{"type":"extras","doc":"Examples of command-line flags used for distributed programming (for more\ninformation, see the [erl](`e:erts:erl_cmd.md`) executable in ERTS):\n\n| _Command-Line Flag_      | _Description_                                               |\n| ------------------------ | ----------------------------------------------------------- |\n| `-connect_all false`     | Only explicit connection setups are used.                   |\n| `-hidden`                | Makes a node into a hidden node.                            |\n| `-name Name`             | Makes a runtime system into a node, using long node names.  |\n| `-setcookie Cookie`      | Same as calling `erlang:set_cookie(Cookie)`.                |\n| `-setcookie Node Cookie` | Same as calling `erlang:set_cookie(Node, Cookie)`.          |\n| `-sname Name`            | Makes a runtime system into a node, using short node names. |\n\n_Table: Distribution Command-Line Flags_","title":"Distribution Command-Line Flags - Distributed Erlang","ref":"distributed.html#distribution-command-line-flags"},{"type":"extras","doc":"Examples of modules useful for distributed programming in the Kernel application:\n\n| _Module_         | _Description_                                      |\n| ---------------- | -------------------------------------------------- |\n| `m:global`       | A global name registration facility.               |\n| `m:global_group` | Grouping nodes to global name registration groups. |\n| `m:net_adm`      | Various Erlang net administration routines.        |\n| `m:net_kernel`   | Erlang networking kernel.                          |\n\n_Table: Kernel Modules Useful For Distribution._\n\nIn the STDLIB application:\n\n| _Module_ | _Description_                     |\n| -------- | --------------------------------- |\n| `m:peer`  | Start and control of peer nodes. |\n\n_Table: STDLIB Modules Useful For Distribution._","title":"Distribution Modules - Distributed Erlang","ref":"distributed.html#distribution-modules"},{"type":"extras","doc":"<!--\n%CopyrightBegin%\n\nCopyright Ericsson AB 2023-2024. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# Compilation and Code Loading\n\nHow code is compiled and loaded is not a language issue, but is\nsystem-dependent. This section describes compilation and code loading in\nErlang/OTP with references to relevant parts of the documentation.","title":"Compilation and Code Loading","ref":"code_loading.html"},{"type":"extras","doc":"Erlang programs must be _compiled_ to object code. The compiler can generate a\nnew file that contains the object code. The current abstract machine, which runs\nthe object code, is called BEAM, therefore the object files get the suffix\n`.beam`. The compiler can also generate a binary which can be loaded directly.\n\nThe compiler is located in the module `m:compile` in Compiler.\n\n```erlang\ncompile:file(Module)\ncompile:file(Module, Options)\n```\n\nThe Erlang shell understands the command `c(Module)`, which both compiles and\nloads `Module`.\n\nThere is also a module `make`, which provides a set of functions similar to the\nUNIX type Make functions, see module `m:make` in Tools.\n\nThe compiler can also be accessed from the OS prompt using the\n[erl](`e:erts:erl_cmd.md`) executable in ERTS.\n\n```erlang\n% erl -compile Module1...ModuleN\n% erl -make\n```\n\nThe `erlc` program provides way to compile modules from the OS\nshell, see the [erlc](`e:erts:erlc_cmd.md`) executable in ERTS. It\nunderstands a number of flags that can be used to define macros, add search\npaths for include files, and more.\n\n```text\n% erlc   File1.erl...FileN.erl\n```\n\n[](){: #loading }","title":"Compilation - Compilation and Code Loading","ref":"code_loading.html#compilation"},{"type":"extras","doc":"The object code must be _loaded_ into the Erlang runtime system. This is handled\nby the _code server_, see module `m:code` in Kernel.\n\nThe code server loads code according to a code loading strategy, which is either\n_interactive_ (default) or _embedded_. In interactive mode, code is searched for\nin a _code path_ and loaded when first referenced. In embedded mode, code is\nloaded at start-up according to a _boot script_. This is described in\n[System Principles ](`e:system:system_principles.md#code_loading`).","title":"Code Loading - Compilation and Code Loading","ref":"code_loading.html#code-loading"},{"type":"extras","doc":"Erlang supports change of code in a running system. Code replacement is done on\nthe module level.\n\nThe code of a module can exist in two variants in a system: _current_ and _old_.\nWhen a module is loaded into the system for the first time, the code becomes\n'current'. If then a new instance of the module is loaded, the code of the\nprevious instance becomes 'old' and the new instance becomes 'current'.\n\nBoth old and current code is valid, and can be evaluated concurrently. Fully\nqualified function calls always refer to current code. Old code can still be\nevaluated because of processes lingering in the old code.\n\nIf a third instance of the module is loaded, the code server removes (purges)\nthe old code and any processes lingering in it is terminated. Then the third\ninstance becomes 'current' and the previously current code becomes 'old'.\n\nTo change from old code to current code, a process must make a fully qualified\nfunction call.\n\n_Example:_\n\n```erlang\n-module(m).\n-export([loop/0]).\n\nloop() ->\n    receive\n        code_switch ->\n            m:loop();\n        Msg ->\n            ...\n            loop()\n    end.\n```\n\nTo make the process change code, send the message `code_switch` to it. The\nprocess then makes a fully qualified call to `m:loop()` and changes to current\ncode. Notice that `m:loop/0` must be exported.\n\nFor code replacement of funs to work, use the syntax\n`fun Module:FunctionName/Arity`.\n\n[](){: #on_load }","title":"Code Replacement - Compilation and Code Loading","ref":"code_loading.html#code-replacement"},{"type":"extras","doc":"The `-on_load()` directive names a function that is to be run automatically when\na module is loaded.\n\nIts syntax is as follows:\n\n```erlang\n-on_load(Name/0).\n```\n\nIt is not necessary to export the function. It is called in a freshly spawned\nprocess (which terminates as soon as the function returns).\n\nThe function must return `ok` if the module is to become the new current code\nfor the module and become callable.\n\nReturning any other value or generating an exception causes the new code to be\nunloaded. If the return value is not an atom, a warning error report is sent to\nthe error logger.\n\nIf there already is current code for the module, that code will remain current\nand can be called until the `on_load` function has returned. If the `on_load`\nfunction fails, the current code (if any) will remain current. If there is no\ncurrent code for a module, any process that makes an external call to the module\nbefore the `on_load` function has finished will be suspended until the `on_load`\nfunction have finished.\n\n> #### Change {: .info }\n>\n> Before Erlang/OTP 19, if the `on_load` function failed, any previously current\n> code would become old, essentially leaving the system without any working and\n> reachable instance of the module.\n\nIn embedded mode, first all modules are loaded. Then all `on_load` functions are\ncalled. The system is terminated unless all of the `on_load` functions return\n`ok`.\n\n_Example:_\n\n```erlang\n-module(m).\n-on_load(load_my_nifs/0).\n\nload_my_nifs() ->\n    NifPath = ...,    %Set up the path to the NIF library.\n    Info = ...,       %Initialize the Info term\n    erlang:load_nif(NifPath, Info).\n```\n\nIf the call to `erlang:load_nif/2` fails, the module is unloaded and a warning\nreport is sent to the error loader.","title":"Running a Function When a Module is Loaded - Compilation and Code Loading","ref":"code_loading.html#running-a-function-when-a-module-is-loaded"},{"type":"extras","doc":"<!--\n%CopyrightBegin%\n\nCopyright Ericsson AB 2023-2024. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# Ports and Port Drivers\n\nExamples of how to use ports and port drivers are provided in\n[Interoperability Tutorial](`e:system:tutorial.md`).\nFor information about the BIFs mentioned, see module `m:erlang` in\nERTS.","title":"Ports and Port Drivers","ref":"ports.html"},{"type":"extras","doc":"_Ports_ provide the basic mechanism for communication with the external world,\nfrom Erlang's point of view. They provide a byte-oriented interface to an\nexternal program. When a port has been created, Erlang can communicate with it\nby sending and receiving lists of bytes, including binaries.\n\nThe Erlang process creating a port is said to be the _port owner_, or the\n_connected process_ of the port. All communication to and from the port must go\nthrough the port owner. If the port owner terminates, so does the port (and the\nexternal program, if it is written correctly).\n\nThe external program resides in another OS process. By default, it reads from\nstandard input (file descriptor 0) and writes to standard output (file\ndescriptor 1). The external program is to terminate when the port is closed.","title":"Ports - Ports and Port Drivers","ref":"ports.html#ports"},{"type":"extras","doc":"It is possible to write a driver in C according to certain principles and\ndynamically link it to the Erlang runtime system. The linked-in driver looks\nlike a port from the Erlang programmer's point of view and is called a _port\ndriver_.\n\n> #### Warning {: .warning }\n>\n> An erroneous port driver causes the entire Erlang runtime system to leak\n> memory, hang or crash.\n\nFor information about port drivers, see:\n\n- [erl_driver](`e:erts:erl_driver.md`) in ERTS\n- [driver_entry](`e:erts:driver_entry.md`) in ERTS\n- [`erl_ddll`](`m:erl_ddll`) in Kernel","title":"Port Drivers - Ports and Port Drivers","ref":"ports.html#port-drivers"},{"type":"extras","doc":"To create a port, call [`open_port(PortName,\nPortSettings)`](`erlang:open_port/2`). It returns a port identifier `Port`\nas the result of opening the new port. Messages can be sent to\nand received from a port identifier, just like a PID. Port\nidentifiers can also be linked to using [`link/1`](`link/1`), or\nregistered under a name using [`register/2`](`register/2`).\n\n`PortName` is usually a tuple `{spawn,Command}`, where the string `Command` is\nthe name of the external program. The external program runs outside the Erlang\nworkspace, unless a port driver with the name `Command` is found. If `Command`\nis found, that driver is started.\n\n`PortSettings` is a list of settings (options) for the port. The list typically\ncontains at least a tuple `{packet,N}`, which specifies that data sent between\nthe port and the external program are preceded by an N-byte length indicator.\nValid values for N are 1, 2, or 4. If binaries are to be used instead of lists\nof bytes, the option `binary` must be included.\n\nThe port owner `Pid` can communicate with the port `Port` by sending and\nreceiving messages. (In fact, any process can send the messages to the port, but\nthe port owner must be identified in the message).\n\nMessages sent to ports are delivered asynchronously.\n\n> #### Change {: .info }\n>\n> Before Erlang/OTP 16, messages to ports were delivered synchronously.\n\nIn the following examples, `Data` must be an I/O list. An I/O list is\na binary or a (possibly deep) list of binaries or integers in the\nrange 0 through 255.\n\nThe following messages can be sent to a port:\n\n- **`{Pid,{command,Data}}`** - Sends `Data` to the port.\n\n- **`{Pid,close}`** - Closes the port. Unless the port is already\n    closed, the port replies with `{Port,closed}` when all buffers\n    have been flushed and the port really closes.\n\n- **`{Pid,{connect,NewPid}}`** - Sets the port owner of `Port` to\n    `NewPid`. Unless the port is already closed, the port replies\n    with`{Port,connected}` to the old port owner. Note that the old\n    port owner is still linked to the port, but the new port owner is\n    not.\n\nHere follows the possible messages that can be received from a port. They\nare sent to the process that owns the port:\n\n- **`{Port,{data,Data}}`** - `Data` is received from the external program.\n\n- **`{Port,closed}`** - Reply to `Port ! {Pid,close}`.\n\n- **`{Port,connected}`** - Reply to `Port ! {Pid,{connect,NewPid}}`.\n\n- **`{'EXIT',Port,Reason}`** - If the port has terminated for some\n    reason.\n\nInstead of sending and receiving messages, there are also a number of BIFs that\ncan be used:\n\n- [`port_command(Port, Data)`](`port_command/2`) - Sends `Data` to the\n  port.\n\n- [`port_close(Port)`](`port_close/1`) - Closes the port.\n\n- [`port_connect(Port, NewPid)`](`port_connect/2`) - Sets the port\n  owner of `Port`to `NewPid`. The old port owner `Pid` stays linked to\n  the port and must call [`unlink(Port)`](`unlink/1`) if this is not\n  desired.\n\n- [`erlang:port_info(Port, Item)`](`erlang:port_info/2`) - Returns\n  information as specified by `Item`.\n\n- [`erlang:ports()`](`erlang:ports/0`) - Returns a list of all ports\n  on the current node.\n\nThere also exist a few additional BIFs that apply to port drivers:\n\n- [`port_control/3`](`port_control/3`)\n- `erlang:port_call/3`.","title":"Port BIFs - Ports and Port Drivers","ref":"ports.html#port-bifs"},{"type":"extras","doc":"<!--\n%CopyrightBegin%\n\nCopyright Ericsson AB 2023-2024. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# Introduction","title":"Introduction","ref":"efficiency_guide.html"},{"type":"extras","doc":"> \"Premature optimization is the root of all evil\" (D.E. Knuth)\n\nEfficient code can be well-structured and clean, based on a sound\noverall architecture and sound algorithms. Efficient code can be\nhighly implementation-dependent code that bypasses documented\ninterfaces and takes advantage of obscure quirks.\n\nIdeally, your code only contains the first type of efficient code. If that turns\nout to be too slow, profile the application to find out where the performance\nbottlenecks are and optimize only the bottlenecks. Let other code stay as clean\nas possible.\n\nThis Efficiency Guide cannot really teach you how to write efficient code. It\ncan give you a few pointers about what to avoid and what to use, and some\nunderstanding of how certain language features are implemented. This guide does\nnot include general tips about optimization that works in any language, such as\nmoving common calculations out of loops.","title":"Purpose - Introduction","ref":"efficiency_guide.html#purpose"},{"type":"extras","doc":"It is assumed that you are familiar with the Erlang programming language and the\nOTP concepts.","title":"Prerequisites - Introduction","ref":"efficiency_guide.html#prerequisites"},{"type":"extras","doc":"<!--\n%CopyrightBegin%\n\nCopyright Ericsson AB 2023-2024. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# Common Caveats\n\nThis section lists a few constructs to watch out for.","title":"Common Caveats","ref":"commoncaveats.html"},{"type":"extras","doc":"The `++` operator copies its left-hand side operand. That is clearly\nseen if we do our own implementation in Erlang:\n\n```erlang\nmy_plus_plus([H|T], Tail) ->\n    [H|my_plus_plus(T, Tail)];\nmy_plus_plus([], Tail) ->\n    Tail.\n```\n\nWe must be careful how we use `++` in a loop. First is how not to use it:\n\n**DO NOT**\n\n```erlang\nnaive_reverse([H|T]) ->\n    naive_reverse(T) ++ [H];\nnaive_reverse([]) ->\n    [].\n```\n\nAs the `++` operator copies its left-hand side operand, the growing\nresult is copied repeatedly, leading to quadratic complexity.\n\nOn the other hand, using `++` in loop like this is perfectly fine:\n\n**OK**\n\n```erlang\nnaive_but_ok_reverse(List) ->\n    naive_but_ok_reverse(List, []).\n\nnaive_but_ok_reverse([H|T], Acc) ->\n    naive_but_ok_reverse(T, [H] ++ Acc);\nnaive_but_ok_reverse([], Acc) ->\n    Acc.\n```\n\nEach list element is copied only once. The growing result `Acc` is the right-hand\nside operand, which it is _not_ copied.\n\nExperienced Erlang programmers would probably write as follows:\n\n**DO**\n\n```erlang\nvanilla_reverse([H|T], Acc) ->\n    vanilla_reverse(T, [H|Acc]);\nvanilla_reverse([], Acc) ->\n    Acc.\n```\n\nIn principle, this is slightly more efficient because the list element `[H]`\nis not built before being copied and discarded. In practice, the compiler\nrewrites `[H] ++ Acc` to `[H|Acc]`.","title":"Operator `++` - Common Caveats","ref":"commoncaveats.html#operator"},{"type":"extras","doc":"Creating timers using `erlang:send_after/3` and `erlang:start_timer/3`, is more\nefficient than using the timers provided by the `m:timer` module in STDLIB.\n\nThe `timer` module uses a separate process to manage the\ntimers. Before Erlang/OTP 25, this management overhead was substantial\nand increasing with the number of timers, especially when they were\nshort-lived, so the timer server process could easily become\noverloaded and unresponsive. In Erlang/OTP 25, the timer module was\nimproved by removing most of the management overhead and the resulting\nperformance penalty. Still, the timer server remains a single process,\nand it may at some point become a bottleneck of an application.\n\nThe functions in the `timer` module that do not manage timers (such as\n`timer:tc/3` or `timer:sleep/1`), do not call the timer-server process and are\ntherefore harmless.","title":"Timer Module - Common Caveats","ref":"commoncaveats.html#timer-module"},{"type":"extras","doc":"When spawning a new process using a fun, one can accidentally copy more data to\nthe process than intended. For example:\n\n**DO NOT**\n\n```erlang\naccidental1(State) ->\n    spawn(fun() ->\n                  io:format(\"~p\\n\", [State#state.info])\n          end).\n```\n\nThe code in the fun will extract one element from the record and print it. The\nrest of the `state` record is not used. However, when the [`spawn/1`](`spawn/1`)\nfunction is executed, the entire record is copied to the newly created process.\n\nThe same kind of problem can happen with a map:\n\n**DO NOT**\n\n```erlang\naccidental2(State) ->\n    spawn(fun() ->\n                  io:format(\"~p\\n\", [map_get(info, State)])\n          end).\n```\n\nIn the following example (part of a module implementing the `m:gen_server`\nbehavior) the created fun is sent to another process:\n\n**DO NOT**\n\n```erlang\nhandle_call(give_me_a_fun, _From, State) ->\n    Fun = fun() -> State#state.size =:= 42 end,\n    {reply, Fun, State}.\n```\n\nHow bad that unnecessary copy is depends on the contents of the record or the\nmap.\n\nFor example, if the `state` record is initialized like this:\n\n```erlang\ninit1() ->\n    #state{data=lists:seq(1, 10000)}.\n```\n\na list with 10000 elements (or about 20000 heap words) will be copied to the\nnewly created process.\n\nAn unnecessary copy of 10000 element list can be bad enough, but it can get even\nworse if the `state` record contains _shared subterms_. Here is a simple example\nof a term with a shared subterm:\n\n```erlang\n{SubTerm, SubTerm}\n```\n\nWhen a term is copied to another process, sharing of subterms will be lost and\nthe copied term can be many times larger than the original term. For example:\n\n```erlang\ninit2() ->\n    SharedSubTerms = lists:foldl(fun(_, A) -> [A|A] end, [0], lists:seq(1, 15)),\n    #state{data=Shared}.\n```\n\nIn the process that calls `init2/0`, the size of the `data` field in the `state`\nrecord will be 32 heap words. When the record is copied to the newly created\nprocess, sharing will be lost and the size of the copied `data` field will be\n131070 heap words. More details about\n[loss off sharing](eff_guide_processes.md#loss-of-sharing) are found in a later\nsection.\n\nTo avoid the problem, outside of the fun extract only the fields of the record\nthat are actually used:\n\n**DO**\n\n```erlang\nfixed_accidental1(State) ->\n    Info = State#state.info,\n    spawn(fun() ->\n                  io:format(\"~p\\n\", [Info])\n          end).\n```\n\nSimilarly, outside of the fun extract only the map elements that are actually\nused:\n\n**DO**\n\n```erlang\nfixed_accidental2(State) ->\n    Info = map_get(info, State),\n    spawn(fun() ->\n                  io:format(\"~p\\n\", [Info])\n          end).\n```","title":"Accidental Copying and Loss of Sharing - Common Caveats","ref":"commoncaveats.html#accidental-copying-and-loss-of-sharing"},{"type":"extras","doc":"Atoms are not garbage-collected. Once an atom is created, it is never removed.\nThe emulator terminates if the limit for the number of atoms (1,048,576 by\ndefault) is reached.\n\nTherefore, converting arbitrary input strings to atoms can be dangerous in a\nsystem that runs continuously. If only certain well-defined atoms are allowed as\ninput, [`list_to_existing_atom/1`](`erlang:list_to_existing_atom/1`) or\n[`binary_to_existing_atom/1`](`erlang:binary_to_existing_atom/1`) can be used\nto guard against a denial-of-service attack. (All atoms that are allowed must\nhave been created earlier, for example, by using all of them in a module\nand loading that module.)\n\nUsing [`list_to_atom/1`](`list_to_atom/1`) to construct an atom that\nis passed to [`apply/3`](`apply/3`) is quite expensive.\n\n**DO NOT**\n\n```erlang\napply(list_to_atom(\"some_prefix\"++Var), foo, Args)\n```","title":"list_to_atom/1 - Common Caveats","ref":"commoncaveats.html#list_to_atom-1"},{"type":"extras","doc":"The time for calculating the length of a list is proportional to the length of\nthe list, as opposed to [`tuple_size/1`](`tuple_size/1`),\n[`byte_size/1`](`byte_size/1`), and [`bit_size/1`](`bit_size/1`), which all\nexecute in constant time.\n\nNormally, there is no need to worry about the speed of [`length/1`](`length/1`),\nbecause it is efficiently implemented in C. In time-critical code, you might\nwant to avoid it if the input list could potentially be very long.\n\nSome uses of [`length/1`](`length/1`) can be replaced by matching. For example,\nthe following code:\n\n```erlang\nfoo(L) when length(L) >= 3 ->\n    ...\n```\n\ncan be rewritten to:\n\n```erlang\nfoo([_,_,_|_]=L) ->\n   ...\n```\n\nOne slight difference is that [`length(L)`](`length/1`) fails if `L` is an\nimproper list, while the pattern in the second code fragment accepts an improper\nlist.","title":"length/1 - Common Caveats","ref":"commoncaveats.html#length-1"},{"type":"extras","doc":"[`setelement/3`](`erlang:setelement/3`) copies the tuple it modifies. Therefore,\nupdating a tuple in a loop using [`setelement/3`](`setelement/3`) creates a new\ncopy of the tuple every time.\n\nThere is one exception to the rule that the tuple is copied. If the compiler\nclearly can see that destructively updating the tuple would give the same result\nas if the tuple was copied, the call to [`setelement/3`](`setelement/3`) is\nreplaced with a special destructive `setelement` instruction. In the following\ncode sequence, the first [`setelement/3`](`setelement/3`) call copies the tuple\nand modifies the ninth element:\n\n```erlang\nmultiple_setelement(T0) when tuple_size(T0) =:= 9 ->\n    T1 = setelement(9, T0, bar),\n    T2 = setelement(7, T1, foobar),\n    setelement(5, T2, new_value).\n```\n\nThe two following [`setelement/3`](`setelement/3`) calls modify the tuple in\nplace.\n\nFor the optimization to be applied, _all_ the following conditions must be true:\n\n- The tuple argument must be known to be a tuple of a known size.\n- The indices must be integer literals, not variables or expressions.\n- The indices must be given in descending order.\n- There must be no calls to another function in between the calls to\n  [`setelement/3`](`setelement/3`).\n- The tuple returned from one [`setelement/3`](`setelement/3`) call must only be\n  used in the subsequent call to [`setelement/3`](`setelement/3`).\n\nIf the code cannot be structured as in the `multiple_setelement/1` example, the\nbest way to modify multiple elements in a large tuple is to convert the tuple to\na list, modify the list, and convert it back to a tuple.","title":"setelement/3 - Common Caveats","ref":"commoncaveats.html#setelement-3"},{"type":"extras","doc":"[`size/1`](`size/1`) returns the size for both tuples and binaries.\n\nUsing the BIFs [`tuple_size/1`](`tuple_size/1`) and\n[`byte_size/1`](`byte_size/1`) gives the compiler and the runtime system more\nopportunities for optimization. Another advantage is that those BIFs give Dialyzer\nmore type information.","title":"size/1 - Common Caveats","ref":"commoncaveats.html#size-1"},{"type":"extras","doc":"Rewriting Erlang code to a NIF to make it faster should be seen as a last\nresort.\n\nDoing too much work in each NIF call will\n[degrade responsiveness of the VM](`e:erts:erl_nif.md#WARNING`). Doing too\nlittle work can mean that the gain of the faster processing in the NIF is eaten\nup by the overhead of calling the NIF and checking the arguments.\n\nBe sure to read about [Long-running NIFs](`e:erts:erl_nif.md#lengthy_work`)\nbefore writing a NIF.","title":"Using NIFs - Common Caveats","ref":"commoncaveats.html#using-nifs"},{"type":"extras","doc":"<!--\n%CopyrightBegin%\n\nCopyright Ericsson AB 2023-2024. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# Constructing and Matching Binaries\n\nThis section gives a few examples on how to handle binaries in an efficient way.\nThe sections that follow take an in-depth look at how binaries are implemented\nand how to best take advantages of the optimizations done by the compiler and\nruntime system.\n\nBinaries can be efficiently _built_ in the following way:\n\n**DO**\n\n```erlang\nmy_list_to_binary(List) ->\n    my_list_to_binary(List, <<>>).\n\nmy_list_to_binary([H|T], Acc) ->\n    my_list_to_binary(T, < >);\nmy_list_to_binary([], Acc) ->\n    Acc.\n```\n\nAppending data to a binary as in the example is efficient because it is\nspecially optimized by the runtime system to avoid copying the `Acc` binary\nevery time.\n\nPrepending data to a binary in a loop is not efficient:\n\n**DO NOT**\n\n```erlang\nrev_list_to_binary(List) ->\n    rev_list_to_binary(List, <<>>).\n\nrev_list_to_binary([H|T], Acc) ->\n    rev_list_to_binary(T, < >);\nrev_list_to_binary([], Acc) ->\n    Acc.\n```\n\nThis is not efficient for long lists because the `Acc` binary is copied every\ntime. One way to make the function more efficient is like this:\n\n**DO NOT**\n\n```erlang\nrev_list_to_binary(List) ->\n    rev_list_to_binary(lists:reverse(List), <<>>).\n\nrev_list_to_binary([H|T], Acc) ->\n    rev_list_to_binary(T, < >);\nrev_list_to_binary([], Acc) ->\n    Acc.\n```\n\nAnother way to avoid copying the binary each time is like this:\n\n**DO**\n\n```erlang\nrev_list_to_binary([H|T]) ->\n    RevTail = rev_list_to_binary(T),\n    < >;\nrev_list_to_binary([]) ->\n    <<>>.\n```\n\nNote that in each of the **DO** examples, the binary to be appended to is always\ngiven as the first segment.\n\nBinaries can be efficiently _matched_ in the following way:\n\n**DO**\n\n```erlang\nmy_binary_to_list(< >) ->\n    [H|my_binary_to_list(T)];\nmy_binary_to_list(<<>>) -> [].\n```","title":"Constructing and Matching Binaries","ref":"binaryhandling.html"},{"type":"extras","doc":"Internally, binaries and bitstrings are implemented in the same way. In this\nsection, they are called _binaries_ because that is what they are called in the\nemulator source code.\n\nFour types of binary objects are available internally:\n\n- Two are containers for binary data and are called:\n\n  - _Refc binaries_ (short for _reference-counted binaries_)\n  - _Heap binaries_\n\n- Two are merely references to a part of a binary and are called:\n\n  - _sub binaries_\n  - _match contexts_\n\n> #### Change {: .info }\n>\n> In Erlang/OTP 27, the handling of binaries and bitstrings were\n> rewritten. To fully leverage those changes in the run-time system,\n> the compiler needs to be updated, which is planned for a future\n> release.\n>\n> Since, practically speaking, not much have changed from an efficiency\n> and optimization perspective, the following description has not yet\n> been updated to describe the implementation in Erlang/OTP 27.\n\n[](){: #refc_binary }","title":"How Binaries are Implemented - Constructing and Matching Binaries","ref":"binaryhandling.html#how-binaries-are-implemented"},{"type":"extras","doc":"Refc binaries consist of two parts:\n\n- An object stored on the process heap, called a _ProcBin_\n- The binary object itself, stored outside all process heaps\n\nThe binary object can be referenced by any number of ProcBins from any number of\nprocesses. The object contains a reference counter to keep track of the number\nof references, so that it can be removed when the last reference disappears.\n\nAll ProcBin objects in a process are part of a linked list, so that the garbage\ncollector can keep track of them and decrement the reference counters in the\nbinary when a ProcBin disappears.\n\n[](){: #heap_binary }","title":"Refc Binaries - Constructing and Matching Binaries","ref":"binaryhandling.html#refc-binaries"},{"type":"extras","doc":"Heap binaries are small binaries, up to 64 bytes, and are stored directly on the\nprocess heap. They are copied when the process is garbage-collected and when\nthey are sent as a message. They do not require any special handling by the\ngarbage collector.","title":"Heap Binaries - Constructing and Matching Binaries","ref":"binaryhandling.html#heap-binaries"},{"type":"extras","doc":"The reference objects _sub binaries_ and _match contexts_ can reference part of\na refc binary or heap binary.\n\n[](){: #sub_binary } A _sub binary_ is created by\n[`split_binary/2`](`split_binary/2`) and when a binary is matched out in a\nbinary pattern. A sub binary is a reference into a part of another binary (refc\nor heap binary, but never into another sub binary). Therefore, matching out a\nbinary is relatively cheap because the actual binary data is never copied.\n\n[](){: #match_context }","title":"Sub Binaries - Constructing and Matching Binaries","ref":"binaryhandling.html#sub-binaries"},{"type":"extras","doc":"A _match context_ is similar to a sub binary, but is optimized for binary\nmatching. For example, it contains a direct pointer to the binary data. For each\nfield that is matched out of a binary, the position in the match context is\nincremented.\n\nThe compiler tries to avoid generating code that creates a sub binary, only to\nshortly afterwards create a new match context and discard the sub binary.\nInstead of creating a sub binary, the match context is kept.\n\nThe compiler can only do this optimization if it knows that the match context\nwill not be shared. If it would be shared, the functional properties (also\ncalled referential transparency) of Erlang would break.","title":"Match Context - Constructing and Matching Binaries","ref":"binaryhandling.html#match-context"},{"type":"extras","doc":"Appending to a binary or bitstring in the following way is specially optimized\nto avoid copying the binary:\n\n```erlang\n< >\n%% - OR -\n< >\n```\n\nThis optimization is applied by the runtime system in a way that makes it\neffective in most circumstances (for exceptions, see\n[Circumstances That Force Copying](binaryhandling.md#forced_copying)). The\noptimization in its basic form does not need any help from the compiler.\nHowever, the compiler add hints to the runtime system when it is safe to apply\nthe optimization in a more efficient way.\n\n> #### Change {: .info }\n>\n> The compiler support for making the optimization more efficient was added in\n> Erlang/OTP 26.\n\nTo explain how the basic optimization works, let us examine the following code\nline by line:\n\n```erlang\nBin0 = <<0>>,                    %% 1\nBin1 = < >,    %% 2\nBin2 = < >,    %% 3\nBin3 = < >,    %% 4\nBin4 = < >,       %% 5 !!!\n{Bin4,Bin3}                      %% 6\n```\n\n- Line 1 (marked with the `%% 1` comment), assigns a\n  [heap binary](binaryhandling.md#heap_binary) to the `Bin0` variable.\n- Line 2 is an append operation. As `Bin0` has not been involved in an append\n  operation, a new [refc binary](binaryhandling.md#refc_binary) is created and\n  the contents of `Bin0` is copied into it. The _ProcBin_ part of the refc\n  binary has its size set to the size of the data stored in the binary, while\n  the binary object has extra space allocated. The size of the binary object is\n  either twice the size of `Bin1` or 256, whichever is larger. In this case it\n  is 256.\n- Line 3 is more interesting. `Bin1` _has_ been used in an append operation, and\n  it has 252 bytes of unused storage at the end, so the 3 new bytes are stored\n  there.\n- Line 4. The same applies here. There are 249 bytes left, so there is no\n  problem storing another 3 bytes.\n- Line 5. Here something _interesting_ happens. Notice that the result is not\n  appended to the previous result in `Bin3`, but to `Bin1`. It is expected that\n  `Bin4` will be assigned the value `<<0,1,2,3,17>>`. It is also expected that\n  `Bin3` will retain its value (`<<0,1,2,3,4,5,6,7,8,9>>`). Clearly, the runtime\n  system cannot write byte `17` into the binary, because that would change the\n  value of `Bin3` to `<<0,1,2,3,4,17,6,7,8,9>>`.\n\n  To ensure that the value of `Bin3` is retained, the runtime system _copies_\n  the contents of `Bin1` to a new refc binary before storing the `17` byte.\n\n  Here is not explained how the runtime system can know that it is not allowed\n  to write into `Bin1`; it is left as an exercise to the curious reader to\n  figure out how it is done by reading the emulator sources, primarily\n  `erl_bits.c`.","title":"Constructing Binaries - Constructing and Matching Binaries","ref":"binaryhandling.html#constructing-binaries"},{"type":"extras","doc":"> #### Change {: .info }\n>\n> The compiler support for making the optimization more efficient was added in\n> Erlang/OTP 26.\n\nIn the example in the previous section, it was shown that the runtime system can\nhandle an append operation to a heap binary by copying it to a refc binary (line\n2), and also handle an append operation to a previous version of the binary by\ncopying it (line 5). The support for doing that does not come for free. For\nexample, to make it possible to know when it is necessary to copy the binary,\nfor every append operation, the runtime system must create a sub binary.\n\nWhen the compiler can determine that none of those situations need to be handled\nand that the append operation cannot possibly fail, the compiler generates code\nthat causes the runtime system to apply a more efficient variant of the\noptimization.\n\n**Example:**\n\n```erlang\n-module(repack).\n-export([repack/1]).\n\nrepack(Bin) when is_binary(Bin) ->\n    repack(Bin, <<>>).\n\nrepack(< >, Result) ->\n    repack(T, < >);\nrepack(<<>>, Result) ->\n    Result.\n```\n\nThe `repack/2` function only keeps a single version of the binary, so there is\nnever any need to copy the binary. The compiler rewrites the creation of the\nempty binary in `repack/1` to instead create a refc binary with 256 bytes\nalready reserved; thus, the append operation in `repack/2` never needs to handle\na binary not prepared for appending.\n\n[](){: #forced_copying }","title":"Compiler Support For Constructing Binaries - Constructing and Matching Binaries","ref":"binaryhandling.html#compiler-support-for-constructing-binaries"},{"type":"extras","doc":"The optimization of the binary append operation requires that there is a\n_single_ ProcBin and a _single reference_ to the ProcBin for the binary. The\nreason is that the binary object can be moved (reallocated) during an append\noperation, and when that happens, the pointer in the ProcBin must be updated. If\nthere would be more than one ProcBin pointing to the binary object, it would not\nbe possible to find and update all of them.\n\nTherefore, certain operations on a binary mark it so that any future append\noperation will be forced to copy the binary. In most cases, the binary object\nwill be shrunk at the same time to reclaim the extra space allocated for\ngrowing.\n\nWhen appending to a binary as follows, only the binary returned from the latest\nappend operation will support further cheap append operations:\n\n```erlang\nBin = < >\n```\n\nIn the code fragment in the beginning of this section, appending to `Bin` will\nbe cheap, while appending to `Bin0` will force the creation of a new binary and\ncopying of the contents of `Bin0`.\n\nIf a binary is sent as a message to a process or port, the binary will be shrunk\nand any further append operation will copy the binary data into a new binary.\nFor example, in the following code fragment `Bin1` will be copied in the third\nline:\n\n```erlang\nBin1 = < >,\nPortOrPid ! Bin1,\nBin = < >  %% Bin1 will be COPIED\n```\n\nThe same happens if you insert a binary into an Ets table, send it to a port\nusing `erlang:port_command/2`, or pass it to\n[enif_inspect_binary](`e:erts:erl_nif.md#enif_inspect_binary`) in a NIF.\n\nMatching a binary will also cause it to shrink and the next append operation\nwill copy the binary data:\n\n```erlang\nBin1 = < >,\n< > = Bin1,\nBin = < >  %% Bin1 will be COPIED\n```\n\nThe reason is that a [match context](binaryhandling.md#match_context) contains a\ndirect pointer to the binary data.\n\nIf a process simply keeps binaries (either in \"loop data\" or in the process\ndictionary), the garbage collector can eventually shrink the binaries. If only\none such binary is kept, it will not be shrunk. If the process later appends to\na binary that has been shrunk, the binary object will be reallocated to make\nplace for the data to be appended.","title":"Circumstances That Force Copying - Constructing and Matching Binaries","ref":"binaryhandling.html#circumstances-that-force-copying"},{"type":"extras","doc":"Let us revisit the example in the beginning of the previous section:\n\n**DO**\n\n```erlang\nmy_binary_to_list(< >) ->\n    [H|my_binary_to_list(T)];\nmy_binary_to_list(<<>>) -> [].\n```\n\nThe first time `my_binary_to_list/1` is called, a\n[match context](binaryhandling.md#match_context) is created. The match context\npoints to the first byte of the binary. 1 byte is matched out and the match\ncontext is updated to point to the second byte in the binary.\n\nAt this point it would make sense to create a\n[sub binary](binaryhandling.md#sub_binary), but in this particular example the\ncompiler sees that there will soon be a call to a function (in this case, to\n`my_binary_to_list/1` itself) that immediately will create a new match context\nand discard the sub binary.\n\nTherefore `my_binary_to_list/1` calls itself with the match context instead of\nwith a sub binary. The instruction that initializes the matching operation\nbasically does nothing when it sees that it was passed a match context instead\nof a binary.\n\nWhen the end of the binary is reached and the second clause matches, the match\ncontext will simply be discarded (removed in the next garbage collection, as\nthere is no longer any reference to it).\n\nTo summarize, `my_binary_to_list/1` only needs to create _one_ match context and\nno sub binaries.\n\nNotice that the match context in `my_binary_to_list/1` was discarded when the\nentire binary had been traversed. What happens if the iteration stops before it\nhas reached the end of the binary? Will the optimization still work?\n\n```erlang\nafter_zero(<<0,T/binary>>) ->\n    T;\nafter_zero(<<_,T/binary>>) ->\n    after_zero(T);\nafter_zero(<<>>) ->\n    <<>>.\n```\n\nYes, it will. The compiler will remove the building of the sub binary in the\nsecond clause:\n\n```erlang\n...\nafter_zero(<<_,T/binary>>) ->\n    after_zero(T);\n...\n```\n\nBut it will generate code that builds a sub binary in the first clause:\n\n```erlang\nafter_zero(<<0,T/binary>>) ->\n    T;\n...\n```\n\nTherefore, `after_zero/1` builds one match context and one sub binary (assuming\nit is passed a binary that contains a zero byte).\n\nCode like the following will also be optimized:\n\n```erlang\nall_but_zeroes_to_list(Buffer, Acc, 0) ->\n    {lists:reverse(Acc),Buffer};\nall_but_zeroes_to_list(<<0,T/binary>>, Acc, Remaining) ->\n    all_but_zeroes_to_list(T, Acc, Remaining-1);\nall_but_zeroes_to_list(< >, Acc, Remaining) ->\n    all_but_zeroes_to_list(T, [Byte|Acc], Remaining-1).\n```\n\nThe compiler removes building of sub binaries in the second and third clauses,\nand it adds an instruction to the first clause that converts `Buffer` from a\nmatch context to a sub binary (or do nothing if `Buffer` is a binary already).\n\nBut in more complicated code, how can one know whether the optimization is\napplied or not?\n\n[](){: #bin_opt_info }","title":"Matching Binaries - Constructing and Matching Binaries","ref":"binaryhandling.html#matching-binaries"},{"type":"extras","doc":"Use the `bin_opt_info` option to have the compiler print a lot of information\nabout binary optimizations. It can be given either to the compiler or `erlc`:\n\n```erlang\nerlc +bin_opt_info Mod.erl\n```\n\nor passed through an environment variable:\n\n```erlang\nexport ERL_COMPILER_OPTIONS=bin_opt_info\n```\n\nNotice that the `bin_opt_info` is not meant to be a permanent option added to\nyour `Makefile`s, because all messages that it generates cannot be eliminated.\nTherefore, passing the option through the environment is in most cases the most\npractical approach.\n\nThe warnings look as follows:\n\n```erlang\n./efficiency_guide.erl:60: Warning: NOT OPTIMIZED: binary is returned from the function\n./efficiency_guide.erl:62: Warning: OPTIMIZED: match context reused\n```\n\nTo make it clearer exactly what code the warnings refer to, the warnings in the\nfollowing examples are inserted as comments after the clause they refer to, for\nexample:\n\n```erlang\nafter_zero(<<0,T/binary>>) ->\n         %% BINARY CREATED: binary is returned from the function\n    T;\nafter_zero(<<_,T/binary>>) ->\n         %% OPTIMIZED: match context reused\n    after_zero(T);\nafter_zero(<<>>) ->\n    <<>>.\n```\n\nThe warning for the first clause says that the creation of a sub binary cannot\nbe delayed, because it will be returned. The warning for the second clause says\nthat a sub binary will not be created (yet).","title":"Option bin_opt_info - Constructing and Matching Binaries","ref":"binaryhandling.html#option-bin_opt_info"},{"type":"extras","doc":"The compiler figures out if a variable is unused. The same code is generated for\neach of the following functions:\n\n```erlang\ncount1(<<_,T/binary>>, Count) -> count1(T, Count+1);\ncount1(<<>>, Count) -> Count.\n\ncount2(< >, Count) -> count2(T, Count+1);\ncount2(<<>>, Count) -> Count.\n\ncount3(<<_H,T/binary>>, Count) -> count3(T, Count+1);\ncount3(<<>>, Count) -> Count.\n```\n\nIn each iteration, the first 8 bits in the binary will be skipped, not matched\nout.","title":"Unused Variables - Constructing and Matching Binaries","ref":"binaryhandling.html#unused-variables"},{"type":"extras","doc":"<!--\n%CopyrightBegin%\n\nCopyright Ericsson AB 2023-2024. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# Maps\n\nThis guide to using maps efficiently starts with a brief section on the choice\nbetween records or maps, followed by three sections giving concrete (but brief)\nadvice on using maps as an alternative to records, as dictionaries, and as sets.\nThe remaining sections dig deeper, looking at how maps are implemented, the map\nsyntax, and finally the functions in the `m:maps` module.\n\n[](){: #terminology }\n\nTerminology used in this chapter:\n\n- A map with at most 32 elements will informally be called a _small map_.\n- A map with more than 32 elements will informally be called a _large map_.","title":"Maps","ref":"maps.html"},{"type":"extras","doc":"If the advice in this chapter is followed, the performance of records compared\nto using small maps instead of records is expected to be similar. Therefore, the\nchoice between records and maps should be based on the desired properties of the\ndata structure and not performance.\n\nThe advantages of records compared to maps are:\n\n- If the name of a record field is misspelled, there will be a compilation\n  error. If a map key is misspelled, the compiler will give no warning and\n  program will fail in some way when it is run.\n- Records will use slightly less memory than maps, and performance is expected\n  to be _slightly_ better than maps in most circumstances.\n\nThe disadvantage of records compared to maps is that if a new field is added to\na record, all code that uses that record must be recompiled. Because of that, it\nis recommended to only use records within a unit of code that can easily be\nrecompiled all at once, for example within a single application or single\nmodule.","title":"Maps or Records? - Maps","ref":"maps.html#maps-or-records"},{"type":"extras","doc":"- Use the map syntax instead of the functions in the `m:maps` module.\n- Avoid having more than 32 elements in the map. As soon as there are more than\n  32 elements in the map, it will require more memory and keys can no longer be\n  shared with other instances of the map.\n- When creating a new map, always create it with all keys that will ever be\n  used. To maximize sharing of keys (thus minimizing memory use), create a\n  single function that constructs the map using the map syntax and always use\n  it.\n- Always update the map using the `:=` operator (that is, requiring that an\n  element with that key already exists). The `:=` operator is slightly more\n  efficient, and it helps catching mispellings of keys.\n- Whenever possible, match multiple map elements at once.\n- Whenever possible, update multiple map elements at once.\n- Avoid default values and the `maps:get/3` function. If there are default\n  values, sharing of keys between different instances of the map will be less\n  effective, and it is not possible to match multiple elements having default\n  values in one go.\n- To avoid having to deal with a map that may lack some keys, `maps:merge/2` can\n  efficiently add multiple default values. For example:\n\n  ```erlang\n  DefaultMap = #{shoe_size => 42, editor => emacs},\n  MapWithDefaultsApplied = maps:merge(DefaultMap, OtherMap)\n  ```","title":"Using Maps as an Alternative to Records - Maps","ref":"maps.html#using-maps-as-an-alternative-to-records"},{"type":"extras","doc":"Using a map as a dictionary implies the following usage pattern:\n\n- Keys are usually variables not known at compile-time.\n- There can be any number of elements in the map.\n- Usually, no more than one element is looked up or updated at once.\n\nGiven that usage pattern, the difference in performance between using the map\nsyntax and the maps module is usually small. Therefore, which one to use is\nmostly a matter of taste.\n\nMaps are usually the most efficient dictionary data structure, with a few\nexceptions:\n\n- If it is necessary to frequently convert a dictionary to a sorted list, or\n  from a sorted list to a dictionary, using `m:gb_trees` can be a better choice.\n- If all keys are non-negative integers, the `m:array` module can be a better\n  choice.","title":"Using Maps as Dictionaries - Maps","ref":"maps.html#using-maps-as-dictionaries"},{"type":"extras","doc":"Starting in OTP 24, the `m:sets` module has an option to represent sets as maps.\nExamples:\n\n```erlang\n1> sets:new([{version,2}]).\n#{}\n2> sets:from_list([x,y,z], [{version,2}]).\n#{x => [],y => [],z => []}\n```\n\n`sets` backed by maps is generally the most efficient set representation, with a\nfew possible exceptions:\n\n- `ordsets:intersection/2` can be more efficient than `sets:intersection/2`. If\n  the intersection operation is frequently used and operations that operate on a\n  single element in a set (such as `is_element/2`) are avoided, `m:ordsets` can\n  be a better choice than `m:sets`.\n- If the intersection operation is frequently used and operations that operate\n  on a single element in a set (such as `is_element/2`) must also be efficient,\n  `m:gb_sets` can potentially be a better choice than `m:sets`.\n- If the elements of the set are integers in a fairly compact range, the set can\n  be represented as an integer where each bit represents an element in the set.\n  The union operation is performed by `bor` and the intersection operation by\n  `band`.","title":"Using Maps as Sets - Maps","ref":"maps.html#using-maps-as-sets"},{"type":"extras","doc":"Internally, maps have two distinct representations depending on the number of\nelements in the map. The representation changes when a map grows beyond 32\nelements, or when it shrinks to 32 elements or less.\n\n- A map with at most 32 elements has a compact representation, making it\n  suitable as an alternative to records.\n- A map with more than 32 elements is represented as a tree that can be\n  efficiently searched and updated regardless of how many elements there are.","title":"How Maps are Implemented - Maps","ref":"maps.html#how-maps-are-implemented"},{"type":"extras","doc":"A small map looks like this inside the runtime system:\n\n| 0           | 1   | 2      | 3        |         | N        |\n| :---------: | --- | :----: | :------: | :-----: | :------: |\n| **FLATMAP** | _N_ | _Keys_ | _Value1_ | _..._   | _ValueN_ |\n\n_Table: The representation of a small map_\n\n- **`FLATMAP`** - The tag for a small map (called _flat map_ in the source code\n  for the runtime system).\n\n- **N** - The number of elements in the map.\n\n- **Keys** - A tuple with keys of the map: `{Key1,...,KeyN}`. The keys are\n  sorted.\n\n- **Value1** - The value corresponding to the first key in the key tuple.\n\n- **ValueN** - The value corresponding to the last key in the key tuple.\n\nAs an example, let us look at how the map `#{a => foo, z => bar}` is\nrepresented:\n\n| 0           | 1   | 2         | 3     | 4     |\n| :---------: | --- | :-------: | :---: | ----- |\n| **FLATMAP** | _2_ | `{a,z}`   | `foo` | `bar` |\n\n_Table: \\#\\{a => foo, z => bar\\}_\n\nLet us update the map: `M#{q => baz}`. The map now looks like this:\n\n| 0           | 1   | 2           | 3     | 4     | 5     |\n| :---------: | --- | :---------: | :---: | :---: | :---: |\n| **FLATMAP** | _3_ | `{a,q,z}`   | `foo` | `baz` | `bar` |\n\n_Table: \\#\\{a => foo, q => baz, z => bar\\}_\n\nFinally, change the value of one element: `M#{z := bird}`. The map now looks\nlike this:\n\n| 0           | 1   | 2           | 3     | 4     | 5      |\n| :---------: | --- | :---------: | :---: | :---: | :----: |\n| **FLATMAP** | _3_ | `{a,q,z}`   | `foo` | `baz` | `bird` |\n\n_Table: \\#\\{a => foo, q => baz, z => bird\\}_\n\nWhen the value for an existing key is updated, the key tuple is not updated,\nallowing the key tuple to be shared with other instances of the map that have\nthe same keys. In fact, the key tuple can be shared between all maps with the\nsame keys with some care. To arrange that, define a function that returns a map.\nFor example:\n\n```erlang\nnew() ->\n    #{a => default, b => default, c => default}.\n```\n\nDefined like this, the key tuple `{a,b,c}` will be a global literal. To ensure\nthat the key tuple is shared when creating an instance of the map, always call\n`new()` and modify the returned map:\n\n```erlang\n    (SOME_MODULE:new())#{a := 42}.\n```\n\nUsing the map syntax with small maps is particularly efficient. As long as the\nkeys are known at compile-time, the map is updated in one go, making the time to\nupdate a map essentially constant regardless of the number of keys updated. The\nsame goes for matching. (When the keys are variables, one or more of the keys\ncould be identical, so the operations need to be performed sequentially from\nleft to right.)\n\nThe memory size for a small map is the size of all keys and values plus 5 words.\nSee [Memory](memory.md) for more information about memory sizes.","title":"How Small Maps are Implemented - Maps","ref":"maps.html#how-small-maps-are-implemented"},{"type":"extras","doc":"A map with more than 32 elements is implemented as a\n[Hash array mapped trie (HAMT)](https://en.wikipedia.org/wiki/Hash_array_mapped_trie).\nA large map can be efficiently searched and updated regardless of the number of\nelements in the map.\n\nThere is less performance to be gained by matching or updating multiple elements\nusing the map syntax on a large map compared to a small map. The execution time\nis roughly proportional to the number of elements matched or updated.\n\nThe storage overhead for a large map is higher than for a small map. For a large\nmap, the extra number of words besides the keys and values is roughly\nproportional to the number of elements. For a map with 33 elements the overhead\nis at least 53 heap words according to the formula in\n[Memory](memory.md) (compared to 5 extra words for a small map\nregardless of the number of elements).\n\nWhen a large map is updated, the updated map and the original map will share\ncommon parts of the HAMT, but sharing will never be as effective as the best\npossible sharing of the key tuple for small maps.\n\nTherefore, if maps are used instead of records and it is expected that many\ninstances of the map will be created, it is more efficient from a memory\nstandpoint to avoid using large maps (for example, by grouping related map\nelements into sub maps to reduce the number of elements).","title":"How Large Maps are Implemented - Maps","ref":"maps.html#how-large-maps-are-implemented"},{"type":"extras","doc":"Using the map syntax is usually slightly more efficient than using the\ncorresponding function in the `m:maps` module.\n\nThe gain in efficiency for the map syntax is more noticeable for the following\noperations that can only be achieved using the map syntax:\n\n- Matching multiple literal keys\n- Updating multiple literal keys\n- Adding multiple literal keys to a map\n\nFor example:\n\n**DO**\n\n```erlang\nMap = Map1#{x := X, y := Y, z := Z}\n```\n\n**DO NOT**\n\n```erlang\nMap2 = maps:update(x, X, Map1),\nMap3 = maps:update(y, Y, Map2),\nMap = maps:update(z, Z, Map3)\n```\n\nIf the map is a small map, the first example runs roughly three times as fast.\n\nNote that for variable keys, the elements are updated sequentially from left to\nright. For example, given the following update with variable keys:\n\n```erlang\nMap = Map1#{Key1 := X, Key2 := Y, Key3 := Z}\n```\n\nthe compiler rewrites it like this to ensure that the updates are applied from\nleft to right:\n\n```erlang\nMap2 = Map1#{Key1 := X},\nMap3 = Map2#{Key2 := Y},\nMap = Map3#{Key3 := Z}\n```\n\nIf a key is known to exist in a map, using the `:=` operator is slightly more\nefficient than using the `=>` operator for a small map.","title":"Using the Map Syntax - Maps","ref":"maps.html#using-the-map-syntax"},{"type":"extras","doc":"Here follows some notes about most of the functions in the `maps` module. For\neach function, the implementation language (C or Erlang) is stated. The reason\nwe mention the language is that it gives an hint about how efficient the\nfunction is:\n\n- If a function is implemented in C, it is pretty much impossible to implement\n  the same functionality more efficiently in Erlang.\n- However, it might be possible to beat the `maps` modules functions implemented\n  in Erlang, because they are generally implemented in a way that attempts to\n  make the performance reasonable for all possible inputs.\n\n  For example, `maps:map/2` iterates over all elements of the map, calling the\n  mapping fun, collects the updated map elements in a list, and finally converts\n  the list back to a map using `maps:from_list/1`. If it is known that at most\n  one percent of the values in the map will change, it can be more efficient to\n  update only the changed values.\n\n> #### Note {: .info }\n>\n> The implementation details given in this section can change in the future.","title":"Using the Functions in the maps Module - Maps","ref":"maps.html#using-the-functions-in-the-maps-module"},{"type":"extras","doc":"`maps:filter/2` is implemented in Erlang. It creates a new map using\n`maps:from_list/1`. If it is known that only a minority of the values will be\nremoved, it can be more efficient to avoid `maps:filter/2` and write a function\nthat will use [maps:remove/3](`maps:remove/2`) to remove the unwanted values.","title":"maps:filter/2 - Maps","ref":"maps.html#maps-filter-2"},{"type":"extras","doc":"`maps:filtermap/2` is implemented in Erlang. It creates a new map using\n`maps:from_list/1`. See the notes for `maps:map/2` and `maps:filter/2` for hints\non how to implement a more efficient version.","title":"maps:filtermap/2 - Maps","ref":"maps.html#maps-filtermap-2"},{"type":"extras","doc":"`maps:find/2` is implemented in C.\n\nUsing the map matching syntax instead of `maps:find/2` will be slightly more\nefficient since building an `{ok,Value}` tuple will be avoided.","title":"maps:find/2 - Maps","ref":"maps.html#maps-find-2"},{"type":"extras","doc":"As an optimization, the compiler will rewrite a call to `maps:get/2` to a call\nto the guard BIF [map_get/2](`erlang:map_get/2`). A call to a guard BIF is more\nefficient than calls to other BIFs, making the performance similar to using the\nmap matching syntax.\n\nIf the map is small and the keys are constants known at compile-time, using the\nmap matching syntax will be more efficient than multiple calls to `maps:get/2`.\n\n[](){: #maps_get_3 }","title":"maps:get/2 - Maps","ref":"maps.html#maps-get-2"},{"type":"extras","doc":"As an optimization, the compiler will rewrite a call to `maps:get/3` to Erlang\ncode similar to the following:\n\n```erlang\nResult = case Map of\n             #{Key := Value} -> Value;\n             #{} -> Default\n         end\n```\n\nThis is reasonably efficient, but if a small map is used as an alternative to\nusing a record it is often better not to rely on default values as it prevents\nsharing of keys, which may in the end use more memory than what you save from\nnot storing default values in the map.\n\nIf default values are nevertheless required, instead of calling `maps:get/3`\nmultiple times, consider putting the default values in a map and merging that\nmap with the other map:\n\n```erlang\nDefaultMap = #{Key1 => Value2, Key2 => Value2, ..., KeyN => ValueN},\nMapWithDefaultsApplied = maps:merge(DefaultMap, OtherMap)\n```\n\nThis helps share keys between the default map and the one you applied defaults\nto, as long as the default map contains _all_ the keys that will ever be used\nand not just the ones with default values. Whether this is faster than calling\n`maps:get/3` multiple times depends on the size of the map and the number of\ndefault values.\n\n> #### Change {: .info }\n>\n> Before OTP 26.0 `maps:get/3` was implemented by calling the function instead\n> of rewriting it as an Erlang expression. It is now slightly faster but can no\n> longer be traced.","title":"maps:get/3 - Maps","ref":"maps.html#maps-get-3"},{"type":"extras","doc":"`maps:intersect/2` and `maps:intersect_with/3` are implemented in Erlang. They\nboth create new maps using `maps:from_list/1`.\n\n> #### Note {: .info }\n>\n> A map is usually the most efficient way to implement a set, but an exception\n> is the intersection operation, where `ordsets:intersection/2` used on\n> `m:ordsets` can be more efficient than `maps:intersect/2` on sets implemented\n> as maps.","title":"maps:intersect/2, maps:intersect_with/3 - Maps","ref":"maps.html#maps-intersect-2-maps-intersect_with-3"},{"type":"extras","doc":"`maps:from_list/1` is implemented in C.","title":"maps:from_list/1 - Maps","ref":"maps.html#maps-from_list-1"},{"type":"extras","doc":"`maps:from_keys/2` is implemented in C.","title":"maps:from_keys/2 - Maps","ref":"maps.html#maps-from_keys-2"},{"type":"extras","doc":"As an optimization, the compiler rewrites calls to `maps:is_key/2` to calls to\nthe guard BIF [is_map_key/2](`erlang:is_map_key/2`). A call to a guard BIF is\nmore efficient than calls to other BIFs, making the performance similar to using\nthe map matching syntax.","title":"maps:is_key/2 - Maps","ref":"maps.html#maps-is_key-2"},{"type":"extras","doc":"`maps:iterator/1` is efficiently implemented in C and Erlang.","title":"maps:iterator/1 - Maps","ref":"maps.html#maps-iterator-1"},{"type":"extras","doc":"`maps:keys/1` is implemented in C. If the resulting list needs to be ordered,\nuse `lists:sort/1` to sort the result.","title":"maps:keys/1 - Maps","ref":"maps.html#maps-keys-1"},{"type":"extras","doc":"`maps:map/2` is implemented in Erlang. It creates a new map using\n`maps:from_list/1`. If it is known that only a minority of the values will be\nupdated, it can be more efficient to avoid `maps:map/2` and write a function\nthat will call `maps:update/3` to update only the values that have changed.","title":"maps:map/2 - Maps","ref":"maps.html#maps-map-2"},{"type":"extras","doc":"`maps:merge/2` is implemented in C. For [small maps](maps.md#terminology), the\nkey tuple may be shared with any of the argument maps if that argument map\ncontains all the keys. Literal key tuples are prefered if possible.\n\n> #### Change {: .info }\n>\n> The sharing of key tuples by `maps:merge/2` was introduced in OTP 26.0. Older\n> versions always contructed a new key tuple on the callers heap.","title":"maps:merge/2 - Maps","ref":"maps.html#maps-merge-2"},{"type":"extras","doc":"`maps:merge_with/3` is implemented in Erlang. It updates and returns the larger\nof the two maps.","title":"maps:merge_with/3 - Maps","ref":"maps.html#maps-merge_with-3"},{"type":"extras","doc":"The compiler rewrites a call to `maps:new/0` to using the syntax `#{}` for\nconstructing an empty map.","title":"maps:new/0 - Maps","ref":"maps.html#maps-new-0"},{"type":"extras","doc":"`maps:next/1` is efficiently implemented in C and Erlang.","title":"maps:next/1 - Maps","ref":"maps.html#maps-next-1"},{"type":"extras","doc":"`maps:put/3` is implemented in C.\n\nIf the key is known to already exist in the map, `maps:update/3` is slightly\nmore efficient than `maps:put/3`.\n\nIf the keys are constants known at compile-time, using the map update syntax\nwith the `=>` operator is more efficient than multiple calls to `maps:put/3`,\nespecially for small maps.","title":"maps:put/3 - Maps","ref":"maps.html#maps-put-3"},{"type":"extras","doc":"`maps:remove/2` is implemented in C.","title":"maps:remove/2 - Maps","ref":"maps.html#maps-remove-2"},{"type":"extras","doc":"As an optimization, the compiler rewrites calls to `maps:size/1` to calls to the\nguard BIF [map_size/1](`erlang:map_size/1`). Calls to guard BIFs are more\nefficient than calls to other BIFs.","title":"maps:size/1 - Maps","ref":"maps.html#maps-size-1"},{"type":"extras","doc":"`maps:take/2` is implemented in C.","title":"maps:take/2 - Maps","ref":"maps.html#maps-take-2"},{"type":"extras","doc":"`maps:to_list/1` is efficiently implemented in C and Erlang. If the resulting\nlist needs to be ordered, use `lists:sort/1` to sort the result.\n\n> #### Note {: .info }\n>\n> Maps are usually more performant than `m:gb_trees`, but if it is necessary to\n> frequently convert to and from sorted lists, `gb_trees` can be a better\n> choice.","title":"maps:to_list/1 - Maps","ref":"maps.html#maps-to_list-1"},{"type":"extras","doc":"`maps:update/3` is implemented in C.\n\nIf the keys are constants known at compile-time, using the map update syntax\nwith the `:=` operator is more efficient than multiple calls to `maps:update/3`,\nespecially for [small maps](maps.md#terminology).","title":"maps:update/3 - Maps","ref":"maps.html#maps-update-3"},{"type":"extras","doc":"`maps:values/1` is implemented in C.","title":"maps:values/1 - Maps","ref":"maps.html#maps-values-1"},{"type":"extras","doc":"`maps:with/2` is implemented in Erlang. It creates a new map using\n`maps:from_list/1`.","title":"maps:with/2 - Maps","ref":"maps.html#maps-with-2"},{"type":"extras","doc":"`maps:without/2` is implemented in Erlang. It returns a modified copy of the\ninput map.","title":"maps:without/2 - Maps","ref":"maps.html#maps-without-2"},{"type":"extras","doc":"<!--\n%CopyrightBegin%\n\nCopyright Ericsson AB 2023-2024. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# List Handling","title":"List Handling","ref":"listhandling.html"},{"type":"extras","doc":"Lists can only be built starting from the end and attaching list elements at the\nbeginning. If you use the `++` operator as follows, a new list is created that\nis a copy of the elements in `List1`, followed by `List2`:\n\n```erlang\nList1 ++ List2\n```\n\nLooking at how `lists:append/2` or `++` would be implemented in plain Erlang,\nclearly the first list is copied:\n\n```erlang\nappend([H|T], Tail) ->\n    [H|append(T, Tail)];\nappend([], Tail) ->\n    Tail.\n```\n\nWhen recursing and building a list, it is important to ensure that you attach\nthe new elements to the beginning of the list. In this way, you will build _one_\nlist, not hundreds or thousands of copies of the growing result list.\n\nLet us first see how it is not to be done:\n\n**DO NOT**\n\n```erlang\nbad_fib(N) ->\n    bad_fib(N, 0, 1, []).\n\nbad_fib(0, _Current, _Next, Fibs) ->\n    Fibs;\nbad_fib(N, Current, Next, Fibs) ->\n    bad_fib(N - 1, Next, Current + Next, Fibs ++ [Current]).\n```\n\nHere more than one list is built. In each iteration step a new list is created\nthat is one element longer than the new previous list.\n\nTo avoid copying the result in each iteration, build the list in reverse order\nand reverse the list when you are done:\n\n**DO**\n\n```erlang\ntail_recursive_fib(N) ->\n    tail_recursive_fib(N, 0, 1, []).\n\ntail_recursive_fib(0, _Current, _Next, Fibs) ->\n    lists:reverse(Fibs);\ntail_recursive_fib(N, Current, Next, Fibs) ->\n    tail_recursive_fib(N - 1, Next, Current + Next, [Current|Fibs]).\n```","title":"Creating a List - List Handling","ref":"listhandling.html#creating-a-list"},{"type":"extras","doc":"A list comprehension:\n\n```erlang\n[Expr(E) || E <- List]\n```\n\nis basically translated to a local function:\n\n```erlang\n'lc^0'([E|Tail], Expr) ->\n    [Expr(E)|'lc^0'(Tail, Expr)];\n'lc^0'([], _Expr) -> [].\n```\n\nIf the result of the list comprehension will _obviously_ not be used, a list\nwill not be constructed. For example, in this code:\n\n```erlang\n[io:put_chars(E) || E <- List],\nok.\n```\n\nor in this code:\n\n```erlang\ncase Var of\n    ... ->\n        [io:put_chars(E) || E <- List];\n    ... ->\nend,\nsome_function(...),\n```\n\nthe value is not assigned to a variable, not passed to another function, and not\nreturned. This means that there is no need to construct a list and the compiler\nwill simplify the code for the list comprehension to:\n\n```erlang\n'lc^0'([E|Tail], Expr) ->\n    Expr(E),\n    'lc^0'(Tail, Expr);\n'lc^0'([], _Expr) -> [].\n```\n\nThe compiler also understands that assigning to `_` means that the value will\nnot be used. Therefore, the code in the following example will also be optimized:\n\n```erlang\n_ = [io:put_chars(E) || E <- List],\nok.\n```","title":"List Comprehensions - List Handling","ref":"listhandling.html#list-comprehensions"},{"type":"extras","doc":"`lists:flatten/1` builds an entirely new list. It is therefore expensive, and\neven _more_ expensive than the `++` operator (which copies its left argument,\nbut not its right argument).\n\nIn the following situations it is unnecessary to call `lists:flatten/1`:\n\n- When sending data to a port. Ports understand deep lists so there is no reason\n  to flatten the list before sending it to the port.\n- When calling BIFs that accept deep lists, such as\n  [`list_to_binary/1`](`erlang:list_to_binary/1`) or\n  [`iolist_to_binary/1`](`erlang:iolist_to_binary/1`).\n- When you know that your list is only one level deep. Use `lists:append/1`\n  instead.\n\n_Examples:_\n\n**DO**\n\n```erlang\nport_command(Port, DeepList)\n```\n\n**DO NOT**\n\n```erlang\nport_command(Port, lists:flatten(DeepList))\n```\n\nA common way to send a zero-terminated string to a port is the following:\n\n**DO NOT**\n\n```erlang\nTerminatedStr = String ++ [0],\nport_command(Port, TerminatedStr)\n```\n\nInstead:\n\n**DO**\n\n```erlang\nTerminatedStr = [String, 0],\nport_command(Port, TerminatedStr)\n```\n\n**DO**\n\n```erlang\n1> lists:append([[1], [2], [3]]).\n[1,2,3]\n```\n\n**DO NOT**\n\n```erlang\n1> lists:flatten([[1], [2], [3]]).\n[1,2,3]\n```","title":"Deep and Flat Lists - List Handling","ref":"listhandling.html#deep-and-flat-lists"},{"type":"extras","doc":"There are two basic ways to write a function that traverses a list and\nproduces a new list.\n\nThe first way is writing a *body-recursive* function:\n\n```erlang\n%% Add 42 to each integer in the list.\nadd_42_body([H|T]) ->\n    [H + 42 | add_42_body(T)];\nadd_42_body([]) ->\n    [].\n```\n\nThe second way is writing a *tail-recursive* function:\n\n```erlang\n%% Add 42 to each integer in the list.\nadd_42_tail(List) ->\n    add_42_tail(List, []).\n\nadd_42_tail([H|T], Acc) ->\n    add_42_tail(T, [H + 42 | Acc]);\nadd_42_tail([], Acc) ->\n    lists:reverse(Acc).\n```\n\nIn early version of Erlang the tail-recursive function would typically\nbe more efficient. In modern versions of Erlang, there is usually not\nmuch difference in performance between a body-recursive list function and\ntail-recursive function that reverses the list at the end. Therefore,\nconcentrate on writing beautiful code and forget about the performance\nof your list functions. In the time-critical parts of your code,\n_measure_ before rewriting your code.\n\nFor a thorough discussion about tail and body recursion, see\n[Erlang's Tail Recursion is Not a Silver Bullet](http://ferd.ca/erlang-s-tail-recursion-is-not-a-silver-bullet.html).\n\n> #### Note {: .info }\n>\n> This section is about list functions that _construct_ lists. A tail-recursive\n> function that does not construct a list runs in constant space, while the\n> corresponding body-recursive function uses stack space proportional to the\n> length of the list.\n\nFor example, a function that sums a list of integers, is _not_ to be written as\nfollows:\n\n**DO NOT**\n\n```erlang\nrecursive_sum([H|T]) -> H+recursive_sum(T);\nrecursive_sum([])    -> 0.\n```\n\nInstead:\n\n**DO**\n\n```erlang\nsum(L) -> sum(L, 0).\n\nsum([H|T], Sum) -> sum(T, Sum + H);\nsum([], Sum)    -> Sum.\n```","title":"Recursive List Functions - List Handling","ref":"listhandling.html#recursive-list-functions"},{"type":"extras","doc":"<!--\n%CopyrightBegin%\n\nCopyright Ericsson AB 2023-2024. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# Functions","title":"Functions","ref":"eff_guide_functions.html"},{"type":"extras","doc":"Pattern matching in function head as well as in `case` and `receive` clauses are\noptimized by the compiler. With a few exceptions, there is nothing to gain by\nrearranging clauses.\n\nOne exception is pattern matching of binaries. The compiler does not rearrange\nclauses that match binaries. Placing the clause that matches against the empty\nbinary _last_ is usually slightly faster than placing it _first_.\n\nThe following is a rather unnatural example to show another exception where\nrearranging clauses is beneficial:\n\n**DO NOT**\n\n```erlang\natom_map1(one) -> 1;\natom_map1(two) -> 2;\natom_map1(three) -> 3;\natom_map1(Int) when is_integer(Int) -> Int;\natom_map1(four) -> 4;\natom_map1(five) -> 5;\natom_map1(six) -> 6.\n```\n\nThe problem is the clause with the variable `Int`. As a variable can match\nanything, including the atoms `four`, `five`, and `six`, which the following\nclauses also match, the compiler must generate suboptimal code that executes as\nfollows:\n\n- First, the input value is compared to `one`, `two`, and `three` (using a\n  single instruction that does a binary search; thus, quite efficient even if\n  there are many values) to select which one of the first three clauses to\n  execute (if any).\n- If none of the first three clauses match, the fourth clause match as a\n  variable always matches.\n- If the guard test [`is_integer(Int)`](`is_integer/1`) succeeds, the fourth\n  clause is executed.\n- If the guard test fails, the input value is compared to `four`, `five`, and\n  `six`, and the appropriate clause is selected. (There is a `function_clause`\n  exception if none of the values matched.)\n\nRewriting to either:\n\n**DO**\n\n```erlang\natom_map2(one) -> 1;\natom_map2(two) -> 2;\natom_map2(three) -> 3;\natom_map2(four) -> 4;\natom_map2(five) -> 5;\natom_map2(six) -> 6;\natom_map2(Int) when is_integer(Int) -> Int.\n```\n\nor:\n\n**DO**\n\n```erlang\natom_map3(Int) when is_integer(Int) -> Int;\natom_map3(one) -> 1;\natom_map3(two) -> 2;\natom_map3(three) -> 3;\natom_map3(four) -> 4;\natom_map3(five) -> 5;\natom_map3(six) -> 6.\n```\n\ngives slightly more efficient matching code.\n\nAnother example:\n\n**DO NOT**\n\n```erlang\nmap_pairs1(_Map, [], Ys) ->\n    Ys;\nmap_pairs1(_Map, Xs, []) ->\n    Xs;\nmap_pairs1(Map, [X|Xs], [Y|Ys]) ->\n    [Map(X, Y)|map_pairs1(Map, Xs, Ys)].\n```\n\nThe first argument is _not_ a problem. It is variable, but it is a variable in\nall clauses. The problem is the variable in the second argument, `Xs`, in the\nmiddle clause. Because the variable can match anything, the compiler is not\nallowed to rearrange the clauses, but must generate code that matches them in\nthe order written.\n\nIf the function is rewritten as follows, the compiler is free to rearrange the\nclauses:\n\n**DO**\n\n```erlang\nmap_pairs2(_Map, [], Ys) ->\n    Ys;\nmap_pairs2(_Map, [_|_]=Xs, [] ) ->\n    Xs;\nmap_pairs2(Map, [X|Xs], [Y|Ys]) ->\n    [Map(X, Y)|map_pairs2(Map, Xs, Ys)].\n```\n\nThe compiler will generate code similar to this:\n\n**DO NOT (already done by the compiler)**\n\n```erlang\nexplicit_map_pairs(Map, Xs0, Ys0) ->\n    case Xs0 of\n\t[X|Xs] ->\n\t    case Ys0 of\n\t\t[Y|Ys] ->\n\t\t    [Map(X, Y)|explicit_map_pairs(Map, Xs, Ys)];\n\t\t[] ->\n\t\t    Xs0\n\t    end;\n\t[] ->\n\t    Ys0\n    end.\n```\n\nThis is slightly faster for probably the most common case that the input lists\nare not empty or very short. (Another advantage is that Dialyzer can deduce a\nbetter type for the `Xs` variable.)","title":"Pattern Matching - Functions","ref":"eff_guide_functions.html#pattern-matching"},{"type":"extras","doc":"This is a rough hierarchy of the performance of the different types of function\ncalls:\n\n- Calls to local or external functions (`foo()`, `m:foo()`) are the fastest\n  calls.\n- Calling or applying a fun (`Fun()`, [`apply(Fun, [])`](`apply/2`)) is just a\n  little slower than external calls.\n- Applying an exported function (`Mod:Name()`,\n  [`apply(Mod, Name, [])`](`apply/3`)) where the number of arguments is known at\n  compile time is next.\n- Applying an exported function ([`apply(Mod, Name, Args)`](`apply/3`)) where\n  the number of arguments is not known at compile time is the least efficient.","title":"Function Calls - Functions","ref":"eff_guide_functions.html#function-calls"},{"type":"extras","doc":"Calling and applying a fun does not involve any hash-table lookup. A fun\ncontains an (indirect) pointer to the function that implements the fun.\n\n[`apply/3`](`apply/3`) must look up the code for the function to execute in a\nhash table. It is therefore always slower than a direct call or a fun call.\n\nCaching callback functions into funs may be more efficient in the long run than\napply calls for frequently-used callbacks.","title":"Notes and Implementation Details - Functions","ref":"eff_guide_functions.html#notes-and-implementation-details"},{"type":"extras","doc":"<!--\n%CopyrightBegin%\n\nCopyright Ericsson AB 2023-2024. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# Tables and Databases","title":"Tables and Databases","ref":"tablesdatabases.html"},{"type":"extras","doc":"Every example using Ets has a corresponding example in Mnesia. In general, all\nEts examples also apply to Dets tables.","title":"Ets, Dets, and Mnesia - Tables and Databases","ref":"tablesdatabases.html#ets-dets-and-mnesia"},{"type":"extras","doc":"Select/match operations on Ets and Mnesia tables can become very expensive\noperations. They usually need to scan the complete table. Try to structure the\ndata to minimize the need for select/match operations. However, if you require a\nselect/match operation, it is still more efficient than using `tab2list`.\nExamples of this and of how to avoid select/match are provided in the following\nsections. The functions `ets:select/2` and `mnesia:select/3` are to be preferred\nover `ets:match/2`, `ets:match_object/2`, and `mnesia:match_object/3`.\n\nIn some circumstances, the select/match operations do not need to scan the\ncomplete table. For example, if part of the key is bound when searching an\n`ordered_set` table, or if it is a Mnesia table and there is a secondary index\non the field that is selected/matched. If the key is fully bound, there is no\npoint in doing a select/match, unless you have a bag table and are only\ninterested in a subset of the elements with the specific key.\n\nWhen creating a record to be used in a select/match operation, you want most of\nthe fields to have the value `_`. The easiest and fastest way to do that is as\nfollows:\n\n```text\n#person{age = 42, _ = '_'}.\n```","title":"Select/Match Operations - Tables and Databases","ref":"tablesdatabases.html#select-match-operations"},{"type":"extras","doc":"The `delete` operation is considered successful if the element was not present\nin the table. Hence all attempts to check that the element is present in the\nEts/Mnesia table before deletion are unnecessary. Here follows an example for\nEts tables:\n\n**DO**\n\n```text\nets:delete(Tab, Key),\n```\n\n**DO NOT**\n\n```erlang\ncase ets:lookup(Tab, Key) of\n    [] ->\n        ok;\n    [_|_] ->\n        ets:delete(Tab, Key)\nend,\n```","title":"Deleting an Element - Tables and Databases","ref":"tablesdatabases.html#deleting-an-element"},{"type":"extras","doc":"Do not fetch data that you already have.\n\nConsider that you have a module that handles the abstract data type `Person`.\nYou export the interface function `print_person/1`, which uses the internal\nfunctions `print_name/1`, `print_age/1`, and `print_occupation/1`.\n\n> #### Note {: .info }\n>\n> If the function `print_name/1`, and so on, had been interface functions, the\n> situation would have been different, as you do not want the user of the\n> interface to know about the internal data representation.\n\n**DO**\n\n```erlang\n%%% Interface function\nprint_person(PersonId) ->\n    %% Look up the person in the named table person,\n    case ets:lookup(person, PersonId) of\n        [Person] ->\n            print_name(Person),\n            print_age(Person),\n            print_occupation(Person);\n        [] ->\n            io:format(\"No person with ID = ~p~n\", [PersonID])\n    end.\n\n%%% Internal functions\nprint_name(Person) ->\n    io:format(\"No person ~p~n\", [Person#person.name]).\n\nprint_age(Person) ->\n    io:format(\"No person ~p~n\", [Person#person.age]).\n\nprint_occupation(Person) ->\n    io:format(\"No person ~p~n\", [Person#person.occupation]).\n```\n\n**DO NOT**\n\n```erlang\n%%% Interface function\nprint_person(PersonId) ->\n    %% Look up the person in the named table person,\n    case ets:lookup(person, PersonId) of\n        [Person] ->\n            print_name(PersonID),\n            print_age(PersonID),\n            print_occupation(PersonID);\n        [] ->\n            io:format(\"No person with ID = ~p~n\", [PersonID])\n    end.\n\n%%% Internal functions\nprint_name(PersonID) ->\n    [Person] = ets:lookup(person, PersonId),\n    io:format(\"No person ~p~n\", [Person#person.name]).\n\nprint_age(PersonID) ->\n    [Person] = ets:lookup(person, PersonId),\n    io:format(\"No person ~p~n\", [Person#person.age]).\n\nprint_occupation(PersonID) ->\n    [Person] = ets:lookup(person, PersonId),\n    io:format(\"No person ~p~n\", [Person#person.occupation]).\n```","title":"Fetching Data - Tables and Databases","ref":"tablesdatabases.html#fetching-data"},{"type":"extras","doc":"For non-persistent database storage, prefer Ets tables over Mnesia\n`local_content` tables. Even the Mnesia `dirty_write` operations carry a fixed\noverhead compared to Ets writes. Mnesia must check if the table is replicated or\nhas indices, this involves at least one Ets lookup for each `dirty_write`. Thus,\nEts writes is always faster than Mnesia writes.","title":"Non-Persistent Database Storage - Tables and Databases","ref":"tablesdatabases.html#non-persistent-database-storage"},{"type":"extras","doc":"Assuming an Ets table that uses `idno` as key and contains the following:\n\n```text\n[#person{idno = 1, name = \"Adam\",  age = 31, occupation = \"mailman\"},\n #person{idno = 2, name = \"Bryan\", age = 31, occupation = \"cashier\"},\n #person{idno = 3, name = \"Bryan\", age = 35, occupation = \"banker\"},\n #person{idno = 4, name = \"Carl\",  age = 25, occupation = \"mailman\"}]\n```\n\nIf you _must_ return all data stored in the Ets table, you can use\n`ets:tab2list/1`. However, usually you are only interested in a subset of the\ninformation in which case `ets:tab2list/1` is expensive. If you only want to\nextract one field from each record, for example, the age of every person, then:\n\n**DO**\n\n```erlang\nets:select(Tab, [{#person{idno='_',\n                          name='_',\n                          age='$1',\n                          occupation = '_'},\n                [],\n                ['$1']}]),\n```\n\n**DO NOT**\n\n```erlang\nTabList = ets:tab2list(Tab),\nlists:map(fun(X) -> X#person.age end, TabList),\n```\n\nIf you are only interested in the age of all persons named \"Bryan\", then:\n\n**DO**\n\n```erlang\nets:select(Tab, [{#person{idno='_',\n                          name=\"Bryan\",\n                          age='$1',\n                          occupation = '_'},\n                [],\n                ['$1']}])\n```\n\n**DO NOT**\n\n```erlang\nTabList = ets:tab2list(Tab),\nlists:foldl(fun(X, Acc) -> case X#person.name of\n                                \"Bryan\" ->\n                                    [X#person.age|Acc];\n                                 _ ->\n                                     Acc\n                           end\n             end, [], TabList)\n```\n\nIf you need all information stored in the Ets table about persons named \"Bryan\",\nthen:\n\n**DO**\n\n```erlang\nets:select(Tab, [{#person{idno='_',\n                          name=\"Bryan\",\n                          age='_',\n                          occupation = '_'}, [], ['$_']}]),\n```\n\n**DO NOT**\n\n```erlang\nTabList = ets:tab2list(Tab),\nlists:filter(fun(X) -> X#person.name == \"Bryan\" end, TabList),\n```\n\n### `ordered_set` Tables\n\nIf the data in the table is to be accessed so that the order of the keys in the\ntable is significant, the table type `ordered_set` can be used instead of the\nmore usual `set` table type. An `ordered_set` is always traversed in Erlang term\norder regarding the key field so that the return values from functions such as\n`select`, `match_object`, and `foldl` are ordered by the key values. Traversing\nan `ordered_set` with the `first` and `next` operations also returns the keys\nordered.\n\n> #### Note {: .info }\n>\n> An `ordered_set` only guarantees that objects are processed in _key_ order.\n> Results from functions such as `ets:select/2` appear in _key_ order even if\n> the key is not included in the result.","title":"tab2list - Tables and Databases","ref":"tablesdatabases.html#tab2list"},{"type":"extras","doc":"","title":"ETS - Tables and Databases","ref":"tablesdatabases.html#ets"},{"type":"extras","doc":"An Ets table is a single-key table (either a hash table or a tree ordered by the\nkey) and is to be used as one. In other words, use the key to look up things\nwhenever possible. A lookup by a known key in a `set` Ets table is constant and\nfor an `ordered_set` Ets table it is _O(log N)_. A key lookup is always preferable\nto a call where the whole table has to be scanned. In the previous examples, the\nfield `idno` is the key of the table and all lookups where only the name is\nknown result in a complete scan of the (possibly large) table for a matching\nresult.\n\nA simple solution would be to use the `name` field as the key instead of the\n`idno` field, but that would cause problems if the names were not unique. A more\ngeneral solution would be to create a second table with `name` as key and `idno`\nas data, that is, to index (invert) the table regarding the `name` field.\nClearly, the second table would have to be kept consistent with the master\ntable. Mnesia can do this for you, but a home-brew index table can be very\nefficient compared to the overhead involved in using Mnesia.\n\nAn index table for the table in the previous examples would have to be a bag (as\nkeys would appear more than once) and can have the following contents:\n\n```text\n[#index_entry{name=\"Adam\", idno=1},\n #index_entry{name=\"Bryan\", idno=2},\n #index_entry{name=\"Bryan\", idno=3},\n #index_entry{name=\"Carl\", idno=4}]\n```\n\nGiven this index table, a lookup of the `age` fields for all persons named\n\"Bryan\" can be done as follows:\n\n```erlang\nMatchingIDs = ets:lookup(IndexTable,\"Bryan\"),\nlists:map(fun(#index_entry{idno = ID}) ->\n                 [#person{age = Age}] = ets:lookup(PersonTable, ID),\n                 Age\n          end,\n          MatchingIDs),\n```\n\nNotice that this code does not use `ets:match/2`, but instead uses the\n`ets:lookup/2` call. The `lists:map/2` call is only used to traverse the `idno`s\nmatching the name \"Bryan\" in the table; thus the number of lookups in the master\ntable is minimized.\n\nKeeping an index table introduces some overhead when inserting records in the\ntable. The number of operations gained from the table must therefore be compared\nagainst the number of operations inserting objects in the table. However, notice\nthat the gain is significant when the key can be used to lookup elements.","title":"Using Keys of Ets Table - Tables and Databases","ref":"tablesdatabases.html#using-keys-of-ets-table"},{"type":"extras","doc":"","title":"Mnesia - Tables and Databases","ref":"tablesdatabases.html#mnesia"},{"type":"extras","doc":"If you frequently do lookups on a field that is not the key of the table, you\nlose performance using [mnesia:select()](`mnesia:select/3`) or\n[`mnesia:match_object()`](`mnesia:match_object/1`) as these function traverse\nthe whole table. Instead, you can create a secondary index and use\n`mnesia:index_read/3` to get faster access at the expense of using more\nmemory.\n\n_Example:_\n\n```erlang\n-record(person, {idno, name, age, occupation}).\n        ...\n{atomic, ok} =\nmnesia:create_table(person, [{index,[#person.age]},\n                              {attributes,\n                                    record_info(fields, person)}]),\n{atomic, ok} = mnesia:add_table_index(person, age),\n...\n\nPersonsAge42 =\n     mnesia:dirty_index_read(person, 42, #person.age),\n```","title":"Secondary Index - Tables and Databases","ref":"tablesdatabases.html#secondary-index"},{"type":"extras","doc":"Using transactions is a way to guarantee that the distributed Mnesia database\nremains consistent, even when many different processes update it in parallel.\nHowever, if you have real-time requirements it is recommended to use dirtry\noperations instead of transactions. When using dirty operations, you lose the\nconsistency guarantee; this is usually solved by only letting one process update\nthe table. Other processes must send update requests to that process.\n\n_Example:_\n\n```erlang\n...\n%% Using transaction\n\nFun = fun() ->\n          [mnesia:read({Table, Key}),\n           mnesia:read({Table2, Key2})]\n      end,\n\n{atomic, [Result1, Result2]}  = mnesia:transaction(Fun),\n...\n\n%% Same thing using dirty operations\n...\n\nResult1 = mnesia:dirty_read({Table, Key}),\nResult2 = mnesia:dirty_read({Table2, Key2}),\n```","title":"Transactions - Tables and Databases","ref":"tablesdatabases.html#transactions"},{"type":"extras","doc":"<!--\n%CopyrightBegin%\n\nCopyright Ericsson AB 2023-2024. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# Processes","title":"Processes","ref":"eff_guide_processes.html"},{"type":"extras","doc":"An Erlang process is lightweight compared to threads and processes in operating\nsystems.\n\nA newly spawned Erlang process uses 327 words of memory. The size can be found\nas follows:\n\n```erlang\nErlang/OTP 27 [erts-14.2.3] [64-bit] [smp:8:8] [ds:8:8:10] [async-threads:1] [jit]\n\nEshell V14.2.3 (press Ctrl+G to abort, type help(). for help)\n1> Fun = fun() -> receive after infinity -> ok end end.\n#Fun \n2> {_,Bytes} = process_info(spawn(Fun), memory).\n{memory,2616}\n3> Bytes div erlang:system_info(wordsize).\n327\n```\n\nThe size includes 233 words for the heap area (which includes the stack). The\ngarbage collector increases the heap as needed.\n\nThe main (outer) loop for a process _must_ be tail-recursive. Otherwise, the\nstack grows until the process terminates.\n\n**DO NOT**\n\n```erlang\nloop() ->\n  receive\n     {sys, Msg} ->\n         handle_sys_msg(Msg),\n         loop();\n     {From, Msg} ->\n          Reply = handle_msg(Msg),\n          From ! Reply,\n          loop()\n  end,\n  io:format(\"Message is processed~n\", []).\n```\n\nThe call to `io:format/2` will never be executed, but a return address will\nstill be pushed to the stack each time `loop/0` is called recursively. The\ncorrect tail-recursive version of the function looks as follows:\n\n**DO**\n\n```erlang\nloop() ->\n   receive\n      {sys, Msg} ->\n         handle_sys_msg(Msg),\n         loop();\n      {From, Msg} ->\n         Reply = handle_msg(Msg),\n         From ! Reply,\n         loop()\n end.\n```","title":"Creating an Erlang Process - Processes","ref":"eff_guide_processes.html#creating-an-erlang-process"},{"type":"extras","doc":"The default initial heap size of 233 words is quite conservative to support\nErlang systems with hundreds of thousands or even millions of processes. The\ngarbage collector grows and shrinks the heap as needed.\n\nIn a system that use comparatively few processes, performance _might_ be\nimproved by increasing the minimum heap size using either the `+h` option for\n[erl](`e:erts:erl_cmd.md`) or on a process-per-process basis using the\n`min_heap_size` option for [spawn_opt/4](`erlang:spawn_opt/4`).\n\nThe gain is twofold:\n\n- Although the garbage collector grows the heap, it grows it step-by-step, which\n  is more costly than directly establishing a larger heap when the process is\n  spawned.\n- The garbage collector can also shrink the heap if it is much larger than the\n  amount of data stored on it; setting the minimum heap size prevents that.\n\n> #### Warning {: .warning }\n>\n> The runtime system probably uses more memory, and because garbage collections occur\n> less frequently, huge binaries can be kept much longer.\n>\n> This optimization is not to be attempted without proper measurements.\n\nIn systems with many processes, computation tasks that run for a short time can\nbe spawned off into a new process with a higher minimum heap size. When the\nprocess is done, it sends the result of the computation to another process and\nterminates. If the minimum heap size is calculated properly, the process might\nnot have to do any garbage collections at all.","title":"Initial Heap Size - Processes","ref":"eff_guide_processes.html#initial-heap-size"},{"type":"extras","doc":"All data in messages sent between Erlang processes is copied, except for\n[refc binaries](binaryhandling.md#refc_binary) and\n[literals](eff_guide_processes.md#literal-pool) on the same Erlang node.\n\nWhen a message is sent to a process on another Erlang node, it is\nfirst encoded to the [Erlang External Format](`e:erts:erl_ext_dist.md`)\nbefore being sent through a TCP/IP socket. The receiving Erlang node\ndecodes the message and distributes it to the correct process.","title":"Sending Messages - Processes","ref":"eff_guide_processes.html#sending-messages"},{"type":"extras","doc":"The cost of receiving messages depends on how complicated the `receive`\nexpression is. A simple expression that matches any message is very cheap\nbecause it retrieves the first message in the message queue:\n\n**DO**\n\n```erlang\nreceive\n    Message -> handle_msg(Message)\nend.\n```\n\nHowever, this is not always convenient: we can receive a message that we do not\nknow how to handle at this point, so it is common to only match the messages we\nexpect:\n\n```erlang\nreceive\n    {Tag, Message} -> handle_msg(Message)\nend.\n```\n\nWhile this is convenient it means that the entire message queue must be searched\nuntil it finds a matching message. This is very expensive for processes with\nlong message queues, so there is an optimization for the common case of\nsending a request and waiting for a response shortly after:\n\n**DO**\n\n```erlang\nMRef = monitor(process, Process),\nProcess ! {self(), MRef, Request},\nreceive\n    {MRef, Reply} ->\n        erlang:demonitor(MRef, [flush]),\n        handle_reply(Reply);\n    {'DOWN', MRef, _, _, Reason} ->\n        handle_error(Reason)\nend.\n```\n\nSince the compiler knows that the reference created by\n[`monitor/2`](`monitor/2`) cannot exist before the call (since it is a globally\nunique identifier), and that the `receive` only matches messages that contain\nsaid reference, it will tell the emulator to search only the messages that\narrived after the call to [`monitor/2`](`monitor/2`).\n\nThe above is a simple example where one is but guaranteed that the optimization\nwill take, but what about more complicated code?\n\n[](){: #recv_opt_info }","title":"Receiving messages - Processes","ref":"eff_guide_processes.html#receiving-messages"},{"type":"extras","doc":"Use the `recv_opt_info` option to have the compiler print information about\nreceive optimizations. It can be given either to the compiler or `erlc`:\n\n```erlang\nerlc +recv_opt_info Mod.erl\n```\n\nor passed through an environment variable:\n\n```erlang\nexport ERL_COMPILER_OPTIONS=recv_opt_info\n```\n\nNotice that `recv_opt_info` is not meant to be a permanent option added to your\n`Makefile`s, because all messages that it generates cannot be eliminated.\nTherefore, passing the option through the environment is in most cases the most\npractical approach.\n\nThe warnings look as follows:\n\n```erlang\nefficiency_guide.erl:194: Warning: INFO: receive matches any message, this is always fast\nefficiency_guide.erl:200: Warning: NOT OPTIMIZED: all clauses do not match a suitable reference\nefficiency_guide.erl:206: Warning: OPTIMIZED: reference used to mark a message queue position\nefficiency_guide.erl:208: Warning: OPTIMIZED: all clauses match reference created by monitor/2 at efficiency_guide.erl:206\nefficiency_guide.erl:219: Warning: INFO: passing reference created by make_ref/0 at efficiency_guide.erl:218\nefficiency_guide.erl:222: Warning: OPTIMIZED: all clauses match reference in function parameter 1\n```\n\nTo make it clearer exactly what code the warnings refer to, the warnings in the\nfollowing examples are inserted as comments after the clause they refer to, for\nexample:\n\n```erlang\n%% DO\nsimple_receive() ->\n%% efficiency_guide.erl:194: Warning: INFO: not a selective receive, this is always fast\nreceive\n    Message -> handle_msg(Message)\nend.\n\n%% DO NOT, unless Tag is known to be a suitable reference: see\n%% cross_function_receive/0 further down.\nselective_receive(Tag, Message) ->\n%% efficiency_guide.erl:200: Warning: NOT OPTIMIZED: all clauses do not match a suitable reference\nreceive\n    {Tag, Message} -> handle_msg(Message)\nend.\n\n%% DO\noptimized_receive(Process, Request) ->\n%% efficiency_guide.erl:206: Warning: OPTIMIZED: reference used to mark a message queue position\n    MRef = monitor(process, Process),\n    Process ! {self(), MRef, Request},\n    %% efficiency_guide.erl:208: Warning: OPTIMIZED: matches reference created by monitor/2 at efficiency_guide.erl:206\n    receive\n        {MRef, Reply} ->\n        erlang:demonitor(MRef, [flush]),\n        handle_reply(Reply);\n    {'DOWN', MRef, _, _, Reason} ->\n    handle_error(Reason)\n    end.\n\n%% DO\ncross_function_receive() ->\n    %% efficiency_guide.erl:218: Warning: OPTIMIZED: reference used to mark a message queue position\n    Ref = make_ref(),\n    %% efficiency_guide.erl:219: Warning: INFO: passing reference created by make_ref/0 at efficiency_guide.erl:218\n    cross_function_receive(Ref).\n\ncross_function_receive(Ref) ->\n    %% efficiency_guide.erl:222: Warning: OPTIMIZED: all clauses match reference in function parameter 1\n    receive\n        {Ref, Message} -> handle_msg(Message)\n    end.\n```","title":"Option recv_opt_info - Processes","ref":"eff_guide_processes.html#option-recv_opt_info"},{"type":"extras","doc":"Constant Erlang terms (hereafter called _literals_) are kept in _literal pools_;\neach loaded module has its own pool. The following function does not build the\ntuple every time it is called (only to have it discarded the next time the\ngarbage collector was run), but the tuple is located in the module's literal\npool:\n\n**DO**\n\n```erlang\ndays_in_month(M) ->\n    element(M, {31,28,31,30,31,30,31,31,30,31,30,31}).\n```\n\nIf a literal, or a term that contains a literal, is inserted into an Ets table,\nit is _copied_. The reason is that the module containing the literal can be\nunloaded in the future.\n\nWhen a literal is sent to another process, it is _not_ copied. When a module\nholding a literal is unloaded, the literal will be copied to the heap of all\nprocesses that hold references to that literal.\n\nThere also exists a global literal pool that is managed by the\n`m:persistent_term` module.\n\nBy default, 1 GB of virtual address space is reserved for all literal pools (in\nBEAM code and persistent terms). The amount of virtual address space reserved\nfor literals can be changed by using the\n[`+MIscs option`](`e:erts:erts_alloc.md#MIscs`) when starting the emulator.\n\nHere is an example how the reserved virtual address space for literals can be\nraised to 2 GB (2048 MB):\n\n```text\nerl +MIscs 2048\n```","title":"Literal Pool - Processes","ref":"eff_guide_processes.html#literal-pool"},{"type":"extras","doc":"An Erlang term can have shared subterms. Here is a simple example:\n\n```erlang\n{SubTerm, SubTerm}\n```\n\nShared subterms are _not_ preserved in the following cases:\n\n- When a term is sent to another process\n- When a term is passed as the initial process arguments in the `spawn` call\n- When a term is stored in an Ets table\n\nThat is an optimization. Most applications do not send messages with shared\nsubterms.\n\nThe following example shows how a shared subterm can be created:\n\n```erlang\nkilo_byte() ->\n    kilo_byte(10, [42]).\n\nkilo_byte(0, Acc) ->\n    Acc;\nkilo_byte(N, Acc) ->\n    kilo_byte(N-1, [Acc|Acc]).\n```\n\n`kilo_byte/1` creates a deep list. If [`list_to_binary/1`](`list_to_binary/1`)\nis called, the deep list can be converted to a binary of 1024 bytes:\n\n```text\n1> byte_size(list_to_binary(efficiency_guide:kilo_byte())).\n1024\n```\n\nUsing the `erts_debug:size/1` BIF, it can be seen that the deep list only\nrequires 22 words of heap space:\n\n```erlang\n2> erts_debug:size(efficiency_guide:kilo_byte()).\n22\n```\n\nUsing the `erts_debug:flat_size/1` BIF, the size of the deep list can be\ncalculated if sharing is ignored. It becomes the size of the list when it has\nbeen sent to another process or stored in an Ets table:\n\n```erlang\n3> erts_debug:flat_size(efficiency_guide:kilo_byte()).\n4094\n```\n\nIt can be verified that sharing will be lost if the data is inserted into an Ets\ntable:\n\n```erlang\n4> T = ets:new(tab, []).\n#Ref<0.1662103692.2407923716.214181>\n5> ets:insert(T, {key,efficiency_guide:kilo_byte()}).\ntrue\n6> erts_debug:size(element(2, hd(ets:lookup(T, key)))).\n4094\n7> erts_debug:flat_size(element(2, hd(ets:lookup(T, key)))).\n4094\n```\n\nWhen the data has passed through an Ets table, `erts_debug:size/1` and\n`erts_debug:flat_size/1` return the same value. Sharing has been lost.\n\nIt is possible to build an _experimental_ variant of the runtime system that\nwill preserve sharing when copying terms by giving the\n`--enable-sharing-preserving` option to the `configure` script.","title":"Loss of Sharing - Processes","ref":"eff_guide_processes.html#loss-of-sharing"},{"type":"extras","doc":"The Erlang run-time system takes advantage of a multi-core or\nmulti-CPU computer by running several Erlang scheduler threads\n(typically, the same number of threads as the number of cores).\n\nTo gain performance from a multi-core computer, your application _must have more\nthan one runnable Erlang process_ most of the time. Otherwise, the Erlang\nemulator can still only run one Erlang process at the time.\n\nBenchmarks that appear to be concurrent are often sequential.  For\nexample, the [EStone\nbenchmark](https://github.com/erlang/otp/blob/f164034e6fdab3316ae23c5d5bbaef258dd6d12c/erts/emulator/test/estone_SUITE.erl)\nis entirely sequential. So is the most common implementation of the\n\"ring benchmark\"; usually one process is active, while the others wait\nin a `receive` statement.","title":"SMP Run-Time System - Processes","ref":"eff_guide_processes.html#smp-run-time-system"},{"type":"extras","doc":"<!--\n%CopyrightBegin%\n\nCopyright Ericsson AB 2023-2024. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# Drivers\n\nThis section provides a brief overview on how to write efficient drivers.\n\nIt is assumed that you have a good understanding of drivers.","title":"Drivers","ref":"drivers.html"},{"type":"extras","doc":"The runtime system always takes a lock before running any code in a driver.\n\nBy default, that lock is at the driver level, that is, if several ports have\nbeen opened to the same driver, only code for one port at the same time can be\nrunning.\n\nA driver can be configured to have one lock for each port instead.\n\nIf a driver is used in a functional way (that is, holds no state, but only does\nsome heavy calculation and returns a result), several ports with registered\nnames can be opened beforehand, and the port to be used can be chosen based on\nthe scheduler ID as follows:\n\n```erlang\n-define(PORT_NAMES(),\n\t{some_driver_01, some_driver_02, some_driver_03, some_driver_04,\n\t some_driver_05, some_driver_06, some_driver_07, some_driver_08,\n\t some_driver_09, some_driver_10, some_driver_11, some_driver_12,\n\t some_driver_13, some_driver_14, some_driver_15, some_driver_16}).\n\nclient_port() ->\n    element(erlang:system_info(scheduler_id) rem tuple_size(?PORT_NAMES()) + 1,\n\t    ?PORT_NAMES()).\n```\n\nAs long as there are no more than 16 schedulers, there will never be any lock\ncontention on the port lock for the driver.","title":"Drivers and Concurrency - Drivers","ref":"drivers.html#drivers-and-concurrency"},{"type":"extras","doc":"There are basically two ways to avoid copying a binary that is sent to a driver:\n\n- If the `Data` argument for [`port_control/3`](`erlang:port_control/3`) is a\n  binary, the driver will be passed a pointer to the contents of the binary and\n  the binary will not be copied. If the `Data` argument is an iolist (list of\n  binaries and lists), all binaries in the iolist will be copied.\n\n  Therefore, if you want to send both a pre-existing binary and some extra data\n  to a driver without copying the binary, you must call\n  [`port_control/3`](`port_control/3`) twice; once with the binary and once with\n  the extra data. However, that will only work if there is only one process\n  communicating with the port (because otherwise another process can call the\n  driver in-between the calls).\n\n- Implement an `outputv` callback (instead of an `output` callback) in the\n  driver. If a driver has an `outputv` callback, refc binaries passed in an\n  iolist in the `Data` argument for [`port_command/2`](`erlang:port_command/2`)\n  will be passed as references to the driver.","title":"Avoiding Copying Binaries When Calling a Driver - Drivers","ref":"drivers.html#avoiding-copying-binaries-when-calling-a-driver"},{"type":"extras","doc":"The runtime system can represent binaries up to 64 bytes as heap binaries. They\nare always copied when sent in messages, but they require less memory if they\nare not sent to another process and garbage collection is cheaper.\n\nIf you know that the binaries you return are always small, you are advised to\nuse driver API calls that do not require a pre-allocated binary, for example,\n[`driver_output()`](`e:erts:erl_driver.md#driver_output`) or\n[`erl_drv_output_term()`](`e:erts:erl_driver.md#erl_drv_output_term`), using the\n`ERL_DRV_BUF2BINARY` format, to allow the runtime to construct a heap binary.","title":"Returning Small Binaries from a Driver - Drivers","ref":"drivers.html#returning-small-binaries-from-a-driver"},{"type":"extras","doc":"To avoid copying data when a large binary is sent or returned from the driver to\nan Erlang process, the driver must first allocate the binary and then send it to\nan Erlang process in some way.\n\nUse [`driver_alloc_binary()`](`e:erts:erl_driver.md#driver_alloc_binary`) to\nallocate a binary.\n\nThere are several ways to send a binary created with `driver_alloc_binary()`:\n\n- From the `control` callback, a binary can be returned if\n  [`set_port_control_flags()`](`e:erts:erl_driver.md#set_port_control_flags`) has\n  been called with the flag value `PORT_CONTROL_FLAG_BINARY`.\n- A single binary can be sent with\n  [`driver_output_binary()`](`e:erts:erl_driver.md#driver_output_binary`).\n- Using [`erl_drv_output_term()`](`e:erts:erl_driver.md#erl_drv_output_term`) or\n  [`erl_drv_send_term()`](`e:erts:erl_driver.md#erl_drv_send_term`), a binary can\n  be included in an Erlang term.","title":"Returning Large Binaries without Copying from a Driver - Drivers","ref":"drivers.html#returning-large-binaries-without-copying-from-a-driver"},{"type":"extras","doc":"<!--\n%CopyrightBegin%\n\nCopyright Ericsson AB 2023-2024. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# Memory Usage\n\nA good start when programming efficiently is to know how much memory different\ndata types and operations require. It is implementation-dependent how much\nmemory the Erlang data types and other items consume, but the following table\nshows some figures for the `erts-8.0` system in OTP 19.0.\n\nThe unit of measurement is memory words. There exists both a 32-bit and a 64-bit\nimplementation. A word is therefore 4 bytes or 8 bytes, respectively. The value\nfor a running system can be determined by calling\n[`erlang:system_info(wordsize)`](`m:erlang#system_info_wordsize`).\n\n\n \n \n    Data Type  \n    Memory Size  \n \n \n    Small integer \n    1 word. \n   On 32-bit architectures: -134217729 &lt; i &lt; 134217728\n   (28 bits). \n   On 64-bit architectures: -576460752303423489 &lt; i &lt;\n   576460752303423488 (60 bits). \n \n \n    Large integer \n    At least 3 words. \n \n \n    Atom \n    1 word. \n   An atom refers into an atom table, which also consumes memory.\n   The atom text is stored once for each unique atom in this table.\n   The atom table is  not  garbage-collected. \n \n \n    Float \n    On 32-bit architectures: 4 words. \n   On 64-bit architectures: 3 words. \n \n \n    Binary \n    3-6 words + data (can be shared). \n \n \n    List \n    1 word + 1 word per element + the size of each element. \n \n \n    String \n    (is the same as a list of integers) \n   1 word + 2 words per character.\n    \n \n \n   Tuple \n   2 words + the size of each element. \n \n \n   Small Map \n   (up to 32 keys) \n    5 words + the size of all keys and values. \n \n \n   Large Map \n   \n      (more than 32 keys) \n       N  x  F  words + the size of all keys and values. \n       N  is the number of keys in the Map. \n       F  is a sparsity factor that varies between 1.6 and 1.8\n      due to the probabilistic nature of the internal HAMT data structure.\n   \n \n \n    Pid \n    1 word for a process identifier from the current local node. \n   On 32-bit: 6 words for a process identifier from another node. \n   On 64-bit: 5 words for a process identifier from another node. \n   A process identifier refers into a process table and a node table,\n   which also consumes memory. \n \n \n    Port \n    1 word for a port identifier from the current local node. \n   5 words for a port identifier from another node. \n   A port identifier refers into a port table and a node table,\n   which also consumes memory. \n \n \n    Reference \n    On 32-bit architectures: 4-7 words for a reference from the\n   current local node, and 7-9 words for a reference from another\n   node. \n   On 64-bit architectures: 4-6 words for a reference from the current\n   local node, and 6-7 words for a reference from another node. \n   A reference also refers into more or less emulator internal data\n   structures which also consumes memory. At a minimum it\n   refers into the node tables. \n \n \n    Fun \n    9..13 words + the size of environment. \n   A fun refers into a fun table, which also consumes memory. \n \n \n    Ets table \n    Initially 768 words + the size of each element (6 words +\n   the size of Erlang data). The table grows when necessary. \n \n \n    Erlang process \n    338 words when spawned, including a heap of 233 words. \n \n \n\n_Table: Memory Size of Different Data Types_","title":"Memory Usage","ref":"memory.html"},{"type":"extras","doc":"<!--\n%CopyrightBegin%\n\nCopyright Ericsson AB 2023-2024. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# System Limits\n\nThe Erlang language specification puts no limits on the number of processes,\nlength of atoms, and so on. However, for performance and memory saving reasons,\nthere will always be limits in a practical implementation of the Erlang language\nand execution environment.\n\n- **Processes** - The maximum number of simultaneously alive Erlang processes\nis by default 1,048,576. This limit can be configured at startup. For more information,\nsee the [`+P`](`e:erts:erl_cmd.md#max_processes`) command-line flag\nin the [`erl(1)`](`e:erts:erl_cmd.md`) manual page in ERTS.\n\n- [](){: #unique_pids } **Unique Local Process Identifiers on a\nRuntime System Instance ** - On a 64 bit system at most `2⁶⁰ - 1`\nunique process identifiers can be created, and on a 32 bit system at most `2²⁸ - 1`.\n\n- **Known nodes** - A remote node Y must be known to node X if there exists\nany pids, ports, references, or funs (Erlang data types) from Y on X, or if\nX and Y are connected. The maximum number of remote nodes simultaneously/ever known\nto a node is limited by the [maximum number of atoms](#atoms) available\nfor node names. All data concerning remote nodes, except for the node name atom,\nare garbage-collected.\n\n- **Connected nodes** - The maximum number of simultaneously connected nodes is\nlimited by either the maximum number of simultaneously known remote nodes,\n[the maximum number of (Erlang) ports](#ports) available,\nor [the maximum number of sockets](#files_sockets) available.\n\n- **Characters in an atom** - 255.\n\n- [](){: #atoms } **Atoms** - By default, the maximum number of atoms is 1,048,576.\nThis limit can be raised or lowered using the `+t` option.\n\n- **Elements in a tuple** - The maximum number of elements in a\ntuple is 16,777,215 (24-bit unsigned integer).\n\n- **Size of binary** - In the 32-bit run-time system for Erlang, 536,870,911 bytes\nis the largest binary that can be constructed or matched using the bit syntax.\nIn the 64-bit run-time system, the maximum size is 2,305,843,009,213,693,951 bytes.\nIf the limit is exceeded, bit syntax construction fails with a `system_limit`\nexception, while any attempt to match a binary that is too large\nfails. From Erlang/OTP 27, all other operations that create binaries (such as\n[`list_to_binary/1`](`list_to_binary/1`)) also enforces the same limit.\n\n- **Total amount of data allocated by an Erlang node** - The Erlang runtime system\ncan use the complete 32-bit (or 64-bit) address space, but the operating system\noften limits a single process to use less than that.\n\n- **Length of a node name** - An Erlang node name has the form `host@shortname`\nor `host@longname`. The node name is used as an atom within the system, so the\nmaximum size of 255 holds also for the node name.\n\n- [](){: #ports } **Open ports** - The maximum number of simultaneously open\nErlang ports is often by default 16,384. This limit can be configured at startup.\nFor more information, see the [`+Q`](`e:erts:erl_cmd.md#max_ports`) command-line\nflag in the [`erl(1)`](`e:erts:erl_cmd.md`) manual page in ERTS.\n\n- [](){: #unique_ports } **Unique Local Port Identifiers on a Runtime System Instance** -\nOn a 64 bit system at most `2⁶⁰ - 1` unique port identifiers can be created and\non a 32 bit system at most `2²⁸ - 1`.\n\n- [](){: #files_sockets } **Open files and sockets** - The maximum number of simultaneously\nopen files and sockets depends on [the maximum number of Erlang ports](#ports)\navailable, as well as on operating system-specific settings and limits.\n\n- **Number of arguments to a function or fun** - 255.\n\n- [](){: #unique_references } **Unique References on a Runtime System Instance** -\nEach scheduler thread has its own set of references, and all other threads have\na shared set of references. Each set of references consist of `2⁶⁴ - 1`unique\nreferences. That is, the total amount of unique references that can be produced\non a runtime system instance is `(NumSchedulers + 1) × (2⁶⁴ - 1)`. If a scheduler\nthread create a new reference each nano second, references will at earliest be\nreused after more than 584 years. That is, for the foreseeable future they are\nsufficiently unique.\n\n- [](){: #unique_integers } **Unique Integers on a Runtime System Instance** -\n  There are two types of unique integers created by the\n  [erlang:unique_integer/1](`erlang:unique_integer/1`) BIF:\n  - Unique integers created **with** the `monotonic` modifier consist of\n    a set of `2⁶⁴ - 1` unique integers.\n  - Unique integers created **without** the `monotonic` modifier consist\n    of a set of `2⁶⁴ - 1` unique integers per scheduler thread and a\n    set of `2⁶⁴ - 1` unique integers shared by other threads. That is,\n    the total amount of unique integers without the `monotonic`\n    modifier is `(NumSchedulers + 1) × (2⁶⁴ - 1)`.\n\n  If a unique integer  is created each nano second, unique integers will be\n  reused at earliest after more than 584 years. That is, for the foreseeable future\n  they are sufficiently unique.\n\n- ** Timer resolution ** - On most systems, millisecond resolution. For more\n  information, see the [*Timers*](`e:erts:time_correction.md#timers`) section of\n  the [*Time and Time Correction in Erlang*](`e:erts:time_correction.md`) ERTS\n  User's guide.","title":"System Limits","ref":"system_limits.html"},{"type":"extras","doc":"<!--\n%CopyrightBegin%\n\nCopyright Ericsson AB 2023-2024. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# Profiling","title":"Profiling","ref":"profiling.html"},{"type":"extras","doc":"Even experienced software developers often guess wrong about where the\nperformance bottlenecks are in their programs. Therefore, profile your program\nto see where the performance bottlenecks are and concentrate on optimizing them.\n\nErlang/OTP contains several tools to help finding bottlenecks:\n\n- `m:tprof` is a tracing profiler that can measure call count, call time, or\n  heap allocations per function call.\n- `m:fprof` provides the most detailed information about where the program time\n  is spent, but it significantly slows down the program it profiles.\n- `m:dbg` is the generic erlang tracing frontend. By using the `timestamp` or\n  `cpu_timestamp` options it can be used to time how long function calls in a\n  live system take.\n- `m:lcnt` is used to find contention points in the Erlang Run-Time System's\n  internal locking mechanisms. It is useful when looking for bottlenecks in\n  interaction between process, port, ETS tables, and other entities that can be\n  run in parallel.\n\nThe tools are further described in [Tools](profiling.md#profiling_tools).\n\nThere are also several open source tools outside of Erlang/OTP that can be used\nto help profiling. Some of them are:\n\n- [erlgrind](https://github.com/isacssouza/erlgrind) can be used to visualize\n  fprof data in kcachegrind.\n- [eflame](https://github.com/proger/eflame) is an alternative to fprof that\n  displays the profiling output as a flamegraph.\n- [recon](https://ferd.github.io/recon/index.html) is a collection of Erlang\n  profiling and debugging tools. This tool comes with an accompanying E-book\n  called [Erlang in Anger](https://www.erlang-in-anger.com/).\n- [perf](https://perf.wiki.kernel.org/index.php/Main_Page) is a sampling\n  profiler for Linux that provides functionality similar to `fprof` but with\n  much lower overhead. Profiling Erlang code is possible when the emulator has\n  been started with the `+JPperf true` emulator flag, and is only available when\n  the JIT is enabled.\n\n  For more details about how to run `perf` see the\n  [perf support](`e:erts:beamasm.md#linux-perf-support`) section in the BeamAsm\n  internal documentation.","title":"Never Guess About Performance Bottlenecks - Profiling","ref":"profiling.html#never-guess-about-performance-bottlenecks"},{"type":"extras","doc":"```text\neheap_alloc: Cannot allocate 1234567890 bytes of memory (of type \"heap\").\n```\n\nThe above slogan is one of the more common reasons for Erlang to terminate. For\nunknown reasons the Erlang Run-Time System failed to allocate memory to use.\nWhen this happens a crash dump is generated that contains information about the\nstate of the system as it ran out of memory. Use\n[`crashdump_viewer`](`e:observer:cdv_cmd.md`) to get a view of the memory being\nused. Look for processes with large heaps or many messages, large ETS tables,\nand so on.\n\nWhen looking at memory usage in a running system the most basic function to get\ninformation from is [`erlang:memory()`](`erlang:memory/0`). It returns the\ncurrent memory usage of the system. `m:instrument` can be used to get a more\ndetailed breakdown of where memory is used.\n\nProcesses, ports, and ETS tables can then be inspected using their respective\ninformation functions, that is,\n[`process_info/2`](`m:erlang#process_info_memory`),\n[`erlang:port_info/2 `](`m:erlang#port_info_memory`), and `ets:info/1`.\n\nSometimes the system can enter a state where the reported memory from\n`erlang:memory(total)` is very different from the memory reported by\nthe operating system. One reason for that is internal fragmentation\nwithin the Erlang run-time system.  Data about how memory is allocated\ncan be retrieved using\n[`erlang:system_info(allocator)`](`m:erlang#system_info_allocator`). The\ndata you get from that function is raw and hard to read.\n[recon_alloc](http://ferd.github.io/recon/recon_alloc.html) can\nbe used to extract useful information from system_info statistics\ncounters.","title":"Memory profiling - Profiling","ref":"profiling.html#memory-profiling"},{"type":"extras","doc":"For a large system, it can be interesting to run profiling on a simulated and\nlimited scenario to start with. But bottlenecks have a tendency to appear or\ncause problems only when many things are going on at the same time, and when\nmany nodes are involved. Therefore, it is also desirable to run profiling in a\nsystem test plant on a real target system.\n\nFor a large system, you do not want to run the profiling tools on the whole\nsystem. Instead you want to concentrate on central processes and modules, which\naccount for a big part of the execution.\n\nThere are also some tools that can be used to get a view of the whole system\nwith more or less overhead.\n\n- `m:observer` is a GUI tool that can connect to remote nodes and display a\n  variety of information about the running system.\n- `m:etop` is a command line tool that can connect to remote nodes and display\n  information similar to what the UNIX tool top shows.\n- `m:msacc` allows the user to get a view of what the Erlang Run-Time system is\n  spending its time doing. Has a very low overhead, which makes it useful to run\n  in heavily loaded systems to get some idea of where to start doing more\n  granular profiling.","title":"Large Systems - Profiling","ref":"profiling.html#large-systems"},{"type":"extras","doc":"When analyzing the result file from the profiling activity, look for functions\nthat are called many times and have a long \"own\" execution time (time excluding\ncalls to other functions). Functions that are called a lot of times can also be\ninteresting, as even small things can add up to quite a bit if repeated often.\nAlso ask yourself what you can do to reduce this time. The following are\nappropriate types of questions to ask yourself:\n\n- Is it possible to reduce the number of times the function is called?\n- Can any test be run less often if the order of tests is changed?\n- Can any redundant tests be removed?\n- Does any calculated expression give the same result each time?\n- Are there other ways to do this that are equivalent and more efficient?\n- Can another internal data representation be used to make things more\n  efficient?\n\nThese questions are not always trivial to answer. Some benchmarks might be\nneeded to back up your theory and to avoid making things slower if your theory\nis wrong. For details, see [Benchmarking](benchmarking.md).","title":"What to Look For - Profiling","ref":"profiling.html#what-to-look-for"},{"type":"extras","doc":"[](){: #profiling_tools }","title":"Tools - Profiling","ref":"profiling.html#tools"},{"type":"extras","doc":"`fprof` measures the execution time for each function, both own time, that is,\nhow much time a function has used for its own execution, and accumulated time,\nthat is, including called functions. The values are displayed per process. You\nalso get to know how many times each function has been called.\n\n`fprof` is based on trace to file to minimize runtime performance impact. Using\n`fprof` is just a matter of calling a few library functions, see the `m:fprof`\nmanual page in Tools.","title":"fprof - Profiling","ref":"profiling.html#fprof"},{"type":"extras","doc":"`eprof` is based on the Erlang `trace_info` BIFs. `eprof` shows how much time\nhas been used by each process, and in which function calls this time has been\nspent. Time is shown as a percentage of total time and absolute time. For more\ninformation, see the `m:eprof` manual page in Tools.","title":"eprof - Profiling","ref":"profiling.html#eprof"},{"type":"extras","doc":"`cprof` is something in between `fprof` and `cover` regarding features. It\ncounts how many times each function is called when the program is run, on a per\nmodule basis. `cprof` has a low performance degradation effect (compared with\n`fprof`) and does not need to recompile any modules to profile (compared with\n`cover`). For more information, see the `m:cprof` manual page in Tools.","title":"cprof - Profiling","ref":"profiling.html#cprof"},{"type":"extras","doc":"| _Tool_  | _Results_                           | _Size of Result_ | _Effects on Program Execution Time_ | _Records Number of Calls_ | _Records Execution Time_ | _Records Called by_ | _Records Garbage Collection_ |\n| ------- | ----------------------------------- | ---------------- | ----------------------------------- | ------------------------- | ------------------------ | ------------------- | ---------------------------- |\n| `fprof` | Per process to screen/file          | Large            | Significant slowdown                | Yes                       | Total and own            | Yes                 | Yes                          |\n| `eprof` | Per process/function to screen/file | Medium           | Small slowdown                      | Yes                       | Only total               | No                  | No                           |\n| `cprof` | Per module to caller                | Small            | Small slowdown                      | Yes                       | No                       | No                  | No                           |\n\n_Table: Tool Summary_","title":"Tool Summary - Profiling","ref":"profiling.html#tool-summary"},{"type":"extras","doc":"`dbg` is a generic Erlang trace tool. By using the `timestamp` or\n`cpu_timestamp` options it can be used as a precision instrument to profile how\nlong time a function call takes for a specific process. This can be very useful\nwhen trying to understand where time is spent in a heavily loaded system as it\nis possible to limit the scope of what is profiled to be very small. For more\ninformation, see the `m:dbg` manual page in Runtime Tools.","title":"dbg - Profiling","ref":"profiling.html#dbg"},{"type":"extras","doc":"`lcnt` is used to profile interactions in between entities that run in parallel.\nFor example if you have a process that all other processes in the system needs\nto interact with (maybe it has some global configuration), then `lcnt` can be\nused to figure out if the interaction with that process is a problem.\n\nIn the Erlang Run-time System entities are only run in parallel when there are\nmultiple schedulers. Therefore `lcnt` will show more contention points (and thus\nbe more useful) on systems using many schedulers on many cores.\n\nFor more information, see the `m:lcnt` manual page in Tools.","title":"lcnt - Profiling","ref":"profiling.html#lcnt"},{"type":"extras","doc":"<!--\n%CopyrightBegin%\n\nCopyright Ericsson AB 2023-2024. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# Benchmarking\n\nThe main purpose of benchmarking is to find out which implementation of a given\nalgorithm or function is the fastest. Benchmarking is far from an exact science.\nToday's operating systems generally run background tasks that are difficult to\nturn off. Caches and multiple CPU cores do not facilitate benchmarking. It would\nbe best to run UNIX computers in single-user mode when benchmarking, but that is\ninconvenient to say the least for casual testing.","title":"Benchmarking","ref":"benchmarking.html"},{"type":"extras","doc":"A useful tool for benchmarking is [erlperf](https://github.com/max-au/erlperf)\n([documentation](https://hexdocs.pm/erlperf/erlperf.html)).\nIt makes it simple to find out which code is faster. For example, here is how\ntwo methods of generating random bytes can be compared:\n\n```text\n% erlperf 'rand:bytes(2).' 'crypto:strong_rand_bytes(2).'\nCode                                 ||        QPS       Time   Rel\nrand:bytes(2).                        1    7784 Ki     128 ns  100%\ncrypto:strong_rand_bytes(2).          1    2286 Ki     437 ns   29%\n```\n\nFrom the **Time** column we can read out that on average a call to\n[`rand:bytes(2)`](`rand:bytes/1`) executes in 128 nano seconds, while\na call to\n[`crypto:strong_rand_bytes(2)`](`crypto:strong_rand_bytes/1`) executes\nin 437 nano seconds.\n\nFrom the **QPS** column we can read out how many calls that can be\nmade in a second. For `rand:bytes(2)`, it is 7,784,000 calls per second.\n\nThe **Rel** column shows the relative differences, with `100%` indicating\nthe fastest code.\n\nWhen generating two random bytes at the time, `rand:bytes/1` is more\nthan three times faster than `crypto:strong_rand_bytes/1`. Assuming\nthat we really need strong random numbers and we need to get them as\nfast as possible, what can we do? One way could be to generate more\nthan two bytes at the time.\n\n```text\n% erlperf 'rand:bytes(100).' 'crypto:strong_rand_bytes(100).'\nCode                                   ||        QPS       Time   Rel\nrand:bytes(100).                        1    2124 Ki     470 ns  100%\ncrypto:strong_rand_bytes(100).          1    1915 Ki     522 ns   90%\n```\n\n`rand:bytes/1` is still faster when we generate 100 bytes at the time,\nbut the relative difference is smaller.\n\n```\n% erlperf 'rand:bytes(1000).' 'crypto:strong_rand_bytes(1000).'\nCode                                    ||        QPS       Time   Rel\ncrypto:strong_rand_bytes(1000).          1    1518 Ki     658 ns  100%\nrand:bytes(1000).                        1     284 Ki    3521 ns   19%\n```\n\nWhen we generate 1000 bytes at the time, `crypto:strong_rand_bytes/1` is\nnow the fastest.","title":"Using erlperf - Benchmarking","ref":"benchmarking.html#using-erlperf"},{"type":"extras","doc":"Benchmarks can measure wall-clock time or CPU time.\n\n- `timer:tc/3` measures wall-clock time. The advantage with wall-clock time is\n  that I/O, swapping, and other activities in the operating system kernel are\n  included in the measurements. The disadvantage is that the measurements often\n  vary a lot. Usually it is best to run the benchmark several times and note\n  the shortest time, which is the minimum time that is possible to achieve\n  under the best of circumstances.\n\n- [`statistics(runtime)`](`erlang:statistics/1`) measures CPU time spent\n  in the Erlang virtual machine. The advantage with CPU time is that\n  the results are more consistent from run to run. The disadvantage is\n  that the time spent in the operating system kernel (such as swapping\n  and I/O) is not included. Therefore, measuring CPU time is\n  misleading if any I/O (file or socket) is involved.\n\nIt is probably a good idea to do both wall-clock measurements and CPU time\nmeasurements.\n\nSome final advice:\n\n- The granularity of both measurement types can be high. Therefore, ensure that\n  each individual measurement lasts for at least several seconds.\n- To make the test fair, each new test run is to run in its own, newly created\n  Erlang process. Otherwise, if all tests run in the same process, the later\n  tests start out with larger heap sizes and therefore probably do fewer garbage\n  collections. Also consider restarting the Erlang emulator between each test.\n- Do not assume that the fastest implementation of a given algorithm on computer\n  architecture X is also the fastest on computer architecture Y.","title":"Benchmarking using Erlang/OTP functionality - Benchmarking","ref":"benchmarking.html#benchmarking-using-erlang-otp-functionality"},{"type":"extras","doc":"<!--\n%CopyrightBegin%\n\nCopyright Ericsson AB 2023-2024. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# Introduction\n\n[](){: #interoperability-tutorial }\n\nThis section informs on interoperability, that is, information exchange, between\nErlang and other programming languages. The included examples mainly treat\ninteroperability between Erlang and C.","title":"Introduction","ref":"tutorial.html"},{"type":"extras","doc":"The purpose of this tutorial is to describe different interoperability\nmechanisms that can be used when integrating a program written in Erlang with a\nprogram written in another programming language, from the Erlang programmer's\nperspective.","title":"Purpose - Introduction","ref":"tutorial.html#purpose"},{"type":"extras","doc":"It is assumed that you are a skilled Erlang programmer, familiar with concepts\nsuch as Erlang data types, processes, messages, and error handling.\n\nTo illustrate the interoperability principles, C programs running in a UNIX\nenvironment have been used. It is assumed that you have enough knowledge to\napply these principles to the relevant programming languages and platforms.\n\n> #### Note {: .info }\n>\n> For readability, the example code is kept as simple as possible. For example,\n> it does not include error handling, which might be vital in a real-life\n> system.","title":"Prerequisites - Introduction","ref":"tutorial.html#prerequisites"},{"type":"extras","doc":"<!--\n%CopyrightBegin%\n\nCopyright Ericsson AB 2023-2024. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# Overview","title":"Overview","ref":"overview.html"},{"type":"extras","doc":"Two interoperability mechanisms are built into the Erlang runtime system,\n_distributed Erlang_, _ports_, and _nifs_. A variation of ports is _linked-in drivers_.","title":"Built-In Mechanisms - Overview","ref":"overview.html#built-in-mechanisms"},{"type":"extras","doc":"An Erlang runtime system is made a distributed Erlang node by giving it a name.\nA distributed Erlang node can connect to, and monitor, other nodes. It can also\nspawn processes at other nodes. Message passing and error handling between\nprocesses at different nodes are transparent. A number of useful STDLIB modules\nare available in a distributed Erlang system. For example, `m:global`, which\nprovides global name registration. The distribution mechanism is implemented\nusing TCP/IP sockets.\n\n_When to use:_ Distributed Erlang is primarily used for Erlang-Erlang\ncommunication. It can also be used for communication between Erlang and C, if\nthe C program is implemented as a C node, see\n[C and Java Libraries](overview.md#c-nodes).\n\n_Where to read more:_ Distributed Erlang and some distributed programming\ntechniques are described in the Erlang book.\n\nFor more information, see\n[Distributed Programming](`e:system:conc_prog.md#distributed-programming`).\n\nRelevant manual pages are the following:\n\n- `m:erlang` manual page in ERTS (describes the BIFs)\n- `m:global` manual page in Kernel\n- `m:net_adm` manual page in Kernel\n- `m:pg` manual page in Kernel\n- `m:rpc` manual page in Kernel\n- `m:pool` manual page in STDLIB\n- `m:slave` manual page in STDLIB","title":"Distributed Erlang - Overview","ref":"overview.html#distributed-erlang"},{"type":"extras","doc":"Ports provide the basic mechanism for communication with the external world,\nfrom Erlang's point of view. The ports provide a byte-oriented interface to an\nexternal program. When a port is created, Erlang can communicate with it by\nsending and receiving [lists of bytes](`t:iolist/0`) or [binaries](`t:binary/0`) (not Erlang terms).\nThis means that the programmer might have to invent a suitable encoding and decoding scheme.\n\nThe implementation of the port mechanism depends on the platform. For UNIX,\npipes are used and the external program is assumed to read from standard input\nand write to standard output. The external program can be written in any\nprogramming language as long as it can handle the interprocess communication\nmechanism with which the port is implemented.\n\nThe external program resides in another OS process than the Erlang runtime\nsystem. In some cases this is not acceptable. Consider, for example, drivers\nwith very hard time requirements. It is therefore possible to write a program in\nC according to certain principles, and dynamically link it to the Erlang runtime\nsystem. This is called a _linked-in driver_.\n\n_When to use:_ Ports can be used for all kinds of interoperability situations\nwhere the Erlang program and the other program runs on the same machine.\nProgramming is fairly straight-forward.\n\nLinked-in drivers involves writing certain call-back functions in C. This\nrequires very good skills as the code is linked to the Erlang runtime system.\nIt is recommended to use [NIFs](#native-implemented-functions-nifs)\ninstead of linked-in drivers as they provide a richer feature set and can use\n[dirty schedulers for lengthy work](`e:erts:erl_nif.md#dirty_nifs`).\n\n> #### Warning {: .warning }\n>\n> A faulty linked-in driver causes the entire Erlang runtime system to leak\n> memory, hang, or crash.\n\n_Where to read more:_ Ports are described in section \"Miscellaneous Items\" of\nthe Erlang book. Linked-in drivers are described in Appendix E.\n\nThe BIF [`open_port/2`](`open_port/2`) is documented in the `m:erlang` manual\npage in ERTS.\n\nFor linked-in drivers, the programmer needs to read the `m:erl_ddll` manual page\nin Kernel.\n\n_Examples:_ Port example in [Ports](c_port.md).","title":"Ports and Linked-In Drivers - Overview","ref":"overview.html#ports-and-linked-in-drivers"},{"type":"extras","doc":"NIFs provide an alternative to a port using linked-in drivers to link C code into\nthe Erlang runtime system. NIFs make it possible to provide C implementation of\nnormal Erlang functions when interacting with the OS or some other external library.\n\n> #### Warning {: .warning }\n>\n> A faulty NIFs causes the entire Erlang runtime system to leak\n> memory, hang, crash, or leak sensitive information.\n\n_When to use:_ Since a faulty NIF can cause many different problems related to both\nstability and security it is recommended to use an external Port if possible. If the\noverhead is not acceptable then a NIF is a good solution for interacting with any\nnative code, be it in C, C++ or Rust.\n\n_Where to read more:_ NIFs are described in [API functions for an Erlang NIF library](`e:erts:erl_nif.md`).\n\n_Examples:_ Port example in [NIFs](nif.md).","title":"Native implemented functions (Nifs) - Overview","ref":"overview.html#native-implemented-functions-nifs"},{"type":"extras","doc":"","title":"C and Java Libraries - Overview","ref":"overview.html#c-and-java-libraries"},{"type":"extras","doc":"The program at the other side of a port is often a C program. To help the C\nprogrammer, the Erl_Interface library has been developed\n\nThe Erlang external term format is a representation of an Erlang term as a\nsequence of bytes, that is, a binary. Conversion between the two representations\nis done using the following BIFs:\n\n```text\nBinary = term_to_binary(Term)\nTerm = binary_to_term(Binary)\n```\n\nA port can be set to use binaries instead of lists of bytes. It is then not\nnecessary to invent any encoding/decoding scheme. Erl_Interface functions are\nused for unpacking the binary and convert it into a struct similar to an Erlang\nterm. Such a struct can be manipulated in different ways, be converted to the\nErlang external format, and sent to Erlang.\n\n_When to use:_ In C code, in conjunction with Erlang binaries.\n\n_Where to read more:_ See the Erlang Interface User's Guide, Command Reference,\nand Library Reference. In Erlang/OTP R5B, and earlier versions, the information\nis part of the Kernel application.\n\n_Examples:_ Erl_Interface example in [Erl_Interface](erl_interface.md).","title":"Erl_Interface - Overview","ref":"overview.html#erl_interface"},{"type":"extras","doc":"A C program that uses the Erl_Interface functions for setting up a connection\nto, and communicating with, a distributed Erlang node is called a _C node_, or a\n_hidden node_. The main advantage with a C node is that the communication from\nthe Erlang programmer's perspective is extremely easy, as the C program behaves\nas a distributed Erlang node.\n\n_When to use:_ C nodes can typically be used on device processors (as opposed to\ncontrol processors) where C is a better choice than Erlang due to memory\nlimitations or application characteristics, or both.\n\n_Where to read more:_ See the `ei_connect` part of the\n[Erl_Interface](erl_interface.md) documentation. The programmer also needs to be\nfamiliar with TCP/IP sockets, see Sockets in\n[Standard Protocols](overview.md#sockets) and Distributed Erlang in\n[Built-In Mechanisms](overview.md#distributed-erlang).\n\n_Example:_ C node example in [C Nodes](cnode.md).","title":"C Nodes - Overview","ref":"overview.html#c-nodes"},{"type":"extras","doc":"In Erlang/OTP R6B, a library similar to Erl_Interface for Java was added called\n_jinterface_. It provides a tool for Java programs to communicate with Erlang\nnodes.","title":"Jinterface - Overview","ref":"overview.html#jinterface"},{"type":"extras","doc":"Sometimes communication between an Erlang program and another program using a\nstandard protocol is desirable. Erlang/OTP currently supports TCP/IP and UDP\n_sockets_: as follows:\n\n- SNMP\n- HTTP\n- IIOP (CORBA)\n\nUsing one of the latter three requires good knowledge about the protocol and is\nnot covered by this tutorial. See the SNMP, Inets, and Orber applications,\nrespectively.","title":"Standard Protocols - Overview","ref":"overview.html#standard-protocols"},{"type":"extras","doc":"Simply put, connection-oriented socket communication (TCP/IP) consists of an\ninitiator socket (\"server\") started at a certain host with a certain port\nnumber. A connector socket (\"client\"), which is aware of the initiator host name\nand port number, can connect to it and data can be sent between them.\n\nConnection-less socket communication (UDP) consists of an initiator socket at a\ncertain host with a certain port number and a connector socket sending data to\nit.\n\nFor a detailed description of the socket concept, refer to a suitable book about\nnetwork programming. A suggestion is _UNIX Network Programming, Volume 1:\nNetworking APIs - Sockets and XTI_ by W. Richard Stevens, ISBN: 013490012X.\n\nIn Erlang/OTP, access to TCP/IP and UDP sockets is provided by the modules\n`gen_tcp` and `gen_udp` in Kernel. Both are easy to use and do not require\ndetailed knowledge about the socket concept.\n\n_When to use:_ For programs running on the same or on another machine than the\nErlang program.\n\n_Where to read more:_ See the `m:gen_tcp` and the `m:gen_udp` manual pages in\nKernel.","title":"Sockets - Overview","ref":"overview.html#sockets"},{"type":"extras","doc":"IC (Erlang IDL Compiler) is an interface generator that, given an IDL interface\nspecification, automatically generates stub code in Erlang, C, or Java. See the\nIC User's Guide and IC Reference Manual.\n\nFor details, see the [corba repository](https://github.com/erlang/corba).","title":"IC and CORBA - Overview","ref":"overview.html#ic-and-corba"},{"type":"extras","doc":"<!--\n%CopyrightBegin%\n\nCopyright Ericsson AB 2023-2024. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# Problem Example","title":"Problem Example","ref":"example.html"},{"type":"extras","doc":"A common interoperability situation is when you want to incorporate a piece of\ncode, solving a complex problem, in your Erlang program. Suppose for example,\nthat you have the following C functions that you would like to call from Erlang:\n\n```c\n/* complex.c */\n\nint foo(int x) {\n  return x+1;\n}\n\nint bar(int y) {\n  return y*2;\n}\n```\n\nThe functions are deliberately kept as simple as possible, for readability\nreasons.\n\nFrom an Erlang perspective, it is preferable to be able to call `foo` and `bar`\nwithout having to bother about that they are C functions:\n\n```erlang\n% Erlang code\n...\nRes = complex:foo(X),\n...\n```\n\nHere, the communication with C is hidden in the implementation of `complex.erl`.\nIn the following sections, it is shown how this module can be implemented using\nthe different interoperability mechanisms.","title":"Description - Problem Example","ref":"example.html#description"},{"type":"extras","doc":"<!--\n%CopyrightBegin%\n\nCopyright Ericsson AB 2023-2024. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# Ports\n\nThis section outlines an example of how to solve the example problem in the\n[previous section](example.md) by using a port.\n\nThe scenario is illustrated in the following figure:\n\n```mermaid\n---\ntitle: Port Communication\n---\nflowchart LR\n    subgraph Legend\n        direction LR\n\n        os[OS Process]\n        erl([Erlang Process])\n    end\n\n    subgraph ERTS\n        direction LR\n\n        port{Port} --> erlProc\n        erlProc([Connected process]) --> port\n    end\n\n    port --> proc[External Program]\n    proc --> port\n```","title":"Ports","ref":"c_port.html"},{"type":"extras","doc":"All communication between Erlang and C must be established by creating the port.\nThe Erlang process that creates a port is said to be _the connected process_ of\nthe port. All communication to and from the port must go through the connected\nprocess. If the connected process terminates, the port also terminates (and the\nexternal program, if it is written properly).\n\nThe port is created using the BIF [`open_port/2`](`open_port/2`) with\n`{spawn,ExtPrg}` as the first argument. The string `ExtPrg` is the name of the\nexternal program, including any command line arguments. The second argument is a\nlist of options, in this case only `{packet,2}`. This option says that a 2 byte\nlength indicator is to be used to simplify the communication between C and\nErlang. The Erlang port automatically adds the length indicator, but this must\nbe done explicitly in the external C program.\n\nThe process is also set to trap exits, which enables detection of failure of the\nexternal program:\n\n```erlang\n-module(complex1).\n-export([start/1, init/1]).\n\nstart(ExtPrg) ->\n  spawn(?MODULE, init, [ExtPrg]).\n\ninit(ExtPrg) ->\n  register(complex, self()),\n  process_flag(trap_exit, true),\n  Port = open_port({spawn, ExtPrg}, [{packet, 2}]),\n  loop(Port).\n```\n\nNow `complex1:foo/1` and `complex1:bar/1` can be implemented. Both send a\nmessage to the `complex` process and receive the following replies:\n\n```erlang\nfoo(X) ->\n  call_port({foo, X}).\nbar(Y) ->\n  call_port({bar, Y}).\n\ncall_port(Msg) ->\n  complex ! {call, self(), Msg},\n  receive\n    {complex, Result} ->\n      Result\n  end.\n```\n\nThe `complex` process does the following:\n\n- Encodes the message into a sequence of bytes.\n- Sends it to the port.\n- Waits for a reply.\n- Decodes the reply.\n- Sends it back to the caller:\n\n```erlang\nloop(Port) ->\n  receive\n    {call, Caller, Msg} ->\n      Port ! {self(), {command, encode(Msg)}},\n      receive\n        {Port, {data, Data}} ->\n          Caller ! {complex, decode(Data)}\n      end,\n      loop(Port)\n  end.\n```\n\nAssuming that both the arguments and the results from the C functions are less\nthan 256, a simple encoding/decoding scheme is employed. In this scheme, `foo`\nis represented by byte 1, `bar` is represented by 2, and the argument/result is\nrepresented by a single byte as well:\n\n```erlang\nencode({foo, X}) -> [1, X];\nencode({bar, Y}) -> [2, Y].\n\ndecode([Int]) -> Int.\n```\n\nThe resulting Erlang program, including functionality for stopping the port and\ndetecting port failures, is as follows:\n\n```erlang\n-module(complex1).\n-export([start/1, stop/0, init/1]).\n-export([foo/1, bar/1]).\n\nstart(ExtPrg) ->\n    spawn(?MODULE, init, [ExtPrg]).\nstop() ->\n    complex ! stop.\n\nfoo(X) ->\n    call_port({foo, X}).\nbar(Y) ->\n    call_port({bar, Y}).\n\ncall_port(Msg) ->\n    complex ! {call, self(), Msg},\n    receive\n\t{complex, Result} ->\n\t    Result\n    end.\n\ninit(ExtPrg) ->\n    register(complex, self()),\n    process_flag(trap_exit, true),\n    Port = open_port({spawn, ExtPrg}, [{packet, 2}]),\n    loop(Port).\n\nloop(Port) ->\n    receive\n\t{call, Caller, Msg} ->\n\t    Port ! {self(), {command, encode(Msg)}},\n\t    receive\n\t\t{Port, {data, Data}} ->\n\t\t    Caller ! {complex, decode(Data)}\n\t    end,\n\t    loop(Port);\n\tstop ->\n\t    Port ! {self(), close},\n\t    receive\n\t\t{Port, closed} ->\n\t\t    exit(normal)\n\t    end;\n\t{'EXIT', Port, Reason} ->\n\t    exit(port_terminated)\n    end.\n\nencode({foo, X}) -> [1, X];\nencode({bar, Y}) -> [2, Y].\n\ndecode([Int]) -> Int.\n```","title":"Erlang Program - Ports","ref":"c_port.html#erlang-program"},{"type":"extras","doc":"On the C side, it is necessary to write functions for receiving and sending data\nwith 2 byte length indicators from/to Erlang. By default, the C program is to\nread from standard input (file descriptor 0) and write to standard output (file\ndescriptor 1). Examples of such functions, `read_cmd/1` and `write_cmd/2`,\nfollows:\n\n```c\n/* erl_comm.c */\n\n#include  \n#include  \n\ntypedef unsigned char byte;\n\nint read_exact(byte *buf, int len)\n{\n  int i, got=0;\n\n  do {\n      if ((i = read(0, buf+got, len-got)) <= 0){\n          return(i);\n      }\n    got += i;\n  } while (got > 8) & 0xff;\n  write_exact(&li, 1);\n\n  li = len & 0xff;\n  write_exact(&li, 1);\n\n  return write_exact(buf, len);\n}\n```\n\nNotice that `stdin` and `stdout` are for buffered input/output and must _not_ be\nused for the communication with Erlang.\n\nIn the `main` function, the C program is to listen for a message from Erlang\nand, according to the selected encoding/decoding scheme, use the first byte to\ndetermine which function to call and the second byte as argument to the\nfunction. The result of calling the function is then to be sent back to Erlang:\n\n```c\n/* port.c */\n\ntypedef unsigned char byte;\n\nint main() {\n  int fn, arg, res;\n  byte buf[100];\n\n  while (read_cmd(buf) > 0) {\n    fn = buf[0];\n    arg = buf[1];\n\n    if (fn == 1) {\n      res = foo(arg);\n    } else if (fn == 2) {\n      res = bar(arg);\n    }\n\n    buf[0] = res;\n    write_cmd(buf, 1);\n  }\n}\n```\n\nNotice that the C program is in a `while`\\-loop, checking for the return value\nof `read_cmd/1`. This is because the C program must detect when the port closes\nand terminates.","title":"C Program - Ports","ref":"c_port.html#c-program"},{"type":"extras","doc":"_Step 1._ Compile the C code:\n\n```text\n$ gcc -o extprg complex.c erl_comm.c port.c\n```\n\n_Step 2._ Start Erlang and compile the Erlang code:\n\n```erlang\n$ erl\nErlang/OTP 26 [erts-14.2] [source] [64-bit] [smp:8:8] [ds:8:8:10] [async-threads:1] [jit:ns]\n\nEshell V14.2 (press Ctrl+G to abort, type help(). for help)\n1> c(complex1).\n{ok,complex1}\n```\n\n_Step 3._ Run the example:\n\n```erlang\n2> complex1:start(\"./extprg\").\n<0.34.0>\n3> complex1:foo(3).\n4\n4> complex1:bar(5).\n10\n5> complex1:stop().\nstop\n```","title":"Running the Example - Ports","ref":"c_port.html#running-the-example"},{"type":"extras","doc":"<!--\n%CopyrightBegin%\n\nCopyright Ericsson AB 2023-2024. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# Erl_Interface\n\nThis section outlines an example of how to solve the example problem in\n[Problem Example](example.md) by using a port and Erl_Interface. It is necessary\nto read the port example in [Ports](c_port.md) before reading this section.","title":"Erl_Interface","ref":"erl_interface.html"},{"type":"extras","doc":"The following example shows an Erlang program communicating with a C program\nover a plain port with home made encoding:\n\n```erlang\n-module(complex1).\n-export([start/1, stop/0, init/1]).\n-export([foo/1, bar/1]).\n\nstart(ExtPrg) ->\n    spawn(?MODULE, init, [ExtPrg]).\nstop() ->\n    complex ! stop.\n\nfoo(X) ->\n    call_port({foo, X}).\nbar(Y) ->\n    call_port({bar, Y}).\n\ncall_port(Msg) ->\n    complex ! {call, self(), Msg},\n    receive\n\t{complex, Result} ->\n\t    Result\n    end.\n\ninit(ExtPrg) ->\n    register(complex, self()),\n    process_flag(trap_exit, true),\n    Port = open_port({spawn, ExtPrg}, [{packet, 2}]),\n    loop(Port).\n\nloop(Port) ->\n    receive\n\t{call, Caller, Msg} ->\n\t    Port ! {self(), {command, encode(Msg)}},\n\t    receive\n\t\t{Port, {data, Data}} ->\n\t\t    Caller ! {complex, decode(Data)}\n\t    end,\n\t    loop(Port);\n\tstop ->\n\t    Port ! {self(), close},\n\t    receive\n\t\t{Port, closed} ->\n\t\t    exit(normal)\n\t    end;\n\t{'EXIT', Port, Reason} ->\n\t    exit(port_terminated)\n    end.\n\nencode({foo, X}) -> [1, X];\nencode({bar, Y}) -> [2, Y].\n\ndecode([Int]) -> Int.\n```\n\nThere are two differences when using Erl_Interface on the C side compared to the\nexample in [Ports](c_port.md), using only the plain port:\n\n- As Erl_Interface operates on the Erlang external term format, the port must be\n  set to use binaries.\n- Instead of inventing an encoding/decoding scheme, the\n  [`term_to_binary/1`](`term_to_binary/1`) and\n  [`binary_to_term/1`](`binary_to_term/1`) BIFs are to be used.\n\nThat is:\n\n```erlang\nopen_port({spawn, ExtPrg}, [{packet, 2}])\n```\n\nis replaced with:\n\n```erlang\nopen_port({spawn, ExtPrg}, [{packet, 2}, binary])\n```\n\nAnd:\n\n```erlang\nPort ! {self(), {command, encode(Msg)}},\nreceive\n  {Port, {data, Data}} ->\n    Caller ! {complex, decode(Data)}\nend\n```\n\nis replaced with:\n\n```erlang\nPort ! {self(), {command, term_to_binary(Msg)}},\nreceive\n  {Port, {data, Data}} ->\n    Caller ! {complex, binary_to_term(Data)}\nend\n```\n\nThe resulting Erlang program is as follows:\n\n```erlang\n-module(complex2).\n-export([start/1, stop/0, init/1]).\n-export([foo/1, bar/1]).\n\nstart(ExtPrg) ->\n    spawn(?MODULE, init, [ExtPrg]).\nstop() ->\n    complex ! stop.\n\nfoo(X) ->\n    call_port({foo, X}).\nbar(Y) ->\n    call_port({bar, Y}).\n\ncall_port(Msg) ->\n    complex ! {call, self(), Msg},\n    receive\n\t{complex, Result} ->\n\t    Result\n    end.\n\ninit(ExtPrg) ->\n    register(complex, self()),\n    process_flag(trap_exit, true),\n    Port = open_port({spawn, ExtPrg}, [{packet, 2}, binary]),\n    loop(Port).\n\nloop(Port) ->\n    receive\n\t{call, Caller, Msg} ->\n\t    Port ! {self(), {command, term_to_binary(Msg)}},\n\t    receive\n\t\t{Port, {data, Data}} ->\n\t\t    Caller ! {complex, binary_to_term(Data)}\n\t    end,\n\t    loop(Port);\n\tstop ->\n\t    Port ! {self(), close},\n\t    receive\n\t\t{Port, closed} ->\n\t\t    exit(normal)\n\t    end;\n\t{'EXIT', Port, Reason} ->\n\t    exit(port_terminated)\n    end.\n```\n\nNotice that calling `complex2:foo/1` and `complex2:bar/1` results in the tuple\n`{foo,X}` or `{bar,Y}` being sent to the `complex` process, which codes them as\nbinaries and sends them to the port. This means that the C program must be able\nto handle these two tuples.","title":"Erlang Program - Erl_Interface","ref":"erl_interface.html#erlang-program"},{"type":"extras","doc":"The following example shows a C program communicating with an Erlang program\nover a plain port with the Erlang external term format encoding:\n\n```c\n/* ei.c */\n\n#include \"ei.h\"\n#include  \n#include  \n#include  \n\ntypedef unsigned char byte;\n\nint read_cmd(byte *buf);\nint write_cmd(byte *buf, int len);\nint foo(int x);\nint bar(int y);\n\nstatic void fail(int place) {\n    fprintf(stderr, \"Something went wrong %d\\n\", place);\n    exit(1);\n}\n\nint main() {\n    byte buf[100];\n    int index = 0;\n    int version = 0;\n    int arity = 0;\n    char atom[128];\n    long in = 0;\n    int res = 0;\n    ei_x_buff res_buf;\n    ei_init();\n    while (read_cmd(buf) > 0) {\n        if (ei_decode_version(buf, &index, &version) != 0)\n            fail(1);\n        if (ei_decode_tuple_header(buf, &index, &arity) != 0)\n            fail(2);\n        if (arity != 2)\n            fail(3);\n        if (ei_decode_atom(buf, &index, atom) != 0)\n            fail(4);\n        if (ei_decode_long(buf, &index, &in) != 0)\n            fail(5);\n        if (strncmp(atom, \"foo\", 3) == 0) {\n            res = foo((int)in);\n        } else if (strncmp(atom, \"bar\", 3) == 0) {\n            res = bar((int)in);\n        }\n        if (ei_x_new_with_version(&res_buf) != 0)\n            fail(6);\n        if (ei_x_encode_long(&res_buf, res) != 0)\n            fail(7);\n        write_cmd(res_buf.buff, res_buf.index);\n\n        if (ei_x_free(&res_buf) != 0)\n            fail(8);\n        index = 0;\n    }\n}\n```\n\nThe following functions, `read_cmd()` and `write_cmd()`, from the `erl_comm.c`\nexample in [Ports](c_port.md) can still be used for reading from and writing to\nthe port:\n\n```c\n/* erl_comm.c */\n\n#include  \n#include  \n\ntypedef unsigned char byte;\n\nint read_exact(byte *buf, int len)\n{\n  int i, got=0;\n\n  do {\n      if ((i = read(0, buf+got, len-got)) <= 0){\n          return(i);\n      }\n    got += i;\n  } while (got > 8) & 0xff;\n  write_exact(&li, 1);\n\n  li = len & 0xff;\n  write_exact(&li, 1);\n\n  return write_exact(buf, len);\n}\n```","title":"C Program - Erl_Interface","ref":"erl_interface.html#c-program"},{"type":"extras","doc":"_Step 1._ Compile the C code. This provides the paths to the include file\n`ei.h`, and also to the library `ei`:\n\n```text\n$ gcc -o extprg -I/usr/local/otp/lib/erl_interface-3.9.2/include \\\n    -L/usr/local/otp/lib/erl_interface-3.9.2/lib \\\n    complex.c erl_comm.c ei.c -lei -lpthread\n```\n\nIn Erlang/OTP R5B and later versions of OTP, the `include` and `lib` directories\nare situated under `$OTPROOT/lib/erl_interface-VSN`, where `$OTPROOT` is the\nroot directory of the OTP installation (`/usr/local/otp` in the recent example)\nand `VSN` is the version of the Erl_interface application (3.2.1 in the recent\nexample).\n\nIn R4B and earlier versions of OTP, `include` and `lib` are situated under\n`$OTPROOT/usr`.\n\n_Step 2._ Start Erlang and compile the Erlang code:\n\n```erlang\n$ erl\nErlang/OTP 26 [erts-14.2] [source] [64-bit] [smp:8:8] [ds:8:8:10] [async-threads:1] [jit:ns]\n\nEshell V14.2 (press Ctrl+G to abort, type help(). for help)\n1> c(complex2).\n{ok,complex2}\n```\n\n_Step 3._ Run the example:\n\n```erlang\n2> complex2:start(\"./extprg\").\n<0.34.0>\n3> complex2:foo(3).\n4\n4> complex2:bar(5).\n10\n5> complex2:bar(352).\n704\n6> complex2:stop().\nstop\n```","title":"Running the Example - Erl_Interface","ref":"erl_interface.html#running-the-example"},{"type":"extras","doc":"<!--\n%CopyrightBegin%\n\nCopyright Ericsson AB 2023-2024. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# Port Drivers\n\nThis section outlines an example of how to solve the example problem in\n[Problem Example](example.md) by using a linked-in port driver.\n\nA port driver is a linked-in driver that is accessible as a port from an Erlang\nprogram. It is a shared library (SO in UNIX, DLL in Windows), with special entry\npoints. The Erlang runtime system calls these entry points when the driver is\nstarted and when data is sent to the port. The port driver can also send data to\nErlang.\n\nAs a port driver is dynamically linked into the emulator process, this is the\nfastest way of calling C-code from Erlang. Calling functions in the port driver\nrequires no context switches. But it is also the least safe way, because a crash\nin the port driver brings the emulator down too.\n\nThe scenario is illustrated in the following figure:\n\n```mermaid\n---\ntitle: Port Driver Communication\n---\nflowchart\n    subgraph Legend\n        direction LR\n\n        os[OS Process]\n        erl([Erlang Process])\n    end\n\n    subgraph emulator\n        direction LR\n\n        port{Port} --> erlProc\n        erlProc([Connected process]) --> port\n\n        port --> proc[Port Driver Shared Library]\n        proc --> port\n    end\n```","title":"Port Drivers","ref":"c_portdriver.html"},{"type":"extras","doc":"Like a port program, the port communicates with an Erlang process. All\ncommunication goes through one Erlang process that is the _connected process_ of\nthe port driver. Terminating this process closes the port driver.\n\nBefore the port is created, the driver must be loaded. This is done with the\nfunction `erl_ddll:load_driver/2`, with the name of the shared library as\nargument.\n\nThe port is then created using the BIF [`open_port/2`](`open_port/2`), with the\ntuple `{spawn, DriverName}` as the first argument. The string `SharedLib` is the\nname of the port driver. The second argument is a list of options, none in this\ncase:\n\n```erlang\n-module(complex5).\n-export([start/1, init/1]).\n\nstart(SharedLib) ->\n    case erl_ddll:load_driver(\".\", SharedLib) of\n        ok -> ok;\n        {error, already_loaded} -> ok;\n        _ -> exit({error, could_not_load_driver})\n    end,\n    spawn(?MODULE, init, [SharedLib]).\n\ninit(SharedLib) ->\n  register(complex, self()),\n  Port = open_port({spawn, SharedLib}, []),\n  loop(Port).\n```\n\nNow `complex5:foo/1` and `complex5:bar/1` can be implemented. Both send a\nmessage to the `complex` process and receive the following reply:\n\n```erlang\nfoo(X) ->\n    call_port({foo, X}).\nbar(Y) ->\n    call_port({bar, Y}).\n\ncall_port(Msg) ->\n    complex ! {call, self(), Msg},\n    receive\n        {complex, Result} ->\n            Result\n    end.\n```\n\nThe `complex` process performs the following:\n\n- Encodes the message into a sequence of bytes.\n- Sends it to the port.\n- Waits for a reply.\n- Decodes the reply.\n- Sends it back to the caller:\n\n```erlang\nloop(Port) ->\n    receive\n        {call, Caller, Msg} ->\n            Port ! {self(), {command, encode(Msg)}},\n            receive\n                {Port, {data, Data}} ->\n                    Caller ! {complex, decode(Data)}\n            end,\n            loop(Port)\n    end.\n```\n\nAssuming that both the arguments and the results from the C functions are less\nthan 256, a simple encoding/decoding scheme is employed. In this scheme, `foo`\nis represented by byte 1, `bar` is represented by 2, and the argument/result is\nrepresented by a single byte as well:\n\n```erlang\nencode({foo, X}) -> [1, X];\nencode({bar, Y}) -> [2, Y].\n\ndecode([Int]) -> Int.\n```\n\nThe resulting Erlang program, including functions for stopping the port and\ndetecting port failures, is as follows:\n\n```erlang\n\n-module(complex5).\n-export([start/1, stop/0, init/1]).\n-export([foo/1, bar/1]).\n\nstart(SharedLib) ->\n    case erl_ddll:load_driver(\".\", SharedLib) of\n\tok -> ok;\n\t{error, already_loaded} -> ok;\n\t_ -> exit({error, could_not_load_driver})\n    end,\n    spawn(?MODULE, init, [SharedLib]).\n\ninit(SharedLib) ->\n    register(complex, self()),\n    Port = open_port({spawn, SharedLib}, []),\n    loop(Port).\n\nstop() ->\n    complex ! stop.\n\nfoo(X) ->\n    call_port({foo, X}).\nbar(Y) ->\n    call_port({bar, Y}).\n\ncall_port(Msg) ->\n    complex ! {call, self(), Msg},\n    receive\n\t{complex, Result} ->\n\t    Result\n    end.\n\nloop(Port) ->\n    receive\n\t{call, Caller, Msg} ->\n\t    Port ! {self(), {command, encode(Msg)}},\n\t    receive\n\t\t{Port, {data, Data}} ->\n\t\t    Caller ! {complex, decode(Data)}\n\t    end,\n\t    loop(Port);\n\tstop ->\n\t    Port ! {self(), close},\n\t    receive\n\t\t{Port, closed} ->\n\t\t    exit(normal)\n\t    end;\n\t{'EXIT', Port, Reason} ->\n\t    io:format(\"~p ~n\", [Reason]),\n\t    exit(port_terminated)\n    end.\n\nencode({foo, X}) -> [1, X];\nencode({bar, Y}) -> [2, Y].\n\ndecode([Int]) -> Int.\n```","title":"Erlang Program - Port Drivers","ref":"c_portdriver.html#erlang-program"},{"type":"extras","doc":"The C driver is a module that is compiled and linked into a shared library. It\nuses a driver structure and includes the header file `erl_driver.h`.\n\nThe driver structure is filled with the driver name and function pointers. It is\nreturned from the special entry point, declared with the macro\n`DRIVER_INIT( )`.\n\nThe functions for receiving and sending data are combined into a function,\npointed out by the driver structure. The data sent into the port is given as\narguments, and the replied data is sent with the C-function `driver_output`.\n\nAs the driver is a shared module, not a program, no main function is present.\nAll function pointers are not used in this example, and the corresponding fields\nin the `driver_entry` structure are set to NULL.\n\nAll functions in the driver takes a handle (returned from `start`) that is just\npassed along by the Erlang process. This must in some way refer to the port\ndriver instance.\n\nThe `example_drv_start`, is the only function that is called with a handle to\nthe port instance, so this must be saved. It is customary to use an allocated\ndriver-defined structure for this one, and to pass a pointer back as a\nreference.\n\nIt is not a good idea to use a global variable as the port driver can be spawned\nby multiple Erlang processes. This driver-structure is to be instantiated\nmultiple times:\n\n```c\n/* port_driver.c */\n\n#include  \n#include \"erl_driver.h\"\n\ntypedef struct {\n    ErlDrvPort port;\n} example_data;\n\nstatic ErlDrvData example_drv_start(ErlDrvPort port, char *buff)\n{\n    example_data* d = (example_data*)driver_alloc(sizeof(example_data));\n    d->port = port;\n    return (ErlDrvData)d;\n}\n\nstatic void example_drv_stop(ErlDrvData handle)\n{\n    driver_free((char*)handle);\n}\n\nstatic void example_drv_output(ErlDrvData handle, char *buff,\n\t\t\t       ErlDrvSizeT bufflen)\n{\n    example_data* d = (example_data*)handle;\n    char fn = buff[0], arg = buff[1], res;\n    if (fn == 1) {\n      res = foo(arg);\n    } else if (fn == 2) {\n      res = bar(arg);\n    }\n    driver_output(d->port, &res, 1);\n}\n\nErlDrvEntry example_driver_entry = {\n    NULL,\t\t\t/* F_PTR init, called when driver is loaded */\n    example_drv_start,\t\t/* L_PTR start, called when port is opened */\n    example_drv_stop,\t\t/* F_PTR stop, called when port is closed */\n    example_drv_output,\t\t/* F_PTR output, called when erlang has sent */\n    NULL,\t\t\t/* F_PTR ready_input, called when input descriptor ready */\n    NULL,\t\t\t/* F_PTR ready_output, called when output descriptor ready */\n    \"example_drv\",\t\t/* char *driver_name, the argument to open_port */\n    NULL,\t\t\t/* F_PTR finish, called when unloaded */\n    NULL,                       /* void *handle, Reserved by VM */\n    NULL,\t\t\t/* F_PTR control, port_command callback */\n    NULL,\t\t\t/* F_PTR timeout, reserved */\n    NULL,\t\t\t/* F_PTR outputv, reserved */\n    NULL,                       /* F_PTR ready_async, only for async drivers */\n    NULL,                       /* F_PTR flush, called when port is about\n\t\t\t\t   to be closed, but there is data in driver\n\t\t\t\t   queue */\n    NULL,                       /* F_PTR call, much like control, sync call\n\t\t\t\t   to driver */\n    NULL,                       /* unused */\n    ERL_DRV_EXTENDED_MARKER,    /* int extended marker, Should always be\n\t\t\t\t   set to indicate driver versioning */\n    ERL_DRV_EXTENDED_MAJOR_VERSION, /* int major_version, should always be\n\t\t\t\t       set to this value */\n    ERL_DRV_EXTENDED_MINOR_VERSION, /* int minor_version, should always be\n\t\t\t\t       set to this value */\n    0,                          /* int driver_flags, see documentation */\n    NULL,                       /* void *handle2, reserved for VM use */\n    NULL,                       /* F_PTR process_exit, called when a\n\t\t\t\t   monitored process dies */\n    NULL                        /* F_PTR stop_select, called to close an\n\t\t\t\t   event object */\n};\n\nDRIVER_INIT(example_drv) /* must match name in driver_entry */\n{\n    return &example_driver_entry;\n}\n```","title":"C Driver - Port Drivers","ref":"c_portdriver.html#c-driver"},{"type":"extras","doc":"_Step 1._ Compile the C code:\n\n```text\nunix> gcc -o example_drv.so -fpic -shared complex.c port_driver.c\nwindows> cl -LD -MD -Fe example_drv.dll complex.c port_driver.c\n```\n\n_Step 2._ Start Erlang and compile the Erlang code:\n\n```erlang\n> erl\nErlang/OTP 26 [erts-14.2] [source] [64-bit] [smp:8:8] [ds:8:8:10] [async-threads:1] [jit:ns]\n\nEshell V14.2 (press Ctrl+G to abort, type help(). for help)\n1> c(complex5).\n{ok,complex5}\n```\n\n_Step 3._ Run the example:\n\n```erlang\n2> complex5:start(\"example_drv\").\n<0.34.0>\n3> complex5:foo(3).\n4\n4> complex5:bar(5).\n10\n5> complex5:stop().\nstop\n```","title":"Running the Example - Port Drivers","ref":"c_portdriver.html#running-the-example"},{"type":"extras","doc":"<!--\n%CopyrightBegin%\n\nCopyright Ericsson AB 2023-2024. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# C Nodes\n\nThe reader is referred to\n[the erl_interface users guide](`e:erl_interface:ei_users_guide.md`) for\ninformation about how to create C nodes.","title":"C Nodes","ref":"cnode.html"},{"type":"extras","doc":"<!--\n%CopyrightBegin%\n\nCopyright Ericsson AB 2023-2024. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# NIFs\n\nThis section outlines an example of how to solve the example problem in\n[Problem Example](example.md) by using Native Implemented Functions (NIFs).\n\nNIFs are a simpler and more efficient way of calling C-code than using port\ndrivers. NIFs are most suitable for synchronous functions, such as `foo` and\n`bar` in the example, that do some relatively short calculations without side\neffects and return the result.\n\nA NIF is a function that is implemented in C instead of Erlang. NIFs appear as\nany other functions to the callers. They belong to a module and are called like\nany other Erlang functions. The NIFs of a module are compiled and linked into a\ndynamic loadable, shared library (SO in UNIX, DLL in Windows). The NIF library\nmust be loaded in runtime by the Erlang code of the module.\n\nAs a NIF library is dynamically linked into the emulator process, this is the\nfastest way of calling C-code from Erlang (alongside port drivers). Calling NIFs\nrequires no context switches. But it is also the least safe, because a crash in\na NIF brings the emulator down too.","title":"NIFs","ref":"nif.html"},{"type":"extras","doc":"Even if all functions of a module are NIFs, an Erlang module is still needed for\ntwo reasons:\n\n- The NIF library must be explicitly loaded by Erlang code in the same module.\n- All NIFs of a module must have an Erlang implementation as well.\n\nNormally these are minimal stub implementations that throw an exception. But\nthey can also be used as fallback implementations for functions that do not have\nnative implementations on some architectures.\n\nNIF libraries are loaded by calling `erlang:load_nif/2`, with the name of the\nshared library as argument. The second argument can be any term that will be\npassed on to the library and used for initialization:\n\n```erlang\n-module(complex6).\n-export([foo/1, bar/1]).\n-nifs([foo/1, bar/1]).\n-on_load(init/0).\n\ninit() ->\n    ok = erlang:load_nif(\"./complex6_nif\", 0).\n\nfoo(_X) ->\n    erlang:nif_error(nif_library_not_loaded).\nbar(_Y) ->\n    erlang:nif_error(nif_library_not_loaded).\n```\n\nHere, the directive `on_load` is used to get function `init` to be automatically\ncalled when the module is loaded. If `init` returns anything other than `ok`,\nsuch when the loading of the NIF library fails in this example, the module is\nunloaded and calls to functions within it, fail.\n\nLoading the NIF library overrides the stub implementations and cause calls to\n`foo` and `bar` to be dispatched to the NIF implementations instead.","title":"Erlang Program - NIFs","ref":"nif.html#erlang-program"},{"type":"extras","doc":"The NIFs of the module are compiled and linked into a shared library. Each NIF\nis implemented as a normal C function. The macro `ERL_NIF_INIT` together with an\narray of structures defines the names, arity, and function pointers of all the\nNIFs in the module. The header file `erl_nif.h` must be included. As the library\nis a shared module, not a program, no main function is to be present.\n\nThe function arguments passed to a NIF appears in an array `argv`, with `argc`\nas the length of the array, and thus the arity of the function. The Nth argument\nof the function can be accessed as `argv[N-1]`. NIFs also take an environment\nargument that serves as an opaque handle that is needed to be passed on to most\nAPI functions. The environment contains information about the calling Erlang\nprocess:\n\n```c\n#include  \n\nextern int foo(int x);\nextern int bar(int y);\n\nstatic ERL_NIF_TERM foo_nif(ErlNifEnv* env, int argc, const ERL_NIF_TERM argv[])\n{\n    int x, ret;\n    if (!enif_get_int(env, argv[0], &x)) {\n\treturn enif_make_badarg(env);\n    }\n    ret = foo(x);\n    return enif_make_int(env, ret);\n}\n\nstatic ERL_NIF_TERM bar_nif(ErlNifEnv* env, int argc, const ERL_NIF_TERM argv[])\n{\n    int y, ret;\n    if (!enif_get_int(env, argv[0], &y)) {\n\treturn enif_make_badarg(env);\n    }\n    ret = bar(y);\n    return enif_make_int(env, ret);\n}\n\nstatic ErlNifFunc nif_funcs[] = {\n    {\"foo\", 1, foo_nif},\n    {\"bar\", 1, bar_nif}\n};\n\nERL_NIF_INIT(complex6, nif_funcs, NULL, NULL, NULL, NULL)\n```\n\nHere, `ERL_NIF_INIT` has the following arguments:\n\n- The first argument must be the name of the Erlang module as a C-identifier. It\n  will be stringified by the macro.\n- The second argument is the array of `ErlNifFunc` structures containing name,\n  arity, and function pointer of each NIF.\n- The remaining arguments are pointers to callback functions that can be used to\n  initialize the library. They are not used in this simple example, hence they\n  are all set to `NULL`.\n\nFunction arguments and return values are represented as values of type\n`ERL_NIF_TERM`. Here, functions like `enif_get_int` and `enif_make_int` are used\nto convert between Erlang term and C-type. If the function argument `argv[0]` is\nnot an integer, `enif_get_int` returns false, in which case it returns by\nthrowing a `badarg`\\-exception with `enif_make_badarg`.","title":"NIF Library Code - NIFs","ref":"nif.html#nif-library-code"},{"type":"extras","doc":"_Step 1._ Compile the C code:\n\n```text\nunix> gcc -o complex6_nif.so -fpic -shared complex.c complex6_nif.c\nwindows> cl -LD -MD -Fe complex6_nif.dll complex.c complex6_nif.c\n```\n\n_Step 2:_ Start Erlang and compile the Erlang code:\n\n```erlang\n> erl\nErlang R13B04 (erts-5.7.5) [64-bit] [smp:4:4] [rq:4] [async-threads:0] [kernel-poll:false]\n\nEshell V5.7.5  (abort with ^G)\n1> c(complex6).\n{ok,complex6}\n```\n\n_Step 3:_ Run the example:\n\n```erlang\n3> complex6:foo(3).\n4\n4> complex6:bar(5).\n10\n5> complex6:foo(\"not an integer\").\n** exception error: bad argument\n     in function  complex6:foo/1\n        called as comlpex6:foo(\"not an integer\")\n```","title":"Running the Example - NIFs","ref":"nif.html#running-the-example"},{"type":"extras","doc":"<!--\n%CopyrightBegin%\n\nCopyright Ericsson AB 2023. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# Debugging NIFs and Port Drivers","title":"Debugging NIFs and Port Drivers","ref":"debugging.html"},{"type":"extras","doc":"NIFs and port driver code run inside the Erlang VM OS process (the \"Beam\"). To\nmaximize performance the code is called directly by the same threads executing\nErlang beam code and has full access to all the memory of the OS process. A\nbuggy NIF/driver can thus make severe damage by corrupting memory.\n\nIn a best case scenario such memory corruption is detected immediately causing\nthe Beam to crash generating a core dump file which can be analyzed to find the\nbug. However, it is very common for memory corruption bugs to not be immediately\ndetected when the faulty write happens, but instead much later, for example when\nthe calling Erlang process is garbage collected. When that happens it can be\nvery hard to find the root cause of the memory corruption by analysing the core\ndump. All traces that could have indicated which specific buggy NIF/driver that\ncaused the corruption may be long gone.\n\nAnother kind of bugs that are hard to find are _memory leaks_. They may go\nunnoticed and not cause problem until a deployed system has been running for a\nlong time.\n\nThe following sections describe tools that make it easier to both detect and\nfind the root cause of bugs like this. These tools are actively used during\ndevelopment, testing and troubleshooting of the Erlang runtime system itself.\n\n- [Debug emulator](debugging.md#debug)\n- [Address Sanitizer](debugging.md#asan)\n- [Valgrind](debugging.md#valgrind)\n- [rr - Record and Replay](debugging.md#rr)\n\n[](){: #debug }","title":"With great power comes great responsibilty - Debugging NIFs and Port Drivers","ref":"debugging.html#with-great-power-comes-great-responsibilty"},{"type":"extras","doc":"One way to make debugging easier is to run an emulator built with target\n`debug`. It will\n\n- _Increase probability of detecting bugs earlier_. It contains a lot more\n  runtime checks to ensure correct use of internal interfaces and data\n  structures.\n- _Generate a core dump that is easier to analyze_. Compiler optimizations are\n  turned off, which stops the compiler from \"optimizing away\" variables, thus\n  making it easier/possible to inspect their state.\n- _Detect lock order violations_. A runtime lock checker will verify that the\n  locks in the [`erl_nif`](`e:erts:erl_nif.md`) and\n  [`erl_driver`](`e:erts:erl_driver.md`) APIs are seized in a consistent order\n  that cannot result in deadlock bugs.\n\nIn fact, we recommend to use the debug emulator as default during development of\nNIFs and drivers, regardless if you are troubleshooting bugs or not. Some subtle\nbugs may not be detected by the normal emulator and just happen to work anyway\nby chance. However, another version of the emulator, or even different\ncircumstances within the same emulator, may cause the bug to later provoke all\nkinds of problems.\n\nThe main disadvantage of the `debug` emulator is its reduced performance. The\nextra runtime checks and lack of compiler optimizations may result in a slowdown\nwith a factor of two or more depending on load. The memory footprint should be\nabout the same.\n\nIf the `debug` emulator is part of the Erlang/OTP installation, it can be\nstarted with the [`-emu_type`](`e:erts:erl_cmd.md#emu_type`) option.\n\n```text\n> erl -emu_type debug\nErlang/OTP 25 [erts-13.0.2] ... [type-assertions] [debug-compiled] [lock-checking]\n\nEshell V13.0.2  (abort with ^G)\n1>\n```\n\nIf the `debug` emulator is not part of the installation, you need to\n[build it from the Erlang/OTP source code](`e:system:install.md#advanced-configuration-and-build-of-erlang-otp_building_how-to-build-a-debug-enabled-erlang-runtime-system`).\nAfter building from source either make an Erlang/OTP installation or you can run\nthe debug emulator directly in the source tree with the `cerl` script:\n\n```text\n> $ERL_TOP/bin/cerl -debug\nErlang/OTP 25 [erts-13.0.2] ... [type-assertions] [debug-compiled] [lock-checking]\n\nEshell V13.0.2  (abort with ^G)\n1>\n```\n\nThe `cerl` script can also be used as a convenient way to start the debugger\n`gdb` for core dump analysis:\n\n```text\n> $ERL_TOP/bin/cerl -debug -core core.12345\nor\n> $ERL_TOP/bin/cerl -debug -rcore core.12345\n```\n\nThe first variant starts Emacs and runs `gdb` within, while the other `-rcore`\nruns `gdb` directly in the terminal. Apart from starting `gdb` with the correct\n`beam.debug.smp` executable file it will also read the file\n`$ERL_TOP/erts/etc/unix/etp-commands` which contains a lot of `gdb` command for\ninspecting a beam core dump. For example, the command `etp` that will print the\ncontent of an Erlang term (`Eterm`) in plain Erlang syntax.\n\n[](){: #asan }","title":"Debug emulator - Debugging NIFs and Port Drivers","ref":"debugging.html#debug-emulator"},{"type":"extras","doc":"[AddressSanitizer](https://clang.llvm.org/docs/AddressSanitizer.html) (asan) is\nan open source programming tool that detects memory corruption bugs such as\nbuffer overflows, use-after-free and memory leaks. AddressSanitizer is based on\ncompiler instrumentation and is supported by both gcc and clang.\n\nSimilar to the `debug` emulator, the `asan` emulator runs slower than normal,\nabout 2-3 times slower. However, it also has a larger memory footprint, about 3\ntimes more memory than normal.\n\nTo get full effect you should compile both your own NIF/driver code as well as\nthe Erlang emulator with AddressSanitizer instrumentation. Compile your own code\nby passing option `-fsanitize=address` to gcc or clang. Other recommended\noptions that will improve the fault identification are `-fno-common` and\n`-fno-omit-frame-pointer`.\n\nBuild and run the emulator with AddressSanitizer support by using the same\nprocedure as for the debug emulator, except use the `asan` build target instead\nof `debug`.\n\n- **Run in source tree** - If you run the `asan` emulator directly in the source\n  tree with the `cerl` script you only need to set environment variable\n  `ASAN_LOG_DIR` to the directory where the error log files will be generated.\n\n  ```text\n  > export ASAN_LOG_DIR=/my/asan/log/dir\n  > $ERL_TOP/bin/cerl -asan\n  Erlang/OTP 25 [erts-13.0.2] ... [address-sanitizer]\n\n  Eshell V13.0.2  (abort with ^G)\n  1>\n  ```\n\n  You may however also want to set `ASAN_OPTIONS=\"halt_on_error=true\"` if you\n  want the emulator to crash when an error is detected.\n\n- **Run installed Erlang/OTP** - If you run the `asan` emulator in an installed\n  Erlang/OTP with `erl -emu_type asan` you need to set the path to the error log\n  _file_ with\n\n  ```text\n  > export ASAN_OPTIONS=\"log_path=/my/asan/log/file\"\n  ```\n\n  To avoid false positive memory leak reports from the emulator itself set\n  `LSAN_OPTIONS` (LSAN=LeakSanitizer):\n\n  ```text\n  > export LSAN_OPTIONS=\"suppressions=$ERL_TOP/erts/emulator/asan/suppress\"\n  ```\n\n  The `suppress` file is currently not installed but can be copied manually from\n  the source tree to wherever you want it.\n\nMemory corruption errors are reported by AddressSanitizer when they happen, but\nmemory leaks are only checked and reported by default then the emulator\nterminates.","title":"Address Sanitizer - Debugging NIFs and Port Drivers","ref":"debugging.html#address-sanitizer"},{"type":"extras","doc":"An even more heavy weight debugging tool is [Valgrind](https://valgrind.org). It\ncan also find memory corruption bugs and memory leaks similar to `asan`.\nValgrind is not as good at buffer overflow bugs, but it will find use of\nundefined data, which is a type of error that `asan` cannot detect.\n\nValgrind is much slower than `asan` and it is incapable at exploiting CPU\nmulticore processing. We therefore recommend `asan` as the first choice before\ntrying valgrind.\n\nValgrind runs as a virtual machine itself, emulating execution of hardware\nmachine instructions. This means you can run almost any program unchanged on\nvalgrind. However, we have found that the beam executable benefits from being\ncompiled with special adaptions for running on valgrind.\n\nBuild the emulator with `valgrind` target the same as is done for `debug` and\n`asan`. Note that `valgrind` needs to be installed on the machine before the\nbuild starts.\n\nRun the `valgrind` emulator directly in the source tree with the `cerl` script.\nSet environment variable `VALGRIND_LOG_DIR` to the directory where the error log\nfiles will be generated.\n\n```text\n> export VALGRIND_LOG_DIR=/my/valgrind/log/dir\n> $ERL_TOP/bin/cerl -valgrind\nErlang/OTP 25 [erts-13.0.2] ... [valgrind-compiled]\n\nEshell V13.0.2  (abort with ^G)\n1>\n```\n\n[](){: #rr }","title":"Valgrind - Debugging NIFs and Port Drivers","ref":"debugging.html#valgrind"},{"type":"extras","doc":"Last but not least, the fantastic interactive debugging tool\n[rr](https://rr-project.org/), developed by Mozilla as open source. `rr` stands\nfor Record and Replay. While a core dump represents only a static snapshot of\nthe OS process when it crashed, with `rr` you instead record the entire session,\nfrom start of the OS process to the end (the crash). You can then replay that\nsession from within `gdb`. Single step, set breakpoints and watchpoints, and\neven _execute backwards_.\n\nConsidering its powerful utility, `rr` is remarkably light weight. It runs on\nLinux with any reasonably modern x86 CPU. You may get a two times slowdown when\nexecuting in recording mode. The big weakness is