/** VSys:$nethdr.h:0.0.3-012$ **/
/*
 *  Transfered by VSys script on   11 17:05:08 MSK 2003
 *  Project: ndsad; Project version: 0.0.3-025;
 *  Branch: ;
 *  File: nethdr.h; File version: 0.0.3-012
 */
//#ifndef __NET_HEADERS_H__
//#define __NET_HEADERS_H__

/*
 * Very truncated version of linux netinet/tcp.h netinet/udp.h adn linux/ip.h
 * Only definitions of iphdr, tcphdr and udphdr are left
 * Some delarations are changed
 */

/*
 * Copyrights
 */
/*
 * Copyright (c) 1982, 1986 Regents of the University of California.
 * All rights reserved.  The Berkeley software License Agreement
 * specifies the terms and conditions for redistribution.
 */
/*
 * INET		An implementation of the TCP/IP protocol suite for the LINUX
 *		operating system.  INET is implemented using the  BSD Socket
 *		interface as the means of communication with the user level.
 *
 *		Definitions for the TCP protocol.
 * Version:	@(#)tcp.h	1.0.2	04/28/93
 *		Definitions for the UDP protocol.
 * Version:	@(#)udp.h	1.0.2	04/28/93
 *		Definitions for the IP protocol.
 * Version:	@(#)ip.h	1.0.2	04/28/93
 *
 * Author:	Fred N. van Kempen, <waltje@uWalt.NL.Mugnet.ORG>
 *
 *		This program is free software; you can redistribute it and/or
 *		modify it under the terms of the GNU General Public License
 *		as published by the Free Software Foundation; either version
 *		2 of the License, or (at your option) any later version.
 */


#ifdef WIN32 
#include "win32/types.h"
#else
#include <config.h> 
#include <sys/types.h>
#endif

#ifndef __BEGIN_DECLS 
#define __BEGIN_DECLS   extern "C" {
#endif
#ifndef __END_DECLS 
#define __END_DECLS };
#endif

#ifdef WIN32
extern "C" {
#else
__BEGIN_DECLS
#endif

#ifndef WIN32

// Fix some problems with different endianness declaration
#ifdef __OS_BSD_LIKE
# include <machine/endian.h>
# if (BYTE_ORDER == LITTLE_ENDIAN)
#  ifndef __LITTLE_ENDIAN_BITFIELD
#   define __LITTLE_ENDIAN_BITFIELD
#  endif
# elif (BYTE_ORDER ==  BIG_ENDIAN)
#  ifndef __BIG_ENDIAN_BITFIELD
#   define    __BIG_ENDIAN_BITFIELD
#  endif
# else
#  error "Fix byteorder!"
# endif
#elif defined __OS_LINUX_LIKE
# include <asm/byteorder.h>
#elif defined __OS_SOLARIS_LIKE
# include <sys/byteorder.h>
#define __BIG_ENDIAN_BITFIELD
#else
# warning "Unknown OS type - using Linux headers"
# include <asm/byteorder.h>
#endif// IF...

#else
#define __LITTLE_ENDIAN_BITFIELD
#endif// ifndef WIN32

#ifndef __NEED_ALL
# ifndef __NEED_IP
#  ifndef __NEED_TCP
#   ifndef __NEED_UDP
#    ifndef __NEED_PPP
#     define __NEED_ALL
#    endif
#   endif
#  endif
# endif
#endif

#ifdef  __NEED_ALL
#       undef  __NEED_ALL
#       define __NEED_IP
#       define __NEED_UDP
#       define __NEED_TCP
#       define __NEED_PPP
#endif//__NEED_ALL

#ifdef  __IP_INCLUDED
#	undef __NEED_IP
#endif//__IP_INCLUDED

#ifdef  __TCP_INCLUDED
#	undef __NEED_TCP
#endif//__TCP_INCLUDED

#ifdef  __UDP_INCLUDED
#	undef __NEED_UDP
#endif//__UDP_INCLUDED

#ifdef  __PPP_INCLUDED
#	undef __NEED_PPP
#endif//__PPP_INCLUDED

#ifndef ____HDR_SZ
# define ____HDR_SZ
# define  IP_HDR_SZ  (u_int32_t) 20
# define TCP_HDR_SZ  (u_int32_t) 20
# define UDP_HDR_SZ  8
#endif

#ifdef  __NEED_IP

#define IPP_UDP 17
#define IPP_TCP 6

// printf ("cc");
struct iphdr{
#if defined(__LITTLE_ENDIAN_BITFIELD)
	u_int8_t ih_l:4,
	ih_ver:4;
#elif defined (__BIG_ENDIAN_BITFIELD)
	u_int8_t ih_ver:4,
	ih_l:4;
#else 
#	error  "Please fix files dependent on endianness"
#endif
	u_int8_t  ih_tos;
	u_int16_t ih_len;
	u_int16_t ih_id;
	u_int16_t ih_frag;
	u_int8_t  ih_ttl;
	u_int8_t  ih_proto;
	u_int16_t ih_check;
	u_int32_t ih_saddr;
	u_int32_t ih_daddr;
	/*The options start here. */
};

#undef  __NEED_IP
#define __IP_INCLUDED
#endif//__NEED_IP

#ifdef __NEED_TCP


/*
 * TCP header.
 * Per RFC 793, September, 1981.
 */
struct tcphdr {
	u_int16_t th_sport;         /* source port */
	u_int16_t th_dport;         /* destination port */
	u_int32_t th_seq;           /* sequence number */
	u_int32_t th_ack;           /* acknowledgement number */
#  if defined(__LITTLE_ENDIAN_BITFIELD)
	u_int8_t th_x2:4;           /* (unused) */
	u_int8_t th_off:4;          /* data offset */
#  elif defined (__BIG_ENDIAN_BITFIELD)
	u_int8_t th_off:4;          /* data offset */
	u_int8_t th_x2:4;           /* (unused) */
#  else
#	error  "Please fix files dependent on endianness"
#  endif
	u_int8_t th_flags;
#  define TH_FIN        0x01
#  define TH_SYN        0x02
#  define TH_RST        0x04
#  define TH_PUSH       0x08
#  define TH_ACK        0x10
#  define TH_URG        0x20
	u_int16_t th_win;           /* window */
	u_int16_t th_sum;           /* checksum */
	u_int16_t th_urp;           /* urgent pointer */
};

#undef  __NEED_TCP
#define __TCP_INCLUDED
#endif//__NEED_TCP

#ifdef  __NEED_UDP

/* UDP header as specified by RFC 768, August 1980. */

struct udphdr {
	u_int16_t uh_sport;           /* source port */
	u_int16_t uh_dport;           /* destination port */
	u_int16_t uh_ulen;            /* udp length */
	u_int16_t uh_sum;             /* udp checksum */
};

#define SOL_UDP            17      /* sockopt level for UDP */

#undef  __NEED_UDP
#define __UDP_INCLUDED
#endif//__NEED_UDP

#ifdef  __NEED_PPP

#define PPP_HDR_LEN 4

#define PPP_ADDR_VAL 0xff
#define PPP_CNTL_VAL 0x03

struct ppphdr {
	u_int8_t  ph_addr;
	u_int8_t  ph_cntl;
	u_int16_t ph_prot;
};

// A bit of PPP protocols
#define PPP_IP_PROTO      0x21    /* Internet Protocol */
#define PPP_IPV6_PROTO    0x57    /* Internet Protocol Version 6 */
#define PPP_COMP_PROTO    0xfd    /* compressed packet */
#define PPP_IPCP_PROTO    0x8021  /* IP Control Protocol */
#define PPP_IPV6CP_PROTO  0x8057  /* IPv6 Control Protocol */
#define PPP_CCP_PROTO     0x80fd  /* Compression Control Protocol */
#define PPP_LCP_PROTO     0xc021  /* Link Control Protocol */
#define PPP_PAP_PROTO     0xc023  /* Password Authentication Protocol */
#define PPP_CHAP_PROTO    0xc223  /* Cryptographic Handshake Auth. Protocol */

#undef  __NEED_PPP
#define __PPP_INCLUDED
#endif//__NEED_PPP

#ifdef WIN32
}
#else
__END_DECLS
#endif

//#endif//__NET_HEADERS_H__
