/*
  lxac3scan.c
  
  Kleines Programm zum Filtern eines ac3 Streams.
  Alle Zeichen bis zum ersten "sync word" werden uebersprungen

  
  Autor: Stefan Becker
  Lizenz: GPL, siehe Kopf von lxdvdrip.c

*/


#include <stdio.h>

int main (int argc, char* argv[])
{

  FILE* fStdin;
  FILE* fStdout;
    
  fStdin = fopen ("/dev/stdin", "rb");
  fStdout = fopen ("/dev/stdout", "wb");

  char ch=' '; 
  
  // Schleife 1: Alles ueberspringen bis zum ersten sync word
  do {
    if (fread (&ch, 1, 1, fStdin) <= 0) break;
    if ((int)ch == 0x0b)
    {
      if (fread (&ch, 1, 1, fStdin) <= 0) break;
      if ((int)ch == 0x77)
      {
        fprintf (fStdout, "%c%c", 0x0b, 0x77);
	break;
      }
    }
  } while (1==1);
  
  // Schleife 2: bis zum Ende der Datei alles ausgeben
  do {
    if (fread (&ch, 1, 1, fStdin) <= 0) break;
    fwrite (&ch, 1, 1, fStdout);
  } while (1==1);
        
  fclose (fStdin);
  fclose (fStdout);
  
  return 0;
}  
