/*==============================================================================

FICHIER     : [dvdformat.c]

DATE        : 2006/01/0026 19:39:26

CREATEUR    : [Linux!jef]

COMMENTAIRE :
		Released under GPL license, see gnu.org
================================================================================

==============================================================================*/
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif
#include <stdio.h>


#include "const.h"
#include "dvdformat.h"

typedef struct
{
	long long wanted_bytes;
	long long maxBytes;
} DvdFormat_t;

static DvdFormat_t Format;

/*------------------------------------------------------------------------------
	SETFORMAT-
Linux!jef 2006/01/26 19:41:03
------------------------------------------------------------------------------*/

void SetFormat( int format )
{
	switch( format ) {
		case DVD5 :
			Format.wanted_bytes = DVD5_WANTED_BYTES_LL;
			Format.maxBytes = MAX_DVD5_BYTES;
			break;
		case DVD9 :
			Format.wanted_bytes = DVD9_WANTED_BYTES_LL;
			Format.maxBytes = MAX_DVD9_BYTES;
			break;
	}
}
/*------------------------------------------------------------------------------
	GETWANTEDBYTES-
Linux!jef 2006/01/26 19:43:50
------------------------------------------------------------------------------*/

long long GetWantedBytes()
{
	return( Format.wanted_bytes );
}
/*------------------------------------------------------------------------------
	GETMAXBYTES-
Linux!jef 2006/01/26 19:44:05
------------------------------------------------------------------------------*/

long long GetMaxBytes()
{
	return( Format.maxBytes );
}
/*------------------------------------------------------------------------------
	GETWORKBYTES-
Linux!jef 2006/01/26 19:48:15
------------------------------------------------------------------------------*/

long long GetWorkBytes()
{
	return( 2 * MAX_DVD5_BYTES );
}

