package dts

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// TransferPayType invokes the dts.TransferPayType API synchronously
func (client *Client) TransferPayType(request *TransferPayTypeRequest) (response *TransferPayTypeResponse, err error) {
	response = CreateTransferPayTypeResponse()
	err = client.DoAction(request, response)
	return
}

// TransferPayTypeWithChan invokes the dts.TransferPayType API asynchronously
func (client *Client) TransferPayTypeWithChan(request *TransferPayTypeRequest) (<-chan *TransferPayTypeResponse, <-chan error) {
	responseChan := make(chan *TransferPayTypeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.TransferPayType(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// TransferPayTypeWithCallback invokes the dts.TransferPayType API asynchronously
func (client *Client) TransferPayTypeWithCallback(request *TransferPayTypeRequest, callback func(response *TransferPayTypeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *TransferPayTypeResponse
		var err error
		defer close(result)
		response, err = client.TransferPayType(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// TransferPayTypeRequest is the request struct for api TransferPayType
type TransferPayTypeRequest struct {
	*requests.RpcRequest
	Period     string `position:"Query" name:"Period"`
	BuyCount   string `position:"Query" name:"BuyCount"`
	DtsJobId   string `position:"Query" name:"DtsJobId"`
	ChargeType string `position:"Query" name:"ChargeType"`
}

// TransferPayTypeResponse is the response struct for api TransferPayType
type TransferPayTypeResponse struct {
	*responses.BaseResponse
	EndTime        string `json:"EndTime" xml:"EndTime"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
	DtsJobId       string `json:"DtsJobId" xml:"DtsJobId"`
	ErrCode        string `json:"ErrCode" xml:"ErrCode"`
	Success        bool   `json:"Success" xml:"Success"`
	ChargeType     string `json:"ChargeType" xml:"ChargeType"`
	ErrMessage     string `json:"ErrMessage" xml:"ErrMessage"`
	Code           string `json:"Code" xml:"Code"`
	DynamicMessage string `json:"DynamicMessage" xml:"DynamicMessage"`
	InstanceId     string `json:"InstanceId" xml:"InstanceId"`
}

// CreateTransferPayTypeRequest creates a request to invoke TransferPayType API
func CreateTransferPayTypeRequest() (request *TransferPayTypeRequest) {
	request = &TransferPayTypeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dts", "2020-01-01", "TransferPayType", "dts", "openAPI")
	request.Method = requests.POST
	return
}

// CreateTransferPayTypeResponse creates a response to parse from TransferPayType response
func CreateTransferPayTypeResponse() (response *TransferPayTypeResponse) {
	response = &TransferPayTypeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
