package dcdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDcdnSecFuncInfo invokes the dcdn.DescribeDcdnSecFuncInfo API synchronously
func (client *Client) DescribeDcdnSecFuncInfo(request *DescribeDcdnSecFuncInfoRequest) (response *DescribeDcdnSecFuncInfoResponse, err error) {
	response = CreateDescribeDcdnSecFuncInfoResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDcdnSecFuncInfoWithChan invokes the dcdn.DescribeDcdnSecFuncInfo API asynchronously
func (client *Client) DescribeDcdnSecFuncInfoWithChan(request *DescribeDcdnSecFuncInfoRequest) (<-chan *DescribeDcdnSecFuncInfoResponse, <-chan error) {
	responseChan := make(chan *DescribeDcdnSecFuncInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDcdnSecFuncInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDcdnSecFuncInfoWithCallback invokes the dcdn.DescribeDcdnSecFuncInfo API asynchronously
func (client *Client) DescribeDcdnSecFuncInfoWithCallback(request *DescribeDcdnSecFuncInfoRequest, callback func(response *DescribeDcdnSecFuncInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDcdnSecFuncInfoResponse
		var err error
		defer close(result)
		response, err = client.DescribeDcdnSecFuncInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDcdnSecFuncInfoRequest is the request struct for api DescribeDcdnSecFuncInfo
type DescribeDcdnSecFuncInfoRequest struct {
	*requests.RpcRequest
	Lang        string           `position:"Query" name:"Lang"`
	OwnerId     requests.Integer `position:"Query" name:"OwnerId"`
	SecFuncType string           `position:"Query" name:"SecFuncType"`
}

// DescribeDcdnSecFuncInfoResponse is the response struct for api DescribeDcdnSecFuncInfo
type DescribeDcdnSecFuncInfoResponse struct {
	*responses.BaseResponse
	RequestId   string        `json:"RequestId" xml:"RequestId"`
	Description string        `json:"Description" xml:"Description"`
	RetCode     string        `json:"RetCode" xml:"RetCode"`
	HttpStatus  string        `json:"HttpStatus" xml:"HttpStatus"`
	Content     []ContentItem `json:"Content" xml:"Content"`
}

// CreateDescribeDcdnSecFuncInfoRequest creates a request to invoke DescribeDcdnSecFuncInfo API
func CreateDescribeDcdnSecFuncInfoRequest() (request *DescribeDcdnSecFuncInfoRequest) {
	request = &DescribeDcdnSecFuncInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dcdn", "2018-01-15", "DescribeDcdnSecFuncInfo", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeDcdnSecFuncInfoResponse creates a response to parse from DescribeDcdnSecFuncInfo response
func CreateDescribeDcdnSecFuncInfoResponse() (response *DescribeDcdnSecFuncInfoResponse) {
	response = &DescribeDcdnSecFuncInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
