package cloudwf

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifySubAccountPermission invokes the cloudwf.ModifySubAccountPermission API synchronously
// api document: https://help.aliyun.com/api/cloudwf/modifysubaccountpermission.html
func (client *Client) ModifySubAccountPermission(request *ModifySubAccountPermissionRequest) (response *ModifySubAccountPermissionResponse, err error) {
	response = CreateModifySubAccountPermissionResponse()
	err = client.DoAction(request, response)
	return
}

// ModifySubAccountPermissionWithChan invokes the cloudwf.ModifySubAccountPermission API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/modifysubaccountpermission.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifySubAccountPermissionWithChan(request *ModifySubAccountPermissionRequest) (<-chan *ModifySubAccountPermissionResponse, <-chan error) {
	responseChan := make(chan *ModifySubAccountPermissionResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifySubAccountPermission(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifySubAccountPermissionWithCallback invokes the cloudwf.ModifySubAccountPermission API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/modifysubaccountpermission.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifySubAccountPermissionWithCallback(request *ModifySubAccountPermissionRequest, callback func(response *ModifySubAccountPermissionResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifySubAccountPermissionResponse
		var err error
		defer close(result)
		response, err = client.ModifySubAccountPermission(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifySubAccountPermissionRequest is the request struct for api ModifySubAccountPermission
type ModifySubAccountPermissionRequest struct {
	*requests.RpcRequest
	ShopGroupIds   *[]string        `position:"Query" name:"ShopGroupIds"  type:"Repeated"`
	ShopIds        *[]string        `position:"Query" name:"ShopIds"  type:"Repeated"`
	PagePermission string           `position:"Query" name:"PagePermission"`
	Id             requests.Integer `position:"Query" name:"Id"`
	BusinessIds    *[]string        `position:"Query" name:"BusinessIds"  type:"Repeated"`
}

// ModifySubAccountPermissionResponse is the response struct for api ModifySubAccountPermission
type ModifySubAccountPermissionResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Message   string `json:"Message" xml:"Message"`
	ErrorCode int    `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMsg  string `json:"ErrorMsg" xml:"ErrorMsg"`
}

// CreateModifySubAccountPermissionRequest creates a request to invoke ModifySubAccountPermission API
func CreateModifySubAccountPermissionRequest() (request *ModifySubAccountPermissionRequest) {
	request = &ModifySubAccountPermissionRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloudwf", "2017-03-28", "ModifySubAccountPermission", "cloudwf", "openAPI")
	return
}

// CreateModifySubAccountPermissionResponse creates a response to parse from ModifySubAccountPermission response
func CreateModifySubAccountPermissionResponse() (response *ModifySubAccountPermissionResponse) {
	response = &ModifySubAccountPermissionResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
