package airec

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyScene invokes the airec.ModifyScene API synchronously
func (client *Client) ModifyScene(request *ModifySceneRequest) (response *ModifySceneResponse, err error) {
	response = CreateModifySceneResponse()
	err = client.DoAction(request, response)
	return
}

// ModifySceneWithChan invokes the airec.ModifyScene API asynchronously
func (client *Client) ModifySceneWithChan(request *ModifySceneRequest) (<-chan *ModifySceneResponse, <-chan error) {
	responseChan := make(chan *ModifySceneResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyScene(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifySceneWithCallback invokes the airec.ModifyScene API asynchronously
func (client *Client) ModifySceneWithCallback(request *ModifySceneRequest, callback func(response *ModifySceneResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifySceneResponse
		var err error
		defer close(result)
		response, err = client.ModifyScene(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifySceneRequest is the request struct for api ModifyScene
type ModifySceneRequest struct {
	*requests.RoaRequest
	InstanceId string `position:"Path" name:"instanceId"`
	SceneId    string `position:"Path" name:"sceneId"`
}

// ModifySceneResponse is the response struct for api ModifyScene
type ModifySceneResponse struct {
	*responses.BaseResponse
	RequestId string              `json:"requestId" xml:"requestId"`
	Code      string              `json:"code" xml:"code"`
	Message   string              `json:"message" xml:"message"`
	Result    ResultInModifyScene `json:"result" xml:"result"`
}

// CreateModifySceneRequest creates a request to invoke ModifyScene API
func CreateModifySceneRequest() (request *ModifySceneRequest) {
	request = &ModifySceneRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("Airec", "2020-11-26", "ModifyScene", "/v2/openapi/instances/[instanceId]/scenes/[sceneId]", "airec", "openAPI")
	request.Method = requests.PUT
	return
}

// CreateModifySceneResponse creates a response to parse from ModifyScene response
func CreateModifySceneResponse() (response *ModifySceneResponse) {
	response = &ModifySceneResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
