/* pdv.h
   $Id: pdv.h,v 1.8 2001/09/01 19:09:28 gwiley Exp $
	Glen Wiley, gwiley@ieee.org

Copyright (c)1999,2000,2001 Glen Wiley

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sub-license, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.


*/

#ifndef PDV_H
#define PDV_H

#if HAVE_CONFIG_H
 #include "config.h"
#endif
#include <sys/types.h>
/* if PDV_USE_ZLIB is not defined then no support for internal compression
   libraries will be supported
#if HAVE_ZLIB_H && HAVE_LIBZ
#define PDV_USE_ZLIB 1
#endif
*/

/* this structure is appended to the end of the executable */ 
struct payload_st
{
	char   *fn_out;        /* the name of the payload output file */
	mode_t payldmode;      /* the name of the payload output file */
	char   *cmd;           /* command to execute after delivery */
	char   *hlpmsg;        /* user help message */
	char   *agrmsg;        /* optional agreement message */
	char   iscompressed;   /* filter payload through uncompress */ 
	char   isatar;         /* filter payload through tar */
	char   iszipped;       /* use internal compression library */
	off_t  payloadstart;   /* start of payload (after pdv stub) */
	off_t  metadatastart;  /* start of payload data (at end of file) */
};

/* this struct is used to keep track of everything useful about a
   pdv package - it can even be read from/written to a file */
struct pdvspec_st
{
	char *fn_spec;
	char *fn_helpmsg;
	char *fn_agrmsg;
	char *fn_output;
	char *fn_payld;
	char *fn_pdvstub;
	char *fn_exec;
	char *fn_pkg;
	char *compress; /* populate with "y" or "n" */
	char *tar;      /* populate with "y" or "n" */
};

#ifndef HAVE_STRDUP
char *strdup(char *);
#endif

#ifndef HAVE_STRERROR
char *strerror(int);
#endif

char *findpdv(char *prg, char *hint, int showmsgs);
void fatalError(int err, const char *fmt, ...);
int  readMsgFile(char *fn, char **msg);
int  filecopy(const char *fn_src, const char *fn_dst, int setown, uid_t uid
 , gid_t gid, int setmode, mode_t mode, int append);
int  newpkgfile(const char *fn_pdv, const char *fn_pkg, const char *fn_pld
 , struct payload_st *pld_data, int showmsgs);

/* these routines are used to manipulate the spec structure */

int  writespec(struct pdvspec_st *spec);
int  readspec(const char *fn, struct pdvspec_st *spec, char **badfield);
void freespecmembers(struct pdvspec_st *spec);
int  cmpspec(struct pdvspec_st *spec1, struct pdvspec_st *spec2);
int  spectopayload(struct pdvspec_st *spec, struct payload_st *pld);

#endif /* PDV_H */

/* end pdv.h */
