/* xmpdvmkpkg.h
	$Id: xmpdvmkpkg.h,v 1.2 2001/08/26 16:04:00 gwiley Exp $
	Glen Wiley <gwiley@ieee.org>

Copyright (c)1999,2000,2001 Glen Wiley

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sub-license, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.

*/

#ifndef XMPDVMKPKG_H
#define XMPDVMKPKG_H

#if HAVE_CONFIG_H
 #include "config.h"
#endif
#include <errno.h>
#if HAVE_FCNTL_H
 #include <fcntl.h>
#endif
#include <sys/types.h>
#include <sys/stat.h>
#include <stdlib.h>
#include <time.h>
#if HAVE_UNISTD_H
 #include <unistd.h>
#endif
#include <Xm/Xm.h>
#include "../pdv.h"

/*-------------------- data types */

struct specwidgets_st
{
	Widget tx_fnpkg;
	Widget tx_fnpayld;
	Widget tx_fnoutput;
	Widget tx_exec;
	Widget tx_fnhelp;
	Widget tx_fnagrmsg;
	Widget tb_compress;
	Widget tb_tar;
};

/*-------------------- constants */

extern const int  TXENTRYWIDTH;
extern const int  INITAPPWIDTH;
extern const int  INITAPPHEIGHT;
extern const char *APPNAME;

/*-------------------- global vars */

extern struct specwidgets_st g_specwidgets;
extern struct pdvspec_st     g_pdvspec;
extern Widget g_statusw;

/*-------------------- functions */

void spectowidgets(void);
void widgetstospec(struct pdvspec_st *spec);
int  cmpspecandwidgets(void);
void xu_SetMainTitle(const char *newtitle, const char *newprefix
 , Widget topshell);

#endif /* XMPDVMKPKG_H */

/* xmpdvmkpkg.h */
