/*
 * pi3's Linux kernel Runtime Guard
 *
 * Component:
 *  - Intercept setgroups/setgroups16 syscall
 *
 * Notes:
 *  - None
 *
 * Caveats:
 *  - None
 *
 * Timeline:
 *  - Created: 09.IX.2017
 *
 * Author:
 *  - Adam 'pi3' Zabrocki (http://pi3.com.pl)
 *
 */

#ifndef P_LKRG_EXPLOIT_DETECTION_SET_CURRENT_GROUPS_H
#define P_LKRG_EXPLOIT_DETECTION_SET_CURRENT_GROUPS_H

/* per-instance private data */
struct p_set_current_groups_data {
    ktime_t entry_stamp;
};


int p_set_current_groups_ret(struct kretprobe_instance *ri, struct pt_regs *p_regs);
int p_set_current_groups_entry(struct kretprobe_instance *p_ri, struct pt_regs *p_regs);
int p_install_set_current_groups_hook(int p_isra);
void p_uninstall_set_current_groups_hook(void);

#endif
