/*
 * pi3's Linux kernel Runtime Guard
 *
 * Component:
 *  - Intercept '__scm_send' function
 *
 * Notes:
 *  - This hook enforces process validation
 *    before SCM_CREDENTIALS is used (for UNIX sockets).
 *
 * Caveats:
 *  - None
 *
 * Timeline:
 *  - Created: 28.IV.2020
 *
 * Author:
 *  - Adam 'pi3' Zabrocki (http://pi3.com.pl)
 *
 */

#include "../../../../p_lkrg_main.h"


char p_scm_send_kretprobe_state = 0;

static struct kretprobe p_scm_send_kretprobe = {
    .kp.symbol_name = "__scm_send",
    .handler = p_scm_send_ret,
    .entry_handler = p_scm_send_entry,
    .data_size = sizeof(struct p_scm_send_data),
};


int p_scm_send_entry(struct kretprobe_instance *p_ri, struct pt_regs *p_regs) {

   p_ed_enforce_validation();

   return 0;
}


int p_scm_send_ret(struct kretprobe_instance *ri, struct pt_regs *p_regs) {

   return 0;
}


GENERATE_INSTALL_FUNC(scm_send)
