/*
 * pi3's Linux kernel Runtime Guard
 *
 * Component:
 *  - Intercept 'security_bprm_committing_creds' syscall
 *
 * Notes:
 *  - We are maintianing Red-Black tree of pid's for Exploit Detection feature.
 *    When process calls execve, we need to update RB tree.
 *
 * Caveats:
 *  - None
 *
 * Timeline:
 *  - 18.I.2021:   Replace one 'search_binary_handler' hook with two
 *                 independent one to reduce the race window while
 *                 the process is not being verified
 *  - 28.XII.2020: Replace various execve syscall hooks with one hook
 *                 of the function 'search_binary_handler'
 *  - Created:     18.IX.2017
 *
 * Author:
 *  - Adam 'pi3' Zabrocki (http://pi3.com.pl)
 *
 */

#ifndef P_LKRG_EXPLOIT_DETECTION_SECURITY_BPRM_COMMITTING_CREDS_H
#define P_LKRG_EXPLOIT_DETECTION_SECURITY_BPRM_COMMITTING_CREDS_H

/* per-instance private data */
struct p_security_bprm_committing_creds_data {
    ktime_t entry_stamp;
};

int p_security_bprm_committing_creds_entry(struct kretprobe_instance *p_ri, struct pt_regs *p_regs);
int p_security_bprm_committing_creds_ret(struct kretprobe_instance *p_ri, struct pt_regs *p_regs);
int p_install_security_bprm_committing_creds_hook(int p_isra);
void p_uninstall_security_bprm_committing_creds_hook(void);

#endif
