/***************************************************************************
                          game.h  -  description
                             -------------------
    begin                : Tue Feb 29 2000
    copyright            : (C) 2000 by Michael Speck
    email                : 
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef GAME_H
#define GAME_H

/**
  *@author Michael Speck
  */

#include "sdl.h"
#include "sndsrv.h"

//action types
#define AT_NONE		1000
#define AT_QUIT		1001
#define AT_HISCORE	1002
#define AT_NEWGAME	1003

class MenuManager;
class BreakOut;
class Menu;
class MenuItem;

class Game{
public: 
    Game();
    ~Game();
    void Run();
private:
    SDL_Surface *title;
    SDL_Surface *logo;
    int         logo_x;
    int         logo_y;
    SFnt        *f_menu_w;
    SFnt        *f_menu_b;
    SFnt        *f_hiscore;
    SFnt        *f_enlgt_hiscore;
    SFnt        *f_copy;
    MenuManager *mm;
    char        val_ctrl_keys[SDLK_LAST];
    BreakOut    *breakout;
    MenuItem    *level_sw;
    MenuItem    *level_menu;
#ifdef SOUND
    Wave        *snd_menu;
#endif
protected:
    void ShowHiScore(int r = -1);
    void CheckLevelFile();
};

#endif
