/* $Id: procterm.c,v 1.1 2011/06/01 02:42:25 ve3wwg Exp $
 * Warren W. Gay VE3WWG		Wed Feb 26 22:43:33 1997
 *
 * INTERPRET PROCESS TERMINATION:
 *
 * 	X LessTif WAV Play :
 * 
 * 	Copyright (C) 1997  Warren W. Gay VE3WWG
 * 
 * This  program is free software; you can redistribute it and/or modify it
 * under the  terms  of  the GNU General Public License as published by the
 * Free Software Foundation.
 * 
 * This  program  is  distributed  in  the hope that it will be useful, but
 * WITHOUT   ANY   WARRANTY;   without   even  the   implied   warranty  of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 * Public License for more details (licensed by file COPYING or GPLv*).
 */
static const char rcsid[] = "$Id: procterm.c,v 1.1 2011/06/01 02:42:25 ve3wwg Exp $";

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <signal.h>
#include <string.h>
#include <sys/types.h>
#include <sys/wait.h>

extern char *ProcTerm(int ProcStat);

/*
 * Return an interpreted text description of a process termination event.
 */
char *
ProcTerm(int ProcStat) {
	int ExitCode, Signal;
	static char buf[80];

	if ( ProcStat == 0 || WIFEXITED(ProcStat) ) {
		if ( !ProcStat )
			ExitCode = 0;					/* exit(0) */
		else	ExitCode = WEXITSTATUS(ProcStat);		/* exit(code) */
		sprintf(buf,"exit(%d)",ExitCode);

	} else if ( WIFSIGNALED(ProcStat) ) {
		Signal = WTERMSIG(ProcStat);				/* Signalled or aborted */
		sprintf(buf,"signal(%d)%s",Signal,WCOREDUMP(ProcStat)
				? ", core file written"
				: "");

	} else if ( WIFSTOPPED(ProcStat) ) {
		Signal = WSTOPSIG(ProcStat);				/* Stopped process */
		sprintf(buf,"stopsig(%d)",Signal);

	} else	sprintf(buf,"Weird termination 0x%04X",ProcStat);	/* Something weird */

	return buf;
}

/* $Source: /cvsroot/wavplay/code/src/procterm.c,v $ */
