pub const ext = @import("ext.zig");
const gstnet = @This();

const std = @import("std");
const compat = @import("compat");
const gst = @import("gst1");
const gobject = @import("gobject2");
const glib = @import("glib2");
const gmodule = @import("gmodule2");
const gio = @import("gio2");
/// `gstnet.NetClientClock` implements a custom `gst.Clock` that synchronizes its time
/// to a remote time provider such as `gstnet.NetTimeProvider`. `gstnet.NtpClock`
/// implements a `gst.Clock` that synchronizes its time to a remote NTPv4 server.
///
/// A new clock is created with `gstnet.NetClientClock.new` or
/// `gstnet.NtpClock.new`, which takes the address and port of the remote time
/// provider along with a name and an initial time.
///
/// This clock will poll the time provider and will update its calibration
/// parameters based on the local and remote observations.
///
/// The "round-trip" property limits the maximum round trip packets can take.
///
/// Various parameters of the clock can be configured with the parent `gst.Clock`
/// "timeout", "window-size" and "window-threshold" object properties.
///
/// A `gstnet.NetClientClock` and `gstnet.NtpClock` is typically set on a `gst.Pipeline` with
/// `gst.Pipeline.useClock`.
///
/// If you set a `gst.Bus` on the clock via the "bus" object property, it will
/// send `GST_MESSAGE_ELEMENT` messages with an attached `gst.Structure` containing
/// statistics about clock accuracy and network traffic.
pub const NetClientClock = extern struct {
    pub const Parent = gst.SystemClock;
    pub const Implements = [_]type{};
    pub const Class = gstnet.NetClientClockClass;
    f_clock: gst.SystemClock,
    f_priv: ?*gstnet.NetClientClockPrivate,
    f__gst_reserved: [4]*anyopaque,

    pub const virtual_methods = struct {};

    pub const properties = struct {
        pub const address = struct {
            pub const name = "address";

            pub const Type = ?[*:0]u8;
        };

        pub const base_time = struct {
            pub const name = "base-time";

            pub const Type = u64;
        };

        pub const bus = struct {
            pub const name = "bus";

            pub const Type = ?*gst.Bus;
        };

        pub const internal_clock = struct {
            pub const name = "internal-clock";

            pub const Type = ?*gst.Clock;
        };

        pub const minimum_update_interval = struct {
            pub const name = "minimum-update-interval";

            pub const Type = u64;
        };

        pub const port = struct {
            pub const name = "port";

            pub const Type = c_int;
        };

        pub const qos_dscp = struct {
            pub const name = "qos-dscp";

            pub const Type = c_int;
        };

        pub const round_trip_limit = struct {
            pub const name = "round-trip-limit";

            pub const Type = u64;
        };
    };

    pub const signals = struct {};

    /// Create a new `gstnet.NetClientClock` that will report the time
    /// provided by the `gstnet.NetTimeProvider` on `remote_address` and
    /// `remote_port`.
    extern fn gst_net_client_clock_new(p_name: ?[*:0]const u8, p_remote_address: [*:0]const u8, p_remote_port: c_int, p_base_time: gst.ClockTime) *gstnet.NetClientClock;
    pub const new = gst_net_client_clock_new;

    extern fn gst_net_client_clock_get_type() usize;
    pub const getGObjectType = gst_net_client_clock_get_type;

    extern fn g_object_ref(p_self: *gstnet.NetClientClock) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *gstnet.NetClientClock) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *NetClientClock, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// This object exposes the time of a `gst.Clock` on the network.
///
/// A `gstnet.NetTimeProvider` is created with `gstnet.NetTimeProvider.new` which
/// takes a `gst.Clock`, an address and a port number as arguments.
///
/// After creating the object, a client clock such as `gstnet.NetClientClock` can
/// query the exposed clock over the network for its values.
///
/// The `gstnet.NetTimeProvider` typically wraps the clock used by a `gst.Pipeline`.
pub const NetTimeProvider = extern struct {
    pub const Parent = gst.Object;
    pub const Implements = [_]type{gio.Initable};
    pub const Class = gstnet.NetTimeProviderClass;
    f_parent: gst.Object,
    f_priv: ?*gstnet.NetTimeProviderPrivate,
    f__gst_reserved: [4]*anyopaque,

    pub const virtual_methods = struct {};

    pub const properties = struct {
        pub const active = struct {
            pub const name = "active";

            pub const Type = c_int;
        };

        pub const address = struct {
            pub const name = "address";

            pub const Type = ?[*:0]u8;
        };

        pub const clock = struct {
            pub const name = "clock";

            pub const Type = ?*gst.Clock;
        };

        pub const port = struct {
            pub const name = "port";

            pub const Type = c_int;
        };

        pub const qos_dscp = struct {
            pub const name = "qos-dscp";

            pub const Type = c_int;
        };
    };

    pub const signals = struct {};

    /// Allows network clients to get the current time of `clock`.
    extern fn gst_net_time_provider_new(p_clock: *gst.Clock, p_address: ?[*:0]const u8, p_port: c_int) ?*gstnet.NetTimeProvider;
    pub const new = gst_net_time_provider_new;

    extern fn gst_net_time_provider_get_type() usize;
    pub const getGObjectType = gst_net_time_provider_get_type;

    extern fn g_object_ref(p_self: *gstnet.NetTimeProvider) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *gstnet.NetTimeProvider) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *NetTimeProvider, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const NtpClock = extern struct {
    pub const Parent = gstnet.NetClientClock;
    pub const Implements = [_]type{};
    pub const Class = gstnet.NtpClockClass;
    f_clock: gst.SystemClock,
    f_priv: ?*gstnet.NetClientClockPrivate,
    f__gst_reserved: [4]*anyopaque,

    pub const virtual_methods = struct {};

    pub const properties = struct {};

    pub const signals = struct {};

    /// Create a new `gstnet.NtpClock` that will report the time provided by
    /// the NTPv4 server on `remote_address` and `remote_port`.
    extern fn gst_ntp_clock_new(p_name: ?[*:0]const u8, p_remote_address: [*:0]const u8, p_remote_port: c_int, p_base_time: gst.ClockTime) *gstnet.NtpClock;
    pub const new = gst_ntp_clock_new;

    extern fn gst_ntp_clock_get_type() usize;
    pub const getGObjectType = gst_ntp_clock_get_type;

    extern fn g_object_ref(p_self: *gstnet.NtpClock) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *gstnet.NtpClock) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *NtpClock, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// GstPtpClock implements a PTP (IEEE1588:2008) ordinary clock in slave-only
/// mode, that allows a GStreamer pipeline to synchronize to a PTP network
/// clock in some specific domain.
///
/// The PTP subsystem can be initialized with `gstnet.ptpInit`, which then starts
/// a helper process to do the actual communication via the PTP ports. This is
/// required as PTP listens on ports < 1024 and thus requires special
/// privileges. Once this helper process is started, the main process will
/// synchronize to all PTP domains that are detected on the selected
/// interfaces.
///
/// `gstnet.PtpClock.new` then allows to create a GstClock that provides the PTP
/// time from a master clock inside a specific PTP domain. This clock will only
/// return valid timestamps once the timestamps in the PTP domain are known. To
/// check this, you can use `gst.Clock.waitForSync`, the GstClock::synced
/// signal and `gst.Clock.isSynced`.
///
/// To gather statistics about the PTP clock synchronization,
/// `gstnet.ptpStatisticsCallbackAdd` can be used. This gives the application
/// the possibility to collect all kinds of statistics from the clock
/// synchronization.
pub const PtpClock = extern struct {
    pub const Parent = gst.SystemClock;
    pub const Implements = [_]type{};
    pub const Class = gstnet.PtpClockClass;
    f_clock: gst.SystemClock,
    f_priv: ?*gstnet.PtpClockPrivate,
    f__gst_reserved: [4]*anyopaque,

    pub const virtual_methods = struct {};

    pub const properties = struct {
        pub const domain = struct {
            pub const name = "domain";

            pub const Type = c_uint;
        };

        pub const grandmaster_clock_id = struct {
            pub const name = "grandmaster-clock-id";

            pub const Type = u64;
        };

        pub const internal_clock = struct {
            pub const name = "internal-clock";

            pub const Type = ?*gst.Clock;
        };

        pub const master_clock_id = struct {
            pub const name = "master-clock-id";

            pub const Type = u64;
        };
    };

    pub const signals = struct {};

    /// Creates a new PTP clock instance that exports the PTP time of the master
    /// clock in `domain`. This clock can be slaved to other clocks as needed.
    ///
    /// If `gstnet.ptpInit` was not called before, this will call `gstnet.ptpInit` with
    /// default parameters.
    ///
    /// This clock only returns valid timestamps after it received the first
    /// times from the PTP master clock on the network. Once this happens the
    /// GstPtpClock::internal-clock property will become non-NULL. You can
    /// check this with `gst.Clock.waitForSync`, the GstClock::synced signal and
    /// `gst.Clock.isSynced`.
    extern fn gst_ptp_clock_new(p_name: [*:0]const u8, p_domain: c_uint) *gstnet.PtpClock;
    pub const new = gst_ptp_clock_new;

    extern fn gst_ptp_clock_get_type() usize;
    pub const getGObjectType = gst_ptp_clock_get_type;

    extern fn g_object_ref(p_self: *gstnet.PtpClock) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *gstnet.PtpClock) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *PtpClock, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// `gstnet.NetAddressMeta` can be used to store a network address (a `gio.SocketAddress`)
/// in a `gst.Buffer` so that it network elements can track the to and from address
/// of the buffer.
pub const NetAddressMeta = extern struct {
    /// the parent type
    f_meta: gst.Meta,
    /// a `gio.SocketAddress` stored as metadata
    f_addr: ?*gio.SocketAddress,

    extern fn gst_net_address_meta_get_info() *const gst.MetaInfo;
    pub const getInfo = gst_net_address_meta_get_info;
};

pub const NetClientClockClass = extern struct {
    pub const Instance = gstnet.NetClientClock;

    f_parent_class: gst.SystemClockClass,
    f__gst_reserved: [4]*anyopaque,

    pub fn as(p_instance: *NetClientClockClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const NetClientClockPrivate = opaque {};

/// `gstnet.NetControlMessageMeta` can be used to store control messages (ancillary
/// data) which was received with or is to be sent alongside the buffer data.
/// When used with socket sinks and sources which understand this meta it allows
/// sending and receiving ancillary data such as unix credentials (See
/// `gio.UnixCredentialsMessage`) and Unix file descriptions (See `gio.UnixFDMessage`).
pub const NetControlMessageMeta = extern struct {
    /// the parent type
    f_meta: gst.Meta,
    /// a `gio.SocketControlMessage` stored as metadata
    f_message: ?*gio.SocketControlMessage,

    extern fn gst_net_control_message_meta_get_info() *const gst.MetaInfo;
    pub const getInfo = gst_net_control_message_meta_get_info;
};

/// Various functions for receiving, sending an serializing `gstnet.NetTimePacket`
/// structures.
pub const NetTimePacket = extern struct {
    /// the local time when this packet was sent
    f_local_time: gst.ClockTime,
    /// the remote time observation
    f_remote_time: gst.ClockTime,

    /// Receives a `gstnet.NetTimePacket` over a socket. Handles interrupted system
    /// calls, but otherwise returns NULL on error.
    extern fn gst_net_time_packet_receive(p_socket: *gio.Socket, p_src_address: ?**gio.SocketAddress, p_error: ?*?*glib.Error) ?*gstnet.NetTimePacket;
    pub const receive = gst_net_time_packet_receive;

    /// Creates a new `gstnet.NetTimePacket` from a buffer received over the network. The
    /// caller is responsible for ensuring that `buffer` is at least
    /// `GST_NET_TIME_PACKET_SIZE` bytes long.
    ///
    /// If `buffer` is `NULL`, the local and remote times will be set to
    /// `GST_CLOCK_TIME_NONE`.
    ///
    /// MT safe. Caller owns return value (gst_net_time_packet_free to free).
    extern fn gst_net_time_packet_new(p_buffer: ?*const [16]u8) *gstnet.NetTimePacket;
    pub const new = gst_net_time_packet_new;

    /// Make a copy of `packet`.
    extern fn gst_net_time_packet_copy(p_packet: *const NetTimePacket) *gstnet.NetTimePacket;
    pub const copy = gst_net_time_packet_copy;

    /// Free `packet`.
    extern fn gst_net_time_packet_free(p_packet: *NetTimePacket) void;
    pub const free = gst_net_time_packet_free;

    /// Sends a `gstnet.NetTimePacket` over a socket.
    ///
    /// MT safe.
    extern fn gst_net_time_packet_send(p_packet: *const NetTimePacket, p_socket: *gio.Socket, p_dest_address: *gio.SocketAddress, p_error: ?*?*glib.Error) c_int;
    pub const send = gst_net_time_packet_send;

    /// Serialized a `gstnet.NetTimePacket` into a newly-allocated sequence of
    /// `GST_NET_TIME_PACKET_SIZE` bytes, in network byte order. The value returned is
    /// suitable for passing to write(2) or sendto(2) for communication over the
    /// network.
    ///
    /// MT safe. Caller owns return value (g_free to free).
    extern fn gst_net_time_packet_serialize(p_packet: *const NetTimePacket) *[16]u8;
    pub const serialize = gst_net_time_packet_serialize;

    extern fn gst_net_time_packet_get_type() usize;
    pub const getGObjectType = gst_net_time_packet_get_type;
};

pub const NetTimeProviderClass = extern struct {
    pub const Instance = gstnet.NetTimeProvider;

    f_parent_class: gst.ObjectClass,
    f__gst_reserved: [4]*anyopaque,

    pub fn as(p_instance: *NetTimeProviderClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const NetTimeProviderPrivate = opaque {};

pub const NtpClockClass = extern struct {
    pub const Instance = gstnet.NtpClock;

    f_parent_class: gst.SystemClockClass,
    f__gst_reserved: [4]*anyopaque,

    pub fn as(p_instance: *NtpClockClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// Opaque `gstnet.PtpClockClass` structure.
pub const PtpClockClass = extern struct {
    pub const Instance = gstnet.PtpClock;

    /// parented to `gst.SystemClockClass`
    f_parent_class: gst.SystemClockClass,
    f__gst_reserved: [4]*anyopaque,

    pub fn as(p_instance: *PtpClockClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const PtpClockPrivate = opaque {};

/// Attaches `addr` as metadata in a `gstnet.NetAddressMeta` to `buffer`.
extern fn gst_buffer_add_net_address_meta(p_buffer: *gst.Buffer, p_addr: *gio.SocketAddress) *gstnet.NetAddressMeta;
pub const bufferAddNetAddressMeta = gst_buffer_add_net_address_meta;

/// Attaches `message` as metadata in a `gstnet.NetControlMessageMeta` to `buffer`.
extern fn gst_buffer_add_net_control_message_meta(p_buffer: *gst.Buffer, p_message: *gio.SocketControlMessage) *gstnet.NetControlMessageMeta;
pub const bufferAddNetControlMessageMeta = gst_buffer_add_net_control_message_meta;

/// Find the `gstnet.NetAddressMeta` on `buffer`.
extern fn gst_buffer_get_net_address_meta(p_buffer: *gst.Buffer) ?*gstnet.NetAddressMeta;
pub const bufferGetNetAddressMeta = gst_buffer_get_net_address_meta;

extern fn gst_net_address_meta_api_get_type() usize;
pub const netAddressMetaApiGetType = gst_net_address_meta_api_get_type;

extern fn gst_net_control_message_meta_api_get_type() usize;
pub const netControlMessageMetaApiGetType = gst_net_control_message_meta_api_get_type;

/// Configures IP_TOS value of socket, i.e. sets QoS DSCP.
extern fn gst_net_utils_set_socket_tos(p_socket: *gio.Socket, p_qos_dscp: c_int) c_int;
pub const netUtilsSetSocketTos = gst_net_utils_set_socket_tos;

/// Deinitialize the GStreamer PTP subsystem and stop the PTP clock. If there
/// are any remaining GstPtpClock instances, they won't be further synchronized
/// to the PTP network clock.
extern fn gst_ptp_deinit() void;
pub const ptpDeinit = gst_ptp_deinit;

/// Initialize the GStreamer PTP subsystem and create a PTP ordinary clock in
/// slave-only mode for all domains on the given `interfaces` with the
/// given `clock_id`.
///
/// If `clock_id` is `GST_PTP_CLOCK_ID_NONE`, a clock id is automatically
/// generated from the MAC address of the first network interface.
///
/// This function is automatically called by `gstnet.PtpClock.new` with default
/// parameters if it wasn't called before.
extern fn gst_ptp_init(p_clock_id: u64, p_interfaces: ?[*][*:0]u8) c_int;
pub const ptpInit = gst_ptp_init;

/// Initialize the GStreamer PTP subsystem and create a PTP ordinary clock in
/// slave-only mode according to the `config`.
///
/// `config` is a `gst.Structure` with the following optional fields:
/// * `guint64` `clock-id`: The clock ID to use for the local clock. If the
///     clock-id is not provided or `GST_PTP_CLOCK_ID_NONE` is provided, a clock
///     id is automatically generated from the MAC address of the first network
///     interface.
/// * `glib.Strv` `interfaces`: The interface names to listen on for PTP packets. If
///     none are provided then all compatible interfaces will be used.
/// * `guint` `ttl`: The TTL to use for multicast packets sent out by GStreamer.
///     This defaults to 1, i.e. packets will not leave the local network.
///
/// This function is automatically called by `gstnet.PtpClock.new` with default
/// parameters if it wasn't called before.
extern fn gst_ptp_init_full(p_config: *const gst.Structure) c_int;
pub const ptpInitFull = gst_ptp_init_full;

/// Check if the GStreamer PTP clock subsystem is initialized.
extern fn gst_ptp_is_initialized() c_int;
pub const ptpIsInitialized = gst_ptp_is_initialized;

/// Check if PTP clocks are generally supported on this system, and if previous
/// initializations did not fail.
extern fn gst_ptp_is_supported() c_int;
pub const ptpIsSupported = gst_ptp_is_supported;

/// Installs a new statistics callback for gathering PTP statistics. See
/// GstPtpStatisticsCallback for a list of statistics that are provided.
extern fn gst_ptp_statistics_callback_add(p_callback: gstnet.PtpStatisticsCallback, p_user_data: ?*anyopaque, p_destroy_data: ?glib.DestroyNotify) c_ulong;
pub const ptpStatisticsCallbackAdd = gst_ptp_statistics_callback_add;

/// Removes a PTP statistics callback that was previously added with
/// `gstnet.ptpStatisticsCallbackAdd`.
extern fn gst_ptp_statistics_callback_remove(p_id: c_ulong) void;
pub const ptpStatisticsCallbackRemove = gst_ptp_statistics_callback_remove;

/// The statistics can be the following structures:
///
/// GST_PTP_STATISTICS_NEW_DOMAIN_FOUND:
/// "domain"                G_TYPE_UINT          The domain identifier of the domain
/// "clock"                 GST_TYPE_CLOCK       The internal clock that is slaved to the
///                                              PTP domain
///
/// GST_PTP_STATISTICS_BEST_MASTER_CLOCK_SELECTED:
/// "domain"                G_TYPE_UINT          The domain identifier of the domain
/// "master-clock-id"       G_TYPE_UINT64        PTP clock identifier of the selected master
///                                              clock
/// "master-clock-port"     G_TYPE_UINT          PTP port number of the selected master clock
/// "grandmaster-clock-id"  G_TYPE_UINT64        PTP clock identifier of the grandmaster clock
///
/// GST_PTP_STATISTICS_PATH_DELAY_MEASURED:
/// "domain"                G_TYPE_UINT          The domain identifier of the domain
/// "mean-path-delay-avg"   GST_TYPE_CLOCK_TIME  Average mean path delay
/// "mean-path-delay"       GST_TYPE_CLOCK_TIME  Latest mean path delay
/// "delay-request-delay"   GST_TYPE_CLOCK_TIME  Delay of DELAY_REQ / DELAY_RESP messages
///
/// GST_PTP_STATISTICS_TIME_UPDATED:
/// "domain"                G_TYPE_UINT          The domain identifier of the domain
/// "mean-path-delay-avg"   GST_TYPE_CLOCK_TIME  Average mean path delay
/// "local-time"            GST_TYPE_CLOCK_TIME  Local time that corresponds to ptp-time
/// "ptp-time"              GST_TYPE_CLOCK_TIME  Newly measured PTP time at local-time
/// "estimated-ptp-time"    GST_TYPE_CLOCK_TIME  Estimated PTP time based on previous measurements
/// "discontinuity"         G_TYPE_INT64         Difference between estimated and measured PTP time
/// "synced"                G_TYPE_BOOLEAN       Currently synced to the remote clock
/// "r-squared"             G_TYPE_DOUBLE        R² of clock estimation regression
/// "internal-time"         GST_TYPE_CLOCK_TIME  Internal time clock parameter
/// "external-time"         GST_TYPE_CLOCK_TIME  External time clock parameter
/// "rate-num"              G_TYPE_UINT64        Internal/external rate numerator
/// "rate-den"              G_TYPE_UINT64        Internal/external rate denominator
/// "rate"                  G_TYPE_DOUBLE        Internal/external rate
///
/// If `FALSE` is returned, the callback is removed and never called again.
pub const PtpStatisticsCallback = *const fn (p_domain: u8, p_stats: *const gst.Structure, p_user_data: ?*anyopaque) callconv(.C) c_int;

/// The size of the packets sent between network clocks.
pub const NET_TIME_PACKET_SIZE = 16;
/// PTP clock identification that can be passed to `gstnet.ptpInit` to
/// automatically select one based on the MAC address of interfaces
pub const PTP_CLOCK_ID_NONE = 18446744073709551615;
pub const PTP_STATISTICS_BEST_MASTER_CLOCK_SELECTED = "GstPtpStatisticsBestMasterClockSelected";
pub const PTP_STATISTICS_NEW_DOMAIN_FOUND = "GstPtpStatisticsNewDomainFound";
pub const PTP_STATISTICS_PATH_DELAY_MEASURED = "GstPtpStatisticsPathDelayMeasured";
pub const PTP_STATISTICS_TIME_UPDATED = "GstPtpStatisticsTimeUpdated";
