#! /usr/bin/env python

# This Python script was auto-generated using YODA v1.9.8.
# Analysis object: /ATLAS_2010_S8918562/d14-x01-y01
# Timestamp: 01-05-2023 (12:50:08)

import matplotlib as mpl
import matplotlib.pyplot as plt
mpl.use('Agg') # comment out for interactive use
import sys, os
import numpy as np

plotDir = os.path.split(os.path.realpath(__file__))[0]

#plot style
plt.style.use(os.path.join(plotDir, '../default.mplstyle'))
# plot metadata
figW, figH = plt.rcParams['figure.figsize']
ax_xLabel = r'$p_\perp$ $\;$ [GeV]'
ax_yLabel = r'$1/N_\mathrm{ev} \, 1/2\pi{}p_\perp \, \mathrm{d}\sigma/\mathrm{d}\eta\mathrm{d}p_\perp$'
ax_title  = r'Charged particle $p_\perp$ at 7$\,$TeV, track $p_\perp > 500\,\mathrm{MeV}$, for $N_\mathrm{ch} \geq 6$'
ax_xScale = 'log'
ax_yScale = 'log'
xLims = (0.5, 50.0)
yLims = (9e-11, 11.0)
# TeX-friendly labels for the legend
labels = [ r"Data", r"mc1", r"mc2" ]

# Create figure and axis objects
fig, (ax, ratio0_ax) = plt.subplots(2, 1, sharex=True,
                  figsize=(figW,figH), gridspec_kw={'height_ratios': (2, 1)})
ratio0_ax.yaxis.set_major_locator(mpl.ticker.MultipleLocator(0.1))
ratio0_ax.set_ylabel('MC/Data')
ratio0_ax.set_ylim(0.5, 1.4999)
colors = {0: '#EE3311', 1: '#3366FF', 2: '#109618', 3: '#FF9900', 4: '#990099'}
# the numerical data is stored in a separate file
dataf = dict()
prefix = os.path.split(__file__)[0]
if prefix:    prefix = prefix + '/'
exec(open(prefix+'d14-x01-y01__data.py').read(), dataf)


legend_handles = [] # keep track of handles for the legend

# reference data in main panel
ref_curve = ax.errorbar(dataf['xpoints'], dataf['ref_yvals'],
                        xerr=dataf['xerrs'], yerr=dataf['ref_errs'],
                        fmt='o', ecolor = 'black', color='black', zorder=2)
legend_handles += [ ref_curve ]

# style options for curves
# starts at zorder>=5 to draw curve on top of legend
styles = {
  'curve1': {
    'color' : colors[0],
    'linestyle' : '-',
    'zorder' : 6,
  },
  'curve2': {
    'color' : colors[1],
    'linestyle' : '-',
    'zorder' : 7,
  },
}
# curve from input yoda files in main panel
for label in dataf['yvals'].keys():
    tmp, = ax.plot(dataf['xedges'], dataf['yedges'][label],
                   color=styles[label]['color'],
                   linestyle=styles[label]['linestyle'],
                   drawstyle='steps-pre', solid_joinstyle='miter',
                   zorder=styles[label]['zorder'], label=label)
    legend_handles += [tmp]
    ax.errorbar(dataf['xpoints'], dataf['yvals'][label], color=styles[label]['color'],
                xerr=dataf['xerrs'], yerr=[dataf['ydowns'][label], dataf['yups'][label]],
                linestyle='none', zorder=styles[label]['zorder'])
    for varLabel in dataf['variation_yvals'].keys():
        if varLabel.startswith(label):
            tmp, = ax.plot(dataf['xedges'], dataf['variation_yvals'][varLabel],
                           color=styles[label]['color'],
                           linestyle=styles[label]['linestyle'],
                           drawstyle='steps-pre', solid_joinstyle='miter',
                           zorder=styles[label]['zorder'], alpha=0.5)


# plots on ratio panel
# reference data
ratio0_ax.errorbar(dataf['xpoints'], [1.] * len(dataf['xpoints']),
              xerr=dataf['xerrs'], yerr=dataf['ratio0_ref_errs'],
              fmt='o', ecolor = 'black', color='black')
# curve from input yoda files in ratio panel
for label,yvals in dataf['ratio0_yvals'].items():
    ratio0_ax.plot(dataf['xedges'], yvals,
                  color=styles[label]['color'],
                  linestyle=styles[label]['linestyle'],
                  drawstyle='steps-pre', zorder=1,
                  solid_joinstyle='miter')
    ratio0_ax.vlines(dataf['xpoints'],
                dataf['ratio0_ydowns'][label], dataf['ratio0_yups'][label],
                color=styles[label]['color'], zorder=1)

    # try drawing the error bands around the ratio lines
    try:
        ratio0_ax.fill_between(dataf['xedges'],
                              dataf['ratio_band_edges']['ratio0_'+label+'_band_dn'],
                              dataf['ratio_band_edges']['ratio0_'+label+'_band_up'],
                              color=styles[label]['color'],
                              alpha=0.2,step='pre',
                              zorder=styles[label]['zorder'],edgecolor=None)
    except:
        pass  # Band information not available for this curve

legend_pos = (0.5, 0.97)
ax.legend(legend_handles, labels, loc='upper left', bbox_to_anchor=legend_pos)

# set plot metadata as defined above
ratio0_ax.set_xlabel(ax_xLabel)
ax.set_ylabel(ax_yLabel, loc='top')
ax.set_title(ax_title, loc='left')
ax.set_xscale(ax_xScale)
ax.set_yscale(ax_yScale)
ax.set_xlim(xLims)
ax.set_ylim(yLims)

# tick formatting
plt.rcParams['xtick.top'] = True
plt.rcParams['ytick.right'] = True
ax.yaxis.set_major_locator(mpl.ticker.LogLocator(base=10.0, numticks=np.inf))
ax.yaxis.set_minor_locator(mpl.ticker.LogLocator(
                           base=10.0, subs=np.arange(0.1, 1, 0.1), numticks=np.inf))
fig.align_ylabels((ax, ratio0_ax))
plt.savefig(os.path.join(plotDir, 'd14-x01-y01.pdf'), format='PDF')
plt.savefig(os.path.join(plotDir, 'd14-x01-y01.png'), format='PNG')

plt.close(fig)