// -*- C++ -*-
#include "Rivet/Analysis.hh"
#include "Rivet/Projections/UnstableParticles.hh"
#include "Rivet/Projections/DecayedParticles.hh"

namespace Rivet {


  /// @brief  psi(2S) -> gamma pi+pi- / K+K- 
  class BES_2003_I563492 : public Analysis {
  public:

    /// Constructor
    RIVET_DEFAULT_ANALYSIS_CTOR(BES_2003_I563492);


    /// @name Analysis methods
    /// @{

    /// Book histograms and initialise projections before the run
    void init() {
      // Initialise and register projections
      UnstableParticles ufs = UnstableParticles(Cuts::abspid==100443);
      declare(ufs, "UFS");
      DecayedParticles PSI(ufs);
      PSI.addStable(PID::ETA);
      PSI.addStable(PID::PI0);
      declare(PSI, "PSI");
      // histos
      for(unsigned int ix=0;ix<2;++ix)
	book(_h[ix],1+ix,1,1);
    }


    /// Perform the per-event analysis
    void analyze(const Event& event) {
      // find the J/psi decays
      static const map<PdgId,unsigned int> & mode1 = { { 211,1}, {-211,1}, { 22,1}};
      static const map<PdgId,unsigned int> & mode2 = { { 321,1}, {-321,1}, { 22,1}};
      DecayedParticles PSI = apply<DecayedParticles>(event, "PSI");
      // loop over particles
      for(unsigned int ix=0;ix<PSI.decaying().size();++ix) {
	unsigned int imode=0;
	if(PSI.modeMatches(ix,3,mode1))      imode=0;
	else if(PSI.modeMatches(ix,3,mode2)) imode=1;
	else continue;
	const Particle  & gam = PSI.decayProducts()[0].at( 22)[0];
	_h[imode]->fill((PSI.decaying()[ix].momentum()-gam.momentum()).mass());
      }
    }


    /// Normalise histograms etc., after the run
    void finalize() {
      for(unsigned int ix=0;ix<2;++ix)
	normalize(_h[ix],1.,false);
    }

    /// @}


    /// @name Histograms
    /// @{
    Histo1DPtr _h[2];
    /// @}


  };


  RIVET_DECLARE_PLUGIN(BES_2003_I563492);

}
