/*
 *
 * Copyright (c) 2007-2016 The University of Waikato, Hamilton, New Zealand.
 * All rights reserved.
 *
 * This file is part of libtrace.
 *
 * This code has been developed by the University of Waikato WAND
 * research group. For further information please see http://www.wand.net.nz/
 *
 * libtrace is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * libtrace is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *
 */

#include <stdlib.h>
#include "libtrace.h"

void *trace_get_payload_from_vxlan(libtrace_vxlan_t *vxlan, uint32_t *remaining)
{
    if (remaining) {
        if (*remaining < sizeof(*vxlan)) {
            *remaining = 0;
            return NULL;
        }

        *remaining -= sizeof(*vxlan);
    }

    return (void*)((char *)vxlan + sizeof(*vxlan));
}


libtrace_vxlan_t *trace_get_vxlan_from_udp(libtrace_udp_t *udp,
        uint32_t *remaining)
{
    if (udp->dest != htons(4789)) { /* UDP port number for vxlan */
        return NULL; /* Not a vxlan packet. */
    }

    return trace_get_payload_from_udp(udp, remaining);
}



