# Announce: Rakudo compiler, Release 2021.02.1

On behalf of the Rakudo development team, I'm announcing an
out-of-schedule release of the Rakudo compiler.
Rakudo is an implementation of the Raku[^1] language.

This release is a point release in addition to the regular, monthly
releases. This release fixes a regression in behavior of
lazy iterables and cleans some introduced unstable tests.

The tarball for this release is available from <http://rakudo.org/downloads/rakudo/>.
Pre-compiled archives will be available shortly.

The changes in this release are outlined below:

New in 2021.02.1:
  + Fixes:
    + Fix a regression of the 2021.02 release where a lazy iterable usage could suddenly
      lead to a hang [5eeddd37][6d164158][7d6e4322]
    + Fix calling `list` and `iterator` methods on `Map` and `Array` type objects [6b83135a]
    + Fix a minor memory leak in Rakudo runner [18735ae9]
  + Internal:
    + Remove newly introduced, but unreliable inlining tests [a5ca53a8]

The following people contributed to this release:

Elizabeth Mattijsen, Stefan Seifert, Daniel Green, Alexander Kiryuhin

This release implements 6.c and 6.d versions of the Raku specification.
6.c version of the language is available if you use the `use v6.c`
version pragma, otherwise 6.d is the default.

Upcoming releases in 2020 will include new functionality that is not
part of 6.c or 6.d specifications, available with a lexically scoped
pragma. Our goal is to ensure that anything that is tested as part of
6.c and 6.d specifications will continue to work unchanged. There may
be incremental spec releases this year as well.

If you would like to contribute or get more information, visit
<https://raku.org>, <https://rakudo.org/community>, ask on the
<perl6-compiler@perl.org> mailing list, or ask on IRC #raku on freenode.

Additionally, we invite you to make a donation to The Perl Foundation
to sponsor Raku development: <https://donate.perlfoundation.org/>
(put “Raku Core Development Fund” in the ‘Purpose’ text field)

The next release of Rakudo (#144), is tentatively scheduled for 2021-03-20.

A list of the other planned release dates is available in the
“docs/release_guide.pod” file.

The development team appreciates feedback! If you’re using Rakudo, do
get back to us. Questions, comments, suggestions for improvements, cool
discoveries, incredible hacks, or any other feedback -- get in touch with
us through (the above-mentioned) mailing list or IRC channel. Enjoy!

Please note that recent releases have known issues running on the JVM.
We are working to get the JVM backend working again but do not yet have
an estimated delivery date.

[^1]: See <https://raku.org/>
