/*
*  qm_config.h
*  QUIMUP configuration class
*  © 2008-2024 Johan Spee
*  SPDX-License-Identifier: GPL-3.0-or-later
*/

#ifndef QM_CONFIG_H
#define QM_CONFIG_H

#include <QString>

class qm_Config
{
public:
    qm_Config(bool);
    virtual ~qm_Config ();

    QString version;
    QString version_previous;
    bool cout_extensive;
    bool this_is_wayland;

    // server
    bool onquit_quitmpd;
    QString onquit_mpd_command;
    bool onstart_startmpd;
    QString onstart_mpd_command;
    bool auto_connect;
    bool auto_re_connect;
    int mpd_timeout;
    int mpd_pollfreq;

    bool start_minimized;
    int profile_current;

    QString profile_name_0;
    QString profile_note_0;
    QString profile_host_0;
    uint    profile_port_0;
    QString profile_pswd_0;
    QString profile_mdir_0;

    QString profile_name_1;
    QString profile_note_1;
    QString profile_host_1;
    uint    profile_port_1;
    QString profile_pswd_1;
    QString profile_mdir_1;

    QString profile_name_2;
    QString profile_note_2;
    QString profile_host_2;
    uint    profile_port_2;
    QString profile_pswd_2;
    QString profile_mdir_2;

    QString profile_name_3;
    QString profile_note_3;
    QString profile_host_3;
    uint    profile_port_3;
    QString profile_pswd_3;
    QString profile_mdir_3;

    QString profile_name_4;
    QString profile_note_4;
    QString profile_host_4;
    uint    profile_port_4;
    QString profile_pswd_4;
    QString profile_mdir_4;

    QString mpd_musicpath;  	// not saved
    int mpd_musicdir_status;  	// not saved
    QString mpd_process_owner;  // not saved
    bool mpd_is_installed;      // not saved
    bool mpd_op_listall_allowed;// not saved
    bool mpd_op_disable_allowed;// not saved
    bool mpd_op_enable_allowed; // not saved
    bool mpd_update_allowed; 	// not saved
    bool mpd_deleteid_allowed; 	// not saved
    bool mpd_delete_allowed; 	// not saved
    bool mpd_save_allowed;  	// not saved
    bool mpd_single_allowed; 	// not saved
    bool mpd_consume_allowed; 	// not saved
    bool mpd_xfade_allowed;  	// not saved
    bool mpd_repeat_allowed; 	// not saved
    bool mpd_random_allowed; 	// not saved
    bool mpd_rescan_allowed; 	// not saved
    bool mpd_shuffle_allowed; 	// not saved
    bool mpd_rm_allowed;  		// not saved
    bool mpd_config_allowed;  	// not saved
    bool mpd_albumart_allowed;  // not saved
    bool mpd_readpic_allowed;  	// not saved
    bool mpd_socket_conn;  		// not saved
    bool mpd_setrpgain_allowed; // not saved
    bool mpd_stats_allowed;  	// not saved
    bool mpd_clear_allowed;  	// not saved

    bool xfade_is_on;  			// not saved
    uint  xfade_time;           // not saved

    // player'
    QString tag_editor;
    QString image_viewer;
    QString file_manager;
    bool tag_editor_installed;      // not saved
    bool image_viewer_installed;    // not saved
    bool file_manager_installed;    // not saved
    QString replaygain_mode;
    int player_X;
    int player_Y;
    int albumart_size;
    bool player_maxmode;
    bool use_trayicon;
    bool use_timeleft;
    // browser
    int browser_X;
    int browser_Y;
    int browser_W;
    int browser_H;
    int browser_L_splitter;
    int browser_R_splitter;
    int browser_libmode;
    int browser_searchmode;
    int browser_selectmode;
    int lib_column_count;
    bool library_autocols;
    bool playlist_autocols;
    bool sort_albums_year;
    bool ignore_leading_the;
    bool albumart_custom;
    QString custom_albumart_file;
    bool auto_playfirst;
    bool mark_whenplayed;
    QString search_string;
    QString select_string;
    // settings
    int settings_X;
    int settings_Y;
    int settings_W;
    int settings_H;
    QString font_family;
    int  font_title_size;
    bool font_title_bold;
    bool font_title_italic;
    int  font_codecinfo_size;
    bool font_codecinfo_bold;
    int  font_time_size;
    bool font_time_bold;
    int  font_album_size;
    bool font_album_bold;
    int  font_year_size;
    bool font_year_bold;
    int  font_browser_size;
    int  font_comment_size;
    bool font_comment_italic;
    QString color_cus_fg_title;
    QString color_cus_bg_title;
    QString color_cus_fg_album;
    QString color_cus_bg_album;
    QString color_def_fg_title;
    QString color_def_bg_title;
    QString color_def_fg_album;
    QString color_def_bg_album;
    QString color_alt_fg_title;
    QString color_alt_bg_title;
    QString color_alt_fg_album;
    QString color_alt_bg_album;
    bool set_dark_theme;
    bool colors_system;
    bool colors_default;
    bool colors_cutom;
    bool show_tooltips;
    bool colfor_browser;
    bool colfor_albuminfo;
    bool colfor_progressbar;
    // user actions
    bool usract1_enabled;
    bool usract1_fileparm;
    QString usract1_label;
    QString usract1_command;
    bool usract2_enabled;
    bool usract2_fileparm;
    QString usract2_label;
    QString usract2_command;
    //  functions
    void  save_config();
    void  load_config();
    void  reset_temps();

private:
    bool b_cout;
};


#endif // QM_CONFIG_H
