/*
 * DO NOT EDIT THIS FILE. Generated by checkmk.
 * Edit the original source file "../../libdrgn/tests/serialize.c.in" instead.
 */

#include <check.h>

#line 1 "../../libdrgn/tests/serialize.c.in"
// Copyright (c) Meta Platforms, Inc. and affiliates.
// SPDX-License-Identifier: LGPL-2.1-or-later

#include "test_util.h"
#include "../serialize.h"
#include "../util.h"

struct foo64 {
	uint64_t big;
	uint32_t medium;
	uint16_t small;
	uint8_t tiny;
	uint8_t array[3];
};

struct foo32 {
	uint32_t big;
	uint16_t medium;
	uint8_t small;
	uint8_t tiny;
	uint8_t array[3];
};

#define visit_foo_members(visit_scalar_member, visit_raw_member) do {	\
	visit_scalar_member(big);					\
	visit_scalar_member(medium);					\
	visit_scalar_member(small);					\
	visit_scalar_member(tiny);					\
	visit_raw_member(array);					\
} while (0)



START_TEST(deserialize_struct64_64le)
{
#line 37
{
	uint8_t buf[24] = {
		0x00, 0xf2, 0x05, 0x2a, 0x01, 0x00, 0x00, 0x00,
		0xa0, 0x86, 0x01, 0x00,
		0x20, 0x03,
		0x0a,
		0x41, 0x42, 0x43,
	};
	struct foo64 foo;
	deserialize_struct64(&foo, struct foo32, visit_foo_members, buf, true,
			     !HOST_LITTLE_ENDIAN);
	ck_assert_uint_eq(foo.big, 5000000000);
	ck_assert_uint_eq(foo.medium, 100000);
	ck_assert_uint_eq(foo.small, 800);
	ck_assert_uint_eq(foo.tiny, 10);
	ck_assert_mem_eq(foo.array, "ABC", 3);
}

}
END_TEST

START_TEST(deserialize_struct64_64be)
{
#line 56
{
	uint8_t buf[24] = {
		0x00, 0x00, 0x00, 0x01, 0x2a, 0x05, 0xf2, 0x00,
		0x00, 0x01, 0x86, 0xa0,
		0x03, 0x20,
		0x0a,
		0x41, 0x42, 0x43,
	};
	struct foo64 foo;
	deserialize_struct64(&foo, struct foo32, visit_foo_members, buf, true,
			     HOST_LITTLE_ENDIAN);
	ck_assert_uint_eq(foo.big, 5000000000);
	ck_assert_uint_eq(foo.medium, 100000);
	ck_assert_uint_eq(foo.small, 800);
	ck_assert_uint_eq(foo.tiny, 10);
	ck_assert_mem_eq(foo.array, "ABC", 3);
}

}
END_TEST

START_TEST(deserialize_struct64_32le)
{
#line 75
{
	uint8_t buf[12] = {
		0x00, 0x5e, 0xd0, 0xb2,
		0x10, 0x27,
		0x64,
		0x0d,
		0x41, 0x42, 0x43,
	};
	struct foo64 foo;
	deserialize_struct64(&foo, struct foo32, visit_foo_members, buf, false,
			     !HOST_LITTLE_ENDIAN);
	ck_assert_uint_eq(foo.big, 3000000000);
	ck_assert_uint_eq(foo.medium, 10000);
	ck_assert_uint_eq(foo.small, 100);
	ck_assert_uint_eq(foo.tiny, 13);
	ck_assert_mem_eq(foo.array, "ABC", 3);
}

}
END_TEST

START_TEST(deserialize_struct64_32be)
{
#line 94
{
	uint8_t buf[12] = {
		0xb2, 0xd0, 0x5e, 0x00,
		0x27, 0x10,
		0x64,
		0x0d,
		0x41, 0x42, 0x43,
	};
	struct foo64 foo;
	deserialize_struct64(&foo, struct foo32, visit_foo_members, buf, false,
			     HOST_LITTLE_ENDIAN);
	ck_assert_uint_eq(foo.big, 3000000000);
	ck_assert_uint_eq(foo.medium, 10000);
	ck_assert_uint_eq(foo.small, 100);
	ck_assert_uint_eq(foo.tiny, 13);
	ck_assert_mem_eq(foo.array, "ABC", 3);
}

}
END_TEST

START_TEST(deserialize_struct64_inplace_64le)
{
#line 115
{
	uint8_t buf[24] = {
		0x00, 0xf2, 0x05, 0x2a, 0x01, 0x00, 0x00, 0x00,
		0xa0, 0x86, 0x01, 0x00,
		0x20, 0x03,
		0x0a,
		0x41, 0x42, 0x43,
	};
	struct foo64 foo;
	memcpy(&foo, buf, sizeof(buf));
	deserialize_struct64_inplace(&foo, struct foo32, visit_foo_members,
				     true, !HOST_LITTLE_ENDIAN);
	ck_assert_uint_eq(foo.big, 5000000000);
	ck_assert_uint_eq(foo.medium, 100000);
	ck_assert_uint_eq(foo.small, 800);
	ck_assert_uint_eq(foo.tiny, 10);
	ck_assert_mem_eq(foo.array, "ABC", 3);
}

}
END_TEST

START_TEST(deserialize_struct64_inplace_64be)
{
#line 135
{
	uint8_t buf[24] = {
		0x00, 0x00, 0x00, 0x01, 0x2a, 0x05, 0xf2, 0x00,
		0x00, 0x01, 0x86, 0xa0,
		0x03, 0x20,
		0x0a,
		0x41, 0x42, 0x43,
	};
	struct foo64 foo;
	memcpy(&foo, buf, sizeof(buf));
	deserialize_struct64_inplace(&foo, struct foo32, visit_foo_members,
				     true, HOST_LITTLE_ENDIAN);
	ck_assert_uint_eq(foo.big, 5000000000);
	ck_assert_uint_eq(foo.medium, 100000);
	ck_assert_uint_eq(foo.small, 800);
	ck_assert_uint_eq(foo.tiny, 10);
	ck_assert_mem_eq(foo.array, "ABC", 3);
}

}
END_TEST

START_TEST(deserialize_struct64_inplace_32le)
{
#line 155
{
	uint8_t buf[12] = {
		0x00, 0x5e, 0xd0, 0xb2,
		0x10, 0x27,
		0x64,
		0x0d,
		0x41, 0x42, 0x43,
	};
	struct foo64 foo;
	memcpy(&foo, buf, sizeof(buf));
	deserialize_struct64_inplace(&foo, struct foo32, visit_foo_members,
				     false, !HOST_LITTLE_ENDIAN);
	ck_assert_uint_eq(foo.big, 3000000000);
	ck_assert_uint_eq(foo.medium, 10000);
	ck_assert_uint_eq(foo.small, 100);
	ck_assert_uint_eq(foo.tiny, 13);
	ck_assert_mem_eq(foo.array, "ABC", 3);
}

}
END_TEST

START_TEST(deserialize_struct64_inplace_32be)
{
#line 175
{
	uint8_t buf[12] = {
		0xb2, 0xd0, 0x5e, 0x00,
		0x27, 0x10,
		0x64,
		0x0d,
		0x41, 0x42, 0x43,
	};
	struct foo64 foo;
	memcpy(&foo, buf, sizeof(buf));
	deserialize_struct64_inplace(&foo, struct foo32, visit_foo_members,
				     false, HOST_LITTLE_ENDIAN);
	ck_assert_uint_eq(foo.big, 3000000000);
	ck_assert_uint_eq(foo.medium, 10000);
	ck_assert_uint_eq(foo.small, 100);
	ck_assert_uint_eq(foo.tiny, 13);
	ck_assert_mem_eq(foo.array, "ABC", 3);
}
}
END_TEST

int main(void)
{
    Suite *s1 = suite_create("serialize");
    TCase *tc1_1 = tcase_create("deserialize_struct64");
    TCase *tc1_2 = tcase_create("deserialize_struct64_inplace");
    SRunner *sr = srunner_create(s1);
    int nf;

    suite_add_tcase(s1, tc1_1);
    tcase_add_test(tc1_1, deserialize_struct64_64le);
    tcase_add_test(tc1_1, deserialize_struct64_64be);
    tcase_add_test(tc1_1, deserialize_struct64_32le);
    tcase_add_test(tc1_1, deserialize_struct64_32be);
    suite_add_tcase(s1, tc1_2);
    tcase_add_test(tc1_2, deserialize_struct64_inplace_64le);
    tcase_add_test(tc1_2, deserialize_struct64_inplace_64be);
    tcase_add_test(tc1_2, deserialize_struct64_inplace_32le);
    tcase_add_test(tc1_2, deserialize_struct64_inplace_32be);

    srunner_run_all(sr, CK_ENV);
    nf = srunner_ntests_failed(sr);
    srunner_free(sr);

    return nf == 0 ? 0 : 1;
}
