#line 1 "../../libdrgn/linux_kernel_object_find.inc.strswitch"
// Copyright (c) Meta Platforms, Inc. and affiliates.
// SPDX-License-Identifier: LGPL-2.1-or-later

static struct drgn_error *
linux_kernel_object_find(const char *name, size_t name_len,
			 const char *filename,
			 enum drgn_find_object_flags flags, void *arg,
			 struct drgn_object *ret)
{
	struct drgn_program *prog = arg;
	if (!filename) {
#line 14 "linux_kernel_object_find.inc"
		/* Generated by libdrgn/build-aux/gen_strswitch.py. */
		switch (1) {
		default: {
			#define memswitch0_args(ptr, len) \
				const void *memswitch0_ptr = (ptr); \
				const char *memswitch0_str = memswitch0_ptr; \
				size_t memswitch0_len = (len);
			memswitch0_args(
#line 12 "../../libdrgn/linux_kernel_object_find.inc.strswitch"
		            name, name_len
#line 25 "linux_kernel_object_find.inc"
			)
			#undef memswitch0_args
			if (memswitch0_len == 7) {
				if (memswitch0_str[0] == 'j') {
					if (memcmp(&memswitch0_str[1], "iffies", sizeof("iffies") - 1) == 0) {
						memswitch0_case5:
#line 34 "../../libdrgn/linux_kernel_object_find.inc.strswitch"
			if (flags & DRGN_FIND_OBJECT_VARIABLE)
				return linux_kernel_get_jiffies(prog, ret);
			break;
#line 36 "linux_kernel_object_find.inc"
						goto memswitch0_case6;
					}
				} else if (memswitch0_str[0] == 'v') {
					if (memcmp(&memswitch0_str[1], "memmap", sizeof("memmap") - 1) == 0) {
						memswitch0_case6:
#line 38 "../../libdrgn/linux_kernel_object_find.inc.strswitch"
			if (flags & DRGN_FIND_OBJECT_CONSTANT)
				return linux_kernel_get_vmemmap(prog, ret);
			break;
#line 46 "linux_kernel_object_find.inc"
					}
				}
			} else if (memswitch0_len == 9) {
				if (memcmp(&memswitch0_str[0], "PAGE_", sizeof("PAGE_") - 1) == 0) {
					if (memswitch0_str[5] == 'M') {
						if (memcmp(&memswitch0_str[6], "ASK", sizeof("ASK") - 1) == 0) {
							memswitch0_case2:
#line 22 "../../libdrgn/linux_kernel_object_find.inc.strswitch"
			if (flags & DRGN_FIND_OBJECT_CONSTANT)
				return linux_kernel_get_page_mask(prog, ret);
			break;
#line 58 "linux_kernel_object_find.inc"
							goto memswitch0_case3;
						}
					} else if (memswitch0_str[5] == 'S') {
						if (memcmp(&memswitch0_str[6], "IZE", sizeof("IZE") - 1) == 0) {
							memswitch0_case1:
#line 18 "../../libdrgn/linux_kernel_object_find.inc.strswitch"
			if (flags & DRGN_FIND_OBJECT_CONSTANT)
				return linux_kernel_get_page_size(prog, ret);
			break;
#line 68 "linux_kernel_object_find.inc"
							goto memswitch0_case2;
						}
					}
				}
			} else if (memswitch0_len == 10) {
				if (memswitch0_str[0] == 'P') {
					if (memcmp(&memswitch0_str[1], "AGE_SHIFT", sizeof("AGE_SHIFT") - 1) == 0) {
#line 14 "../../libdrgn/linux_kernel_object_find.inc.strswitch"
			if (flags & DRGN_FIND_OBJECT_CONSTANT)
				return linux_kernel_get_page_shift(prog, ret);
			break;
#line 80 "linux_kernel_object_find.inc"
						goto memswitch0_case1;
					}
				} else if (memswitch0_str[0] == 'V') {
					if (memcmp(&memswitch0_str[1], "MCOREINFO", sizeof("MCOREINFO") - 1) == 0) {
						memswitch0_case4:
#line 30 "../../libdrgn/linux_kernel_object_find.inc.strswitch"
			if (flags & DRGN_FIND_OBJECT_CONSTANT)
				return linux_kernel_get_vmcoreinfo(prog, ret);
			break;
#line 90 "linux_kernel_object_find.inc"
						goto memswitch0_case5;
					}
				}
			} else if (memswitch0_len == 11) {
				if (memcmp(&memswitch0_str[0], "UTS_RELEASE", sizeof("UTS_RELEASE") - 1) == 0) {
					memswitch0_case3:
#line 26 "../../libdrgn/linux_kernel_object_find.inc.strswitch"
			if (flags & DRGN_FIND_OBJECT_CONSTANT)
				return linux_kernel_get_uts_release(prog, ret);
			break;
#line 101 "linux_kernel_object_find.inc"
					goto memswitch0_case4;
				}
			}
		}
		}
#line 42 "../../libdrgn/linux_kernel_object_find.inc.strswitch"
	}
	return &drgn_not_found;
}
