// Copyright 2018 Keybase Inc. All rights reserved.
// Use of this source code is governed by a BSD
// license that can be found in the LICENSE file.

package attachments

var mimeTypes = map[string]string{
	".3gp":     "video/3gpp",
	".3gpp":    "video/3gpp",
	".7z":      "application/x-7z-compressed",
	".aac":     "audio/aac",
	".ai":      "application/postscript",
	".asf":     "video/x-ms-asf",
	".asx":     "video/x-ms-asf",
	".atom":    "application/atom+xml",
	".avi":     "video/x-msvideo",
	".bin":     "application/octet-stream",
	".bmp":     "image/x-ms-bmp",
	".cco":     "application/x-cocoa",
	".crt":     "application/x-x509-ca-cert",
	".css":     "text/css",
	".deb":     "application/octet-stream",
	".der":     "application/x-x509-ca-cert",
	".dll":     "application/octet-stream",
	".dmg":     "application/octet-stream",
	".doc":     "application/msword",
	".docx":    "application/vnd.openxmlformats-officedocument.wordprocessingml.document",
	".ear":     "application/java-archive",
	".eot":     "application/vnd.ms-fontobject",
	".eps":     "application/postscript",
	".exe":     "application/octet-stream",
	".flv":     "video/x-flv",
	".gif":     "image/gif",
	".hqx":     "application/mac-binhex40",
	".htc":     "text/x-component",
	".htm":     "text/html",
	".html":    "text/html",
	".ico":     "image/x-icon",
	".img":     "application/octet-stream",
	".iso":     "application/octet-stream",
	".jad":     "text/vnd.sun.j2me.app-descriptor",
	".jar":     "application/java-archive",
	".jardiff": "application/x-java-archive-diff",
	".jng":     "image/x-jng",
	".jnlp":    "application/x-java-jnlp-file",
	".jpeg":    "image/jpeg",
	".jpg":     "image/jpeg",
	".js":      "application/javascript",
	".json":    "application/json",
	".kar":     "audio/midi",
	".kml":     "application/vnd.google-earth.kml+xml",
	".kmz":     "application/vnd.google-earth.kmz",
	".m3u8":    "application/vnd.apple.mpegurl",
	".m4a":     "audio/x-m4a",
	".m4v":     "video/x-m4v",
	".mid":     "audio/midi",
	".midi":    "audio/midi",
	".mml":     "text/mathml",
	".mng":     "video/x-mng",
	".mov":     "video/quicktime",
	".mp3":     "audio/mpeg",
	".mp4":     "video/mp4",
	".mpeg":    "video/mpeg",
	".mpg":     "video/mpeg",
	".msi":     "application/octet-stream",
	".msm":     "application/octet-stream",
	".msp":     "application/octet-stream",
	".odg":     "application/vnd.oasis.opendocument.graphics",
	".odp":     "application/vnd.oasis.opendocument.presentation",
	".ods":     "application/vnd.oasis.opendocument.spreadsheet",
	".odt":     "application/vnd.oasis.opendocument.text",
	".ogg":     "audio/ogg",
	".pdb":     "application/x-pilot",
	".pdf":     "application/pdf",
	".pem":     "application/x-x509-ca-cert",
	".pl":      "application/x-perl",
	".pm":      "application/x-perl",
	".png":     "image/png",
	".ppt":     "application/vnd.ms-powerpoint",
	".pptx":    "application/vnd.openxmlformats-officedocument.presentationml.presentation",
	".prc":     "application/x-pilot",
	".ps":      "application/postscript",
	".qt":      "video/quicktime",
	".ra":      "audio/x-realaudio",
	".rar":     "application/x-rar-compressed",
	".rpm":     "application/x-redhat-package-manager",
	".rss":     "application/rss+xml",
	".rtf":     "application/rtf",
	".run":     "application/x-makeself",
	".sea":     "application/x-sea",
	".shtml":   "text/html",
	".sit":     "application/x-stuffit",
	".svg":     "image/svg+xml",
	".svgz":    "image/svg+xml",
	".swf":     "application/x-shockwave-flash",
	".tcl":     "application/x-tcl",
	".tif":     "image/tiff",
	".tiff":    "image/tiff",
	".tk":      "application/x-tcl",
	".ts":      "video/mp2t",
	".txt":     "text/plain",
	".war":     "application/java-archive",
	".wbmp":    "image/vnd.wap.wbmp",
	".webm":    "video/webm",
	".webp":    "image/webp",
	".wml":     "text/vnd.wap.wml",
	".wmlc":    "application/vnd.wap.wmlc",
	".wmv":     "video/x-ms-wmv",
	".woff":    "application/font-woff",
	".xhtml":   "application/xhtml+xml",
	".xls":     "application/vnd.ms-excel",
	".xlsx":    "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet",
	".xml":     "text/xml",
	".xpi":     "application/x-xpinstall",
	".xspf":    "application/xspf+xml",
	".zip":     "application/zip",
}
