/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.hoxt.packet;

import javax.xml.namespace.QName;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.util.Objects;
import org.jivesoftware.smack.util.XmlStringBuilder;

public class Base64BinaryChunk
implements ExtensionElement {
    public static final String ELEMENT_CHUNK = "chunk";
    public static final String ATTRIBUTE_STREAM_ID = "streamId";
    public static final String ATTRIBUTE_LAST = "last";
    public static final String ATTRIBUTE_NR = "nr";
    public static final QName QNAME = new QName("urn:xmpp:http", "chunk");
    private final String streamId;
    private final boolean last;
    private final String text;
    private final int nr;

    public Base64BinaryChunk(String text, String streamId, int nr, boolean last) {
        this.text = Objects.requireNonNull(text, "text must not be null");
        this.streamId = Objects.requireNonNull(streamId, "streamId must not be null");
        if (nr < 0) {
            throw new IllegalArgumentException("nr must be a non negative integer");
        }
        this.nr = nr;
        this.last = last;
    }

    public Base64BinaryChunk(String text, String streamId, int nr) {
        this(text, streamId, nr, false);
    }

    public String getStreamId() {
        return this.streamId;
    }

    public boolean isLast() {
        return this.last;
    }

    public String getText() {
        return this.text;
    }

    public int getNr() {
        return this.nr;
    }

    @Override
    public String getElementName() {
        return QNAME.getLocalPart();
    }

    @Override
    public String getNamespace() {
        return QNAME.getNamespaceURI();
    }

    @Override
    public XmlStringBuilder toXML(XmlEnvironment enclosingNamespace) {
        XmlStringBuilder xml = new XmlStringBuilder(this);
        xml.attribute(ATTRIBUTE_STREAM_ID, this.streamId);
        xml.attribute(ATTRIBUTE_NR, this.nr);
        xml.optBooleanAttribute(ATTRIBUTE_LAST, this.last);
        xml.rightAngleBracket();
        xml.append(this.text);
        xml.closeElement(this);
        return xml;
    }
}

