/*
  Copyright (C) 2004-2005 Tommi Tervonen, Petteri Klemola, Pasi Orovuo

  This file is part of Kajaani Kombat.

  Kajaani Kombat is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  Kajaani Kombat is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with Kajaani Kombat; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef __ANIMATION_H__
#define __ANIMATION_H__

#include "SDL.h"
#include "particle_efects.h"
#include "game_obj.h"
#include "globals.h"
#include "gfx_functions.h"
#include "rotozoom.h"

#define SANIM_SIZE 20
#define MANIM_SIZE 50
#define BANIM_SIZE 100

#define SANIM_LEN 500 // anim len 0.5s
#define MANIM_LEN 500 
#define BANIM_LEN 500 

class animation
{
 public:
  animation(int num_frames, SDL_Surface *first_frame);
  void set_frame (int findex, SDL_Surface *fram);
  const SDL_Surface *get_frame (int findex);

  ~animation();

 protected:
  vector<SDL_Surface *> frames;

};

class exp_anim_container
{
 public:
  enum type {
    EXP_SMALL = 0,
    EXP_MED,
    EXP_BIG
  };

  exp_anim_container(int frames = 30);
  ~exp_anim_container();

  const SDL_Surface *get_frame (type t, int ind) const;
  int get_frames() const
    { return frames; }
 protected:
  int frames;
  
  animation *sanim;
  animation *manim;
  animation *banim;

};

class ammo_anim_container
{
 public:
  ammo_anim_container(SDL_Surface **ammogfxs, int frames = 50);
  ~ammo_anim_container();

  const SDL_Surface *get_frame (int pindex, int alt) const;
  int get_frames() const
    { return frames; }
 protected:
  int frames;
  
  animation *anims[MAX_PLAYERS];
};

class anim_explosion_obj : public game_obj
{
 public:

  anim_explosion_obj (const coord &position, exp_anim_container::type t);
  virtual bool is_finished() const;
  exp_anim_container::type get_type() const
    { return t; }

 protected:
  exp_anim_container::type t;

};

#endif
