#ifndef __STREAMDVD_H__
#define __STREAMDVD_H__     1
#endif

#include <dvdread/dvd_reader.h>

#define BLOCK_DATA_OFFSET   23                     

#define BLOCKS2READ         16384


#define VIDEO_PREFIX        0xe0                   
#define MAX_STREAMS         64                     
#define MAX_VIDEO           2
#define MAX_AUDIO           10
#define MAX_SUBPICTURE      32




struct streamblock {                               
   unsigned char id;                                  
   int num;                                           
   int offset;                                        
   int size;                                          
   unsigned char content[DVD_VIDEO_LB_LEN];           
   struct streamblock *previous;                      
   struct streamblock *next;                          
};


struct global_job_values {                         
   int stream_count;                                  
   int *stream_list;                                  
   struct streamblock **streams;                      
   unsigned char video_id;                            
   int av_delay;                                      
   long start_block;                                  
   long end_block;                                    
   long last_block;                                   
   dvd_reader_t *dvd;                                 
   dvd_file_t *vob;                                   
   int need_requant;                                  
   float requant_factor;                              
   int debug_level;                                   
};

