# Part of the StreamDVD project
package StreamDVD::Calc;

use strict;
use vars qw($VERSION @ISA @EXPORT);

require Exporter;

@ISA = qw(Exporter);
@EXPORT = qw(

);


$VERSION = '0.1';

sub new {                                                  # create new calculator object
   my $class = shift;
   my $self = bless {}, $class;
   my ($GUI) = @_;
   $self->_show($GUI);
   return $self;
}


sub _show {                                                # show calculator gui
   my $self = shift;
   my ($GUI) = @_;

   my $time_hour = 0;
   my $time_min = 0;
   my $time_sec = 0;
   my $time_msec = 0;
   my $time_frame = 0;
   my @frame_rates = ("NTSC 24 fps", "PAL 25 fps", "NTSC 30 fps");
   my $frame_rate = "PAL 25 fps";
   my @audio_rates = ("32 Kbit/s","48 Kbit/s","56 Kbit/s","64 Kbit/s","80 Kbit/s","96 Kbit/s","112 Kbit/s","128 Kbit/s","160 Kbit/s","192 Kbit/s","224 Kbit/s","256 Kbit/s","320 Kbit/s","252 Kbit/s","384 Kbit/s","416 Kbit/s","448 Kbit/s");
   my $audio_rate = "192 Kbit/s";
   my $video_rate = 0;
   my @disk_sizes = ("650 MB (74 Min. Data)","700 (80 Min. Data)","736 (74 Min. [S]VCD)","792 (80 Min. [S]VCD)","2048 (2 GB DVD/HDD)","4096 (4 GB DVD/HDD)","4480 (DVD-R/RW)");
   my $disk_size = "4480 (DVD-R/RW)";
   my $disk_count = 1;
   my $whattodo = 1;

   my $out_round_hour = 0;
   my $out_round_min = 0;
   my $out_round_sec = 0;
   my $out_round_frm = 0;
   my $out_full_ms = 0;
   my $out_full_frm = 0;
   my $out_video_rate = 0;
   my $out_audio_rate = 0;
   my $out_complete_rate = 0;
   my $out_disk_count = 0;

   my $Wcalc = $GUI->Toplevel(-title=>"Calculator");

   my $FRMinput = $Wcalc->Frame(-borderwidth=>2)->pack(-side=>"left", -fill=>"x");

   my $FRMtime = $FRMinput->LabFrame(-label=>"Run Time", -labelside=>"acrosstop", -borderwidth=>2)->pack(-side=>"top", -expand=>1, -fill=>"x");
   my $FRMtime1 = $FRMtime->Frame(-borderwidth=>2)->pack(-side=>"left", -fill=>"x");
   $FRMtime1->Label(-text=>"Hours")->pack(-side=>"top");
   $FRMtime1->Entry(-textvariable => \$time_hour, -width=>2)->pack(-side=>"top");
   my $FRMtime2 = $FRMtime->Frame(-borderwidth=>2)->pack(-side=>"left", -fill=>"x");
   $FRMtime2->Label(-text=>"Min.")->pack(-side=>"top");
   $FRMtime2->Entry(-textvariable => \$time_min, -width=>3)->pack(-side=>"top");
   my $FRMtime3 = $FRMtime->Frame(-borderwidth=>2)->pack(-side=>"left", -fill=>"x");
   $FRMtime3->Label(-text=>"Sec.")->pack(-side=>"top");
   $FRMtime3->Entry(-textvariable => \$time_sec, -width=>5)->pack(-side=>"top");
   my $FRMtime4 = $FRMtime->Frame(-borderwidth=>2)->pack(-side=>"left", -fill=>"x");
   $FRMtime4->Label(-text=>"mSec.")->pack(-side=>"top");
   $FRMtime4->Entry(-textvariable => \$time_msec, -width=>5)->pack(-side=>"top");
   $FRMtime4->Label(-text=>"Frames")->pack(-side=>"top");
   $FRMtime4->Entry(-textvariable => \$time_frame, -width=>5)->pack(-side=>"top");

   my $FRMrates = $FRMinput->LabFrame(-label=>"Framerate / Bitrate", -labelside=>"acrosstop", -borderwidth=>2)->pack(-side=>"top", -expand=>1, -fill=>"x");
   my $FRMrates1 = $FRMrates->Frame(-borderwidth=>2)->pack(-side=>"top", -fill=>"x");
   $FRMrates1->BrowseEntry(-label=>"Type", -variable => \$frame_rate, -choices=>\@frame_rates)->pack(-side=>"top", -fill=>"x");
   my $FRMrates2 = $FRMrates->Frame(-borderwidth=>2)->pack(-side=>"top", -fill=>"x");
   $FRMrates2->Label(-text=>"Video")->pack(-side=>"left");
   $FRMrates2->Entry(-textvariable => \$video_rate, -width=>5)->pack(-side=>"left", -fill=>"x");
   $FRMrates2->Label(-text=>"Kbit/s")->pack(-side=>"left");
   my $FRMrates3 = $FRMrates->Frame(-borderwidth=>2)->pack(-side=>"top", -fill=>"x");
   $FRMrates3->BrowseEntry(-label=>"Audio", -variable => \$audio_rate, -choices=>\@audio_rates)->pack(-side=>"top", -fill=>"x");

   my $FRMsize = $FRMinput->LabFrame(-label=>"File/Disk Size", -labelside=>"acrosstop", -borderwidth=>2)->pack(-side=>"top", -expand=>1, -fill=>"x");
   $FRMsize->Label(-text=>"Disk Count")->pack(-side=>"left");
   $FRMsize->Entry(-textvariable => \$disk_count, -width=>2)->pack(-side=>"left", -fill=>"x");
   $FRMsize->BrowseEntry(-label=>"Disk Size", -variable => \$disk_size, -choices=>\@disk_sizes)->pack(-side=>"top", -fill=>"x");

   my $FRMbutton = $FRMinput->LabFrame(-label=>"Calculate", -labelside=>"acrosstop", -borderwidth=>2)->pack(-side=>"top", -expand=>1, -fill=>"x");
   my $FRMbutton1 = $FRMbutton->Frame(-borderwidth=>2)->pack(-side=>"left", -fill=>"x");
   $FRMbutton1->Radiobutton(-text=>"Video Bitrate", -variable=>\$whattodo, -value=>1)->pack(-side=>"top", -fill=>"x");
   $FRMbutton1->Radiobutton(-text=>"Disk Usage", -variable=>\$whattodo, -value=>0)->pack(-side=>"top", -fill=>"x");
   my $FRMbutton2 = $FRMbutton->Frame(-borderwidth=>2)->pack(-side=>"left", -fill=>"x");
   $FRMbutton2->Button(-text=>"Calculate",-command=>
      sub { my $allframes = 0;
            my ($framerate) = $frame_rate =~ /(\d+)/;                   # extract framerate value from string
            my ($arate) = $audio_rate =~ /(\d+)/;                       # extract audio bitrate value from string
            my $vrate = $video_rate;
            my ($disksize) = $disk_size =~ /^(\d+)/;                    # extract disksize value from string
            my $framesperhour = $framerate * 3600;
            my $framespermin = $framerate * 60;
            my $kbitpermb = 8192;
            my $temp;
            my $temp2;

            $allframes += $time_hour * $framerate * 3600;               # calc overall frame count
            $allframes += $time_min * $framerate * 60;
            $allframes += $time_sec * $framerate;
            if( $time_msec > 0 ) {
               $allframes += $framerate / (1000 / $time_msec); }
            else {
               $allframes += $time_frame; }

            $out_round_hour = int($allframes / $framesperhour);         # overall values
            $out_round_min = int($allframes / $framespermin);
            $out_round_sec = int($allframes / $framerate);
            $out_round_frm = $allframes;

            $temp = $allframes;                                         # run rime in hh:mm:ss:ms / hh:mm:ss:frm
            $out_full_ms = int($temp / $framesperhour);
            $temp = $temp % $framesperhour;
            $out_full_ms .= "." . int($temp / $framespermin);
            $temp = $temp % $framespermin;
            $out_full_ms .= "." . int($temp / $framerate);
            $temp = $temp % $framerate;
            $out_full_frm = $out_full_ms . "." . $temp;
            $out_full_ms .= "." . int($temp * (1/$framerate) * 1000);

            if( $whattodo ) {                                           # calc target bitrate
               my $diskspace = ($disk_count * $disksize) * $kbitpermb;
               $out_complete_rate = int( $diskspace / int($allframes / $framerate));
               $out_audio_rate = $arate;
               $out_video_rate = $out_complete_rate - $arate;
               $out_disk_count = $disk_count;
            }
            else {                                                      # calc disk usage / disk count
               my $i = 1;
               my $diskspace = $disksize * $kbitpermb;
               $out_audio_rate = $arate;
               $out_video_rate = $vrate;
               $out_complete_rate = $vrate + $arate;
               while( ($diskspace * $i) < ($out_complete_rate * int($allframes / $framerate)) ) {
                  $i++; }
               $out_disk_count = $i;
            }

          } )->pack(-side=>"top");



   my $FRMoutput = $Wcalc->LabFrame(-label=>"Output", -labelside=>"acrosstop", -borderwidth=>2)->pack(-side=>"left", -fill=>"x");

   my $FRMoutput1 = $FRMoutput->Frame(-borderwidth=>2)->pack(-side=>"top", -fill=>"x");
   $FRMoutput1->Label(-width=>15, -text=>"Hours: ")->pack(-side=>"left");
   $FRMoutput1->Label(-width=>15, -textvariable=>\$out_round_hour)->pack(-side=>"left");

   my $FRMoutput2 = $FRMoutput->Frame(-borderwidth=>2)->pack(-side=>"top", -fill=>"x");
   $FRMoutput2->Label(-width=>15, -text=>"Min.: ")->pack(-side=>"left");
   $FRMoutput2->Label(-width=>15, -textvariable=>\$out_round_min)->pack(-side=>"left");

   my $FRMoutput3 = $FRMoutput->Frame(-borderwidth=>2)->pack(-side=>"top", -fill=>"x");
   $FRMoutput3->Label(-width=>15, -text=>"Sec.: ")->pack(-side=>"left");
   $FRMoutput3->Label(-width=>15, -textvariable=>\$out_round_sec)->pack(-side=>"left");

   my $FRMoutput4 = $FRMoutput->Frame(-borderwidth=>2)->pack(-side=>"top", -fill=>"x");
   $FRMoutput4->Label(-width=>15, -text=>"Frames: ")->pack(-side=>"left");
   $FRMoutput4->Label(-width=>15, -textvariable=>\$out_round_frm)->pack(-side=>"left");

   my $FRMoutput5 = $FRMoutput->Frame(-borderwidth=>2)->pack(-side=>"top", -fill=>"x");
   $FRMoutput5->Label(-width=>15, -text=>"hh.mm.ss.ms:")->pack(-side=>"left");
   $FRMoutput5->Label(-width=>15, -textvariable=>\$out_full_ms)->pack(-side=>"left");

   my $FRMoutput6 = $FRMoutput->Frame(-borderwidth=>2)->pack(-side=>"top", -fill=>"x");
   $FRMoutput6->Label(-width=>15, -text=>"hh.mm.ss.frm:")->pack(-side=>"left");
   $FRMoutput6->Label(-width=>15, -textvariable=>\$out_full_frm)->pack(-side=>"left");

   my $FRMoutput7 = $FRMoutput->Frame(-borderwidth=>2)->pack(-side=>"top", -fill=>"x");
   $FRMoutput7->Label(-width=>15, -text=>"Video Bitrate: ")->pack(-side=>"left");
   $FRMoutput7->Label(-width=>15, -textvariable=>\$out_video_rate)->pack(-side=>"left");

   my $FRMoutput8 = $FRMoutput->Frame(-borderwidth=>2)->pack(-side=>"top", -fill=>"x");
   $FRMoutput8->Label(-width=>15, -text=>"Audio Bitrate: ")->pack(-side=>"left");
   $FRMoutput8->Label(-width=>15, -textvariable=>\$out_audio_rate)->pack(-side=>"left");

   my $FRMoutput9 = $FRMoutput->Frame(-borderwidth=>2)->pack(-side=>"top", -fill=>"x");
   $FRMoutput9->Label(-width=>15, -text=>"Complete Bitrate: ")->pack(-side=>"left");
   $FRMoutput9->Label(-width=>15, -textvariable=>\$out_complete_rate)->pack(-side=>"left");

   my $FRMoutput10 = $FRMoutput->Frame(-borderwidth=>2)->pack(-side=>"top", -fill=>"x");
   $FRMoutput10->Label(-width=>15, -text=>"Disk Count: ")->pack(-side=>"left");
   $FRMoutput10->Label(-width=>15, -textvariable=>\$out_disk_count)->pack(-side=>"left");

}

1;

