// Copyright (c) HashiCorp, Inc.
// SPDX-License-Identifier: MPL-2.0

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             (unknown)
// source: internal/plugin/grpc_broker.proto

package plugin

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	GRPCBroker_StartStream_FullMethodName = "/plugin.GRPCBroker/StartStream"
)

// GRPCBrokerClient is the client API for GRPCBroker service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type GRPCBrokerClient interface {
	StartStream(ctx context.Context, opts ...grpc.CallOption) (GRPCBroker_StartStreamClient, error)
}

type gRPCBrokerClient struct {
	cc grpc.ClientConnInterface
}

func NewGRPCBrokerClient(cc grpc.ClientConnInterface) GRPCBrokerClient {
	return &gRPCBrokerClient{cc}
}

func (c *gRPCBrokerClient) StartStream(ctx context.Context, opts ...grpc.CallOption) (GRPCBroker_StartStreamClient, error) {
	stream, err := c.cc.NewStream(ctx, &GRPCBroker_ServiceDesc.Streams[0], GRPCBroker_StartStream_FullMethodName, opts...)
	if err != nil {
		return nil, err
	}
	x := &gRPCBrokerStartStreamClient{stream}
	return x, nil
}

type GRPCBroker_StartStreamClient interface {
	Send(*ConnInfo) error
	Recv() (*ConnInfo, error)
	grpc.ClientStream
}

type gRPCBrokerStartStreamClient struct {
	grpc.ClientStream
}

func (x *gRPCBrokerStartStreamClient) Send(m *ConnInfo) error {
	return x.ClientStream.SendMsg(m)
}

func (x *gRPCBrokerStartStreamClient) Recv() (*ConnInfo, error) {
	m := new(ConnInfo)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// GRPCBrokerServer is the server API for GRPCBroker service.
// All implementations should embed UnimplementedGRPCBrokerServer
// for forward compatibility
type GRPCBrokerServer interface {
	StartStream(GRPCBroker_StartStreamServer) error
}

// UnimplementedGRPCBrokerServer should be embedded to have forward compatible implementations.
type UnimplementedGRPCBrokerServer struct {
}

func (UnimplementedGRPCBrokerServer) StartStream(GRPCBroker_StartStreamServer) error {
	return status.Errorf(codes.Unimplemented, "method StartStream not implemented")
}

// UnsafeGRPCBrokerServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to GRPCBrokerServer will
// result in compilation errors.
type UnsafeGRPCBrokerServer interface {
	mustEmbedUnimplementedGRPCBrokerServer()
}

func RegisterGRPCBrokerServer(s grpc.ServiceRegistrar, srv GRPCBrokerServer) {
	s.RegisterService(&GRPCBroker_ServiceDesc, srv)
}

func _GRPCBroker_StartStream_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(GRPCBrokerServer).StartStream(&gRPCBrokerStartStreamServer{stream})
}

type GRPCBroker_StartStreamServer interface {
	Send(*ConnInfo) error
	Recv() (*ConnInfo, error)
	grpc.ServerStream
}

type gRPCBrokerStartStreamServer struct {
	grpc.ServerStream
}

func (x *gRPCBrokerStartStreamServer) Send(m *ConnInfo) error {
	return x.ServerStream.SendMsg(m)
}

func (x *gRPCBrokerStartStreamServer) Recv() (*ConnInfo, error) {
	m := new(ConnInfo)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// GRPCBroker_ServiceDesc is the grpc.ServiceDesc for GRPCBroker service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var GRPCBroker_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "plugin.GRPCBroker",
	HandlerType: (*GRPCBrokerServer)(nil),
	Methods:     []grpc.MethodDesc{},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "StartStream",
			Handler:       _GRPCBroker_StartStream_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
	},
	Metadata: "internal/plugin/grpc_broker.proto",
}
