# -*- encoding: utf-8 -*-

# Hyphenation patterns for Text::Hyphen in Ruby: Czech
#   Lala 8.11.1991
#
# The original copyright holds and is reproduced in the source to this file.
# The Ruby version of these patterns are copyright 2004 Austin Ziegler.
#--
# Czech hyphenation patterns - Lala 8.11.1991
#++
require "text/hyphen/language"

Text::Hyphen::Language::CS = Text::Hyphen::Language.new do |lang|
  lang.encoding "UTF-8"
  lang.patterns <<-PATTERNS
a1ğa a1ça a1Ÿa a1ÿa a1ca a1ja a1Ôa a1œa a1åa a1ha a1cha a1ka a1ra a1da a1ta
a1na a1ğe a1çe a1Ÿe a1ÿe a1ce a1je a1he a1che a1ke a1re a1de a1te a1ne a1ri
a1ği a1çi a1Ÿi a1ÿi a1ci a1ji a1di a1ti a1ni a1ğo a1ço a1Ÿo a1ÿo a1co a1jo
a1Ôo a1œo a1åo a1ho a1cho a1ko a1ro a1do a1to a1no a1ğu a1çu a1Ÿu a1ÿu a1cu
a1ju a1Ôu a1œu a1åu a1hu a1chu a1ku a1ru a1du a1tu a1nu a1hy a1chy a1ky a1ry
a1dy a1ty a1ny a1ğă a1çă a1Ÿă a1ÿă a1că a1jă a1Ôă a1œă a1åă a1hă a1chă a1kă
a1ră a1dă a1tă a1nă a1ğĆ a1çĆ a1ŸĆ a1ÿĆ a1cĆ a1jĆ a1hĆ a1chĆ a1kĆ a1rĆ a1dĆ
a1tĆ a1nĆ a1ğą a1çą a1Ÿą a1ÿą a1cą a1ją a1dą a1tą a1ną a1kć a1rć a1dć a1tć
a1nć a1hì a1chì a1kì a1rì a1dì a1tì a1nì a1dØ a1tØ a1nØ e1ğa e1ça e1Ÿa e1ÿa
e1ca e1ja e1Ôa e1œa e1åa e1ha e1cha e1ka e1ra e1da e1ta e1na e1ğe e1çe e1Ÿe
e1ÿe e1ce e1je e1he e1che e1ke e1re e1de e1te e1ne e1ği e1çi e1Ÿi e1ÿi e1ci
e1ji e1di e1ti e1ni e1ğo e1ço e1Ÿo e1ÿo e1co e1jo e1Ôo e1œo e1åo e1ho e1cho
e1ko e1ro e1do e1to e1no e1ğu e1çu e1Ÿu e1ÿu e1cu e1ju e1Ôu e1œu e1åu e1hu
e1chu e1ku e1ru e1du e1tu e1nu e1hy e1chy e1ky e1ry e1dy e1ty e1ny e1ğă e1çă
e1Ÿă e1ÿă e1că e1jă e1hă e1chă e1kă e1ră e1dă e1tă e1nă e1ğĆ e1çĆ e1ŸĆ e1ÿĆ
e1cĆ e1jĆ e1hĆ e1chĆ e1kĆ e1rĆ e1dĆ e1tĆ e1nĆ e1ğą e1çą e1Ÿą e1ÿą e1cą e1ją
e1dą e1tą e1ną e1hì e1chì e1kì e1rì e1dì e1tì e1nì e1dØ e1tØ e1nØ i1ğa i1ça
i1Ÿa i1ÿa i1ca i1ja i1Ôa i1œa i1åa i1ha i1cha i1ka i1ra i1da i1ta i1na i1ğe
i1çe i1Ÿe i1ÿe i1ce i1je i1he i1che i1ke i1re i1de i1te i1ne i1ği i1çi i1Ÿi
i1ÿi i1ci i1ji i1di i1ti i1ni i1ğo i1ço i1Ÿo i1ÿo i1co i1jo i1Ôo i1œo i1åo
i1ho i1cho i1ko i1ro i1do i1to i1no i1ğu i1çu i1Ÿu i1ÿu i1cu i1ju i1Ôu i1œu
i1åu i1hu i1chu i1ku i1ru i1du i1tu i1nu i1hy i1chy i1ky i1ry i1dy i1ty i1ny
i1ğă i1çă i1Ÿă i1ÿă i1că i1jă i1Ôă i1œă i1åă i1hă i1chă i1kă i1ră i1dă i1tă
i1nă i1ğĆ i1çĆ i1ŸĆ i1ÿĆ i1cĆ i1jĆ i1hĆ i1chĆ i1kĆ i1rĆ i1dĆ i1tĆ i1nĆ i1ğą
i1çą i1Ÿą i1ÿą i1cą i1ją i1dą i1tą i1ną i1kć i1rć i1hì i1chì i1kì i1rì i1dì
i1tì i1nì i1dØ i1tØ i1nØ o1ğa o1ça o1Ÿa o1ÿa o1ca o1ja o1Ôa o1œa o1åa o1ha
o1cha o1ka o1ra o1da o1ta o1na o1ğe o1çe o1Ÿe o1ÿe o1ce o1je o1he o1che o1ke
o1re o1de o1te o1ne o1ği o1çi o1Ÿi o1ÿi o1ci o1ji o1di o1ti o1ni o1ğo o1ço
o1Ÿo o1ÿo o1co o1jo o1Ôo o1œo o1åo o1ho o1cho o1ko o1ro o1do o1to o1no o1ğu
o1çu o1Ÿu o1ÿu o1cu o1ju o1Ôu o1œu o1åu o1hu o1chu o1ku o1ru o1du o1tu o1nu
o1hy o1chy o1ky o1ry o1dy o1ty o1ny o1ğă o1çă o1Ÿă o1ÿă o1că o1jă o1hă o1chă
o1kă o1ră o1dă o1tă o1nă o1ğĆ o1çĆ o1ŸĆ o1ÿĆ o1cĆ o1jĆ o1hĆ o1chĆ o1kĆ o1rĆ
o1dĆ o1tĆ o1nĆ o1ğą o1çą o1Ÿą o1ÿą o1cą o1ją o1dą o1tą o1ną o1hì o1chì o1kì
o1rì o1dì o1tì o1nì o1dØ o1tØ o1nØ u1ğa u1ça u1Ÿa u1ÿa u1ca u1ja u1Ôa u1œa
u1åa u1ha u1cha u1ka u1ra u1da u1ta u1na u1ğe u1çe u1Ÿe u1ÿe u1ce u1je u1he
u1che u1ke u1re u1de u1te u1ne u1ği u1çi u1Ÿi u1ÿi u1ci u1ji u1di u1ti u1ni
u1ğo u1ço u1Ÿo u1ÿo u1co u1jo u1Ôo u1œo u1åo u1ho u1cho u1ko u1ro u1do u1to
u1no u1ğu u1çu u1Ÿu u1ÿu u1cu u1ju u1Ôu u1œu u1åu u1hu u1chu u1ku u1ru u1du
u1tu u1nu u1hy u1chy u1ky u1ry u1dy u1ty u1ny u1ğă u1çă u1Ÿă u1ÿă u1că u1jă
u1Ôă u1œă u1åă u1hă u1chă u1kă u1ră u1dă u1tă u1nă u1ğĆ u1çĆ u1ŸĆ u1ÿĆ u1cĆ
u1jĆ u1hĆ u1chĆ u1kĆ u1rĆ u1dĆ u1tĆ u1nĆ u1ğą u1çą u1Ÿą u1ÿą u1cą u1ją u1dą
u1tą u1ną u1hì u1chì u1kì u1rì u1dì u1tì u1nì u1dØ u1tØ u1nØ y1ğa y1ça y1Ÿa
y1ÿa y1ca y1ja y1ha y1cha y1ka y1ra y1da y1ta y1na y1ğe y1çe y1Ÿe y1ÿe y1ce
y1je y1he y1che y1ke y1re y1de y1te y1ne y1ği y1çi y1Ÿi y1ÿi y1ci y1ji y1di
y1ti y1ni y1ğo y1ço y1Ÿo y1ÿo y1co y1jo y1åo y1ho y1cho y1ko y1ro y1do y1to
y1no y1ğu y1çu y1Ÿu y1ÿu y1cu y1ju y1hu y1chu y1ku y1ru y1du y1tu y1nu y1hy
y1chy y1ky y1ry y1dy y1ty y1ny y1ğă y1çă y1Ÿă y1ÿă y1că y1jă y1hă y1chă y1kă
y1ră y1dă y1tă y1nă y1ğĆ y1çĆ y1ŸĆ y1ÿĆ y1cĆ y1jĆ y1hĆ y1chĆ y1kĆ y1rĆ y1dĆ
y1tĆ y1nĆ y1ğą y1çą y1Ÿą y1ÿą y1cą y1ją y1dą y1tą y1ną y1hì y1chì y1kì y1rì
y1dì y1tì y1nì y1dØ y1tØ y1nØ ă1ğa ă1ça ă1Ÿa ă1ÿa ă1ca ă1ja ă1Ôa ă1œa ă1åa
ă1ha ă1cha ă1ka ă1ra ă1da ă1ta ă1na ă1ğe ă1çe ă1Ÿe ă1ÿe ă1ce ă1je ă1he ă1che
ă1ke ă1re ă1de ă1te ă1ne ă1ği ă1çi ă1Ÿi ă1ÿi ă1ci ă1ji ă1di ă1ti ă1ni ă1ğo
ă1ço ă1Ÿo ă1ÿo ă1co ă1jo ă1Ôo ă1œo ă1åo ă1ho ă1cho ă1ko ă1ro ă1do ă1to ă1no
ă1ğu ă1çu ă1Ÿu ă1ÿu ă1cu ă1ju ă1Ôu ă1œu ă1åu ă1hu ă1chu ă1ku ă1ru ă1du ă1tu
ă1nu ă1hy ă1chy ă1ky ă1ry ă1dy ă1ty ă1ny ă1ğă ă1çă ă1Ÿă ă1ÿă ă1că ă1jă ă1hă
ă1chă ă1kă ă1ră ă1dă ă1tă ă1nă ă1ğĆ ă1çĆ ă1ŸĆ ă1ÿĆ ă1cĆ ă1jĆ ă1hĆ ă1chĆ ă1kĆ
ă1rĆ ă1dĆ ă1tĆ ă1nĆ ă1ğą ă1çą ă1Ÿą ă1ÿą ă1cą ă1ją ă1dą ă1tą ă1ną ă1hì ă1chì
ă1kì ă1rì ă1dì ă1tì ă1nì ă1dØ ă1tØ ă1nØ Ć1ğa Ć1ça Ć1Ÿa Ć1ÿa Ć1ca Ć1ja Ć1Ôa
Ć1œa Ć1åa Ć1ha Ć1cha Ć1ka Ć1ra Ć1da Ć1ta Ć1na Ć1ğe Ć1çe Ć1Ÿe Ć1ÿe Ć1ce Ć1je
Ć1he Ć1che Ć1ke Ć1re Ć1de Ć1te Ć1ne Ć1ği Ć1çi Ć1Ÿi Ć1ÿi Ć1ci Ć1ji Ć1di Ć1ti
Ć1ni Ć1ğo Ć1ço Ć1Ÿo Ć1ÿo Ć1co Ć1jo Ć1Ôo Ć1œo Ć1ho Ć1cho Ć1ko Ć1ro Ć1do Ć1to
Ć1no Ć1ğu Ć1çu Ć1Ÿu Ć1ÿu Ć1cu Ć1ju Ć1Ôu Ć1œu Ć1hu Ć1chu Ć1ku Ć1ru Ć1du Ć1tu
Ć1nu Ć1hy Ć1chy Ć1ky Ć1ry Ć1dy Ć1ty Ć1ny Ć1ğă Ć1çă Ć1Ÿă Ć1ÿă Ć1că Ć1jă Ć1hă
Ć1chă Ć1kă Ć1ră Ć1dă Ć1tă Ć1nă Ć1ğĆ Ć1çĆ Ć1ŸĆ Ć1ÿĆ Ć1cĆ Ć1jĆ Ć1hĆ Ć1chĆ Ć1kĆ
Ć1rĆ Ć1dĆ Ć1tĆ Ć1nĆ Ć1ğą Ć1çą Ć1Ÿą Ć1ÿą Ć1cą Ć1ją Ć1dą Ć1tą Ć1ną Ć1hì Ć1chì
Ć1kì Ć1rì Ć1dì Ć1tì Ć1nì Ć1dØ Ć1tØ Ć1nØ ą1ğa ą1ça ą1Ÿa ą1ÿa ą1ca ą1ja ą1Ôa
ą1œa ą1åa ą1ha ą1cha ą1ka ą1ra ą1da ą1ta ą1na ą1ğe ą1çe ą1Ÿe ą1ÿe ą1ce ą1je
ą1he ą1che ą1ke ą1re ą1de ą1te ą1ne ą1ği ą1çi ą1Ÿi ą1ÿi ą1ci ą1ji ą1di ą1ti
ą1ni ą1ğo ą1ço ą1Ÿo ą1ÿo ą1co ą1jo ą1Ôo ą1œo ą1åo ą1ho ą1cho ą1ko ą1ro ą1do
ą1to ą1no ą1ğu ą1çu ą1Ÿu ą1ÿu ą1cu ą1ju ą1Ôu ą1œu ą1åu ą1hu ą1chu ą1ku ą1ru
ą1du ą1tu ą1nu ą1hy ą1chy ą1ky ą1ry ą1dy ą1ty ą1ny ą1ğă ą1çă ą1Ÿă ą1ÿă ą1că
ą1jă ą1Ôă ą1œă ą1åă ą1hă ą1chă ą1kă ą1ră ą1dă ą1tă ą1nă ą1ğĆ ą1çĆ ą1ŸĆ ą1ÿĆ
ą1cĆ ą1jĆ ą1hĆ ą1chĆ ą1kĆ ą1rĆ ą1dĆ ą1tĆ ą1nĆ ą1ğą ą1çą ą1Ÿą ą1ÿą ą1cą ą1ją
ą1dą ą1tą ą1ną ą1hì ą1chì ą1kì ą1rì ą1dì ą1tì ą1nì ą1dØ ą1tØ ą1nØ ć1ğa ć1da
ć1do ć1du ć1ta ć1tu ć1to ć1na ć1nu ć1no ć1ğe ć1ÿe ć1je ć1ti ć1ni Ø1ğa Ø1ça
Ø1Ÿa Ø1ÿa Ø1ca Ø1ja Ø1ha Ø1cha Ø1ka Ø1ra Ø1da Ø1ta Ø1na Ø1ğe Ø1çe Ø1Ÿe Ø1ÿe
Ø1ce Ø1je Ø1he Ø1che Ø1ke Ø1re Ø1de Ø1te Ø1ne Ø1ği Ø1çi Ø1Ÿi Ø1ÿi Ø1ci Ø1ji
Ø1di Ø1ti Ø1ni Ø1ğo Ø1ço Ø1Ÿo Ø1ÿo Ø1co Ø1jo Ø1ho Ø1cho Ø1ko Ø1ro Ø1do Ø1to
Ø1no Ø1ğu Ø1çu Ø1Ÿu Ø1ÿu Ø1cu Ø1ju Ø1hu Ø1chu Ø1ku Ø1ru Ø1du Ø1tu Ø1nu Ø1hy
Ø1chy Ø1ky Ø1ry Ø1dy Ø1ty Ø1ny Ø1ğă Ø1çă Ø1Ÿă Ø1ÿă Ø1că Ø1jă Ø1hă Ø1chă Ø1kă
Ø1ră Ø1dă Ø1tă Ø1nă Ø1ğĆ Ø1çĆ Ø1ŸĆ Ø1ÿĆ Ø1cĆ Ø1jĆ Ø1chĆ Ø1kĆ Ø1rĆ Ø1dĆ Ø1tĆ
Ø1nĆ Ø1ğą Ø1çą Ø1Ÿą Ø1ÿą Ø1cą Ø1ją Ø1dą Ø1tą Ø1ną Ø1hì Ø1chì Ø1kì Ø1rì Ø1dì
Ø1tì Ø1nì Ø1dØ Ø1tØ Ø1nØ a1ga a1ge a1gi a1go a1gć a1gu e1ga e1ge e1gi e1go
e1gu e1gă i1ga i1ge i1gi i1go i1gu i1gă i1gć o1ga o1ge o1gi o1go o1gu u1ga
u1ge u1gi u1gy u1go u1gu a1xa a1xe a1xi a1xo a1xu a1xć e1xa e1xe e1xi e1xo
e1xu i1xa i1xe i1xi i1xo i1xu o1xa o1xe o1xi o1xo o1xu Ě1zu u1zĚ Ě1zo o1zĚ
Ø1zĚ Ě1zą ą1zĚ ć1zĚ Ě1zi i1zĚ Ě1ză ă1zĚ Ć1zĚ Ě1ze e1zĚ Ě1za a1zĚ ì1zĚ Ě1zĚ
Ě1zy y1zĚ Ě1åu u1åĚ Ě1åo o1åĚ Ě1åą ć1åĚ Ě1åi i1åĚ ă1åĚ Ć1åĚ e1åĚ Ě1åa a1åĚ
ì1åĚ Ě1vu u1vĚ Ě1vo o1vĚ Ě1vØ Ø1vĚ Ě1vą ą1vĚ Ě1vi i1vĚ ă1vĚ Ć1vĚ Ě1ve e1vĚ
Ě1va a1vĚ ì1vĚ Ě1vĚ Ě1vy y1vĚ Ě1œa Ě1tu u1tĚ Ě1to o1tĚ Ě1tØ Ø1tĚ Ě1tą ą1tĚ
ć1tĚ Ě1ti i1tĚ ă1tĚ Ć1tĚ Ě1te e1tĚ Ě1ta a1tĚ ì1tĚ Ě1tĚ Ě1ty y1tĚ Ě1su u1sĚ
Ě1so o1sĚ Ø1sĚ Ě1są ą1sĚ ć1sĚ Ě1si i1sĚ Ě1să ă1sĚ Ć1sĚ Ě1se e1sĚ Ě1sa a1sĚ
ì1sĚ Ě1sy y1sĚ Ě1ru u1rĚ Ě1ro o1rĚ Ø1rĚ ą1rĚ ć1rĚ i1rĚ Ě1ră ă1rĚ Ć1rĚ Ě1re
e1rĚ Ě1ra a1rĚ Ě1rì ì1rĚ Ě1rĚ Ě1ry y1rĚ u1pĚ Ě1po o1pĚ Ě1pØ Ø1pĚ Ě1pą ą1pĚ
i1pĚ Ć1pĚ Ě1pe e1pĚ a1pĚ ì1pĚ y1pĚ u1nĚ o1nĚ Ě1nØ Ø1nĚ Ě1ną ą1nĚ ć1nĚ Ě1ni
i1nĚ ă1nĚ Ć1nĚ Ě1ne e1nĚ Ě1na a1nĚ ì1nĚ Ě1nĚ Ě1ny y1nĚ u1mĚ o1mĚ Ě1mØ Ø1mĚ
ą1mĚ ć1mĚ i1mĚ ă1mĚ Ć1mĚ e1mĚ Ě1ma a1mĚ ì1mĚ Ě1mĚ Ě1my y1mĚ Ě1lu u1lĚ Ě1lo
o1lĚ Ø1lĚ Ě1lą ą1lĚ ć1lĚ Ě1li i1lĚ ă1lĚ Ć1lĚ Ě1le e1lĚ Ě1la a1lĚ Ě1lì ì1lĚ
Ě1lĚ Ě1ly y1lĚ u1kĚ Ě1ko o1kĚ Ø1kĚ ą1kĚ ć1kĚ i1kĚ ă1kĚ Ć1kĚ e1kĚ Ě1ka a1kĚ
ì1kĚ Ě1ky y1kĚ u1jĚ o1jĚ Ø1jĚ Ě1ją ą1jĚ ć1jĚ Ě1ji i1jĚ ă1jĚ Ć1jĚ Ě1je e1jĚ
Ě1ja a1jĚ ì1jĚ y1jĚ u1hĚ o1hĚ Ø1hĚ ą1hĚ i1hĚ Ě1hă ă1hĚ Ć1hĚ Ě1he e1hĚ Ě1ha
a1hĚ Ě1hĚ Ě1hy y1hĚ Ć1fĚ a1fĚ y1fĚ Ě1ğu u1ğĚ Ě1ğo o1ğĚ Ø1ğĚ Ě1ğą ą1ğĚ ć1ğĚ
Ě1ği i1ğĚ Ě1ğă ă1ğĚ Ć1ğĚ Ě1ğe e1ğĚ Ě1ğa a1ğĚ ì1ğĚ y1ğĚ Ě1du u1dĚ Ě1do o1dĚ
Ě1dØ Ø1dĚ ą1dĚ ć1dĚ Ě1di i1dĚ ă1dĚ Ć1dĚ e1dĚ Ě1da a1dĚ ì1dĚ Ě1dy y1dĚ u1cĚ
o1cĚ Ø1cĚ Ě1cą ą1cĚ i1cĚ ă1cĚ e1cĚ a1cĚ ì1cĚ y1cĚ u1bĚ o1bĚ Ě1bØ Ø1bĚ ą1bĚ
ć1bĚ i1bĚ ă1bĚ Ć1bĚ e1bĚ Ě1ba a1bĚ ì1bĚ Ě1by y1bĚ u1ŸĚ o1ŸĚ Ø1ŸĚ ą1ŸĚ Ě1Ÿi
i1ŸĚ ă1ŸĚ Ě1Ÿe e1ŸĚ a1ŸĚ ì1ŸĚ Ě1Ÿy y1ŸĚ u1ÔĚ o1ÔĚ ą1ÔĚ ă1ÔĚ Ć1ÔĚ e1ÔĚ a1ÔĚ
Ě1chu u1chĚ Ě1cho o1chĚ Ø1chĚ ą1chĚ i1chĚ ă1chĚ e1chĚ Ě1cha a1chĚ Ě1chì
ì1chĚ Ě1chĚ Ě1chy y1chĚ u1ÿĚ o1ÿĚ Ø1ÿĚ Ě1ÿą ą1ÿĚ Ě1ÿi i1ÿĚ ă1ÿĚ Ć1ÿĚ Ě1ÿe
e1ÿĚ a1ÿĚ ì1ÿĚ y1ÿĚ Ě1çu u1çĚ Ě1ço o1çĚ Ø1çĚ Ě1çą ą1çĚ Ě1çi i1çĚ ă1çĚ Ć1çĚ
Ě1çe e1çĚ Ě1ça a1çĚ ì1çĚ Ě1çĚ y1çĚ u1bu u1fu u1lu u1mu u1pu u1su u1vu u1zu
u1bo u1fo u1lo u1mo u1po u1so u1vo u1zo u1bØ u1mØ u1pØ u1vØ u1bą u1fą u1lą
u1mą u1pą u1są u1vą u1zą u1bi u1fi u1li u1mi u1pi u1si u1vi u1zi u1bă u1fă
u1lă u1mă u1pă u1să u1vă u1ză u1bĆ u1lĆ u1mĆ u1pĆ u1sĆ u1vĆ u1zĆ u1be u1fe
u1le u1me u1pe u1se u1ve u1ze u1ba u1fa u1la u1ma u1pa u1sa u1va u1za u1bì
u1lì u1mì u1pì u1sì u1vì u1zì u1by u1fy u1my u1py u1sy u1vy o1bu o1fu o1lu
o1mu o1pu o1su o1vu o1zu o1bo o1fo o1lo o1mo o1po o1so o1vo o1zo o1bØ o1mØ
o1pØ o1vØ o1bą o1fą o1lą o1mą o1pą o1są o1vą o1zą o1fć o1zć o1bi o1fi o1li
o1mi o1pi o1si o1vi o1zi o1bă o1fă o1lă o1mă o1pă o1să o1vă o1ză o1bĆ o1fĆ
o1lĆ o1mĆ o1pĆ o1sĆ o1vĆ o1zĆ o1be o1fe o1le o1me o1pe o1se o1ve o1ze o1ba
o1fa o1la o1ma o1pa o1sa o1va o1za o1bì o1lì o1mì o1pì o1sì o1vì o1zì o1by
o1ly o1my o1py o1sy o1vy o1zy č1lu č1su č1zu č1bo č1lo č1mo č1po č1vo č1bØ
č1mØ č1pØ č1vØ č1pą č1li č1pi č1si č1vi č1zi č1le č1se č1ze č1pa č1sa č1va
č1by č1ly č1my Ø1bu Ø1lu Ø1mu Ø1pu Ø1su Ø1vu Ø1zu Ø1bo Ø1fo Ø1lo Ø1mo Ø1po
Ø1so Ø1vo Ø1zo Ø1mØ Ø1vØ Ø1bą Ø1lą Ø1mą Ø1pą Ø1są Ø1vą Ø1zą Ø1li Ø1mi Ø1pi
Ø1si Ø1vi Ø1zi Ø1bă Ø1lă Ø1mă Ø1pă Ø1să Ø1vă Ø1ză Ø1lĆ Ø1mĆ Ø1pĆ Ø1sĆ Ø1vĆ
Ø1zĆ Ø1be Ø1le Ø1me Ø1pe Ø1se Ø1ve Ø1ze Ø1ba Ø1la Ø1ma Ø1pa Ø1sa Ø1va Ø1za
Ø1lì Ø1mì Ø1pì Ø1sì Ø1vì Ø1zì Ø1by Ø1ly Ø1my Ø1py Ø1sy Ø1vy Ø1zy ą1bu ą1fu
ą1lu ą1mu ą1pu ą1su ą1vu ą1zu ą1bo ą1fo ą1lo ą1mo ą1po ą1so ą1vo ą1zo ą1bØ
ą1mØ ą1vØ ą1bą ą1lą ą1pą ą1vą ą1zą ą1bi ą1li ą1mi ą1pi ą1si ą1vi ą1zi ą1bă
ą1lă ą1mă ą1pă ą1să ą1vă ą1ză ą1bĆ ą1lĆ ą1mĆ ą1pĆ ą1sĆ ą1vĆ ą1zĆ ą1be ą1le
ą1me ą1pe ą1se ą1ve ą1ze ą1ba ą1la ą1ma ą1pa ą1sa ą1va ą1za ą1lì ą1mì ą1sì
ą1vì ą1zì ą1by ą1fy ą1ly ą1my ą1py ą1sy ą1vy ą1zy ć1bu ć1lu ć1mu ć1pu ć1su
ć1vu ć1zu ć1lo ć1po ć1so ć1vo ć1zo ć1bØ ć1mØ ć1vØ ć1są ć1vą ć1zą ć1fi ć1zi
ć1lĆ ć1vĆ ć1zĆ ć1le ć1me ć1ve ć1ze ć1ba ć1fa ć1la ć1ma ć1pa ć1sa ć1va ć1za
ć1by ć1fy ć1ly ć1my ć1py ć1sy ć1vy ć1zy i1bu i1lu i1mu i1pu i1su i1vu i1zu
i1bo i1fo i1lo i1mo i1po i1so i1vo i1zo i1bØ i1mØ i1pØ i1vØ i1bą i1lą i1mą
i1pą i1są i1vą i1zą i1vć i1bi i1fi i1li i1mi i1pi i1si i1vi i1zi i1bă i1lă
i1mă i1pă i1să i1vă i1ză i1bĆ i1lĆ i1mĆ i1pĆ i1sĆ i1vĆ i1zĆ i1be i1fe i1le
i1me i1pe i1se i1ve i1ze i1ba i1fa i1la i1ma i1pa i1sa i1va i1za i1bì i1lì
i1mì i1pì i1sì i1vì i1zì i1by i1fy i1ly i1my i1py i1sy i1vy i1zy ă1bu ă1fu
ă1lu ă1mu ă1pu ă1su ă1vu ă1zu ă1bo ă1lo ă1mo ă1po ă1so ă1vo ă1zo ă1bØ ă1fØ
ă1mØ ă1pØ ă1vØ ă1bą ă1fą ă1lą ă1mą ă1pą ă1są ă1vą ă1zą ă1bi ă1fi ă1li ă1mi
ă1pi ă1si ă1vi ă1zi ă1bă ă1lă ă1mă ă1pă ă1să ă1vă ă1ză ă1bĆ ă1lĆ ă1mĆ ă1pĆ
ă1sĆ ă1vĆ ă1zĆ ă1be ă1fe ă1le ă1me ă1pe ă1se ă1ve ă1ze ă1ba ă1fa ă1la ă1ma
ă1pa ă1sa ă1va ă1za ă1lì ă1mì ă1pì ă1sì ă1vì ă1zì ă1by ă1fy ă1ly ă1my ă1py
ă1sy ă1vy ă1zy Ć1bu Ć1fu Ć1lu Ć1mu Ć1pu Ć1su Ć1vu Ć1zu Ć1bo Ć1lo Ć1mo Ć1po
Ć1so Ć1vo Ć1zo Ć1mØ Ć1pØ Ć1vØ Ć1fi Ć1mi Ć1pi Ć1si Ć1vi Ć1zi Ć1bă Ć1vă Ć1ză
Ć1lĆ Ć1fe Ć1le Ć1me Ć1pe Ć1se Ć1ve Ć1ze Ć1ba Ć1la Ć1ma Ć1pa Ć1sa Ć1va Ć1za
Ć1by Ć1ly Ć1my Ć1sy Ć1vy Ć1zy e1bu e1fu e1lu e1mu e1pu e1su e1vu e1zu e1bo
e1fo e1lo e1mo e1po e1so e1vo e1zo e1bØ e1mØ e1pØ e1vØ e1bą e1lą e1mą e1pą
e1są e1vą e1zą e1lć e1zć e1bi e1fi e1li e1mi e1pi e1si e1vi e1zi e1bă e1fă
e1lă e1mă e1pă e1să e1vă e1ză e1bĆ e1lĆ e1mĆ e1pĆ e1sĆ e1vĆ e1zĆ e1be e1fe
e1le e1me e1pe e1se e1ve e1ze e1ba e1fa e1la e1ma e1pa e1sa e1va e1za e1bì
e1lì e1mì e1pì e1sì e1vì e1zì e1by e1ly e1my e1py e1sy e1vy e1zy a1bu a1fu
a1lu a1mu a1pu a1su a1vu a1zu a1bo a1fo a1lo a1mo a1po a1so a1vo a1zo a1bØ
a1mØ a1pØ a1vØ a1bą a1fą a1lą a1mą a1pą a1są a1vą a1zą a1lć a1bi a1fi a1li
a1mi a1pi a1si a1vi a1zi a1bă a1fă a1lă a1mă a1pă a1să a1vă a1ză a1bĆ a1fĆ
a1lĆ a1mĆ a1pĆ a1sĆ a1vĆ a1zĆ a1be a1fe a1le a1me a1pe a1se a1ve a1ze a1ba
a1fa a1la a1ma a1pa a1sa a1va a1za a1bì a1lì a1mì a1pì a1sì a1vì a1zì a1by
a1fy a1ly a1my a1py a1sy a1vy a1zy ì1bu ì1fu ì1lu ì1mu ì1pu ì1su ì1vu ì1zu
ì1bo ì1lo ì1mo ì1po ì1so ì1vo ì1zo ì1bØ ì1mØ ì1pØ ì1vØ ì1lą ì1bi ì1li ì1mi
ì1pi ì1si ì1vi ì1zi ì1bă ì1lă ì1mă ì1pă ì1să ì1vă ì1ză ì1zĆ ì1be ì1le ì1me
ì1pe ì1se ì1ve ì1ze ì1ba ì1la ì1ma ì1pa ì1sa ì1va ì1za ì1by ì1ly ì1my ì1py
ì1sy ì1vy ì1zy y1bu y1fu y1lu y1mu y1pu y1su y1vu y1zu y1bo y1lo y1mo y1po
y1so y1vo y1zo y1bØ y1mØ y1pØ y1vØ y1bą y1lą y1mą y1pą y1są y1vą y1zą y1mć
y1bi y1fi y1li y1mi y1pi y1si y1vi y1zi y1bă y1fă y1lă y1mă y1pă y1să y1vă
y1ză y1fĆ y1lĆ y1mĆ y1pĆ y1sĆ y1vĆ y1zĆ y1be y1fe y1le y1me y1pe y1se y1ve
y1ze y1ba y1fa y1la y1ma y1pa y1sa y1va y1za y1lì y1mì y1pì y1sì y1vì y1zì
y1by y1ly y1my y1py y1sy y1vy y1zy v2r1h vr2hn vr2hl vr3hl. vr2hc v2r1ch
vr2chn vr2chl v2r1k vr2kn vr2kl vr3kl. v2r1d vr2dn vr2dl v2r1t vr2tn vr2tl
vr3tl. v2r1n v2r1ğ v2r1ç vr2çk vr2çn vr2çm vr2çt v2r1Ÿ vr2Ÿm vr2Ÿt v2r1c
v2r1b vr2bk v2r1s vr2st vr2s2tv v2r1z vr2zn vr2zl vr3zl. s2r1k sr2kn sr2kl
sr3kl. s2r1d sr2dn sr2dŸ s2r1n sr2nk sr2nŸ s2r1ç sr2çm sr2çt s2r1b sr2bs
s2r1p sr2pn sr2pk s2r1s sr2st s2rs2tk s2rs2tn t2r1h tr2hl tr3hl. tr2hn t2r1n
tr2nk tr2nŸ t2r1ğ tr2ğn t2r1Ÿ tr2Ÿk tr2Ÿm tr2Ÿt t2r1b t2r1m t2r1p tr2pn
tr2pm tr2pŸ t2r1s tr2sn tr2sl tr3sl. tr2sk t2r1v ch2r1t chr2tl chr3tl.
ch2r1Ÿ chr2Ÿm chr2Ÿt ch2r1s chr2st p2r1ch pr2chn pr2chl pr3chl. p2r1k pr2kn
p2r1d pr2dl pr3dl. p2r1t p2r1n p2r1ç pr2çk p2r1Ÿ p2r1c p2r1v pr2vn pr2vk
m2r1d mr2dl m2r1k mr2kl mr3kl. mr2kn m2r1t mr2tv mr2tk mr2tn m2r1ç mr2çœ
mr2çk m2r1m mr2ml m2r1s mr2sk m2r1v mr2vm mr2vt m2r1z mr2zk mr2zl mr3zl.
mr2zn Ÿ2r1t Ÿr2tk Ÿr2tn Ÿr2tl Ÿr3tl. k2r1t kr2tn kr2tl kr2tk k2r1n k2r1ç
kr2çk k2r1Ÿ kr2Ÿn kr2Ÿk kr2Ÿm kr2Ÿt k2r1b k2r1m kr2mn kr2mm kr2mt k2r1z
h2r1k hr2kl hr3kl. hr2kn h2r1d hr2dl hr2dn h2r1n hr2nc hr2nk hr2nŸ hr2åm
hr2åt h2r1Ÿ h2r1b hr2bk hr2b1l h2r1m h2r1s hr2st h2rs2tm h2r1z f2r1k fr2kl
fr2kn f2r1Ÿ fr2Ÿk fr2Ÿm fr2Ÿt d2r1n dr2nk dr2nŸ d2r1ğ dr2ğk dr2ğm dr2ğt
dr2ğg d2r1c dr2cl dr3cl. dr2cn d2r1b dr2bn dr2bl dr3bl. d2r1s dr2sn d2r1v
d2r1z dr2zn dr2zl c2r1Ÿ b2r1k br2kn br2kl b2r1d b2r1t br2tn br2tl br3tl.
b2r1n br2nk b2r1ğ br2ğÔ b2r1Ÿ br2Ÿk b2r1v b2r1z br2zl br2zk br2zd b2r1b
br2bl z2r1n zr2nk k2l1k v2l1h vl2hk vl2hŸ v2l1k v2l1n vl2nk v2l1Ÿ vl2Ÿk
v2l1c h2l1t hl2tn hl2tl hl3tl. p2l1ch p2l1k p2l1n p2l1ğ p2l1å p2l1s pl2st
pl2sœ p2l1z pl2zl pl2zn b2l1b bl2bn bl2bl bl3bl. bl2bc bl2bŸ m2l1s ml2sn
m2l1ğ ml2ğn 1ğl. 1çl. 1Ÿl. 1cl. 1hl. 1c2hl. 1dl. 1tl. 1bl. 1ml. 1pl. 1sl.
1vl. 1zl. 1cr. 1hr. 1c2hr. 1kr. 1dr. 1tr. 1br. 1fr. 1mr. 1pr. 1sr. 1vr. .ğ4
ğ1ç ğ1Ÿ ğ1c ğ1Ô ğ1k ğ1d ğ1t ğ1n ğ1b ğ1l ğ1m ğ1p ğ1v .ç4 ç1ç ç1Ÿ ç1c ç1œ ç1ch
ç1k ç1d ç1t ç1n ç1b ç1l ç1m ç1p ç1v .Ÿ4 Ÿ1Ÿ Ÿ1c Ÿ1œ Ÿ1å Ÿ1k Ÿ1t Ÿ1n Ÿ1b Ÿ1l
Ÿ1m Ÿ1p Ÿ1v .ÿ4 ÿ1Ÿ ÿ1c ÿ1k ÿ1d ÿ1t ÿ1n ÿ1b ÿ1l ÿ1m ÿ1v .c4 c1k c1t c1n c1l
c1m c1v .j4 j1ç j1Ÿ j1c j1k j1d j1t j1n j1b j1f j1l j1m j1p j1s j1v j1z .Ô4
Ô1c Ô1k Ô1t Ô1m .œ4 œ1c œ1h œ1ch œ1k œ1t œ1m œ1s œ1v .å4 å1c å1h å1ch å1k
å1d å1t å1m å1p å1z .h4 h1ç h1Ÿ h1c h1k h1d h1n h1l .ch4 4ch. ch1b ch1r ch1t
ch1n ch1l ch1m .k4 k1ç k1Ÿ k1ÿ k1c k1ch k1r k1t k1n k1b k1l k1m k1p k1s
k1vic .r4 r1ç r1Ÿ r1c r1h r1ch r1k r1d r1t r1n r1b r1l r1m r1p r1s r1v r1z
.d4 d1ğ d1ç d1Ÿ d1ÿ d1c d1œ d1å d1h d1ch d1k d1n d1b d1l d1m d1p d1r d1s d1v
.t4 t1ç t1Ÿ t1c t1ch t1k t1r t1n t1b t1f t1l t1m t1p t1v .n4 n1ğ n1ç n1Ÿ n1c
n1Ô n1h n1ch n1k n1r n1d n1t n1n n1b n1l n1p n1z .x4 x1c x1k x1b x1f x1l x1p
x1n x1h x1t .b4 b1ğ b1ç b1Ÿ b1ÿ b1c b1h b1ch b1k b1r b1n b1f b1l b1m b1s b1v
b1z .f4 f1l f1k f1s .l4 l1ğ l1ç l1Ÿ l1å l1c l1k l1d l1t l1n l1b l1m l1p l1s
l1v l1z .m4 m1ç m1Ÿ m1c m1ch m1k m1r m1d m1t m1n m1b m1l m1p m1s m1z .p4 p1Ÿ
p1ÿ p1c p1ch p1k p1r p1t p1n p1l .s4 s1ç s1Ÿ s1å s1c s1k s1r s1t s1n s1b s1l
s1m s1p .v4 v1ç v1Ÿ v1å v1c v1ch v1k v1r v1d v1t v1n v1b v1l v1m v1p v1s .z4
z1ç z1Ÿ z1c z1k z1d z1t z1b z1l z1m z1n z1p z1v .g4 g1n g1r g1m g1g d1g r1g
n1g j1g l1g f1g s1g v1g b2s1c b1s2k b1ç2t c2t2n c1t2v Ÿ1s2k Ÿ1ç2t d1s2k
d1ç2t f1g2h h2ÿ2m j1g2l j2Ô1m j1s2k j1ç2t j2s2m k2t1n k2t1r k3t2ri k2Ÿ1n
k2ÿ2t l2k2n l1s2k l1ç2t l2s2t l1t2r m2b1d m1b2r m2d2l m2k2l m2k2n m1p2l
m2p2t m1s2k m1ç2t m2s2t n1g2l. n2g1l n2k1c n2k1l n2k1r n2k1t n2s1f n1s2k
n1s2t n2t1g n2t1k n2t1n n2t1s n2t1v n2Ÿ1n n1ç2t p2t1k p2Ÿ1n p2r2s p1s2k
p1ç2t r2d1n r2k1r r2k1t r2m1n r2p1c r2p1Ÿ r1s2k r1s2p r2t1l r2t1n r2v1n
r2z1n r1ç2t s2h2l s2h2r s2ch2v s2k2l s2k2r s2k1v s2m2l s2m1n s2p2l s2p2r
s2t1k s2t2l s2t1m s2t1n s2t1r s2t2ÿ ç1s2k t2k2n t2ÿ1k t2ÿ1n t1s2k v1s2k
v1ç2t v2s2t v2z2d v2z2l v2z2n v2z2t v2ğ2d z2d2l z2d1n z2d2v z2k2l z2v2l
ğ1s2k ğ1ç2t Ÿ2t2v å1s2k å1ç2t ç2k2l oçk3l ç2t1m ç2t1n ç2t2v ç2œ1k .s2t2r
.be2z1 bez1b2 bez1h2 be3z2ov be3z2ink bez1k2 bez1m2 bez1p2 bez1s2 bez1t2
.be3z2e1 .bezec2 .bezej2 .bezel2 .bezes2 .bezest2 .bezez2 blaho1 blahos2
blahop2 boje1 bojes2 bojech2 celo1 celod2 celop2 celos2 celoz2 .Ÿtyÿ1
.ŸtyÿŸ2 .Ÿtyÿh2 .Ÿtyÿk2 .Ÿtyÿs2 .Ÿtyÿv2 .daleko1 .dalekoh2 .dalekoz2 .do1
.doŸ2 .doh2 .doj2 .dok2 .do2k3s .do2k3t .dom2 .doo1p2 .dop2 .dos2 .dot2
.doč1Ÿ2 .dov2 .doz2 .doğ2 dĚ1 dĚk2 dĚs2 dĚt2 dĚv2 dvoj1 dvou1 dvojŸ2 dvouŸ2
dvojk2 dvouk2 dvojst2r dvoust3r jedno1 jednoh2 jednos2 jednot2 jedno2t3k
jedno2t3l jedno2t3n jednoz2 kolem1 kolemj2 kolems2 .koso1 .kosoŸ2t2v kro2m1
.kro3m2Ø .lec1 .lec2h .leck2 .leda1k .leda2s1k2 .mezi1 .mezib2 .meziŸ2
.mezi2Ÿ3k .mezid2 .mezih2 .meziv2 .mimo1s2 .mimo1st2 mąsto1d2 mąsto1k2
mąsto1p2 .mnoho1 .mnohoh2 .mnohos2 .mnohoŸ2 .na1 .nab2 .nac2 .naŸ2 .nah2
.nach2 .naj2 .nak2 .nal2 .nam2 .nap2 .naÿ2 .nas2 .nast2 .naç2 .nat2 .nav2
.naz2 .nă1 .năb2 .năc2 .năd2 .nă2d3h .năh2 .năk2 .năm2 .năp2 .năr2 .năs2
.năst2 .năt2 .năv2 .na2d1 .na3d2Ø .na3d2a .na3d2ă .na3d2ą .na3d2i .na3d2u
.na3d2o .na4d3obl .na4d3obyŸ .na3d2o1smr .na3d2r .na4d3rot .nadch2 .nadh2
.nadk2 .nads2 .nadz2 .na3d2e1 .nadez2 .naded2 .nadej2 .nadeh2 .nadel2
.nadep2 .nadeç2 .ne1 .neb2 .nec2 .neŸ2 .ned2 .neg2 .ne2g3l .neh2 .ne2h1t
.nech2 .ne2ch. .ne2chœ3 .nek2 .ne2kro .ne2kt .nel2 .nem2 .nep2 .ner2 .ne2r2v
.neÿ2 .nes2 .nest2 .neç2 .net2 .nev2 .nez2 .nedo1 .nedob2ra .nedok2 .nedom2
.nedop2 .nedor2 .nedos2 .nedot2 .nedov2 .nedoz2 .neod1 .neodh2 .neodch2
.neodm2 .neod2ol .neodp2 .neods2 .neodst2 .neodç2 .neodt2 .neodz2 .neod2e1
.neodeb2 .neodeh2 .neodej2 .neodem2 .neodep2 .neodes2 .neodeç2 .neodez
.neod2Ø .nepo1 .nepob2 .nepoc2 .nepof2 .nepog2 .nepoh2 .nepoch2 .nepoj2
.nepok2 .nepom2 .nepo2mp .nepon2 .nepop2 .nepo2r1t .nepos2 .nepost2 .nepoç2
.nepo2ç3t .nepo3ç4œu .nepot2 .nepo7uŸ .nepo7u1k2 .nepov2 .nepoz2 .nepo2d1
.nepo3d2a .nepo3d2i .nepo3d2ob .nepo3d2u .nepo3d2ă .nepo3d2ą .nepodh2
.nepodk2 .nepo3d2ot .nepodp2 .nepo3d2răğd .nepo3d2rağ .nepods2 .nepodst2
.nepodv2 .nepo3d2e1 .nepodeb2 .nepodej2 .nepodem2 .nepodep2 .nepodes2
.nepodez2 .nepro1 .neprob2 .neproc2 .neproŸ2 .neprod2 .neprog2 .neproj2
.neproh2 .neproch2 .neprok2 .neprol2 .neprom2 .neprop2 .nepror2 .neproÿ2
.nepros2 .neprost2 .neproç2 .neprot2 .neprov2 .neproz2 .neproğ2 .nepÿe2d1
.nepÿe3d2a .nepÿe3d2ă .nepÿe3d2ra .nepÿedk2 .nepÿeds2 .nepÿedv2 .nepÿedz2
.nepÿedpo3k2 .nepÿe3d2e1 .nepÿedej2 .nepÿedes2 .nepÿedest2 .nepÿedeç2
.nepÿe2s1n .nepÿe1 .nepÿeb2 .nepÿec2 .nepÿeŸ2 .nepÿeh2 .nepÿej2 .nepÿek2
.nepÿel2 .nepÿem2 .nepÿep2 .nepÿer2 .nepÿeÿ2 .nepÿeç2 .nepÿet2 .nepÿev2
.nepÿez2 .nepÿi1 .nepÿib2 .nepÿic2 .nepÿiŸ2 .nepÿid2 .nepÿij2 .nepÿih2
.nepÿik2 .nepÿil2 .nepÿim2 .nepÿip2 .nepÿiÿ2 .nepÿis2 .nepÿist2 .nepÿiç2
.nepÿit2 .nepÿiv2 .nepÿiz2 .nero2z1 .nero3zum .nerozb2 .nerozŸ2 .nerozd2
.nerozh2 .nerozk2 .nerozp2 .nerozs2 .nerozst2 .nerozç2 .nerozt2 .nerozv2
.nerozz2 .nero3z2e1 .nerozeb2 .nerozeŸ2 .nerozed2 .nerozeh2 .nerozej2
.nerozek2 .nerozel2 .nerozem2 .nerozep2 .nerozer2 .nerozeÿ2 .nerozes2
.nerozest2 .nerozeç2 .nerozet2 .nerozev2 .nerozez2 .nesou1 .nesouŸ2 .nesoud2
.nesouh2 .nesouk2 .nesoum2 .nesous2 .nesoust2 .nesouç2 .nesouv2 .nesouz2
.neupo1 .neupos2 .neupot2 .nØ1k2 .ne2j1 .ne3j2du. .ne3j2deç. .ne3j2de.
.ne3j2deme. .ne3j2dete. .ne3j2dou. .ne3j2e .ne3j2a .ne3j2sem. .ne3j2si.
.ne3j2sme. .ne3j2ste. .ne3j2sou. .ne4j3akt .ne3j2i .ne3j2ą .nejd2 .nejf2
.nejh2 .nejk2 .nejm2 .nejp2 .nejs2 .nejst2 .nejt2 .nejv2 .nejz2 .nejne1
.nejnep2 .nejnes2 .nejnez2 .ni1k2 .o1 .oh2 .ok2 .ok3t .okolo1 .okoloj2
.okolos2 .om2 .op2 .op3ti .op3to .or2v .os2l .os2m .os3mo .os2n .os2p .os2tu
.os2ty .os2tì .os2t2r .os2v .oç2 .ot2r .ot3ru .ov2 .oz2 .oğ2 .o2b1d2 .o2b1j
.o2b1k2 .o2b1r .o3b2ran .o3b2răn .o2b1ÿ .o2b1s2 .o2b1ç2 .o2b1t2 .o2b1v2
.o2b1z2 .o2boj1s2 .o2boj1st2r .o2boj1ğ .o2boj1r .o2boj1n .obou1 .obous2
.obousm2 .ob2e1 .obe2c1 .obeh2 obej2 obel2 obep2 .obes2 .obest2 .obet2
.obez2 .od1 .odh2 .odch2 .odm2 .od2ol .odp2 .ods2 .odst2 .odç2 .odt2 .odz2
.od2e1 .odeb2 .odeh2 .odej2 .odem2 .odep2 .odes2 .odeç2 .odez .od2Ø .ote1v2
.pa1h2r .pa1k2l .pa1m2l .pa1p2r .pa1t2v .pa1z2v .pa4s3tv .pØti1 .pØtiŸ2
.pØtih2 .pØtik2 .pØtis2 .pØtiv2 .po1 .pob2 .poc2 .poŸ2 .pof2 .pog2 .poh2
.poch2 .po2int .poj2 .po2jÔ .pok2 .po2ls .po2lç .pom2 .po2mp .pon2 .pop2
.po2rn .po2r1t .por2tl .pos2 .post2 .poç2 .po2ç3t .po2ç3œ .po3ç4tØv .po3ç4œu
.pot2 .po7uŸ .po7u1k2 .po7uliŸ .pov2 .poz2 .po2z3dØ .po2d1 .po3d2a .po3d2i
.po3d2le. .po3d2ob .po4d3obl .po4d3oboj .po4d3oboŸ .po3d2rob .po3d2u .po3d2ă
.po3d2ą .podh2 .podk2 .podm2 .po3d2ol .po3d2ot .podp2 .po3d2răğd .po3d2raği
.pods2 .podst2 .podv2 .po3d2e1 .podeb2 .podej2 .podem2 .podep2 .podes2
.podez2 .polo1o1 .polo1p2 .polo1s2 .pra1 .pras2 .pra2s1k .pra2s1n .pra2cn
.pra2Ÿk .pra2h1n .pra2h1l .pra2kt .pra2çt .pra2vd .pro1 .prob2 .proc2 .proŸ2
.prod2 .prog2 .proj2 .proh2 .proch2 .prok2 .prol2 .prom2 .prop2 .pror2
.proÿ2 .pros2 .prost2 .proç2 .prot2 .pro2u .prov2 .proz2 .proğ2 proti1
protik2 protim2 protip2 protis2 protist2 prĚ1 prĚ2mk prĚh2 prĚk2 prĚp2 prĚr2
prĚs2 prĚt2 prĚv2 prĚz .pÿe1 .pÿeb2 .pÿec2 .pÿeŸ2 .pÿeh2 .pÿej2 .pÿek2
.pÿel2 .pÿem2 .pÿep2 .pÿer2 .pÿeÿ2 .pÿes2 .pÿe2s1Ÿ .pÿe2sto .pÿe2sn .pÿeç2
.pÿet2 .pÿev2 .pÿez2 .pÿe2d1 .pÿe3d2a .pÿe3d2ă .pÿe3d2ra .pÿe3d2răğd .pÿedk2
.pÿeds2 .pÿedv2 .pÿedz2 .pÿedpo3k2 .pÿe3d2e1 .pÿedej2 .pÿedes2 .pÿedest2
.pÿedeç2 .pÿedev2 .pÿe3s2nąd .pÿe2s1po .pÿe2s1pÿ .pÿe2s1len .pÿe2s1li .pÿi1
.pÿib2 .pÿic2 .pÿiŸ2 .pÿid2 .pÿij2 .pÿih2 .pÿik2 .pÿil2 .pÿim2 .pÿip2 .pÿiÿ2
.pÿis2 .pÿist2 .pÿiç2 .pÿit2 .pÿiv2 .pÿiz2 pÿą1 pÿą2m1n pÿąb2 pÿą2Ÿk pÿą2Ÿn
pÿąj2 pÿąk2 pÿąm2 pÿąp2 pÿąs2 pÿąst2 pÿąç2 pÿąt2 pÿąv2 pÿąz2 pĚ1j2d .ro2z1
.ro3zum .rozb2 .rozŸ2 .rozd2 .rozh2 .rozk2 .rozp2 .rozs2 .rozst2 .rozç2
.rozt2 .rozv2 .rozz2 .ro3z2e1 .rozeb2 .rozeŸ2 .rozed2 .rozeh2 .rozej2
.rozek2 .rozel2 .rozem2 .rozep2 .rozer2 .rozeÿ2 .rozes2 .rozest2 .rozeç2
.rozet2 .rozev2 .rozez2 .sd2 .sh2 .sk2 .sp2 .sv2 .se1 .se2dmi .se2dme .se2dl
.se2dn .seb2 .sebe1 .sebek2 .sec2 .se2Ÿ .se3Ÿ2t .se2gm .seg2 .seh2 .se2is1
.sej2 .sek2 .sel2 .sem2 .sep2 .se2p1t .sep2ta .serv2 .se2rvis .seÿ2 .ses2
.se2st se3st2roj .se3st2ÿel .seç2 .set2 .sev2 .se2x1 .sez2 .sou1 .souŸ2
.soud2 .sou2d3c .sou2d3n .souh2 .souj2 .souk2 .soum2 .soup2 .sous2 .soust2
.souç2 .souv2 .souz2 .spolu1 .spolub2 .spolup2 .nespolu1p2 .çesti1 .çestiŸ2
.çestih2 .çestik2 .çestis2 .çestiv2 .tro2j1č .tro2j1s2 .u1 .ub2 .uc2 .ud2
.uh2 .u2h3l .u3h4lad .u3h4ląd .u2h3r .u3h4rad .u3h4rab .u3h4ră .u4h5răm.
.u4h5răch. .uch2 .uj2 .uk2 .ul2h .ul2p .um2 .up2 .upo1 .upos2 .upot2 .ur2
.ur3b .ur3Ÿ .uÿ2 .us2 .ust2 .uç2 .ut2 .uv2 .uz2 .u2z3b .u2z3d .u2z3l .u2z3m
.uğ2 .u2ğ3çą č1 čc2 čŸ2 č2hl č3h2lav čj2 čk2 čp2 čs2 č2s3t čs4tn č3s4tav
č3s4t2r č3s4t2ÿ č4s5t3ÿi čç2 čt2 čv2 č2z1k .vk2 .vp2 .vs2 .vst2 .vç2 .vt2
.vz2 .ve1 .vec2 .ved2 .vØ1h2l .veh2 .ve2jc .ve2jŸ .ve2jp .ve2kt .vem2 .ve2n1
.ve2p3ÿ .vep2 .ve2r .ve3ri .ves2 .ve2s3l .ve2s3mą .ve2s3n .ve2s3t .ve3s4tav
.veç2 .ve2ç3k .vet2 .ve2tch .vev2 .ve2z3 .ve3zl. .ve2l1b2 .ve2l1k .ve2l1m
.ve2l1t2 .ve2l2t3l .vele1 .vele2bn .veleh2 .veles2 .velest2 .velez2 .vodo1
.vodot2 .vodoz2 .vçe1 .vçe2ch. .vy1 .vyb2 .vyc2 .vyŸ2 .vyd2 .vy2d1r
.vy3d2rol .vy3d2răp .vy3d2răs .vyh2 .vyj2 .vyk2 .vyl2 .vym2 .vyn2 .vyp2
.vyr2 .vyÿ2 .vys2 .vyst2 .vyç2 .vy2ç3ç .vyt2 .vyv2 .vyz2 .vì1 .vìŸ2 .vìh2
.vìk2 .vìm2 .vìp2 .vìr2v .vìs2 .vìst2 .vìç2 .vì2ç3k .vìt2 .vìv2 .vìz2 .vz1h2
.vz1p2 .vz1t2 .vze1 .vzed2 .vzep2 .vzes2 .vzeç2 .vzez2 .zd2 .zh2 .zch2 .zk2
.zl2 .zm2 .zp2 .zr2 .zt2 .zv2 .zne1 .znek2 .znem2 .znep2 .zne2rv .znes2
.zneç2 .znet2 .za1 .z3a2larm .z3akti .zab2 .zaŸ2 .zad2 .zah2 .zach2 .zaj2
.zak2 .zal2 .zam2 .zap2 .zar2 .zaÿ2 .zas2 .zast2 .zaç2 .zat2 .zav2 .zaz2
.zane1 .zaned2 .zanes2 .zaneç2 .uza1m2 .uza1r2 .uza1v2 .ză1 .zăb2 .zăc2
.zăd2 .zăh2 .zăch2 .zăj2 .zăk2 .nejză1k2 .zăm2 .zăp2 .zăs2 .zăst2 .zăç2
.zăt2 .zăv2 .zăz2 .z2e1 .z3e2f .zed2 .ze2d1n .zej2 .zem2 .ze2ms .ze2mn .zep2
.zes2 .zet2 .zev2 .zez2 zĚ1 .a1e2ro .a1d2re .a1g2no .a1ch2r .a1k2l .a1k2re
.an1es an3g2l .an2t1ar .anti1 .antik2 .antip2 an1t2ro1 .ar2ch1an .as2pek
.a1s2t .as3t2r asym3p2t .a1t2r .ausçt2r .auto1 .absçt2 .de1f2 .de1g2 .de1k2
.de1p2 .de2p3ta .de2z1 .di1o .di1p2 .dis3k2v dis3k2r dis3t2r .di1u .du1p2l
.epi1 .epig2 .ex1 .exk2 .exp2 .ext2 .ex2o ex2i1s .fyto1 .fytop2 .ide1 .ide2n
.in1 .inc2 .inf2 .ing2 .ink2 .ins2 .int2 .inter1 .interp2 .inters2 .kom1p2
.kon3g2 .kon3k2 .kon3s2 .konst2 .kon3t2 .kon3v2 .ko1o .hyper1 .hypert2
.hypo1 .hypos2 .kata1k2l .ko1i .ko1e .para1 .paraf2 .parag2 .re1 .ref2 .reg2
.re2j1 .rek2 .re2n2d .re2n2t .rep2 .re2pti .res2 .re2sp. .ret2 .sub1 .super1
.superp2 .supers2 .supra1 .sy1s2t .te1o1 .topo1g2 .tran2s1 .tran3s2pi
.tran3s2k2r .tran3s2c .tri1 .trip2 .tri2Ÿk .tri2st .zoo1 .zoop2 .zoos2 i1ent
ru1ov 3s2t2vą 3s2t2vo. 3s2t2va. 3s2t2vu. 3s2t2ve 3s2tev. 3s2tevn 3s2t2vĚm.
3s2t2vy. 3ğe. .m4ğe. 3hle. c4hle. 3li. 3ly. 3la. 3nout. 3nouti. i1ăn a1tb
e1tb i1tb 1t2va. 1t2vy. 1t2vØ. 1t2vu. 1t2vou. 1t2ev. 1t2văm. 1t2văch.
1t2vami. 3s2t2v a4s3t2v ă4st3v 3k2rac 3k2rat 3k2răt. 3k2răte. 3p2lex 1t2rof
1s2trof .a1v2çak .atmo1s2f .ce1d1r Ÿesko3s4l Ÿesko3b4r .e1gyp2t1 .elek1t
.elek3t1r .elek3t1ÿ elip1s elip1t eu1k2lei1d .i1h2ned kladko1s2t2roj
moÿe1p2lav .pe1t1r oka1mği s2t2ran z2d2rav zĚ1s2ta
  PATTERNS
end
