# 6.1 Changelog

## [6.1.6] - 2019-09-12

### Build and Packaging Improvements

- Update DotNet SDK and runtime framework version (Internal 9945)

## [6.1.5] - 2019-07-16

### Breaking changes

- Disable `Enter-PSHostProcess` cmdlet when system in lock down mode (Internal 8968)

### Build and Packaging Improvements

- Update DotNet SDK and runtime framework version (Internal 9087)
- Add automated RPM signing to release build (#10013)
- Update copyright symbol for NuGet packages (#9936)
- Bump `System.Net.Http.WinHttpHandler` from `4.5.3` to `4.5.4` (#9790)
- Integrate building NuGet package in the coordinated build (#8947) (#9708)
- Bump `Newtonsoft.Json` (#9662)

## [6.1.4] - 2019-05-21

### Build and Packaging Improvements

- Disable debugger in System Lock down mode (Internal 8430)
- Port changes for release automation to `6.1` (Internal 8402)
- Fix `MSI` `WIX` generation (#9013) (Internal 8385)
- Update `Microsoft.PowerShell.Archive` version (Internal 8380)
- Update package version in hosting test (Internal 8374)
- Bump to `dotnet` `2.1.11` release
- Remove update build table logic from release build (Internal 8364)
- Add `AccessToken` variable to jobs that perform signing (#9351)
- Support release branches based on the forward slash separator (#8903)

## [6.1.3] - 2019-02-14

### Engine Updates and Fixes

- Add security mitigation for 6.1.3 release (Internal 6561)

### Tools

- Change the feed URL to feed name due to changes in Azure DevOps (#8664)

### Tests

- Updating test gallery URL in PackageManagement tests (#7879)

### Build and Packaging Improvements

- Get PowerShellGet tests working (#7831)
- Start tracking release build information in an azure storage table (#8850)
- Remove `PDBs` from `fxdependent` package (#8006)
- Make every `csproj` files have its own folder (#8750)
- Update packaging script to build reference assembly targeting `netcoreapp2.1` and use actual `.csproj` files (#8729)
- Move Final artifacts from coordinated build to `finalResults` folder (#8806)
- Refactor Unified Release Build (#8804)
- Add compliance to Coordinated build (#8798)
- Switch to 1.11 of FPM to fix FPM install issue (#8797)
- Update the coordinated build with framework dependent package for dotnet SDK (#8773)
- Add Windows build to coordinated release build YAML (#8695)
- Build package build using Ubuntu 18.04 image (#8666)
- Adding `yml` for Windows Release builds (#8374)
- Update `SignType` in `signing.xml` (#8223)
- Update DotNet SDK and Runtime version (Internal 7004)
- Add `binskim` to coordinated build and increase timeout (#8834)

## [6.1.2] - 2019-01-15

### Tests

- Fix test failures (Internal 6310)

### Build and Packaging Improvements

- Moved the cleanup logic to `Restore-PSModuleToBuild` (Internal 6442)
- Update dependency versions (Internal 6421)
- Create unified release build for macOS and Linux packages (#8399)
- Build Alpine `tar.gz` package in release builds (Internal 6027)

### Documentation and Help Content

- Update version for README, Alpine docker file and hosting tests (Internal 6438)

## [6.1.1] - 2018-11-13

### Engine Updates and Fixes

- Fix issue with logging the null character in `ScriptBlock` logging (Internal 5607)
- Consolidation of all Windows PowerShell work ported to 6.1 (Internal 5233)

### General Cmdlet Updates and Fixes

- Use `ZipFile` and `ExtractToDirectory` APIs to extract zip file (Internal 5608)

## [6.0.5] - 2018-11-13

### Engine updates and fixes

- Fix issue with logging the null character in `ScriptBlock` logging (Internal 5605)

### General cmdlet updates and fixes

- Use `ZipFile` and `ExtractToDirectory` APIs to extract zip file (Internal 4802)

### Build and Packaging Improvements

- Update `SignType` in `signing.xml` (Internal 5721)
- Port changes to pull PowerShell Gallery modules from Modules `csproj` (Internal 5713)
- Port macOS Release build changes changes from GitHub (#8189, #8188, #8185)
- Fix script path for `PowerShellPackageVsts.ps1` (#8189)
- Workaround for accessing `AzDevOps` Artifacts (#8188)
- Bump various packages to latest patch version (Internal 5675)
- Update PowerShell SDK NuGet various metadata description (Internal 4527, 4510, 4505)

## [6.0.4] - 2018-08-10

### Build and Packaging Improvements

- Update the Archive module version (Internal 5671)
- Update to .NET Core `2.1.5` with SDK `2.1.403` (#7936) (Thanks @iSazonov!)
- Disable package major upgrade tests for release branch (Internal 5209)
- Bump versions for dependencies (Internal 5612)
- Port changes to allow `AzDevOps` NuGet feeds for macOS build (Internal 5716)
- Port macOS changes from GitHub (#8189, #8188, #8185)
- Add function to create a new `nuget.config` file (#8170)
- Updated `wxs` file to match published packages (Internal 5660)

### Tests

- Change API to match cmdlet which is more reliable in `AzDevOps` Pipelines Windows (#8003)
- Fix conflict with `Get-AdlStoreChildItem` from `az` module in tab completion tests (#8167)

## [6.1.0] - 2018-09-13

### Engine Updates and Fixes

- Enable indexing operations on `System.Tuple` and `System.ValueTuple` (#7633) (Thanks @SeeminglyScience!)
- Use non-virtual call to invoke 'family or assembly' methods on base class from PowerShell class (#7624) (Thanks @yurko7!)
- Handle operations with `ByRef-like` types gracefully in PowerShell (#7533)
- Make the `-settingfile` flag on `pwsh` work for `ScriptBlock` logging on windows (#7631)
- Ensure the `SSHClientSessionTransportManager` stream writer and reader fields are cleared after disposing (#7746)
- Add `LocationChangedAction` handler to support the Windows Compatibility module (#7552)

### General Cmdlet Updates and Fixes

- Fix `Set-Service -Status Stopped` to stop services with dependencies (#5525) (Thanks @zhenggu!)
- Add the `Duration` property to `HistoryInfo` (#5208) (Thanks @powercode!)
- Fix null reference in `ConvertFrom-Markdown` when the markdown content is empty (#7463)
- Fix file blocking issue with WebCmdlets (#7676) (Thanks @Claustn!)
- Fix performance issue in `WSMan` provider by using `Refresh()` to update the status rather than instantiating `ServiceController` (#7680)

### Code Cleanup

- Remove `Suspend-Job` and `Resume-Job` cmdlets from compilation on Unix platforms (#7650)
- Remove extra spaces in error messages in `Modules.resx` (#7662) (Thanks @sethvs!)
- Cleanup the platform runtime checks from `FileSystemProvider` (#7655) (Thanks @iSazonov!)
- Improve code style of `Send-MailMessage` cmdlet (#7723) (Thanks @ThreeFive-O!)

### Tools

- Add tools for PowerShell performance analysis (#7595) (Thanks @lzybkr!)
- Update code coverage module to download zip files based on job ID (#7653)

### Tests

- Update test which assumes all previews have the name preview in the version (#7625)
- Update Pester syntax in `Set-Location` test (#7615) (Thanks @iSazonov!)
- Add `ScriptBlock` logging test for Linux and macOS (#7599) (#7586)
- Add tests to report when package references are out of date (#7661)
- Fix `ModuleSpecification.Tests.ps1` (#7663) (Thanks @sethvs!)
- Updates Docker package tests (#7667)

### Build and Packaging Improvements

- Update to the latest package references, dotnet core SDK and framework (#7646) (Thanks @iSazonov!)
- Make the artifact upload only occur for non-PR builds (#7657)
- Change to not upload artifacts during pull request due to missing VSTS feature (#7588)
- Remove workaround on VSTS that is no longer needed (#7666)
- Update docker files to use MCR (#7656)
- Add symbolic links for `libssl` and `libcrypto` to Debian 9 build to make remoting work (#7609)
- Simplify the `StartupInfo` type used in Jumplist creation for faster `P/Invoke` (#7580) (Thanks @powercode!)
- Add VSTS CI for Windows (#7536)
- Update the version of `PowerShellGet` module to `1.6.7` (#7564)
- update the version of `PSReadLine` module to `2.0.0-beta3` (#7711)
- Make sure MSI build works for non-preview builds (#7752)
- Build and package framework dependent package (#7729)
- Change locale of `mdspell` to `en-US` (#7671)
- Add daily build on non-windows platforms (#7683)
- Fix Windows MSI to remove the `Uninstall` shortcut during an uninstall when more than one version is installed (#7701) (Thanks @bergmeister!)
- Fix docker image names for release build (#7726)

### Documentation and Help Content

- Update the version of .NET Core in docs (#7467) (Thanks @bergmeister!)
- Fix links in `README.md` (#7619) (Thanks @iSazonov!)
- Add VSTS CI build badges for master branch to `README.md` (#7691) (Thanks @bergmeister!)
- Add a paragraph in `CONTRIBUTING.md` about updating `files.wxs` (#7695) (Thanks @iSazonov!)

# [6.1.0-rc.1]- 2018-08-22

### Engine Updates and Fixes

- Fix to not duplicate the `System32` module path when starting `pwsh` from `pwsh` (#7414)
- Fix sequence point update for `switch/if/for/while/do-while/do-until` statements (#7305)
- Set the cursor to the place where a user hits tab key (#7299)
- Adding `LanguagePrimitives.TryCompare` to provide faster comparisons (#7438) (Thanks @powercode!)
- Improving performance of `LanguagePrimitives.TryConvertTo` (#7418) (Thanks @powercode!)
- Set `PowerShellVersion` to `3.0` for built-in modules to make Windows PowerShell work when starting from PowerShell Core (#7365)
- Avoid extra unnecessary allocations in `PSMemberInfoInternalCollection<T>` (#7435) (Thanks @iSazonov!)
- Enforce the `CompatiblePSEditions` check for modules from the legacy `System32` module path (#7183)
- Make sure that `SettingFile` argument is parsed before we load the settings (#7449)
- Default to `DefaultConsoleWidth` when DotNet says `WindowWidth` is 0 (#7465)

### General Cmdlet Updates and Fixes

- Fix parameter name in the `Get-Variable` cmdlet error message (#7384) (Thanks @sethvs!)
- Fix `Move-Item -Path` with wildcard character (#7397) (Thanks @kwkam!)
- Ignore `Newtonsoft.Json` metadata properties in `ConvertFrom-Json` (#7308) (Thanks @louistio!)
- Fix several issues in Markdown cmdlets (#7329)
- Add support for parsing Link Header with variable whitespace (#7322)
- Change parameter order in `Get-Help` and help in order to get first `-Full` and
  then `-Functionality` when using Get-Help `-Fu` followed by pressing tab and help `-Fu` followed by pressing tab (#7370) (Thanks @sethvs!)
- Add support for passing files and Markdown directly to `Show-Markdown` (#7354)
- Add `-SkipIndex` parameter to `Select-Object` (#7483) (Thanks @powercode!)
- Improve performance of `Import-CSV` up to 10 times (#7413) (Thanks @powercode!)
- Update `Enable-PSRemoting` so configuration name is unique for Preview releases (#7202)
- Improve performance on JSON to PSObject conversion (#7482) (Thanks @powercode!)
- Fix error message for `Add-Type` when `-AssemblyName` with wildcard is not found (#7444)
- Make native globbing on Unix return an absolute path when it is given an absolute path (#7106)
- Improve the performance of `Group-Object` (#7410) (Thanks @powercode!)
- Remove one unneeded verbose output from `ConvertTo-Json` (#7487) (Thanks @devblackops!)
- Enable `Get-ChildItem` to produce `Mode` property even if cannot determine if hard link (#7355)

### Code Cleanup

- Remove empty XML comment lines (#7401) (Thanks @iSazonov!)
- Cleanup Docker files (#7328)
- Correct the comment for `WSManReceiveDataResult.Unmarshal` (#7364)
- Format Utility `csproj` with updated `codeformatter` (#7263) (Thanks @iSazonov!)
- Bulk update format for files in Management folder with `codeformatter` (#7346) (Thanks @iSazonov!)
- Cleanup: replace `Utils.FileExists()/DirectoryExists()/ItemExists()` with DotNet methods (#7129) (Thanks @iSazonov!)
- Update `Utils.IsComObject` to use `Marshal.IsComObject` since CAS is no longer supported in DotNet Core (#7344)
- Fix some style issues in engine code (#7246) (Thanks @iSazonov!)

### Test

- Use `-BeExactly` and `-HaveCount` instead of `-Be` in `BugFix.Tests.ps1` (#7386) (Thanks @sethvs!)
- Use `-BeExactly` and `-HaveCount` instead of `-Be` in `TabCompletion.Tests.ps1` (#7380) (Thanks @sethvs!)
- Update CI scripts to support running tests for experimental features (#7419)
- Use `-HaveCount` instead of `-Be` in `Where-Object.Tests.ps1` (#7379) (Thanks @sethvs!)
- Fix ThreadJob tests so that they will run more reliably (#7360)
- Make logging tests for macOS pending (#7433)

### Build and Packaging Improvements

- Update Build script owners (#7321)
- Make `MUSL` NuGet package optional (#7316)
- Enable `pwsh-preview` to work on Windows (#7345)
- Fix SDK dependencies
- Add back the `powershell-core` NuGet source for hosting tests
- Fix typo in environment checker (#7547 & #7549)
- Only remove the revision if it is `0` from module version when restoring modules (#7538)
- Update `WCF` and `NJsonSchema` NuGet packages to latest released patch version (#7411) (Thanks @bergmeister!)
- Add Linux and macOS VSTS CI (#7490, #7527, #7535, #7515 & #7516)
- Updated ThreadJob to version `1.1.2` (#7522)
- Add xUnit project to `PowerShell.sln` and make it runnable from within VisualStudio (#7254) (Thanks @bergmeister!)
- Update NuGet packaging code for the new markdown assembly (#7431)
- Update version of modules shipped with PowerShell (#7531)
- Retry restore on failure (#7544 & #7550)
- Update `PowerShellGet` version
- Update NuGet package metadata (#7517)
- Update reference to use packages from `NuGet.org` (#7525)
- `Start-DevPowerShell`: add `-Configuration` and handle `-ArgumentList` more properly (#7300) (Thanks @jazzdelightsme!)
- Add preview icon to macOS launcher (#7448) (Thanks @thezim!)
- Add `Microsoft.PowerShell.MarkdownRender` to `signing.xml` (#7472)
- Fix building on RedHat Enterprise Linux (#7489)
- Build: Also search PATH for `rcedit`  (#7503) (Thanks @kwkam!)
- Save modules to un-versioned folder to enable servicing (#7518 & #7523)
- Fix macOS launcher app to allow release and preview versions (#7306) (Thanks @thezim!)

### Documentation and Help Content

- Fix docs comments in utility folder (#7192) (Thanks @iSazonov!)
- Fix a typo in `issue-management.md` (#7393) (Thanks @alexandair!)
- Fix casing of `GitHub` in `best-practice.md` (#7392) (Thanks @alexandair!)
- Fix typos in `docs/maintainers/README.md` (#7390) (Thanks @alexandair!)
- Add maintainer's best practice document and update maintainer list (#7311)
- Update Docker link to `PowerShell-Docker` (#7351) (Thanks @JoshuaCooper!)
- Add `Snapcraft` to spelling dictionary (#7318)
- Update `README.md` and `metadata.json` for release `v6.0.4` (#7497)
- Add `Former Repository Maintainers` section in `maintainers/README.md` (#7475)
- Update the `HelpUri` for `Get-ExperimentalFeature` (#7466)

# [6.1.0-preview.4]- 2018-07-19

### Breaking Changes

- Remove the `VisualBasic` support from Add-Type (#7284)
- Update PowerShell Direct to try `pwsh` then fallback to `powershell` (#7241)
- Make pwsh able to start in a directory with wildcards in the name (#7240)
- Update `Enable-PSRemoting` so configuration name is unique for Preview releases (#7202)
- Enforce the `CompatiblePSEditions` check for modules from the legacy `System32` module path (#7183)

### Engine Updates and Fixes

- Add support to experimental features (#7242)
- Fix error when using `Get-ChildItem c:` (#7033) (Thanks @sethvs!)
- Add location history for `Set-Location` to enable `cd -` scenario (issue #2188) (#5051) (Thanks @bergmeister!)
- Fix padding for right aligned column in table formatting (#7136)
- Fix a performance regression to the `-replace` operator after adding `ScriptBlock` support (#7135)
- Fix tab expansion for `Get-Process` on macOS (#7176)
- When using PSRP, if we receive text instead of XML, output it as error to help troubleshoot (#7168)
- Fix trimming of whitespace when table is wrapped (#7184)
- Modified the `Group-Object -AsHashTable` to use the base object of `PSObject` as the key for the `Hashtable` (#7123)
- Add back ADSI and WMI type accelerators (#7085)
- Add `CompatiblePSEditions` to PowerShell Core built-in modules (#7083)
- Make `Start-Process -ArgumentList` to accept `@()` or `$null` (#6597)
- Avoid calling native APIs to check for existence of FileSystem items (#6929) (Thanks @iSazonov!)
- Add copy environment variables from `ProcessStartInfo` to key/pair array used in creating SSH process (#7070)
- Add markdown rendering feature assemblies to the trusted assembly list (#7280)
- Don't fail if `SaferPolicy` API is not available on Windows 10 IoT or NanoServer (#7075)
- Fix conditions for transcription of `Write-Information` command. (#6917) (Thanks @hubuk!)
- Fix a parsing error when `break` and `continue` are used in a switch statement in a finally block (#7273)
- Fix prompt string to be platform agnostic and keep its trailing spaces (#7255)
- Make progress panel display correctly on UNIX when the user is typing. (#6972)
- Revert change to have `SetLocation()` treat wildcarded path as literal if it exists (#7101)
- Make `Select-Object`/`ForEach-Object`/`Where-Object` see dynamic properties (#6898) (Thanks @jazzdelightsme!)
- Fix class searcher to ignore hidden properties (#7188)
- Update remote prompt when using SSH to show username if different (#7191)
- Remove `SemanticVersion` from `knowntypes` list in serialization code to enable interop between Windows PowerShell and PowerShell Core (#7016)
- Add more information to job process failure error (#7251)
- Use .Net Core `File.Delete()` method to remove symbolic links and alternate streams (#7017) (Thanks @iSazonov!)
- Enable `UseShellExecute` on all platforms (#7198)
- Methods with return type `[object]` should return `null` for an empty result (#7138)

### General Cmdlet Updates and Fixes

- Add Markdown rendering cmdlets (#6926)
- `Send-MailMessage`: Update all parameters to support `ValueFromPipelineByPropertyName`. (#6911) (Thanks @sethvs!)
- Allow Basic Auth over HTTPS (#6890)
- Add `ThreadJob` module package and tests (#7169)
- Fix Windows Event Log channel isolation semantics (#6956) (Thanks @Robo210!)
- Make `Measure-Object` handle `scriptblock` properties. (#6934)
- Added functionality to retry in `Invoke-RestMethod` and `Invoke-WebRequest`. (#5760)
- Add type inference for `Select-Object` command (#7171) (Thanks @powercode!)
- Add `-AllStats` Switch parameter for `Measure-Object` cmdlet (#7220) (Thanks @kvprasoon!)

### Code Cleanup

- Remove unneeded code that forces ARM platforms to run PowerShell in CL mode (#7046)
- Bulk update code base to put `null` on the right-hand-side of a comparison expression (#6949) (Thanks @iSazonov!)
- Remove `MapSecurityZoneWithUrlmon` method and related code (#7103)
- Cleanup: remove the unneeded type `RemotingCommandUtils` (#7029)
- Remove unneeded "Windows-Full" modules (#7030)
- CodeFactor code style cleanup: replace literal empty strings with `string.Empty` (#6950) (Thanks @iSazonov!)
- Remove dummy comments in Utility module files (#7224) (Thanks @iSazonov!)
- Use empty array for Functions/Cmdlets/`AliasesToExport` to follow the best practice (#7108)
- Refactor module code related to `Get-Module -ListAvailable` (#7145)
- Refactor module specification logic (#7126)

### Test

- Add tests for module specifications (#7140)
- Update test string for better clarity in `Send-MailMessage.Tests.ps1` (#7195) (Thanks @sethvs!)
- Add test to verify filesystem provider isn't used when accessing root path in `PSDrive` (#7173)
- Fix to address `ThreadJob` tests reliability and speed (#7270)
- Add additional checks for test that passes inconsistently (#7051)

### Build and Packaging Improvements

- `install-powershell.sh` filter pre-releases (when available), `params` documentation (#6849) (Thanks @DarwinJS!)
- Fedora 28 was released, Fedora 26 and 25 went end of life. (#7079) (Thanks @adelton!)
- Disambiguate icon on Windows for preview builds/installers to use `Powershell_av_colors` and
  make daily build use `Powershell_avatar` instead (#7086) (Thanks @bergmeister!)
- Update to build for Alpine (#7139)
- Update build and packaging modules for Alpine (#7149)
- Add ability to install previews side-by-side with production releases (#7194) (Thanks @DarwinJS!)
- Enable NuGet Package Registration for compliance (#7053)
- Fix the preview macOS package link (#7061)
- Remove PSReadLine from then `PowerShell.sln` file (#7137)
- Fix the file `PowerShell.sln` that was corrupted by accident (#7288)
- Fix the encoding of `PowerShell.sln` to be `utf-8` (#7289)
- Make sure all references to the Package ID for previews packages is powershell-preview (#7066)
- Update `internals.md` with the latest build changes (#7058)
- When installing using MSI, set the working directory of the shortcut to the user home directory (#7072)
- Move to dotnet core 2.1.1 (#7161) (Thanks @iSazonov!)
- Update to latest package references, runtime framework, and SDK (#7272)
- AppVeyor build matrix: more efficient build job split to reduce total time by another 5 minutes (#7021) (Thanks @bergmeister!)
- Build: Fix the source location of `PowerShell.Core.Instrumentation.dll` (#7226)
- Add Andrew to the default reviewers of the build related files (#7019)
- Build: Fix a check to avoid null argument in case `vcvarsall.bat` is absent (#7218) (Thanks @PetSerAl!)
- Update `releaseTag` in `tools/metadata.json` (#7214)
- Update `Start-PSPester` to make it more user friendly (#7210) (Thanks @bergmeister!)
- Make `Start-PSBuild -Clean` not prompt due to locked files when Visual Studio is open by excluding `sqlite3` folder and use `-x` instead of `-X` option on `git clean` (#7235) (Thanks @bergmeister!)

### Documentation and Help Content

- Fix typos in `DOCSMIGRATION.md` (#7094) (Thanks @alexandair!)
- Add instructions to update Homebrew formula for the preview version PowerShell (#7067) (Thanks @vors!)
- Merge Third Party Notices and License updates (#7203)
- Update third party notices (#7042)
- Fix Markdown and spelling errors in `CHANGELOG.md` (#7064)
- Fix `New-TemporaryFile` online help URI (#6608)
- Fix links to PowerShell install docs (#7001) (Thanks @jokajak!)
- Update links that contain `en-us` culture (#7013) (Thanks @bergmeister!)
- Update docs for `ArgumentCompleterAttribute` class (#7227) (Thanks @Meir017!)
- Fix the name of a `Register-EngineEvent` test (#7222) (Thanks @alexjordan6!)
- Update README files for native code for migration (#7248)
- Comment about dynamic members for the `DotNetAdapter`, `GetMember` and `GetMembers` (#7087)
- Update the PowerShell executable location in building guide docs (#7205) (Thanks @louistio!)

# [6.1.0-preview.3]- 2018-06-07

### Breaking Changes

- Clean up uses of `CommandTypes.Workflow` and `WorkflowInfo` (#6708)
- Disallow Basic Auth over HTTP in PowerShell Remoting on Unix (#6787)
- Change packaging to differentiate only between major versions and previews (#6968)
- Enhance and refactor `Add-Type` cmdlet (#6141) (Thanks @iSazonov!)
    - A few error strings were removed and thus the corresponding fully qualified error ids are no longer in use.

### Engine Updates and Fixes

- Fix crash when terminal is reset (#6777)
- Fix a module-loading regression that caused an infinite loop (#6843)
- Further improve `PSMethod` to `Delegate` conversion (#6851)
- Block list `System.Windows.Forms` from loading to prevent a crash (#6822)
- Fix `Format-Table` where rows were being trimmed unnecessarily if there's only one row of headers (#6772)
- Fix `SetDate` function in `libpsl-native` to avoid corrupting memory during `P/Invoke` (#6881)
- Fix tab completions for hash table (#6839) (Thanks @iSazonov!)
- Fix parser to continue parsing key-value pairs after an `If-Statement` value in a `HashExpression` (#7002)
- Add error handling for `#requires` in an interactive session (#6469)

### General Cmdlet Updates and Fixes

- Improve parameter validation in `ExportCsvHelper` (#6816) (Thanks @sethvs!)
- Quote `Multipart` form-data field names (#6782) (Thanks @markekraus!)
- Fix Web Cmdlets for .NET Core 2.1 (#6806) (Thanks @markekraus!)
- Fix `Set-Location DriveName:` to restore current working directory in the drive (#6774) (Thanks @mcbobke!)
- Add the alias `-lp` for `-LiteralPath` parameters #6732 (#6770) (Thanks @kvprasoon!)
- Remove `more` function and move the `$env:PAGER` capability into the `help` function (#6059) (Thanks @iSazonov!)
- Add line break to the error message for `Set-ExecutionPolicy` (#6803) (Thanks @wesholton84!)

### Code Cleanup

- Clean up `#if SILVERLIGHT` (#6907) (Thanks @iSazonov!)
- Clean up the unused method `NonWindowsGetDomainName()` (#6948) (Thanks @iSazonov!)
- Clean up FileSystem provider (#6909) (Thanks @iSazonov!)

### Test

- Add tests for PowerShell hosting API to verify MyGet packages (#6737)
- Remove Web Cmdlets tests using proxy environment variables (#6808) (Thanks @iSazonov!)
- Enable Web Cmdlets tests for greater platform support (#6836) (Thanks @markekraus!)
- Convert `ShouldBeErrorId` to `Should -Throw -ErrorId` in PowerShell tests (#6682)
- Fix CIM cmdlets tests (#6755) (Thanks @sethvs!)
- Add tests for PowerShell classes inheriting from abstract .NET classes (#6752)
- Fix `Select-Object.Tests.ps1` which previously failed intermittently on Unix platforms. (#6747)
- Update docker package tests to fix error on OpenSUSE 42 (#6783)
- Fix test and infrastructure that block code coverage runs (#6790)
- Update Tests `Isfile` to correct response for `"/"` (#6754) (Thanks @Patochun!)
- Improve code coverage in `Export-Csv.Tests.ps1` (#6795) (Thanks @sethvs!)
- Change `-Quiet` parameter of `Invoke-Pester` to `-Show None` in `OpenCover.psm1` (#6798) (Thanks @sethvs!)
- Replace `Dbg.Assert` with `if () throw` in `CSVCommands.cs` (#6910) (Thanks @sethvs!)
- Fix xUnit test `GetTempFileName` (#6943) (Thanks @iSazonov!)

### Build and Packaging Improvements

- Add Windows Compatibility Pack 2.0.0 to PowerShell Core and adopt the official .NET Core 2.1 (#6958)
- Add Jumplist 'Run as Administrator' to Taskbar on Windows (#6913, #6985) (Thanks @bergmeister!)
- Use AppVeyor matrix for faster Pull Request builds (#6945) (Thanks @bergmeister!)
- Fix `build.psm1` to not add tool path to $PATH twice (#6834)
- Add script to create a container manifest (#6735)
- Fix docker manifest creation script to work with more complex tags and with repeated use (#6852)
- Add functions to merge Pester and xUnit logs (#6854)
- Enable generating full symbols for the Windows debug build (#6853)
- Add functions into `build.psm1` to save and restore `PSOptions` between different sessions. (#6884)
- Update signing XML based on new signing guidelines (#6893)
- Update the release docker files to allow specifying the version of to-be-installed PowerShell and the version of image to use (#6835)
- Updates docker files for Fedora 27 and Kali Linux (#6819)
- Change packaging to support Ubuntu 17.10 and 18.04 (#6769)
- Update `Get-ChangeLog` to make it more accurate (#6764)
- Fix comparison to see if sudo test is needed in `install-*.sh` (#6771) (Thanks @bjh7242!)
- Packaging: Add registry keys to support library folder background for explorer context menu (#6784) (Thanks @bergmeister!)
- Skip `dotnet-cli` initialization and stop caching the `dotnet` folder for Travis CI (#7007)
- Skip compiling the non-supported cmdlets on Unix in `System.Management.Automation.dll` to fix the crash in Unix debug build (#6939)
- Use `PSReadLine` 2.0.0-beta2 from PSGallery (#6998)
- Update `PSRP` Linux NuGet package version to 1.4.2-* (#6711)
- Add path cleanup utility `Reset-PWSHSystemPath.ps1` (#6892) (Thanks @DarwinJS!)
- Add logic to create signing XML for NuGet packages (#6921)
- Add and config the `Settings.StyleCop` file (#6930, #6986) (Thanks @iSazonov!)
- Fix the double curly bracket typo in a docker file (#6960) (Thanks @adelton!)
- Remove dependencies on `libcurl` and `libunwind` in packaging to match the .NET Core behavior (#6964) (Thanks @qmfrederik!)
- Make the docker build fail when the curl operation fails. (#6961) (Thanks @adelton!)

### Documentation and Help Content

- Update installation doc about Raspbian (#6859)
- Add code coverage report generation instructions (#6515)
- Migrate docs from PowerShell repository to Docs repository (#6899)
- Fix broken links due to migrating GitHub docs on Installation, Known Issues and Breaking Changes to `docs.microsoft.com` (#6981) (Thanks @bergmeister!)
- Update documentation on how to write tests verifying errors conditions (#6687)
- Fix preview download links in `README.md` (#6762)

# [6.1.0-preview.2]- 2018-04-27

### Breaking Changes

- Remove support for file to opt-out of telemetry, only support environment variable (#6601)
- Simplify the installation paths the MSI uses (#6442)

### Engine Updates and Fixes

- Fix running `pwsh` produced from `dotnet build` (#6549)
- Remove the `FullCLR-only` symbol-info related code from `EventManager.cs` (#6563)
- Improve `PSMethod-to-Delegate` conversion (#6570)
- Fix `PsUtils.GetManModule()` to avoid infinite loop when there was no main module (#6358)
- Fix error in windows environment provider when the environment variable has duplicates that differ only by case (#6489) (Thanks @mklement0!)
- Make sure that the width of the header is at least the size of the label (or property name) (#6487)
- Enable `[Environment]::OSVersion` to return current OS rather than compatible version (#6457)
- Change the `SaveError` method in Parser to use `nameof` for error ids (#6498)
- Fix error when `Format-Wide -AutoSize | Out-String` is called (#6491) (Thanks @stknohg!)
- Make `LanguagePrimitive.GetEnumerable` treat `DataTable` as Enumerable (#6511)
- Fix formatting of tables where headers span multiple rows (#6504)
- Improve performance of parsing `RegexOption` for `-split` by using `if` branches (#6605) (Thanks @iSazonov!)
- Enable specifying `sshd` subsystem to use via `-Subsystem` (#6603)
- Add some optimizations in formatting subsystem (#6678) (Thanks @iSazonov!)
- Throw better parsing error when statements should be put in named block (#6434)
- Use `Unregister-Event` to remove an event subscriber when removing `PSEdit` function (#6449)
- Make the `PSISERemoteSessionOpenFile` a support event (#6582)
- Add `-WorkingDirectory` parameter to `pwsh` (#6612)
- Support importing module paths that end in trailing directory separator (#6602)
- Formatting: Use cache for dash padding strings for tables (#6625) (Thanks @iSazonov!)
- Port Windows PowerShell AppLocker and DeviceGuard `UMCI` application white listing support (#6133)
- Reduce allocations in `TableWriter` (#6648) (Thanks @iSazonov!)

### General Cmdlet Updates and Fixes

- Add `-Resume` Feature to WebCmdlets (#6447) (Thanks @markekraus!)
- Support `user@host:port` syntax for `SSH` transport (#6558)
- Add ported `Test-Connection` cmdlet (#5328) (Thanks @iSazonov!)
- Added line break to Access-Denied error message (#6607)
- Some fixes in `Get-Date -UFormat` (#6542) (Thanks @iSazonov!)
- Added check for existence of Location HTTP header before using it (#6560) (Thanks @ffeldhaus!)
- Enable `Update-Help` to save help content in user scope by default (#6352)
- Update `Enable-PSRemoting` to create PowerShell.6 endpoint and version specific endpoint (#6519, #6630)
- Update error message that `Disconnect-PSSession` is only supported with `WSMan` (#6689)
- Make `Export-FormatData` print pretty XML output (#6691) (Thanks @iSazonov!)
- Add `-AsArray` parameter to `ConvertoTo-Json` command (#6438)
- Add `Test-Json` cmdlet (`NJsonSchema`) (#5229) (Thanks @iSazonov!)
- Correct a typo in comment for `Invoke-WebRequest` (#6700) (Thanks @gabrielsroka!)
- Re-order `UFormat` options in `Get-Date` (#6627) (Thanks @iSazonov!)
- Add the parameter `-Not` to `Where-Object` (#6464) (Thanks @SimonWahlin!)

### Code Cleanup

- Engine: Fix several code cleanup issues (#6552, #6609)
- Clean up workflow logic in the module loading component (#6523)
- Engine: Clean up unneeded `GetTypeInfo()` calls (#6613, #6636, #6633, #6635, #6634)

### Test

- Fix line ending in `DefaultCommands.Tests.ps1` from `CRLF` to `LF` (#6553)
- Use new Pester parameter syntax in tests (#6490, #6574, #6535, #6536, #6488, #6366, #6351, #6349, #6256, #6250) (Thanks @KevinMarquette, @sethvs, @bergmeister!)
- Fix `Copy.Item.Tests.ps1` (#6596) (Thanks @sethvs!)
- Fix typos or formatting in some test files (#6595, #6593, #6594, #6592, #6591) (Thanks @sethvs!)
- Add missing `Start-WebListener` to WebCmdlets tests (#6604) (Thanks @markekraus!)
- Update Dockerfile test to use Ubuntu 17.10 as the base image (#6503)
- Add PowerShell logging tests for macOS and Linux (#6025)
- Add tests for `Format-Table -Wrap` (#6670) (Thanks @iSazonov!)
- Reformat `Format-Table` tests (#6657) (Thanks @iSazonov!)
- Add new reliable tests for `Get-Date -UFormat` (#6614) (Thanks @iSazonov!)

### Build and Packaging Improvements

- Use C# latest language in `.csproj` files (#6559) (Thanks @iSazonov!)
- Update `installpsh-<distrofamily>.sh` installers to handle "preview" in version number (#6573) (Thanks @DarwinJS!)
- Enable `PowerShell.sln` to work in VisualStudio (#6546)
- Remove duplicate `Restore-PSPackage` (#6544)
- Use `-WorkingDirectory` parameter to handle context menu when path contains single quotes (#6660) (Thanks @bergmeister!)
- Make `-CI` not depend on `-PSModuleRestore` in `Start-PSBuild` (#6450)
- Restore for official Linux arm builds (#6455)
- Fix error about setting readonly variable in `install-powershell.sh` (#6617)
- Make release macOS build work better (#6619, #6610)
- MSI: add function to generate a `MSP` package (#6445)

### Documentation and Help Content

- Doc: Update Ubuntu source creation commands to use `curl -o` (#6510) (Thanks @M-D-M!)
- Update stale bot message (#6462) (Thanks @iSazonov!)
- Remove extraneous SSH and install docs from the 'demos' folder (#6628)

# [6.1.0-preview.1]- 2018-03-23

### Breaking Changes

- Throw terminating error in `New-TemporaryFile` and make it not rely on the presence of the `TEMP` environment variable (#6182) (Thanks @bergmeister!)
- Remove the unnecessary `AddTypeCommandBase` class from `Add-Type` (#5407) (Thanks @iSazonov!)
- Remove unsupported members from the enum `Language` in `Add-Type` (#5829) (Thanks @iSazonov!)
- Fix range operator to work better with character ranges (#5732) (Thanks @iSazonov!)

### Engine Updates and Fixes

- Fix `ValidateSet` with generator in a module (#5702)
- Update `SAL` annotation and fix warnings (#5617)
- Add `ForEach` and `Where` methods to `PSCustomobject` (#5756) (Thanks @iSazonov!)
- Add `Count` and `Length` properties to `PSCustomobject` (#5745) (Thanks @iSazonov!)
- Make minor fixes in compiler to properly handle void type expression (#5764)
- Logging: Fix the escaped characters when generating `.resx` file from PowerShell `ETW` manifest. (#5892)
- Remove `PSv2` only code from `Types_Ps1Xml.cs` and `HostUtilities.cs` (#5907) (Thanks @iSazonov!)
- Enable passing arrays to `pwsh -EncodedArguments` on debug builds. (#5836)
- Logging: Handle path that contains spaces in `RegisterManifest.ps1` (#5859) (Thanks @tandasat!)
- Add `-settingsfile` to `pwsh` to support loading a custom powershell config file. (#5920)
- Return better error for `pwsh -WindowStyle` on unsupported platforms. (#5975) (Thanks @thezim!)
- Enable conversions from `PSMethod` to `Delegate` (#5287) (Thanks @powercode!)
- Minor code clean-up changes in tab completion code (#5737) (Thanks @kwkam!)
- Add lambda support to `-replace` operator (#6029) (Thanks @IISResetMe!)
- Fix retrieval of environment variables on Windows in cases where variable names differ only by case. (#6320)
- Fix the `NullRefException` when using `-PipelineVariable` with `DynamicParam` block (#6433)
- Add `NullReference` checks to two code paths related to `PseudoParameterBinder` (#5738) (Thanks @kwkam!)
- Fix `PropertyOnlyAdapter` to allow calling base methods (#6394)
- Improve table view for `Certs` and `Signatures` by adding `EnhancedKeyUsageList` and `StatusMessage` (#6123)
- Fix the filtering of analytic events on Unix platforms. (#6086)
- Update copyright and license headers (#6134)
- Set pipeline thread stack size to 10MB (#6224) (Thanks @iSazonov!)

### General Cmdlet Updates and Fixes

- Fix the `NullRefException` in `Enter-PSHostProcess` (#5995)
- Merge and Sort `BasicHtmlWebResponseObject` and `ContentHelper` in Web Cmdlets (#5720) (Thanks @markekraus!)
- Encoding for `New-ModuleManifest` on all platforms should be `UTF-8 NoBOM` (#5923)
- Make `Set-Location` use path with wildcard characters as literal if it exists (#5839)
- Combine Web Cmdlets partial class files (#5612) (Thanks @markekraus!)
- Change `Microsoft.PowerShell.Commands.SetDateCommand.SystemTime` to `struct`. (#6006) (Thanks @stknohg!)
- Add Simplified `multipart/form-data` support to Web Cmdlets through `-Form` parameter (#5972) (Thanks @markekraus!)
- Make a relative redirect URI absolute when `Authorization` header present (#6325) (Thanks @markekraus!)
- Make relation-link handling in Web Cmdlets case-insensitive (#6338)
- Make `Get-ChildItem -LiteralPath` accept `Include` or `Exclude` filter (#5462)
- Stop `ConvertTo-Json` when `Ctrl+c` is hit (#6392)
- Make `Resolve-Path -Relative` return useful path when `$PWD` and `-Path` is on different drive (#5740) (Thanks @kwkam!)
- Correct the `%c`, `%l`, `%k`, `%s` and `%j` formats in `Get-Date -UFormat` (#4805) (Thanks @iSazonov!)
- Add standard deviation implementation on `Measure-Object` (#6238) (Thanks @CloudyDino!)
- Make `Get-ChildItem <PATH>/* -file` include `<Path>` as search directory (#5431)
- Enable setting `PSSession` Name when using `SSHTransport` and add `Transport` property (#5954)
- Add `Path` alias to `-FilePath` parameters and others for several commands (#5817) (Thanks @KevinMarquette!)
- Add the parameter `-Password` to `Get-PfxCertificate` (#6113) (Thanks @maybe-hello-world!)
- Don't add trailing spaces to last column when using `Format-Table` (#5568)
- Fix table alignment and padding. (#6230)
- Add `-SkipHeaderValidation` Support to `ContentType` on Web Cmdlets (#6018) (Thanks @markekraus!)
- Add common aliases for all `write-*` commands default message parameter (#5816) (Thanks @KevinMarquette!)
- Make `UTF-8` the default encoding for `application/json` (#6109) (Thanks @markekraus!)
- Enable `$env:PAGER` to work correctly if arguments are used (#6144)

### Test

- Convert Web Cmdlets test to `one-true-brace-style` formatting (#5716) (Thanks @markekraus!)
- Add a test for `IValidateSetValuesGenerator` in a module (#5830) (Thanks @iSazonov!)
- Fix function to test for docker OS due to change to use `linuxkit` for macOS (#5843)
- Replace `HttpListener` tests with `WebListener` (#5806, #5840, #5872) (Thanks @markekraus!)
- Stop `HttpListener` from running in Web Cmdlets tests (#5921) (Thanks @markekraus!)
- Fix `PSVersion` in `PSSessionConfiguration` tests (#5554) (Thanks @iSazonov!)
- Update test framework to support Pester v4 (#6064)
- Update tests to use Pester v4 Syntax. (#6294, #6257, #6306, #6304, #6298)
- Add negative tests for `Copy-Item` over remote sessions (#6231)
- Markdown test: Use strict in JavaScript (#6328)
- Add tests for `Get-Process` about the `-Module` and `-FileVersion` parameters (#6272)
- Add test for the `OsLocalDateTime` property of `Get-ComputerInfo`. (#6253)
- Change `Get-FileHash` tests to use raw bytes (#6430)
- Remove `runas.exe` from tests as we have tags to control this behavior (#6432)
- Refactor the `Get-Content` tests to use `-TestCases`. (#6082)
- Use `RequireAdminOnWindows` tag in `Set-Date` tests (#6034) (Thanks @stknohg!)
- Remove `-TimeOutSec` from non timeout related tests (#6055) (Thanks @markekraus!)
- Add verbosity and more accurate timeout implementation for `Start-WebListener` (#6013) (Thanks @markekraus!)
- Skip tests that use `ExecutionPolicy` cmdlets on Unix (#6021)
- Change Web Cmdlet tests to use `127.0.0.1` instead of `Localhost` (#6069) (Thanks @markekraus!)
- Fix `Start-PSPester` to include or exclude `RequireSudoOnUnix` tag smartly on Unix (#6241)
- Fix the terse output on Windows for test runs without admin privilege (#6252)
- Add `RequireSudoOnUnix` tag for `Get-Help` tests. (#6223)
- Add tests for `*-Item` Cmdlets in function provider (#6172)
- Support running tests in root privilege on Linux. (#6145)

### Build and Packaging Improvements

- Add option to add explorer shell context menu in Windows installer (#5774) (Thanks @bergmeister!)
- Make the explorer shell context menu registry entries platform specific to allow side by side of `x86` and `x64`. (#5824) (Thanks @bergmeister!)
- Fix start menu folder clash of shortcut when `x86` and `x64` are both installed by appending ` (x86)` for `x86` installation. (#5826) (Thanks @bergmeister!)
- Reduce image file sizes using lossless compression with `imgbot` (#5808) (Thanks @bergmeister!)
- Windows installer: Allow `Launch PowerShell` checkbox to be toggled using the space bar. (#5792) (Thanks @bergmeister!)
- Fix release packaging build (#6459)
- Fail `AppVeyor` Build if `MSI` does not build (#5755) (Thanks @bergmeister!)
- Cleanup temporarily created `WiX` files after compilation to be able to have a clean re-build (#5757) (Thanks @bergmeister!)
- Fix `install-powershell.ps1` for running during window setup (#5727)
- Start using `Travis-CI` cache (#6003)
- Fix build, packaging and installation scripts for `SLES` (#5918) (Thanks @tomconte!)
- Update recommended `WiX` toolset link to be generic to `WiX 3.x` but mention that latest version of 3.11 has to be taken (#5926) (Thanks @bergmeister!)
- Add service point manager call in `Install-PowerShell.ps1` to force `TLS1.2`. (#6310) (Thanks @DarqueWarrior!)
- Add `-Restore` when build `win-arm` and `win-arm64` (#6353)
- Make sure package verification failure fails the `AppVeyor` build (#6337)
- Specify the runtime when running `dotnet restore` in `Start-PSBuild` (#6345)
- Rename `log` and `logerror` to `Write-Log [$message] [-error]` (#6333)
- Make Linux packages use correct version scheme for preview releases (#6318)
- Add support for Debian in `installpsh-debian.sh` (#6314) (Thanks @Pawamoy!)
- MSI: Make preview builds to install Side by side with release builds (#6301)
- Add `TLS1.2` workaround for code coverage script (#6299)
- Cleanup after Powershell install for `CentOS` and `Fedora` Docker images (#6264) (Thanks @strawgate!)
- MSI: Update the environment variable PATH with proper value (#6441)
- MSI: Remove the version from the product name (#6415)
- Support non-GitHub commits in the change log generation script (#6389)
- Fix secret and JavaScript compliance issues (#6408)
- Remove `AppVeyor` specific cmdlet from `Start-NativeExecution` (#6263)
- Restore modules from the `NuGet` package cache by using `dotnet restore` (#6111)
- CI Build: Use `TRAVIS_PULL_REQUEST_SHA` to accurately get the commit message (#6024)
- Use `TLS1.2` on Windows during `Start-PSBootstrap` (#6235) (Thanks @CallmeJoeBob!)
- Use `TLS1.2` in `Start-PSBootStrap` without breaking `HTTPS` (#6236) (Thanks @markekraus!)
- Add options to enable `PSRemoting` and register Windows Event Logging Manifest to MSI installer (#5999) (Thanks @bergmeister!)

### Documentation and Help Content

- Separate macOS from Linux install instructions. (#5823) (Thanks @thezim!)
- Show usage (short) help if command line parameter is wrong (#5780) (Thanks @iSazonov!)
- Add the breaking changes doc for 6.0.0 release. (#5620) (Thanks @maertendMSFT!)
- Remove DockerFile for Fedora 25 and add DockerFile for Fedora 27 (#5984) (Thanks @seemethere!)
- Add a missing step to prepare the build environment on Mac. (#5901) (Thanks @zackJKnight!)
- Update `BREAKINGCHANGES.md` to include WebCmdlets breaking changes (#5852) (Thanks @markekraus!)
- Fix typos in `BREAKINGCHANGES.md` (#5913) (Thanks @brianbunke!)
- Update `macos.md` to use `brew cask upgrade` for upgrading powershell (#5875) (Thanks @timothywlewis!)
- Add verification step to macOS install docs (#5860) (Thanks @rpalo!)
- Fix links in macOS install docs (#5861) (Thanks @kanjibates!)
- Update docs with test guidelines with the `RequireSudoOnUnix` tag. (#6274)
- Add `Alpine` Linux support (#6367) (Thanks @kasper3!)
- Update to Governance doc to reflect current working model (#6323)
- Add guidance on adding copyright and license header to new source files (#6140)
- Fix the command to build type catalog in `internals.md` (#6084) (Thanks @ppadmavilasom!)
- Fix `Pull Request Process` dead link (#6066) (Thanks @IISResetMe!)
- Update processes to allow for coordinated vulnerability disclosure (#6042)
- Rework Windows Start menu folder name (#5891) (Thanks @Stanzilla!)
- Update `Raspbian` installation instructions to create `symlink` for `pwsh` (#6122)
- Fix various places that still refer to old versions of `pwsh` (#6179) (Thanks @bergmeister!)
- Correct a Linux installation typo (#6219) (Thanks @mababio!)
- Change synopsis of `install-powershell.ps1` to reflect that it works cross-platform (#5465) (Thanks @bergmeister!)

## [6.0.2] - 2018-03-15

### Engine updates and fixes

- Update PowerShell to use `2.0.6` dotnet core runtime and packages (#6403)
    - This change addresses this vulnerability: [Microsoft Security Advisory `CVE-2018-0875`: Hash Collision can cause Denial of Service](https://github.com/PowerShell/Announcements/issues/4)

### Build and Packaging Improvements

- Add Ubuntu build without `AppImage` (#6380)
- Add scripts to set and or update the release tag in `VSTS` (#6107)
- Fix `DSC` Configuration compilation (#6225)
- Fix errors in `Start-PSBootStrap` during release builds (#6159)
- Fix spelling failures in `CI` (#6191)
- Use PowerShell `windowsservercore` Docker image for release builds (#6226)
- Use `ADD` instead of `Invoke-WebRequest` in `nanoserver` Docker file (#6255)
- When doing daily/test build in a non-release branch use the branch name as the preview name (#6355)
- Add Environment Variable override of telemetry (#6063) (Thanks @diddledan!)
- Build: Remove two unneeded lines from `Invoke-AppveyorFinish` (#6344)
- MSI: Refactor `New-MsiPackage` into `packaging.psm1`
  and various fixes to enable patching
  (#5871, #6221, #6254, #6303, #6356, #6208, #6334, #6379, #6094, #6192)
- MSI: Use `HKLM` instead of `HKCU` registry keys since the current installation scope is per-machine. (#5915) (Thanks @bergmeister!)

## [6.0.1] - 2018-01-25

### Engine updates and fixes

- Update PowerShell to use `2.0.5` dotnet core runtime and packages. (#5903, #5961) (Thanks @iSazonov!)

### Build and Packaging Improvements

- Re-release of `v6.0.0` as `v6.0.1` due to issues upgrading from pre-release versions

### Test

- Update regular expression to validate `GitCommitId` in `$PSVersionTable` to not require a pre-release tag (#5893)

[6.1.6]: https://github.com/PowerShell/PowerShell/compare/v6.1.5...v6.1.6
[6.1.5]: https://github.com/PowerShell/PowerShell/compare/v6.1.4...v6.1.5
[6.1.4]: https://github.com/PowerShell/PowerShell/compare/v6.1.3...v6.1.4
[6.1.3]: https://github.com/PowerShell/PowerShell/compare/v6.1.2...v6.1.3
[6.1.2]: https://github.com/PowerShell/PowerShell/compare/v6.1.1...v6.1.2
[6.1.1]: https://github.com/PowerShell/PowerShell/compare/v6.1.0...v6.1.1
[6.1.0]: https://github.com/PowerShell/PowerShell/compare/v6.1.0-rc.1...v6.1.0
[6.1.0-rc.1]: https://github.com/PowerShell/PowerShell/compare/v6.1.0-preview.4...v6.1.0-rc.1
[6.1.0-preview.4]: https://github.com/PowerShell/PowerShell/compare/v6.1.0-preview.3...v6.1.0-preview.4
[6.1.0-preview.3]: https://github.com/PowerShell/PowerShell/compare/v6.1.0-preview.2...v6.1.0-preview.3
[6.1.0-preview.2]: https://github.com/PowerShell/PowerShell/compare/v6.1.0-preview.1...v6.1.0-preview.2
[6.1.0-preview.1]: https://github.com/PowerShell/PowerShell/compare/v6.0.2...v6.1.0-preview.1
[6.0.2]: https://github.com/PowerShell/PowerShell/compare/v6.0.1...v6.0.2
[6.0.1]: https://github.com/PowerShell/PowerShell/compare/v6.0.0...v6.0.1
