/*
 * Decompiled with CFR 0.152.
 */
package org.stathissideris.ditaa.text;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.stathissideris.ditaa.text.AbstractionGrid;
import org.stathissideris.ditaa.text.TextGrid;

public class CellSet
implements Iterable<TextGrid.Cell> {
    private static final boolean DEBUG = false;
    private static final boolean VERBOSE_DEBUG = false;
    public static final int TYPE_CLOSED = 0;
    public static final int TYPE_OPEN = 1;
    public static final int TYPE_MIXED = 2;
    public static final int TYPE_HAS_CLOSED_AREA = 3;
    public static final int TYPE_UNDETERMINED = 4;
    private static final Comparator<TextGrid.Cell> CELL_COMPARATOR = (o1, o2) -> {
        int yResult = Integer.compare(o1.y, o2.y);
        if (yResult == 0) {
            return Integer.compare(o1.x, o2.x);
        }
        return yResult;
    };
    Set<TextGrid.Cell> internalSet = new TreeSet<TextGrid.Cell>(CELL_COMPARATOR);
    private int type = 4;
    private boolean typeIsValid = false;

    public CellSet() {
    }

    public CellSet(CellSet other) {
        this.addAll(other);
    }

    @Override
    public Iterator<TextGrid.Cell> iterator() {
        return this.internalSet.iterator();
    }

    public void add(TextGrid.Cell cell) {
        this.internalSet.add(cell);
    }

    public void addAll(CellSet set) {
        for (TextGrid.Cell cell : set) {
            this.add(cell);
        }
    }

    public int size() {
        return this.internalSet.size();
    }

    public TextGrid.Cell getFirst() {
        return this.internalSet.iterator().next();
    }

    public void printAsGrid(PrintStream out) {
        TextGrid grid = new TextGrid(this.getMaxX() + 2, this.getMaxY() + 2);
        grid.fillCellsWith(this, '*');
        grid.printDebug(out);
    }

    public String getCellsAsString() {
        StringBuilder str = new StringBuilder();
        for (TextGrid.Cell cell : this) {
            if (str.length() > 0) {
                str.append("/");
            }
            str.append(cell);
        }
        return str.toString();
    }

    public String toString() {
        TextGrid grid = new TextGrid(this.getMaxX() + 2, this.getMaxY() + 2);
        grid.fillCellsWith(this, '*');
        return grid.getDebugString();
    }

    public static CellSet copyCellSet(CellSet set) {
        CellSet newSet = new CellSet();
        for (TextGrid.Cell cell : set) {
            TextGrid.Cell newCell = new TextGrid.Cell(cell);
            newSet.add(newCell);
        }
        return newSet;
    }

    public int getType(TextGrid grid) {
        if (this.typeIsValid) {
            return this.type;
        }
        this.typeIsValid = true;
        if (this.size() == 1) {
            this.type = 1;
            return 1;
        }
        int typeTrace = this.getTypeAccordingToTraceMethod(grid);
        if (typeTrace == 1) {
            this.type = 1;
            return 1;
        }
        if (typeTrace == 0) {
            this.type = 0;
            return 0;
        }
        if (typeTrace == 4) {
            int typeFill = this.getTypeAccordingToFillMethod(grid);
            if (typeFill == 3) {
                this.type = 2;
                return 2;
            }
            if (typeFill == 1) {
                this.type = 1;
                return 1;
            }
        }
        this.type = 4;
        return 4;
    }

    private int getTypeAccordingToTraceMethod(TextGrid grid) {
        TextGrid.Cell previous;
        CellSet nextCells;
        if (this.size() < 2) {
            return 1;
        }
        TextGrid workGrid = TextGrid.makeSameSizeAs(grid);
        grid.copyCellsTo(this, workGrid);
        TextGrid.Cell start = null;
        for (TextGrid.Cell cell : this) {
            if (!workGrid.isLinesEnd(cell)) continue;
            start = cell;
        }
        if (start == null) {
            start = this.getFirst();
        }
        if ((nextCells = workGrid.followCell(previous = start)).size() == 0) {
            return 1;
        }
        TextGrid.Cell cell = nextCells.getFirst();
        while (!cell.equals(start)) {
            nextCells = workGrid.followCell(cell, previous);
            if (nextCells.size() == 0) {
                return 1;
            }
            if (nextCells.size() == 1) {
                previous = cell;
                cell = nextCells.getFirst();
                continue;
            }
            if (nextCells.size() <= 1) continue;
            return 4;
        }
        return 0;
    }

    private int getTypeAccordingToFillMethod(TextGrid grid) {
        if (this.size() == 0) {
            return 1;
        }
        CellSet tempSet = CellSet.copyCellSet(this);
        tempSet.translate(-this.getMinX() + 1, -this.getMinY() + 1);
        TextGrid subGrid = grid.getSubGrid(this.getMinX() - 1, this.getMinY() - 1, this.getWidth() + 3, this.getHeight() + 3);
        AbstractionGrid abstraction = new AbstractionGrid(subGrid, tempSet);
        TextGrid temp = abstraction.getCopyOfInternalBuffer();
        int width = temp.getWidth();
        int height = temp.getHeight();
        TextGrid.Cell fillCell = null;
        block0: for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                TextGrid.Cell cCell = new TextGrid.Cell(x, y);
                if (!temp.isBlank(cCell)) continue;
                fillCell = cCell;
                continue block0;
            }
        }
        if (fillCell == null) {
            System.err.println("Unexpected error: fill method cannot fill anywhere");
            return 4;
        }
        temp.fillContinuousArea(fillCell, '*');
        if (temp.hasBlankCells()) {
            return 3;
        }
        return 1;
    }

    public void translate(int dx, int dy) {
        this.typeIsValid = false;
        TreeSet<TextGrid.Cell> newSet = new TreeSet<TextGrid.Cell>(CELL_COMPARATOR);
        for (TextGrid.Cell oldCell : this.internalSet) {
            newSet.add(new TextGrid.Cell(oldCell.x + dx, oldCell.y + dy));
        }
        this.internalSet = newSet;
    }

    public TextGrid.Cell find(TextGrid.Cell cell) {
        for (TextGrid.Cell cCell : this) {
            if (!cCell.equals(cell)) continue;
            return cCell;
        }
        return null;
    }

    public boolean contains(TextGrid.Cell cell) {
        return cell != null && this.internalSet.contains(cell);
    }

    public boolean hasCommonCells(CellSet otherSet) {
        for (TextGrid.Cell cell : this) {
            if (!otherSet.contains(cell)) continue;
            return true;
        }
        return false;
    }

    public CellSet getFilledEquivalent(TextGrid textGrid) {
        if (this.getType(textGrid) == 1) {
            return new CellSet(this);
        }
        TextGrid grid = new TextGrid(this.getMaxX() + 2, this.getMaxY() + 2);
        grid.fillCellsWith(this, '*');
        TextGrid.Cell cell = null;
        boolean finished = false;
        for (int y = 0; y < grid.getHeight() && !finished; ++y) {
            for (int x = 0; x < grid.getWidth() && !finished; ++x) {
                cell = new TextGrid.Cell(x, y);
                if (grid.isBlank(cell) || !grid.isBlank(cell.getEast()) || !grid.isBlank(cell.getWest())) continue;
                finished = true;
            }
        }
        if (cell != null) {
            if (grid.isOutOfBounds(cell = cell.getEast())) {
                return new CellSet(this);
            }
            grid.fillContinuousArea(cell, '*');
            return grid.getAllNonBlank();
        }
        System.err.println("Unexpected error, cannot find the filled equivalent of CellSet");
        return null;
    }

    public void subtractSet(CellSet set) {
        this.typeIsValid = false;
        for (TextGrid.Cell cell : set) {
            TextGrid.Cell thisCell = this.find(cell);
            if (thisCell == null) continue;
            this.remove(thisCell);
        }
    }

    public int getWidth() {
        return this.getMaxX() - this.getMinX();
    }

    public int getHeight() {
        return this.getMaxY() - this.getMinY();
    }

    public int getMaxX() {
        int result = 0;
        for (TextGrid.Cell cell : this) {
            if (cell.x <= result) continue;
            result = cell.x;
        }
        return result;
    }

    public int getMinX() {
        int result = Integer.MAX_VALUE;
        for (TextGrid.Cell cell : this) {
            if (cell.x >= result) continue;
            result = cell.x;
        }
        return result;
    }

    public int getMaxY() {
        int result = 0;
        for (TextGrid.Cell cell : this) {
            if (cell.y <= result) continue;
            result = cell.y;
        }
        return result;
    }

    public int getMinY() {
        int result = Integer.MAX_VALUE;
        for (TextGrid.Cell cell : this) {
            if (cell.y >= result) continue;
            result = cell.y;
        }
        return result;
    }

    public Object remove(TextGrid.Cell cell) {
        this.typeIsValid = false;
        if ((cell = this.find(cell)) != null) {
            return this.internalSet.remove(cell);
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CellSet cells = (CellSet)o;
        return this.internalSet != null ? this.internalSet.equals(cells.internalSet) : cells.internalSet == null;
    }

    public int hashCode() {
        return this.internalSet != null ? this.internalSet.hashCode() : 0;
    }

    public static ArrayList<CellSet> removeDuplicateSets(ArrayList<CellSet> list) {
        ArrayList<CellSet> uniqueSets = new ArrayList<CellSet>();
        for (CellSet set : list) {
            boolean isOriginal = true;
            for (CellSet uniqueSet : uniqueSets) {
                if (!set.equals(uniqueSet)) continue;
                isOriginal = false;
            }
            if (!isOriginal) continue;
            uniqueSets.add(set);
        }
        return uniqueSets;
    }

    public ArrayList<CellSet> breakIntoDistinctBoundaries(TextGrid grid) {
        AbstractionGrid temp = new AbstractionGrid(grid, this);
        ArrayList<CellSet> result = temp.getDistinctShapes();
        return result;
    }

    public ArrayList<CellSet> breakIntoDistinctBoundaries() {
        ArrayList<CellSet> result = new ArrayList<CellSet>();
        TextGrid boundaryGrid = new TextGrid(this.getMaxX() + 2, this.getMaxY() + 2);
        boundaryGrid.fillCellsWith(this, '*');
        for (TextGrid.Cell cell : this) {
            if (boundaryGrid.isBlank(cell.x, cell.y)) continue;
            CellSet boundarySet = boundaryGrid.fillContinuousArea(cell.x, cell.y, ' ');
            result.add(boundarySet);
        }
        return result;
    }

    public ArrayList<CellSet> breakTrulyMixedBoundaries(TextGrid grid) {
        ArrayList<CellSet> result = new ArrayList<CellSet>();
        CellSet visitedEnds = new CellSet();
        TextGrid workGrid = TextGrid.makeSameSizeAs(grid);
        grid.copyCellsTo(this, workGrid);
        for (TextGrid.Cell start : this) {
            if (!workGrid.isLinesEnd(start) || visitedEnds.contains(start)) continue;
            CellSet set = new CellSet();
            set.add(start);
            TextGrid.Cell previous = start;
            CellSet nextCells = workGrid.followCell(previous);
            if (nextCells.size() == 0) {
                throw new IllegalArgumentException("This shape is either open but multipart or has only one cell, and cannot be processed by this method");
            }
            TextGrid.Cell cell = nextCells.getFirst();
            set.add(cell);
            boolean finished = false;
            if (workGrid.isLinesEnd(cell)) {
                visitedEnds.add(cell);
                finished = true;
            }
            while (!finished) {
                nextCells = workGrid.followCell(cell, previous);
                if (nextCells.size() == 1) {
                    set.add(cell);
                    previous = cell;
                    cell = nextCells.getFirst();
                    if (!workGrid.isLinesEnd(cell)) continue;
                    visitedEnds.add(cell);
                    finished = true;
                    continue;
                }
                if (nextCells.size() <= 1) continue;
                finished = true;
            }
            result.add(set);
        }
        CellSet whatsLeft = new CellSet(this);
        for (CellSet set : result) {
            whatsLeft.subtractSet(set);
        }
        result.add(whatsLeft);
        return result;
    }

    public TextGrid makeIntoGrid() {
        TextGrid grid = new TextGrid(this.getMaxX() + 2, this.getMaxY() + 2);
        grid.fillCellsWith(this, '*');
        return grid;
    }

    public CellSet makeScaledOneThirdEquivalent() {
        TextGrid gridBig = this.makeIntoGrid();
        gridBig.fillCellsWith(this, '*');
        TextGrid gridSmall = new TextGrid((this.getMaxX() + 2) / 3, (this.getMaxY() + 2) / 3);
        for (int y = 0; y < gridBig.getHeight(); ++y) {
            for (int x = 0; x < gridBig.getWidth(); ++x) {
                TextGrid.Cell cell = new TextGrid.Cell(x, y);
                if (gridBig.isBlank(cell)) continue;
                gridSmall.set(x / 3, y / 3, '*');
            }
        }
        return gridSmall.getAllNonBlank();
    }
}

